/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.org.apache.kafka.common.requests;

import io.confluent.org.apache.kafka.common.protocol.ApiKeys;
import io.confluent.org.apache.kafka.common.protocol.CommonFields;
import io.confluent.org.apache.kafka.common.protocol.Errors;
import io.confluent.org.apache.kafka.common.protocol.types.Field;
import io.confluent.org.apache.kafka.common.protocol.types.Schema;
import io.confluent.org.apache.kafka.common.protocol.types.Struct;
import io.confluent.org.apache.kafka.common.protocol.types.Type;
import io.confluent.org.apache.kafka.common.requests.AbstractResponse;
import io.confluent.org.apache.kafka.common.security.auth.KafkaPrincipal;
import java.nio.ByteBuffer;
import java.util.Map;

public class CreateDelegationTokenResponse
extends AbstractResponse {
    private static final String OWNER_KEY_NAME = "owner";
    private static final String ISSUE_TIMESTAMP_KEY_NAME = "issue_timestamp";
    private static final String EXPIRY_TIMESTAMP_NAME = "expiry_timestamp";
    private static final String MAX_TIMESTAMP_NAME = "max_timestamp";
    private static final String TOKEN_ID_KEY_NAME = "token_id";
    private static final String HMAC_KEY_NAME = "hmac";
    private final Errors error;
    private final long issueTimestamp;
    private final long expiryTimestamp;
    private final long maxTimestamp;
    private final String tokenId;
    private final ByteBuffer hmac;
    private final int throttleTimeMs;
    private KafkaPrincipal owner;
    private static final Schema TOKEN_CREATE_RESPONSE_V0 = new Schema(CommonFields.ERROR_CODE, new Field("owner", new Schema(CommonFields.PRINCIPAL_TYPE, CommonFields.PRINCIPAL_NAME), "token owner."), new Field("issue_timestamp", Type.INT64, "timestamp (in msec) when this token was generated."), new Field("expiry_timestamp", Type.INT64, "timestamp (in msec) at which this token expires."), new Field("max_timestamp", Type.INT64, "max life time of this token."), new Field("token_id", Type.STRING, "UUID to ensure uniqueness."), new Field("hmac", Type.BYTES, "HMAC of the delegation token."), CommonFields.THROTTLE_TIME_MS);

    public CreateDelegationTokenResponse(int throttleTimeMs, Errors error, KafkaPrincipal owner, long issueTimestamp, long expiryTimestamp, long maxTimestamp, String tokenId, ByteBuffer hmac) {
        this.throttleTimeMs = throttleTimeMs;
        this.error = error;
        this.owner = owner;
        this.issueTimestamp = issueTimestamp;
        this.expiryTimestamp = expiryTimestamp;
        this.maxTimestamp = maxTimestamp;
        this.tokenId = tokenId;
        this.hmac = hmac;
    }

    public CreateDelegationTokenResponse(int throttleTimeMs, Errors error, KafkaPrincipal owner) {
        this(throttleTimeMs, error, owner, -1L, -1L, -1L, "", ByteBuffer.wrap(new byte[0]));
    }

    public CreateDelegationTokenResponse(Struct struct) {
        this.error = Errors.forCode(struct.get(CommonFields.ERROR_CODE));
        Struct ownerStruct = (Struct)struct.get(OWNER_KEY_NAME);
        String principalType = ownerStruct.get(CommonFields.PRINCIPAL_TYPE);
        String principalName = ownerStruct.get(CommonFields.PRINCIPAL_NAME);
        this.owner = new KafkaPrincipal(principalType, principalName);
        this.issueTimestamp = struct.getLong(ISSUE_TIMESTAMP_KEY_NAME);
        this.expiryTimestamp = struct.getLong(EXPIRY_TIMESTAMP_NAME);
        this.maxTimestamp = struct.getLong(MAX_TIMESTAMP_NAME);
        this.tokenId = struct.getString(TOKEN_ID_KEY_NAME);
        this.hmac = struct.getBytes(HMAC_KEY_NAME);
        this.throttleTimeMs = struct.getOrElse(CommonFields.THROTTLE_TIME_MS, 0);
    }

    public static CreateDelegationTokenResponse parse(ByteBuffer buffer, short version) {
        return new CreateDelegationTokenResponse(ApiKeys.CREATE_DELEGATION_TOKEN.responseSchema(version).read(buffer));
    }

    public static Schema[] schemaVersions() {
        return new Schema[]{TOKEN_CREATE_RESPONSE_V0};
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return this.errorCounts(this.error);
    }

    @Override
    protected Struct toStruct(short version) {
        Struct struct = new Struct(ApiKeys.CREATE_DELEGATION_TOKEN.responseSchema(version));
        struct.set(CommonFields.ERROR_CODE, this.error.code());
        Struct ownerStruct = struct.instance(OWNER_KEY_NAME);
        ownerStruct.set(CommonFields.PRINCIPAL_TYPE, this.owner.getPrincipalType());
        ownerStruct.set(CommonFields.PRINCIPAL_NAME, this.owner.getName());
        struct.set(OWNER_KEY_NAME, (Object)ownerStruct);
        struct.set(ISSUE_TIMESTAMP_KEY_NAME, (Object)this.issueTimestamp);
        struct.set(EXPIRY_TIMESTAMP_NAME, (Object)this.expiryTimestamp);
        struct.set(MAX_TIMESTAMP_NAME, (Object)this.maxTimestamp);
        struct.set(TOKEN_ID_KEY_NAME, (Object)this.tokenId);
        struct.set(HMAC_KEY_NAME, (Object)this.hmac);
        struct.setIfExists(CommonFields.THROTTLE_TIME_MS, (Object)this.throttleTimeMs);
        return struct;
    }

    public Errors error() {
        return this.error;
    }

    public KafkaPrincipal owner() {
        return this.owner;
    }

    public long issueTimestamp() {
        return this.issueTimestamp;
    }

    public long expiryTimestamp() {
        return this.expiryTimestamp;
    }

    public long maxTimestamp() {
        return this.maxTimestamp;
    }

    public String tokenId() {
        return this.tokenId;
    }

    public byte[] hmacBytes() {
        byte[] byteArray = new byte[this.hmac.remaining()];
        this.hmac.get(byteArray);
        return byteArray;
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public boolean hasError() {
        return this.error != Errors.NONE;
    }
}

