/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.org.apache.kafka.common.requests;

import io.confluent.org.apache.kafka.common.protocol.ApiKeys;
import io.confluent.org.apache.kafka.common.protocol.CommonFields;
import io.confluent.org.apache.kafka.common.protocol.Errors;
import io.confluent.org.apache.kafka.common.protocol.types.ArrayOf;
import io.confluent.org.apache.kafka.common.protocol.types.Field;
import io.confluent.org.apache.kafka.common.protocol.types.Schema;
import io.confluent.org.apache.kafka.common.protocol.types.Struct;
import io.confluent.org.apache.kafka.common.requests.AbstractResponse;
import io.confluent.org.apache.kafka.common.requests.ApiError;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateAclsResponse
extends AbstractResponse {
    private static final String CREATION_RESPONSES_KEY_NAME = "creation_responses";
    private static final Schema CREATE_ACLS_RESPONSE_V0 = new Schema(CommonFields.THROTTLE_TIME_MS, new Field("creation_responses", new ArrayOf(new Schema(CommonFields.ERROR_CODE, CommonFields.ERROR_MESSAGE))));
    private final int throttleTimeMs;
    private final List<AclCreationResponse> aclCreationResponses;

    public static Schema[] schemaVersions() {
        return new Schema[]{CREATE_ACLS_RESPONSE_V0};
    }

    public CreateAclsResponse(int throttleTimeMs, List<AclCreationResponse> aclCreationResponses) {
        this.throttleTimeMs = throttleTimeMs;
        this.aclCreationResponses = aclCreationResponses;
    }

    public CreateAclsResponse(Struct struct) {
        this.throttleTimeMs = struct.get(CommonFields.THROTTLE_TIME_MS);
        this.aclCreationResponses = new ArrayList<AclCreationResponse>();
        for (Object responseStructObj : struct.getArray(CREATION_RESPONSES_KEY_NAME)) {
            Struct responseStruct = (Struct)responseStructObj;
            ApiError error = new ApiError(responseStruct);
            this.aclCreationResponses.add(new AclCreationResponse(error));
        }
    }

    @Override
    protected Struct toStruct(short version) {
        Struct struct = new Struct(ApiKeys.CREATE_ACLS.responseSchema(version));
        struct.set(CommonFields.THROTTLE_TIME_MS, this.throttleTimeMs);
        ArrayList<Struct> responseStructs = new ArrayList<Struct>();
        for (AclCreationResponse response : this.aclCreationResponses) {
            Struct responseStruct = struct.instance(CREATION_RESPONSES_KEY_NAME);
            response.error.write(responseStruct);
            responseStructs.add(responseStruct);
        }
        struct.set(CREATION_RESPONSES_KEY_NAME, (Object)responseStructs.toArray());
        return struct;
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public List<AclCreationResponse> aclCreationResponses() {
        return this.aclCreationResponses;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> errorCounts = new HashMap<Errors, Integer>();
        for (AclCreationResponse response : this.aclCreationResponses) {
            this.updateErrorCounts(errorCounts, response.error.error());
        }
        return errorCounts;
    }

    public static CreateAclsResponse parse(ByteBuffer buffer, short version) {
        return new CreateAclsResponse(ApiKeys.CREATE_ACLS.responseSchema(version).read(buffer));
    }

    public static class AclCreationResponse {
        private final ApiError error;

        public AclCreationResponse(ApiError error) {
            this.error = error;
        }

        public ApiError error() {
            return this.error;
        }

        public String toString() {
            return "(" + this.error + ")";
        }
    }
}

