/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.org.apache.kafka.common.requests;

import io.confluent.org.apache.kafka.common.protocol.ApiKeys;
import io.confluent.org.apache.kafka.common.protocol.Errors;
import io.confluent.org.apache.kafka.common.protocol.types.Field;
import io.confluent.org.apache.kafka.common.protocol.types.Schema;
import io.confluent.org.apache.kafka.common.protocol.types.Struct;
import io.confluent.org.apache.kafka.common.protocol.types.Type;
import io.confluent.org.apache.kafka.common.requests.AbstractRequest;
import io.confluent.org.apache.kafka.common.requests.AbstractResponse;
import io.confluent.org.apache.kafka.common.requests.ControlledShutdownResponse;
import java.nio.ByteBuffer;
import java.util.Collections;

public class ControlledShutdownRequest
extends AbstractRequest {
    private static final String BROKER_ID_KEY_NAME = "broker_id";
    private static final Schema CONTROLLED_SHUTDOWN_REQUEST_V0;
    private static final Schema CONTROLLED_SHUTDOWN_REQUEST_V1;
    private final int brokerId;

    public static Schema[] schemaVersions() {
        return new Schema[]{CONTROLLED_SHUTDOWN_REQUEST_V0, CONTROLLED_SHUTDOWN_REQUEST_V1};
    }

    private ControlledShutdownRequest(int brokerId, short version) {
        super(version);
        this.brokerId = brokerId;
    }

    public ControlledShutdownRequest(Struct struct, short version) {
        super(version);
        this.brokerId = struct.getInt(BROKER_ID_KEY_NAME);
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        short versionId = this.version();
        switch (versionId) {
            case 0: 
            case 1: {
                return new ControlledShutdownResponse(Errors.forException(e), Collections.emptySet());
            }
        }
        throw new IllegalArgumentException(String.format("Version %d is not valid. Valid versions for %s are 0 to %d", versionId, this.getClass().getSimpleName(), ApiKeys.CONTROLLED_SHUTDOWN.latestVersion()));
    }

    public int brokerId() {
        return this.brokerId;
    }

    public static ControlledShutdownRequest parse(ByteBuffer buffer, short version) {
        return new ControlledShutdownRequest(ApiKeys.CONTROLLED_SHUTDOWN.parseRequest(version, buffer), version);
    }

    @Override
    protected Struct toStruct() {
        Struct struct = new Struct(ApiKeys.CONTROLLED_SHUTDOWN.requestSchema(this.version()));
        struct.set(BROKER_ID_KEY_NAME, (Object)this.brokerId);
        return struct;
    }

    static {
        CONTROLLED_SHUTDOWN_REQUEST_V1 = CONTROLLED_SHUTDOWN_REQUEST_V0 = new Schema(new Field(BROKER_ID_KEY_NAME, Type.INT32, "The id of the broker for which controlled shutdown has been requested."));
    }

    public static class Builder
    extends AbstractRequest.Builder<ControlledShutdownRequest> {
        private final int brokerId;

        public Builder(int brokerId, short desiredVersion) {
            super(ApiKeys.CONTROLLED_SHUTDOWN, desiredVersion);
            this.brokerId = brokerId;
        }

        @Override
        public ControlledShutdownRequest build(short version) {
            return new ControlledShutdownRequest(this.brokerId, version);
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            bld.append("(type=ControlledShutdownRequest").append(", brokerId=").append(this.brokerId).append(")");
            return bld.toString();
        }
    }
}

