/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.org.apache.kafka.common.requests;

import io.confluent.org.apache.kafka.common.protocol.ApiKeys;
import io.confluent.org.apache.kafka.common.protocol.Errors;
import io.confluent.org.apache.kafka.common.protocol.types.Field;
import io.confluent.org.apache.kafka.common.protocol.types.Schema;
import io.confluent.org.apache.kafka.common.protocol.types.Struct;
import io.confluent.org.apache.kafka.common.requests.AbstractRequest;
import io.confluent.org.apache.kafka.common.requests.ApiVersionsResponse;
import java.nio.ByteBuffer;
import java.util.Collections;

public class ApiVersionsRequest
extends AbstractRequest {
    private static final Schema API_VERSIONS_REQUEST_V0;
    private static final Schema API_VERSIONS_REQUEST_V1;
    private final Short unsupportedRequestVersion;

    public static Schema[] schemaVersions() {
        return new Schema[]{API_VERSIONS_REQUEST_V0, API_VERSIONS_REQUEST_V1};
    }

    public ApiVersionsRequest(short version) {
        this(version, null);
    }

    public ApiVersionsRequest(short version, Short unsupportedRequestVersion) {
        super(version);
        this.unsupportedRequestVersion = unsupportedRequestVersion;
    }

    public ApiVersionsRequest(Struct struct, short version) {
        this(version, null);
    }

    public boolean hasUnsupportedRequestVersion() {
        return this.unsupportedRequestVersion != null;
    }

    @Override
    protected Struct toStruct() {
        return new Struct(ApiKeys.API_VERSIONS.requestSchema(this.version()));
    }

    @Override
    public ApiVersionsResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        short version = this.version();
        switch (version) {
            case 0: {
                return new ApiVersionsResponse(Errors.forException(e), Collections.emptyList());
            }
            case 1: {
                return new ApiVersionsResponse(throttleTimeMs, Errors.forException(e), Collections.emptyList());
            }
        }
        throw new IllegalArgumentException(String.format("Version %d is not valid. Valid versions for %s are 0 to %d", version, this.getClass().getSimpleName(), ApiKeys.API_VERSIONS.latestVersion()));
    }

    public static ApiVersionsRequest parse(ByteBuffer buffer, short version) {
        return new ApiVersionsRequest(ApiKeys.API_VERSIONS.parseRequest(version, buffer), version);
    }

    static {
        API_VERSIONS_REQUEST_V1 = API_VERSIONS_REQUEST_V0 = new Schema(new Field[0]);
    }

    public static class Builder
    extends AbstractRequest.Builder<ApiVersionsRequest> {
        public Builder() {
            super(ApiKeys.API_VERSIONS);
        }

        public Builder(short version) {
            super(ApiKeys.API_VERSIONS, version);
        }

        @Override
        public ApiVersionsRequest build(short version) {
            return new ApiVersionsRequest(version);
        }

        public String toString() {
            return "(type=ApiVersionsRequest)";
        }
    }
}

