/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.org.apache.kafka.common.requests;

import io.confluent.org.apache.kafka.common.TopicPartition;
import io.confluent.org.apache.kafka.common.protocol.ApiKeys;
import io.confluent.org.apache.kafka.common.protocol.CommonFields;
import io.confluent.org.apache.kafka.common.protocol.Errors;
import io.confluent.org.apache.kafka.common.protocol.types.ArrayOf;
import io.confluent.org.apache.kafka.common.protocol.types.Field;
import io.confluent.org.apache.kafka.common.protocol.types.Schema;
import io.confluent.org.apache.kafka.common.protocol.types.Struct;
import io.confluent.org.apache.kafka.common.protocol.types.Type;
import io.confluent.org.apache.kafka.common.requests.AbstractRequest;
import io.confluent.org.apache.kafka.common.requests.AbstractResponse;
import io.confluent.org.apache.kafka.common.requests.AlterReplicaLogDirsResponse;
import io.confluent.org.apache.kafka.common.utils.CollectionUtils;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AlterReplicaLogDirsRequest
extends AbstractRequest {
    private static final String LOG_DIRS_KEY_NAME = "log_dirs";
    private static final String LOG_DIR_KEY_NAME = "log_dir";
    private static final String TOPICS_KEY_NAME = "topics";
    private static final String PARTITIONS_KEY_NAME = "partitions";
    private static final Schema ALTER_REPLICA_LOG_DIRS_REQUEST_V0 = new Schema(new Field("log_dirs", new ArrayOf(new Schema(new Field("log_dir", Type.STRING, "The absolute log directory path."), new Field("topics", new ArrayOf(new Schema(CommonFields.TOPIC_NAME, new Field("partitions", new ArrayOf(Type.INT32), "List of partition ids of the topic."))))))));
    private final Map<TopicPartition, String> partitionDirs;

    public static Schema[] schemaVersions() {
        return new Schema[]{ALTER_REPLICA_LOG_DIRS_REQUEST_V0};
    }

    public AlterReplicaLogDirsRequest(Struct struct, short version) {
        super(version);
        this.partitionDirs = new HashMap<TopicPartition, String>();
        for (Object logDirStructObj : struct.getArray(LOG_DIRS_KEY_NAME)) {
            Struct logDirStruct = (Struct)logDirStructObj;
            String logDir = logDirStruct.getString(LOG_DIR_KEY_NAME);
            for (Object topicStructObj : logDirStruct.getArray(TOPICS_KEY_NAME)) {
                Struct topicStruct = (Struct)topicStructObj;
                String topic = topicStruct.get(CommonFields.TOPIC_NAME);
                for (Object partitionObj : topicStruct.getArray(PARTITIONS_KEY_NAME)) {
                    int partition = (Integer)partitionObj;
                    this.partitionDirs.put(new TopicPartition(topic, partition), logDir);
                }
            }
        }
    }

    public AlterReplicaLogDirsRequest(Map<TopicPartition, String> partitionDirs, short version) {
        super(version);
        this.partitionDirs = partitionDirs;
    }

    @Override
    protected Struct toStruct() {
        HashMap dirPartitions = new HashMap();
        for (Map.Entry<TopicPartition, String> entry : this.partitionDirs.entrySet()) {
            if (!dirPartitions.containsKey(entry.getValue())) {
                dirPartitions.put(entry.getValue(), new ArrayList());
            }
            ((List)dirPartitions.get(entry.getValue())).add(entry.getKey());
        }
        Struct struct = new Struct(ApiKeys.ALTER_REPLICA_LOG_DIRS.requestSchema(this.version()));
        ArrayList<Struct> logDirStructArray = new ArrayList<Struct>();
        for (Map.Entry logDirEntry : dirPartitions.entrySet()) {
            Struct logDirStruct = struct.instance(LOG_DIRS_KEY_NAME);
            logDirStruct.set(LOG_DIR_KEY_NAME, logDirEntry.getKey());
            ArrayList<Struct> topicStructArray = new ArrayList<Struct>();
            for (Map.Entry<String, List<Integer>> topicEntry : CollectionUtils.groupDataByTopic((List)logDirEntry.getValue()).entrySet()) {
                Struct topicStruct = logDirStruct.instance(TOPICS_KEY_NAME);
                topicStruct.set(CommonFields.TOPIC_NAME, topicEntry.getKey());
                topicStruct.set(PARTITIONS_KEY_NAME, (Object)topicEntry.getValue().toArray());
                topicStructArray.add(topicStruct);
            }
            logDirStruct.set(TOPICS_KEY_NAME, (Object)topicStructArray.toArray());
            logDirStructArray.add(logDirStruct);
        }
        struct.set(LOG_DIRS_KEY_NAME, (Object)logDirStructArray.toArray());
        return struct;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        HashMap<TopicPartition, Errors> responseMap = new HashMap<TopicPartition, Errors>();
        for (Map.Entry<TopicPartition, String> entry : this.partitionDirs.entrySet()) {
            responseMap.put(entry.getKey(), Errors.forException(e));
        }
        short versionId = this.version();
        switch (versionId) {
            case 0: {
                return new AlterReplicaLogDirsResponse(throttleTimeMs, responseMap);
            }
        }
        throw new IllegalArgumentException(String.format("Version %d is not valid. Valid versions for %s are 0 to %d", versionId, this.getClass().getSimpleName(), ApiKeys.ALTER_REPLICA_LOG_DIRS.latestVersion()));
    }

    public Map<TopicPartition, String> partitionDirs() {
        return this.partitionDirs;
    }

    public static AlterReplicaLogDirsRequest parse(ByteBuffer buffer, short version) {
        return new AlterReplicaLogDirsRequest(ApiKeys.ALTER_REPLICA_LOG_DIRS.parseRequest(version, buffer), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<AlterReplicaLogDirsRequest> {
        private final Map<TopicPartition, String> partitionDirs;

        public Builder(Map<TopicPartition, String> partitionDirs) {
            super(ApiKeys.ALTER_REPLICA_LOG_DIRS);
            this.partitionDirs = partitionDirs;
        }

        @Override
        public AlterReplicaLogDirsRequest build(short version) {
            return new AlterReplicaLogDirsRequest(this.partitionDirs, version);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("(type=AlterReplicaLogDirsRequest").append(", partitionDirs=").append(this.partitionDirs).append(")");
            return builder.toString();
        }
    }
}

