/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.org.apache.kafka.common.protocol.types;

import io.confluent.org.apache.kafka.common.protocol.types.SchemaException;
import io.confluent.org.apache.kafka.common.protocol.types.Type;
import java.nio.ByteBuffer;

public class ArrayOf
extends Type {
    private final Type type;
    private final boolean nullable;

    public ArrayOf(Type type) {
        this(type, false);
    }

    public static ArrayOf nullable(Type type) {
        return new ArrayOf(type, true);
    }

    private ArrayOf(Type type, boolean nullable) {
        this.type = type;
        this.nullable = nullable;
    }

    @Override
    public boolean isNullable() {
        return this.nullable;
    }

    @Override
    public void write(ByteBuffer buffer, Object o) {
        if (o == null) {
            buffer.putInt(-1);
            return;
        }
        Object[] objs = (Object[])o;
        int size = objs.length;
        buffer.putInt(size);
        for (Object obj : objs) {
            this.type.write(buffer, obj);
        }
    }

    @Override
    public Object read(ByteBuffer buffer) {
        int size = buffer.getInt();
        if (size < 0 && this.isNullable()) {
            return null;
        }
        if (size < 0) {
            throw new SchemaException("Array size " + size + " cannot be negative");
        }
        if (size > buffer.remaining()) {
            throw new SchemaException("Error reading array of size " + size + ", only " + buffer.remaining() + " bytes available");
        }
        Object[] objs = new Object[size];
        for (int i = 0; i < size; ++i) {
            objs[i] = this.type.read(buffer);
        }
        return objs;
    }

    @Override
    public int sizeOf(Object o) {
        Object[] objs;
        int size = 4;
        if (o == null) {
            return size;
        }
        for (Object obj : objs = (Object[])o) {
            size += this.type.sizeOf(obj);
        }
        return size;
    }

    public Type type() {
        return this.type;
    }

    public String toString() {
        return "ARRAY(" + this.type + ")";
    }

    public Object[] validate(Object item) {
        try {
            Object[] array;
            if (this.isNullable() && item == null) {
                return null;
            }
            for (Object obj : array = (Object[])item) {
                this.type.validate(obj);
            }
            return array;
        }
        catch (ClassCastException e) {
            throw new SchemaException("Not an Object[].");
        }
    }
}

