/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.org.apache.kafka.common.protocol;

import io.confluent.org.apache.kafka.common.errors.ApiException;
import io.confluent.org.apache.kafka.common.errors.BrokerNotAvailableException;
import io.confluent.org.apache.kafka.common.errors.ClusterAuthorizationException;
import io.confluent.org.apache.kafka.common.errors.ConcurrentTransactionsException;
import io.confluent.org.apache.kafka.common.errors.ControllerMovedException;
import io.confluent.org.apache.kafka.common.errors.CoordinatorLoadInProgressException;
import io.confluent.org.apache.kafka.common.errors.CoordinatorNotAvailableException;
import io.confluent.org.apache.kafka.common.errors.CorruptRecordException;
import io.confluent.org.apache.kafka.common.errors.DelegationTokenAuthorizationException;
import io.confluent.org.apache.kafka.common.errors.DelegationTokenDisabledException;
import io.confluent.org.apache.kafka.common.errors.DelegationTokenExpiredException;
import io.confluent.org.apache.kafka.common.errors.DelegationTokenNotFoundException;
import io.confluent.org.apache.kafka.common.errors.DelegationTokenOwnerMismatchException;
import io.confluent.org.apache.kafka.common.errors.DuplicateSequenceException;
import io.confluent.org.apache.kafka.common.errors.FetchSessionIdNotFoundException;
import io.confluent.org.apache.kafka.common.errors.GroupAuthorizationException;
import io.confluent.org.apache.kafka.common.errors.GroupIdNotFoundException;
import io.confluent.org.apache.kafka.common.errors.GroupNotEmptyException;
import io.confluent.org.apache.kafka.common.errors.IllegalGenerationException;
import io.confluent.org.apache.kafka.common.errors.IllegalSaslStateException;
import io.confluent.org.apache.kafka.common.errors.InconsistentGroupProtocolException;
import io.confluent.org.apache.kafka.common.errors.InvalidCommitOffsetSizeException;
import io.confluent.org.apache.kafka.common.errors.InvalidConfigurationException;
import io.confluent.org.apache.kafka.common.errors.InvalidFetchSessionEpochException;
import io.confluent.org.apache.kafka.common.errors.InvalidFetchSizeException;
import io.confluent.org.apache.kafka.common.errors.InvalidGroupIdException;
import io.confluent.org.apache.kafka.common.errors.InvalidPartitionsException;
import io.confluent.org.apache.kafka.common.errors.InvalidPidMappingException;
import io.confluent.org.apache.kafka.common.errors.InvalidPrincipalTypeException;
import io.confluent.org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import io.confluent.org.apache.kafka.common.errors.InvalidReplicationFactorException;
import io.confluent.org.apache.kafka.common.errors.InvalidRequestException;
import io.confluent.org.apache.kafka.common.errors.InvalidRequiredAcksException;
import io.confluent.org.apache.kafka.common.errors.InvalidSessionTimeoutException;
import io.confluent.org.apache.kafka.common.errors.InvalidTimestampException;
import io.confluent.org.apache.kafka.common.errors.InvalidTopicException;
import io.confluent.org.apache.kafka.common.errors.InvalidTxnStateException;
import io.confluent.org.apache.kafka.common.errors.InvalidTxnTimeoutException;
import io.confluent.org.apache.kafka.common.errors.KafkaStorageException;
import io.confluent.org.apache.kafka.common.errors.LeaderNotAvailableException;
import io.confluent.org.apache.kafka.common.errors.LogDirNotFoundException;
import io.confluent.org.apache.kafka.common.errors.NetworkException;
import io.confluent.org.apache.kafka.common.errors.NotControllerException;
import io.confluent.org.apache.kafka.common.errors.NotCoordinatorException;
import io.confluent.org.apache.kafka.common.errors.NotEnoughReplicasAfterAppendException;
import io.confluent.org.apache.kafka.common.errors.NotEnoughReplicasException;
import io.confluent.org.apache.kafka.common.errors.NotLeaderForPartitionException;
import io.confluent.org.apache.kafka.common.errors.OffsetMetadataTooLarge;
import io.confluent.org.apache.kafka.common.errors.OffsetOutOfRangeException;
import io.confluent.org.apache.kafka.common.errors.OperationNotAttemptedException;
import io.confluent.org.apache.kafka.common.errors.OutOfOrderSequenceException;
import io.confluent.org.apache.kafka.common.errors.PolicyViolationException;
import io.confluent.org.apache.kafka.common.errors.ProducerFencedException;
import io.confluent.org.apache.kafka.common.errors.ReassignmentInProgressException;
import io.confluent.org.apache.kafka.common.errors.RebalanceInProgressException;
import io.confluent.org.apache.kafka.common.errors.RecordBatchTooLargeException;
import io.confluent.org.apache.kafka.common.errors.RecordTooLargeException;
import io.confluent.org.apache.kafka.common.errors.ReplicaNotAvailableException;
import io.confluent.org.apache.kafka.common.errors.RetriableException;
import io.confluent.org.apache.kafka.common.errors.SaslAuthenticationException;
import io.confluent.org.apache.kafka.common.errors.SecurityDisabledException;
import io.confluent.org.apache.kafka.common.errors.TimeoutException;
import io.confluent.org.apache.kafka.common.errors.TopicAuthorizationException;
import io.confluent.org.apache.kafka.common.errors.TopicExistsException;
import io.confluent.org.apache.kafka.common.errors.TransactionCoordinatorFencedException;
import io.confluent.org.apache.kafka.common.errors.TransactionalIdAuthorizationException;
import io.confluent.org.apache.kafka.common.errors.UnknownMemberIdException;
import io.confluent.org.apache.kafka.common.errors.UnknownProducerIdException;
import io.confluent.org.apache.kafka.common.errors.UnknownServerException;
import io.confluent.org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import io.confluent.org.apache.kafka.common.errors.UnsupportedByAuthenticationException;
import io.confluent.org.apache.kafka.common.errors.UnsupportedForMessageFormatException;
import io.confluent.org.apache.kafka.common.errors.UnsupportedSaslMechanismException;
import io.confluent.org.apache.kafka.common.errors.UnsupportedVersionException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum Errors {
    UNKNOWN_SERVER_ERROR(-1, "The server experienced an unexpected error when processing the request", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message) {
            return new UnknownServerException(message);
        }
    }),
    NONE(0, null, new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message) {
            return null;
        }
    }),
    OFFSET_OUT_OF_RANGE(1, "The requested offset is not within the range of offsets maintained by the server.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message) {
            return new OffsetOutOfRangeException(message);
        }
    }),
    CORRUPT_MESSAGE(2, "This message has failed its CRC checksum, exceeds the valid size, or is otherwise corrupt.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message) {
            return new CorruptRecordException(message);
        }
    }),
    UNKNOWN_TOPIC_OR_PARTITION(3, "This server does not host this topic-partition.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message) {
            return new UnknownTopicOrPartitionException(message);
        }
    }),
    INVALID_FETCH_SIZE(4, "The requested fetch size is invalid.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message) {
            return new InvalidFetchSizeException(message);
        }
    }),
    LEADER_NOT_AVAILABLE(5, "There is no leader for this topic-partition as we are in the middle of a leadership election.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message) {
            return new LeaderNotAvailableException(message);
        }
    }),
    NOT_LEADER_FOR_PARTITION(6, "This server is not the leader for that topic-partition.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message) {
            return new NotLeaderForPartitionException(message);
        }
    }),
    REQUEST_TIMED_OUT(7, "The request timed out.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message) {
            return new TimeoutException(message);
        }
    }),
    BROKER_NOT_AVAILABLE(8, "The broker is not available.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message) {
            return new BrokerNotAvailableException(message);
        }
    }),
    REPLICA_NOT_AVAILABLE(9, "The replica is not available for the requested topic-partition", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message) {
            return new ReplicaNotAvailableException(message);
        }
    }),
    MESSAGE_TOO_LARGE(10, "The request included a message larger than the max message size the server will accept.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message) {
            return new RecordTooLargeException(message);
        }
    }),
    STALE_CONTROLLER_EPOCH(11, "The controller moved to another broker.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message) {
            return new ControllerMovedException(message);
        }
    }),
    OFFSET_METADATA_TOO_LARGE(12, "The metadata field of the offset request was too large.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message) {
            return new OffsetMetadataTooLarge(message);
        }
    }),
    NETWORK_EXCEPTION(13, "The server disconnected before a response was received.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message) {
            return new NetworkException(message);
        }
    }),
    COORDINATOR_LOAD_IN_PROGRESS(14, "The coordinator is loading and hence can't process requests.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message) {
            return new CoordinatorLoadInProgressException(message);
        }
    }),
    COORDINATOR_NOT_AVAILABLE(15, "The coordinator is not available.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message) {
            return new CoordinatorNotAvailableException(message);
        }
    }),
    NOT_COORDINATOR(16, "This is not the correct coordinator.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message) {
            return new NotCoordinatorException(message);
        }
    }),
    INVALID_TOPIC_EXCEPTION(17, "The request attempted to perform an operation on an invalid topic.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message) {
            return new InvalidTopicException(message);
        }
    }),
    RECORD_LIST_TOO_LARGE(18, "The request included message batch larger than the configured segment size on the server.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message) {
            return new RecordBatchTooLargeException(message);
        }
    }),
    NOT_ENOUGH_REPLICAS(19, "Messages are rejected since there are fewer in-sync replicas than required.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message) {
            return new NotEnoughReplicasException(message);
        }
    }),
    NOT_ENOUGH_REPLICAS_AFTER_APPEND(20, "Messages are written to the log, but to fewer in-sync replicas than required.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message) {
            return new NotEnoughReplicasAfterAppendException(message);
        }
    }),
    INVALID_REQUIRED_ACKS(21, "Produce request specified an invalid value for required acks.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message) {
            return new InvalidRequiredAcksException(message);
        }
    }),
    ILLEGAL_GENERATION(22, "Specified group generation id is not valid.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message) {
            return new IllegalGenerationException(message);
        }
    }),
    INCONSISTENT_GROUP_PROTOCOL(23, "The group member's supported protocols are incompatible with those of existing members or first group member tried to join with empty protocol type or empty protocol list.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message) {
            return new InconsistentGroupProtocolException(message);
        }
    }),
    INVALID_GROUP_ID(24, "The configured groupId is invalid", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message) {
            return new InvalidGroupIdException(message);
        }
    }),
    UNKNOWN_MEMBER_ID(25, "The coordinator is not aware of this member.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message) {
            return new UnknownMemberIdException(message);
        }
    }),
    INVALID_SESSION_TIMEOUT(26, "The session timeout is not within the range allowed by the broker (as configured by group.min.session.timeout.ms and group.max.session.timeout.ms).", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message) {
            return new InvalidSessionTimeoutException(message);
        }
    }),
    REBALANCE_IN_PROGRESS(27, "The group is rebalancing, so a rejoin is needed.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message) {
            return new RebalanceInProgressException(message);
        }
    }),
    INVALID_COMMIT_OFFSET_SIZE(28, "The committing offset data size is not valid", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message) {
            return new InvalidCommitOffsetSizeException(message);
        }
    }),
    TOPIC_AUTHORIZATION_FAILED(29, "Topic authorization failed.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message) {
            return new TopicAuthorizationException(message);
        }
    }),
    GROUP_AUTHORIZATION_FAILED(30, "Group authorization failed.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message) {
            return new GroupAuthorizationException(message);
        }
    }),
    CLUSTER_AUTHORIZATION_FAILED(31, "Cluster authorization failed.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message) {
            return new ClusterAuthorizationException(message);
        }
    }),
    INVALID_TIMESTAMP(32, "The timestamp of the message is out of acceptable range.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message) {
            return new InvalidTimestampException(message);
        }
    }),
    UNSUPPORTED_SASL_MECHANISM(33, "The broker does not support the requested SASL mechanism.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message) {
            return new UnsupportedSaslMechanismException(message);
        }
    }),
    ILLEGAL_SASL_STATE(34, "Request is not valid given the current SASL state.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message) {
            return new IllegalSaslStateException(message);
        }
    }),
    UNSUPPORTED_VERSION(35, "The version of API is not supported.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message) {
            return new UnsupportedVersionException(message);
        }
    }),
    TOPIC_ALREADY_EXISTS(36, "Topic with this name already exists.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message) {
            return new TopicExistsException(message);
        }
    }),
    INVALID_PARTITIONS(37, "Number of partitions is invalid.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message) {
            return new InvalidPartitionsException(message);
        }
    }),
    INVALID_REPLICATION_FACTOR(38, "Replication-factor is invalid.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message) {
            return new InvalidReplicationFactorException(message);
        }
    }),
    INVALID_REPLICA_ASSIGNMENT(39, "Replica assignment is invalid.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message) {
            return new InvalidReplicaAssignmentException(message);
        }
    }),
    INVALID_CONFIG(40, "Configuration is invalid.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message) {
            return new InvalidConfigurationException(message);
        }
    }),
    NOT_CONTROLLER(41, "This is not the correct controller for this cluster.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message) {
            return new NotControllerException(message);
        }
    }),
    INVALID_REQUEST(42, "This most likely occurs because of a request being malformed by the client library or the message was sent to an incompatible broker. See the broker logs for more details.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message) {
            return new InvalidRequestException(message);
        }
    }),
    UNSUPPORTED_FOR_MESSAGE_FORMAT(43, "The message format version on the broker does not support the request.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message) {
            return new UnsupportedForMessageFormatException(message);
        }
    }),
    POLICY_VIOLATION(44, "Request parameters do not satisfy the configured policy.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message) {
            return new PolicyViolationException(message);
        }
    }),
    OUT_OF_ORDER_SEQUENCE_NUMBER(45, "The broker received an out of order sequence number", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message) {
            return new OutOfOrderSequenceException(message);
        }
    }),
    DUPLICATE_SEQUENCE_NUMBER(46, "The broker received a duplicate sequence number", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message) {
            return new DuplicateSequenceException(message);
        }
    }),
    INVALID_PRODUCER_EPOCH(47, "Producer attempted an operation with an old epoch. Either there is a newer producer with the same transactionalId, or the producer's transaction has been expired by the broker.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message) {
            return new ProducerFencedException(message);
        }
    }),
    INVALID_TXN_STATE(48, "The producer attempted a transactional operation in an invalid state", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message) {
            return new InvalidTxnStateException(message);
        }
    }),
    INVALID_PRODUCER_ID_MAPPING(49, "The producer attempted to use a producer id which is not currently assigned to its transactional id", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message) {
            return new InvalidPidMappingException(message);
        }
    }),
    INVALID_TRANSACTION_TIMEOUT(50, "The transaction timeout is larger than the maximum value allowed by the broker (as configured by transaction.max.timeout.ms).", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message) {
            return new InvalidTxnTimeoutException(message);
        }
    }),
    CONCURRENT_TRANSACTIONS(51, "The producer attempted to update a transaction while another concurrent operation on the same transaction was ongoing", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message) {
            return new ConcurrentTransactionsException(message);
        }
    }),
    TRANSACTION_COORDINATOR_FENCED(52, "Indicates that the transaction coordinator sending a WriteTxnMarker is no longer the current coordinator for a given producer", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message) {
            return new TransactionCoordinatorFencedException(message);
        }
    }),
    TRANSACTIONAL_ID_AUTHORIZATION_FAILED(53, "Transactional Id authorization failed", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message) {
            return new TransactionalIdAuthorizationException(message);
        }
    }),
    SECURITY_DISABLED(54, "Security features are disabled.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message) {
            return new SecurityDisabledException(message);
        }
    }),
    OPERATION_NOT_ATTEMPTED(55, "The broker did not attempt to execute this operation. This may happen for batched RPCs where some operations in the batch failed, causing the broker to respond without trying the rest.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message) {
            return new OperationNotAttemptedException(message);
        }
    }),
    KAFKA_STORAGE_ERROR(56, "Disk error when trying to access log file on the disk.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message) {
            return new KafkaStorageException(message);
        }
    }),
    LOG_DIR_NOT_FOUND(57, "The user-specified log directory is not found in the broker config.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message) {
            return new LogDirNotFoundException(message);
        }
    }),
    SASL_AUTHENTICATION_FAILED(58, "SASL Authentication failed.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message) {
            return new SaslAuthenticationException(message);
        }
    }),
    UNKNOWN_PRODUCER_ID(59, "This exception is raised by the broker if it could not locate the producer metadata associated with the producerId in question. This could happen if, for instance, the producer's records were deleted because their retention time had elapsed. Once the last records of the producerId are removed, the producer's metadata is removed from the broker, and future appends by the producer will return this exception.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message) {
            return new UnknownProducerIdException(message);
        }
    }),
    REASSIGNMENT_IN_PROGRESS(60, "A partition reassignment is in progress", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message) {
            return new ReassignmentInProgressException(message);
        }
    }),
    DELEGATION_TOKEN_AUTH_DISABLED(61, "Delegation Token feature is not enabled.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message) {
            return new DelegationTokenDisabledException(message);
        }
    }),
    DELEGATION_TOKEN_NOT_FOUND(62, "Delegation Token is not found on server.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message) {
            return new DelegationTokenNotFoundException(message);
        }
    }),
    DELEGATION_TOKEN_OWNER_MISMATCH(63, "Specified Principal is not valid Owner/Renewer.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message) {
            return new DelegationTokenOwnerMismatchException(message);
        }
    }),
    DELEGATION_TOKEN_REQUEST_NOT_ALLOWED(64, "Delegation Token requests are not allowed on PLAINTEXT/1-way SSL channels and on delegation token authenticated channels.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message) {
            return new UnsupportedByAuthenticationException(message);
        }
    }),
    DELEGATION_TOKEN_AUTHORIZATION_FAILED(65, "Delegation Token authorization failed.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message) {
            return new DelegationTokenAuthorizationException(message);
        }
    }),
    DELEGATION_TOKEN_EXPIRED(66, "Delegation Token is expired.", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message) {
            return new DelegationTokenExpiredException(message);
        }
    }),
    INVALID_PRINCIPAL_TYPE(67, "Supplied principalType is not supported", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message) {
            return new InvalidPrincipalTypeException(message);
        }
    }),
    NON_EMPTY_GROUP(68, "The group is not empty", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message) {
            return new GroupNotEmptyException(message);
        }
    }),
    GROUP_ID_NOT_FOUND(69, "The group id does not exist", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message) {
            return new GroupIdNotFoundException(message);
        }
    }),
    FETCH_SESSION_ID_NOT_FOUND(70, "The fetch session ID was not found", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message) {
            return new FetchSessionIdNotFoundException(message);
        }
    }),
    INVALID_FETCH_SESSION_EPOCH(71, "The fetch session epoch is invalid", new ApiExceptionBuilder(){

        @Override
        public ApiException build(String message) {
            return new InvalidFetchSessionEpochException(message);
        }
    });

    private static final Logger log;
    private static Map<Class<?>, Errors> classToError;
    private static Map<Short, Errors> codeToError;
    private final short code;
    private final ApiExceptionBuilder builder;
    private final ApiException exception;

    private Errors(int code, String defaultExceptionString, ApiExceptionBuilder builder) {
        this.code = (short)code;
        this.builder = builder;
        this.exception = builder.build(defaultExceptionString);
    }

    public ApiException exception() {
        return this.exception;
    }

    public ApiException exception(String message) {
        if (message == null) {
            return this.exception;
        }
        return this.builder.build(message);
    }

    public String exceptionName() {
        return this.exception == null ? null : this.exception.getClass().getName();
    }

    public short code() {
        return this.code;
    }

    public void maybeThrow() {
        if (this.exception != null) {
            throw this.exception;
        }
    }

    public String message() {
        if (this.exception != null) {
            return this.exception.getMessage();
        }
        return this.toString();
    }

    public static Errors forCode(short code) {
        Errors error = codeToError.get(code);
        if (error != null) {
            return error;
        }
        log.warn("Unexpected error code: {}.", (Object)code);
        return UNKNOWN_SERVER_ERROR;
    }

    public static Errors forException(Throwable t) {
        for (Class<?> clazz = t.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Errors error = classToError.get(clazz);
            if (error == null) continue;
            return error;
        }
        return UNKNOWN_SERVER_ERROR;
    }

    private static String toHtml() {
        StringBuilder b = new StringBuilder();
        b.append("<table class=\"data-table\"><tbody>\n");
        b.append("<tr>");
        b.append("<th>Error</th>\n");
        b.append("<th>Code</th>\n");
        b.append("<th>Retriable</th>\n");
        b.append("<th>Description</th>\n");
        b.append("</tr>\n");
        for (Errors error : Errors.values()) {
            b.append("<tr>");
            b.append("<td>");
            b.append(error.name());
            b.append("</td>");
            b.append("<td>");
            b.append(error.code());
            b.append("</td>");
            b.append("<td>");
            b.append(error.exception() != null && error.exception() instanceof RetriableException ? "True" : "False");
            b.append("</td>");
            b.append("<td>");
            b.append(error.exception() != null ? error.exception().getMessage() : "");
            b.append("</td>");
            b.append("</tr>\n");
        }
        b.append("</table>\n");
        return b.toString();
    }

    public static void main(String[] args) {
        System.out.println(Errors.toHtml());
    }

    static {
        log = LoggerFactory.getLogger(Errors.class);
        classToError = new HashMap();
        codeToError = new HashMap<Short, Errors>();
        for (Errors error : Errors.values()) {
            codeToError.put(error.code(), error);
            if (error.exception == null) continue;
            classToError.put(error.exception.getClass(), error);
        }
    }

    private static interface ApiExceptionBuilder {
        public ApiException build(String var1);
    }
}

