/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.org.apache.kafka.common.acl;

import io.confluent.org.apache.kafka.common.annotation.InterfaceStability;
import java.util.HashMap;
import java.util.Locale;

@InterfaceStability.Evolving
public enum AclOperation {
    UNKNOWN(0),
    ANY(1),
    ALL(2),
    READ(3),
    WRITE(4),
    CREATE(5),
    DELETE(6),
    ALTER(7),
    DESCRIBE(8),
    CLUSTER_ACTION(9),
    DESCRIBE_CONFIGS(10),
    ALTER_CONFIGS(11),
    IDEMPOTENT_WRITE(12);

    private static final HashMap<Byte, AclOperation> CODE_TO_VALUE;
    private final byte code;

    public static AclOperation fromString(String str) throws IllegalArgumentException {
        try {
            return AclOperation.valueOf(str.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            return UNKNOWN;
        }
    }

    public static AclOperation fromCode(byte code) {
        AclOperation operation = CODE_TO_VALUE.get(code);
        if (operation == null) {
            return UNKNOWN;
        }
        return operation;
    }

    private AclOperation(byte code) {
        this.code = code;
    }

    public byte code() {
        return this.code;
    }

    public boolean isUnknown() {
        return this == UNKNOWN;
    }

    static {
        CODE_TO_VALUE = new HashMap();
        for (AclOperation operation : AclOperation.values()) {
            CODE_TO_VALUE.put(operation.code, operation);
        }
    }
}

