/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.org.apache.kafka.common.acl;

import io.confluent.org.apache.kafka.common.acl.AccessControlEntryFilter;
import io.confluent.org.apache.kafka.common.acl.AclBinding;
import io.confluent.org.apache.kafka.common.acl.AclOperation;
import io.confluent.org.apache.kafka.common.acl.AclPermissionType;
import io.confluent.org.apache.kafka.common.annotation.InterfaceStability;
import io.confluent.org.apache.kafka.common.resource.ResourceFilter;
import io.confluent.org.apache.kafka.common.resource.ResourceType;
import java.util.Objects;

@InterfaceStability.Evolving
public class AclBindingFilter {
    private final ResourceFilter resourceFilter;
    private final AccessControlEntryFilter entryFilter;
    public static final AclBindingFilter ANY = new AclBindingFilter(new ResourceFilter(ResourceType.ANY, null), new AccessControlEntryFilter(null, null, AclOperation.ANY, AclPermissionType.ANY));

    public AclBindingFilter(ResourceFilter resourceFilter, AccessControlEntryFilter entryFilter) {
        Objects.requireNonNull(resourceFilter);
        this.resourceFilter = resourceFilter;
        Objects.requireNonNull(entryFilter);
        this.entryFilter = entryFilter;
    }

    public boolean isUnknown() {
        return this.resourceFilter.isUnknown() || this.entryFilter.isUnknown();
    }

    public ResourceFilter resourceFilter() {
        return this.resourceFilter;
    }

    public final AccessControlEntryFilter entryFilter() {
        return this.entryFilter;
    }

    public String toString() {
        return "(resourceFilter=" + this.resourceFilter + ", entryFilter=" + this.entryFilter + ")";
    }

    public boolean equals(Object o) {
        if (!(o instanceof AclBindingFilter)) {
            return false;
        }
        AclBindingFilter other = (AclBindingFilter)o;
        return this.resourceFilter.equals(other.resourceFilter) && this.entryFilter.equals(other.entryFilter);
    }

    public boolean matchesAtMostOne() {
        return this.resourceFilter.matchesAtMostOne() && this.entryFilter.matchesAtMostOne();
    }

    public String findIndefiniteField() {
        String indefinite = this.resourceFilter.findIndefiniteField();
        if (indefinite != null) {
            return indefinite;
        }
        return this.entryFilter.findIndefiniteField();
    }

    public boolean matches(AclBinding binding) {
        return this.resourceFilter.matches(binding.resource()) && this.entryFilter.matches(binding.entry());
    }

    public int hashCode() {
        return Objects.hash(this.resourceFilter, this.entryFilter);
    }
}

