/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.org.apache.kafka.common;

import io.confluent.org.apache.kafka.common.annotation.InterfaceStability;
import io.confluent.org.apache.kafka.common.internals.KafkaFutureImpl;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@InterfaceStability.Evolving
public abstract class KafkaFuture<T>
implements Future<T> {
    public static <U> KafkaFuture<U> completedFuture(U value) {
        KafkaFutureImpl<U> future = new KafkaFutureImpl<U>();
        ((KafkaFuture)future).complete(value);
        return future;
    }

    public static KafkaFuture<Void> allOf(KafkaFuture<?> ... futures) {
        KafkaFutureImpl<Void> allOfFuture = new KafkaFutureImpl<Void>();
        AllOfAdapter allOfWaiter = new AllOfAdapter(futures.length, allOfFuture);
        for (KafkaFuture<?> future : futures) {
            future.addWaiter(allOfWaiter);
        }
        return allOfFuture;
    }

    public abstract <R> KafkaFuture<R> thenApply(BaseFunction<T, R> var1);

    public abstract <R> KafkaFuture<R> thenApply(Function<T, R> var1);

    public abstract KafkaFuture<T> whenComplete(BiConsumer<? super T, ? super Throwable> var1);

    protected abstract void addWaiter(BiConsumer<? super T, ? super Throwable> var1);

    protected abstract boolean complete(T var1);

    protected abstract boolean completeExceptionally(Throwable var1);

    @Override
    public abstract boolean cancel(boolean var1);

    @Override
    public abstract T get() throws InterruptedException, ExecutionException;

    @Override
    public abstract T get(long var1, TimeUnit var3) throws InterruptedException, ExecutionException, TimeoutException;

    public abstract T getNow(T var1) throws InterruptedException, ExecutionException;

    @Override
    public abstract boolean isCancelled();

    public abstract boolean isCompletedExceptionally();

    @Override
    public abstract boolean isDone();

    private static class AllOfAdapter<R>
    implements BiConsumer<R, Throwable> {
        private int remainingResponses;
        private KafkaFuture<?> future;

        public AllOfAdapter(int remainingResponses, KafkaFuture<?> future) {
            this.remainingResponses = remainingResponses;
            this.future = future;
            this.maybeComplete();
        }

        @Override
        public synchronized void accept(R newValue, Throwable exception) {
            if (this.remainingResponses <= 0) {
                return;
            }
            if (exception != null) {
                this.remainingResponses = 0;
                this.future.completeExceptionally(exception);
            } else {
                --this.remainingResponses;
                this.maybeComplete();
            }
        }

        private void maybeComplete() {
            if (this.remainingResponses <= 0) {
                this.future.complete(null);
            }
        }
    }

    public static interface BiConsumer<A, B> {
        public void accept(A var1, B var2);
    }

    public static abstract class Function<A, B>
    implements BaseFunction<A, B> {
    }

    public static interface BaseFunction<A, B> {
        public B apply(A var1);
    }
}

