/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.org.apache.kafka.clients.admin;

import io.confluent.org.apache.kafka.clients.CommonClientConfigs;
import io.confluent.org.apache.kafka.common.config.AbstractConfig;
import io.confluent.org.apache.kafka.common.config.ConfigDef;
import io.confluent.org.apache.kafka.common.metrics.Sensor;
import java.util.Map;
import java.util.Set;

public class AdminClientConfig
extends AbstractConfig {
    private static final ConfigDef CONFIG;
    public static final String BOOTSTRAP_SERVERS_CONFIG = "bootstrap.servers";
    private static final String BOOTSTRAP_SERVERS_DOC = "A list of host/port pairs to use for establishing the initial connection to the Kafka cluster. The client will make use of all servers irrespective of which servers are specified here for bootstrapping&mdash;this list only impacts the initial hosts used to discover the full set of servers. This list should be in the form <code>host1:port1,host2:port2,...</code>. Since these servers are just used for the initial connection to discover the full cluster membership (which may change dynamically), this list need not contain the full set of servers (you may want more than one, though, in case a server is down).";
    public static final String RECONNECT_BACKOFF_MS_CONFIG = "reconnect.backoff.ms";
    private static final String RECONNECT_BACKOFF_MS_DOC = "The base amount of time to wait before attempting to reconnect to a given host. This avoids repeatedly connecting to a host in a tight loop. This backoff applies to all connection attempts by the client to a broker.";
    public static final String RECONNECT_BACKOFF_MAX_MS_CONFIG = "reconnect.backoff.max.ms";
    private static final String RECONNECT_BACKOFF_MAX_MS_DOC = "The maximum amount of time in milliseconds to wait when reconnecting to a broker that has repeatedly failed to connect. If provided, the backoff per host will increase exponentially for each consecutive connection failure, up to this maximum. After calculating the backoff increase, 20% random jitter is added to avoid connection storms.";
    public static final String RETRY_BACKOFF_MS_CONFIG = "retry.backoff.ms";
    private static final String RETRY_BACKOFF_MS_DOC = "The amount of time to wait before attempting to retry a failed request. This avoids repeatedly sending requests in a tight loop under some failure scenarios.";
    public static final String CONNECTIONS_MAX_IDLE_MS_CONFIG = "connections.max.idle.ms";
    private static final String CONNECTIONS_MAX_IDLE_MS_DOC = "Close idle connections after the number of milliseconds specified by this config.";
    public static final String REQUEST_TIMEOUT_MS_CONFIG = "request.timeout.ms";
    private static final String REQUEST_TIMEOUT_MS_DOC = "The configuration controls the maximum amount of time the client will wait for the response of a request. If the response is not received before the timeout elapses the client will resend the request if necessary or fail the request if retries are exhausted.";
    public static final String CLIENT_ID_CONFIG = "client.id";
    private static final String CLIENT_ID_DOC = "An id string to pass to the server when making requests. The purpose of this is to be able to track the source of requests beyond just ip/port by allowing a logical application name to be included in server-side request logging.";
    public static final String METADATA_MAX_AGE_CONFIG = "metadata.max.age.ms";
    private static final String METADATA_MAX_AGE_DOC = "The period of time in milliseconds after which we force a refresh of metadata even if we haven't seen any partition leadership changes to proactively discover any new brokers or partitions.";
    public static final String SEND_BUFFER_CONFIG = "send.buffer.bytes";
    private static final String SEND_BUFFER_DOC = "The size of the TCP send buffer (SO_SNDBUF) to use when sending data. If the value is -1, the OS default will be used.";
    public static final String RECEIVE_BUFFER_CONFIG = "receive.buffer.bytes";
    private static final String RECEIVE_BUFFER_DOC = "The size of the TCP receive buffer (SO_RCVBUF) to use when reading data. If the value is -1, the OS default will be used.";
    public static final String METRIC_REPORTER_CLASSES_CONFIG = "metric.reporters";
    private static final String METRIC_REPORTER_CLASSES_DOC = "A list of classes to use as metrics reporters. Implementing the <code>org.apache.kafka.common.metrics.MetricsReporter</code> interface allows plugging in classes that will be notified of new metric creation. The JmxReporter is always included to register JMX statistics.";
    public static final String METRICS_NUM_SAMPLES_CONFIG = "metrics.num.samples";
    private static final String METRICS_NUM_SAMPLES_DOC = "The number of samples maintained to compute metrics.";
    public static final String METRICS_SAMPLE_WINDOW_MS_CONFIG = "metrics.sample.window.ms";
    private static final String METRICS_SAMPLE_WINDOW_MS_DOC = "The window of time a metrics sample is computed over.";
    public static final String METRICS_RECORDING_LEVEL_CONFIG = "metrics.recording.level";
    public static final String SECURITY_PROTOCOL_CONFIG = "security.protocol";
    public static final String DEFAULT_SECURITY_PROTOCOL = "PLAINTEXT";
    private static final String SECURITY_PROTOCOL_DOC;
    private static final String METRICS_RECORDING_LEVEL_DOC = "The highest recording level for metrics.";
    public static final String RETRIES_CONFIG = "retries";

    @Override
    protected Map<String, Object> postProcessParsedConfig(Map<String, Object> parsedValues) {
        return CommonClientConfigs.postProcessReconnectBackoffConfigs(this, parsedValues);
    }

    public AdminClientConfig(Map<?, ?> props) {
        super(CONFIG, props);
    }

    public static Set<String> configNames() {
        return CONFIG.names();
    }

    public static void main(String[] args) {
        System.out.println(CONFIG.toHtmlTable());
    }

    static {
        SECURITY_PROTOCOL_DOC = CommonClientConfigs.SECURITY_PROTOCOL_DOC;
        CONFIG = new ConfigDef().define(BOOTSTRAP_SERVERS_CONFIG, ConfigDef.Type.LIST, ConfigDef.Importance.HIGH, BOOTSTRAP_SERVERS_DOC).define(CLIENT_ID_CONFIG, ConfigDef.Type.STRING, "", ConfigDef.Importance.MEDIUM, CLIENT_ID_DOC).define(METADATA_MAX_AGE_CONFIG, ConfigDef.Type.LONG, 300000, ConfigDef.Range.atLeast(0), ConfigDef.Importance.LOW, METADATA_MAX_AGE_DOC).define(SEND_BUFFER_CONFIG, ConfigDef.Type.INT, 131072, ConfigDef.Range.atLeast(-1), ConfigDef.Importance.MEDIUM, SEND_BUFFER_DOC).define(RECEIVE_BUFFER_CONFIG, ConfigDef.Type.INT, 65536, ConfigDef.Range.atLeast(-1), ConfigDef.Importance.MEDIUM, RECEIVE_BUFFER_DOC).define(RECONNECT_BACKOFF_MS_CONFIG, ConfigDef.Type.LONG, 50L, ConfigDef.Range.atLeast(0L), ConfigDef.Importance.LOW, RECONNECT_BACKOFF_MS_DOC).define(RECONNECT_BACKOFF_MAX_MS_CONFIG, ConfigDef.Type.LONG, 1000L, ConfigDef.Range.atLeast(0L), ConfigDef.Importance.LOW, RECONNECT_BACKOFF_MAX_MS_DOC).define(RETRY_BACKOFF_MS_CONFIG, ConfigDef.Type.LONG, 100L, ConfigDef.Range.atLeast(0L), ConfigDef.Importance.LOW, RETRY_BACKOFF_MS_DOC).define(REQUEST_TIMEOUT_MS_CONFIG, ConfigDef.Type.INT, 120000, ConfigDef.Range.atLeast(0), ConfigDef.Importance.MEDIUM, REQUEST_TIMEOUT_MS_DOC).define(CONNECTIONS_MAX_IDLE_MS_CONFIG, ConfigDef.Type.LONG, 300000, ConfigDef.Importance.MEDIUM, CONNECTIONS_MAX_IDLE_MS_DOC).define(RETRIES_CONFIG, ConfigDef.Type.INT, 5, ConfigDef.Range.atLeast(0), ConfigDef.Importance.LOW, "Setting a value greater than zero will cause the client to resend any request that fails with a potentially transient error.").define(METRICS_SAMPLE_WINDOW_MS_CONFIG, ConfigDef.Type.LONG, 30000, ConfigDef.Range.atLeast(0), ConfigDef.Importance.LOW, METRICS_SAMPLE_WINDOW_MS_DOC).define(METRICS_NUM_SAMPLES_CONFIG, ConfigDef.Type.INT, 2, ConfigDef.Range.atLeast(1), ConfigDef.Importance.LOW, METRICS_NUM_SAMPLES_DOC).define(METRIC_REPORTER_CLASSES_CONFIG, ConfigDef.Type.LIST, "", ConfigDef.Importance.LOW, METRIC_REPORTER_CLASSES_DOC).define(METRICS_RECORDING_LEVEL_CONFIG, ConfigDef.Type.STRING, Sensor.RecordingLevel.INFO.toString(), ConfigDef.ValidString.in(Sensor.RecordingLevel.INFO.toString(), Sensor.RecordingLevel.DEBUG.toString()), ConfigDef.Importance.LOW, METRICS_RECORDING_LEVEL_DOC).define(SECURITY_PROTOCOL_CONFIG, ConfigDef.Type.STRING, DEFAULT_SECURITY_PROTOCOL, ConfigDef.Importance.MEDIUM, SECURITY_PROTOCOL_DOC).withClientSslSupport().withClientSaslSupport();
    }
}

