/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest;

import io.confluent.kafka.javaapi.consumer.SimpleConsumer;
import io.confluent.kafkarest.KafkaRestConfig;
import io.confluent.kafkarest.SimpleConsumerConfig;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleConsumerFactory {
    private static final Logger log = LoggerFactory.getLogger(SimpleConsumerFactory.class);
    private final KafkaRestConfig config;
    private final SimpleConsumerConfig simpleConsumerConfig;
    private final AtomicInteger clientIdCounter;

    public SimpleConsumerFactory(KafkaRestConfig config) {
        this.config = config;
        this.clientIdCounter = new AtomicInteger(0);
        this.simpleConsumerConfig = new SimpleConsumerConfig(config.getOriginalProperties());
    }

    public SimpleConsumerConfig getSimpleConsumerConfig() {
        return this.simpleConsumerConfig;
    }

    private String nextClientId() {
        StringBuilder id = new StringBuilder();
        id.append("rest-simpleconsumer-");
        String serverId = this.config.getString("id");
        if (!serverId.isEmpty()) {
            id.append(serverId);
            id.append("-");
        }
        id.append(Integer.toString(this.clientIdCounter.incrementAndGet()));
        return id.toString();
    }

    public SimpleConsumer createConsumer(String host, int port) {
        String clientId = this.nextClientId();
        log.debug("Creating SimpleConsumer with id {} (host:{}, port:{})", new Object[]{clientId, host, port});
        return new SimpleConsumer(host, port, this.simpleConsumerConfig.socketTimeoutMs(), this.simpleConsumerConfig.socketReceiveBufferBytes(), clientId);
    }
}

