/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest;

import io.confluent.kafka.utils.ZkUtils;
import io.confluent.kafkarest.ConsumerManager;
import io.confluent.kafkarest.KafkaRestConfig;
import io.confluent.kafkarest.MetadataObserver;
import io.confluent.kafkarest.SimpleConsumerFactory;
import io.confluent.kafkarest.SimpleConsumerManager;
import io.confluent.kafkarest.UnsupportedMetaDataObserver;
import io.confluent.kafkarest.exceptions.ZkExceptionMapper;
import io.confluent.org.apache.kafka.common.security.JaasUtils;
import javax.ws.rs.core.Configurable;
import org.eclipse.jetty.util.StringUtil;

public class ScalaConsumersContext {
    private final MetadataObserver metadataObserver;
    private final ConsumerManager consumerManager;
    private final SimpleConsumerManager simpleConsumerManager;
    private ZkUtils zkUtils;

    public ScalaConsumersContext(KafkaRestConfig appConfig) {
        SimpleConsumerFactory simpleConsumerFactory = new SimpleConsumerFactory(appConfig);
        this.metadataObserver = this.metadataObserver(appConfig);
        this.consumerManager = new ConsumerManager(appConfig, this.metadataObserver);
        this.simpleConsumerManager = new SimpleConsumerManager(appConfig, this.metadataObserver, simpleConsumerFactory);
    }

    public static void registerExceptionMappers(Configurable<?> config, KafkaRestConfig appConfig) {
        config.register((Object)new ZkExceptionMapper(appConfig));
    }

    private MetadataObserver metadataObserver(KafkaRestConfig config) {
        if (StringUtil.isNotBlank((String)config.getString("zookeeper.connect"))) {
            this.zkUtils = ZkUtils.apply(config.getString("zookeeper.connect"), 30000, 30000, JaasUtils.isZkSecurityEnabled());
            return new MetadataObserver(this.zkUtils);
        }
        return new UnsupportedMetaDataObserver(null);
    }

    public ScalaConsumersContext(MetadataObserver metadataObserver, ConsumerManager consumerManager, SimpleConsumerManager simpleConsumerManager) {
        this.metadataObserver = metadataObserver;
        this.consumerManager = consumerManager;
        this.simpleConsumerManager = simpleConsumerManager;
        this.zkUtils = null;
    }

    public void shutdown() {
        this.metadataObserver.shutdown();
        this.consumerManager.shutdown();
        this.simpleConsumerManager.shutdown();
        if (this.zkUtils != null) {
            this.zkUtils.close();
        }
    }

    public SimpleConsumerManager getSimpleConsumerManager() {
        return this.simpleConsumerManager;
    }

    public ConsumerManager getConsumerManager() {
        return this.consumerManager;
    }
}

