/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.kafka.javaapi.consumer.ConsumerConnector;
import io.confluent.kafka.message.MessageAndMetadata;
import io.confluent.kafka.serializer.Decoder;
import io.confluent.kafka.serializer.DefaultDecoder;
import io.confluent.kafka.utils.VerifiableProperties;
import io.confluent.kafkarest.ConsumerInstanceId;
import io.confluent.kafkarest.ConsumerRecordAndSize;
import io.confluent.kafkarest.ConsumerState;
import io.confluent.kafkarest.KafkaRestConfig;
import io.confluent.kafkarest.entities.ConsumerRecord;
import io.confluent.kafkarest.entities.JsonConsumerRecord;
import io.confluent.org.apache.kafka.common.errors.SerializationException;

public class JsonConsumerState
extends ConsumerState<byte[], byte[], Object, Object> {
    private static final Decoder<byte[]> decoder = new DefaultDecoder(new VerifiableProperties());
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public JsonConsumerState(KafkaRestConfig config, ConsumerInstanceId instanceId, ConsumerConnector consumer) {
        super(config, instanceId, consumer);
    }

    @Override
    protected Decoder<byte[]> getKeyDecoder() {
        return decoder;
    }

    @Override
    protected Decoder<byte[]> getValueDecoder() {
        return decoder;
    }

    @Override
    public ConsumerRecordAndSize<Object, Object> createConsumerRecord(MessageAndMetadata<byte[], byte[]> msg) {
        long approxSize = 0L;
        Object key = null;
        Object value = null;
        if (msg.key() != null) {
            approxSize += (long)msg.key().length;
            key = this.deserialize(msg.key());
        }
        if (msg.message() != null) {
            approxSize += (long)msg.message().length;
            value = this.deserialize(msg.message());
        }
        return new ConsumerRecordAndSize((ConsumerRecord)new JsonConsumerRecord(msg.topic(), key, value, msg.partition(), msg.offset()), approxSize);
    }

    private Object deserialize(byte[] data) {
        try {
            return objectMapper.readValue(data, Object.class);
        }
        catch (Exception e) {
            throw new SerializationException(e);
        }
    }
}

