/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.zookeeper;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import io.confluent.kafka.metrics.KafkaMetricsGroup;
import io.confluent.kafka.utils.CoreUtils$;
import io.confluent.kafka.utils.KafkaScheduler;
import io.confluent.kafka.utils.KafkaScheduler$;
import io.confluent.kafka.utils.Logging;
import io.confluent.kafka.zookeeper.AsyncRequest;
import io.confluent.kafka.zookeeper.AsyncResponse;
import io.confluent.kafka.zookeeper.CreateRequest;
import io.confluent.kafka.zookeeper.CreateResponse;
import io.confluent.kafka.zookeeper.DeleteRequest;
import io.confluent.kafka.zookeeper.DeleteResponse;
import io.confluent.kafka.zookeeper.ExistsRequest;
import io.confluent.kafka.zookeeper.ExistsResponse;
import io.confluent.kafka.zookeeper.GetAclRequest;
import io.confluent.kafka.zookeeper.GetAclResponse;
import io.confluent.kafka.zookeeper.GetChildrenRequest;
import io.confluent.kafka.zookeeper.GetChildrenResponse;
import io.confluent.kafka.zookeeper.GetDataRequest;
import io.confluent.kafka.zookeeper.GetDataResponse;
import io.confluent.kafka.zookeeper.ResponseMetadata;
import io.confluent.kafka.zookeeper.SetAclRequest;
import io.confluent.kafka.zookeeper.SetAclResponse;
import io.confluent.kafka.zookeeper.SetDataRequest;
import io.confluent.kafka.zookeeper.SetDataResponse;
import io.confluent.kafka.zookeeper.StateChangeHandler;
import io.confluent.kafka.zookeeper.ZNodeChangeHandler;
import io.confluent.kafka.zookeeper.ZNodeChildChangeHandler;
import io.confluent.kafka.zookeeper.ZooKeeperClient$ZooKeeperClientWatcher$;
import io.confluent.kafka.zookeeper.ZooKeeperClientAuthFailedException;
import io.confluent.kafka.zookeeper.ZooKeeperClientExpiredException;
import io.confluent.kafka.zookeeper.ZooKeeperClientTimeoutException;
import io.confluent.org.apache.kafka.common.utils.Time;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LongRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\rUa\u0001B\u0001\u0003\u0001\u001d\u0011qBW8p\u0017\u0016,\u0007/\u001a:DY&,g\u000e\u001e\u0006\u0003\u0007\u0011\t\u0011B_8pW\u0016,\u0007/\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0003\u0001\u00119!\u0002CA\u0005\r\u001b\u0005Q!\"A\u0006\u0002\u000bM\u001c\u0017\r\\1\n\u00055Q!AB!osJ+g\r\u0005\u0002\u0010%5\t\u0001C\u0003\u0002\u0012\t\u0005)Q\u000f^5mg&\u00111\u0003\u0005\u0002\b\u0019><w-\u001b8h!\t)\u0002$D\u0001\u0017\u0015\t9B!A\u0004nKR\u0014\u0018nY:\n\u0005e1\"!E&bM.\fW*\u001a;sS\u000e\u001cxI]8va\"A1\u0004\u0001B\u0001B\u0003%A$A\u0007d_:tWm\u0019;TiJLgn\u001a\t\u0003;\u0011r!A\b\u0012\u0011\u0005}QQ\"\u0001\u0011\u000b\u0005\u00052\u0011A\u0002\u001fs_>$h(\u0003\u0002$\u0015\u00051\u0001K]3eK\u001aL!!\n\u0014\u0003\rM#(/\u001b8h\u0015\t\u0019#\u0002\u0003\u0005)\u0001\t\u0005\t\u0015!\u0003*\u0003A\u0019Xm]:j_:$\u0016.\\3pkRl5\u000f\u0005\u0002\nU%\u00111F\u0003\u0002\u0004\u0013:$\b\u0002C\u0017\u0001\u0005\u0003\u0005\u000b\u0011B\u0015\u0002'\r|gN\\3di&|g\u000eV5nK>,H/T:\t\u0011=\u0002!\u0011!Q\u0001\n%\n1#\\1y\u0013:4E.[4iiJ+\u0017/^3tiND\u0001\"\r\u0001\u0003\u0002\u0003\u0006IAM\u0001\u0005i&lW\r\u0005\u00024y5\tAG\u0003\u0002\u0012k)\u0011agN\u0001\u0007G>lWn\u001c8\u000b\u0005\u0015A$BA\u001d;\u0003\u0019\t\u0007/Y2iK*\t1(A\u0002pe\u001eL!!\u0010\u001b\u0003\tQKW.\u001a\u0005\t\u007f\u0001\u0011\t\u0011)A\u00059\u0005YQ.\u001a;sS\u000e<%o\\;q\u0011!\t\u0005A!A!\u0002\u0013a\u0012AC7fiJL7\rV=qK\")1\t\u0001C\u0001\t\u00061A(\u001b8jiz\"\u0002\"R$I\u0013*[E*\u0014\t\u0003\r\u0002i\u0011A\u0001\u0005\u00067\t\u0003\r\u0001\b\u0005\u0006Q\t\u0003\r!\u000b\u0005\u0006[\t\u0003\r!\u000b\u0005\u0006_\t\u0003\r!\u000b\u0005\u0006c\t\u0003\rA\r\u0005\u0006\u007f\t\u0003\r\u0001\b\u0005\u0006\u0003\n\u0003\r\u0001\b\u0005\b\u001f\u0002\u0011\r\u0011\"\u0003Q\u0003IIg.\u001b;jC2L'0\u0019;j_:dunY6\u0016\u0003E\u0003\"AU.\u000e\u0003MS!\u0001V+\u0002\u000b1|7m[:\u000b\u0005Y;\u0016AC2p]\u000e,(O]3oi*\u0011\u0001,W\u0001\u0005kRLGNC\u0001[\u0003\u0011Q\u0017M^1\n\u0005q\u001b&A\u0006*fK:$(/\u00198u%\u0016\fGm\u0016:ji\u0016dunY6\t\ry\u0003\u0001\u0015!\u0003R\u0003MIg.\u001b;jC2L'0\u0019;j_:dunY6!\u0011\u001d\u0001\u0007A1A\u0005\n\u0005\f\u0001$[:D_:tWm\u0019;fI>\u0013X\t\u001f9je\u0016$Gj\\2l+\u0005\u0011\u0007C\u0001*d\u0013\t!7KA\u0007SK\u0016tGO]1oi2{7m\u001b\u0005\u0007M\u0002\u0001\u000b\u0011\u00022\u00023%\u001c8i\u001c8oK\u000e$X\rZ(s\u000bb\u0004\u0018N]3e\u0019>\u001c7\u000e\t\u0005\bQ\u0002\u0011\r\u0011\"\u0003j\u0003uI7oQ8o]\u0016\u001cG/\u001a3Pe\u0016C\b/\u001b:fI\u000e{g\u000eZ5uS>tW#\u00016\u0011\u0005I[\u0017B\u00017T\u0005%\u0019uN\u001c3ji&|g\u000e\u0003\u0004o\u0001\u0001\u0006IA[\u0001\u001fSN\u001cuN\u001c8fGR,Gm\u0014:FqBL'/\u001a3D_:$\u0017\u000e^5p]\u0002Bq\u0001\u001d\u0001C\u0002\u0013%\u0011/A\n{\u001d>$Wm\u00115b]\u001e,\u0007*\u00198eY\u0016\u00148/F\u0001s!\u0011\u0019x\u000fH=\u000e\u0003QT!AV;\u000b\u0005YT\u0011AC2pY2,7\r^5p]&\u0011\u0001\u0010\u001e\u0002\u0004\u001b\u0006\u0004\bC\u0001${\u0013\tY(A\u0001\n[\u001d>$Wm\u00115b]\u001e,\u0007*\u00198eY\u0016\u0014\bBB?\u0001A\u0003%!/\u0001\u000b{\u001d>$Wm\u00115b]\u001e,\u0007*\u00198eY\u0016\u00148\u000f\t\u0005\t\u007f\u0002\u0011\r\u0011\"\u0003\u0002\u0002\u0005A\"PT8eK\u000eC\u0017\u000e\u001c3DQ\u0006tw-\u001a%b]\u0012dWM]:\u0016\u0005\u0005\r\u0001#B:x9\u0005\u0015\u0001c\u0001$\u0002\b%\u0019\u0011\u0011\u0002\u0002\u0003/isu\u000eZ3DQ&dGm\u00115b]\u001e,\u0007*\u00198eY\u0016\u0014\b\u0002CA\u0007\u0001\u0001\u0006I!a\u0001\u00023itu\u000eZ3DQ&dGm\u00115b]\u001e,\u0007*\u00198eY\u0016\u00148\u000f\t\u0005\n\u0003#\u0001!\u0019!C\u0005\u0003'\t\u0001#\u001b8GY&<\u0007\u000e\u001e*fcV,7\u000f^:\u0016\u0005\u0005U\u0001\u0003BA\f\u00033i\u0011!V\u0005\u0004\u00037)&!C*f[\u0006\u0004\bn\u001c:f\u0011!\ty\u0002\u0001Q\u0001\n\u0005U\u0011!E5o\r2Lw\r\u001b;SKF,Xm\u001d;tA!I\u00111\u0005\u0001C\u0002\u0013%\u0011QE\u0001\u0014gR\fG/Z\"iC:<W\rS1oI2,'o]\u000b\u0003\u0003O\u0001Ra]<\u001d\u0003S\u00012ARA\u0016\u0013\r\tiC\u0001\u0002\u0013'R\fG/Z\"iC:<W\rS1oI2,'\u000f\u0003\u0005\u00022\u0001\u0001\u000b\u0011BA\u0014\u0003Q\u0019H/\u0019;f\u0007\"\fgnZ3IC:$G.\u001a:tA!Q\u0011Q\u0007\u0001C\u0002\u0013\u0005!!a\u000e\u0002\u001f\u0015D\b/\u001b:z'\u000eDW\rZ;mKJ,\"!!\u000f\u0011\u0007=\tY$C\u0002\u0002>A\u0011abS1gW\u0006\u001c6\r[3ek2,'\u000f\u0003\u0005\u0002B\u0001\u0001\u000b\u0011BA\u001d\u0003A)\u0007\u0010]5ssN\u001b\u0007.\u001a3vY\u0016\u0014\b\u0005C\u0005\u0002F\u0001\u0011\r\u0011\"\u0003\u0002H\u0005YQ.\u001a;sS\u000et\u0015-\\3t+\t\tI\u0005E\u0003\u0002L\u0005EC$\u0004\u0002\u0002N)\u0019\u0011qJ;\u0002\u000f5,H/\u00192mK&!\u00111KA'\u0005\r\u0019V\r\u001e\u0005\t\u0003/\u0002\u0001\u0015!\u0003\u0002J\u0005aQ.\u001a;sS\u000et\u0015-\\3tA!I\u00111\f\u0001C\u0002\u0013%\u0011QL\u0001\u0010gR\fG/\u001a+p\u001b\u0016$XM]'baV\u0011\u0011q\f\t\t\u0003C\n9'!\u001b\u0002|5\u0011\u00111\r\u0006\u0004\u0003K*\u0018!C5n[V$\u0018M\u00197f\u0013\rA\u00181\r\t\u0005\u0003W\n9(\u0004\u0002\u0002n)!\u0011qNA9\u0003\u0015)e/\u001a8u\u0015\u0011\t\u0019(!\u001e\u0002\u000f]\u000bGo\u00195fe*\u00111\u0001O\u0005\u0005\u0003s\niGA\u0006LK\u0016\u0004XM]*uCR,\u0007\u0003BA?\u0003\u001bk!!a \u000b\t\u0005\u0005\u00151Q\u0001\u0005G>\u0014XMC\u0002\u0018\u0003\u000bSA!a\"\u0002\n\u00061\u00110Y7nKJT!!a#\u0002\u0007\r|W.\u0003\u0003\u0002\u0010\u0006}$!B'fi\u0016\u0014\b\u0002CAJ\u0001\u0001\u0006I!a\u0018\u0002!M$\u0018\r^3U_6+G/\u001a:NCB\u0004\u0003\"CAL\u0001\u0001\u0007I\u0011BAM\u0003%Qxn\\&fKB,'/\u0006\u0002\u0002\u001cB!\u0011QTAP\u001b\t\t)(\u0003\u0003\u0002\"\u0006U$!\u0003.p_.+W\r]3s\u0011%\t)\u000b\u0001a\u0001\n\u0013\t9+A\u0007{_>\\U-\u001a9fe~#S-\u001d\u000b\u0005\u0003S\u000by\u000bE\u0002\n\u0003WK1!!,\u000b\u0005\u0011)f.\u001b;\t\u0015\u0005E\u00161UA\u0001\u0002\u0004\tY*A\u0002yIEB\u0001\"!.\u0001A\u0003&\u00111T\u0001\u000bu>|7*Z3qKJ\u0004\u0003\u0006BAZ\u0003s\u00032!CA^\u0013\r\tiL\u0003\u0002\tm>d\u0017\r^5mK\"9\u0011\u0011\u0019\u0001\u0005B\u0005\r\u0017AC7fiJL7MT1nKR1\u0011QYAf\u0003\u001f\u0004B!! \u0002H&!\u0011\u0011ZA@\u0005)iU\r\u001e:jG:\u000bW.\u001a\u0005\b\u0003\u001b\fy\f1\u0001\u001d\u0003\u0011q\u0017-\\3\t\u0011\u0005E\u0017q\u0018a\u0001\u0003'\f!\"\\3ue&\u001cG+Y4t!\u0019\t).a6\u001d95\tQ/\u0003\u0002yk\"9\u00111\u001c\u0001\u0005\u0002\u0005u\u0017aD2p]:,7\r^5p]N#\u0018\r^3\u0016\u0005\u0005}\u0007\u0003BAq\u0003gtA!a9\u0002p:!\u0011Q]Aw\u001d\u0011\t9/a;\u000f\u0007}\tI/C\u0001<\u0013\tI$(\u0003\u0002\u0004q%!\u0011\u0011_A;\u0003%Qvn\\&fKB,'/\u0003\u0003\u0002v\u0006](AB*uCR,7O\u0003\u0003\u0002r\u0006U\u0004bBA~\u0001\u0011\u0005\u0011Q`\u0001\u000eQ\u0006tG\r\\3SKF,Xm\u001d;\u0016\t\u0005}(q\u0001\u000b\u0005\u0005\u0003\u0011i\u0002\u0005\u0003\u0003\u0004\te\u0001\u0003\u0002B\u0003\u0005\u000fa\u0001\u0001\u0002\u0005\u0003\n\u0005e(\u0019\u0001B\u0006\u0005\r\u0011V-]\t\u0005\u0005\u001b\u0011\u0019\u0002E\u0002\n\u0005\u001fI1A!\u0005\u000b\u0005\u001dqu\u000e\u001e5j]\u001e\u00042A\u0012B\u000b\u0013\r\u00119B\u0001\u0002\r\u0003NLhn\u0019*fcV,7\u000f^\u0005\u0005\u00057\u0011)B\u0001\u0005SKN\u0004xN\\:f\u0011!\u0011y\"!?A\u0002\t\r\u0011a\u0002:fcV,7\u000f\u001e\u0005\b\u0005G\u0001A\u0011\u0001B\u0013\u00039A\u0017M\u001c3mKJ+\u0017/^3tiN,BAa\n\u0003@Q!!\u0011\u0006B!!\u0019\u0011YC!\u000e\u0003<9!!Q\u0006B\u0019\u001d\ry\"qF\u0005\u0002\u0017%\u0019!1\u0007\u0006\u0002\u000fA\f7m[1hK&!!q\u0007B\u001d\u0005\r\u0019V-\u001d\u0006\u0004\u0005gQ\u0001\u0003\u0002B\u001f\u00053\u0001BA!\u0002\u0003@\u0011A!\u0011\u0002B\u0011\u0005\u0004\u0011Y\u0001\u0003\u0005\u0003D\t\u0005\u0002\u0019\u0001B#\u0003!\u0011X-];fgR\u001c\bC\u0002B\u0016\u0005k\u0011i\u0004\u0003\u0005\u0003J\u0001!\tA\u0001B&\u0003\u0011\u0019XM\u001c3\u0016\t\t5#q\f\u000b\u0005\u0005\u001f\u0012\t\u0007\u0006\u0003\u0002*\nE\u0003\u0002\u0003B*\u0005\u000f\u0002\rA!\u0016\u0002\u001fA\u0014xnY3tgJ+7\u000f]8og\u0016\u0004r!\u0003B,\u00057\nI+C\u0002\u0003Z)\u0011\u0011BR;oGRLwN\\\u0019\u0011\t\tu#\u0011\u0004\t\u0005\u0005\u000b\u0011y\u0006\u0002\u0005\u0003\n\t\u001d#\u0019\u0001B\u0006\u0011!\u0011yBa\u0012A\u0002\tu\u0003b\u0002B3\u0001\u0011\u0005!qM\u0001\u0013o\u0006LG/\u00168uS2\u001cuN\u001c8fGR,G\r\u0006\u0002\u0002*\"9!Q\r\u0001\u0005\n\t-DCBAU\u0005[\u00129\b\u0003\u0005\u0003p\t%\u0004\u0019\u0001B9\u0003\u001d!\u0018.\\3pkR\u00042!\u0003B:\u0013\r\u0011)H\u0003\u0002\u0005\u0019>tw\r\u0003\u0005\u0003z\t%\u0004\u0019\u0001B>\u0003!!\u0018.\\3V]&$\b\u0003BA\f\u0005{J1Aa V\u0005!!\u0016.\\3V]&$\bb\u0002BB\u0001\u0011%!QQ\u0001\fg\"|W\u000f\u001c3XCR\u001c\u0007\u000e\u0006\u0003\u0003\b\n5\u0005cA\u0005\u0003\n&\u0019!1\u0012\u0006\u0003\u000f\t{w\u000e\\3b]\"A!q\u0004BA\u0001\u0004\u0011\u0019\u0002C\u0004\u0003\u0012\u0002!\tAa%\u00025I,w-[:uKJTfj\u001c3f\u0007\"\fgnZ3IC:$G.\u001a:\u0015\t\u0005%&Q\u0013\u0005\b\u0005/\u0013y\t1\u0001z\u0003IQhj\u001c3f\u0007\"\fgnZ3IC:$G.\u001a:\t\u000f\tm\u0005\u0001\"\u0001\u0003\u001e\u0006aRO\u001c:fO&\u001cH/\u001a:[\u001d>$Wm\u00115b]\u001e,\u0007*\u00198eY\u0016\u0014H\u0003BAU\u0005?CqA!)\u0003\u001a\u0002\u0007A$\u0001\u0003qCRD\u0007b\u0002BS\u0001\u0011\u0005!qU\u0001 e\u0016<\u0017n\u001d;fejsu\u000eZ3DQ&dGm\u00115b]\u001e,\u0007*\u00198eY\u0016\u0014H\u0003BAU\u0005SC\u0001Ba+\u0003$\u0002\u0007\u0011QA\u0001\u0018u:{G-Z\"iS2$7\t[1oO\u0016D\u0015M\u001c3mKJDqAa,\u0001\t\u0003\u0011\t,A\u0011v]J,w-[:uKJTfj\u001c3f\u0007\"LG\u000eZ\"iC:<W\rS1oI2,'\u000f\u0006\u0003\u0002*\nM\u0006b\u0002BQ\u0005[\u0003\r\u0001\b\u0005\b\u0005o\u0003A\u0011\u0001B]\u0003i\u0011XmZ5ti\u0016\u00148\u000b^1uK\u000eC\u0017M\\4f\u0011\u0006tG\r\\3s)\u0011\tIKa/\t\u0011\tu&Q\u0017a\u0001\u0003S\t!c\u001d;bi\u0016\u001c\u0005.\u00198hK\"\u000bg\u000e\u001a7fe\"9!\u0011\u0019\u0001\u0005\u0002\t\r\u0017\u0001H;oe\u0016<\u0017n\u001d;feN#\u0018\r^3DQ\u0006tw-\u001a%b]\u0012dWM\u001d\u000b\u0005\u0003S\u0013)\rC\u0004\u0002N\n}\u0006\u0019\u0001\u000f\t\u000f\t%\u0007\u0001\"\u0001\u0003h\u0005)1\r\\8tK\"9!Q\u001a\u0001\u0005\u0002\t=\u0017!C:fgNLwN\\%e+\t\u0011\t\b\u0003\u0005\u0003T\u0002!\t\u0001BAM\u0003A\u0019WO\u001d:f]RTvn\\&fKB,'\u000fC\u0004\u0003X\u0002!IAa\u001a\u0002\u0015%t\u0017\u000e^5bY&TX\r\u0003\u0005\u0003\\\u0002!\tA\u0001B4\u00031\u0011X-\u001b8ji&\fG.\u001b>f\u0011!\u0011y\u000e\u0001C\u0001\u0005\t\u001d\u0014\u0001H:dQ\u0016$W\u000f\\3TKN\u001c\u0018n\u001c8FqBL'/\u001f%b]\u0012dWM]\u0004\t\u0005G\u0004\u0001\u0012\u0001\u0002\u0003f\u00061\"l\\8LK\u0016\u0004XM]\"mS\u0016tGoV1uG\",'\u000f\u0005\u0003\u0003h\n%X\"\u0001\u0001\u0007\u0011\t-\b\u0001#\u0001\u0003\u0005[\u0014aCW8p\u0017\u0016,\u0007/\u001a:DY&,g\u000e^,bi\u000eDWM]\n\u0007\u0005S\u0014yOa?\u0011\t\tE(q_\u0007\u0003\u0005gT1A!>Z\u0003\u0011a\u0017M\\4\n\t\te(1\u001f\u0002\u0007\u001f\nTWm\u0019;\u0011\t\u0005u%Q`\u0005\u0005\u0005\u007f\f)HA\u0004XCR\u001c\u0007.\u001a:\t\u000f\r\u0013I\u000f\"\u0001\u0004\u0004Q\u0011!Q\u001d\u0005\t\u0007\u000f\u0011I\u000f\"\u0011\u0004\n\u00059\u0001O]8dKN\u001cH\u0003BAU\u0007\u0017A\u0001b!\u0004\u0004\u0006\u0001\u00071qB\u0001\u0006KZ,g\u000e\u001e\t\u0005\u0003;\u001b\t\"\u0003\u0003\u0004\u0014\u0005U$\u0001D,bi\u000eDW\rZ#wK:$\b")
public class ZooKeeperClient
implements KafkaMetricsGroup {
    private volatile ZooKeeperClient$ZooKeeperClientWatcher$ ZooKeeperClientWatcher$module;
    private final String connectString;
    private final int sessionTimeoutMs;
    private final Time time;
    private final String metricGroup;
    private final String metricType;
    private final ReentrantReadWriteLock initializationLock;
    private final ReentrantLock kafka$zookeeper$ZooKeeperClient$$isConnectedOrExpiredLock;
    private final Condition kafka$zookeeper$ZooKeeperClient$$isConnectedOrExpiredCondition;
    private final scala.collection.concurrent.Map<String, ZNodeChangeHandler> kafka$zookeeper$ZooKeeperClient$$zNodeChangeHandlers;
    private final scala.collection.concurrent.Map<String, ZNodeChildChangeHandler> kafka$zookeeper$ZooKeeperClient$$zNodeChildChangeHandlers;
    private final Semaphore inFlightRequests;
    private final scala.collection.concurrent.Map<String, StateChangeHandler> kafka$zookeeper$ZooKeeperClient$$stateChangeHandlers;
    private final KafkaScheduler expiryScheduler;
    private final Set<String> metricNames;
    private final scala.collection.immutable.Map<Watcher.Event.KeeperState, Meter> kafka$zookeeper$ZooKeeperClient$$stateToMeterMap;
    private volatile ZooKeeper zooKeeper;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    public ZooKeeperClient$ZooKeeperClientWatcher$ ZooKeeperClientWatcher() {
        if (this.ZooKeeperClientWatcher$module == null) {
            this.ZooKeeperClientWatcher$lzycompute$1();
        }
        return this.ZooKeeperClientWatcher$module;
    }

    private Logger logger$lzycompute() {
        ZooKeeperClient zooKeeperClient = this;
        synchronized (zooKeeperClient) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private ReentrantReadWriteLock initializationLock() {
        return this.initializationLock;
    }

    public ReentrantLock kafka$zookeeper$ZooKeeperClient$$isConnectedOrExpiredLock() {
        return this.kafka$zookeeper$ZooKeeperClient$$isConnectedOrExpiredLock;
    }

    public Condition kafka$zookeeper$ZooKeeperClient$$isConnectedOrExpiredCondition() {
        return this.kafka$zookeeper$ZooKeeperClient$$isConnectedOrExpiredCondition;
    }

    public scala.collection.concurrent.Map<String, ZNodeChangeHandler> kafka$zookeeper$ZooKeeperClient$$zNodeChangeHandlers() {
        return this.kafka$zookeeper$ZooKeeperClient$$zNodeChangeHandlers;
    }

    public scala.collection.concurrent.Map<String, ZNodeChildChangeHandler> kafka$zookeeper$ZooKeeperClient$$zNodeChildChangeHandlers() {
        return this.kafka$zookeeper$ZooKeeperClient$$zNodeChildChangeHandlers;
    }

    private Semaphore inFlightRequests() {
        return this.inFlightRequests;
    }

    public scala.collection.concurrent.Map<String, StateChangeHandler> kafka$zookeeper$ZooKeeperClient$$stateChangeHandlers() {
        return this.kafka$zookeeper$ZooKeeperClient$$stateChangeHandlers;
    }

    public KafkaScheduler expiryScheduler() {
        return this.expiryScheduler;
    }

    private Set<String> metricNames() {
        return this.metricNames;
    }

    public scala.collection.immutable.Map<Watcher.Event.KeeperState, Meter> kafka$zookeeper$ZooKeeperClient$$stateToMeterMap() {
        return this.kafka$zookeeper$ZooKeeperClient$$stateToMeterMap;
    }

    private ZooKeeper zooKeeper() {
        return this.zooKeeper;
    }

    private void zooKeeper_$eq(ZooKeeper x$1) {
        this.zooKeeper = x$1;
    }

    @Override
    public MetricName metricName(String name, Map<String, String> metricTags) {
        return this.explicitMetricName(this.metricGroup, this.metricType, name, metricTags);
    }

    public ZooKeeper.States connectionState() {
        return this.zooKeeper().getState();
    }

    public <Req extends AsyncRequest> AsyncResponse handleRequest(Req request) {
        return (AsyncResponse)this.handleRequests((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AsyncRequest[]{request}))).head();
    }

    public <Req extends AsyncRequest> Seq<AsyncResponse> handleRequests(Seq<Req> requests) {
        Seq seq;
        if (requests.isEmpty()) {
            seq = (Seq)Seq$.MODULE$.empty();
        } else {
            CountDownLatch countDownLatch = new CountDownLatch(requests.size());
            ArrayBlockingQueue responseQueue = new ArrayBlockingQueue(requests.size());
            requests.foreach((Function1 & Serializable & scala.Serializable)request -> {
                ZooKeeperClient.$anonfun$handleRequests$1(this, countDownLatch, responseQueue, request);
                return BoxedUnit.UNIT;
            });
            countDownLatch.await();
            seq = ((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(responseQueue).asScala()).toBuffer();
        }
        return seq;
    }

    public <Req extends AsyncRequest> void send(Req request, Function1<AsyncResponse, BoxedUnit> processResponse) {
        long sendTimeMs = this.time.hiResClockMs();
        Req Req = request;
        if (Req instanceof ExistsRequest) {
            ExistsRequest existsRequest = (ExistsRequest)Req;
            String path = existsRequest.path();
            Option<Object> ctx = existsRequest.ctx();
            this.zooKeeper().exists(path, this.shouldWatch(request), new AsyncCallback.StatCallback(this, processResponse, sendTimeMs){
                private final /* synthetic */ ZooKeeperClient $outer;
                private final Function1 processResponse$1;
                private final long sendTimeMs$1;

                public void processResult(int rc, String path, Object ctx, Stat stat) {
                    ZooKeeperClient.kafka$zookeeper$ZooKeeperClient$$callback$1(new ExistsResponse(KeeperException.Code.get((int)rc), path, (Option<Object>)Option$.MODULE$.apply(ctx), stat, this.$outer.kafka$zookeeper$ZooKeeperClient$$responseMetadata$1(this.sendTimeMs$1)), this.processResponse$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.processResponse$1 = processResponse$1;
                    this.sendTimeMs$1 = sendTimeMs$1;
                }
            }, ctx.orNull(Predef$.MODULE$.$conforms()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (Req instanceof GetDataRequest) {
            GetDataRequest getDataRequest = (GetDataRequest)Req;
            String path = getDataRequest.path();
            Option<Object> ctx = getDataRequest.ctx();
            this.zooKeeper().getData(path, this.shouldWatch(request), new AsyncCallback.DataCallback(this, processResponse, sendTimeMs){
                private final /* synthetic */ ZooKeeperClient $outer;
                private final Function1 processResponse$1;
                private final long sendTimeMs$1;

                public void processResult(int rc, String path, Object ctx, byte[] data, Stat stat) {
                    ZooKeeperClient.kafka$zookeeper$ZooKeeperClient$$callback$1(new GetDataResponse(KeeperException.Code.get((int)rc), path, (Option<Object>)Option$.MODULE$.apply(ctx), data, stat, this.$outer.kafka$zookeeper$ZooKeeperClient$$responseMetadata$1(this.sendTimeMs$1)), this.processResponse$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.processResponse$1 = processResponse$1;
                    this.sendTimeMs$1 = sendTimeMs$1;
                }
            }, ctx.orNull(Predef$.MODULE$.$conforms()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (Req instanceof GetChildrenRequest) {
            GetChildrenRequest getChildrenRequest = (GetChildrenRequest)Req;
            String path = getChildrenRequest.path();
            Option<Object> ctx = getChildrenRequest.ctx();
            this.zooKeeper().getChildren(path, this.shouldWatch(request), new AsyncCallback.Children2Callback(this, processResponse, sendTimeMs){
                private final /* synthetic */ ZooKeeperClient $outer;
                private final Function1 processResponse$1;
                private final long sendTimeMs$1;

                public void processResult(int rc, String path, Object ctx, List<String> children, Stat stat) {
                    ZooKeeperClient.kafka$zookeeper$ZooKeeperClient$$callback$1(new GetChildrenResponse(KeeperException.Code.get((int)rc), path, (Option<Object>)Option$.MODULE$.apply(ctx), (Seq<String>)((Seq)Option$.MODULE$.apply(children).map((Function1 & Serializable & scala.Serializable)x$1 -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(x$1).asScala()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.empty())), stat, this.$outer.kafka$zookeeper$ZooKeeperClient$$responseMetadata$1(this.sendTimeMs$1)), this.processResponse$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.processResponse$1 = processResponse$1;
                    this.sendTimeMs$1 = sendTimeMs$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$processResult$1(java.util.List ), $anonfun$processResult$2()}, serializedLambda);
                }
            }, ctx.orNull(Predef$.MODULE$.$conforms()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (Req instanceof CreateRequest) {
            CreateRequest createRequest = (CreateRequest)Req;
            String path = createRequest.path();
            byte[] data = createRequest.data();
            Seq<ACL> acl = createRequest.acl();
            CreateMode createMode = createRequest.createMode();
            Option<Object> ctx = createRequest.ctx();
            this.zooKeeper().create(path, data, (List)JavaConverters$.MODULE$.seqAsJavaListConverter(acl).asJava(), createMode, new AsyncCallback.StringCallback(this, processResponse, sendTimeMs){
                private final /* synthetic */ ZooKeeperClient $outer;
                private final Function1 processResponse$1;
                private final long sendTimeMs$1;

                public void processResult(int rc, String path, Object ctx, String name) {
                    ZooKeeperClient.kafka$zookeeper$ZooKeeperClient$$callback$1(new CreateResponse(KeeperException.Code.get((int)rc), path, (Option<Object>)Option$.MODULE$.apply(ctx), name, this.$outer.kafka$zookeeper$ZooKeeperClient$$responseMetadata$1(this.sendTimeMs$1)), this.processResponse$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.processResponse$1 = processResponse$1;
                    this.sendTimeMs$1 = sendTimeMs$1;
                }
            }, ctx.orNull(Predef$.MODULE$.$conforms()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (Req instanceof SetDataRequest) {
            SetDataRequest setDataRequest = (SetDataRequest)Req;
            String path = setDataRequest.path();
            byte[] data = setDataRequest.data();
            int version = setDataRequest.version();
            Option<Object> ctx = setDataRequest.ctx();
            this.zooKeeper().setData(path, data, version, new AsyncCallback.StatCallback(this, processResponse, sendTimeMs){
                private final /* synthetic */ ZooKeeperClient $outer;
                private final Function1 processResponse$1;
                private final long sendTimeMs$1;

                public void processResult(int rc, String path, Object ctx, Stat stat) {
                    ZooKeeperClient.kafka$zookeeper$ZooKeeperClient$$callback$1(new SetDataResponse(KeeperException.Code.get((int)rc), path, (Option<Object>)Option$.MODULE$.apply(ctx), stat, this.$outer.kafka$zookeeper$ZooKeeperClient$$responseMetadata$1(this.sendTimeMs$1)), this.processResponse$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.processResponse$1 = processResponse$1;
                    this.sendTimeMs$1 = sendTimeMs$1;
                }
            }, ctx.orNull(Predef$.MODULE$.$conforms()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (Req instanceof DeleteRequest) {
            DeleteRequest deleteRequest = (DeleteRequest)Req;
            String path = deleteRequest.path();
            int version = deleteRequest.version();
            Option<Object> ctx = deleteRequest.ctx();
            this.zooKeeper().delete(path, version, new AsyncCallback.VoidCallback(this, processResponse, sendTimeMs){
                private final /* synthetic */ ZooKeeperClient $outer;
                private final Function1 processResponse$1;
                private final long sendTimeMs$1;

                public void processResult(int rc, String path, Object ctx) {
                    ZooKeeperClient.kafka$zookeeper$ZooKeeperClient$$callback$1(new DeleteResponse(KeeperException.Code.get((int)rc), path, (Option<Object>)Option$.MODULE$.apply(ctx), this.$outer.kafka$zookeeper$ZooKeeperClient$$responseMetadata$1(this.sendTimeMs$1)), this.processResponse$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.processResponse$1 = processResponse$1;
                    this.sendTimeMs$1 = sendTimeMs$1;
                }
            }, ctx.orNull(Predef$.MODULE$.$conforms()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (Req instanceof GetAclRequest) {
            GetAclRequest getAclRequest = (GetAclRequest)Req;
            String path = getAclRequest.path();
            Option<Object> ctx = getAclRequest.ctx();
            this.zooKeeper().getACL(path, null, new AsyncCallback.ACLCallback(this, processResponse, sendTimeMs){
                private final /* synthetic */ ZooKeeperClient $outer;
                private final Function1 processResponse$1;
                private final long sendTimeMs$1;

                public void processResult(int rc, String path, Object ctx, List<ACL> acl, Stat stat) {
                    ZooKeeperClient.kafka$zookeeper$ZooKeeperClient$$callback$1(new GetAclResponse(KeeperException.Code.get((int)rc), path, (Option<Object>)Option$.MODULE$.apply(ctx), (Seq<ACL>)((Seq)Option$.MODULE$.apply(acl).map((Function1 & Serializable & scala.Serializable)x$2 -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(x$2).asScala()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.empty())), stat, this.$outer.kafka$zookeeper$ZooKeeperClient$$responseMetadata$1(this.sendTimeMs$1)), this.processResponse$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.processResponse$1 = processResponse$1;
                    this.sendTimeMs$1 = sendTimeMs$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$processResult$3(java.util.List ), $anonfun$processResult$4()}, serializedLambda);
                }
            }, ctx.orNull(Predef$.MODULE$.$conforms()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (Req instanceof SetAclRequest) {
            SetAclRequest setAclRequest = (SetAclRequest)Req;
            String path = setAclRequest.path();
            Seq<ACL> acl = setAclRequest.acl();
            int version = setAclRequest.version();
            Option<Object> ctx = setAclRequest.ctx();
            this.zooKeeper().setACL(path, (List)JavaConverters$.MODULE$.seqAsJavaListConverter(acl).asJava(), version, new AsyncCallback.StatCallback(this, processResponse, sendTimeMs){
                private final /* synthetic */ ZooKeeperClient $outer;
                private final Function1 processResponse$1;
                private final long sendTimeMs$1;

                public void processResult(int rc, String path, Object ctx, Stat stat) {
                    ZooKeeperClient.kafka$zookeeper$ZooKeeperClient$$callback$1(new SetAclResponse(KeeperException.Code.get((int)rc), path, (Option<Object>)Option$.MODULE$.apply(ctx), stat, this.$outer.kafka$zookeeper$ZooKeeperClient$$responseMetadata$1(this.sendTimeMs$1)), this.processResponse$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.processResponse$1 = processResponse$1;
                    this.sendTimeMs$1 = sendTimeMs$1;
                }
            }, ctx.orNull(Predef$.MODULE$.$conforms()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(Req);
        }
    }

    public void waitUntilConnected() {
        CoreUtils$.MODULE$.inLock(this.kafka$zookeeper$ZooKeeperClient$$isConnectedOrExpiredLock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.waitUntilConnected(Long.MAX_VALUE, TimeUnit.MILLISECONDS));
    }

    private void waitUntilConnected(long timeout, TimeUnit timeUnit) {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Waiting until connected.");
        LongRef nanos = LongRef.create((long)timeUnit.toNanos(timeout));
        CoreUtils$.MODULE$.inLock(this.kafka$zookeeper$ZooKeeperClient$$isConnectedOrExpiredLock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ZooKeeper.States state = this.connectionState();
            while (!state.isConnected() && state.isAlive()) {
                if (nanos$1.elem <= 0L) {
                    throw new ZooKeeperClientTimeoutException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Timed out waiting for connection while in state: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{state})));
                }
                nanos$1.elem = this.kafka$zookeeper$ZooKeeperClient$$isConnectedOrExpiredCondition().awaitNanos(nanos$1.elem);
                state = this.connectionState();
            }
            ZooKeeper.States states = state;
            ZooKeeper.States states2 = ZooKeeper.States.AUTH_FAILED;
            if (!(states != null ? !states.equals(states2) : states2 != null)) {
                throw new ZooKeeperClientAuthFailedException("Auth failed either before or while waiting for connection");
            }
            ZooKeeper.States states3 = state;
            ZooKeeper.States states4 = ZooKeeper.States.CLOSED;
            if (!(states3 != null ? !states3.equals(states4) : states4 != null)) {
                throw new ZooKeeperClientExpiredException("Session expired either before or while waiting for connection");
            }
        });
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Connected.");
    }

    private boolean shouldWatch(AsyncRequest request) {
        boolean bl;
        AsyncRequest asyncRequest = request;
        if (asyncRequest instanceof GetChildrenRequest) {
            bl = this.kafka$zookeeper$ZooKeeperClient$$zNodeChildChangeHandlers().contains((Object)request.path());
        } else {
            boolean bl2 = asyncRequest instanceof ExistsRequest ? true : asyncRequest instanceof GetDataRequest;
            if (bl2) {
                bl = this.kafka$zookeeper$ZooKeeperClient$$zNodeChangeHandlers().contains((Object)request.path());
            } else {
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Request ", " is not watchable"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{request})));
            }
        }
        return bl;
    }

    public void registerZNodeChangeHandler(ZNodeChangeHandler zNodeChangeHandler) {
        this.kafka$zookeeper$ZooKeeperClient$$zNodeChangeHandlers().put((Object)zNodeChangeHandler.path(), (Object)zNodeChangeHandler);
    }

    public void unregisterZNodeChangeHandler(String path) {
        this.kafka$zookeeper$ZooKeeperClient$$zNodeChangeHandlers().remove((Object)path);
    }

    public void registerZNodeChildChangeHandler(ZNodeChildChangeHandler zNodeChildChangeHandler) {
        this.kafka$zookeeper$ZooKeeperClient$$zNodeChildChangeHandlers().put((Object)zNodeChildChangeHandler.path(), (Object)zNodeChildChangeHandler);
    }

    public void unregisterZNodeChildChangeHandler(String path) {
        this.kafka$zookeeper$ZooKeeperClient$$zNodeChildChangeHandlers().remove((Object)path);
    }

    public void registerStateChangeHandler(StateChangeHandler stateChangeHandler) {
        CoreUtils$.MODULE$.inReadLock(this.initializationLock(), (Function0 & Serializable & scala.Serializable)() -> stateChangeHandler != null ? this.kafka$zookeeper$ZooKeeperClient$$stateChangeHandlers().put((Object)stateChangeHandler.name(), (Object)stateChangeHandler) : BoxedUnit.UNIT);
    }

    public void unregisterStateChangeHandler(String name) {
        CoreUtils$.MODULE$.inReadLock(this.initializationLock(), (Function0 & Serializable & scala.Serializable)() -> this.kafka$zookeeper$ZooKeeperClient$$stateChangeHandlers().remove((Object)name));
    }

    public void close() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Closing.");
        CoreUtils$.MODULE$.inWriteLock(this.initializationLock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.kafka$zookeeper$ZooKeeperClient$$zNodeChangeHandlers().clear();
            this.kafka$zookeeper$ZooKeeperClient$$zNodeChildChangeHandlers().clear();
            this.kafka$zookeeper$ZooKeeperClient$$stateChangeHandlers().clear();
            this.zooKeeper().close();
            this.metricNames().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                this.removeMetric(x$3, this.removeMetric$default$2());
                return BoxedUnit.UNIT;
            });
        });
        this.expiryScheduler().shutdown();
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Closed.");
    }

    public long sessionId() {
        return BoxesRunTime.unboxToLong(CoreUtils$.MODULE$.inReadLock(this.initializationLock(), (JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> this.zooKeeper().getSessionId()));
    }

    public ZooKeeper currentZooKeeper() {
        return (ZooKeeper)CoreUtils$.MODULE$.inReadLock(this.initializationLock(), (Function0 & Serializable & scala.Serializable)() -> this.zooKeeper());
    }

    private void initialize() {
        if (!this.connectionState().isAlive()) {
            this.zooKeeper().close();
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Initializing a new session to ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.connectString})));
            boolean connected = false;
            while (!connected) {
                try {
                    this.zooKeeper_$eq(new ZooKeeper(this.connectString, this.sessionTimeoutMs, (Watcher)this.ZooKeeperClientWatcher()));
                    connected = true;
                }
                catch (Exception e) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error when recreating ZooKeeper, retrying after a short sleep", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                    Thread.sleep(1000L);
                }
            }
        }
    }

    public void reinitialize() {
        this.zooKeeper().close();
        this.initialize();
    }

    public void scheduleSessionExpiryHandler() {
        this.expiryScheduler().schedule("zk-session-expired", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> CoreUtils$.MODULE$.inWriteLock(this.initializationLock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Session expired.");
            this.kafka$zookeeper$ZooKeeperClient$$stateChangeHandlers().values().foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                x$4.beforeInitializingSession();
                return BoxedUnit.UNIT;
            });
            this.initialize();
            this.kafka$zookeeper$ZooKeeperClient$$stateChangeHandlers().values().foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
                x$5.afterInitializingSession();
                return BoxedUnit.UNIT;
            });
        }), 0L, -1L, TimeUnit.MILLISECONDS);
    }

    private final void ZooKeeperClientWatcher$lzycompute$1() {
        ZooKeeperClient zooKeeperClient = this;
        synchronized (zooKeeperClient) {
            if (this.ZooKeeperClientWatcher$module == null) {
                this.ZooKeeperClientWatcher$module = new ZooKeeperClient$ZooKeeperClientWatcher$(this);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$handleRequests$3(ZooKeeperClient $this, CountDownLatch countDownLatch$1, ArrayBlockingQueue responseQueue$1, AsyncResponse response) {
        responseQueue$1.add(response);
        $this.inFlightRequests().release();
        countDownLatch$1.countDown();
    }

    public static final /* synthetic */ void $anonfun$handleRequests$1(ZooKeeperClient $this, CountDownLatch countDownLatch$1, ArrayBlockingQueue responseQueue$1, AsyncRequest request) {
        $this.inFlightRequests().acquire();
        try {
            CoreUtils$.MODULE$.inReadLock($this.initializationLock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.send(request, (Function1<AsyncResponse, BoxedUnit>)(Function1 & Serializable & scala.Serializable)response -> {
                ZooKeeperClient.$anonfun$handleRequests$3($this, countDownLatch$1, responseQueue$1, response);
                return BoxedUnit.UNIT;
            }));
        }
        catch (Throwable e) {
            $this.inFlightRequests().release();
            throw e;
        }
    }

    public static final void kafka$zookeeper$ZooKeeperClient$$callback$1(AsyncResponse response, Function1 processResponse$1) {
        processResponse$1.apply((Object)response);
    }

    public final ResponseMetadata kafka$zookeeper$ZooKeeperClient$$responseMetadata$1(long sendTimeMs) {
        return new ResponseMetadata(sendTimeMs, this.time.hiResClockMs());
    }

    public ZooKeeperClient(String connectString, int sessionTimeoutMs, int connectionTimeoutMs, int maxInFlightRequests, Time time, String metricGroup, String metricType) {
        this.connectString = connectString;
        this.sessionTimeoutMs = sessionTimeoutMs;
        this.time = time;
        this.metricGroup = metricGroup;
        this.metricType = metricType;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.logIdent_$eq("[ZooKeeperClient] ");
        this.initializationLock = new ReentrantReadWriteLock();
        this.kafka$zookeeper$ZooKeeperClient$$isConnectedOrExpiredLock = new ReentrantLock();
        this.kafka$zookeeper$ZooKeeperClient$$isConnectedOrExpiredCondition = this.kafka$zookeeper$ZooKeeperClient$$isConnectedOrExpiredLock().newCondition();
        this.kafka$zookeeper$ZooKeeperClient$$zNodeChangeHandlers = (scala.collection.concurrent.Map)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(new ConcurrentHashMap()).asScala();
        this.kafka$zookeeper$ZooKeeperClient$$zNodeChildChangeHandlers = (scala.collection.concurrent.Map)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(new ConcurrentHashMap()).asScala();
        this.inFlightRequests = new Semaphore(maxInFlightRequests);
        this.kafka$zookeeper$ZooKeeperClient$$stateChangeHandlers = (scala.collection.concurrent.Map)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(new ConcurrentHashMap()).asScala();
        this.expiryScheduler = new KafkaScheduler(0, "zk-session-expiry-handler", KafkaScheduler$.MODULE$.$lessinit$greater$default$3());
        this.metricNames = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        scala.collection.immutable.Map stateToEventTypeMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Watcher.Event.KeeperState.Disconnected), (Object)"Disconnects"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Watcher.Event.KeeperState.SyncConnected), (Object)"SyncConnects"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Watcher.Event.KeeperState.AuthFailed), (Object)"AuthFailures"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Watcher.Event.KeeperState.ConnectedReadOnly), (Object)"ReadOnlyConnects"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Watcher.Event.KeeperState.SaslAuthenticated), (Object)"SaslAuthentications"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Watcher.Event.KeeperState.Expired), (Object)"Expires")}));
        this.kafka$zookeeper$ZooKeeperClient$$stateToMeterMap = (scala.collection.immutable.Map)stateToEventTypeMap.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Watcher.Event.KeeperState state = (Watcher.Event.KeeperState)tuple2._1();
            String eventType = (String)tuple2._2();
            String name = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ZooKeeper", "PerSec"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{eventType}));
            this.metricNames().$plus$eq((Object)name);
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)state), (Object)this.newMeter(name, eventType.toLowerCase(Locale.ROOT), TimeUnit.SECONDS, this.newMeter$default$4()));
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Initializing a new session to ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.connectString})));
        this.zooKeeper = new ZooKeeper(connectString, sessionTimeoutMs, (Watcher)this.ZooKeeperClientWatcher());
        this.newGauge("SessionState", new Gauge<String>(this){
            private final /* synthetic */ ZooKeeperClient $outer;

            public String value() {
                return (String)Option$.MODULE$.apply((Object)this.$outer.connectionState().toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "DISCONNECTED");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$value$1()}, serializedLambda);
            }
        }, this.newGauge$default$3());
        this.metricNames().$plus$eq((Object)"SessionState");
        this.expiryScheduler().startup();
        this.waitUntilConnected(connectionTimeoutMs, TimeUnit.MILLISECONDS);
    }
}

