/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.zk;

import com.typesafe.scalalogging.Logger;
import io.confluent.kafka.admin.AdminOperationException;
import io.confluent.kafka.admin.AdminUtils$;
import io.confluent.kafka.admin.BrokerMetadata;
import io.confluent.kafka.admin.RackAwareMode;
import io.confluent.kafka.admin.RackAwareMode$Disabled$;
import io.confluent.kafka.admin.RackAwareMode$Enforced$;
import io.confluent.kafka.admin.RackAwareMode$Safe$;
import io.confluent.kafka.cluster.Broker;
import io.confluent.kafka.common.TopicAlreadyMarkedForDeletionException;
import io.confluent.kafka.log.LogConfig$;
import io.confluent.kafka.server.ConfigEntityName$;
import io.confluent.kafka.server.ConfigType$;
import io.confluent.kafka.server.DynamicConfig$Broker$;
import io.confluent.kafka.server.DynamicConfig$Client$;
import io.confluent.kafka.server.DynamicConfig$User$;
import io.confluent.kafka.utils.Logging;
import io.confluent.kafka.zk.KafkaZkClient;
import io.confluent.kafka.zk.TopicZNode$;
import io.confluent.org.apache.kafka.common.TopicPartition;
import io.confluent.org.apache.kafka.common.errors.BrokerNotAvailableException;
import io.confluent.org.apache.kafka.common.errors.InvalidPartitionsException;
import io.confluent.org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import io.confluent.org.apache.kafka.common.errors.InvalidTopicException;
import io.confluent.org.apache.kafka.common.errors.TopicExistsException;
import io.confluent.org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import io.confluent.org.apache.kafka.common.internals.Topic;
import java.io.Serializable;
import java.util.Properties;
import org.apache.zookeeper.KeeperException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\tUa\u0001B\u0001\u0003\u0001\u001d\u0011Q\"\u00113nS:T6n\u00117jK:$(BA\u0002\u0005\u0003\tQ8NC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001\u0001\u0005\u000f!\tIA\"D\u0001\u000b\u0015\u0005Y\u0011!B:dC2\f\u0017BA\u0007\u000b\u0005\u0019\te.\u001f*fMB\u0011qBE\u0007\u0002!)\u0011\u0011\u0003B\u0001\u0006kRLGn]\u0005\u0003'A\u0011q\u0001T8hO&tw\r\u0003\u0005\u0016\u0001\t\u0005\t\u0015!\u0003\u0017\u0003!Q8n\u00117jK:$\bCA\f\u0019\u001b\u0005\u0011\u0011BA\r\u0003\u00055Y\u0015MZ6b5.\u001cE.[3oi\")1\u0004\u0001C\u00019\u00051A(\u001b8jiz\"\"!\b\u0010\u0011\u0005]\u0001\u0001\"B\u000b\u001b\u0001\u00041\u0002\"\u0002\u0011\u0001\t\u0003\t\u0013aC2sK\u0006$X\rV8qS\u000e$bAI\u00133oe\u001a\u0005CA\u0005$\u0013\t!#B\u0001\u0003V]&$\b\"\u0002\u0014 \u0001\u00049\u0013!\u0002;pa&\u001c\u0007C\u0001\u00150\u001d\tIS\u0006\u0005\u0002+\u00155\t1F\u0003\u0002-\r\u00051AH]8pizJ!A\f\u0006\u0002\rA\u0013X\rZ3g\u0013\t\u0001\u0014G\u0001\u0004TiJLgn\u001a\u0006\u0003])AQaM\u0010A\u0002Q\n!\u0002]1si&$\u0018n\u001c8t!\tIQ'\u0003\u00027\u0015\t\u0019\u0011J\u001c;\t\u000baz\u0002\u0019\u0001\u001b\u0002#I,\u0007\u000f\\5dCRLwN\u001c$bGR|'\u000fC\u0004;?A\u0005\t\u0019A\u001e\u0002\u0017Q|\u0007/[2D_:4\u0017n\u001a\t\u0003y\u0005k\u0011!\u0010\u0006\u0003}}\nA!\u001e;jY*\t\u0001)\u0001\u0003kCZ\f\u0017B\u0001\">\u0005)\u0001&o\u001c9feRLWm\u001d\u0005\b\t~\u0001\n\u00111\u0001F\u00035\u0011\u0018mY6Bo\u0006\u0014X-T8eKB\u0011a)S\u0007\u0002\u000f*\u0011\u0001\nB\u0001\u0006C\u0012l\u0017N\\\u0005\u0003\u0015\u001e\u0013QBU1dW\u0006;\u0018M]3N_\u0012,\u0007\"\u0002'\u0001\t\u0003i\u0015AE4fi\n\u0013xn[3s\u001b\u0016$\u0018\rZ1uCN$2AT,Y!\ry%\u000bV\u0007\u0002!*\u0011\u0011KC\u0001\u000bG>dG.Z2uS>t\u0017BA*Q\u0005\r\u0019V-\u001d\t\u0003\rVK!AV$\u0003\u001d\t\u0013xn[3s\u001b\u0016$\u0018\rZ1uC\"9Ai\u0013I\u0001\u0002\u0004)\u0005bB-L!\u0003\u0005\rAW\u0001\u000bEJ|7.\u001a:MSN$\bcA\u0005\\;&\u0011AL\u0003\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007=\u0013F\u0007C\u0003`\u0001\u0011\u0005\u0001-\u0001\u0018de\u0016\fG/Z(s+B$\u0017\r^3U_BL7\rU1si&$\u0018n\u001c8BgNLwM\\7f]R\u0004\u0016\r\u001e5J]j[E#\u0002\u0012bE\u001eL\u0007\"\u0002\u0014_\u0001\u00049\u0003\"B2_\u0001\u0004!\u0017A\u00079beRLG/[8o%\u0016\u0004H.[2b\u0003N\u001c\u0018n\u001a8nK:$\b\u0003B(fiuK!A\u001a)\u0003\u00075\u000b\u0007\u000fC\u0004i=B\u0005\t\u0019A\u001e\u0002\r\r|gNZ5h\u0011\u001dQg\f%AA\u0002-\fa!\u001e9eCR,\u0007CA\u0005m\u0013\ti'BA\u0004C_>dW-\u00198\t\u000b=\u0004A\u0011\u00019\u00027Y\fG.\u001b3bi\u0016\u001c%/Z1uK>\u0013X\u000b\u001d3bi\u0016$v\u000e]5d)\u0015\u0011\u0013O]:u\u0011\u00151c\u000e1\u0001(\u0011\u0015\u0019g\u000e1\u0001e\u0011\u0015Ag\u000e1\u0001<\u0011\u0015Qg\u000e1\u0001l\u0011\u00151\b\u0001\"\u0003x\u0003u9(/\u001b;f)>\u0004\u0018n\u0019)beRLG/[8o\u0003N\u001c\u0018n\u001a8nK:$H\u0003\u0002\u0012ysnDQAJ;A\u0002\u001dBQA_;A\u0002\u0011\f\u0011C]3qY&\u001c\u0017-Q:tS\u001etW.\u001a8u\u0011\u0015QW\u000f1\u0001l\u0011\u0015i\b\u0001\"\u0001\u007f\u0003-!W\r\\3uKR{\u0007/[2\u0015\u0005\tz\b\"\u0002\u0014}\u0001\u00049\u0003bBA\u0002\u0001\u0011\u0005\u0011QA\u0001\u000eC\u0012$\u0007+\u0019:uSRLwN\\:\u0015\u001b\u0011\f9!!\u0003\u0002\u000e\u0005E\u0011QCA\r\u0011\u00191\u0013\u0011\u0001a\u0001O!9\u00111BA\u0001\u0001\u0004!\u0017AE3ySN$\u0018N\\4BgNLwM\\7f]RDq!a\u0004\u0002\u0002\u0001\u0007a*\u0001\u0006bY2\u0014%o\\6feND\u0011\"a\u0005\u0002\u0002A\u0005\t\u0019\u0001\u001b\u0002\u001b9,X\u000eU1si&$\u0018n\u001c8t\u0011%Q\u0018\u0011\u0001I\u0001\u0002\u0004\t9\u0002E\u0002\n7\u0012D\u0011\"a\u0007\u0002\u0002A\u0005\t\u0019A6\u0002\u0019Y\fG.\u001b3bi\u0016|e\u000e\\=\t\u000f\u0005}\u0001\u0001\"\u0003\u0002\"\u0005Ib/\u00197jI\u0006$XMU3qY&\u001c\u0017-Q:tS\u001etW.\u001a8u)\u001d\u0011\u00131EA\u0013\u0003SAaA_A\u000f\u0001\u0004!\u0007bBA\u0014\u0003;\u0001\r\u0001N\u0001\u001aKb\u0004Xm\u0019;fIJ+\u0007\u000f\\5dCRLwN\u001c$bGR|'\u000f\u0003\u0005\u0002,\u0005u\u0001\u0019AA\u0017\u0003I\tg/Y5mC\ndWM\u0011:pW\u0016\u0014\u0018\nZ:\u0011\t!\ny\u0003N\u0005\u0004\u0003c\t$aA*fi\"9\u0011Q\u0007\u0001\u0005\u0002\u0005]\u0012!D2iC:<WmQ8oM&<7\u000fF\u0004#\u0003s\ti$!\u0011\t\u000f\u0005m\u00121\u0007a\u0001O\u0005QQM\u001c;jif$\u0016\u0010]3\t\u000f\u0005}\u00121\u0007a\u0001O\u0005QQM\u001c;jift\u0015-\\3\t\u000f\u0005\r\u00131\u0007a\u0001w\u000591m\u001c8gS\u001e\u001c\bbBA$\u0001\u0011\u0005\u0011\u0011J\u0001\u0015G\"\fgnZ3DY&,g\u000e^%e\u0007>tg-[4\u0015\u000b\t\nY%a\u0014\t\u000f\u00055\u0013Q\ta\u0001O\u0005\t2/\u00198ji&TX\rZ\"mS\u0016tG/\u00133\t\u000f\u0005\r\u0013Q\ta\u0001w!9\u00111\u000b\u0001\u0005\u0002\u0005U\u0013AH2iC:<W-V:fe>\u0013Xk]3s\u00072LWM\u001c;JI\u000e{gNZ5h)\u0015\u0011\u0013qKA.\u0011\u001d\tI&!\u0015A\u0002\u001d\n1c]1oSRL'0\u001a3F]RLG/\u001f(b[\u0016Dq!a\u0011\u0002R\u0001\u00071\bC\u0004\u0002`\u0001!\t!!\u0019\u0002'Y\fG.\u001b3bi\u0016$v\u000e]5d\u0007>tg-[4\u0015\u000b\t\n\u0019'!\u001a\t\r\u0019\ni\u00061\u0001(\u0011\u001d\t\u0019%!\u0018A\u0002mBq!!\u001b\u0001\t\u0003\tY'A\tdQ\u0006tw-\u001a+pa&\u001c7i\u001c8gS\u001e$RAIA7\u0003_BaAJA4\u0001\u00049\u0003bBA\"\u0003O\u0002\ra\u000f\u0005\b\u0003g\u0002A\u0011AA;\u0003I\u0019\u0007.\u00198hK\n\u0013xn[3s\u0007>tg-[4\u0015\u000b\t\n9(a\u001f\t\u000f\u0005e\u0014\u0011\u000fa\u0001;\u00069!M]8lKJ\u001c\bbBA\"\u0003c\u0002\ra\u000f\u0005\b\u0003g\u0002A\u0011AA@)\u0015\u0011\u0013\u0011QAD\u0011!\t\u0019)! A\u0002\u0005\u0015\u0015A\u00022s_.,'\u000fE\u0002\n7RBq!a\u0011\u0002~\u0001\u00071\bC\u0004\u0002\f\u0002!\t!!$\u0002)Y\fG.\u001b3bi\u0016\u0014%o\\6fe\u000e{gNZ5h)\r\u0011\u0013q\u0012\u0005\b\u0003\u0007\nI\t1\u0001<\u0011\u001d\t\u0019\n\u0001C\u0005\u0003+\u000b!c\u00195b]\u001e,WI\u001c;jif\u001cuN\u001c4jOR9!%a&\u0002\u001c\u0006}\u0005bBAM\u0003#\u0003\raJ\u0001\u000fe>|G/\u00128uSRLH+\u001f9f\u0011\u001d\ti*!%A\u0002\u001d\nqCZ;mYN\u000bg.\u001b;ju\u0016$WI\u001c;jift\u0015-\\3\t\u000f\u0005\r\u0013\u0011\u0013a\u0001w!9\u00111\u0015\u0001\u0005\u0002\u0005\u0015\u0016!\u00054fi\u000eDWI\u001c;jif\u001cuN\u001c4jOR)1(a*\u0002*\"9\u0011\u0011TAQ\u0001\u00049\u0003bBA-\u0003C\u0003\ra\n\u0005\b\u0003[\u0003A\u0011AAX\u0003I9W\r^!mYR{\u0007/[2D_:4\u0017nZ:\u0015\u0005\u0005E\u0006\u0003B(fOmBq!!.\u0001\t\u0003\t9,A\u000bgKR\u001c\u0007.\u00117m\u000b:$\u0018\u000e^=D_:4\u0017nZ:\u0015\t\u0005E\u0016\u0011\u0018\u0005\b\u0003w\t\u0019\f1\u0001(\u0011\u001d\ti\f\u0001C\u0001\u0003\u007f\u000b!DZ3uG\"\fE\u000e\\\"iS2$WI\u001c;jif\u001cuN\u001c4jON$b!!-\u0002B\u0006\r\u0007bBAM\u0003w\u0003\ra\n\u0005\b\u0003\u000b\fY\f1\u0001(\u0003=\u0019\u0007.\u001b7e\u000b:$\u0018\u000e^=UsB,\u0007\"CAe\u0001E\u0005I\u0011AAf\u0003q9W\r\u001e\"s_.,'/T3uC\u0012\fG/Y:%I\u00164\u0017-\u001e7uIE*\"!!4+\u0007\u0015\u000bym\u000b\u0002\u0002RB!\u00111[Ao\u001b\t\t)N\u0003\u0003\u0002X\u0006e\u0017!C;oG\",7m[3e\u0015\r\tYNC\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAp\u0003+\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%\t\u0019\u000fAI\u0001\n\u0003\t)/\u0001\u000fhKR\u0014%o\\6fe6+G/\u00193bi\u0006\u001cH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005\u001d(f\u0001.\u0002P\"I\u00111\u001e\u0001\u0012\u0002\u0013\u0005\u0011Q^\u00019GJ,\u0017\r^3PeV\u0003H-\u0019;f)>\u0004\u0018n\u0019)beRLG/[8o\u0003N\u001c\u0018n\u001a8nK:$\b+\u0019;i\u0013:T6\n\n3fM\u0006,H\u000e\u001e\u00134+\t\tyOK\u0002<\u0003\u001fD\u0011\"a=\u0001#\u0003%\t!!>\u0002q\r\u0014X-\u0019;f\u001fJ,\u0006\u000fZ1uKR{\u0007/[2QCJ$\u0018\u000e^5p]\u0006\u001b8/[4o[\u0016tG\u000fU1uQ&s'l\u0013\u0013eK\u001a\fW\u000f\u001c;%iU\u0011\u0011q\u001f\u0016\u0004W\u0006=\u0007\"CA~\u0001E\u0005I\u0011AAw\u0003U\u0019'/Z1uKR{\u0007/[2%I\u00164\u0017-\u001e7uIQB\u0011\"a@\u0001#\u0003%\t!a3\u0002+\r\u0014X-\u0019;f)>\u0004\u0018n\u0019\u0013eK\u001a\fW\u000f\u001c;%k!I!1\u0001\u0001\u0012\u0002\u0013\u0005!QA\u0001\u0018C\u0012$\u0007+\u0019:uSRLwN\\:%I\u00164\u0017-\u001e7uIQ*\"Aa\u0002+\u0007Q\ny\rC\u0005\u0003\f\u0001\t\n\u0011\"\u0001\u0003\u000e\u00059\u0012\r\u001a3QCJ$\u0018\u000e^5p]N$C-\u001a4bk2$H%N\u000b\u0003\u0005\u001fQC!a\u0006\u0002P\"I!1\u0003\u0001\u0012\u0002\u0013\u0005\u0011Q_\u0001\u0018C\u0012$\u0007+\u0019:uSRLwN\\:%I\u00164\u0017-\u001e7uIY\u0002")
public class AdminZkClient
implements Logging {
    private final KafkaZkClient zkClient;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        AdminZkClient adminZkClient = this;
        synchronized (adminZkClient) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public void createTopic(String topic, int partitions, int replicationFactor, Properties topicConfig, RackAwareMode rackAwareMode) {
        Seq<BrokerMetadata> brokerMetadatas = this.getBrokerMetadatas(rackAwareMode, this.getBrokerMetadatas$default$2());
        Map<Object, Seq<Object>> replicaAssignment = AdminUtils$.MODULE$.assignReplicasToBrokers(brokerMetadatas, partitions, replicationFactor, AdminUtils$.MODULE$.assignReplicasToBrokers$default$4(), AdminUtils$.MODULE$.assignReplicasToBrokers$default$5());
        this.createOrUpdateTopicPartitionAssignmentPathInZK(topic, replicaAssignment, topicConfig, this.createOrUpdateTopicPartitionAssignmentPathInZK$default$4());
    }

    public Properties createTopic$default$4() {
        return new Properties();
    }

    public RackAwareMode createTopic$default$5() {
        return RackAwareMode$Enforced$.MODULE$;
    }

    public Seq<BrokerMetadata> getBrokerMetadatas(RackAwareMode rackAwareMode, Option<Seq<Object>> brokerList) {
        RackAwareMode rackAwareMode2;
        Seq<Broker> allBrokers = this.zkClient.getAllBrokersInCluster();
        Seq brokers = (Seq)brokerList.map((Function1 & Serializable & scala.Serializable)brokerIds -> (Seq)allBrokers.filter((Function1 & Serializable & scala.Serializable)b -> BoxesRunTime.boxToBoolean((boolean)brokerIds.contains((Object)BoxesRunTime.boxToInteger((int)b.id()))))).getOrElse((Function0 & Serializable & scala.Serializable)() -> allBrokers);
        Seq brokersWithRack = (Seq)brokers.filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)AdminZkClient.$anonfun$getBrokerMetadatas$4(x$1)));
        RackAwareMode rackAwareMode3 = rackAwareMode;
        RackAwareMode$Enforced$ rackAwareMode$Enforced$ = RackAwareMode$Enforced$.MODULE$;
        if (!(rackAwareMode3 != null ? !rackAwareMode3.equals(rackAwareMode$Enforced$) : rackAwareMode$Enforced$ != null)) {
            if (brokersWithRack.nonEmpty() && brokersWithRack.size() < brokers.size()) {
                throw new AdminOperationException("Not all brokers have rack information. Add --disable-rack-aware in command line to make replica assignment without rack information.");
            }
        }
        Seq seq = RackAwareMode$Disabled$.MODULE$.equals(rackAwareMode2 = rackAwareMode) ? (Seq)brokers.map((Function1 & Serializable & scala.Serializable)broker -> new BrokerMetadata(broker.id(), (Option<String>)None$.MODULE$), Seq$.MODULE$.canBuildFrom()) : (RackAwareMode$Safe$.MODULE$.equals(rackAwareMode2) && brokersWithRack.size() < brokers.size() ? (Seq)brokers.map((Function1 & Serializable & scala.Serializable)broker -> new BrokerMetadata(broker.id(), (Option<String>)None$.MODULE$), Seq$.MODULE$.canBuildFrom()) : (Seq)brokers.map((Function1 & Serializable & scala.Serializable)broker -> new BrokerMetadata(broker.id(), broker.rack()), Seq$.MODULE$.canBuildFrom()));
        Seq brokerMetadatas = seq;
        return (Seq)brokerMetadatas.sortBy((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.id()), (Ordering)Ordering.Int$.MODULE$);
    }

    public RackAwareMode getBrokerMetadatas$default$1() {
        return RackAwareMode$Enforced$.MODULE$;
    }

    public Option<Seq<Object>> getBrokerMetadatas$default$2() {
        return None$.MODULE$;
    }

    public void createOrUpdateTopicPartitionAssignmentPathInZK(String topic, Map<Object, Seq<Object>> partitionReplicaAssignment, Properties config, boolean update) {
        this.validateCreateOrUpdateTopic(topic, partitionReplicaAssignment, config, update);
        if (!update) {
            this.zkClient.setOrCreateEntityConfigs(ConfigType$.MODULE$.Topic(), topic, config);
        }
        this.writeTopicPartitionAssignment(topic, partitionReplicaAssignment, update);
    }

    public Properties createOrUpdateTopicPartitionAssignmentPathInZK$default$3() {
        return new Properties();
    }

    public boolean createOrUpdateTopicPartitionAssignmentPathInZK$default$4() {
        return false;
    }

    public void validateCreateOrUpdateTopic(String topic, Map<Object, Seq<Object>> partitionReplicaAssignment, Properties config, boolean update) {
        block6: {
            Topic.validate(topic);
            if (!update) {
                if (this.zkClient.topicExists(topic)) {
                    throw new TopicExistsException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Topic '", "' already exists."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
                }
                if (Topic.hasCollisionChars(topic)) {
                    Seq<String> allTopics = this.zkClient.getAllTopicsInCluster();
                    if (allTopics.contains((Object)topic)) {
                        throw new TopicExistsException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Topic '", "' already exists."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
                    }
                    Seq collidingTopics = (Seq)allTopics.filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)AdminZkClient.$anonfun$validateCreateOrUpdateTopic$1(topic, x$3)));
                    if (collidingTopics.nonEmpty()) {
                        throw new InvalidTopicException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Topic '", "' collides with existing topics: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, collidingTopics.mkString(", ")})));
                    }
                }
            }
            if (((TraversableOnce)partitionReplicaAssignment.values().map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.size()), Iterable$.MODULE$.canBuildFrom())).toSet().size() != 1) {
                throw new InvalidReplicaAssignmentException("All partitions should have the same number of replicas");
            }
            partitionReplicaAssignment.values().foreach((Function1 & Serializable & scala.Serializable)reps -> {
                AdminZkClient.$anonfun$validateCreateOrUpdateTopic$3(partitionReplicaAssignment, reps);
                return BoxedUnit.UNIT;
            });
            if (update) break block6;
            LogConfig$.MODULE$.validate(config);
        }
    }

    private void writeTopicPartitionAssignment(String topic, Map<Object, Seq<Object>> replicaAssignment, boolean update) {
        try {
            scala.collection.immutable.Map assignment = ((TraversableOnce)replicaAssignment.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                int partitionId = tuple2._1$mcI$sp();
                Seq replicas = (Seq)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)new TopicPartition(topic, partitionId), (Object)replicas);
                return tuple22;
            }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            if (!update) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Topic creation " + assignment);
                this.zkClient.createTopicAssignment(topic, (scala.collection.immutable.Map<TopicPartition, Seq<Object>>)assignment);
            } else {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Topic update " + assignment);
                this.zkClient.setTopicAssignment(topic, (scala.collection.immutable.Map<TopicPartition, Seq<Object>>)assignment);
            }
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Updated path %s with %s for replica assignment")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{TopicZNode$.MODULE$.path(topic), assignment})));
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
            throw new TopicExistsException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Topic '", "' already exists."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
        }
        catch (Throwable e2) {
            throw new AdminOperationException(e2.toString());
        }
    }

    public void deleteTopic(String topic) {
        if (this.zkClient.topicExists(topic)) {
            try {
                this.zkClient.createDeleteTopicPath(topic);
            }
            catch (KeeperException.NodeExistsException nodeExistsException) {
                throw new TopicAlreadyMarkedForDeletionException(new StringOps(Predef$.MODULE$.augmentString("topic %s is already marked for deletion")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
            }
            catch (Throwable e) {
                throw new AdminOperationException(e.getMessage());
            }
        } else {
            throw new UnknownTopicOrPartitionException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Topic `", "` to delete does not exist"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
        }
    }

    public Map<Object, Seq<Object>> addPartitions(String topic, Map<Object, Seq<Object>> existingAssignment, Seq<BrokerMetadata> allBrokers, int numPartitions, Option<Map<Object, Seq<Object>>> replicaAssignment, boolean validateOnly) {
        Map proposedAssignment;
        block1: {
            Seq existingAssignmentPartition0 = (Seq)existingAssignment.getOrElse((Object)BoxesRunTime.boxToInteger((int)0), (Function0 & Serializable & scala.Serializable)() -> {
                throw new AdminOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected existing replica assignment for topic '", "', partition id 0 is missing. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Assignment: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{existingAssignment})));
            });
            int partitionsToAdd = numPartitions - existingAssignment.size();
            if (partitionsToAdd <= 0) {
                throw new InvalidPartitionsException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The number of partitions for a topic can only be increased. "})).s((Seq)Nil$.MODULE$) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Topic ", " currently has ", " partitions, "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, BoxesRunTime.boxToInteger((int)existingAssignment.size())})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " would not be an increase."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)numPartitions)})));
            }
            replicaAssignment.foreach((Function1 & Serializable & scala.Serializable)proposedReplicaAssignment -> {
                this.validateReplicaAssignment((Map<Object, Seq<Object>>)proposedReplicaAssignment, existingAssignmentPartition0.size(), (Set<Object>)((TraversableOnce)allBrokers.map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.id()), Seq$.MODULE$.canBuildFrom())).toSet());
                return BoxedUnit.UNIT;
            });
            Map proposedAssignmentForNewPartitions = (Map)replicaAssignment.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                int startIndex = package$.MODULE$.max(0, allBrokers.indexWhere((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)AdminZkClient.$anonfun$addPartitions$5(existingAssignmentPartition0, x$6))));
                return AdminUtils$.MODULE$.assignReplicasToBrokers(allBrokers, partitionsToAdd, existingAssignmentPartition0.size(), startIndex, existingAssignment.size());
            });
            proposedAssignment = existingAssignment.$plus$plus((GenTraversableOnce)proposedAssignmentForNewPartitions);
            if (validateOnly) break block1;
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Creating ", " partitions for '", "' with the following replica assignment: "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)partitionsToAdd), topic})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{proposedAssignmentForNewPartitions})));
            String x$8 = topic;
            Map x$9 = proposedAssignment;
            boolean x$10 = true;
            Properties x$11 = this.createOrUpdateTopicPartitionAssignmentPathInZK$default$3();
            this.createOrUpdateTopicPartitionAssignmentPathInZK(x$8, (Map<Object, Seq<Object>>)x$9, x$11, x$10);
        }
        return proposedAssignment;
    }

    public int addPartitions$default$4() {
        return 1;
    }

    public Option<Map<Object, Seq<Object>>> addPartitions$default$5() {
        return None$.MODULE$;
    }

    public boolean addPartitions$default$6() {
        return false;
    }

    private void validateReplicaAssignment(Map<Object, Seq<Object>> replicaAssignment, int expectedReplicationFactor, Set<Object> availableBrokerIds) {
        replicaAssignment.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Seq replicas;
            int partitionId;
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                partitionId = tuple2._1$mcI$sp();
                replicas = (Seq)tuple2._2();
                if (replicas.isEmpty()) {
                    throw new InvalidReplicaAssignmentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot have replication factor of 0 for partition id ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)partitionId)})));
                }
                if (replicas.size() != replicas.toSet().size()) {
                    throw new InvalidReplicaAssignmentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Duplicate brokers not allowed in replica assignment: "})).s((Seq)Nil$.MODULE$) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " for partition id ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{replicas.mkString(", "), BoxesRunTime.boxToInteger((int)partitionId)})));
                }
                if (!replicas.toSet().subsetOf((GenSet)availableBrokerIds)) {
                    throw new BrokerNotAvailableException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Some brokers specified for partition id ", " are not available. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)partitionId)})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Specified brokers: ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{replicas.mkString(", ")})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"available brokers: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{availableBrokerIds.mkString(", ")})));
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partitionId)), (Object)BoxesRunTime.boxToInteger((int)replicas.size()));
            return tuple22;
        });
        Map badRepFactors = (Map)replicaAssignment.collect((PartialFunction)new scala.Serializable(null, expectedReplicationFactor){
            public static final long serialVersionUID = 0L;
            private final int expectedReplicationFactor$1;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<Object, Seq<Object>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    int partition = A1._1$mcI$sp();
                    Seq replicas = (Seq)A1._2();
                    if (replicas.size() != this.expectedReplicationFactor$1) {
                        object = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition)), (Object)BoxesRunTime.boxToInteger((int)replicas.size()));
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<Object, Seq<Object>> x1) {
                Seq replicas;
                Tuple2<Object, Seq<Object>> tuple2 = x1;
                boolean bl = tuple2 != null && (replicas = (Seq)tuple2._2()).size() != this.expectedReplicationFactor$1;
                return bl;
            }
            {
                this.expectedReplicationFactor$1 = expectedReplicationFactor$1;
            }
        }, Map$.MODULE$.canBuildFrom());
        if (badRepFactors.nonEmpty()) {
            Seq sortedBadRepFactors = (Seq)badRepFactors.toSeq().sortBy((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToInteger((int)AdminZkClient.$anonfun$validateReplicaAssignment$2(x0$3)), (Ordering)Ordering.Int$.MODULE$);
            Seq partitions = (Seq)sortedBadRepFactors.map((Function1 & Serializable & scala.Serializable)x0$4 -> BoxesRunTime.boxToInteger((int)AdminZkClient.$anonfun$validateReplicaAssignment$3(x0$4)), Seq$.MODULE$.canBuildFrom());
            Seq repFactors = (Seq)sortedBadRepFactors.map((Function1 & Serializable & scala.Serializable)x0$5 -> BoxesRunTime.boxToInteger((int)AdminZkClient.$anonfun$validateReplicaAssignment$4(x0$5)), Seq$.MODULE$.canBuildFrom());
            throw new InvalidReplicaAssignmentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Inconsistent replication factor between partitions, "})).s((Seq)Nil$.MODULE$) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partition 0 has ", " while partitions [", "] have "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)expectedReplicationFactor), partitions.mkString(", ")})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"replication factors [", "], respectively."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{repFactors.mkString(", ")})));
        }
    }

    public void changeConfigs(String entityType, String entityName, Properties configs) {
        String string = entityType;
        String string2 = ConfigType$.MODULE$.Topic();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            this.changeTopicConfig(entityName, configs);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            String string4 = ConfigType$.MODULE$.Client();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                this.changeClientIdConfig(entityName, configs);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                String string6 = ConfigType$.MODULE$.User();
                String string7 = string;
                if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                    this.changeUserOrUserClientIdConfig(entityName, configs);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    String string8 = ConfigType$.MODULE$.Broker();
                    String string9 = string;
                    if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                        this.changeBrokerConfig((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{AdminZkClient.parseBroker$1(entityName)}))), configs);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not a known entityType. Should be one of ", ", ", ", ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{entityType, ConfigType$.MODULE$.Topic(), ConfigType$.MODULE$.Client(), ConfigType$.MODULE$.Broker()})));
                    }
                }
            }
        }
    }

    public void changeClientIdConfig(String sanitizedClientId, Properties configs) {
        DynamicConfig$Client$.MODULE$.validate(configs);
        this.changeEntityConfig(ConfigType$.MODULE$.Client(), sanitizedClientId, configs);
    }

    public void changeUserOrUserClientIdConfig(String sanitizedEntityName, Properties configs) {
        String string = sanitizedEntityName;
        String string2 = ConfigEntityName$.MODULE$.Default();
        java.util.Map<String, Object> map = !(string == null ? string2 != null : !string.equals(string2)) || sanitizedEntityName.contains("/clients") ? DynamicConfig$Client$.MODULE$.validate(configs) : DynamicConfig$User$.MODULE$.validate(configs);
        this.changeEntityConfig(ConfigType$.MODULE$.User(), sanitizedEntityName, configs);
    }

    public void validateTopicConfig(String topic, Properties configs) {
        Topic.validate(topic);
        if (!this.zkClient.topicExists(topic)) {
            throw new AdminOperationException(new StringOps(Predef$.MODULE$.augmentString("Topic \"%s\" does not exist.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
        }
        LogConfig$.MODULE$.validate(configs);
    }

    public void changeTopicConfig(String topic, Properties configs) {
        this.validateTopicConfig(topic, configs);
        this.changeEntityConfig(ConfigType$.MODULE$.Topic(), topic, configs);
    }

    public void changeBrokerConfig(Seq<Object> brokers, Properties configs) {
        this.validateBrokerConfig(configs);
        brokers.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)broker -> this.changeEntityConfig(ConfigType$.MODULE$.Broker(), ((Object)BoxesRunTime.boxToInteger((int)broker)).toString(), configs));
    }

    public void changeBrokerConfig(Option<Object> broker, Properties configs) {
        this.validateBrokerConfig(configs);
        String entityName = (String)broker.map((Function1 & Serializable & scala.Serializable)x$7 -> AdminZkClient.$anonfun$changeBrokerConfig$2(BoxesRunTime.unboxToInt((Object)x$7))).getOrElse((Function0 & Serializable & scala.Serializable)() -> ConfigEntityName$.MODULE$.Default());
        this.changeEntityConfig(ConfigType$.MODULE$.Broker(), (String)broker.map((Function1 & Serializable & scala.Serializable)x$1 -> AdminZkClient.$anonfun$changeBrokerConfig$4(BoxesRunTime.unboxToInt((Object)x$1))).getOrElse((Function0 & Serializable & scala.Serializable)() -> ConfigEntityName$.MODULE$.Default()), configs);
    }

    public void validateBrokerConfig(Properties configs) {
        DynamicConfig$Broker$.MODULE$.validate(configs);
    }

    private void changeEntityConfig(String rootEntityType, String fullSanitizedEntityName, Properties configs) {
        String sanitizedEntityPath = rootEntityType + '/' + fullSanitizedEntityName;
        this.zkClient.setOrCreateEntityConfigs(rootEntityType, fullSanitizedEntityName, configs);
        this.zkClient.createConfigChangeNotification(sanitizedEntityPath);
    }

    public Properties fetchEntityConfig(String rootEntityType, String sanitizedEntityName) {
        return this.zkClient.getEntityConfigs(rootEntityType, sanitizedEntityName);
    }

    public Map<String, Properties> getAllTopicConfigs() {
        return ((TraversableOnce)this.zkClient.getAllTopicsInCluster().map((Function1 & Serializable & scala.Serializable)topic -> new Tuple2(topic, (Object)this.fetchEntityConfig(ConfigType$.MODULE$.Topic(), (String)topic)), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Map<String, Properties> fetchAllEntityConfigs(String entityType) {
        return ((TraversableOnce)this.zkClient.getAllEntitiesWithConfig(entityType).map((Function1 & Serializable & scala.Serializable)entity -> new Tuple2(entity, (Object)this.fetchEntityConfig(entityType, (String)entity)), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Map<String, Properties> fetchAllChildEntityConfigs(String rootEntityType, String childEntityType) {
        return ((TraversableOnce)((TraversableLike)this.entityPaths$1((Option)None$.MODULE$, rootEntityType).flatMap((Function1 & Serializable & scala.Serializable)entity -> this.entityPaths$1((Option)new Some((Object)(entity + '/' + childEntityType)), rootEntityType), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)entityPath -> new Tuple2(entityPath, (Object)this.fetchEntityConfig(rootEntityType, (String)entityPath)), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public static final /* synthetic */ boolean $anonfun$getBrokerMetadatas$4(Broker x$1) {
        return x$1.rack().nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$validateCreateOrUpdateTopic$1(String topic$2, String x$3) {
        return Topic.hasCollision(topic$2, x$3);
    }

    public static final /* synthetic */ void $anonfun$validateCreateOrUpdateTopic$3(Map partitionReplicaAssignment$1, Seq reps) {
        if (reps.size() != reps.toSet().size()) {
            throw new InvalidReplicaAssignmentException("Duplicate replica assignment found: " + partitionReplicaAssignment$1);
        }
    }

    public static final /* synthetic */ boolean $anonfun$addPartitions$5(Seq existingAssignmentPartition0$1, BrokerMetadata x$6) {
        return x$6.id() >= BoxesRunTime.unboxToInt((Object)existingAssignmentPartition0$1.head());
    }

    public static final /* synthetic */ int $anonfun$validateReplicaAssignment$2(Tuple2 x0$3) {
        int partitionId;
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int n = partitionId = tuple2._1$mcI$sp();
        return n;
    }

    public static final /* synthetic */ int $anonfun$validateReplicaAssignment$3(Tuple2 x0$4) {
        int partitionId;
        Tuple2 tuple2 = x0$4;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int n = partitionId = tuple2._1$mcI$sp();
        return n;
    }

    public static final /* synthetic */ int $anonfun$validateReplicaAssignment$4(Tuple2 x0$5) {
        int rf;
        Tuple2 tuple2 = x0$5;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int n = rf = tuple2._2$mcI$sp();
        return n;
    }

    private static final int parseBroker$1(String broker) {
        int n;
        try {
            n = new StringOps(Predef$.MODULE$.augmentString(broker)).toInt();
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error parsing broker ", ". The broker's Entity Name must be a single integer value"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{broker})));
        }
        return n;
    }

    public static final /* synthetic */ String $anonfun$changeBrokerConfig$2(int x$7) {
        return ((Object)BoxesRunTime.boxToInteger((int)x$7)).toString();
    }

    public static final /* synthetic */ String $anonfun$changeBrokerConfig$4(int x$1) {
        return String.valueOf(x$1);
    }

    private final Seq entityPaths$1(Option rootPath, String rootEntityType$1) {
        Seq seq;
        String string;
        Option option = rootPath;
        if (option instanceof Some) {
            Some some = (Some)option;
            String path = (String)some.value();
            string = rootEntityType$1 + '/' + path;
        } else if (None$.MODULE$.equals(option)) {
            string = rootEntityType$1;
        } else {
            throw new MatchError((Object)option);
        }
        String root = string;
        Seq entityNames = this.zkClient.getAllEntitiesWithConfig(root);
        Option option2 = rootPath;
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            String path = (String)some.value();
            seq = (Seq)entityNames.map((Function1 & Serializable & scala.Serializable)entityName -> path + '/' + entityName, Seq$.MODULE$.canBuildFrom());
        } else if (None$.MODULE$.equals(option2)) {
            seq = entityNames;
        } else {
            throw new MatchError((Object)option2);
        }
        return seq;
    }

    public AdminZkClient(KafkaZkClient zkClient) {
        this.zkClient = zkClient;
        Logging.$init$(this);
    }
}

