/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.utils;

import io.confluent.kafka.common.TopicAndPartition;
import io.confluent.kafka.utils.Json$;
import io.confluent.kafka.utils.ZKStringSerializer$;
import io.confluent.kafka.utils.ZkUtils;
import io.confluent.kafka.utils.json.DecodeJson$;
import io.confluent.kafka.utils.json.DecodeJson$DecodeInt$;
import io.confluent.kafka.utils.json.DecodeJson$DecodeString$;
import io.confluent.kafka.utils.json.JsonObject;
import io.confluent.kafka.zk.ZkData$;
import io.confluent.org.apache.kafka.common.TopicPartition;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.ZkConnection;
import org.apache.zookeeper.data.ACL;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.runtime.BoxesRunTime;

public final class ZkUtils$ {
    public static ZkUtils$ MODULE$;
    private final ArrayList<ACL> kafka$utils$ZkUtils$$UseDefaultAcls;
    private final String AdminPath;
    private final String BrokersPath;
    private final String ClusterPath;
    private final String ConfigPath;
    private final String ControllerPath;
    private final String ControllerEpochPath;
    private final String IsrChangeNotificationPath;
    private final String LogDirEventNotificationPath;
    private final String KafkaAclPath;
    private final String KafkaAclChangesPath;
    private final String ConsumersPath;
    private final String ClusterIdPath;
    private final String BrokerIdsPath;
    private final String BrokerTopicsPath;
    private final String ReassignPartitionsPath;
    private final String DeleteTopicsPath;
    private final String PreferredReplicaLeaderElectionPath;
    private final String BrokerSequenceIdPath;
    private final String ConfigChangesPath;
    private final String ConfigUsersPath;
    private final String ConfigBrokersPath;
    private final String ProducerIdBlockPath;
    private final Seq<String> SecureZkRootPaths;
    private final Seq<String> SensitiveZkRootPaths;

    static {
        new ZkUtils$();
    }

    public ArrayList<ACL> kafka$utils$ZkUtils$$UseDefaultAcls() {
        return this.kafka$utils$ZkUtils$$UseDefaultAcls;
    }

    public String AdminPath() {
        return this.AdminPath;
    }

    public String BrokersPath() {
        return this.BrokersPath;
    }

    public String ClusterPath() {
        return this.ClusterPath;
    }

    public String ConfigPath() {
        return this.ConfigPath;
    }

    public String ControllerPath() {
        return this.ControllerPath;
    }

    public String ControllerEpochPath() {
        return this.ControllerEpochPath;
    }

    public String IsrChangeNotificationPath() {
        return this.IsrChangeNotificationPath;
    }

    public String LogDirEventNotificationPath() {
        return this.LogDirEventNotificationPath;
    }

    public String KafkaAclPath() {
        return this.KafkaAclPath;
    }

    public String KafkaAclChangesPath() {
        return this.KafkaAclChangesPath;
    }

    public String ConsumersPath() {
        return this.ConsumersPath;
    }

    public String ClusterIdPath() {
        return this.ClusterIdPath;
    }

    public String BrokerIdsPath() {
        return this.BrokerIdsPath;
    }

    public String BrokerTopicsPath() {
        return this.BrokerTopicsPath;
    }

    public String ReassignPartitionsPath() {
        return this.ReassignPartitionsPath;
    }

    public String DeleteTopicsPath() {
        return this.DeleteTopicsPath;
    }

    public String PreferredReplicaLeaderElectionPath() {
        return this.PreferredReplicaLeaderElectionPath;
    }

    public String BrokerSequenceIdPath() {
        return this.BrokerSequenceIdPath;
    }

    public String ConfigChangesPath() {
        return this.ConfigChangesPath;
    }

    public String ConfigUsersPath() {
        return this.ConfigUsersPath;
    }

    public String ConfigBrokersPath() {
        return this.ConfigBrokersPath;
    }

    public String ProducerIdBlockPath() {
        return this.ProducerIdBlockPath;
    }

    public Seq<String> SecureZkRootPaths() {
        return this.SecureZkRootPaths;
    }

    public Seq<String> SensitiveZkRootPaths() {
        return this.SensitiveZkRootPaths;
    }

    public ZkUtils apply(String zkUrl, int sessionTimeout, int connectionTimeout, boolean isZkSecurityEnabled) {
        Tuple2<ZkClient, ZkConnection> tuple2 = this.createZkClientAndConnection(zkUrl, sessionTimeout, connectionTimeout);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        ZkClient zkClient = (ZkClient)tuple2._1();
        ZkConnection zkConnection = (ZkConnection)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)zkClient, (Object)zkConnection);
        Tuple2 tuple23 = tuple22;
        ZkClient zkClient2 = (ZkClient)tuple23._1();
        ZkConnection zkConnection2 = (ZkConnection)tuple23._2();
        return new ZkUtils(zkClient2, zkConnection2, isZkSecurityEnabled);
    }

    public ZkUtils apply(ZkClient zkClient, boolean isZkSecurityEnabled) {
        return new ZkUtils(zkClient, null, isZkSecurityEnabled);
    }

    public ZkClient createZkClient(String zkUrl, int sessionTimeout, int connectionTimeout) {
        ZkClient zkClient = new ZkClient(zkUrl, sessionTimeout, connectionTimeout, ZKStringSerializer$.MODULE$);
        return zkClient;
    }

    public Tuple2<ZkClient, ZkConnection> createZkClientAndConnection(String zkUrl, int sessionTimeout, int connectionTimeout) {
        ZkConnection zkConnection = new ZkConnection(zkUrl, sessionTimeout);
        ZkClient zkClient = new ZkClient(zkConnection, connectionTimeout, ZKStringSerializer$.MODULE$);
        return new Tuple2((Object)zkClient, (Object)zkConnection);
    }

    public List<ACL> DefaultAcls(boolean isSecure) {
        return this.defaultAcls(isSecure, "");
    }

    public boolean sensitivePath(String path) {
        return ZkData$.MODULE$.sensitivePath(path);
    }

    public List<ACL> defaultAcls(boolean isSecure, String path) {
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter(ZkData$.MODULE$.defaultAcls(isSecure, path)).asJava();
    }

    public void maybeDeletePath(String zkUrl, String dir) {
        try {
            ZkClient zk = this.createZkClient(zkUrl, 30000, 30000);
            zk.deleteRecursive(dir);
            zk.close();
        }
        catch (Throwable throwable) {}
    }

    public String getTopicPath(String topic) {
        return this.BrokerTopicsPath() + "/" + topic;
    }

    public String getTopicPartitionsPath(String topic) {
        return this.getTopicPath(topic) + "/partitions";
    }

    public String getTopicPartitionPath(String topic, int partitionId) {
        return this.getTopicPartitionsPath(topic) + "/" + partitionId;
    }

    public String getTopicPartitionLeaderAndIsrPath(String topic, int partitionId) {
        return this.getTopicPartitionPath(topic, partitionId) + "/" + "state";
    }

    public String getEntityConfigRootPath(String entityType) {
        return this.ConfigPath() + "/" + entityType;
    }

    public String getEntityConfigPath(String entityType, String entity) {
        return this.getEntityConfigRootPath(entityType) + "/" + entity;
    }

    public String getEntityConfigPath(String entityPath) {
        return this.ConfigPath() + "/" + entityPath;
    }

    public String getDeleteTopicPath(String topic) {
        return this.DeleteTopicsPath() + "/" + topic;
    }

    public Map<TopicAndPartition, Seq<Object>> parsePartitionReassignmentData(String jsonData) {
        Seq seq = (Seq)Option$.MODULE$.option2Iterable(Json$.MODULE$.parseFull(jsonData)).toSeq().flatMap((Function1 & Serializable & scala.Serializable)js -> (Seq)Option$.MODULE$.option2Iterable(js.asJsonObject().get("partitions")).toSeq().flatMap((Function1 & Serializable & scala.Serializable)partitionsSeq -> partitionsSeq.asJsonArray().iterator().map((Function1 & Serializable & scala.Serializable)p -> {
            JsonObject partitionFields = p.asJsonObject();
            String topic = partitionFields.apply("topic").to(DecodeJson$DecodeString$.MODULE$);
            int partition = BoxesRunTime.unboxToInt((Object)partitionFields.apply("partition").to(DecodeJson$DecodeInt$.MODULE$));
            Seq newReplicas = (Seq)partitionFields.apply("replicas").to(DecodeJson$.MODULE$.decodeSeq(DecodeJson$DecodeInt$.MODULE$, Predef$.MODULE$.fallbackStringCanBuildFrom()));
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicAndPartition(topic, partition)), (Object)newReplicas);
        }), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        return seq.toMap(Predef$.MODULE$.$conforms());
    }

    public Seq<String> parseTopicsData(String jsonData) {
        return (Seq)Option$.MODULE$.option2Iterable(Json$.MODULE$.parseFull(jsonData)).toSeq().flatMap((Function1 & Serializable & scala.Serializable)js -> (Seq)Option$.MODULE$.option2Iterable(js.asJsonObject().get("topics")).toSeq().flatMap((Function1 & Serializable & scala.Serializable)partitionsSeq -> partitionsSeq.asJsonArray().iterator().map((Function1 & Serializable & scala.Serializable)p -> p.asJsonObject().apply("topic").to(DecodeJson$DecodeString$.MODULE$)), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
    }

    public String controllerZkData(int brokerId, long timestamp) {
        return Json$.MODULE$.legacyEncodeAsString(Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"brokerid"), (Object)BoxesRunTime.boxToInteger((int)brokerId)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"timestamp"), (Object)((Object)BoxesRunTime.boxToLong((long)timestamp)).toString())})));
    }

    public String preferredReplicaLeaderElectionZkData(Set<TopicAndPartition> partitions) {
        return Json$.MODULE$.legacyEncodeAsString(Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partitions"), partitions.map((Function1 & Serializable & scala.Serializable)tp -> (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic"), (Object)tp.topic()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partition"), (Object)BoxesRunTime.boxToInteger((int)tp.partition()))})), Set$.MODULE$.canBuildFrom()))})));
    }

    public String formatAsReassignmentJson(Map<TopicAndPartition, Seq<Object>> partitionsToBeReassigned) {
        return Json$.MODULE$.legacyEncodeAsString(Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partitions"), partitionsToBeReassigned.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Seq replicas;
            TopicAndPartition topicAndPartition;
            block3: {
                Tuple2 tuple2;
                block2: {
                    tuple2 = x0$1;
                    if (tuple2 == null) break block2;
                    topicAndPartition = (TopicAndPartition)tuple2._1();
                    replicas = (Seq)tuple2._2();
                    if (topicAndPartition != null) break block3;
                }
                throw new MatchError((Object)tuple2);
            }
            String topic = topicAndPartition.topic();
            int partition = topicAndPartition.partition();
            Map map = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic"), (Object)topic), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partition"), (Object)BoxesRunTime.boxToInteger((int)partition)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"replicas"), (Object)replicas)}));
            return map;
        }, Iterable$.MODULE$.canBuildFrom()))})));
    }

    public String getReassignmentJson(Map<TopicPartition, Seq<Object>> partitionsToBeReassigned) {
        return Json$.MODULE$.encodeAsString(Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partitions"), partitionsToBeReassigned.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition tp = (TopicPartition)tuple2._1();
            Seq replicas = (Seq)tuple2._2();
            Map map = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic"), (Object)tp.topic()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partition"), (Object)BoxesRunTime.boxToInteger((int)tp.partition())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"replicas"), (Object)replicas)}));
            return map;
        }, Iterable$.MODULE$.canBuildFrom()))})));
    }

    private ZkUtils$() {
        MODULE$ = this;
        this.kafka$utils$ZkUtils$$UseDefaultAcls = new ArrayList();
        this.AdminPath = "/admin";
        this.BrokersPath = "/brokers";
        this.ClusterPath = "/cluster";
        this.ConfigPath = "/config";
        this.ControllerPath = "/controller";
        this.ControllerEpochPath = "/controller_epoch";
        this.IsrChangeNotificationPath = "/isr_change_notification";
        this.LogDirEventNotificationPath = "/log_dir_event_notification";
        this.KafkaAclPath = "/io/confluent/kafka-acl";
        this.KafkaAclChangesPath = "/io/confluent/kafka-acl-changes";
        this.ConsumersPath = "/consumers";
        this.ClusterIdPath = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/id"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.ClusterPath()}));
        this.BrokerIdsPath = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/ids"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.BrokersPath()}));
        this.BrokerTopicsPath = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/topics"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.BrokersPath()}));
        this.ReassignPartitionsPath = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/reassign_partitions"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.AdminPath()}));
        this.DeleteTopicsPath = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/delete_topics"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.AdminPath()}));
        this.PreferredReplicaLeaderElectionPath = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/preferred_replica_election"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.AdminPath()}));
        this.BrokerSequenceIdPath = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/seqid"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.BrokersPath()}));
        this.ConfigChangesPath = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/changes"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.ConfigPath()}));
        this.ConfigUsersPath = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/users"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.ConfigPath()}));
        this.ConfigBrokersPath = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/brokers"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.ConfigPath()}));
        this.ProducerIdBlockPath = "/latest_producer_id_block";
        this.SecureZkRootPaths = ZkData$.MODULE$.SecureRootPaths();
        this.SensitiveZkRootPaths = ZkData$.MODULE$.SensitiveRootPaths();
    }
}

