/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.tools;

import com.typesafe.scalalogging.Logger;
import io.confluent.kafka.api.TopicMetadata;
import io.confluent.kafka.api.TopicMetadataResponse;
import io.confluent.kafka.client.ClientUtils$;
import io.confluent.kafka.cluster.BrokerEndPoint;
import io.confluent.kafka.common.TopicAndPartition;
import io.confluent.kafka.consumer.ConsumerConfig$;
import io.confluent.kafka.consumer.Whitelist;
import io.confluent.kafka.tools.ReplicaBuffer;
import io.confluent.kafka.tools.ReplicaFetcher;
import io.confluent.kafka.tools.ReplicaVerificationTool$;
import io.confluent.kafka.tools.TopicPartitionReplica;
import io.confluent.kafka.utils.CommandLineUtils$;
import io.confluent.kafka.utils.Exit$;
import io.confluent.kafka.utils.Logging;
import io.confluent.kafka.utils.ToolsUtils$;
import io.confluent.org.apache.kafka.common.utils.Time;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

public final class ReplicaVerificationTool$
implements Logging {
    public static ReplicaVerificationTool$ MODULE$;
    private final String clientId;
    private final String dateFormatString;
    private final SimpleDateFormat dateFormat;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new ReplicaVerificationTool$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        ReplicaVerificationTool$ replicaVerificationTool$ = this;
        synchronized (replicaVerificationTool$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String clientId() {
        return this.clientId;
    }

    public String dateFormatString() {
        return this.dateFormatString;
    }

    public SimpleDateFormat dateFormat() {
        return this.dateFormat;
    }

    public String getCurrentTimeString() {
        return this.dateFormat().format(new Date(Time.SYSTEM.milliseconds()));
    }

    public void main(String[] args) {
        OptionParser parser = new OptionParser(false);
        ArgumentAcceptingOptionSpec brokerListOpt = parser.accepts("broker-list", "REQUIRED: The list of hostname and port of the server to connect to.").withRequiredArg().describedAs("hostname:port,...,hostname:port").ofType(String.class);
        ArgumentAcceptingOptionSpec fetchSizeOpt = parser.accepts("fetch-size", "The fetch size of each request.").withRequiredArg().describedAs("bytes").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(ConsumerConfig$.MODULE$.FetchSize()), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec maxWaitMsOpt = parser.accepts("max-wait-ms", "The max amount of time each fetch request waits.").withRequiredArg().describedAs("ms").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(1000), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec topicWhiteListOpt = parser.accepts("topic-white-list", "White list of topics to verify replica consistency. Defaults to all topics.").withRequiredArg().describedAs("Java regex (String)").ofType(String.class).defaultsTo((Object)".*", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec initialOffsetTimeOpt = parser.accepts("time", "Timestamp for getting the initial offsets.").withRequiredArg().describedAs("timestamp/-1(latest)/-2(earliest)").ofType(Long.class).defaultsTo((Object)Predef$.MODULE$.long2Long(-1L), (Object[])new Long[0]);
        ArgumentAcceptingOptionSpec reportIntervalOpt = parser.accepts("report-interval-ms", "The reporting interval.").withRequiredArg().describedAs("ms").ofType(Long.class).defaultsTo((Object)Predef$.MODULE$.long2Long(30000L), (Object[])new Long[0]);
        if (args.length == 0) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(parser, "Validate that all replicas for a set of topics have the same data.");
        }
        OptionSet options = parser.parse(args);
        CommandLineUtils$.MODULE$.checkRequiredArgs(parser, options, (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{brokerListOpt}));
        String regex = (String)options.valueOf((OptionSpec)topicWhiteListOpt);
        Whitelist topicWhiteListFiler = new Whitelist(regex);
        try {
            Pattern.compile(regex);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw new RuntimeException(regex + " is an invalid regex.");
        }
        int fetchSize = (Integer)options.valueOf((OptionSpec)fetchSizeOpt);
        int maxWaitMs = (Integer)options.valueOf((OptionSpec)maxWaitMsOpt);
        long initialOffsetTime = (Long)options.valueOf((OptionSpec)initialOffsetTimeOpt);
        long reportInterval = (Long)options.valueOf((OptionSpec)reportIntervalOpt);
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Getting topic metadata...");
        String brokerList = (String)options.valueOf((OptionSpec)brokerListOpt);
        ToolsUtils$.MODULE$.validatePortOrDie(parser, brokerList);
        Seq<BrokerEndPoint> metadataTargetBrokers = ClientUtils$.MODULE$.parseBrokerList(brokerList);
        TopicMetadataResponse topicsMetadataResponse = ClientUtils$.MODULE$.fetchTopicMetadata((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)), metadataTargetBrokers, this.clientId(), maxWaitMs, ClientUtils$.MODULE$.fetchTopicMetadata$default$5());
        Map brokerMap = ((TraversableOnce)topicsMetadataResponse.brokers().map((Function1 & Serializable & scala.Serializable)b -> new Tuple2((Object)BoxesRunTime.boxToInteger((int)b.id()), b), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Seq filteredTopicMetadata = (Seq)topicsMetadataResponse.topicsMetadata().filter((Function1 & Serializable & scala.Serializable)topicMetadata -> BoxesRunTime.boxToBoolean((boolean)ReplicaVerificationTool$.$anonfun$main$3(topicWhiteListFiler, topicMetadata)));
        if (filteredTopicMetadata.isEmpty()) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "No topics found. " + topicWhiteListOpt + ", if specified, is either filtering out all topics or there is no topic.");
            throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
        }
        Seq topicPartitionReplicaList = (Seq)filteredTopicMetadata.flatMap((Function1 & Serializable & scala.Serializable)topicMetadataResponse -> (Seq)topicMetadataResponse.partitionsMetadata().flatMap((Function1 & Serializable & scala.Serializable)partitionMetadata -> (Seq)partitionMetadata.replicas().map((Function1 & Serializable & scala.Serializable)broker -> new TopicPartitionReplica(topicMetadataResponse.topic(), partitionMetadata.partitionId(), broker.id()), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Selected topic partitions: " + topicPartitionReplicaList);
        Map topicAndPartitionsPerBroker = (Map)topicPartitionReplicaList.groupBy((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.replicaId())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int brokerId = tuple2._1$mcI$sp();
            Seq partitions = (Seq)tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)brokerId)), partitions.map((Function1 & Serializable & scala.Serializable)partition -> new TopicAndPartition(partition.topic(), partition.partitionId()), Seq$.MODULE$.canBuildFrom()));
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Topic partitions per broker: " + topicAndPartitionsPerBroker);
        Map expectedReplicasPerTopicAndPartition = (Map)topicPartitionReplicaList.groupBy((Function1 & Serializable & scala.Serializable)replica -> new TopicAndPartition(replica.topic(), replica.partitionId())).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicAndPartition topicAndPartition = (TopicAndPartition)tuple2._1();
            Seq replicaSet = (Seq)tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicAndPartition), (Object)BoxesRunTime.boxToInteger((int)replicaSet.size()));
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected replicas per topic partition: " + expectedReplicasPerTopicAndPartition);
        Map leadersPerBroker = ((TraversableLike)filteredTopicMetadata.flatMap((Function1 & Serializable & scala.Serializable)topicMetadataResponse -> (Seq)topicMetadataResponse.partitionsMetadata().map((Function1 & Serializable & scala.Serializable)partitionMetadata -> new Tuple2((Object)new TopicAndPartition(topicMetadataResponse.topic(), partitionMetadata.partitionId()), (Object)BoxesRunTime.boxToInteger((int)((BrokerEndPoint)partitionMetadata.leader().get()).id())), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())).groupBy((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2._2$mcI$sp())).mapValues((Function1 & Serializable & scala.Serializable)topicAndPartitionAndLeaderIds -> (Seq)topicAndPartitionAndLeaderIds.map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            TopicAndPartition topicAndPartition;
            Tuple2 tuple2 = x0$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicAndPartition topicAndPartition2 = topicAndPartition = (TopicAndPartition)tuple2._1();
            return topicAndPartition2;
        }, Seq$.MODULE$.canBuildFrom()));
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Leaders per broker: " + leadersPerBroker);
        ReplicaBuffer replicaBuffer = new ReplicaBuffer((Map<TopicAndPartition, Object>)expectedReplicasPerTopicAndPartition, (Map<Object, Seq<TopicAndPartition>>)leadersPerBroker, topicAndPartitionsPerBroker.size(), (Map<Object, BrokerEndPoint>)brokerMap, initialOffsetTime, reportInterval);
        int verificationBrokerId = ((Tuple2)topicAndPartitionsPerBroker.head())._1$mcI$sp();
        Iterable fetcherThreads = (Iterable)topicAndPartitionsPerBroker.map((Function1 & Serializable & scala.Serializable)x0$4 -> {
            Tuple2 tuple2 = x0$4;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int brokerId = tuple2._1$mcI$sp();
            Seq topicAndPartitions = (Seq)tuple2._2();
            ReplicaFetcher replicaFetcher = new ReplicaFetcher("ReplicaFetcher-" + brokerId, (BrokerEndPoint)brokerMap.apply((Object)BoxesRunTime.boxToInteger((int)brokerId)), (Iterable<TopicAndPartition>)topicAndPartitions, replicaBuffer, 30000, 256000, fetchSize, maxWaitMs, 1, brokerId == verificationBrokerId);
            return replicaFetcher;
        }, Iterable$.MODULE$.canBuildFrom());
        Runtime.getRuntime().addShutdownHook(new Thread(fetcherThreads){
            private final Iterable fetcherThreads$1;

            public void run() {
                ReplicaVerificationTool$.MODULE$.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Stopping all fetchers");
                this.fetcherThreads$1.foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                    anon.1.$anonfun$run$2(x$3);
                    return BoxedUnit.UNIT;
                });
            }

            public static final /* synthetic */ void $anonfun$run$2(ReplicaFetcher x$3) {
                x$3.shutdown();
            }
            {
                this.fetcherThreads$1 = fetcherThreads$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1(), $anonfun$run$2$adapted(io.confluent.kafka.tools.ReplicaFetcher )}, serializedLambda);
            }
        });
        fetcherThreads.foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            x$4.start();
            return BoxedUnit.UNIT;
        });
        Predef$.MODULE$.println((Object)(this.getCurrentTimeString() + ": verification process is started."));
    }

    public static final /* synthetic */ boolean $anonfun$main$3(Whitelist topicWhiteListFiler$1, TopicMetadata topicMetadata) {
        return topicWhiteListFiler$1.isTopicAllowed(topicMetadata.topic(), false);
    }

    private ReplicaVerificationTool$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.clientId = "replicaVerificationTool";
        this.dateFormatString = "yyyy-MM-dd HH:mm:ss,SSS";
        this.dateFormat = new SimpleDateFormat(this.dateFormatString());
    }
}

