/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.tools;

import io.confluent.kafka.consumer.ConsumerTimeoutException;
import io.confluent.kafka.consumer.KafkaStream;
import io.confluent.kafka.message.MessageAndMetadata;
import io.confluent.kafka.tools.ConsumerPerformance$;
import io.confluent.kafka.tools.PerfConfig;
import io.confluent.kafka.utils.CommandLineUtils$;
import io.confluent.org.apache.kafka.clients.consumer.KafkaConsumer;
import io.confluent.org.apache.kafka.common.serialization.ByteArrayDeserializer;
import io.confluent.org.apache.kafka.common.utils.Utils;
import java.nio.channels.ClosedByInterruptException;
import java.text.SimpleDateFormat;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import scala.Console$;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\tUw!B\u0001\u0003\u0011\u00039\u0011aE\"p]N,X.\u001a:QKJ4wN]7b]\u000e,'BA\u0002\u0005\u0003\u0015!xn\u001c7t\u0015\u0005)\u0011!B6bM.\f7\u0001\u0001\t\u0003\u0011%i\u0011A\u0001\u0004\u0006\u0015\tA\ta\u0003\u0002\u0014\u0007>t7/^7feB+'OZ8s[\u0006t7-Z\n\u0004\u00131\u0011\u0002CA\u0007\u0011\u001b\u0005q!\"A\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Eq!AB!osJ+g\r\u0005\u0002\u001455\tAC\u0003\u0002\u0016-\u0005a1oY1mC2|wmZ5oO*\u0011q\u0003G\u0001\tif\u0004Xm]1gK*\t\u0011$A\u0002d_6L!a\u0007\u000b\u0003\u00171\u000b'0\u001f'pO\u001eLgn\u001a\u0005\u0006;%!\tAH\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u001dAQ\u0001I\u0005\u0005\u0002\u0005\nA!\\1j]R\u0011!%\n\t\u0003\u001b\rJ!\u0001\n\b\u0003\tUs\u0017\u000e\u001e\u0005\u0006M}\u0001\raJ\u0001\u0005CJ<7\u000fE\u0002\u000eQ)J!!\u000b\b\u0003\u000b\u0005\u0013(/Y=\u0011\u0005-\u0012dB\u0001\u00171!\tic\"D\u0001/\u0015\tyc!\u0001\u0004=e>|GOP\u0005\u0003c9\ta\u0001\u0015:fI\u00164\u0017BA\u001a5\u0005\u0019\u0019FO]5oO*\u0011\u0011G\u0004\u0005\u0007m%!\tAA\u001c\u0002\u0017A\u0014\u0018N\u001c;IK\u0006$WM\u001d\u000b\u0004Eaj\u0004\"B\u001d6\u0001\u0004Q\u0014!E:i_^$U\r^1jY\u0016$7\u000b^1ugB\u0011QbO\u0005\u0003y9\u0011qAQ8pY\u0016\fg\u000eC\u0003?k\u0001\u0007!(\u0001\bvg\u0016|E\u000eZ\"p]N,X.\u001a:\t\u000b\u0001KA\u0011A!\u0002\u000f\r|gn];nKRq!E\u0011+`I\u001a\u0014\tA!\u0006\u0003\u001a\tu\u0001\"B\"@\u0001\u0004!\u0015\u0001C2p]N,X.\u001a:\u0011\t\u0015s\u0005\u000bU\u0007\u0002\r*\u00111i\u0012\u0006\u0003\u0011&\u000bqa\u00197jK:$8O\u0003\u0002\u0006\u0015*\u00111\nT\u0001\u0007CB\f7\r[3\u000b\u00035\u000b1a\u001c:h\u0013\tyeIA\u0007LC\u001a\\\u0017mQ8ogVlWM\u001d\t\u0004\u001b!\n\u0006CA\u0007S\u0013\t\u0019fB\u0001\u0003CsR,\u0007\"B+@\u0001\u00041\u0016A\u0002;pa&\u001c7\u000fE\u0002X9*r!\u0001\u0017.\u000f\u00055J\u0016\"A\b\n\u0005ms\u0011a\u00029bG.\fw-Z\u0005\u0003;z\u0013A\u0001T5ti*\u00111L\u0004\u0005\u0006A~\u0002\r!Y\u0001\u0006G>,h\u000e\u001e\t\u0003\u001b\tL!a\u0019\b\u0003\t1{gn\u001a\u0005\u0006K~\u0002\r!Y\u0001\bi&lWm\\;u\u0011\u00159w\b1\u0001i\u0003\u0019\u0019wN\u001c4jOB\u0011\u0011N[\u0007\u0002\u0013\u0019!1.\u0003\u0001m\u0005I\u0019uN\\:v[\u0016\u0014\b+\u001a:g\u0007>tg-[4\u0014\u0005)l\u0007C\u0001\u0005o\u0013\ty'A\u0001\u0006QKJ47i\u001c8gS\u001eD\u0001B\n6\u0003\u0002\u0003\u0006Ia\n\u0005\u0006;)$\tA\u001d\u000b\u0003QNDQAJ9A\u0002\u001dBq!\u001e6C\u0002\u0013\u0005a/\u0001\u0007{W\u000e{gN\\3di>\u0003H/F\u0001x!\rA8PK\u0007\u0002s*\t!0\u0001\u0006k_B$8/[7qY\u0016L!\u0001`=\u00037\u0005\u0013x-^7f]R\f5mY3qi&twm\u00149uS>t7\u000b]3d\u0011\u0019q(\u000e)A\u0005o\u0006i!p[\"p]:,7\r^(qi\u0002B\u0001\"!\u0001k\u0005\u0004%\tA^\u0001\u0014E>|Go\u001d;sCB\u001cVM\u001d<feN|\u0005\u000f\u001e\u0005\b\u0003\u000bQ\u0007\u0015!\u0003x\u0003Q\u0011wn\u001c;tiJ\f\u0007oU3sm\u0016\u00148o\u00149uA!A\u0011\u0011\u00026C\u0002\u0013\u0005a/\u0001\u0005u_BL7m\u00149u\u0011\u001d\tiA\u001bQ\u0001\n]\f\u0011\u0002^8qS\u000e|\u0005\u000f\u001e\u0011\t\u0011\u0005E!N1A\u0005\u0002Y\f!b\u001a:pkBLEm\u00149u\u0011\u001d\t)B\u001bQ\u0001\n]\f1b\u001a:pkBLEm\u00149uA!I\u0011\u0011\u00046C\u0002\u0013\u0005\u00111D\u0001\rM\u0016$8\r[*ju\u0016|\u0005\u000f^\u000b\u0003\u0003;\u0001B\u0001_>\u0002 A!\u0011\u0011EA\u0016\u001b\t\t\u0019C\u0003\u0003\u0002&\u0005\u001d\u0012\u0001\u00027b]\u001eT!!!\u000b\u0002\t)\fg/Y\u0005\u0005\u0003[\t\u0019CA\u0004J]R,w-\u001a:\t\u0011\u0005E\"\u000e)A\u0005\u0003;\tQBZ3uG\"\u001c\u0016N_3PaR\u0004\u0003\"CA\u001bU\n\u0007I\u0011AA\u001c\u0003]\u0011Xm]3u\u0005\u0016<\u0017N\u001c8j]\u001e|eMZ:fi>\u0003H/\u0006\u0002\u0002:A\u0019\u00010a\u000f\n\u0007\u0005u\u0012PA\tPaRLwN\\*qK\u000e\u0014U/\u001b7eKJD\u0001\"!\u0011kA\u0003%\u0011\u0011H\u0001\u0019e\u0016\u001cX\r\u001e\"fO&tg.\u001b8h\u001f\u001a47/\u001a;PaR\u0004\u0003\"CA#U\n\u0007I\u0011AA\u000e\u0003M\u0019xnY6fi\n+hMZ3s'&TXm\u00149u\u0011!\tIE\u001bQ\u0001\n\u0005u\u0011\u0001F:pG.,GOQ;gM\u0016\u00148+\u001b>f\u001fB$\b\u0005C\u0005\u0002N)\u0014\r\u0011\"\u0001\u0002\u001c\u0005ia.^7UQJ,\u0017\rZ:PaRD\u0001\"!\u0015kA\u0003%\u0011QD\u0001\u000f]VlG\u000b\u001b:fC\u0012\u001cx\n\u001d;!\u0011%\t)F\u001bb\u0001\n\u0003\tY\"\u0001\bok64U\r^2iKJ\u001cx\n\u001d;\t\u0011\u0005e#\u000e)A\u0005\u0003;\tqB\\;n\r\u0016$8\r[3sg>\u0003H\u000f\t\u0005\n\u0003;R'\u0019!C\u0001\u0003o\taB\\3x\u0007>t7/^7fe>\u0003H\u000f\u0003\u0005\u0002b)\u0004\u000b\u0011BA\u001d\u0003=qWm^\"p]N,X.\u001a:PaR\u0004\u0003\u0002CA3U\n\u0007I\u0011\u0001<\u0002#\r|gn];nKJ\u001cuN\u001c4jO>\u0003H\u000fC\u0004\u0002j)\u0004\u000b\u0011B<\u0002%\r|gn];nKJ\u001cuN\u001c4jO>\u0003H\u000f\t\u0005\n\u0003[R'\u0019!C\u0001\u0003o\tq\u0002\u001d:j]RlU\r\u001e:jGN|\u0005\u000f\u001e\u0005\t\u0003cR\u0007\u0015!\u0003\u0002:\u0005\u0001\u0002O]5oi6+GO]5dg>\u0003H\u000f\t\u0005\n\u0003kR'\u0019!C\u0001\u0003o\tAc\u001d5po\u0012+G/Y5mK\u0012\u001cF/\u0019;t\u001fB$\b\u0002CA=U\u0002\u0006I!!\u000f\u0002+MDwn\u001e#fi\u0006LG.\u001a3Ti\u0006$8o\u00149uA!I\u0011Q\u00106C\u0002\u0013\u0005\u0011qP\u0001\b_B$\u0018n\u001c8t+\t\t\t\tE\u0002y\u0003\u0007K1!!\"z\u0005%y\u0005\u000f^5p]N+G\u000f\u0003\u0005\u0002\n*\u0004\u000b\u0011BAA\u0003!y\u0007\u000f^5p]N\u0004\u0003\u0002\u0003 k\u0005\u0004%\t!!$\u0016\u0003iBq!!%kA\u0003%!(A\bvg\u0016|E\u000eZ\"p]N,X.\u001a:!\u0011%\t)J\u001bb\u0001\n\u0003\ti)\u0001\u0007qe&tG/T3ue&\u001c7\u000fC\u0004\u0002\u001a*\u0004\u000b\u0011\u0002\u001e\u0002\u001bA\u0014\u0018N\u001c;NKR\u0014\u0018nY:!\u0011%\tiJ\u001bb\u0001\n\u0003\ty*A\u0003qe>\u00048/\u0006\u0002\u0002\"B!\u00111UAU\u001b\t\t)K\u0003\u0003\u0002(\u0006\u001d\u0012\u0001B;uS2LA!a+\u0002&\nQ\u0001K]8qKJ$\u0018.Z:\t\u0011\u0005=&\u000e)A\u0005\u0003C\u000ba\u0001\u001d:paN\u0004\u0003\"CAZU\n\u0007I\u0011AA[\u0003)qW/\u001c+ie\u0016\fGm]\u000b\u0003\u0003o\u00032!DA]\u0013\r\tYL\u0004\u0002\u0004\u0013:$\b\u0002CA`U\u0002\u0006I!a.\u0002\u00179,X\u000e\u00165sK\u0006$7\u000f\t\u0005\n\u0003\u0007T'\u0019!C\u0001\u0003\u000b\fQ\u0001^8qS\u000e,\u0012A\u000b\u0005\b\u0003\u0013T\u0007\u0015!\u0003+\u0003\u0019!x\u000e]5dA!I\u0011Q\u001a6C\u0002\u0013\u0005\u0011qZ\u0001\f]VlW*Z:tC\u001e,7/F\u0001b\u0011\u001d\t\u0019N\u001bQ\u0001\n\u0005\fAB\\;n\u001b\u0016\u001c8/Y4fg\u0002B\u0011\"a6k\u0005\u0004%\t!!.\u0002#I,\u0007o\u001c:uS:<\u0017J\u001c;feZ\fG\u000e\u0003\u0005\u0002\\*\u0004\u000b\u0011BA\\\u0003I\u0011X\r]8si&tw-\u00138uKJ4\u0018\r\u001c\u0011\t\u0011eR'\u0019!C\u0001\u0003\u001bCq!!9kA\u0003%!(\u0001\ntQ><H)\u001a;bS2,Gm\u0015;biN\u0004\u0003\"CAsU\n\u0007I\u0011AAt\u0003)!\u0017\r^3G_Jl\u0017\r^\u000b\u0003\u0003S\u0004B!a;\u0002r6\u0011\u0011Q\u001e\u0006\u0005\u0003_\f9#\u0001\u0003uKb$\u0018\u0002BAz\u0003[\u0014\u0001cU5na2,G)\u0019;f\r>\u0014X.\u0019;\t\u0011\u0005](\u000e)A\u0005\u0003S\f1\u0002Z1uK\u001a{'/\\1uA!I\u00111 6C\u0002\u0013\u0005\u0011QR\u0001\u000bQ&$W\rS3bI\u0016\u0014\bbBA\u0000U\u0002\u0006IAO\u0001\fQ&$W\rS3bI\u0016\u0014\b\u0005C\u0004\u0003\u0004}\u0002\rA!\u0002\u0002#Q|G/\u00197NKN\u001c\u0018mZ3t%\u0016\fG\r\u0005\u0003\u0003\b\tEQB\u0001B\u0005\u0015\u0011\u0011YA!\u0004\u0002\r\u0005$x.\\5d\u0015\u0011\u0011y!!*\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0003\u0003\u0014\t%!AC!u_6L7\rT8oO\"9!qC A\u0002\t\u0015\u0011A\u0004;pi\u0006d')\u001f;fgJ+\u0017\r\u001a\u0005\b\u00057y\u0004\u0019\u0001B\u0003\u0003!Qw.\u001b8US6,\u0007B\u0002B\u0010\u007f\u0001\u0007\u0011-A\u0007uKN$8\u000b^1siRKW.\u001a\u0005\b\u0005GIA\u0011\u0001B\u0013\u0003a\u0001(/\u001b8u\u001f2$7i\u001c8tk6,'\u000f\u0015:pOJ,7o\u001d\u000b\u0012E\t\u001d\"1\u0006B\u0018\u0005g\u00119Da\u000f\u0003@\t\r\u0003\u0002\u0003B\u0015\u0005C\u0001\r!a.\u0002\u0005%$\u0007b\u0002B\u0017\u0005C\u0001\r!Y\u0001\nEf$Xm\u001d*fC\u0012DqA!\r\u0003\"\u0001\u0007\u0011-A\u0007mCN$()\u001f;fgJ+\u0017\r\u001a\u0005\b\u0005k\u0011\t\u00031\u0001b\u00031iWm]:bO\u0016\u001c(+Z1e\u0011\u001d\u0011ID!\tA\u0002\u0005\f\u0001\u0003\\1ti6+7o]1hKN\u0014V-\u00193\t\u000f\tu\"\u0011\u0005a\u0001C\u000691\u000f^1si6\u001b\bb\u0002B!\u0005C\u0001\r!Y\u0001\u0006K:$Wj\u001d\u0005\t\u0003K\u0014\t\u00031\u0001\u0002j\"9!qI\u0005\u0005\u0002\t%\u0013\u0001\u00079sS:$h*Z<D_:\u001cX/\\3s!J|wM]3tgR\u0019\"Ea\u0013\u0003N\t=#\u0011\u000bB*\u0005+\u00129F!\u0017\u0003\\!A!\u0011\u0006B#\u0001\u0004\t9\fC\u0004\u0003.\t\u0015\u0003\u0019A1\t\u000f\tE\"Q\ta\u0001C\"9!Q\u0007B#\u0001\u0004\t\u0007b\u0002B\u001d\u0005\u000b\u0002\r!\u0019\u0005\b\u0005{\u0011)\u00051\u0001b\u0011\u001d\u0011\tE!\u0012A\u0002\u0005D\u0001\"!:\u0003F\u0001\u0007\u0011\u0011\u001e\u0005\b\u0005;\u0012)\u00051\u0001b\u0003Q\u0001XM]5pI&\u001c'j\\5o)&lW-\u00138Ng\"9!\u0011M\u0005\u0005\n\t\r\u0014A\u00059sS:$()Y:jGB\u0013xn\u001a:fgN$\u0012C\tB3\u0005O\u0012IGa\u001b\u0003n\t=$\u0011\u000fB:\u0011!\u0011ICa\u0018A\u0002\u0005]\u0006b\u0002B\u0017\u0005?\u0002\r!\u0019\u0005\b\u0005c\u0011y\u00061\u0001b\u0011\u001d\u0011)Da\u0018A\u0002\u0005DqA!\u000f\u0003`\u0001\u0007\u0011\rC\u0004\u0003>\t}\u0003\u0019A1\t\u000f\t\u0005#q\fa\u0001C\"A\u0011Q\u001dB0\u0001\u0004\tI\u000fC\u0004\u0003x%!IA!\u001f\u0002+A\u0014\u0018N\u001c;FqR,g\u000eZ3e!J|wM]3tgRy!Ea\u001f\u0003~\t}$\u0011\u0011BB\u0005\u000b\u00139\tC\u0004\u0003.\tU\u0004\u0019A1\t\u000f\tE\"Q\u000fa\u0001C\"9!Q\u0007B;\u0001\u0004\t\u0007b\u0002B\u001d\u0005k\u0002\r!\u0019\u0005\b\u0005{\u0011)\b1\u0001b\u0011\u001d\u0011\tE!\u001eA\u0002\u0005DqA!\u0018\u0003v\u0001\u0007\u0011M\u0002\u0004\u0003\f&\u0001!Q\u0012\u0002\u0013\u0007>t7/^7feB+'O\u001a+ie\u0016\fGm\u0005\u0003\u0003\n\n=\u0005\u0003BA\u0011\u0005#KAAa%\u0002$\t1A\u000b\u001b:fC\u0012D1Ba&\u0003\n\n\u0005\t\u0015!\u0003\u00028\u0006AA\u000f\u001b:fC\u0012LE\r\u0003\u0006\u0003\u001c\n%%\u0011!Q\u0001\n)\nAA\\1nK\"Y!q\u0014BE\u0005\u0003\u0005\u000b\u0011\u0002BQ\u0003\u0019\u0019HO]3b[B1!1\u0015BT!Bk!A!*\u000b\u0005\r#\u0011\u0002\u0002BU\u0005K\u00131bS1gW\u0006\u001cFO]3b[\"IqM!#\u0003\u0002\u0003\u0006I\u0001\u001b\u0005\f\u0005\u0007\u0011II!A!\u0002\u0013\u0011)\u0001C\u0006\u0003\u0018\t%%\u0011!Q\u0001\n\t\u0015\u0001b\u0003BZ\u0005\u0013\u0013\t\u0011)A\u0005\u0005k\u000bqbY8ogVlWM\u001d+j[\u0016|W\u000f\u001e\t\u0005\u0005\u000f\u00119,\u0003\u0003\u0003:\n%!!D!u_6L7MQ8pY\u0016\fg\u000eC\u0004\u001e\u0005\u0013#\tA!0\u0015!\t}&\u0011\u0019Bb\u0005\u000b\u00149M!3\u0003L\n5\u0007cA5\u0003\n\"A!q\u0013B^\u0001\u0004\t9\fC\u0004\u0003\u001c\nm\u0006\u0019\u0001\u0016\t\u0011\t}%1\u0018a\u0001\u0005CCaa\u001aB^\u0001\u0004A\u0007\u0002\u0003B\u0002\u0005w\u0003\rA!\u0002\t\u0011\t]!1\u0018a\u0001\u0005\u000bA\u0001Ba-\u0003<\u0002\u0007!Q\u0017\u0005\t\u0005#\u0014I\t\"\u0011\u0003T\u0006\u0019!/\u001e8\u0015\u0003\t\u0002")
public final class ConsumerPerformance {
    public static void printNewConsumerProgress(int n, long l, long l2, long l3, long l4, long l5, long l6, SimpleDateFormat simpleDateFormat, long l7) {
        ConsumerPerformance$.MODULE$.printNewConsumerProgress(n, l, l2, l3, l4, l5, l6, simpleDateFormat, l7);
    }

    public static void printOldConsumerProgress(int n, long l, long l2, long l3, long l4, long l5, long l6, SimpleDateFormat simpleDateFormat) {
        ConsumerPerformance$.MODULE$.printOldConsumerProgress(n, l, l2, l3, l4, l5, l6, simpleDateFormat);
    }

    public static void consume(KafkaConsumer<byte[], byte[]> kafkaConsumer, List<String> list, long l, long l2, ConsumerPerfConfig consumerPerfConfig, AtomicLong atomicLong, AtomicLong atomicLong2, AtomicLong atomicLong3, long l3) {
        ConsumerPerformance$.MODULE$.consume(kafkaConsumer, list, l, l2, consumerPerfConfig, atomicLong, atomicLong2, atomicLong3, l3);
    }

    public static void main(String[] stringArray) {
        ConsumerPerformance$.MODULE$.main(stringArray);
    }

    public static class ConsumerPerfConfig
    extends PerfConfig {
        private final ArgumentAcceptingOptionSpec<String> zkConnectOpt = this.parser().accepts("zookeeper", "REQUIRED (only when using old consumer): The connection string for the zookeeper connection in the form host:port. Multiple URLS can be given to allow fail-over. This option is only used with the old consumer.").withRequiredArg().describedAs("urls").ofType(String.class);
        private final ArgumentAcceptingOptionSpec<String> bootstrapServersOpt = this.parser().accepts("broker-list", "REQUIRED (unless old consumer is used): A broker list to use for connecting if using the new consumer.").withRequiredArg().describedAs("host").ofType(String.class);
        private final ArgumentAcceptingOptionSpec<String> topicOpt = this.parser().accepts("topic", "REQUIRED: The topic to consume from.").withRequiredArg().describedAs("topic").ofType(String.class);
        private final ArgumentAcceptingOptionSpec<String> groupIdOpt = this.parser().accepts("group", "The group id to consume on.").withRequiredArg().describedAs("gid").defaultsTo((Object)("perf-consumer-" + new Random().nextInt(100000)), (Object[])new String[0]).ofType(String.class);
        private final ArgumentAcceptingOptionSpec<Integer> fetchSizeOpt = this.parser().accepts("fetch-size", "The amount of data to fetch in a single request.").withRequiredArg().describedAs("size").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(0x100000), (Object[])new Integer[0]);
        private final OptionSpecBuilder resetBeginningOffsetOpt = this.parser().accepts("from-latest", "If the consumer does not already have an established offset to consume from, start with the latest message present in the log rather than the earliest message.");
        private final ArgumentAcceptingOptionSpec<Integer> socketBufferSizeOpt = this.parser().accepts("socket-buffer-size", "The size of the tcp RECV size.").withRequiredArg().describedAs("size").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(0x200000), (Object[])new Integer[0]);
        private final ArgumentAcceptingOptionSpec<Integer> numThreadsOpt = this.parser().accepts("threads", "Number of processing threads.").withRequiredArg().describedAs("count").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(10), (Object[])new Integer[0]);
        private final ArgumentAcceptingOptionSpec<Integer> numFetchersOpt = this.parser().accepts("num-fetch-threads", "Number of fetcher threads.").withRequiredArg().describedAs("count").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(1), (Object[])new Integer[0]);
        private final OptionSpecBuilder newConsumerOpt = this.parser().accepts("new-consumer", "Use the new consumer implementation. This is the default, so this option is deprecated and will be removed in a future release.");
        private final ArgumentAcceptingOptionSpec<String> consumerConfigOpt = this.parser().accepts("consumer.config", "Consumer config properties file.").withRequiredArg().describedAs("config file").ofType(String.class);
        private final OptionSpecBuilder printMetricsOpt = this.parser().accepts("print-metrics", "Print out the metrics. This only applies to new consumer.");
        private final OptionSpecBuilder showDetailedStatsOpt = this.parser().accepts("show-detailed-stats", "If set, stats are reported for each reporting interval as configured by reporting-interval");
        private final OptionSet options;
        private final boolean useOldConsumer;
        private final boolean printMetrics;
        private final Properties props;
        private final int numThreads;
        private final String topic;
        private final long numMessages;
        private final int reportingInterval;
        private final boolean showDetailedStats;
        private final SimpleDateFormat dateFormat;
        private final boolean hideHeader;

        public ArgumentAcceptingOptionSpec<String> zkConnectOpt() {
            return this.zkConnectOpt;
        }

        public ArgumentAcceptingOptionSpec<String> bootstrapServersOpt() {
            return this.bootstrapServersOpt;
        }

        public ArgumentAcceptingOptionSpec<String> topicOpt() {
            return this.topicOpt;
        }

        public ArgumentAcceptingOptionSpec<String> groupIdOpt() {
            return this.groupIdOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> fetchSizeOpt() {
            return this.fetchSizeOpt;
        }

        public OptionSpecBuilder resetBeginningOffsetOpt() {
            return this.resetBeginningOffsetOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> socketBufferSizeOpt() {
            return this.socketBufferSizeOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> numThreadsOpt() {
            return this.numThreadsOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> numFetchersOpt() {
            return this.numFetchersOpt;
        }

        public OptionSpecBuilder newConsumerOpt() {
            return this.newConsumerOpt;
        }

        public ArgumentAcceptingOptionSpec<String> consumerConfigOpt() {
            return this.consumerConfigOpt;
        }

        public OptionSpecBuilder printMetricsOpt() {
            return this.printMetricsOpt;
        }

        public OptionSpecBuilder showDetailedStatsOpt() {
            return this.showDetailedStatsOpt;
        }

        public OptionSet options() {
            return this.options;
        }

        public boolean useOldConsumer() {
            return this.useOldConsumer;
        }

        public boolean printMetrics() {
            return this.printMetrics;
        }

        public Properties props() {
            return this.props;
        }

        public int numThreads() {
            return this.numThreads;
        }

        public String topic() {
            return this.topic;
        }

        public long numMessages() {
            return this.numMessages;
        }

        public int reportingInterval() {
            return this.reportingInterval;
        }

        public boolean showDetailedStats() {
            return this.showDetailedStats;
        }

        public SimpleDateFormat dateFormat() {
            return this.dateFormat;
        }

        public boolean hideHeader() {
            return this.hideHeader;
        }

        public ConsumerPerfConfig(String[] args) {
            super(args);
            Object object;
            this.options = this.parser().parse(args);
            CommandLineUtils$.MODULE$.checkRequiredArgs(this.parser(), this.options(), (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{this.topicOpt(), this.numMessagesOpt()}));
            this.useOldConsumer = this.options().has(this.zkConnectOpt());
            this.printMetrics = this.options().has((OptionSpec)this.printMetricsOpt());
            Properties properties = this.props = this.options().has(this.consumerConfigOpt()) ? Utils.loadProps((String)this.options().valueOf(this.consumerConfigOpt())) : new Properties();
            if (!this.useOldConsumer()) {
                CommandLineUtils$.MODULE$.checkRequiredArgs(this.parser(), this.options(), (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{this.bootstrapServersOpt()}));
                if (this.options().has((OptionSpec)this.newConsumerOpt())) {
                    Console$.MODULE$.err().println("The --new-consumer option is deprecated and will be removed in a future major release.The new consumer is used by default if the --bootstrap-server option is provided.");
                }
                this.props().put("bootstrap.servers", this.options().valueOf(this.bootstrapServersOpt()));
                this.props().put("group.id", this.options().valueOf(this.groupIdOpt()));
                this.props().put("receive.buffer.bytes", ((Integer)this.options().valueOf(this.socketBufferSizeOpt())).toString());
                this.props().put("max.partition.fetch.bytes", ((Integer)this.options().valueOf(this.fetchSizeOpt())).toString());
                this.props().put("auto.offset.reset", this.options().has((OptionSpec)this.resetBeginningOffsetOpt()) ? "latest" : "earliest");
                this.props().put("key.deserializer", ByteArrayDeserializer.class);
                this.props().put("value.deserializer", ByteArrayDeserializer.class);
                object = this.props().put("check.crcs", "false");
            } else {
                if (this.options().has(this.bootstrapServersOpt())) {
                    throw CommandLineUtils$.MODULE$.printUsageAndDie(this.parser(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Option ", " is not valid with ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.bootstrapServersOpt(), this.zkConnectOpt()})));
                }
                if (this.options().has((OptionSpec)this.newConsumerOpt())) {
                    throw CommandLineUtils$.MODULE$.printUsageAndDie(this.parser(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Option ", " is not valid with ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.newConsumerOpt(), this.zkConnectOpt()})));
                }
                CommandLineUtils$.MODULE$.checkRequiredArgs(this.parser(), this.options(), (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{this.zkConnectOpt(), this.numMessagesOpt()}));
                this.props().put("group.id", this.options().valueOf(this.groupIdOpt()));
                this.props().put("socket.receive.buffer.bytes", ((Integer)this.options().valueOf(this.socketBufferSizeOpt())).toString());
                this.props().put("fetch.message.max.bytes", ((Integer)this.options().valueOf(this.fetchSizeOpt())).toString());
                this.props().put("auto.offset.reset", this.options().has((OptionSpec)this.resetBeginningOffsetOpt()) ? "largest" : "smallest");
                this.props().put("zookeeper.connect", this.options().valueOf(this.zkConnectOpt()));
                this.props().put("consumer.timeout.ms", "1000");
                object = this.props().put("num.consumer.fetchers", ((Integer)this.options().valueOf(this.numFetchersOpt())).toString());
            }
            this.numThreads = (Integer)this.options().valueOf(this.numThreadsOpt());
            this.topic = (String)this.options().valueOf(this.topicOpt());
            this.numMessages = (Long)this.options().valueOf(this.numMessagesOpt());
            this.reportingInterval = (Integer)this.options().valueOf(this.reportingIntervalOpt());
            if (this.reportingInterval() <= 0) {
                throw new IllegalArgumentException("Reporting interval must be greater than 0.");
            }
            this.showDetailedStats = this.options().has((OptionSpec)this.showDetailedStatsOpt());
            this.dateFormat = new SimpleDateFormat((String)this.options().valueOf(this.dateFormatOpt()));
            this.hideHeader = this.options().has((OptionSpec)this.hideHeaderOpt());
        }
    }

    public static class ConsumerPerfThread
    extends Thread {
        private final int threadId;
        private final KafkaStream<byte[], byte[]> stream;
        private final ConsumerPerfConfig config;
        private final AtomicLong totalMessagesRead;
        private final AtomicLong totalBytesRead;
        private final AtomicBoolean consumerTimeout;

        @Override
        public void run() {
            block7: {
                long startMs;
                long bytesRead = 0L;
                long messagesRead = 0L;
                long lastReportTime = startMs = System.currentTimeMillis();
                long lastBytesRead = 0L;
                long lastMessagesRead = 0L;
                try {
                    Iterator iter = this.stream.iterator();
                    while (iter.hasNext() && messagesRead < this.config.numMessages()) {
                        Object messageAndMetadata = iter.next();
                        ++messagesRead;
                        bytesRead += (long)((byte[])((MessageAndMetadata)messageAndMetadata).message()).length;
                        long currentTimeMillis = System.currentTimeMillis();
                        if (currentTimeMillis - lastReportTime < (long)this.config.reportingInterval()) continue;
                        if (this.config.showDetailedStats()) {
                            ConsumerPerformance$.MODULE$.printOldConsumerProgress(this.threadId, bytesRead, lastBytesRead, messagesRead, lastMessagesRead, lastReportTime, currentTimeMillis, this.config.dateFormat());
                        }
                        lastReportTime = currentTimeMillis;
                        lastMessagesRead = messagesRead;
                        lastBytesRead = bytesRead;
                    }
                }
                catch (InterruptedException interruptedException) {
                }
                catch (ClosedByInterruptException closedByInterruptException) {
                }
                catch (ConsumerTimeoutException consumerTimeoutException) {
                    this.consumerTimeout.set(true);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                this.totalMessagesRead.addAndGet(messagesRead);
                this.totalBytesRead.addAndGet(bytesRead);
                if (!this.config.showDetailedStats()) break block7;
                ConsumerPerformance$.MODULE$.printOldConsumerProgress(this.threadId, bytesRead, lastBytesRead, messagesRead, lastMessagesRead, startMs, System.currentTimeMillis(), this.config.dateFormat());
            }
        }

        public ConsumerPerfThread(int threadId, String name, KafkaStream<byte[], byte[]> stream, ConsumerPerfConfig config, AtomicLong totalMessagesRead, AtomicLong totalBytesRead, AtomicBoolean consumerTimeout) {
            this.threadId = threadId;
            this.stream = stream;
            this.config = config;
            this.totalMessagesRead = totalMessagesRead;
            this.totalBytesRead = totalBytesRead;
            this.consumerTimeout = consumerTimeout;
            super(name);
        }
    }
}

