/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.tools;

import io.confluent.kafka.common.KafkaException;
import io.confluent.kafka.common.MessageReader;
import io.confluent.kafka.message.DefaultCompressionCodec$;
import io.confluent.kafka.message.NoCompressionCodec$;
import io.confluent.kafka.serializer.DefaultEncoder;
import io.confluent.kafka.tools.ConsoleProducer$;
import io.confluent.kafka.utils.CommandLineUtils$;
import io.confluent.kafka.utils.ToolsUtils$;
import io.confluent.org.apache.kafka.clients.producer.ProducerRecord;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\r5s!B\u0001\u0003\u0011\u00039\u0011aD\"p]N|G.\u001a)s_\u0012,8-\u001a:\u000b\u0005\r!\u0011!\u0002;p_2\u001c(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001A\u0011\u0001\"C\u0007\u0002\u0005\u0019)!B\u0001E\u0001\u0017\ty1i\u001c8t_2,\u0007K]8ek\u000e,'o\u0005\u0002\n\u0019A\u0011Q\u0002E\u0007\u0002\u001d)\tq\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0012\u001d\t1\u0011I\\=SK\u001aDQaE\u0005\u0005\u0002Q\ta\u0001P5oSRtD#A\u0004\t\u000bYIA\u0011A\f\u0002\t5\f\u0017N\u001c\u000b\u00031m\u0001\"!D\r\n\u0005iq!\u0001B+oSRDQ\u0001H\u000bA\u0002u\tA!\u0019:hgB\u0019QB\b\u0011\n\u0005}q!!B!se\u0006L\bCA\u0011)\u001d\t\u0011c\u0005\u0005\u0002$\u001d5\tAE\u0003\u0002&\r\u00051AH]8pizJ!a\n\b\u0002\rA\u0013X\rZ3g\u0013\tI#F\u0001\u0004TiJLgn\u001a\u0006\u0003O9AQ\u0001L\u0005\u0005\u00025\nabZ3u%\u0016\fG-\u001a:Qe>\u00048\u000f\u0006\u0002/mA\u0011q\u0006N\u0007\u0002a)\u0011\u0011GM\u0001\u0005kRLGNC\u00014\u0003\u0011Q\u0017M^1\n\u0005U\u0002$A\u0003)s_B,'\u000f^5fg\")qg\u000ba\u0001q\u000511m\u001c8gS\u001e\u0004\"!\u000f\u001e\u000e\u0003%1AaO\u0005\u0001y\tq\u0001K]8ek\u000e,'oQ8oM&<7C\u0001\u001e\r\u0011!a\"H!A!\u0002\u0013i\u0002\"B\n;\t\u0003yDC\u0001\u001dA\u0011\u0015ab\b1\u0001\u001e\u0011\u001d\u0011%H1A\u0005\u0002\r\u000ba\u0001]1sg\u0016\u0014X#\u0001#\u0011\u0005\u0015CU\"\u0001$\u000b\u0003\u001d\u000b!B[8qiNLW\u000e\u001d7f\u0013\tIeI\u0001\u0007PaRLwN\u001c)beN,'\u000f\u0003\u0004Lu\u0001\u0006I\u0001R\u0001\ba\u0006\u00148/\u001a:!\u0011\u001di%H1A\u0005\u00029\u000b\u0001\u0002^8qS\u000e|\u0005\u000f^\u000b\u0002\u001fB\u0019Q\t\u0015\u0011\n\u0005E3%aG!sOVlWM\u001c;BG\u000e,\u0007\u000f^5oO>\u0003H/[8o'B,7\r\u0003\u0004Tu\u0001\u0006IaT\u0001\ni>\u0004\u0018nY(qi\u0002Bq!\u0016\u001eC\u0002\u0013\u0005a*A\u0007ce>\\WM\u001d'jgR|\u0005\u000f\u001e\u0005\u0007/j\u0002\u000b\u0011B(\u0002\u001d\t\u0014xn[3s\u0019&\u001cHo\u00149uA!9\u0011L\u000fb\u0001\n\u0003Q\u0016aB:z]\u000e|\u0005\u000f^\u000b\u00027B\u0011Q\tX\u0005\u0003;\u001a\u0013\u0011c\u00149uS>t7\u000b]3d\u0005VLG\u000eZ3s\u0011\u0019y&\b)A\u00057\u0006A1/\u001f8d\u001fB$\b\u0005C\u0004bu\t\u0007I\u0011\u0001(\u0002'\r|W\u000e\u001d:fgNLwN\\\"pI\u0016\u001cw\n\u001d;\t\r\rT\u0004\u0015!\u0003P\u0003Q\u0019w.\u001c9sKN\u001c\u0018n\u001c8D_\u0012,7m\u00149uA!9QM\u000fb\u0001\n\u00031\u0017\u0001\u00042bi\u000eD7+\u001b>f\u001fB$X#A4\u0011\u0007\u0015\u0003\u0006\u000e\u0005\u0002jY6\t!N\u0003\u0002le\u0005!A.\u00198h\u0013\ti'NA\u0004J]R,w-\u001a:\t\r=T\u0004\u0015!\u0003h\u00035\u0011\u0017\r^2i'&TXm\u00149uA!9\u0011O\u000fb\u0001\n\u00031\u0017\u0001G7fgN\fw-Z*f]\u0012l\u0015\r\u001f*fiJLWm](qi\"11O\u000fQ\u0001\n\u001d\f\u0011$\\3tg\u0006<WmU3oI6\u000b\u0007PU3ue&,7o\u00149uA!9QO\u000fb\u0001\n\u00031\u0017!\u0005:fiJL()Y2l_\u001a4Wj](qi\"1qO\u000fQ\u0001\n\u001d\f!C]3uef\u0014\u0015mY6pM\u001al5o\u00149uA!9\u0011P\u000fb\u0001\n\u00031\u0017AD:f]\u0012$\u0016.\\3pkR|\u0005\u000f\u001e\u0005\u0007wj\u0002\u000b\u0011B4\u0002\u001fM,g\u000e\u001a+j[\u0016|W\u000f^(qi\u0002Bq! \u001eC\u0002\u0013\u0005a-\u0001\u0007rk\u0016,XmU5{K>\u0003H\u000f\u0003\u0004\u0000u\u0001\u0006IaZ\u0001\u000ecV,W/Z*ju\u0016|\u0005\u000f\u001e\u0011\t\u0011\u0005\r!H1A\u0005\u0002\u0019\f\u0001$];fk\u0016,e.];fk\u0016$\u0016.\\3pkRl5o\u00149u\u0011\u001d\t9A\u000fQ\u0001\n\u001d\f\u0011$];fk\u0016,e.];fk\u0016$\u0016.\\3pkRl5o\u00149uA!I\u00111\u0002\u001eC\u0002\u0013\u0005\u0011QB\u0001\u0017e\u0016\fX/Z:u%\u0016\fX/\u001b:fI\u0006\u001b7n](qiV\u0011\u0011q\u0002\t\u0005\u000bB\u000b\t\u0002E\u0002j\u0003'I!!\u000b6\t\u0011\u0005]!\b)A\u0005\u0003\u001f\tqC]3rk\u0016\u001cHOU3rk&\u0014X\rZ!dWN|\u0005\u000f\u001e\u0011\t\u0011\u0005m!H1A\u0005\u0002\u0019\f1C]3rk\u0016\u001cH\u000fV5nK>,H/T:PaRDq!a\b;A\u0003%q-\u0001\u000bsKF,Xm\u001d;US6,w.\u001e;Ng>\u0003H\u000f\t\u0005\n\u0003GQ$\u0019!C\u0001\u0003K\t1#\\3uC\u0012\fG/Y#ya&\u0014\u00180T:PaR,\"!a\n\u0011\t\u0015\u0003\u0016\u0011\u0006\t\u0004S\u0006-\u0012bAA\u0017U\n!Aj\u001c8h\u0011!\t\tD\u000fQ\u0001\n\u0005\u001d\u0012\u0001F7fi\u0006$\u0017\r^1FqBL'/_'t\u001fB$\b\u0005C\u0005\u00026i\u0012\r\u0011\"\u0001\u0002&\u0005iQ.\u0019=CY>\u001c7.T:PaRD\u0001\"!\u000f;A\u0003%\u0011qE\u0001\u000f[\u0006D(\t\\8dW6\u001bx\n\u001d;!\u0011%\tiD\u000fb\u0001\n\u0003\t)#A\tnCblU-\\8ss\nKH/Z:PaRD\u0001\"!\u0011;A\u0003%\u0011qE\u0001\u0013[\u0006DX*Z7pef\u0014\u0015\u0010^3t\u001fB$\b\u0005C\u0005\u0002Fi\u0012\r\u0011\"\u0001\u0002&\u0005QR.\u0019=QCJ$\u0018\u000e^5p]6+Wn\u001c:z\u0005f$Xm](qi\"A\u0011\u0011\n\u001e!\u0002\u0013\t9#A\u000enCb\u0004\u0016M\u001d;ji&|g.T3n_JL()\u001f;fg>\u0003H\u000f\t\u0005\n\u0003\u001bR$\u0019!C\u0001\u0003\u001b\tqB^1mk\u0016,enY8eKJ|\u0005\u000f\u001e\u0005\t\u0003#R\u0004\u0015!\u0003\u0002\u0010\u0005\u0001b/\u00197vK\u0016s7m\u001c3fe>\u0003H\u000f\t\u0005\n\u0003+R$\u0019!C\u0001\u0003\u001b\tQb[3z\u000b:\u001cw\u000eZ3s\u001fB$\b\u0002CA-u\u0001\u0006I!a\u0004\u0002\u001d-,\u00170\u00128d_\u0012,'o\u00149uA!I\u0011Q\f\u001eC\u0002\u0013\u0005\u0011QB\u0001\u0011[\u0016\u001c8/Y4f%\u0016\fG-\u001a:PaRD\u0001\"!\u0019;A\u0003%\u0011qB\u0001\u0012[\u0016\u001c8/Y4f%\u0016\fG-\u001a:PaR\u0004\u0003\u0002CA3u\t\u0007I\u0011\u00014\u0002'M|7m[3u\u0005V4g-\u001a:TSj,w\n\u001d;\t\u000f\u0005%$\b)A\u0005O\u0006!2o\\2lKR\u0014UO\u001a4feNK'0Z(qi\u0002B\u0001\"!\u001c;\u0005\u0004%\tAT\u0001\faJ|\u0007/\u001a:us>\u0003H\u000fC\u0004\u0002ri\u0002\u000b\u0011B(\u0002\u0019A\u0014x\u000e]3sif|\u0005\u000f\u001e\u0011\t\u0011\u0005U$H1A\u0005\u00029\u000b1\u0003\u001d:pIV\u001cWM\u001d)s_B,'\u000f^=PaRDq!!\u001f;A\u0003%q*\u0001\u000bqe>$WoY3s!J|\u0007/\u001a:us>\u0003H\u000f\t\u0005\t\u0003{R$\u0019!C\u0001\u001d\u0006\t\u0002O]8ek\u000e,'oQ8oM&<w\n\u001d;\t\u000f\u0005\u0005%\b)A\u0005\u001f\u0006\u0011\u0002O]8ek\u000e,'oQ8oM&<w\n\u001d;!\u0011!\t)I\u000fb\u0001\n\u0003Q\u0016!E;tK>cG\r\u0015:pIV\u001cWM](qi\"9\u0011\u0011\u0012\u001e!\u0002\u0013Y\u0016AE;tK>cG\r\u0015:pIV\u001cWM](qi\u0002B\u0011\"!$;\u0005\u0004%\t!a$\u0002\u000f=\u0004H/[8ogV\u0011\u0011\u0011\u0013\t\u0004\u000b\u0006M\u0015bAAK\r\nIq\n\u001d;j_:\u001cV\r\u001e\u0005\t\u00033S\u0004\u0015!\u0003\u0002\u0012\u0006Aq\u000e\u001d;j_:\u001c\b\u0005C\u0005\u0002\u001ej\u0012\r\u0011\"\u0001\u0002 \u0006qQo]3PY\u0012\u0004&o\u001c3vG\u0016\u0014XCAAQ!\ri\u00111U\u0005\u0004\u0003Ks!a\u0002\"p_2,\u0017M\u001c\u0005\t\u0003SS\u0004\u0015!\u0003\u0002\"\u0006yQo]3PY\u0012\u0004&o\u001c3vG\u0016\u0014\b\u0005C\u0005\u0002.j\u0012\r\u0011\"\u0001\u00020\u0006)Ao\u001c9jGV\t\u0001\u0005C\u0004\u00024j\u0002\u000b\u0011\u0002\u0011\u0002\rQ|\u0007/[2!\u0011%\t9L\u000fb\u0001\n\u0003\ty+\u0001\u0006ce>\\WM\u001d'jgRDq!a/;A\u0003%\u0001%A\u0006ce>\\WM\u001d'jgR\u0004\u0003\"CA`u\t\u0007I\u0011AAP\u0003\u0011\u0019\u0018P\\2\t\u0011\u0005\r'\b)A\u0005\u0003C\u000bQa]=oG\u0002B\u0011\"a2;\u0005\u0004%\t!a,\u00027\r|W\u000e\u001d:fgNLwN\\\"pI\u0016\u001cw\n\u001d;j_:4\u0016\r\\;f\u0011\u001d\tYM\u000fQ\u0001\n\u0001\nAdY8naJ,7o]5p]\u000e{G-Z2PaRLwN\u001c,bYV,\u0007\u0005C\u0005\u0002Pj\u0012\r\u0011\"\u0001\u0002R\u0006\u00012m\\7qe\u0016\u001c8/[8o\u0007>$WmY\u000b\u0003\u0003#A\u0001\"!6;A\u0003%\u0011\u0011C\u0001\u0012G>l\u0007O]3tg&|gnQ8eK\u000e\u0004\u0003\"CAmu\t\u0007I\u0011AAn\u0003%\u0011\u0017\r^2i'&TX-F\u0001i\u0011\u001d\tyN\u000fQ\u0001\n!\f!BY1uG\"\u001c\u0016N_3!\u0011%\t\u0019O\u000fb\u0001\n\u0003\tY.A\u0006tK:$G+[7f_V$\bbBAtu\u0001\u0006I\u0001[\u0001\rg\u0016tG\rV5nK>,H\u000f\t\u0005\n\u0003WT$\u0019!C\u0001\u00037\f\u0011\"];fk\u0016\u001c\u0016N_3\t\u000f\u0005=(\b)A\u0005Q\u0006Q\u0011/^3vKNK'0\u001a\u0011\t\u0013\u0005M(H1A\u0005\u0002\u0005m\u0017!F9vKV,WI\\9vKV,G+[7f_V$Xj\u001d\u0005\b\u0003oT\u0004\u0015!\u0003i\u0003Y\tX/Z;f\u000b:\fX/Z;f)&lWm\\;u\u001bN\u0004\u0003\"CA~u\t\u0007I\u0011AAi\u0003M\u0011X-];fgR\u0014V-];je\u0016$\u0017iY6t\u0011!\tyP\u000fQ\u0001\n\u0005E\u0011\u0001\u0006:fcV,7\u000f\u001e*fcVL'/\u001a3BG.\u001c\b\u0005C\u0005\u0003\u0004i\u0012\r\u0011\"\u0001\u0002\\\u0006\u0001\"/Z9vKN$H+[7f_V$Xj\u001d\u0005\b\u0005\u000fQ\u0004\u0015!\u0003i\u0003E\u0011X-];fgR$\u0016.\\3pkRl5\u000f\t\u0005\n\u0005\u0017Q$\u0019!C\u0001\u00037\fQ#\\3tg\u0006<WmU3oI6\u000b\u0007PU3ue&,7\u000fC\u0004\u0003\u0010i\u0002\u000b\u0011\u00025\u0002-5,7o]1hKN+g\u000eZ'bqJ+GO]5fg\u0002B\u0011Ba\u0005;\u0005\u0004%\t!a7\u0002\u001dI,GO]=CC\u000e\\wN\u001a4Ng\"9!q\u0003\u001e!\u0002\u0013A\u0017a\u0004:fiJL()Y2l_\u001a4Wj\u001d\u0011\t\u0013\tm!H1A\u0005\u0002\u0005E\u0017aD6fs\u0016s7m\u001c3fe\u000ec\u0017m]:\t\u0011\t}!\b)A\u0005\u0003#\t\u0001c[3z\u000b:\u001cw\u000eZ3s\u00072\f7o\u001d\u0011\t\u0013\t\r\"H1A\u0005\u0002\u0005E\u0017!\u0005<bYV,WI\\2pI\u0016\u00148\t\\1tg\"A!q\u0005\u001e!\u0002\u0013\t\t\"\u0001\nwC2,X-\u00128d_\u0012,'o\u00117bgN\u0004\u0003\"\u0003B\u0016u\t\u0007I\u0011AAi\u0003-\u0011X-\u00193fe\u000ec\u0017m]:\t\u0011\t=\"\b)A\u0005\u0003#\tAB]3bI\u0016\u00148\t\\1tg\u0002B\u0011Ba\r;\u0005\u0004%\t!a7\u0002\u0019M|7m[3u\u0005V4g-\u001a:\t\u000f\t]\"\b)A\u0005Q\u0006i1o\\2lKR\u0014UO\u001a4fe\u0002B\u0011Ba\u000f;\u0005\u0004%\tA!\u0010\u0002\u0019\rlG\rT5oKB\u0013x\u000e]:\u0016\u00039BqA!\u0011;A\u0003%a&A\u0007d[\u0012d\u0015N\\3Qe>\u00048\u000f\t\u0005\n\u0005\u000bR$\u0019!C\u0001\u0005{\t!#\u001a=ue\u0006\u0004&o\u001c3vG\u0016\u0014\bK]8qg\"9!\u0011\n\u001e!\u0002\u0013q\u0013aE3yiJ\f\u0007K]8ek\u000e,'\u000f\u0015:paN\u0004\u0003\"\u0003B'u\t\u0007I\u0011\u0001B(\u00039i\u0017\r_'f[>\u0014\u0018PQ=uKN,\"!!\u000b\t\u0011\tM#\b)A\u0005\u0003S\tq\"\\1y\u001b\u0016lwN]=CsR,7\u000f\t\u0005\n\u0005/R$\u0019!C\u0001\u0005\u001f\nq#\\1y!\u0006\u0014H/\u001b;j_:lU-\\8ss\nKH/Z:\t\u0011\tm#\b)A\u0005\u0003S\t\u0001$\\1y!\u0006\u0014H/\u001b;j_:lU-\\8ss\nKH/Z:!\u0011%\u0011yF\u000fb\u0001\n\u0003\u0011y%\u0001\tnKR\fG-\u0019;b\u000bb\u0004\u0018N]=Ng\"A!1\r\u001e!\u0002\u0013\tI#A\tnKR\fG-\u0019;b\u000bb\u0004\u0018N]=Ng\u0002B\u0011Ba\u001a;\u0005\u0004%\tAa\u0014\u0002\u00155\f\u0007P\u00117pG.l5\u000f\u0003\u0005\u0003li\u0002\u000b\u0011BA\u0015\u0003-i\u0017\r\u001f\"m_\u000e\\Wj\u001d\u0011\t\u000f\t=\u0014\u0002\"\u0001\u0003r\u0005\u0019r-\u001a;PY\u0012\u0004&o\u001c3vG\u0016\u0014\bK]8qgR\u0019aFa\u001d\t\r]\u0012i\u00071\u00019\u0011\u001d\u00119(\u0003C\u0005\u0005s\nQ\u0002\u001d:pIV\u001cWM\u001d)s_B\u001cHc\u0001\u0018\u0003|!1qG!\u001eA\u0002aBqAa \n\t\u0003\u0011\t)A\nhKRtUm\u001e)s_\u0012,8-\u001a:Qe>\u00048\u000fF\u0002/\u0005\u0007Caa\u000eB?\u0001\u0004AdA\u0002BD\u0013\u0001\u0011IIA\tMS:,W*Z:tC\u001e,'+Z1eKJ\u001cRA!\"\r\u0005\u0017\u0003BA!$\u0003\u00146\u0011!q\u0012\u0006\u0004\u0005##\u0011AB2p[6|g.\u0003\u0003\u0003\u0016\n=%!D'fgN\fw-\u001a*fC\u0012,'\u000fC\u0004\u0014\u0005\u000b#\tA!'\u0015\u0005\tm\u0005cA\u001d\u0003\u0006\"Q\u0011Q\u0016BC\u0001\u0004%\t!a,\t\u0015\t\u0005&Q\u0011a\u0001\n\u0003\u0011\u0019+A\u0005u_BL7m\u0018\u0013fcR\u0019\u0001D!*\t\u0013\t\u001d&qTA\u0001\u0002\u0004\u0001\u0013a\u0001=%c!A\u00111\u0017BCA\u0003&\u0001\u0005\u0003\u0006\u0003.\n\u0015\u0005\u0019!C\u0001\u0005_\u000baA]3bI\u0016\u0014XC\u0001BY!\u0011\u0011\u0019L!/\u000e\u0005\tU&b\u0001B\\e\u0005\u0011\u0011n\\\u0005\u0005\u0005w\u0013)L\u0001\bCk\u001a4WM]3e%\u0016\fG-\u001a:\t\u0015\t}&Q\u0011a\u0001\n\u0003\u0011\t-\u0001\u0006sK\u0006$WM]0%KF$2\u0001\u0007Bb\u0011)\u00119K!0\u0002\u0002\u0003\u0007!\u0011\u0017\u0005\n\u0005\u000f\u0014)\t)Q\u0005\u0005c\u000bqA]3bI\u0016\u0014\b\u0005\u0003\u0006\u0003L\n\u0015\u0005\u0019!C\u0001\u0003?\u000b\u0001\u0002]1sg\u0016\\U-\u001f\u0005\u000b\u0005\u001f\u0014)\t1A\u0005\u0002\tE\u0017\u0001\u00049beN,7*Z=`I\u0015\fHc\u0001\r\u0003T\"Q!q\u0015Bg\u0003\u0003\u0005\r!!)\t\u0013\t]'Q\u0011Q!\n\u0005\u0005\u0016!\u00039beN,7*Z=!\u0011)\u0011YN!\"A\u0002\u0013\u0005\u0011\u0011[\u0001\rW\u0016L8+\u001a9be\u0006$xN\u001d\u0005\u000b\u0005?\u0014)\t1A\u0005\u0002\t\u0005\u0018\u0001E6fsN+\u0007/\u0019:bi>\u0014x\fJ3r)\rA\"1\u001d\u0005\u000b\u0005O\u0013i.!AA\u0002\u0005E\u0001\"\u0003Bt\u0005\u000b\u0003\u000b\u0015BA\t\u00035YW-_*fa\u0006\u0014\u0018\r^8sA!Q!1\u001eBC\u0001\u0004%\t!a(\u0002\u0017%<gn\u001c:f\u000bJ\u0014xN\u001d\u0005\u000b\u0005_\u0014)\t1A\u0005\u0002\tE\u0018aD5h]>\u0014X-\u0012:s_J|F%Z9\u0015\u0007a\u0011\u0019\u0010\u0003\u0006\u0003(\n5\u0018\u0011!a\u0001\u0003CC\u0011Ba>\u0003\u0006\u0002\u0006K!!)\u0002\u0019%<gn\u001c:f\u000bJ\u0014xN\u001d\u0011\t\u0015\tm(Q\u0011a\u0001\n\u0003\u0011i0\u0001\u0006mS:,g*^7cKJ,\"Aa@\u0011\u00075\u0019\t!C\u0002\u0004\u00049\u00111!\u00138u\u0011)\u00199A!\"A\u0002\u0013\u00051\u0011B\u0001\u000fY&tWMT;nE\u0016\u0014x\fJ3r)\rA21\u0002\u0005\u000b\u0005O\u001b)!!AA\u0002\t}\b\"CB\b\u0005\u000b\u0003\u000b\u0015\u0002B\u0000\u0003-a\u0017N\\3Ok6\u0014WM\u001d\u0011\t\u0011\rM!Q\u0011C!\u0007+\tA!\u001b8jiR)\u0001da\u0006\u0004\"!A1\u0011DB\t\u0001\u0004\u0019Y\"A\u0006j]B,Ho\u0015;sK\u0006l\u0007\u0003\u0002BZ\u0007;IAaa\b\u00036\nY\u0011J\u001c9viN#(/Z1n\u0011\u001d\u0019\u0019c!\u0005A\u00029\nQ\u0001\u001d:paND\u0001ba\n\u0003\u0006\u0012\u00053\u0011F\u0001\fe\u0016\fG-T3tg\u0006<W\r\u0006\u0002\u0004,AA1QFB!\u0007\u000b\u001a)%\u0004\u0002\u00040)!1\u0011GB\u001a\u0003!\u0001(o\u001c3vG\u0016\u0014(\u0002BB\u001b\u0007o\tqa\u00197jK:$8OC\u0002\u0006\u0007sQAaa\u000f\u0004>\u00051\u0011\r]1dQ\u0016T!aa\u0010\u0002\u0007=\u0014x-\u0003\u0003\u0004D\r=\"A\u0004)s_\u0012,8-\u001a:SK\u000e|'\u000f\u001a\t\u0005\u001by\u00199\u0005E\u0002\u000e\u0007\u0013J1aa\u0013\u000f\u0005\u0011\u0011\u0015\u0010^3")
public final class ConsoleProducer {
    public static Properties getNewProducerProps(ProducerConfig producerConfig) {
        return ConsoleProducer$.MODULE$.getNewProducerProps(producerConfig);
    }

    public static Properties getOldProducerProps(ProducerConfig producerConfig) {
        return ConsoleProducer$.MODULE$.getOldProducerProps(producerConfig);
    }

    public static Properties getReaderProps(ProducerConfig producerConfig) {
        return ConsoleProducer$.MODULE$.getReaderProps(producerConfig);
    }

    public static void main(String[] stringArray) {
        ConsoleProducer$.MODULE$.main(stringArray);
    }

    public static class LineMessageReader
    implements MessageReader {
        private String topic;
        private BufferedReader reader;
        private boolean parseKey;
        private String keySeparator;
        private boolean ignoreError;
        private int lineNumber;

        @Override
        public void close() {
            MessageReader.close$(this);
        }

        public String topic() {
            return this.topic;
        }

        public void topic_$eq(String x$1) {
            this.topic = x$1;
        }

        public BufferedReader reader() {
            return this.reader;
        }

        public void reader_$eq(BufferedReader x$1) {
            this.reader = x$1;
        }

        public boolean parseKey() {
            return this.parseKey;
        }

        public void parseKey_$eq(boolean x$1) {
            this.parseKey = x$1;
        }

        public String keySeparator() {
            return this.keySeparator;
        }

        public void keySeparator_$eq(String x$1) {
            this.keySeparator = x$1;
        }

        public boolean ignoreError() {
            return this.ignoreError;
        }

        public void ignoreError_$eq(boolean x$1) {
            this.ignoreError = x$1;
        }

        public int lineNumber() {
            return this.lineNumber;
        }

        public void lineNumber_$eq(int x$1) {
            this.lineNumber = x$1;
        }

        @Override
        public void init(InputStream inputStream, Properties props) {
            this.topic_$eq(props.getProperty("topic"));
            if (props.containsKey("parse.key")) {
                this.parseKey_$eq(props.getProperty("parse.key").trim().equalsIgnoreCase("true"));
            }
            if (props.containsKey("key.separator")) {
                this.keySeparator_$eq(props.getProperty("key.separator"));
            }
            if (props.containsKey("ignore.error")) {
                this.ignoreError_$eq(props.getProperty("ignore.error").trim().equalsIgnoreCase("true"));
            }
            this.reader_$eq(new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8)));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public ProducerRecord<byte[], byte[]> readMessage() {
            String string;
            this.lineNumber_$eq(this.lineNumber() + 1);
            Predef$.MODULE$.print((Object)">");
            Tuple2 tuple2 = new Tuple2((Object)this.reader().readLine(), (Object)BoxesRunTime.boxToBoolean((boolean)this.parseKey()));
            if (tuple2 != null && (string = (String)tuple2._1()) == null) {
                return null;
            }
            if (tuple2 != null) {
                String line = (String)tuple2._1();
                boolean bl = tuple2._2$mcZ$sp();
                if (bl) {
                    int n = line.indexOf(this.keySeparator());
                    switch (n) {
                        case -1: {
                            if (!this.ignoreError()) throw new KafkaException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No key found on line ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.lineNumber()), line})));
                            ProducerRecord<byte[], byte[]> producerRecord = new ProducerRecord<byte[], byte[]>(this.topic(), line.getBytes(StandardCharsets.UTF_8));
                            return producerRecord;
                        }
                        default: {
                            byte[] value = (n + new StringOps(Predef$.MODULE$.augmentString(this.keySeparator())).size() > new StringOps(Predef$.MODULE$.augmentString(line)).size() ? "" : line.substring(n + new StringOps(Predef$.MODULE$.augmentString(this.keySeparator())).size())).getBytes(StandardCharsets.UTF_8);
                            ProducerRecord<byte[], byte[]> producerRecord = new ProducerRecord<byte[], byte[]>(this.topic(), line.substring(0, n).getBytes(StandardCharsets.UTF_8), value);
                            return producerRecord;
                        }
                    }
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            String line = (String)tuple2._1();
            boolean bl = tuple2._2$mcZ$sp();
            if (false != bl) throw new MatchError((Object)tuple2);
            return new ProducerRecord(this.topic(), line.getBytes(StandardCharsets.UTF_8));
        }

        public LineMessageReader() {
            MessageReader.$init$(this);
            this.topic = null;
            this.reader = null;
            this.parseKey = false;
            this.keySeparator = "\t";
            this.ignoreError = false;
            this.lineNumber = 0;
        }
    }

    public static class ProducerConfig {
        private final OptionParser parser = new OptionParser(false);
        private final ArgumentAcceptingOptionSpec<String> topicOpt = this.parser().accepts("topic", "REQUIRED: The topic id to produce messages to.").withRequiredArg().describedAs("topic").ofType(String.class);
        private final ArgumentAcceptingOptionSpec<String> brokerListOpt = this.parser().accepts("broker-list", "REQUIRED: The broker list string in the form HOST1:PORT1,HOST2:PORT2.").withRequiredArg().describedAs("broker-list").ofType(String.class);
        private final OptionSpecBuilder syncOpt = this.parser().accepts("sync", "If set message send requests to the brokers are synchronously, one at a time as they arrive.");
        private final ArgumentAcceptingOptionSpec<String> compressionCodecOpt = this.parser().accepts("compression-codec", "The compression codec: either 'none', 'gzip', 'snappy', or 'lz4'.If specified without value, then it defaults to 'gzip'").withOptionalArg().describedAs("compression-codec").ofType(String.class);
        private final ArgumentAcceptingOptionSpec<Integer> batchSizeOpt = this.parser().accepts("batch-size", "Number of messages to send in a single batch if they are not being sent synchronously.").withRequiredArg().describedAs("size").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(200), (Object[])new Integer[0]);
        private final ArgumentAcceptingOptionSpec<Integer> messageSendMaxRetriesOpt = this.parser().accepts("message-send-max-retries", "Brokers can fail receiving the message for multiple reasons, and being unavailable transiently is just one of them. This property specifies the number of retires before the producer give up and drop this message.").withRequiredArg().ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(3), (Object[])new Integer[0]);
        private final ArgumentAcceptingOptionSpec<Integer> retryBackoffMsOpt = this.parser().accepts("retry-backoff-ms", "Before each retry, the producer refreshes the metadata of relevant topics. Since leader election takes a bit of time, this property specifies the amount of time that the producer waits before refreshing the metadata.").withRequiredArg().ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(100), (Object[])new Integer[0]);
        private final ArgumentAcceptingOptionSpec<Integer> sendTimeoutOpt = this.parser().accepts("timeout", "If set and the producer is running in asynchronous mode, this gives the maximum amount of time a message will queue awaiting sufficient batch size. The value is given in ms.").withRequiredArg().describedAs("timeout_ms").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(1000), (Object[])new Integer[0]);
        private final ArgumentAcceptingOptionSpec<Integer> queueSizeOpt = this.parser().accepts("queue-size", "If set and the producer is running in asynchronous mode, this gives the maximum amount of  messages will queue awaiting sufficient batch size.").withRequiredArg().describedAs("queue_size").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(10000), (Object[])new Integer[0]);
        private final ArgumentAcceptingOptionSpec<Integer> queueEnqueueTimeoutMsOpt = this.parser().accepts("queue-enqueuetimeout-ms", "Timeout for event enqueue").withRequiredArg().describedAs("queue enqueuetimeout ms").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(Integer.MAX_VALUE), (Object[])new Integer[0]);
        private final ArgumentAcceptingOptionSpec<String> requestRequiredAcksOpt = this.parser().accepts("request-required-acks", "The required acks of the producer requests").withRequiredArg().describedAs("request required acks").ofType(String.class).defaultsTo((Object)"1", (Object[])new String[0]);
        private final ArgumentAcceptingOptionSpec<Integer> requestTimeoutMsOpt = this.parser().accepts("request-timeout-ms", "The ack timeout of the producer requests. Value must be non-negative and non-zero").withRequiredArg().describedAs("request timeout ms").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(1500), (Object[])new Integer[0]);
        private final ArgumentAcceptingOptionSpec<Long> metadataExpiryMsOpt = this.parser().accepts("metadata-expiry-ms", "The period of time in milliseconds after which we force a refresh of metadata even if we haven't seen any leadership changes.").withRequiredArg().describedAs("metadata expiration interval").ofType(Long.class).defaultsTo((Object)Predef$.MODULE$.long2Long(300000L), (Object[])new Long[0]);
        private final ArgumentAcceptingOptionSpec<Long> maxBlockMsOpt = this.parser().accepts("max-block-ms", "The max time that the producer will block for during a send request").withRequiredArg().describedAs("max block on send").ofType(Long.class).defaultsTo((Object)Predef$.MODULE$.long2Long(60000L), (Object[])new Long[0]);
        private final ArgumentAcceptingOptionSpec<Long> maxMemoryBytesOpt = this.parser().accepts("max-memory-bytes", "The total memory used by the producer to buffer records waiting to be sent to the server.").withRequiredArg().describedAs("total memory in bytes").ofType(Long.class).defaultsTo((Object)Predef$.MODULE$.long2Long(0x2000000L), (Object[])new Long[0]);
        private final ArgumentAcceptingOptionSpec<Long> maxPartitionMemoryBytesOpt = this.parser().accepts("max-partition-memory-bytes", "The buffer size allocated for a partition. When records are received which are smaller than this size the producer will attempt to optimistically group them together until this size is reached.").withRequiredArg().describedAs("memory in bytes per partition").ofType(Long.class).defaultsTo((Object)Predef$.MODULE$.long2Long(16384L), (Object[])new Long[0]);
        private final ArgumentAcceptingOptionSpec<String> valueEncoderOpt = this.parser().accepts("value-serializer", "The class name of the message encoder implementation to use for serializing values.").withRequiredArg().describedAs("encoder_class").ofType(String.class).defaultsTo((Object)DefaultEncoder.class.getName(), (Object[])new String[0]);
        private final ArgumentAcceptingOptionSpec<String> keyEncoderOpt = this.parser().accepts("key-serializer", "The class name of the message encoder implementation to use for serializing keys.").withRequiredArg().describedAs("encoder_class").ofType(String.class).defaultsTo((Object)DefaultEncoder.class.getName(), (Object[])new String[0]);
        private final ArgumentAcceptingOptionSpec<String> messageReaderOpt = this.parser().accepts("line-reader", "The class name of the class to use for reading lines from standard in. By default each line is read as a separate message.").withRequiredArg().describedAs("reader_class").ofType(String.class).defaultsTo((Object)LineMessageReader.class.getName(), (Object[])new String[0]);
        private final ArgumentAcceptingOptionSpec<Integer> socketBufferSizeOpt = this.parser().accepts("socket-buffer-size", "The size of the tcp RECV size.").withRequiredArg().describedAs("size").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(102400), (Object[])new Integer[0]);
        private final ArgumentAcceptingOptionSpec<String> propertyOpt = this.parser().accepts("property", "A mechanism to pass user-defined properties in the form key=value to the message reader. This allows custom configuration for a user-defined message reader.").withRequiredArg().describedAs("prop").ofType(String.class);
        private final ArgumentAcceptingOptionSpec<String> producerPropertyOpt = this.parser().accepts("producer-property", "A mechanism to pass user-defined properties in the form key=value to the producer. ").withRequiredArg().describedAs("producer_prop").ofType(String.class);
        private final ArgumentAcceptingOptionSpec<String> producerConfigOpt = this.parser().accepts("producer.config", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Producer config properties file. Note that ", " takes precedence over this config."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.producerPropertyOpt()}))).withRequiredArg().describedAs("config file").ofType(String.class);
        private final OptionSpecBuilder useOldProducerOpt = this.parser().accepts("old-producer", "Use the old producer implementation.");
        private final OptionSet options;
        private final boolean useOldProducer;
        private final String topic;
        private final String brokerList;
        private final boolean sync;
        private final String compressionCodecOptionValue;
        private final String compressionCodec;
        private final Integer batchSize;
        private final Integer sendTimeout;
        private final Integer queueSize;
        private final Integer queueEnqueueTimeoutMs;
        private final String requestRequiredAcks;
        private final Integer requestTimeoutMs;
        private final Integer messageSendMaxRetries;
        private final Integer retryBackoffMs;
        private final String keyEncoderClass;
        private final String valueEncoderClass;
        private final String readerClass;
        private final Integer socketBuffer;
        private final Properties cmdLineProps;
        private final Properties extraProducerProps;
        private final Long maxMemoryBytes;
        private final Long maxPartitionMemoryBytes;
        private final Long metadataExpiryMs;
        private final Long maxBlockMs;

        public OptionParser parser() {
            return this.parser;
        }

        public ArgumentAcceptingOptionSpec<String> topicOpt() {
            return this.topicOpt;
        }

        public ArgumentAcceptingOptionSpec<String> brokerListOpt() {
            return this.brokerListOpt;
        }

        public OptionSpecBuilder syncOpt() {
            return this.syncOpt;
        }

        public ArgumentAcceptingOptionSpec<String> compressionCodecOpt() {
            return this.compressionCodecOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> batchSizeOpt() {
            return this.batchSizeOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> messageSendMaxRetriesOpt() {
            return this.messageSendMaxRetriesOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> retryBackoffMsOpt() {
            return this.retryBackoffMsOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> sendTimeoutOpt() {
            return this.sendTimeoutOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> queueSizeOpt() {
            return this.queueSizeOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> queueEnqueueTimeoutMsOpt() {
            return this.queueEnqueueTimeoutMsOpt;
        }

        public ArgumentAcceptingOptionSpec<String> requestRequiredAcksOpt() {
            return this.requestRequiredAcksOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> requestTimeoutMsOpt() {
            return this.requestTimeoutMsOpt;
        }

        public ArgumentAcceptingOptionSpec<Long> metadataExpiryMsOpt() {
            return this.metadataExpiryMsOpt;
        }

        public ArgumentAcceptingOptionSpec<Long> maxBlockMsOpt() {
            return this.maxBlockMsOpt;
        }

        public ArgumentAcceptingOptionSpec<Long> maxMemoryBytesOpt() {
            return this.maxMemoryBytesOpt;
        }

        public ArgumentAcceptingOptionSpec<Long> maxPartitionMemoryBytesOpt() {
            return this.maxPartitionMemoryBytesOpt;
        }

        public ArgumentAcceptingOptionSpec<String> valueEncoderOpt() {
            return this.valueEncoderOpt;
        }

        public ArgumentAcceptingOptionSpec<String> keyEncoderOpt() {
            return this.keyEncoderOpt;
        }

        public ArgumentAcceptingOptionSpec<String> messageReaderOpt() {
            return this.messageReaderOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> socketBufferSizeOpt() {
            return this.socketBufferSizeOpt;
        }

        public ArgumentAcceptingOptionSpec<String> propertyOpt() {
            return this.propertyOpt;
        }

        public ArgumentAcceptingOptionSpec<String> producerPropertyOpt() {
            return this.producerPropertyOpt;
        }

        public ArgumentAcceptingOptionSpec<String> producerConfigOpt() {
            return this.producerConfigOpt;
        }

        public OptionSpecBuilder useOldProducerOpt() {
            return this.useOldProducerOpt;
        }

        public OptionSet options() {
            return this.options;
        }

        public boolean useOldProducer() {
            return this.useOldProducer;
        }

        public String topic() {
            return this.topic;
        }

        public String brokerList() {
            return this.brokerList;
        }

        public boolean sync() {
            return this.sync;
        }

        public String compressionCodecOptionValue() {
            return this.compressionCodecOptionValue;
        }

        public String compressionCodec() {
            return this.compressionCodec;
        }

        public Integer batchSize() {
            return this.batchSize;
        }

        public Integer sendTimeout() {
            return this.sendTimeout;
        }

        public Integer queueSize() {
            return this.queueSize;
        }

        public Integer queueEnqueueTimeoutMs() {
            return this.queueEnqueueTimeoutMs;
        }

        public String requestRequiredAcks() {
            return this.requestRequiredAcks;
        }

        public Integer requestTimeoutMs() {
            return this.requestTimeoutMs;
        }

        public Integer messageSendMaxRetries() {
            return this.messageSendMaxRetries;
        }

        public Integer retryBackoffMs() {
            return this.retryBackoffMs;
        }

        public String keyEncoderClass() {
            return this.keyEncoderClass;
        }

        public String valueEncoderClass() {
            return this.valueEncoderClass;
        }

        public String readerClass() {
            return this.readerClass;
        }

        public Integer socketBuffer() {
            return this.socketBuffer;
        }

        public Properties cmdLineProps() {
            return this.cmdLineProps;
        }

        public Properties extraProducerProps() {
            return this.extraProducerProps;
        }

        public Long maxMemoryBytes() {
            return this.maxMemoryBytes;
        }

        public Long maxPartitionMemoryBytes() {
            return this.maxPartitionMemoryBytes;
        }

        public Long metadataExpiryMs() {
            return this.metadataExpiryMs;
        }

        public Long maxBlockMs() {
            return this.maxBlockMs;
        }

        public ProducerConfig(String[] args) {
            this.options = this.parser().parse(args);
            if (args.length == 0) {
                throw CommandLineUtils$.MODULE$.printUsageAndDie(this.parser(), "Read data from standard input and publish it to Kafka.");
            }
            CommandLineUtils$.MODULE$.checkRequiredArgs(this.parser(), this.options(), (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{this.topicOpt(), this.brokerListOpt()}));
            this.useOldProducer = this.options().has((OptionSpec)this.useOldProducerOpt());
            this.topic = (String)this.options().valueOf(this.topicOpt());
            this.brokerList = (String)this.options().valueOf(this.brokerListOpt());
            ToolsUtils$.MODULE$.validatePortOrDie(this.parser(), this.brokerList());
            this.sync = this.options().has((OptionSpec)this.syncOpt());
            this.compressionCodecOptionValue = (String)this.options().valueOf(this.compressionCodecOpt());
            this.compressionCodec = this.options().has(this.compressionCodecOpt()) ? (this.compressionCodecOptionValue() == null || this.compressionCodecOptionValue().isEmpty() ? DefaultCompressionCodec$.MODULE$.name() : this.compressionCodecOptionValue()) : NoCompressionCodec$.MODULE$.name();
            this.batchSize = (Integer)this.options().valueOf(this.batchSizeOpt());
            this.sendTimeout = (Integer)this.options().valueOf(this.sendTimeoutOpt());
            this.queueSize = (Integer)this.options().valueOf(this.queueSizeOpt());
            this.queueEnqueueTimeoutMs = (Integer)this.options().valueOf(this.queueEnqueueTimeoutMsOpt());
            this.requestRequiredAcks = (String)this.options().valueOf(this.requestRequiredAcksOpt());
            this.requestTimeoutMs = (Integer)this.options().valueOf(this.requestTimeoutMsOpt());
            this.messageSendMaxRetries = (Integer)this.options().valueOf(this.messageSendMaxRetriesOpt());
            this.retryBackoffMs = (Integer)this.options().valueOf(this.retryBackoffMsOpt());
            this.keyEncoderClass = (String)this.options().valueOf(this.keyEncoderOpt());
            this.valueEncoderClass = (String)this.options().valueOf(this.valueEncoderOpt());
            this.readerClass = (String)this.options().valueOf(this.messageReaderOpt());
            this.socketBuffer = (Integer)this.options().valueOf(this.socketBufferSizeOpt());
            this.cmdLineProps = CommandLineUtils$.MODULE$.parseKeyValueArgs((Iterable<String>)((Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(this.options().valuesOf(this.propertyOpt())).asScala()), CommandLineUtils$.MODULE$.parseKeyValueArgs$default$2());
            this.extraProducerProps = CommandLineUtils$.MODULE$.parseKeyValueArgs((Iterable<String>)((Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(this.options().valuesOf(this.producerPropertyOpt())).asScala()), CommandLineUtils$.MODULE$.parseKeyValueArgs$default$2());
            this.maxMemoryBytes = (Long)this.options().valueOf(this.maxMemoryBytesOpt());
            this.maxPartitionMemoryBytes = (Long)this.options().valueOf(this.maxPartitionMemoryBytesOpt());
            this.metadataExpiryMs = (Long)this.options().valueOf(this.metadataExpiryMsOpt());
            this.maxBlockMs = (Long)this.options().valueOf(this.maxBlockMsOpt());
        }
    }
}

