/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.shaded.serializers;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.kafka.shaded.serializers.KafkaJsonDecoderConfig;
import io.confluent.kafka.shaded.serializers.KafkaJsonDeserializerConfig;
import io.confluent.org.apache.kafka.common.errors.SerializationException;
import io.confluent.org.apache.kafka.common.serialization.Deserializer;
import java.util.Map;

public class KafkaJsonDeserializer<T>
implements Deserializer<T> {
    private ObjectMapper objectMapper;
    private Class<T> type;

    @Override
    public void configure(Map<String, ?> props, boolean isKey) {
        this.configure(new KafkaJsonDeserializerConfig(props), isKey);
    }

    protected void configure(KafkaJsonDecoderConfig config, Class<T> type) {
        this.objectMapper = new ObjectMapper();
        this.type = type;
        boolean failUnknownProperties = config.getBoolean("json.fail.unknown.properties");
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, failUnknownProperties);
    }

    private void configure(KafkaJsonDeserializerConfig config, boolean isKey) {
        if (isKey) {
            this.configure((KafkaJsonDecoderConfig)config, config.getClass("json.key.type"));
        } else {
            this.configure((KafkaJsonDecoderConfig)config, config.getClass("json.value.type"));
        }
    }

    @Override
    public T deserialize(String ignored, byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        try {
            return (T)this.objectMapper.readValue(bytes, this.type);
        }
        catch (Exception e) {
            throw new SerializationException(e);
        }
    }

    protected Class<T> getType() {
        return this.type;
    }

    @Override
    public void close() {
    }
}

