/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.shaded.serializers;

import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.shaded.serializers.AbstractKafkaAvroSerializer;
import io.confluent.kafka.shaded.serializers.AvroSchemaUtils;
import io.confluent.kafka.shaded.serializers.KafkaAvroSerializerConfig;
import io.confluent.org.apache.kafka.common.serialization.Serializer;
import java.util.Map;

public class KafkaAvroSerializer
extends AbstractKafkaAvroSerializer
implements Serializer<Object> {
    private boolean isKey;

    public KafkaAvroSerializer() {
    }

    public KafkaAvroSerializer(SchemaRegistryClient client) {
        this.schemaRegistry = client;
    }

    public KafkaAvroSerializer(SchemaRegistryClient client, Map<String, ?> props) {
        this.schemaRegistry = client;
        this.configure(this.serializerConfig(props));
    }

    @Override
    public void configure(Map<String, ?> configs, boolean isKey) {
        this.isKey = isKey;
        this.configure(new KafkaAvroSerializerConfig(configs));
    }

    @Override
    public byte[] serialize(String topic, Object record) {
        return this.serializeImpl(this.getSubjectName(topic, this.isKey, record, AvroSchemaUtils.getSchema(record, this.useSchemaReflection)), record);
    }

    @Override
    public void close() {
    }
}

