/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.server;

import io.confluent.org.apache.kafka.common.utils.Time;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import scala.Function1;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001u3Q!\u0001\u0002\u0001\u0005\u0019\u0011\u0011\u0003\u00165s_R$H.\u001a3SKN\u0004xN\\:f\u0015\t\u0019A!\u0001\u0004tKJ4XM\u001d\u0006\u0002\u000b\u0005)1.\u00194lCN\u0019\u0001aB\b\u0011\u0005!iQ\"A\u0005\u000b\u0005)Y\u0011\u0001\u00027b]\u001eT\u0011\u0001D\u0001\u0005U\u00064\u0018-\u0003\u0002\u000f\u0013\t1qJ\u00196fGR\u0004\"\u0001E\u000b\u000e\u0003EQ!AE\n\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002\u0015\u0017\u0005!Q\u000f^5m\u0013\t1\u0012CA\u0004EK2\f\u00170\u001a3\t\u0011a\u0001!Q1A\u0005\u0002i\tA\u0001^5nK\u000e\u0001Q#A\u000e\u0011\u0005q1S\"A\u000f\u000b\u0005yy\u0012!B;uS2\u001c(B\u0001\u0011\"\u0003\u0019\u0019w.\\7p]*\u0011QA\t\u0006\u0003G\u0011\na!\u00199bG\",'\"A\u0013\u0002\u0007=\u0014x-\u0003\u0002(;\t!A+[7f\u0011!I\u0003A!A!\u0002\u0013Y\u0012!\u0002;j[\u0016\u0004\u0003\u0002C\u0016\u0001\u0005\u000b\u0007I\u0011\u0001\u0017\u0002\u001dQD'o\u001c;uY\u0016$\u0016.\\3NgV\tQ\u0006\u0005\u0002/c5\tqFC\u00011\u0003\u0015\u00198-\u00197b\u0013\t\u0011tFA\u0002J]RD\u0001\u0002\u000e\u0001\u0003\u0002\u0003\u0006I!L\u0001\u0010i\"\u0014x\u000e\u001e;mKRKW.Z'tA!Aa\u0007\u0001B\u0001B\u0003%q'\u0001\u0005dC2d'-Y2l!\u0011q\u0003(\f\u001e\n\u0005ez#!\u0003$v]\u000e$\u0018n\u001c82!\tq3(\u0003\u0002=_\t!QK\\5u\u0011\u0015q\u0004\u0001\"\u0001@\u0003\u0019a\u0014N\\5u}Q!\u0001IQ\"E!\t\t\u0005!D\u0001\u0003\u0011\u0015AR\b1\u0001\u001c\u0011\u0015YS\b1\u0001.\u0011\u00151T\b1\u00018\u0011\u001d1\u0005A1A\u0005\u0002\u001d\u000bq!\u001a8e)&lW-F\u0001I!\tq\u0013*\u0003\u0002K_\t!Aj\u001c8h\u0011\u0019a\u0005\u0001)A\u0005\u0011\u0006AQM\u001c3US6,\u0007\u0005C\u0003O\u0001\u0011\u0005q*A\u0004fq\u0016\u001cW\u000f^3\u0015\u0003iBQ!\u0015\u0001\u0005BI\u000b\u0001bZ3u\t\u0016d\u0017-\u001f\u000b\u0003\u0011NCQ\u0001\u0016)A\u0002U\u000bA!\u001e8jiB\u0011\u0001CV\u0005\u0003/F\u0011\u0001\u0002V5nKVs\u0017\u000e\u001e\u0005\u00063\u0002!\tEW\u0001\nG>l\u0007/\u0019:f)>$\"!L.\t\u000bqC\u0006\u0019A\b\u0002\u0003\u0011\u0004")
public class ThrottledResponse
implements Delayed {
    private final Time time;
    private final int throttleTimeMs;
    private final Function1<Object, BoxedUnit> callback;
    private final long endTime;

    public Time time() {
        return this.time;
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public long endTime() {
        return this.endTime;
    }

    public void execute() {
        this.callback.apply$mcVI$sp(this.throttleTimeMs());
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return unit.convert(this.endTime() - this.time().milliseconds(), TimeUnit.MILLISECONDS);
    }

    @Override
    public int compareTo(Delayed d) {
        ThrottledResponse other = (ThrottledResponse)d;
        return this.endTime() < other.endTime() ? -1 : (this.endTime() > other.endTime() ? 1 : 0);
    }

    public ThrottledResponse(Time time, int throttleTimeMs, Function1<Object, BoxedUnit> callback) {
        this.time = time;
        this.throttleTimeMs = throttleTimeMs;
        this.callback = callback;
        this.endTime = time.milliseconds() + (long)throttleTimeMs;
    }
}

