/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.server;

import io.confluent.kafka.cluster.BrokerEndPoint;
import io.confluent.kafka.server.AbstractFetcherManager;
import io.confluent.kafka.server.AbstractFetcherThread;
import io.confluent.kafka.server.KafkaConfig;
import io.confluent.kafka.server.ReplicaFetcherManager$;
import io.confluent.kafka.server.ReplicaFetcherThread;
import io.confluent.kafka.server.ReplicaFetcherThread$;
import io.confluent.kafka.server.ReplicaManager;
import io.confluent.kafka.server.ReplicationQuotaManager;
import io.confluent.org.apache.kafka.common.metrics.Metrics;
import io.confluent.org.apache.kafka.common.utils.Time;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\ra\u0001B\u0001\u0003\u0001\u001d\u0011QCU3qY&\u001c\u0017MR3uG\",'/T1oC\u001e,'O\u0003\u0002\u0004\t\u000511/\u001a:wKJT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\u0002\u0005\u0002\n\u00155\t!!\u0003\u0002\f\u0005\t1\u0012IY:ue\u0006\u001cGOR3uG\",'/T1oC\u001e,'\u000f\u0003\u0005\u000e\u0001\t\u0005\t\u0015!\u0003\u000f\u00031\u0011'o\\6fe\u000e{gNZ5h!\tIq\"\u0003\u0002\u0011\u0005\tY1*\u00194lC\u000e{gNZ5h\u0011!\u0011\u0002A!b\u0001\n#\u0019\u0012A\u0004:fa2L7-Y'b]\u0006<WM]\u000b\u0002)A\u0011\u0011\"F\u0005\u0003-\t\u0011aBU3qY&\u001c\u0017-T1oC\u001e,'\u000f\u0003\u0005\u0019\u0001\t\u0005\t\u0015!\u0003\u0015\u0003=\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ\u0004\u0003\u0002\u0003\u000e\u0001\u0005\u0003\u0005\u000b\u0011B\u000e\u0002\u000f5,GO]5dgB\u0011A$J\u0007\u0002;)\u0011!D\b\u0006\u0003?\u0001\naaY8n[>t'BA\u0003\"\u0015\t\u00113%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002I\u0005\u0019qN]4\n\u0005\u0019j\"aB'fiJL7m\u001d\u0005\tQ\u0001\u0011\t\u0011)A\u0005S\u0005!A/[7f!\tQS&D\u0001,\u0015\tac$A\u0003vi&d7/\u0003\u0002/W\t!A+[7f\u0011!\u0001\u0004A!A!\u0002\u0013\t\u0014\u0001\u0005;ie\u0016\fGMT1nKB\u0013XMZ5y!\r\u0011TgN\u0007\u0002g)\tA'A\u0003tG\u0006d\u0017-\u0003\u00027g\t1q\n\u001d;j_:\u0004\"\u0001O \u000f\u0005ej\u0004C\u0001\u001e4\u001b\u0005Y$B\u0001\u001f\u0007\u0003\u0019a$o\\8u}%\u0011ahM\u0001\u0007!J,G-\u001a4\n\u0005\u0001\u000b%AB*ue&twM\u0003\u0002?g!A1\t\u0001B\u0001B\u0003%A)\u0001\u0007rk>$\u0018-T1oC\u001e,'\u000f\u0005\u0002\n\u000b&\u0011aI\u0001\u0002\u0018%\u0016\u0004H.[2bi&|g.U;pi\u0006l\u0015M\\1hKJDQ\u0001\u0013\u0001\u0005\u0002%\u000ba\u0001P5oSRtDc\u0002&L\u00196su\n\u0015\t\u0003\u0013\u0001AQ!D$A\u00029AQAE$A\u0002QAQAG$A\u0002mAQ\u0001K$A\u0002%Bq\u0001M$\u0011\u0002\u0003\u0007\u0011\u0007C\u0003D\u000f\u0002\u0007A\tC\u0003S\u0001\u0011\u00053+A\nde\u0016\fG/\u001a$fi\u000eDWM\u001d+ie\u0016\fG\rF\u0002U/r\u0003\"!C+\n\u0005Y\u0013!!F!cgR\u0014\u0018m\u0019;GKR\u001c\u0007.\u001a:UQJ,\u0017\r\u001a\u0005\u00061F\u0003\r!W\u0001\nM\u0016$8\r[3s\u0013\u0012\u0004\"A\r.\n\u0005m\u001b$aA%oi\")Q,\u0015a\u0001=\u0006a1o\\;sG\u0016\u0014%o\\6feB\u0011qLY\u0007\u0002A*\u0011\u0011\rB\u0001\bG2,8\u000f^3s\u0013\t\u0019\u0007M\u0001\bCe>\\WM]#oIB{\u0017N\u001c;\t\u000b\u0015\u0004A\u0011\u00014\u0002\u0011MDW\u000f\u001e3po:$\u0012a\u001a\t\u0003e!L!![\u001a\u0003\tUs\u0017\u000e^\u0004\bW\n\t\t\u0011#\u0001m\u0003U\u0011V\r\u001d7jG\u00064U\r^2iKJl\u0015M\\1hKJ\u0004\"!C7\u0007\u000f\u0005\u0011\u0011\u0011!E\u0001]N\u0011Qn\u001c\t\u0003eAL!!]\u001a\u0003\r\u0005s\u0017PU3g\u0011\u0015AU\u000e\"\u0001t)\u0005a\u0007bB;n#\u0003%\tA^\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001b\u0016\u0003]T#!\r=,\u0003e\u0004\"A_@\u000e\u0003mT!\u0001`?\u0002\u0013Ut7\r[3dW\u0016$'B\u0001@4\u0003)\tgN\\8uCRLwN\\\u0005\u0004\u0003\u0003Y(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public class ReplicaFetcherManager
extends AbstractFetcherManager {
    private final KafkaConfig brokerConfig;
    private final ReplicaManager replicaManager;
    private final Metrics metrics;
    private final Time time;
    private final Option<String> threadNamePrefix;
    private final ReplicationQuotaManager quotaManager;

    public static Option<String> $lessinit$greater$default$5() {
        return ReplicaFetcherManager$.MODULE$.$lessinit$greater$default$5();
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    @Override
    public AbstractFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker) {
        String prefix = (String)this.threadNamePrefix.map((Function1 & Serializable & scala.Serializable)tp -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tp}))).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        String threadName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "ReplicaFetcherThread-", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{prefix, BoxesRunTime.boxToInteger((int)fetcherId), BoxesRunTime.boxToInteger((int)sourceBroker.id())}));
        return new ReplicaFetcherThread(threadName, fetcherId, sourceBroker, this.brokerConfig, this.replicaManager(), this.metrics, this.time, this.quotaManager, ReplicaFetcherThread$.MODULE$.$lessinit$greater$default$9());
    }

    public void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "shutting down");
        this.closeAllFetchers();
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "shutdown completed");
    }

    public ReplicaFetcherManager(KafkaConfig brokerConfig, ReplicaManager replicaManager, Metrics metrics, Time time, Option<String> threadNamePrefix, ReplicationQuotaManager quotaManager) {
        this.brokerConfig = brokerConfig;
        this.replicaManager = replicaManager;
        this.metrics = metrics;
        this.time = time;
        this.threadNamePrefix = threadNamePrefix;
        this.quotaManager = quotaManager;
        super("ReplicaFetcherManager on broker " + brokerConfig.brokerId(), "Replica", Predef$.MODULE$.Integer2int(brokerConfig.numReplicaFetchers()));
    }
}

