/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.server;

import com.typesafe.scalalogging.Logger;
import io.confluent.kafka.metrics.KafkaMetricsReporter;
import io.confluent.kafka.server.KafkaConfig;
import io.confluent.kafka.server.KafkaServer;
import io.confluent.kafka.server.KafkaServer$;
import io.confluent.kafka.server.KafkaServerStartable$;
import io.confluent.kafka.utils.Exit$;
import io.confluent.kafka.utils.Logging;
import io.confluent.org.apache.kafka.common.utils.Time;
import java.util.Properties;
import scala.Function0;
import scala.Option;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001!<Q!\u0001\u0002\t\u0002\u001d\tAcS1gW\u0006\u001cVM\u001d<feN#\u0018M\u001d;bE2,'BA\u0002\u0005\u0003\u0019\u0019XM\u001d<fe*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0011\u0005!IQ\"\u0001\u0002\u0007\u000b)\u0011\u0001\u0012A\u0006\u0003)-\u000bgm[1TKJ4XM]*uCJ$\u0018M\u00197f'\tIA\u0002\u0005\u0002\u000e!5\taBC\u0001\u0010\u0003\u0015\u00198-\u00197b\u0013\t\tbB\u0001\u0004B]f\u0014VM\u001a\u0005\u0006'%!\t\u0001F\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u001dAQAF\u0005\u0005\u0002]\t\u0011B\u001a:p[B\u0013x\u000e]:\u0015\u0005aq\u0006C\u0001\u0005\u001a\r\u0011Q!\u0001\u0001\u000e\u0014\u0007ea1\u0004\u0005\u0002\u001d?5\tQD\u0003\u0002\u001f\t\u0005)Q\u000f^5mg&\u0011\u0001%\b\u0002\b\u0019><w-\u001b8h\u0011!\u0011\u0013D!b\u0001\n\u0003\u0019\u0013AE:uCRL7mU3sm\u0016\u00148i\u001c8gS\u001e,\u0012\u0001\n\t\u0003\u0011\u0015J!A\n\u0002\u0003\u0017-\u000bgm[1D_:4\u0017n\u001a\u0005\tQe\u0011\t\u0011)A\u0005I\u0005\u00192\u000f^1uS\u000e\u001cVM\u001d<fe\u000e{gNZ5hA!A!&\u0007B\u0001B\u0003%1&A\u0005sKB|'\u000f^3sgB\u0019A\u0006N\u001c\u000f\u00055\u0012dB\u0001\u00182\u001b\u0005y#B\u0001\u0019\u0007\u0003\u0019a$o\\8u}%\tq\"\u0003\u00024\u001d\u00059\u0001/Y2lC\u001e,\u0017BA\u001b7\u0005\r\u0019V-\u001d\u0006\u0003g9\u0001\"\u0001O\u001e\u000e\u0003eR!A\u000f\u0003\u0002\u000f5,GO]5dg&\u0011A(\u000f\u0002\u0015\u0017\u000647.Y'fiJL7m\u001d*fa>\u0014H/\u001a:\t\u000bMIB\u0011\u0001 \u0015\u0007ay\u0004\tC\u0003#{\u0001\u0007A\u0005C\u0003+{\u0001\u00071\u0006C\u0004\u00043\t\u0007I\u0011\u0002\"\u0016\u0003\r\u0003\"\u0001\u0003#\n\u0005\u0015\u0013!aC&bM.\f7+\u001a:wKJDaaR\r!\u0002\u0013\u0019\u0015aB:feZ,'\u000f\t\u0005\u0006'e!\t!\u0013\u000b\u00031)CQa\u0013%A\u0002\u0011\nAb]3sm\u0016\u00148i\u001c8gS\u001eDQ!T\r\u0005\u00029\u000bqa\u001d;beR,\b\u000fF\u0001P!\ti\u0001+\u0003\u0002R\u001d\t!QK\\5u\u0011\u0015\u0019\u0016\u0004\"\u0001O\u0003!\u0019\b.\u001e;e_^t\u0007\"B+\u001a\t\u00031\u0016AD:fiN+'O^3s'R\fG/\u001a\u000b\u0003\u001f^CQ\u0001\u0017+A\u0002e\u000b\u0001B\\3x'R\fG/\u001a\t\u0003\u001biK!a\u0017\b\u0003\t\tKH/\u001a\u0005\u0006;f!\tAT\u0001\u000eC^\f\u0017\u000e^*ikR$wn\u001e8\t\u000b}+\u0002\u0019\u00011\u0002\u0017M,'O^3s!J|\u0007o\u001d\t\u0003C\u001al\u0011A\u0019\u0006\u0003G\u0012\fA!\u001e;jY*\tQ-\u0001\u0003kCZ\f\u0017BA4c\u0005)\u0001&o\u001c9feRLWm\u001d")
public class KafkaServerStartable
implements Logging {
    private final KafkaConfig staticServerConfig;
    private final KafkaServer server;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static KafkaServerStartable fromProps(Properties properties) {
        return KafkaServerStartable$.MODULE$.fromProps(properties);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        KafkaServerStartable kafkaServerStartable = this;
        synchronized (kafkaServerStartable) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public KafkaConfig staticServerConfig() {
        return this.staticServerConfig;
    }

    private KafkaServer server() {
        return this.server;
    }

    public void startup() {
        try {
            this.server().startup();
        }
        catch (Throwable throwable) {
            this.fatal((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> "Exiting Kafka.");
            throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
        }
    }

    public void shutdown() {
        try {
            this.server().shutdown();
        }
        catch (Throwable throwable) {
            this.fatal((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> "Halting Kafka.");
            throw Exit$.MODULE$.halt(1, Exit$.MODULE$.halt$default$2());
        }
    }

    public void setServerState(byte newState) {
        this.server().brokerState().newState(newState);
    }

    public void awaitShutdown() {
        this.server().awaitShutdown();
    }

    public KafkaServerStartable(KafkaConfig staticServerConfig, Seq<KafkaMetricsReporter> reporters) {
        this.staticServerConfig = staticServerConfig;
        Logging.$init$(this);
        KafkaConfig x$1 = staticServerConfig;
        Seq<KafkaMetricsReporter> x$2 = reporters;
        Time x$3 = KafkaServer$.MODULE$.$lessinit$greater$default$2();
        Option<String> x$4 = KafkaServer$.MODULE$.$lessinit$greater$default$3();
        this.server = new KafkaServer(x$1, x$3, x$4, x$2);
    }

    public KafkaServerStartable(KafkaConfig serverConfig) {
        this(serverConfig, (Seq<KafkaMetricsReporter>)((Seq)Seq$.MODULE$.empty()));
    }
}

