/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.server;

import com.typesafe.scalalogging.Logger;
import io.confluent.kafka.server.CachedPartition;
import io.confluent.kafka.server.FetchContext;
import io.confluent.kafka.server.FetchSession;
import io.confluent.kafka.utils.Logging;
import io.confluent.org.apache.kafka.common.TopicPartition;
import io.confluent.org.apache.kafka.common.protocol.Errors;
import io.confluent.org.apache.kafka.common.requests.FetchMetadata;
import io.confluent.org.apache.kafka.common.requests.FetchRequest;
import io.confluent.org.apache.kafka.common.requests.FetchResponse;
import io.confluent.org.apache.kafka.common.utils.Time;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u000194A!\u0001\u0002\u0001\u000f\t9\u0012J\\2sK6,g\u000e^1m\r\u0016$8\r[\"p]R,\u0007\u0010\u001e\u0006\u0003\u0007\u0011\taa]3sm\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001\u0001\u0003\b\u0011\u0005%aQ\"\u0001\u0006\u000b\u0003-\tQa]2bY\u0006L!!\u0004\u0006\u0003\r\u0005s\u0017PU3g!\ty\u0001#D\u0001\u0003\u0013\t\t\"A\u0001\u0007GKR\u001c\u0007nQ8oi\u0016DH\u000f\u0003\u0005\u0014\u0001\t\u0015\r\u0011\"\u0003\u0015\u0003\u0011!\u0018.\\3\u0016\u0003U\u0001\"A\u0006\u0011\u000e\u0003]Q!\u0001G\r\u0002\u000bU$\u0018\u000e\\:\u000b\u0005iY\u0012AB2p[6|gN\u0003\u0002\u00069)\u0011QDH\u0001\u0007CB\f7\r[3\u000b\u0003}\t1a\u001c:h\u0013\t\tsC\u0001\u0003US6,\u0007\u0002C\u0012\u0001\u0005\u0003\u0005\u000b\u0011B\u000b\u0002\u000bQLW.\u001a\u0011\t\u0011\u0015\u0002!Q1A\u0005\n\u0019\n1B]3r\u001b\u0016$\u0018\rZ1uCV\tq\u0005\u0005\u0002)W5\t\u0011F\u0003\u0002+3\u0005A!/Z9vKN$8/\u0003\u0002-S\tia)\u001a;dQ6+G/\u00193bi\u0006D\u0001B\f\u0001\u0003\u0002\u0003\u0006IaJ\u0001\re\u0016\fX*\u001a;bI\u0006$\u0018\r\t\u0005\ta\u0001\u0011)\u0019!C\u0005c\u000591/Z:tS>tW#\u0001\u001a\u0011\u0005=\u0019\u0014B\u0001\u001b\u0003\u000511U\r^2i'\u0016\u001c8/[8o\u0011!1\u0004A!A!\u0002\u0013\u0011\u0014\u0001C:fgNLwN\u001c\u0011\t\u000ba\u0002A\u0011A\u001d\u0002\rqJg.\u001b;?)\u0011Q4\bP\u001f\u0011\u0005=\u0001\u0001\"B\n8\u0001\u0004)\u0002\"B\u00138\u0001\u00049\u0003\"\u0002\u00198\u0001\u0004\u0011\u0004\"B \u0001\t\u0003\u0002\u0015AD4fi\u001a+Go\u00195PM\u001a\u001cX\r\u001e\u000b\u0003\u0003\u001e\u00032!\u0003\"E\u0013\t\u0019%B\u0001\u0004PaRLwN\u001c\t\u0003\u0013\u0015K!A\u0012\u0006\u0003\t1{gn\u001a\u0005\u0006\u0011z\u0002\r!S\u0001\u0003iB\u0004\"AS&\u000e\u0003eI!\u0001T\r\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\")a\n\u0001C!\u001f\u0006\u0001bm\u001c:fC\u000eD\u0007+\u0019:uSRLwN\u001c\u000b\u0003!N\u0003\"!C)\n\u0005IS!\u0001B+oSRDQ\u0001V'A\u0002U\u000b1AZ;o!\u0015Ia+\u0013-Q\u0013\t9&BA\u0005Gk:\u001cG/[8oeA\u0011\u0011\f\u0018\b\u0003QiK!aW\u0015\u0002\u0019\u0019+Go\u00195SKF,Xm\u001d;\n\u0005us&!\u0004)beRLG/[8o\t\u0006$\u0018M\u0003\u0002\\S!)\u0001\r\u0001C!C\u0006iR\u000f\u001d3bi\u0016\fe\u000eZ$f]\u0016\u0014\u0018\r^3SKN\u0004xN\\:f\t\u0006$\u0018\r\u0006\u0002cKB\u0011\u0001fY\u0005\u0003I&\u0012QBR3uG\"\u0014Vm\u001d9p]N,\u0007\"\u00024`\u0001\u00049\u0017aB;qI\u0006$Xm\u001d\t\u0003Q.t!aD5\n\u0005)\u0014\u0011\u0001\u0004$fi\u000eD7+Z:tS>t\u0017B\u00017n\u0005!\u0011Vi\u0015)`\u001b\u0006\u0003&B\u00016\u0003\u0001")
public class IncrementalFetchContext
implements FetchContext {
    private final Time time;
    private final FetchMetadata reqMetadata;
    private final FetchSession session;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String partitionsToLogString(Collection<TopicPartition> partitions) {
        return FetchContext.partitionsToLogString$(this, partitions);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        IncrementalFetchContext incrementalFetchContext = this;
        synchronized (incrementalFetchContext) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private Time time() {
        return this.time;
    }

    private FetchMetadata reqMetadata() {
        return this.reqMetadata;
    }

    private FetchSession session() {
        return this.session;
    }

    @Override
    public Option<Object> getFetchOffset(TopicPartition tp) {
        return this.session().getFetchOffset(tp);
    }

    @Override
    public void foreachPartition(Function2<TopicPartition, FetchRequest.PartitionData, BoxedUnit> fun) {
        FetchSession fetchSession = this.session();
        synchronized (fetchSession) {
            ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(this.session().partitionMap().iterator()).asScala()).foreach((Function1 & Serializable & scala.Serializable)part -> {
                fun.apply((Object)new TopicPartition(part.topic(), part.partition()), (Object)part.reqData());
                return BoxedUnit.UNIT;
            });
        }
    }

    @Override
    public FetchResponse updateAndGenerateResponseData(LinkedHashMap<TopicPartition, FetchResponse.PartitionData> updates) {
        FetchResponse fetchResponse;
        FetchSession fetchSession = this.session();
        synchronized (fetchSession) {
            FetchResponse fetchResponse2;
            int expectedEpoch = FetchMetadata.nextEpoch(this.reqMetadata().epoch());
            if (this.session().epoch() != expectedEpoch) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Incremental fetch session ", " expected epoch ", ", but "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.session().id()), BoxesRunTime.boxToInteger((int)expectedEpoch)})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"got ", ".  Possible duplicate request."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.session().epoch())})));
                fetchResponse2 = new FetchResponse(Errors.INVALID_FETCH_SESSION_EPOCH, new LinkedHashMap<TopicPartition, FetchResponse.PartitionData>(), 0, this.session().id());
            } else {
                java.util.Iterator<Map.Entry<TopicPartition, FetchResponse.PartitionData>> iter = updates.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry<TopicPartition, FetchResponse.PartitionData> entry = iter.next();
                    TopicPartition topicPart = entry.getKey();
                    FetchResponse.PartitionData respData = entry.getValue();
                    CachedPartition cachedPart = this.session().partitionMap().find(new CachedPartition(topicPart));
                    boolean mustRespond = cachedPart.updateResponseData(respData);
                    if (mustRespond) {
                        this.session().partitionMap().remove(cachedPart);
                        this.session().partitionMap().mustAdd(cachedPart);
                        continue;
                    }
                    iter.remove();
                }
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Incremental fetch context with session id ", " returning "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.session().id())})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partitionsToLogString(updates.keySet())})));
                fetchResponse2 = new FetchResponse(Errors.NONE, updates, 0, this.session().id());
            }
            fetchResponse = fetchResponse2;
        }
        return fetchResponse;
    }

    public IncrementalFetchContext(Time time, FetchMetadata reqMetadata, FetchSession session) {
        this.time = time;
        this.reqMetadata = reqMetadata;
        this.session = session;
        Logging.$init$(this);
        FetchContext.$init$(this);
    }
}

