/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.server;

import com.typesafe.scalalogging.Logger;
import io.confluent.kafka.server.CachedPartition;
import io.confluent.kafka.server.FetchContext;
import io.confluent.kafka.server.FetchSessionCache;
import io.confluent.kafka.utils.Logging;
import io.confluent.org.apache.kafka.common.TopicPartition;
import io.confluent.org.apache.kafka.common.protocol.Errors;
import io.confluent.org.apache.kafka.common.requests.FetchMetadata;
import io.confluent.org.apache.kafka.common.requests.FetchRequest;
import io.confluent.org.apache.kafka.common.requests.FetchResponse;
import io.confluent.org.apache.kafka.common.utils.ImplicitLinkedHashSet;
import io.confluent.org.apache.kafka.common.utils.Time;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005-a\u0001B\u0001\u0003\u0001\u001d\u0011\u0001CR;mY\u001a+Go\u00195D_:$X\r\u001f;\u000b\u0005\r!\u0011AB:feZ,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001\u0001\u0005\u000f!\tIA\"D\u0001\u000b\u0015\u0005Y\u0011!B:dC2\f\u0017BA\u0007\u000b\u0005\u0019\te.\u001f*fMB\u0011q\u0002E\u0007\u0002\u0005%\u0011\u0011C\u0001\u0002\r\r\u0016$8\r[\"p]R,\u0007\u0010\u001e\u0005\t'\u0001\u0011)\u0019!C\u0005)\u0005!A/[7f+\u0005)\u0002C\u0001\f!\u001b\u00059\"B\u0001\r\u001a\u0003\u0015)H/\u001b7t\u0015\tQ2$\u0001\u0004d_6lwN\u001c\u0006\u0003\u000bqQ!!\b\u0010\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0012aA8sO&\u0011\u0011e\u0006\u0002\u0005)&lW\r\u0003\u0005$\u0001\t\u0005\t\u0015!\u0003\u0016\u0003\u0015!\u0018.\\3!\u0011!)\u0003A!b\u0001\n\u00131\u0013!B2bG\",W#A\u0014\u0011\u0005=A\u0013BA\u0015\u0003\u0005E1U\r^2i'\u0016\u001c8/[8o\u0007\u0006\u001c\u0007.\u001a\u0005\tW\u0001\u0011\t\u0011)A\u0005O\u000511-Y2iK\u0002B\u0001\"\f\u0001\u0003\u0006\u0004%IAL\u0001\fe\u0016\fX*\u001a;bI\u0006$\u0018-F\u00010!\t\u00014'D\u00012\u0015\t\u0011\u0014$\u0001\u0005sKF,Xm\u001d;t\u0013\t!\u0014GA\u0007GKR\u001c\u0007.T3uC\u0012\fG/\u0019\u0005\tm\u0001\u0011\t\u0011)A\u0005_\u0005a!/Z9NKR\fG-\u0019;bA!A\u0001\b\u0001BC\u0002\u0013%\u0011(A\u0005gKR\u001c\u0007\u000eR1uCV\t!\b\u0005\u0003<\u0001\n3U\"\u0001\u001f\u000b\u0005ur\u0014\u0001B;uS2T\u0011aP\u0001\u0005U\u00064\u0018-\u0003\u0002By\t\u0019Q*\u00199\u0011\u0005\r#U\"A\r\n\u0005\u0015K\"A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\t\u0003\u000f*s!\u0001\r%\n\u0005%\u000b\u0014\u0001\u0004$fi\u000eD'+Z9vKN$\u0018BA&M\u00055\u0001\u0016M\u001d;ji&|g\u000eR1uC*\u0011\u0011*\r\u0005\t\u001d\u0002\u0011\t\u0011)A\u0005u\u0005Qa-\u001a;dQ\u0012\u000bG/\u0019\u0011\t\u0011A\u0003!Q1A\u0005\nE\u000ba\"[:Ge>lgi\u001c7m_^,'/F\u0001S!\tI1+\u0003\u0002U\u0015\t9!i\\8mK\u0006t\u0007\u0002\u0003,\u0001\u0005\u0003\u0005\u000b\u0011\u0002*\u0002\u001f%\u001chI]8n\r>dGn\\<fe\u0002BQ\u0001\u0017\u0001\u0005\u0002e\u000ba\u0001P5oSRtDC\u0002.\\9vsv\f\u0005\u0002\u0010\u0001!)1c\u0016a\u0001+!)Qe\u0016a\u0001O!)Qf\u0016a\u0001_!)\u0001h\u0016a\u0001u!)\u0001k\u0016a\u0001%\")\u0011\r\u0001C!E\u0006qq-\u001a;GKR\u001c\u0007n\u00144gg\u0016$HCA2j!\rIAMZ\u0005\u0003K*\u0011aa\u00149uS>t\u0007CA\u0005h\u0013\tA'B\u0001\u0003M_:<\u0007\"\u00026a\u0001\u0004\u0011\u0015\u0001\u00029beRDQ\u0001\u001c\u0001\u0005B5\f\u0001CZ8sK\u0006\u001c\u0007\u000eU1si&$\u0018n\u001c8\u0015\u00059\f\bCA\u0005p\u0013\t\u0001(B\u0001\u0003V]&$\b\"\u0002:l\u0001\u0004\u0019\u0018a\u00014v]B)\u0011\u0002\u001e\"G]&\u0011QO\u0003\u0002\n\rVt7\r^5p]JBQa\u001e\u0001\u0005Ba\fQ$\u001e9eCR,\u0017I\u001c3HK:,'/\u0019;f%\u0016\u001c\bo\u001c8tK\u0012\u000bG/\u0019\u000b\u0003sr\u0004\"\u0001\r>\n\u0005m\f$!\u0004$fi\u000eD'+Z:q_:\u001cX\rC\u0003~m\u0002\u0007a0A\u0004va\u0012\fG/Z:\u0011\u0007}\f)AD\u0002\u0010\u0003\u0003I1!a\u0001\u0003\u000311U\r^2i'\u0016\u001c8/[8o\u0013\u0011\t9!!\u0003\u0003\u0011I+5\u000bU0N\u0003BS1!a\u0001\u0003\u0001")
public class FullFetchContext
implements FetchContext {
    private final Time time;
    private final FetchSessionCache cache;
    private final FetchMetadata reqMetadata;
    private final Map<TopicPartition, FetchRequest.PartitionData> fetchData;
    private final boolean isFromFollower;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String partitionsToLogString(Collection<TopicPartition> partitions) {
        return FetchContext.partitionsToLogString$(this, partitions);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        FullFetchContext fullFetchContext = this;
        synchronized (fullFetchContext) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private Time time() {
        return this.time;
    }

    private FetchSessionCache cache() {
        return this.cache;
    }

    private FetchMetadata reqMetadata() {
        return this.reqMetadata;
    }

    private Map<TopicPartition, FetchRequest.PartitionData> fetchData() {
        return this.fetchData;
    }

    private boolean isFromFollower() {
        return this.isFromFollower;
    }

    @Override
    public Option<Object> getFetchOffset(TopicPartition part) {
        return Option$.MODULE$.apply((Object)this.fetchData().get(part)).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.fetchOffset));
    }

    @Override
    public void foreachPartition(Function2<TopicPartition, FetchRequest.PartitionData, BoxedUnit> fun) {
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(this.fetchData().entrySet()).asScala()).foreach((Function1 & Serializable & scala.Serializable)entry -> {
            fun.apply(entry.getKey(), entry.getValue());
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public FetchResponse updateAndGenerateResponseData(LinkedHashMap<TopicPartition, FetchResponse.PartitionData> updates) {
        int responseSessionId = this.cache().maybeCreateSession(this.time().milliseconds(), this.isFromFollower(), updates.size(), (Function0<ImplicitLinkedHashSet<CachedPartition>>)(Function0 & Serializable & scala.Serializable)() -> this.createNewSession$1(updates));
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Full fetch context with session id ", " returning "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)responseSessionId)})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partitionsToLogString(updates.keySet())})));
        return new FetchResponse(Errors.NONE, updates, 0, responseSessionId);
    }

    public static final /* synthetic */ void $anonfun$updateAndGenerateResponseData$3(FullFetchContext $this, ImplicitLinkedHashSet cachedPartitions$1, Map.Entry entry) {
        TopicPartition part = (TopicPartition)entry.getKey();
        FetchResponse.PartitionData respData = (FetchResponse.PartitionData)entry.getValue();
        FetchRequest.PartitionData reqData = $this.fetchData().get(part);
        cachedPartitions$1.mustAdd(new CachedPartition(part, reqData, respData));
    }

    /*
     * WARNING - void declaration
     */
    private final ImplicitLinkedHashSet createNewSession$1(LinkedHashMap updates$2) {
        void var2_2;
        ImplicitLinkedHashSet cachedPartitions = new ImplicitLinkedHashSet(updates$2.size());
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(updates$2.entrySet()).asScala()).foreach((Function1 & Serializable & scala.Serializable)entry -> {
            FullFetchContext.$anonfun$updateAndGenerateResponseData$3(this, cachedPartitions, entry);
            return BoxedUnit.UNIT;
        });
        return var2_2;
    }

    public FullFetchContext(Time time, FetchSessionCache cache, FetchMetadata reqMetadata, Map<TopicPartition, FetchRequest.PartitionData> fetchData, boolean isFromFollower) {
        this.time = time;
        this.cache = cache;
        this.reqMetadata = reqMetadata;
        this.fetchData = fetchData;
        this.isFromFollower = isFromFollower;
        Logging.$init$(this);
        FetchContext.$init$(this);
    }
}

