/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.server;

import io.confluent.kafka.server.BrokerReconfigurable;
import io.confluent.kafka.server.DynamicThreadPool$;
import io.confluent.kafka.server.KafkaConfig;
import io.confluent.kafka.server.KafkaConfig$;
import io.confluent.kafka.server.KafkaServer;
import io.confluent.org.apache.kafka.common.config.ConfigException;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001q;Q!\u0001\u0002\t\u0002\u001d\t\u0011\u0003R=oC6L7\r\u00165sK\u0006$\u0007k\\8m\u0015\t\u0019A!\u0001\u0004tKJ4XM\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u0001\u0001C\u0001\u0005\n\u001b\u0005\u0011a!\u0002\u0006\u0003\u0011\u0003Y!!\u0005#z]\u0006l\u0017n\u0019+ie\u0016\fG\rU8pYN\u0011\u0011\u0002\u0004\t\u0003\u001bAi\u0011A\u0004\u0006\u0002\u001f\u0005)1oY1mC&\u0011\u0011C\u0004\u0002\u0007\u0003:L(+\u001a4\t\u000bMIA\u0011\u0001\u000b\u0002\rqJg.\u001b;?)\u00059\u0001b\u0002\f\n\u0005\u0004%\taF\u0001\u0016%\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f\u0007>tg-[4t+\u0005A\u0002cA\r\u001d=5\t!D\u0003\u0002\u001c\u001d\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005uQ\"aA*fiB\u0011q\u0004J\u0007\u0002A)\u0011\u0011EI\u0001\u0005Y\u0006twMC\u0001$\u0003\u0011Q\u0017M^1\n\u0005\u0015\u0002#AB*ue&tw\r\u0003\u0004(\u0013\u0001\u0006I\u0001G\u0001\u0017%\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f\u0007>tg-[4tA\u0019!!B\u0001\u0001*'\rACB\u000b\t\u0003\u0011-J!\u0001\f\u0002\u0003)\t\u0013xn[3s%\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f\u0011!\u0019\u0001F!A!\u0002\u0013q\u0003C\u0001\u00050\u0013\t\u0001$AA\u0006LC\u001a\\\u0017mU3sm\u0016\u0014\b\"B\n)\t\u0003\u0011DCA\u001a5!\tA\u0001\u0006C\u0003\u0004c\u0001\u0007a\u0006C\u00037Q\u0011\u0005s'A\u000bsK\u000e|gNZ5hkJ\f'\r\\3D_:4\u0017nZ:\u0016\u0003a\u00022!\u0007\u000f:!\tQ\u0014I\u0004\u0002<\u007fA\u0011AHD\u0007\u0002{)\u0011aHB\u0001\u0007yI|w\u000e\u001e \n\u0005\u0001s\u0011A\u0002)sK\u0012,g-\u0003\u0002&\u0005*\u0011\u0001I\u0004\u0005\u0006\t\"\"\t%R\u0001\u0018m\u0006d\u0017\u000eZ1uKJ+7m\u001c8gS\u001e,(/\u0019;j_:$\"AR%\u0011\u000559\u0015B\u0001%\u000f\u0005\u0011)f.\u001b;\t\u000b)\u001b\u0005\u0019A&\u0002\u00139,woQ8oM&<\u0007C\u0001\u0005M\u0013\ti%AA\u0006LC\u001a\\\u0017mQ8oM&<\u0007\"B()\t\u0003\u0002\u0016a\u0003:fG>tg-[4ve\u0016$2AR)T\u0011\u0015\u0011f\n1\u0001L\u0003%yG\u000eZ\"p]\u001aLw\rC\u0003K\u001d\u0002\u00071\nC\u0003VQ\u0011%a+\u0001\u0007dkJ\u0014XM\u001c;WC2,X\r\u0006\u0002X5B\u0011Q\u0002W\u0005\u00033:\u00111!\u00138u\u0011\u0015YF\u000b1\u0001:\u0003\u0011q\u0017-\\3")
public class DynamicThreadPool
implements BrokerReconfigurable {
    private final KafkaServer server;

    public static Set<String> ReconfigurableConfigs() {
        return DynamicThreadPool$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        return DynamicThreadPool$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public void validateReconfiguration(KafkaConfig newConfig) {
        ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(newConfig.values()).asScala()).filterKeys((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)DynamicThreadPool.$anonfun$validateReconfiguration$1(elem))).foreach((Function1 & Serializable & scala.Serializable)x0$12 -> {
            DynamicThreadPool.$anonfun$validateReconfiguration$2(this, x0$12);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
        block4: {
            Integer n = newConfig.numIoThreads();
            Integer n2 = oldConfig.numIoThreads();
            if (n == null ? n2 != null : !((Object)n).equals(n2)) {
                this.server.requestHandlerPool().resizeThreadPool(Predef$.MODULE$.Integer2int(newConfig.numIoThreads()));
            }
            Integer n3 = newConfig.numNetworkThreads();
            Integer n4 = oldConfig.numNetworkThreads();
            if (n3 == null ? n4 != null : !((Object)n3).equals(n4)) {
                this.server.socketServer().resizeThreadPool(Predef$.MODULE$.Integer2int(oldConfig.numNetworkThreads()), Predef$.MODULE$.Integer2int(newConfig.numNetworkThreads()));
            }
            Integer n5 = newConfig.numReplicaFetchers();
            Integer n6 = oldConfig.numReplicaFetchers();
            if (n5 == null ? n6 != null : !((Object)n5).equals(n6)) {
                this.server.replicaManager().replicaFetcherManager().resizeThreadPool(Predef$.MODULE$.Integer2int(newConfig.numReplicaFetchers()));
            }
            Integer n7 = newConfig.numRecoveryThreadsPerDataDir();
            Integer n8 = oldConfig.numRecoveryThreadsPerDataDir();
            if (n7 == null ? n8 != null : !((Object)n7).equals(n8)) {
                this.server.getLogManager().resizeRecoveryThreadPool(Predef$.MODULE$.Integer2int(newConfig.numRecoveryThreadsPerDataDir()));
            }
            Integer n9 = newConfig.backgroundThreads();
            Integer n10 = oldConfig.backgroundThreads();
            if (!(n9 == null ? n10 != null : !((Object)n9).equals(n10))) break block4;
            this.server.kafkaScheduler().resizeThreadPool(Predef$.MODULE$.Integer2int(newConfig.backgroundThreads()));
        }
    }

    private int currentValue(String name) {
        int n;
        String string = name;
        String string2 = KafkaConfig$.MODULE$.NumIoThreadsProp();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            n = Predef$.MODULE$.Integer2int(this.server.config().numIoThreads());
        } else {
            String string4 = KafkaConfig$.MODULE$.NumNetworkThreadsProp();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                n = Predef$.MODULE$.Integer2int(this.server.config().numNetworkThreads());
            } else {
                String string6 = KafkaConfig$.MODULE$.NumReplicaFetchersProp();
                String string7 = string;
                if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                    n = Predef$.MODULE$.Integer2int(this.server.config().numReplicaFetchers());
                } else {
                    String string8 = KafkaConfig$.MODULE$.NumRecoveryThreadsPerDataDirProp();
                    String string9 = string;
                    if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                        n = Predef$.MODULE$.Integer2int(this.server.config().numRecoveryThreadsPerDataDir());
                    } else {
                        String string10 = KafkaConfig$.MODULE$.BackgroundThreadsProp();
                        String string11 = string;
                        if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
                            n = Predef$.MODULE$.Integer2int(this.server.config().backgroundThreads());
                        } else {
                            throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected config ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string})));
                        }
                    }
                }
            }
        }
        return n;
    }

    public static final /* synthetic */ boolean $anonfun$validateReconfiguration$1(String elem) {
        return DynamicThreadPool$.MODULE$.ReconfigurableConfigs().contains((Object)elem);
    }

    public static final /* synthetic */ void $anonfun$validateReconfiguration$2(DynamicThreadPool $this, Tuple2 x0$12) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$12;
        if (tuple2 != null) {
            int oldValue;
            String k = (String)tuple2._1();
            Object v = tuple2._2();
            int newValue = BoxesRunTime.unboxToInt((Object)v);
            if (newValue != (oldValue = $this.currentValue(k))) {
                String errorMsg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Dynamic thread count update validation failed for ", "=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{k, v}));
                if (newValue <= 0) {
                    throw new ConfigException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ", value should be at least 1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{errorMsg})));
                }
                if (newValue < oldValue / 2) {
                    throw new ConfigException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ", value should be at least half the current value ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{errorMsg, BoxesRunTime.boxToInteger((int)oldValue)})));
                }
                if (newValue > oldValue * 2) {
                    throw new ConfigException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ", value should not be greater than double the current value ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{errorMsg, BoxesRunTime.boxToInteger((int)oldValue)})));
                }
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public DynamicThreadPool(KafkaServer server) {
        this.server = server;
    }
}

