/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.server;

import com.typesafe.scalalogging.Logger;
import io.confluent.kafka.server.BrokerReconfigurable;
import io.confluent.kafka.server.ConfigEntityName$;
import io.confluent.kafka.server.ConfigType$;
import io.confluent.kafka.server.DynamicBrokerConfig$;
import io.confluent.kafka.server.DynamicConfig$Broker$;
import io.confluent.kafka.server.DynamicListenerConfig;
import io.confluent.kafka.server.DynamicLogConfig;
import io.confluent.kafka.server.DynamicMetricsReporters;
import io.confluent.kafka.server.DynamicThreadPool;
import io.confluent.kafka.server.KafkaConfig;
import io.confluent.kafka.server.KafkaConfig$;
import io.confluent.kafka.server.KafkaServer;
import io.confluent.kafka.utils.CoreUtils$;
import io.confluent.kafka.utils.Logging;
import io.confluent.kafka.utils.PasswordEncoder;
import io.confluent.kafka.zk.AdminZkClient;
import io.confluent.kafka.zk.KafkaZkClient;
import io.confluent.org.apache.kafka.common.Reconfigurable;
import io.confluent.org.apache.kafka.common.config.ConfigDef;
import io.confluent.org.apache.kafka.common.config.ConfigException;
import io.confluent.org.apache.kafka.common.config.types.Password;
import io.confluent.org.apache.kafka.common.network.ListenerName;
import io.confluent.org.apache.kafka.common.network.ListenerReconfigurable;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenSetLike;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\r\u0015u!B\u0001\u0003\u0011\u00039\u0011a\u0005#z]\u0006l\u0017n\u0019\"s_.,'oQ8oM&<'BA\u0002\u0005\u0003\u0019\u0019XM\u001d<fe*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0011\u0005!IQ\"\u0001\u0002\u0007\u000b)\u0011\u0001\u0012A\u0006\u0003'\u0011Kh.Y7jG\n\u0013xn[3s\u0007>tg-[4\u0014\u0005%a\u0001CA\u0007\u0011\u001b\u0005q!\"A\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Eq!AB!osJ+g\rC\u0003\u0014\u0013\u0011\u0005A#\u0001\u0004=S:LGO\u0010\u000b\u0002\u000f!Aa#\u0003b\u0001\n\u0003\u0011q#\u0001\fEs:\fW.[2TK\u000e,(/\u001b;z\u0007>tg-[4t+\u0005A\u0002cA\r\u001fA5\t!D\u0003\u0002\u001c9\u00059Q.\u001e;bE2,'BA\u000f\u000f\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003?i\u00111aU3u!\t\tc%D\u0001#\u0015\t\u0019C%\u0001\u0003mC:<'\"A\u0013\u0002\t)\fg/Y\u0005\u0003O\t\u0012aa\u0015;sS:<\u0007BB\u0015\nA\u0003%\u0001$A\fEs:\fW.[2TK\u000e,(/\u001b;z\u0007>tg-[4tA!91&\u0003b\u0001\n\u0003a\u0013!E!mY\u0012Kh.Y7jG\u000e{gNZ5hgV\tQ\u0006E\u0002\u001a=9\u0002\"a\f\u001c\u000f\u0005A\"\u0004CA\u0019\u000f\u001b\u0005\u0011$BA\u001a\u0007\u0003\u0019a$o\\8u}%\u0011QGD\u0001\u0007!J,G-\u001a4\n\u0005\u001d:$BA\u001b\u000f\u0011\u0019I\u0014\u0002)A\u0005[\u0005\u0011\u0012\t\u001c7Es:\fW.[2D_:4\u0017nZ:!\u0011\u001dY\u0014B1A\u0005\n]\t\u0001\u0003U3s\u0005J|7.\u001a:D_:4\u0017nZ:\t\ruJ\u0001\u0015!\u0003\u0019\u0003E\u0001VM\u001d\"s_.,'oQ8oM&<7\u000f\t\u0005\b\u007f%\u0011\r\u0011\"\u0003A\u0003aa\u0015n\u001d;f]\u0016\u0014X*Z2iC:L7/\\\"p]\u001aLwm]\u000b\u0002\u0003B\u0019!i\u0011\u0011\u000e\u0003qI!a\b\u000f\t\r\u0015K\u0001\u0015!\u0003B\u0003ea\u0015n\u001d;f]\u0016\u0014X*Z2iC:L7/\\\"p]\u001aLwm\u001d\u0011\t\u000f\u001dK!\u0019!C\u0001\u0011\u0006\u0019B*[:uK:,'oQ8oM&<'+Z4fqV\t\u0011\n\u0005\u0002K\u001f6\t1J\u0003\u0002M\u001b\u0006AQ.\u0019;dQ&twM\u0003\u0002O\u001d\u0005!Q\u000f^5m\u0013\t\u00016JA\u0003SK\u001e,\u0007\u0010\u0003\u0004S\u0013\u0001\u0006I!S\u0001\u0015\u0019&\u001cH/\u001a8fe\u000e{gNZ5h%\u0016<W\r\u001f\u0011\t\u000fQK!\u0019!C\u0005Y\u00051B)\u001f8b[&\u001c\u0007+Y:to>\u0014HmQ8oM&<7\u000f\u0003\u0004W\u0013\u0001\u0006I!L\u0001\u0018\tft\u0017-\\5d!\u0006\u001c8o^8sI\u000e{gNZ5hg\u0002BQ\u0001W\u0005\u0005\u0002e\u000b\u0001#[:QCN\u001cxo\u001c:e\u0007>tg-[4\u0015\u0005ik\u0006CA\u0007\\\u0013\tafBA\u0004C_>dW-\u00198\t\u000by;\u0006\u0019\u0001\u0018\u0002\t9\fW.\u001a\u0005\u0006A&!\t!Y\u0001\u0015EJ|7.\u001a:D_:4\u0017nZ*z]>t\u00170\\:\u0015\u0007\t\\G\u000eE\u0002dQ:r!\u0001\u001a4\u000f\u0005E*\u0017\"A\b\n\u0005\u001dt\u0011a\u00029bG.\fw-Z\u0005\u0003S*\u0014A\u0001T5ti*\u0011qM\u0004\u0005\u0006=~\u0003\rA\f\u0005\u0006[~\u0003\rAW\u0001\u0016[\u0006$8\r\u001b'jgR,g.\u001a:Pm\u0016\u0014(/\u001b3f\u0011\u0019y\u0017\u0002\"\u0001\u0003a\u0006\t\u0012\r\u001a3Es:\fW.[2D_:4\u0017nZ:\u0015\u0005E$\bCA\u0007s\u0013\t\u0019hB\u0001\u0003V]&$\b\"B;o\u0001\u00041\u0018!C2p]\u001aLw\rR3g!\r9\u00181A\u0007\u0002q*\u0011\u0011P_\u0001\u0007G>tg-[4\u000b\u0005md\u0018AB2p[6|gN\u0003\u0002\u0006{*\u0011ap`\u0001\u0007CB\f7\r[3\u000b\u0005\u0005\u0005\u0011aA8sO&\u0019\u0011Q\u0001=\u0003\u0013\r{gNZ5h\t\u00164\u0007\u0002CA\u0005\u0013\u0011\u0005!!a\u0003\u00021\u0011Lh.Y7jG\u000e{gNZ5h+B$\u0017\r^3N_\u0012,7/\u0006\u0002\u0002\u000eA1\u0011qBA\n]9j!!!\u0005\u000b\u00059#\u0013\u0002BA\u000b\u0003#\u00111!T1q\r\u0015Q!\u0001AA\r'\u0015\t9\u0002DA\u000e!\u0011\ti\"a\t\u000e\u0005\u0005}!bAA\u0011\t\u0005)Q\u000f^5mg&!\u0011QEA\u0010\u0005\u001daunZ4j]\u001eD1\"!\u000b\u0002\u0018\t\u0015\r\u0011\"\u0003\u0002,\u0005Y1.\u00194lC\u000e{gNZ5h+\t\ti\u0003E\u0002\t\u0003_I1!!\r\u0003\u0005-Y\u0015MZ6b\u0007>tg-[4\t\u0017\u0005U\u0012q\u0003B\u0001B\u0003%\u0011QF\u0001\rW\u000647.Y\"p]\u001aLw\r\t\u0005\b'\u0005]A\u0011AA\u001d)\u0011\tY$!\u0010\u0011\u0007!\t9\u0002\u0003\u0005\u0002*\u0005]\u0002\u0019AA\u0017\u0011-\t\t%a\u0006C\u0002\u0013\u0005!!a\u0011\u0002'M$\u0018\r^5d\u0005J|7.\u001a:D_:4\u0017nZ:\u0016\u0005\u0005\u0015\u0003#B\r\u0002H\u0001\u0002\u0013bAA\u000b5!I\u00111JA\fA\u0003%\u0011QI\u0001\u0015gR\fG/[2Ce>\\WM]\"p]\u001aLwm\u001d\u0011\t\u0017\u0005=\u0013q\u0003b\u0001\n\u0003\u0011\u00111I\u0001\u0015gR\fG/[2EK\u001a\fW\u000f\u001c;D_:4\u0017nZ:\t\u0013\u0005M\u0013q\u0003Q\u0001\n\u0005\u0015\u0013!F:uCRL7\rR3gCVdGoQ8oM&<7\u000f\t\u0005\u000b\u0003/\n9B1A\u0005\n\u0005e\u0013\u0001\u00063z]\u0006l\u0017n\u0019\"s_.,'oQ8oM&<7/\u0006\u0002\u0002\\A)\u0011$a\u0012/]!I\u0011qLA\fA\u0003%\u00111L\u0001\u0016Ift\u0017-\\5d\u0005J|7.\u001a:D_:4\u0017nZ:!\u0011)\t\u0019'a\u0006C\u0002\u0013%\u0011\u0011L\u0001\u0016Ift\u0017-\\5d\t\u00164\u0017-\u001e7u\u0007>tg-[4t\u0011%\t9'a\u0006!\u0002\u0013\tY&\u0001\fes:\fW.[2EK\u001a\fW\u000f\u001c;D_:4\u0017nZ:!\u0011)\tY'a\u0006C\u0002\u0013%\u0011QN\u0001\u0010e\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197fgV\u0011\u0011q\u000e\t\u00063\u0005E\u0014QO\u0005\u0004\u0003gR\"A\u0002\"vM\u001a,'\u000f\u0005\u0003\u0002x\u0005eT\"\u0001>\n\u0007\u0005m$P\u0001\bSK\u000e|gNZ5hkJ\f'\r\\3\t\u0013\u0005}\u0014q\u0003Q\u0001\n\u0005=\u0014\u0001\u0005:fG>tg-[4ve\u0006\u0014G.Z:!\u0011)\t\u0019)a\u0006C\u0002\u0013%\u0011QQ\u0001\u0016EJ|7.\u001a:SK\u000e|gNZ5hkJ\f'\r\\3t+\t\t9\tE\u0003\u001a\u0003c\nI\tE\u0002\t\u0003\u0017K1!!$\u0003\u0005Q\u0011%o\\6feJ+7m\u001c8gS\u001e,(/\u00192mK\"I\u0011\u0011SA\fA\u0003%\u0011qQ\u0001\u0017EJ|7.\u001a:SK\u000e|gNZ5hkJ\f'\r\\3tA!Q\u0011QSA\f\u0005\u0004%I!a&\u0002\t1|7m[\u000b\u0003\u00033\u0003B!a'\u0002&6\u0011\u0011Q\u0014\u0006\u0005\u0003?\u000b\t+A\u0003m_\u000e\\7O\u0003\u0003\u0002$\u0006E\u0011AC2p]\u000e,(O]3oi&!\u0011qUAO\u0005Y\u0011V-\u001a8ue\u0006tGOU3bI^\u0013\u0018\u000e^3M_\u000e\\\u0007\"CAV\u0003/\u0001\u000b\u0011BAM\u0003\u0015awnY6!\u0011)\ty+a\u0006A\u0002\u0013%\u00111F\u0001\u000eGV\u0014(/\u001a8u\u0007>tg-[4\t\u0015\u0005M\u0016q\u0003a\u0001\n\u0013\t),A\tdkJ\u0014XM\u001c;D_:4\u0017nZ0%KF$2!]A\\\u0011)\tI,!-\u0002\u0002\u0003\u0007\u0011QF\u0001\u0004q\u0012\n\u0004\"CA_\u0003/\u0001\u000b\u0015BA\u0017\u00039\u0019WO\u001d:f]R\u001cuN\u001c4jO\u0002B!\"!1\u0002\u0018\t\u0007I\u0011BAb\u0003q!\u0017P\\1nS\u000e\u001cuN\u001c4jOB\u000b7o]<pe\u0012,enY8eKJ,\"!!2\u0011\u000b5\t9-a3\n\u0007\u0005%gB\u0001\u0004PaRLwN\u001c\t\u0005\u0003;\ti-\u0003\u0003\u0002P\u0006}!a\u0004)bgN<xN\u001d3F]\u000e|G-\u001a:\t\u0013\u0005M\u0017q\u0003Q\u0001\n\u0005\u0015\u0017!\b3z]\u0006l\u0017nY\"p]\u001aLw\rU1tg^|'\u000fZ#oG>$WM\u001d\u0011\t\u0013\u0005]\u0017q\u0003C\u0001\u0005\u0005e\u0017AC5oSRL\u0017\r\\5{KR\u0019\u0011/a7\t\u0011\u0005u\u0017Q\u001ba\u0001\u0003?\f\u0001B_6DY&,g\u000e\u001e\t\u0005\u0003C\f9/\u0004\u0002\u0002d*\u0019\u0011Q\u001d\u0003\u0002\u0005i\\\u0017\u0002BAu\u0003G\u0014QbS1gW\u0006T6n\u00117jK:$\b\u0002CAw\u0003/!\t!a<\u0002%\u0005$GMU3d_:4\u0017nZ;sC\ndWm\u001d\u000b\u0004c\u0006E\b\u0002CAz\u0003W\u0004\r!!>\u0002\u0017-\fgm[1TKJ4XM\u001d\t\u0004\u0011\u0005]\u0018bAA}\u0005\tY1*\u00194lCN+'O^3s\u0011!\ti0a\u0006\u0005\u0002\u0005}\u0018!E1eIJ+7m\u001c8gS\u001e,(/\u00192mKR\u0019\u0011O!\u0001\t\u0011\t\r\u00111 a\u0001\u0003k\naB]3d_:4\u0017nZ;sC\ndW\r\u0003\u0005\u0003\b\u0005]A\u0011\u0001B\u0005\u0003]\tG\r\u001a\"s_.,'OU3d_:4\u0017nZ;sC\ndW\rF\u0002r\u0005\u0017A\u0001Ba\u0001\u0003\u0006\u0001\u0007\u0011\u0011\u0012\u0005\t\u0005\u001f\t9\u0002\"\u0001\u0003\u0012\u0005!\"/Z7pm\u0016\u0014VmY8oM&<WO]1cY\u0016$2!\u001dB\n\u0011!\u0011\u0019A!\u0004A\u0002\u0005U\u0004\"\u0003B\f\u0003/!\tAAA\u0016\u0003I\u0019WO\u001d:f]R\\\u0015MZ6b\u0007>tg-[4\t\u0013\tm\u0011q\u0003C\u0001\u0005\tu\u0011aG2veJ,g\u000e\u001e#z]\u0006l\u0017n\u0019\"s_.,'oQ8oM&<7/\u0006\u0002\u0003 A)!I!\t/]%\u0019\u0011Q\u0003\u000f\t\u0013\t\u0015\u0012q\u0003C\u0001\u0005\tu\u0011\u0001H2veJ,g\u000e\u001e#z]\u0006l\u0017n\u0019#fM\u0006,H\u000e^\"p]\u001aLwm\u001d\u0005\n\u0005S\t9\u0002\"\u0001\u0003\u0005W\t!#\u001e9eCR,'I]8lKJ\u001cuN\u001c4jOR)\u0011O!\f\u00038!A!q\u0006B\u0014\u0001\u0004\u0011\t$\u0001\u0005ce>\\WM]%e!\ri!1G\u0005\u0004\u0005kq!aA%oi\"A!\u0011\bB\u0014\u0001\u0004\u0011Y$A\bqKJ\u001c\u0018n\u001d;f]R\u0004&o\u001c9t!\u0011\tyA!\u0010\n\t\t}\u0012\u0011\u0003\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\b\"\u0003B\"\u0003/!\tA\u0001B#\u0003M)\b\u000fZ1uK\u0012+g-Y;mi\u000e{gNZ5h)\r\t(q\t\u0005\t\u0005s\u0011\t\u00051\u0001\u0003<!A!1JA\f\t\u0013\u0011i%\u0001\u000enCf\u0014Wm\u0011:fCR,\u0007+Y:to>\u0014H-\u00128d_\u0012,'\u000f\u0006\u0003\u0002F\n=\u0003\u0002\u0003B)\u0005\u0013\u0002\rAa\u0015\u0002\rM,7M]3u!\u0015i\u0011q\u0019B+!\u0011\u00119F!\u0018\u000e\u0005\te#b\u0001B.q\u0006)A/\u001f9fg&!!q\fB-\u0005!\u0001\u0016m]:x_J$\u0007\u0002\u0003B2\u0003/!IA!\u001a\u0002\u001fA\f7o]<pe\u0012,enY8eKJ,\"!a3\t\u0013\t%\u0014q\u0003C\u0001\u0005\t-\u0014!\u0005;p!\u0016\u00148/[:uK:$\bK]8qgR1!1\bB7\u0005cB\u0001Ba\u001c\u0003h\u0001\u0007!1H\u0001\fG>tg-[4Qe>\u00048\u000fC\u0004\u0003t\t\u001d\u0004\u0019\u0001.\u0002\u001fA,'O\u0011:pW\u0016\u00148i\u001c8gS\u001eD\u0011Ba\u001e\u0002\u0018\u0011\u0005!A!\u001f\u0002'\u0019\u0014x.\u001c)feNL7\u000f^3oiB\u0013x\u000e]:\u0015\r\tm\"1\u0010B?\u0011!\u0011ID!\u001eA\u0002\tm\u0002b\u0002B:\u0005k\u0002\rA\u0017\u0005\t\u0005\u0003\u000b9\u0002\"\u0003\u0003\u0004\u00061R.Y=cKJ+WI\\2pI\u0016\u0004\u0016m]:x_J$7\u000f\u0006\u0004\u0003<\t\u0015%q\u0011\u0005\t\u0005s\u0011y\b1\u0001\u0003<!A!\u0011\u0012B@\u0001\u0004\u0011Y)A\u0007bI6LgNW6DY&,g\u000e\u001e\t\u0005\u0003C\u0014i)\u0003\u0003\u0003\u0010\u0006\r(!D!e[&t'l[\"mS\u0016tG\u000fC\u0005\u0003\u0014\u0006]A\u0011\u0001\u0002\u0003\u0016\u0006Aa/\u00197jI\u0006$X\rF\u0003r\u0005/\u0013Y\n\u0003\u0005\u0003\u001a\nE\u0005\u0019\u0001B\u001e\u0003\u0015\u0001(o\u001c9t\u0011\u001d\u0011\u0019H!%A\u0002iC\u0001Ba(\u0002\u0018\u0011%!\u0011U\u0001\u0011a\u0016\u0014(I]8lKJ\u001cuN\u001c4jON$BAa)\u0003&B\u0019!i\u0011\u0018\t\u0011\te%Q\u0014a\u0001\u0005wA\u0001B!+\u0002\u0018\u0011%!1V\u0001\u0012]>tG)\u001f8b[&\u001c7i\u001c8gS\u001e\u001cH\u0003\u0002BR\u0005[C\u0001B!'\u0003(\u0002\u0007!1\b\u0005\t\u0005c\u000b9\u0002\"\u0003\u00034\u0006!3/Z2ve&$\u0018pQ8oM&<7oV5uQ>,H\u000fT5ti\u0016tWM\u001d)sK\u001aL\u0007\u0010\u0006\u0003\u0003$\nU\u0006\u0002\u0003BM\u0005_\u0003\rAa\u000f\t\u0011\te\u0016q\u0003C\u0005\u0005w\u000b1C^1mS\u0012\fG/Z\"p]\u001aLw\rV=qKN$2!\u001dB_\u0011!\u0011IJa.A\u0002\tm\u0002\u0002\u0003Ba\u0003/!IAa1\u0002)I,Wn\u001c<f\u0013:4\u0018\r\\5e\u0007>tg-[4t)\u0015\t(Q\u0019Bd\u0011!\u0011IJa0A\u0002\tm\u0002b\u0002B:\u0005\u007f\u0003\rA\u0017\u0005\n\u0005\u0017\f9\u0002\"\u0001\u0003\u0005\u001b\f\u0001#\\1zE\u0016\u0014VmY8oM&<WO]3\u0015\u000fE\u0014yM!5\u0003V\"A!1\u0001Be\u0001\u0004\t)\b\u0003\u0005\u0003T\n%\u0007\u0019AA\u0017\u0003%yG\u000eZ\"p]\u001aLw\r\u0003\u0005\u0003X\n%\u0007\u0019\u0001Bm\u0003%qWm^\"p]\u001aLw\r\r\u0003\u0003\\\n\u0005\bcBA\b\u0003'q#Q\u001c\t\u0005\u0005?\u0014\t\u000f\u0004\u0001\u0005\u0019\t\r(Q[A\u0001\u0002\u0003\u0015\tA!:\u0003\u0007}#\u0013'\u0005\u0003\u0003h\n5\bcA\u0007\u0003j&\u0019!1\u001e\b\u0003\u000f9{G\u000f[5oOB\u0019QBa<\n\u0007\tEhBA\u0002B]fD\u0001B!>\u0002\u0018\u0011%!q_\u0001\u000fkB$\u0017\r^3e\u0007>tg-[4t)\u0019\u0011Ipa\u0001\u0004\u0012A\"!1 B\u0000!\u0019I\u0012q\t\u0018\u0003~B!!q\u001cB\u0000\t1\u0019\tAa=\u0002\u0002\u0003\u0005)\u0011\u0001Bs\u0005\ryF%\u000e\u0005\t\u0007\u000b\u0011\u0019\u00101\u0001\u0004\b\u0005Aa.Z<Qe>\u00048\u000f\r\u0003\u0004\n\r5\u0001cBA\b\u0003'q31\u0002\t\u0005\u0005?\u001ci\u0001\u0002\u0007\u0004\u0010\r\r\u0011\u0011!A\u0001\u0006\u0003\u0011)OA\u0002`IIB\u0001ba\u0005\u0003t\u0002\u00071QC\u0001\rGV\u0014(/\u001a8u!J|\u0007o\u001d\u0019\u0007\u0007/\u0019Yb!\t\u0011\u0011\u0005=\u00111CB\r\u0007?\u0001BAa8\u0004\u001c\u0011a1QDB\t\u0003\u0003\u0005\tQ!\u0001\u0003f\n\u0019q\fJ\u001a\u0011\t\t}7\u0011\u0005\u0003\r\u0007G\u0019\t\"!A\u0001\u0002\u000b\u0005!Q\u001d\u0002\u0004?\u0012\"\u0004\u0002CB\u0014\u0003/!Ia!\u000b\u0002\u001b=4XM\u001d:jI\u0016\u0004&o\u001c9t)\u0015\t81FB\u0017\u0011!\u0011Ij!\nA\u0002\u0005m\u0003\u0002CB\u0018\u0007K\u0001\r!a\u0017\u0002\u001bA\u0014x\u000e]:Pm\u0016\u0014(/\u001b3f\u0011!\u0019\u0019$a\u0006\u0005\n\rU\u0012aE;qI\u0006$XmQ;se\u0016tGoQ8oM&<G#A9\t\u0011\re\u0012q\u0003C\u0005\u0007w\ta\u0003\u001d:pG\u0016\u001c8OU3d_:4\u0017nZ;sCRLwN\u001c\u000b\u0007\u0007{\u0019)ea\u0012\u0011\u000f5\u0019y$!\f\u0004D%\u00191\u0011\t\b\u0003\rQ+\b\u000f\\33!\u0011\u0019\u0007.!#\t\u0011\r\u00151q\u0007a\u0001\u0005?Aqa!\u0013\u00048\u0001\u0007!,\u0001\u0007wC2LG-\u0019;f\u001f:d\u0017\u0010\u0003\u0005\u0004N\u0005]A\u0011BB(\u0003QqW-\u001a3t%\u0016\u001cwN\u001c4jOV\u0014\u0018\r^5p]R)!l!\u0015\u0004Z!A11KB&\u0001\u0004\u0019)&A\u000bsK\u000e|gNZ5hkJ\f'\r\\3D_:4\u0017nZ:\u0011\u000b\u0005=1q\u000b\u0018\n\u0007}\t\t\u0002\u0003\u0005\u0004\\\r-\u0003\u0019\u0001BR\u0003-)\b\u000fZ1uK\u0012\\U-_:\t\u0011\r}\u0013q\u0003C\u0005\u0007C\nQ\u0003\u001d:pG\u0016\u001c8OU3d_:4\u0017nZ;sC\ndW\rF\u0006r\u0007G\u001a)g!\u001b\u0004x\r\r\u0005\u0002\u0003B\u0002\u0007;\u0002\r!!\u001e\t\u0011\r\u001d4Q\fa\u0001\u0005G\u000b!#\u001e9eCR,GmQ8oM&<g*Y7fg\"A11NB/\u0001\u0004\u0019i'A\u0007bY2tUm^\"p]\u001aLwm\u001d\u0019\u0005\u0007_\u001a\u0019\bE\u0004\u0002\u0010\u0005Maf!\u001d\u0011\t\t}71\u000f\u0003\r\u0007k\u001aI'!A\u0001\u0002\u000b\u0005!Q\u001d\u0002\u0004?\u00122\u0004\u0002CB=\u0007;\u0002\raa\u001f\u0002!9,woQ;ti>l7i\u001c8gS\u001e\u001c\bcBA\b\u0003'q3Q\u0010\t\u0004C\r}\u0014bABAE\t1qJ\u00196fGRDqa!\u0013\u0004^\u0001\u0007!\f")
public class DynamicBrokerConfig
implements Logging {
    private final KafkaConfig kafkaConfig;
    private final scala.collection.mutable.Map<String, String> staticBrokerConfigs;
    private final scala.collection.mutable.Map<String, String> staticDefaultConfigs;
    private final scala.collection.mutable.Map<String, String> dynamicBrokerConfigs;
    private final scala.collection.mutable.Map<String, String> dynamicDefaultConfigs;
    private final Buffer<Reconfigurable> reconfigurables;
    private final Buffer<BrokerReconfigurable> brokerReconfigurables;
    private final ReentrantReadWriteLock lock;
    private KafkaConfig currentConfig;
    private final Option<PasswordEncoder> dynamicConfigPasswordEncoder;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static List<String> brokerConfigSynonyms(String string, boolean bl) {
        return DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms(string, bl);
    }

    public static boolean isPasswordConfig(String string) {
        return DynamicBrokerConfig$.MODULE$.isPasswordConfig(string);
    }

    public static Regex ListenerConfigRegex() {
        return DynamicBrokerConfig$.MODULE$.ListenerConfigRegex();
    }

    public static scala.collection.mutable.Set<String> AllDynamicConfigs() {
        return DynamicBrokerConfig$.MODULE$.AllDynamicConfigs();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        DynamicBrokerConfig dynamicBrokerConfig = this;
        synchronized (dynamicBrokerConfig) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private KafkaConfig kafkaConfig() {
        return this.kafkaConfig;
    }

    public scala.collection.mutable.Map<String, String> staticBrokerConfigs() {
        return this.staticBrokerConfigs;
    }

    public scala.collection.mutable.Map<String, String> staticDefaultConfigs() {
        return this.staticDefaultConfigs;
    }

    private scala.collection.mutable.Map<String, String> dynamicBrokerConfigs() {
        return this.dynamicBrokerConfigs;
    }

    private scala.collection.mutable.Map<String, String> dynamicDefaultConfigs() {
        return this.dynamicDefaultConfigs;
    }

    private Buffer<Reconfigurable> reconfigurables() {
        return this.reconfigurables;
    }

    private Buffer<BrokerReconfigurable> brokerReconfigurables() {
        return this.brokerReconfigurables;
    }

    private ReentrantReadWriteLock lock() {
        return this.lock;
    }

    private KafkaConfig currentConfig() {
        return this.currentConfig;
    }

    private void currentConfig_$eq(KafkaConfig x$1) {
        this.currentConfig = x$1;
    }

    private Option<PasswordEncoder> dynamicConfigPasswordEncoder() {
        return this.dynamicConfigPasswordEncoder;
    }

    public void initialize(KafkaZkClient zkClient) {
        this.currentConfig_$eq(new KafkaConfig(this.kafkaConfig().props(), false, (Option<DynamicBrokerConfig>)None$.MODULE$));
        AdminZkClient adminZkClient = new AdminZkClient(zkClient);
        this.updateDefaultConfig(adminZkClient.fetchEntityConfig(ConfigType$.MODULE$.Broker(), ConfigEntityName$.MODULE$.Default()));
        Properties props = adminZkClient.fetchEntityConfig(ConfigType$.MODULE$.Broker(), ((Object)BoxesRunTime.boxToInteger((int)this.kafkaConfig().brokerId())).toString());
        Properties brokerConfig = this.maybeReEncodePasswords(props, adminZkClient);
        this.updateBrokerConfig(this.kafkaConfig().brokerId(), brokerConfig);
    }

    public void addReconfigurables(KafkaServer kafkaServer) {
        this.addBrokerReconfigurable(new DynamicThreadPool(kafkaServer));
        if (kafkaServer.logManager().cleaner() != null) {
            this.addBrokerReconfigurable(kafkaServer.logManager().cleaner());
        }
        this.addReconfigurable(new DynamicLogConfig(kafkaServer.logManager()));
        this.addReconfigurable(new DynamicMetricsReporters(this.kafkaConfig().brokerId(), kafkaServer));
        this.addBrokerReconfigurable(new DynamicListenerConfig(kafkaServer));
    }

    public void addReconfigurable(Reconfigurable reconfigurable) {
        CoreUtils$.MODULE$.inWriteLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.require(((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(reconfigurable.reconfigurableConfigs()).asScala()).forall((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig.$anonfun$addReconfigurable$2(elem))));
            return this.reconfigurables().$plus$eq((Object)reconfigurable);
        });
    }

    public void addBrokerReconfigurable(BrokerReconfigurable reconfigurable) {
        CoreUtils$.MODULE$.inWriteLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.require(reconfigurable.reconfigurableConfigs().forall((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig.$anonfun$addBrokerReconfigurable$2(elem))));
            return this.brokerReconfigurables().$plus$eq((Object)reconfigurable);
        });
    }

    public void removeReconfigurable(Reconfigurable reconfigurable) {
        CoreUtils$.MODULE$.inWriteLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> this.reconfigurables().$minus$eq((Object)reconfigurable));
    }

    public KafkaConfig currentKafkaConfig() {
        return (KafkaConfig)CoreUtils$.MODULE$.inReadLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> this.currentConfig());
    }

    public Map<String, String> currentDynamicBrokerConfigs() {
        return (Map)CoreUtils$.MODULE$.inReadLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> this.dynamicBrokerConfigs().clone());
    }

    public Map<String, String> currentDynamicDefaultConfigs() {
        return (Map)CoreUtils$.MODULE$.inReadLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> this.dynamicDefaultConfigs().clone());
    }

    public void updateBrokerConfig(int brokerId, Properties persistentProps) {
        CoreUtils$.MODULE$.inWriteLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            try {
                Properties props = this.fromPersistentProps(persistentProps, true);
                this.dynamicBrokerConfigs().clear();
                this.dynamicBrokerConfigs().$plus$plus$eq((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala());
                this.updateCurrentConfig();
            }
            catch (Exception e) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Per-broker configs of ", " could not be applied: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)brokerId), persistentProps})), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            }
        });
    }

    public void updateDefaultConfig(Properties persistentProps) {
        CoreUtils$.MODULE$.inWriteLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            try {
                Properties props = this.fromPersistentProps(persistentProps, false);
                this.dynamicDefaultConfigs().clear();
                this.dynamicDefaultConfigs().$plus$plus$eq((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala());
                this.updateCurrentConfig();
            }
            catch (Exception e) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cluster default configs could not be applied: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{persistentProps})), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            }
        });
    }

    private Option<PasswordEncoder> maybeCreatePasswordEncoder(Option<Password> secret2) {
        return secret2.map((Function1 & Serializable & scala.Serializable)secret -> new PasswordEncoder((Password)secret, this.kafkaConfig().passwordEncoderKeyFactoryAlgorithm(), this.kafkaConfig().passwordEncoderCipherAlgorithm(), Predef$.MODULE$.Integer2int(this.kafkaConfig().passwordEncoderKeyLength()), Predef$.MODULE$.Integer2int(this.kafkaConfig().passwordEncoderIterations())));
    }

    private PasswordEncoder passwordEncoder() {
        return (PasswordEncoder)this.dynamicConfigPasswordEncoder().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new ConfigException("Password encoder secret not configured");
        });
    }

    /*
     * WARNING - void declaration
     */
    public Properties toPersistentProps(Properties configProps, boolean perBrokerConfig) {
        void var3_3;
        Properties props = (Properties)configProps.clone();
        ((MapLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(configProps).asScala()).filterKeys((Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig$.MODULE$.isPasswordConfig(name))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            DynamicBrokerConfig.$anonfun$toPersistentProps$2(this, perBrokerConfig, props, x0$1);
            return BoxedUnit.UNIT;
        });
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public Properties fromPersistentProps(Properties persistentProps, boolean perBrokerConfig) {
        void var3_3;
        Properties props = (Properties)persistentProps.clone();
        this.removeInvalidConfigs(props, perBrokerConfig);
        this.removeInvalidProps$1(this.nonDynamicConfigs(props), "Non-dynamic configs configured in ZooKeeper will be ignored", props);
        this.removeInvalidProps$1(this.securityConfigsWithoutListenerPrefix(props), "Security configs can be dynamically updated only using listener prefix, base configs will be ignored", props);
        if (!perBrokerConfig) {
            this.removeInvalidProps$1(this.perBrokerConfigs(props), "Per-broker configs defined at default cluster level will be ignored", props);
        }
        ((MapLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala()).filterKeys((Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig$.MODULE$.isPasswordConfig(name))).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            DynamicBrokerConfig.$anonfun$fromPersistentProps$6(this, props, x0$2);
            return BoxedUnit.UNIT;
        });
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private Properties maybeReEncodePasswords(Properties persistentProps, AdminZkClient adminZkClient) {
        void var3_3;
        block0: {
            Properties props = (Properties)persistentProps.clone();
            if (!((MapLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala()).keySet().exists((Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig$.MODULE$.isPasswordConfig(name)))) break block0;
            this.maybeCreatePasswordEncoder(this.kafkaConfig().passwordEncoderOldSecret()).foreach((Function1 & Serializable & scala.Serializable)passwordDecoder -> {
                DynamicBrokerConfig.$anonfun$maybeReEncodePasswords$2(this, persistentProps, adminZkClient, props, passwordDecoder);
                return BoxedUnit.UNIT;
            });
        }
        return var3_3;
    }

    public void validate(Properties props, boolean perBrokerConfig) {
        CoreUtils$.MODULE$.inReadLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> {
            DynamicBrokerConfig.checkInvalidProps$1(this.nonDynamicConfigs(props), "Cannot update these configs dynamically");
            DynamicBrokerConfig.checkInvalidProps$1(this.securityConfigsWithoutListenerPrefix(props), "These security configs can be dynamically updated only per-listener using the listener prefix");
            this.validateConfigTypes(props);
            scala.collection.mutable.Map newProps = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
            newProps.$plus$plus$eq(this.staticBrokerConfigs());
            if (perBrokerConfig) {
                this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, this.dynamicDefaultConfigs());
                this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, (scala.collection.mutable.Map<String, String>)((scala.collection.mutable.Map)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala()));
            } else {
                DynamicBrokerConfig.checkInvalidProps$1(this.perBrokerConfigs(props), "Cannot update these configs at default cluster level, broker id must be specified");
                this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, (scala.collection.mutable.Map<String, String>)((scala.collection.mutable.Map)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala()));
                this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, this.dynamicBrokerConfigs());
            }
            return this.processReconfiguration((Map<String, String>)newProps, true);
        });
    }

    private Set<String> perBrokerConfigs(Properties props) {
        Set configNames = ((MapLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala()).keySet();
        return ((SetLike)configNames.intersect(DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$PerBrokerConfigs())).$plus$plus((GenTraversableOnce)configNames.filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig.$anonfun$perBrokerConfigs$1(x$2))));
    }

    private Set<String> nonDynamicConfigs(Properties props) {
        return (Set)((MapLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala()).keySet().intersect(DynamicConfig$Broker$.MODULE$.nonDynamicProps());
    }

    private Set<String> securityConfigsWithoutListenerPrefix(Properties props) {
        return (Set)DynamicBrokerConfig$.MODULE$.DynamicSecurityConfigs().filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)props.containsKey(x$1)));
    }

    private void validateConfigTypes(Properties props) {
        Properties baseProps = new Properties();
        ((IterableLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$4 -> {
            Tuple2 tuple2 = x0$4;
            if (tuple2 != null) {
                String string = (String)tuple2._1();
                String v = (String)tuple2._2();
                Option option = DynamicBrokerConfig$.MODULE$.ListenerConfigRegex().unapplySeq((CharSequence)string);
                if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
                    String baseName = (String)((LinearSeqOptimized)option.get()).apply(0);
                    return baseProps.put(baseName, v);
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            return baseProps.put(k, v);
        });
        DynamicConfig$Broker$.MODULE$.validate(baseProps);
    }

    private void removeInvalidConfigs(Properties props, boolean perBrokerConfig) {
        try {
            this.validateConfigTypes(props);
            JavaConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala();
        }
        catch (Exception e) {
            scala.collection.mutable.Map invalidProps = (scala.collection.mutable.Map)((TraversableLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$5 -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig.$anonfun$removeInvalidConfigs$1(this, x0$5)));
            invalidProps.foreach((Function1 & Serializable & scala.Serializable)x$1 -> props.remove(x$1));
            String configSource = perBrokerConfig ? "broker" : "default cluster";
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Dynamic ", " config contains invalid values: ", ", these configs will be ignored"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{configSource, invalidProps})), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
        }
    }

    public void maybeReconfigure(Reconfigurable reconfigurable, KafkaConfig oldConfig, java.util.Map<String, ?> newConfig) {
        block0: {
            if (!((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(reconfigurable.reconfigurableConfigs()).asScala()).exists((Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig.$anonfun$maybeReconfigure$1(oldConfig, newConfig, key)))) break block0;
            reconfigurable.reconfigure(newConfig);
        }
    }

    private scala.collection.mutable.Map<String, ?> updatedConfigs(java.util.Map<String, ?> newProps, java.util.Map<?, ?> currentProps) {
        return (scala.collection.mutable.Map)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(newProps).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$6 -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig.$anonfun$updatedConfigs$1(currentProps, x0$6)));
    }

    private void overrideProps(scala.collection.mutable.Map<String, String> props, scala.collection.mutable.Map<String, String> propsOverride) {
        propsOverride.foreach((Function1 & Serializable & scala.Serializable)x0$7 -> {
            Tuple2 tuple2 = x0$7;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms(k, false).foreach((Function1 & Serializable & scala.Serializable)key -> props.remove(key));
            Option option = props.put((Object)k, (Object)v);
            return option;
        });
    }

    private void updateCurrentConfig() {
        block1: {
            scala.collection.mutable.Map newProps = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
            newProps.$plus$plus$eq(this.staticBrokerConfigs());
            this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, this.dynamicDefaultConfigs());
            this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, this.dynamicBrokerConfigs());
            KafkaConfig oldConfig = this.currentConfig();
            Tuple2<KafkaConfig, List<BrokerReconfigurable>> tuple2 = this.processReconfiguration((Map<String, String>)newProps, false);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            KafkaConfig newConfig = (KafkaConfig)tuple2._1();
            List brokerReconfigurablesToUpdate = (List)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)newConfig, (Object)brokerReconfigurablesToUpdate);
            Tuple2 tuple23 = tuple22;
            KafkaConfig newConfig2 = (KafkaConfig)tuple23._1();
            List brokerReconfigurablesToUpdate2 = (List)tuple23._2();
            if (newConfig2 == this.currentConfig()) break block1;
            this.currentConfig_$eq(newConfig2);
            this.kafkaConfig().updateCurrentConfig(newConfig2);
            brokerReconfigurablesToUpdate2.foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                x$4.reconfigure(oldConfig, newConfig2);
                return BoxedUnit.UNIT;
            });
        }
    }

    private Tuple2<KafkaConfig, List<BrokerReconfigurable>> processReconfiguration(Map<String, String> newProps, boolean validateOnly) {
        Tuple2 tuple2;
        KafkaConfig newConfig = new KafkaConfig((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(newProps).asJava(), !validateOnly, (Option<DynamicBrokerConfig>)None$.MODULE$);
        scala.collection.mutable.Map<String, ?> updatedMap = this.updatedConfigs(newConfig.originalsFromThisConfig(), this.currentConfig().originals());
        if (updatedMap.nonEmpty()) {
            try {
                HashMap<String, Object> customConfigs = new HashMap<String, Object>(newConfig.originalsFromThisConfig());
                ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(newConfig.valuesFromThisConfig().keySet()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x$1 -> customConfigs.remove(x$1));
                this.reconfigurables().foreach((Function1 & Serializable & scala.Serializable)x0$8 -> {
                    DynamicBrokerConfig.$anonfun$processReconfiguration$2(this, validateOnly, newConfig, updatedMap, customConfigs, x0$8);
                    return BoxedUnit.UNIT;
                });
                Buffer brokerReconfigurablesToUpdate = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
                this.brokerReconfigurables().foreach((Function1 & Serializable & scala.Serializable)reconfigurable -> {
                    Object object;
                    if (this.needsReconfiguration((java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter(reconfigurable.reconfigurableConfigs()).asJava(), (Set<String>)updatedMap.keySet())) {
                        reconfigurable.validateReconfiguration(newConfig);
                        object = !validateOnly ? brokerReconfigurablesToUpdate.$plus$eq(reconfigurable) : BoxedUnit.UNIT;
                    } else {
                        object = BoxedUnit.UNIT;
                    }
                    return object;
                });
                tuple2 = new Tuple2((Object)newConfig, (Object)brokerReconfigurablesToUpdate.toList());
            }
            catch (Exception e) {
                if (!validateOnly) {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to update broker configuration with configs : ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{newConfig.originalsFromThisConfig()})), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                }
                throw new ConfigException("Invalid dynamic configuration", (Object)e);
            }
        } else {
            tuple2 = new Tuple2((Object)this.currentConfig(), (Object)List$.MODULE$.empty());
        }
        return tuple2;
    }

    private boolean needsReconfiguration(java.util.Set<String> reconfigurableConfigs, Set<String> updatedKeys) {
        return ((TraversableOnce)((GenSetLike)JavaConverters$.MODULE$.asScalaSetConverter(reconfigurableConfigs).asScala()).intersect(updatedKeys)).nonEmpty();
    }

    private void processReconfigurable(Reconfigurable reconfigurable, Set<String> updatedConfigNames, java.util.Map<String, ?> allNewConfigs, java.util.Map<String, Object> newCustomConfigs, boolean validateOnly) {
        block3: {
            HashMap<String, Object> newConfigs = new HashMap<String, Object>();
            ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(allNewConfigs).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$9 -> {
                Tuple2 tuple2 = x0$9;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String k = (String)tuple2._1();
                Object v = tuple2._2();
                Object object = newConfigs.put(k, v);
                return object;
            });
            newConfigs.putAll(newCustomConfigs);
            try {
                reconfigurable.validateReconfiguration(newConfigs);
            }
            catch (ConfigException e) {
                throw e;
            }
            catch (Exception exception) {
                throw new ConfigException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Validation of dynamic config update of ", " failed with class ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{updatedConfigNames, reconfigurable.getClass()})));
            }
            if (validateOnly) break block3;
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Reconfiguring ", ", updated configs: ", " custom configs: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{reconfigurable, updatedConfigNames, newCustomConfigs})));
            reconfigurable.reconfigure(newConfigs);
        }
    }

    public static final /* synthetic */ boolean $anonfun$addReconfigurable$2(String elem) {
        return DynamicBrokerConfig$.MODULE$.AllDynamicConfigs().contains((Object)elem);
    }

    public static final /* synthetic */ boolean $anonfun$addBrokerReconfigurable$2(String elem) {
        return DynamicBrokerConfig$.MODULE$.AllDynamicConfigs().contains((Object)elem);
    }

    private final void encodePassword$1(String configName, String value, boolean perBrokerConfig$2, Properties props$2) {
        block1: {
            if (value == null) break block1;
            if (!perBrokerConfig$2) {
                throw new ConfigException("Password config can be defined only at broker level");
            }
            props$2.setProperty(configName, this.passwordEncoder().encode(new Password(value)));
        }
    }

    public static final /* synthetic */ void $anonfun$toPersistentProps$2(DynamicBrokerConfig $this, boolean perBrokerConfig$2, Properties props$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String name = (String)tuple2._1();
        String value = (String)tuple2._2();
        $this.encodePassword$1(name, value, perBrokerConfig$2, props$2);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private final void removeInvalidProps$1(Set invalidPropNames, String errorMessage, Properties props$3) {
        block0: {
            if (!invalidPropNames.nonEmpty()) break block0;
            invalidPropNames.foreach((Function1 & Serializable & scala.Serializable)x$1 -> props$3.remove(x$1));
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{errorMessage, invalidPropNames})));
        }
    }

    private final void decodePassword$1(String configName, String value, Properties props$3) {
        block2: {
            if (value == null) break block2;
            try {
                props$3.setProperty(configName, this.passwordEncoder().decode(value).value());
            }
            catch (Exception e) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Dynamic password config ", " could not be decoded, ignoring."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{configName})), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                props$3.remove(configName);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$fromPersistentProps$6(DynamicBrokerConfig $this, Properties props$3, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String name = (String)tuple2._1();
        String value = (String)tuple2._2();
        $this.decodePassword$1(name, value, props$3);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$maybeReEncodePasswords$4(DynamicBrokerConfig $this, Properties props$6, PasswordEncoder passwordDecoder$1, Tuple2 x0$3) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$3;
        if (tuple2 != null) {
            String configName = (String)tuple2._1();
            String value2 = (String)tuple2._2();
            if (value2 != null) {
                Some some;
                try {
                    some = new Some((Object)passwordDecoder$1.decode(value2).value());
                }
                catch (Exception exception) {
                    $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Dynamic password config ", " could not be decoded using old secret, new secret will be used."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{configName})));
                    some = None$.MODULE$;
                }
                Some decoded = some;
                decoded.foreach((Function1 & Serializable & scala.Serializable)value -> props$6.put(configName, $this.passwordEncoder().encode(new Password((String)value))));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ void $anonfun$maybeReEncodePasswords$2(DynamicBrokerConfig $this, Properties persistentProps$3, AdminZkClient adminZkClient$1, Properties props$6, PasswordEncoder passwordDecoder) {
        ((MapLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(persistentProps$3).asScala()).filterKeys((Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig$.MODULE$.isPasswordConfig(name))).foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
            DynamicBrokerConfig.$anonfun$maybeReEncodePasswords$4($this, props$6, passwordDecoder, x0$3);
            return BoxedUnit.UNIT;
        });
        adminZkClient$1.changeBrokerConfig((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.kafkaConfig().brokerId()}))), props$6);
    }

    private static final void checkInvalidProps$1(Set invalidPropNames, String errorMessage) {
        if (invalidPropNames.nonEmpty()) {
            throw new ConfigException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{errorMessage, invalidPropNames})));
        }
    }

    public static final /* synthetic */ boolean $anonfun$perBrokerConfigs$1(String x$2) {
        return DynamicBrokerConfig$.MODULE$.ListenerConfigRegex().findFirstIn((CharSequence)x$2).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$removeInvalidConfigs$1(DynamicBrokerConfig $this, Tuple2 x0$5) {
        boolean bl;
        Tuple2 tuple2 = x0$5;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            Properties props1 = new Properties();
            props1.put(k, v);
            try {
                $this.validateConfigTypes(props1);
                bl = false;
            }
            catch (Exception exception) {
                bl = true;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        boolean bl2 = bl;
        return bl2;
    }

    public static final /* synthetic */ boolean $anonfun$maybeReconfigure$1(KafkaConfig oldConfig$1, java.util.Map newConfig$1, String key) {
        return !BoxesRunTime.equals((Object)oldConfig$1.originals().get(key), newConfig$1.get(key));
    }

    public static final /* synthetic */ boolean $anonfun$updatedConfigs$1(java.util.Map currentProps$1, Tuple2 x0$6) {
        Tuple2 tuple2 = x0$6;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String k = (String)tuple2._1();
        Object v = tuple2._2();
        boolean bl = !BoxesRunTime.equals((Object)v, currentProps$1.get(k));
        return bl;
    }

    public static final /* synthetic */ void $anonfun$processReconfiguration$2(DynamicBrokerConfig $this, boolean validateOnly$1, KafkaConfig newConfig$3, scala.collection.mutable.Map updatedMap$1, HashMap customConfigs$1, Reconfigurable x0$8) {
        Reconfigurable reconfigurable = x0$8;
        if (reconfigurable instanceof ListenerReconfigurable) {
            BoxedUnit boxedUnit;
            ListenerReconfigurable listenerReconfigurable = (ListenerReconfigurable)reconfigurable;
            ListenerName listenerName = listenerReconfigurable.listenerName();
            java.util.Map<String, Object> oldValues = $this.currentConfig().valuesWithPrefixOverride(listenerName.configPrefix());
            java.util.Map<String, Object> newValues = newConfig$3.valuesFromThisConfigWithPrefixOverride(listenerName.configPrefix());
            Set updatedKeys = $this.updatedConfigs(newValues, oldValues).keySet();
            if ($this.needsReconfiguration(listenerReconfigurable.reconfigurableConfigs(), (Set<String>)updatedKeys)) {
                $this.processReconfigurable(listenerReconfigurable, (Set<String>)updatedKeys, newValues, customConfigs$1, validateOnly$1);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            BoxedUnit boxedUnit;
            if ($this.needsReconfiguration(reconfigurable.reconfigurableConfigs(), (Set<String>)updatedMap$1.keySet())) {
                $this.processReconfigurable(reconfigurable, (Set<String>)updatedMap$1.keySet(), newConfig$3.valuesFromThisConfig(), customConfigs$1, validateOnly$1);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit3 = boxedUnit;
        }
    }

    public DynamicBrokerConfig(KafkaConfig kafkaConfig) {
        this.kafkaConfig = kafkaConfig;
        Logging.$init$(this);
        this.staticBrokerConfigs = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(ConfigDef.convertToStringMapWithPasswordValues(kafkaConfig.originalsFromThisConfig())).asScala();
        this.staticDefaultConfigs = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(ConfigDef.convertToStringMapWithPasswordValues((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(KafkaConfig$.MODULE$.defaultValues()).asJava())).asScala();
        this.dynamicBrokerConfigs = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.dynamicDefaultConfigs = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.reconfigurables = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.brokerReconfigurables = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.lock = new ReentrantReadWriteLock();
        this.currentConfig = kafkaConfig;
        this.dynamicConfigPasswordEncoder = this.maybeCreatePasswordEncoder(kafkaConfig.passwordEncoderSecret());
    }
}

