/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.server;

import io.confluent.kafka.cluster.Replica;
import io.confluent.kafka.server.DelayedFetchMetrics$;
import io.confluent.kafka.server.DelayedOperation;
import io.confluent.kafka.server.DelayedOperation$;
import io.confluent.kafka.server.FetchMetadata;
import io.confluent.kafka.server.FetchPartitionData;
import io.confluent.kafka.server.FetchPartitionStatus;
import io.confluent.kafka.server.LogOffsetMetadata;
import io.confluent.kafka.server.LogOffsetMetadata$;
import io.confluent.kafka.server.LogReadResult;
import io.confluent.kafka.server.ReplicaManager;
import io.confluent.kafka.server.ReplicaQuota;
import io.confluent.org.apache.kafka.common.TopicPartition;
import io.confluent.org.apache.kafka.common.errors.KafkaStorageException;
import io.confluent.org.apache.kafka.common.errors.NotLeaderForPartitionException;
import io.confluent.org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import io.confluent.org.apache.kafka.common.requests.FetchRequest;
import io.confluent.org.apache.kafka.common.requests.IsolationLevel;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;

@ScalaSignature(bytes="\u0006\u0001\u00014A!\u0001\u0002\u0001\u000f\taA)\u001a7bs\u0016$g)\u001a;dQ*\u00111\u0001B\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011BC\u0007\u0002\u0005%\u00111B\u0001\u0002\u0011\t\u0016d\u0017-_3e\u001fB,'/\u0019;j_:D\u0011\"\u0004\u0001\u0003\u0002\u0003\u0006IA\u0004\u000b\u0002\u000f\u0011,G.Y=NgB\u0011qBE\u0007\u0002!)\t\u0011#A\u0003tG\u0006d\u0017-\u0003\u0002\u0014!\t!Aj\u001c8h\u0013\ti!\u0002\u0003\u0005\u0017\u0001\t\u0005\t\u0015!\u0003\u0018\u000351W\r^2i\u001b\u0016$\u0018\rZ1uCB\u0011\u0011\u0002G\u0005\u00033\t\u0011QBR3uG\"lU\r^1eCR\f\u0007\u0002C\u000e\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000f\u0002\u001dI,\u0007\u000f\\5dC6\u000bg.Y4feB\u0011\u0011\"H\u0005\u0003=\t\u0011aBU3qY&\u001c\u0017-T1oC\u001e,'\u000f\u0003\u0005!\u0001\t\u0005\t\u0015!\u0003\"\u0003\u0015\tXo\u001c;b!\tI!%\u0003\u0002$\u0005\ta!+\u001a9mS\u000e\f\u0017+^8uC\"AQ\u0005\u0001B\u0001B\u0003%a%\u0001\bjg>d\u0017\r^5p]2+g/\u001a7\u0011\u0005\u001d\nT\"\u0001\u0015\u000b\u0005%R\u0013\u0001\u0003:fcV,7\u000f^:\u000b\u0005-b\u0013AB2p[6|gN\u0003\u0002\u0006[)\u0011afL\u0001\u0007CB\f7\r[3\u000b\u0003A\n1a\u001c:h\u0013\t\u0011\u0004F\u0001\bJg>d\u0017\r^5p]2+g/\u001a7\t\u0011Q\u0002!\u0011!Q\u0001\nU\n\u0001C]3ta>t7/Z\"bY2\u0014\u0017mY6\u0011\t=1\u0004\bS\u0005\u0003oA\u0011\u0011BR;oGRLwN\\\u0019\u0011\u0007ebd(D\u0001;\u0015\tY\u0004#\u0001\u0006d_2dWm\u0019;j_:L!!\u0010\u001e\u0003\u0007M+\u0017\u000f\u0005\u0003\u0010\u007f\u0005+\u0015B\u0001!\u0011\u0005\u0019!V\u000f\u001d7feA\u0011!iQ\u0007\u0002U%\u0011AI\u000b\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o!\tIa)\u0003\u0002H\u0005\t\u0011b)\u001a;dQB\u000b'\u000f^5uS>tG)\u0019;b!\ty\u0011*\u0003\u0002K!\t!QK\\5u\u0011\u0015a\u0005\u0001\"\u0001N\u0003\u0019a\u0014N\\5u}Q9aj\u0014)R%N#\u0006CA\u0005\u0001\u0011\u0015i1\n1\u0001\u000f\u0011\u001512\n1\u0001\u0018\u0011\u0015Y2\n1\u0001\u001d\u0011\u0015\u00013\n1\u0001\"\u0011\u0015)3\n1\u0001'\u0011\u0015!4\n1\u00016\u0011\u00151\u0006\u0001\"\u0011X\u0003-!(/_\"p[BdW\r^3\u0015\u0003a\u0003\"aD-\n\u0005i\u0003\"a\u0002\"p_2,\u0017M\u001c\u0005\u00069\u0002!\t%X\u0001\r_:,\u0005\u0010]5sCRLwN\u001c\u000b\u0002\u0011\")q\f\u0001C!;\u0006QqN\\\"p[BdW\r^3")
public class DelayedFetch
extends DelayedOperation {
    private final FetchMetadata fetchMetadata;
    private final ReplicaManager replicaManager;
    private final ReplicaQuota quota;
    private final IsolationLevel isolationLevel;
    private final Function1<Seq<Tuple2<TopicPartition, FetchPartitionData>>, BoxedUnit> responseCallback;

    @Override
    public boolean tryComplete() {
        boolean bl;
        Object object = new Object();
        try {
            IntRef accumulatedSize = IntRef.create((int)0);
            IntRef accumulatedThrottledSize = IntRef.create((int)0);
            this.fetchMetadata.fetchPartitionStatus().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                DelayedFetch.$anonfun$tryComplete$1(this, accumulatedSize, accumulatedThrottledSize, object, x0$1);
                return BoxedUnit.UNIT;
            });
            bl = accumulatedSize.elem >= this.fetchMetadata.fetchMinBytes() || accumulatedSize.elem + accumulatedThrottledSize.elem >= this.fetchMetadata.fetchMinBytes() && !this.quota.isQuotaExceeded() ? this.forceComplete() : false;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                bl = ex.value$mcZ$sp();
            }
            throw ex;
        }
        return bl;
    }

    @Override
    public void onExpiration() {
        if (this.fetchMetadata.isFromFollower()) {
            DelayedFetchMetrics$.MODULE$.followerExpiredRequestMeter().mark();
        } else {
            DelayedFetchMetrics$.MODULE$.consumerExpiredRequestMeter().mark();
        }
    }

    @Override
    public void onComplete() {
        Seq<Tuple2<TopicPartition, LogReadResult>> logReadResults = this.replicaManager.readFromLocalLog(this.fetchMetadata.replicaId(), this.fetchMetadata.fetchOnlyLeader(), this.fetchMetadata.fetchOnlyCommitted(), this.fetchMetadata.fetchMaxBytes(), this.fetchMetadata.hardMaxBytesLimit(), (Seq<Tuple2<TopicPartition, FetchRequest.PartitionData>>)((Seq)this.fetchMetadata.fetchPartitionStatus().map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition tp = (TopicPartition)tuple2._1();
            FetchPartitionStatus status = (FetchPartitionStatus)tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)status.fetchInfo());
            return tuple22;
        }, Seq$.MODULE$.canBuildFrom())), this.quota, this.isolationLevel);
        Seq fetchPartitionData = (Seq)logReadResults.map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition tp = (TopicPartition)tuple2._1();
            LogReadResult result = (LogReadResult)tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new FetchPartitionData(result.error(), result.highWatermark(), result.leaderLogStartOffset(), result.info().records(), result.lastStableOffset(), result.info().abortedTransactions()));
            return tuple22;
        }, Seq$.MODULE$.canBuildFrom());
        this.responseCallback.apply((Object)fetchPartitionData);
    }

    public static final /* synthetic */ void $anonfun$tryComplete$1(DelayedFetch $this, IntRef accumulatedSize$1, IntRef accumulatedThrottledSize$1, Object nonLocalReturnKey1$1, Tuple2 x0$1) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            TopicPartition topicPartition = (TopicPartition)tuple2._1();
            FetchPartitionStatus fetchStatus = (FetchPartitionStatus)tuple2._2();
            LogOffsetMetadata fetchOffset = fetchStatus.startOffsetMetadata();
            try {
                LogOffsetMetadata logOffsetMetadata = fetchOffset;
                LogOffsetMetadata logOffsetMetadata2 = LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata();
                if (logOffsetMetadata == null ? logOffsetMetadata2 != null : !((Object)logOffsetMetadata).equals(logOffsetMetadata2)) {
                    LogOffsetMetadata endOffset;
                    Replica replica = $this.replicaManager.getLeaderReplicaIfLocal(topicPartition);
                    IsolationLevel isolationLevel = $this.isolationLevel;
                    IsolationLevel isolationLevel2 = IsolationLevel.READ_COMMITTED;
                    LogOffsetMetadata logOffsetMetadata3 = !(isolationLevel != null ? !((Object)((Object)isolationLevel)).equals((Object)isolationLevel2) : isolationLevel2 != null) ? replica.lastStableOffset() : (endOffset = $this.fetchMetadata.fetchOnlyCommitted() ? replica.highWatermark() : replica.logEndOffset());
                    if (endOffset.messageOffset() != fetchOffset.messageOffset()) {
                        if (endOffset.onOlderSegment(fetchOffset)) {
                            $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Satisfying fetch %s since it is fetching later segments of partition %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.fetchMetadata, topicPartition})));
                            throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, $this.forceComplete());
                        }
                        if (fetchOffset.onOlderSegment(endOffset)) {
                            $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Satisfying fetch %s immediately since it is fetching older segments.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.fetchMetadata})));
                            if (!$this.replicaManager.shouldLeaderThrottle($this.quota, topicPartition, $this.fetchMetadata.replicaId())) {
                                throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, $this.forceComplete());
                            }
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        if (fetchOffset.messageOffset() < endOffset.messageOffset()) {
                            int bytesAvailable = package$.MODULE$.min(endOffset.positionDiff(fetchOffset), fetchStatus.fetchInfo().maxBytes);
                            if ($this.quota.isThrottled(topicPartition)) {
                                accumulatedThrottledSize$1.elem += bytesAvailable;
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            accumulatedSize$1.elem += bytesAvailable;
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    boxedUnit = BoxedUnit.UNIT;
                }
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (KafkaStorageException kafkaStorageException) {
                $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Partition %s is in an offline log directory, satisfy %s immediately")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition, $this.fetchMetadata})));
                throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, $this.forceComplete());
            }
            catch (UnknownTopicOrPartitionException unknownTopicOrPartitionException) {
                $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Broker no longer know of %s, satisfy %s immediately")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition, $this.fetchMetadata})));
                throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, $this.forceComplete());
            }
            catch (NotLeaderForPartitionException notLeaderForPartitionException) {
                $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Broker is no longer the leader of %s, satisfy %s immediately")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition, $this.fetchMetadata})));
                throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, $this.forceComplete());
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public DelayedFetch(long delayMs, FetchMetadata fetchMetadata, ReplicaManager replicaManager, ReplicaQuota quota, IsolationLevel isolationLevel, Function1<Seq<Tuple2<TopicPartition, FetchPartitionData>>, BoxedUnit> responseCallback) {
        this.fetchMetadata = fetchMetadata;
        this.replicaManager = replicaManager;
        this.quota = quota;
        this.isolationLevel = isolationLevel;
        this.responseCallback = responseCallback;
        super(delayMs, DelayedOperation$.MODULE$.$lessinit$greater$default$2());
    }
}

