/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.server;

import io.confluent.kafka.cluster.Partition;
import io.confluent.kafka.cluster.Replica;
import io.confluent.kafka.server.DelayedDeleteRecordsMetrics$;
import io.confluent.kafka.server.DelayedOperation;
import io.confluent.kafka.server.DelayedOperation$;
import io.confluent.kafka.server.DeleteRecordsPartitionStatus;
import io.confluent.kafka.server.ReplicaManager;
import io.confluent.kafka.server.ReplicaManager$;
import io.confluent.org.apache.kafka.common.TopicPartition;
import io.confluent.org.apache.kafka.common.protocol.Errors;
import io.confluent.org.apache.kafka.common.requests.DeleteRecordsResponse;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001Y3A!\u0001\u0002\u0001\u000f\t!B)\u001a7bs\u0016$G)\u001a7fi\u0016\u0014VmY8sINT!a\u0001\u0003\u0002\rM,'O^3s\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0003\u0001!\u0001\"!\u0003\u0006\u000e\u0003\tI!a\u0003\u0002\u0003!\u0011+G.Y=fI>\u0003XM]1uS>t\u0007\"C\u0007\u0001\u0005\u0003\u0005\u000b\u0011\u0002\b\u0015\u0003\u001d!W\r\\1z\u001bN\u0004\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\u0006g\u000e\fG.Y\u0005\u0003'A\u0011A\u0001T8oO&\u0011QB\u0003\u0005\t-\u0001\u0011\t\u0011)A\u0005/\u0005\u0019B-\u001a7fi\u0016\u0014VmY8sIN\u001cF/\u0019;vgB!\u0001dG\u000f)\u001b\u0005I\"B\u0001\u000e\u0011\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u00039e\u00111!T1q!\tqb%D\u0001 \u0015\t\u0001\u0013%\u0001\u0004d_6lwN\u001c\u0006\u0003\u000b\tR!a\t\u0013\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005)\u0013aA8sO&\u0011qe\b\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o!\tI\u0011&\u0003\u0002+\u0005\taB)\u001a7fi\u0016\u0014VmY8sIN\u0004\u0016M\u001d;ji&|gn\u0015;biV\u001c\b\u0002\u0003\u0017\u0001\u0005\u0003\u0005\u000b\u0011B\u0017\u0002\u001dI,\u0007\u000f\\5dC6\u000bg.Y4feB\u0011\u0011BL\u0005\u0003_\t\u0011aBU3qY&\u001c\u0017-T1oC\u001e,'\u000f\u0003\u00052\u0001\t\u0005\t\u0015!\u00033\u0003A\u0011Xm\u001d9p]N,7)\u00197mE\u0006\u001c7\u000e\u0005\u0003\u0010gU\u0002\u0015B\u0001\u001b\u0011\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0003\u00197u1\u0004CA\u001c>\u001d\tA4(D\u0001:\u0015\tQt$\u0001\u0005sKF,Xm\u001d;t\u0013\ta\u0014(A\u000bEK2,G/\u001a*fG>\u0014Hm\u001d*fgB|gn]3\n\u0005yz$!\u0005)beRLG/[8o%\u0016\u001c\bo\u001c8tK*\u0011A(\u000f\t\u0003\u001f\u0005K!A\u0011\t\u0003\tUs\u0017\u000e\u001e\u0005\u0006\t\u0002!\t!R\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b\u0019;\u0005*\u0013&\u0011\u0005%\u0001\u0001\"B\u0007D\u0001\u0004q\u0001\"\u0002\fD\u0001\u00049\u0002\"\u0002\u0017D\u0001\u0004i\u0003\"B\u0019D\u0001\u0004\u0011\u0004\"\u0002'\u0001\t\u0003j\u0015a\u0003;ss\u000e{W\u000e\u001d7fi\u0016$\u0012A\u0014\t\u0003\u001f=K!\u0001\u0015\t\u0003\u000f\t{w\u000e\\3b]\")!\u000b\u0001C!'\u0006aqN\\#ya&\u0014\u0018\r^5p]R\t\u0001\tC\u0003V\u0001\u0011\u00053+\u0001\u0006p]\u000e{W\u000e\u001d7fi\u0016\u0004")
public class DelayedDeleteRecords
extends DelayedOperation {
    private final Map<TopicPartition, DeleteRecordsPartitionStatus> deleteRecordsStatus;
    private final ReplicaManager replicaManager;
    private final Function1<Map<TopicPartition, DeleteRecordsResponse.PartitionResponse>, BoxedUnit> responseCallback;

    @Override
    public boolean tryComplete() {
        this.deleteRecordsStatus.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            DelayedDeleteRecords.$anonfun$tryComplete$1(this, x0$2);
            return BoxedUnit.UNIT;
        });
        return !this.deleteRecordsStatus.values().exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.acksPending())) ? this.forceComplete() : false;
    }

    @Override
    public void onExpiration() {
        this.deleteRecordsStatus.foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
            DelayedDeleteRecords.$anonfun$onExpiration$1(x0$3);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void onComplete() {
        Map responseStatus = this.deleteRecordsStatus.mapValues((Function1 & Serializable & scala.Serializable)status -> status.responseStatus());
        this.responseCallback.apply((Object)responseStatus);
    }

    public static final /* synthetic */ void $anonfun$new$1(DelayedDeleteRecords $this, Tuple2 x0$1) {
        DeleteRecordsPartitionStatus status;
        TopicPartition topicPartition;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            topicPartition = (TopicPartition)tuple2._1();
            status = (DeleteRecordsPartitionStatus)tuple2._2();
            Errors errors = status.responseStatus().error;
            Errors errors2 = Errors.NONE;
            if (!(errors != null ? !((Object)((Object)errors)).equals((Object)errors2) : errors2 != null)) {
                status.acksPending_$eq(true);
                status.responseStatus().error = Errors.REQUEST_TIMED_OUT;
            } else {
                status.acksPending_$eq(false);
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        $this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Initial partition status for %s is %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition, status})));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$tryComplete$1(DelayedDeleteRecords $this, Tuple2 x0$2) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            TopicPartition topicPartition = (TopicPartition)tuple2._1();
            DeleteRecordsPartitionStatus status = (DeleteRecordsPartitionStatus)tuple2._2();
            $this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Checking delete records satisfaction for ", ", current status ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition, status})));
            if (status.acksPending()) {
                Tuple3 tuple3;
                Option<Partition> option = $this.replicaManager.getPartition(topicPartition);
                if (option instanceof Some) {
                    Tuple3 tuple32;
                    Some some = (Some)option;
                    Partition partition = (Partition)some.value();
                    if (partition == ReplicaManager$.MODULE$.OfflinePartition()) {
                        tuple32 = new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)Errors.KAFKA_STORAGE_ERROR, (Object)BoxesRunTime.boxToLong((long)-1L));
                    } else {
                        Tuple3 tuple33;
                        Option<Replica> option2 = partition.leaderReplicaIfLocal();
                        if (option2 instanceof Some) {
                            long leaderLW = partition.lowWatermarkIfLeader();
                            tuple33 = new Tuple3((Object)BoxesRunTime.boxToBoolean((leaderLW >= status.requiredOffset() ? 1 : 0) != 0), (Object)Errors.NONE, (Object)BoxesRunTime.boxToLong((long)leaderLW));
                        } else if (None$.MODULE$.equals(option2)) {
                            tuple33 = new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)Errors.NOT_LEADER_FOR_PARTITION, (Object)BoxesRunTime.boxToLong((long)-1L));
                        } else {
                            throw new MatchError(option2);
                        }
                        tuple32 = tuple33;
                    }
                    tuple3 = tuple32;
                } else if (None$.MODULE$.equals(option)) {
                    tuple3 = new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)Errors.UNKNOWN_TOPIC_OR_PARTITION, (Object)BoxesRunTime.boxToLong((long)-1L));
                } else {
                    throw new MatchError(option);
                }
                Tuple3 tuple34 = tuple3;
                if (tuple34 == null) {
                    throw new MatchError((Object)tuple34);
                }
                boolean lowWatermarkReached = BoxesRunTime.unboxToBoolean((Object)tuple34._1());
                Errors error = (Errors)((Object)tuple34._2());
                long lw = BoxesRunTime.unboxToLong((Object)tuple34._3());
                Tuple3 tuple35 = new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)lowWatermarkReached), (Object)error, (Object)BoxesRunTime.boxToLong((long)lw));
                Tuple3 tuple36 = tuple35;
                boolean lowWatermarkReached2 = BoxesRunTime.unboxToBoolean((Object)tuple36._1());
                Errors error2 = (Errors)((Object)tuple36._2());
                long lw2 = BoxesRunTime.unboxToLong((Object)tuple36._3());
                Errors errors = error2;
                Errors errors2 = Errors.NONE;
                if ((errors != null ? !((Object)((Object)errors)).equals((Object)errors2) : errors2 != null) || lowWatermarkReached2) {
                    status.acksPending_$eq(false);
                    status.responseStatus().error = error2;
                    status.responseStatus().lowWatermark = lw2;
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ void $anonfun$onExpiration$1(Tuple2 x0$3) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$3;
        if (tuple2 != null) {
            TopicPartition topicPartition = (TopicPartition)tuple2._1();
            DeleteRecordsPartitionStatus status = (DeleteRecordsPartitionStatus)tuple2._2();
            if (status.acksPending()) {
                DelayedDeleteRecordsMetrics$.MODULE$.recordExpiration(topicPartition);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public DelayedDeleteRecords(long delayMs, Map<TopicPartition, DeleteRecordsPartitionStatus> deleteRecordsStatus, ReplicaManager replicaManager, Function1<Map<TopicPartition, DeleteRecordsResponse.PartitionResponse>, BoxedUnit> responseCallback) {
        this.deleteRecordsStatus = deleteRecordsStatus;
        this.replicaManager = replicaManager;
        this.responseCallback = responseCallback;
        super(delayMs, DelayedOperation$.MODULE$.$lessinit$greater$default$2());
        deleteRecordsStatus.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            DelayedDeleteRecords.$anonfun$new$1(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }
}

