/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.security.auth;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.Logger$;
import io.confluent.kafka.common.ZkNodeChangeNotificationListener;
import io.confluent.kafka.common.ZkNodeChangeNotificationListener$;
import io.confluent.kafka.network.RequestChannel;
import io.confluent.kafka.security.auth.Acl;
import io.confluent.kafka.security.auth.Acl$;
import io.confluent.kafka.security.auth.All$;
import io.confluent.kafka.security.auth.Allow$;
import io.confluent.kafka.security.auth.Alter$;
import io.confluent.kafka.security.auth.AlterConfigs$;
import io.confluent.kafka.security.auth.Authorizer;
import io.confluent.kafka.security.auth.Delete$;
import io.confluent.kafka.security.auth.Deny$;
import io.confluent.kafka.security.auth.Describe$;
import io.confluent.kafka.security.auth.DescribeConfigs$;
import io.confluent.kafka.security.auth.Operation;
import io.confluent.kafka.security.auth.PermissionType;
import io.confluent.kafka.security.auth.Read$;
import io.confluent.kafka.security.auth.Resource;
import io.confluent.kafka.security.auth.Resource$;
import io.confluent.kafka.security.auth.ResourceType;
import io.confluent.kafka.security.auth.ResourceType$;
import io.confluent.kafka.security.auth.SimpleAclAuthorizer$;
import io.confluent.kafka.security.auth.SimpleAclAuthorizer$AclChangedNotificationHandler$;
import io.confluent.kafka.security.auth.Write$;
import io.confluent.kafka.server.KafkaConfig;
import io.confluent.kafka.server.KafkaConfig$;
import io.confluent.kafka.utils.CoreUtils$;
import io.confluent.kafka.utils.Logging;
import io.confluent.kafka.zk.AclChangeNotificationSequenceZNode$;
import io.confluent.kafka.zk.AclChangeNotificationZNode$;
import io.confluent.kafka.zk.KafkaZkClient;
import io.confluent.kafka.zk.KafkaZkClient$;
import io.confluent.org.apache.kafka.common.security.auth.KafkaPrincipal;
import io.confluent.org.apache.kafka.common.utils.SecurityUtils;
import io.confluent.org.apache.kafka.common.utils.Time;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\rux!B\u0001\u0003\u0011\u0003I\u0011aE*j[BdW-Q2m\u0003V$\bn\u001c:ju\u0016\u0014(BA\u0002\u0005\u0003\u0011\tW\u000f\u001e5\u000b\u0005\u00151\u0011\u0001C:fGV\u0014\u0018\u000e^=\u000b\u0003\u001d\tQa[1gW\u0006\u001c\u0001\u0001\u0005\u0002\u000b\u00175\t!AB\u0003\r\u0005!\u0005QBA\nTS6\u0004H.Z!dY\u0006+H\u000f[8sSj,'o\u0005\u0002\f\u001dA\u0011qBE\u0007\u0002!)\t\u0011#A\u0003tG\u0006d\u0017-\u0003\u0002\u0014!\t1\u0011I\\=SK\u001aDQ!F\u0006\u0005\u0002Y\ta\u0001P5oSRtD#A\u0005\t\u000faY!\u0019!C\u00013\u0005I!l[+sYB\u0013x\u000e]\u000b\u00025A\u00111\u0004I\u0007\u00029)\u0011QDH\u0001\u0005Y\u0006twMC\u0001 \u0003\u0011Q\u0017M^1\n\u0005\u0005b\"AB*ue&tw\r\u0003\u0004$\u0017\u0001\u0006IAG\u0001\u000b5.,&\u000f\u001c)s_B\u0004\u0003bB\u0013\f\u0005\u0004%\t!G\u0001\u00185.\u001cuN\u001c8fGRLwN\u001c+j[\u0016|U\u000f\u001e)s_BDaaJ\u0006!\u0002\u0013Q\u0012\u0001\u0007.l\u0007>tg.Z2uS>tG+[7f\u001fV$\bK]8qA!9\u0011f\u0003b\u0001\n\u0003I\u0012\u0001\u0006.l'\u0016\u001c8/[8o)&lWmT;u!J|\u0007\u000f\u0003\u0004,\u0017\u0001\u0006IAG\u0001\u00165.\u001cVm]:j_:$\u0016.\\3PkR\u0004&o\u001c9!\u0011\u001di3B1A\u0005\u0002e\tQCW6NCbLeN\u00127jO\"$(+Z9vKN$8\u000f\u0003\u00040\u0017\u0001\u0006IAG\u0001\u00175.l\u0015\r_%o\r2Lw\r\u001b;SKF,Xm\u001d;tA!9\u0011g\u0003b\u0001\n\u0003I\u0012AD*va\u0016\u0014Xk]3sgB\u0013x\u000e\u001d\u0005\u0007g-\u0001\u000b\u0011\u0002\u000e\u0002\u001fM+\b/\u001a:Vg\u0016\u00148\u000f\u0015:pa\u0002Bq!N\u0006C\u0002\u0013\u0005\u0011$A\u0010BY2|w/\u0012<fef|g.Z%g\u001d>\f5\r\\%t\r>,h\u000e\u001a)s_BDaaN\u0006!\u0002\u0013Q\u0012\u0001I!mY><XI^3ss>tW-\u00134O_\u0006\u001bG.S:G_VtG\r\u0015:pa\u00022A!O\u0006Au\tia+\u001a:tS>tW\rZ!dYN\u001cB\u0001\u000f\b<}A\u0011q\u0002P\u0005\u0003{A\u0011q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002\u0010\u007f%\u0011\u0001\t\u0005\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\t\u0005b\u0012)\u001a!C\u0001\u0007\u0006!\u0011m\u00197t+\u0005!\u0005cA#M\u001f:\u0011aI\u0013\t\u0003\u000fBi\u0011\u0001\u0013\u0006\u0003\u0013\"\ta\u0001\u0010:p_Rt\u0014BA&\u0011\u0003\u0019\u0001&/\u001a3fM&\u0011QJ\u0014\u0002\u0004'\u0016$(BA&\u0011!\tQ\u0001+\u0003\u0002R\u0005\t\u0019\u0011i\u00197\t\u0011MC$\u0011#Q\u0001\n\u0011\u000bQ!Y2mg\u0002B\u0001\"\u0016\u001d\u0003\u0016\u0004%\tAV\u0001\nu.4VM]:j_:,\u0012a\u0016\t\u0003\u001faK!!\u0017\t\u0003\u0007%sG\u000f\u0003\u0005\\q\tE\t\u0015!\u0003X\u0003)Q8NV3sg&|g\u000e\t\u0005\u0006+a\"\t!\u0018\u000b\u0004=\u0002\f\u0007CA09\u001b\u0005Y\u0001\"\u0002\"]\u0001\u0004!\u0005\"B+]\u0001\u00049\u0006bB29\u0003\u0003%\t\u0001Z\u0001\u0005G>\u0004\u0018\u0010F\u0002_K\u001aDqA\u00112\u0011\u0002\u0003\u0007A\tC\u0004VEB\u0005\t\u0019A,\t\u000f!D\u0014\u0013!C\u0001S\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nT#\u00016+\u0005\u0011[7&\u00017\u0011\u00055\u0014X\"\u00018\u000b\u0005=\u0004\u0018!C;oG\",7m[3e\u0015\t\t\b#\u0001\u0006b]:|G/\u0019;j_:L!a\u001d8\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0004vqE\u0005I\u0011\u0001<\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\tqO\u000b\u0002XW\"9\u0011\u0010OA\u0001\n\u0003J\u0012!\u00049s_\u0012,8\r\u001e)sK\u001aL\u0007\u0010C\u0004|q\u0005\u0005I\u0011\u0001,\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\t\u000fuD\u0014\u0011!C\u0001}\u0006q\u0001O]8ek\u000e$X\t\\3nK:$HcA@\u0002\u0006A\u0019q\"!\u0001\n\u0007\u0005\r\u0001CA\u0002B]fD\u0001\"a\u0002}\u0003\u0003\u0005\raV\u0001\u0004q\u0012\n\u0004\"CA\u0006q\u0005\u0005I\u0011IA\u0007\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA\b!\u0015\t\t\"a\u0006\u0000\u001b\t\t\u0019BC\u0002\u0002\u0016A\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\tI\"a\u0005\u0003\u0011%#XM]1u_JD\u0011\"!\b9\u0003\u0003%\t!a\b\u0002\u0011\r\fg.R9vC2$B!!\t\u0002(A\u0019q\"a\t\n\u0007\u0005\u0015\u0002CA\u0004C_>dW-\u00198\t\u0013\u0005\u001d\u00111DA\u0001\u0002\u0004y\b\"CA\u0016q\u0005\u0005I\u0011IA\u0017\u0003!A\u0017m\u001d5D_\u0012,G#A,\t\u0013\u0005E\u0002(!A\u0005B\u0005M\u0012\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003iA\u0011\"a\u000e9\u0003\u0003%\t%!\u000f\u0002\r\u0015\fX/\u00197t)\u0011\t\t#a\u000f\t\u0013\u0005\u001d\u0011QGA\u0001\u0002\u0004yx!CA \u0017\u0005\u0005\t\u0012AA!\u000351VM]:j_:,G-Q2mgB\u0019q,a\u0011\u0007\u0011eZ\u0011\u0011!E\u0001\u0003\u000b\u001aR!a\u0011\u0002Hy\u0002r!!\u0013\u0002P\u0011;f,\u0004\u0002\u0002L)\u0019\u0011Q\n\t\u0002\u000fI,h\u000e^5nK&!\u0011\u0011KA&\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\u0005\b+\u0005\rC\u0011AA+)\t\t\t\u0005\u0003\u0006\u00022\u0005\r\u0013\u0011!C#\u0003gA!\"a\u0017\u0002D\u0005\u0005I\u0011QA/\u0003\u0015\t\u0007\u000f\u001d7z)\u0015q\u0016qLA1\u0011\u0019\u0011\u0015\u0011\fa\u0001\t\"1Q+!\u0017A\u0002]C!\"!\u001a\u0002D\u0005\u0005I\u0011QA4\u0003\u001d)h.\u00199qYf$B!!\u001b\u0002vA)q\"a\u001b\u0002p%\u0019\u0011Q\u000e\t\u0003\r=\u0003H/[8o!\u0015y\u0011\u0011\u000f#X\u0013\r\t\u0019\b\u0005\u0002\u0007)V\u0004H.\u001a\u001a\t\u0013\u0005]\u00141MA\u0001\u0002\u0004q\u0016a\u0001=%a!Q\u00111PA\"\u0003\u0003%I!! \u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003\u007f\u00022aGAA\u0013\r\t\u0019\t\b\u0002\u0007\u001f\nTWm\u0019;\u0007\u000b1\u0011\u0001!a\"\u0014\u0011\u0005\u0015\u0015qPAE\u0003\u001f\u00032ACAF\u0013\r\tiI\u0001\u0002\u000b\u0003V$\bn\u001c:ju\u0016\u0014\b\u0003BAI\u0003/k!!a%\u000b\u0007\u0005Ue!A\u0003vi&d7/\u0003\u0003\u0002\u001a\u0006M%a\u0002'pO\u001eLgn\u001a\u0005\b+\u0005\u0015E\u0011AAO)\t\ty\nE\u0002\u000b\u0003\u000bC!\"a)\u0002\u0006\n\u0007I\u0011BAS\u0003A\tW\u000f\u001e5pe&TXM\u001d'pO\u001e,'/\u0006\u0002\u0002(B!\u0011\u0011VA\\\u001b\t\tYK\u0003\u0003\u0002.\u0006=\u0016\u0001D:dC2\fGn\\4hS:<'\u0002BAY\u0003g\u000b\u0001\u0002^=qKN\fg-\u001a\u0006\u0003\u0003k\u000b1aY8n\u0013\u0011\tI,a+\u0003\r1{wmZ3s\u0011%\ti,!\"!\u0002\u0013\t9+A\tbkRDwN]5{KJdunZ4fe\u0002B!\"!1\u0002\u0006\u0002\u0007I\u0011BAb\u0003)\u0019X\u000f]3s+N,'o]\u000b\u0003\u0003\u000b\u0004b!a2\u0002N\u0006=WBAAe\u0015\u0011\tY-a\u0005\u0002\u0013%lW.\u001e;bE2,\u0017bA'\u0002JB!\u0011\u0011[As\u001b\t\t\u0019NC\u0002\u0004\u0003+T1!BAl\u0015\u0011\tI.a7\u0002\r\r|W.\\8o\u0015\r9\u0011Q\u001c\u0006\u0005\u0003?\f\t/\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003G\f1a\u001c:h\u0013\u0011\t9/a5\u0003\u001d-\u000bgm[1Qe&t7-\u001b9bY\"Q\u00111^AC\u0001\u0004%I!!<\u0002\u001dM,\b/\u001a:Vg\u0016\u00148o\u0018\u0013fcR!\u0011q^A{!\ry\u0011\u0011_\u0005\u0004\u0003g\u0004\"\u0001B+oSRD!\"a\u0002\u0002j\u0006\u0005\t\u0019AAc\u0011%\tI0!\"!B\u0013\t)-A\u0006tkB,'/V:feN\u0004\u0003BCA\u007f\u0003\u000b\u0003\r\u0011\"\u0003\u0002\u0000\u0006\t3\u000f[8vY\u0012\fE\u000e\\8x\u000bZ,'/_8oK&3gj\\!dY&\u001bhi\\;oIV\u0011\u0011\u0011\u0005\u0005\u000b\u0005\u0007\t)\t1A\u0005\n\t\u0015\u0011!J:i_VdG-\u00117m_^,e/\u001a:z_:,\u0017J\u001a(p\u0003\u000ed\u0017j\u001d$pk:$w\fJ3r)\u0011\tyOa\u0002\t\u0015\u0005\u001d!\u0011AA\u0001\u0002\u0004\t\t\u0003C\u0005\u0003\f\u0005\u0015\u0005\u0015)\u0003\u0002\"\u0005\u00113\u000f[8vY\u0012\fE\u000e\\8x\u000bZ,'/_8oK&3gj\\!dY&\u001bhi\\;oI\u0002B!Ba\u0004\u0002\u0006\u0002\u0007I\u0011\u0002B\t\u0003!Q8n\u00117jK:$XC\u0001B\n!\u0011\u0011)Ba\u0007\u000e\u0005\t]!b\u0001B\r\r\u0005\u0011!p[\u0005\u0005\u0005;\u00119BA\u0007LC\u001a\\\u0017MW6DY&,g\u000e\u001e\u0005\u000b\u0005C\t)\t1A\u0005\n\t\r\u0012\u0001\u0004>l\u00072LWM\u001c;`I\u0015\fH\u0003BAx\u0005KA!\"a\u0002\u0003 \u0005\u0005\t\u0019\u0001B\n\u0011%\u0011I#!\"!B\u0013\u0011\u0019\"A\u0005{W\u000ec\u0017.\u001a8uA!Q!QFAC\u0001\u0004%IAa\f\u0002#\u0005\u001cGn\u00115b]\u001e,G*[:uK:,'/\u0006\u0002\u00032A!!1\u0007B\u001c\u001b\t\u0011)DC\u0002\u0002Z\u001aIAA!\u000f\u00036\t\u0001#l\u001b(pI\u0016\u001c\u0005.\u00198hK:{G/\u001b4jG\u0006$\u0018n\u001c8MSN$XM\\3s\u0011)\u0011i$!\"A\u0002\u0013%!qH\u0001\u0016C\u000ed7\t[1oO\u0016d\u0015n\u001d;f]\u0016\u0014x\fJ3r)\u0011\tyO!\u0011\t\u0015\u0005\u001d!1HA\u0001\u0002\u0004\u0011\t\u0004C\u0005\u0003F\u0005\u0015\u0005\u0015)\u0003\u00032\u0005\u0011\u0012m\u00197DQ\u0006tw-\u001a'jgR,g.\u001a:!\u0011)\u0011I%!\"C\u0002\u0013%!1J\u0001\tC\u000ed7)Y2iKV\u0011!Q\n\t\t\u0005\u001f\u0012)F!\u0017\u0003`5\u0011!\u0011\u000b\u0006\u0005\u0005'\n\u0019\"A\u0004nkR\f'\r\\3\n\t\t]#\u0011\u000b\u0002\b\u0011\u0006\u001c\b.T1q!\rQ!1L\u0005\u0004\u0005;\u0012!\u0001\u0003*fg>,(oY3\u0011\u0007\t\u0005\u0004HD\u0002\u0003d\u0001qAA!\u001a\u0003n9!!q\rB6\u001d\r9%\u0011N\u0005\u0002\u000f%\u0011QAB\u0005\u0003\u0007\u0011A\u0011B!\u001d\u0002\u0006\u0002\u0006IA!\u0014\u0002\u0013\u0005\u001cGnQ1dQ\u0016\u0004\u0003B\u0003B;\u0003\u000b\u0013\r\u0011\"\u0003\u0003x\u0005!An\\2l+\t\u0011I\b\u0005\u0003\u0003|\t%UB\u0001B?\u0015\u0011\u0011yH!!\u0002\u000b1|7m[:\u000b\t\t\r%QQ\u0001\u000bG>t7-\u001e:sK:$(b\u0001BD=\u0005!Q\u000f^5m\u0013\u0011\u0011YI! \u0003-I+WM\u001c;sC:$(+Z1e/JLG/\u001a'pG.D\u0011Ba$\u0002\u0006\u0002\u0006IA!\u001f\u0002\u000b1|7m\u001b\u0011\t\u0015\tM\u0015Q\u0011a\u0001\n#\u0011a+\u0001\tnCb,\u0006\u000fZ1uKJ+GO]5fg\"Y!qSAC\u0001\u0004%\tB\u0001BM\u0003Qi\u0017\r_+qI\u0006$XMU3ue&,7o\u0018\u0013fcR!\u0011q\u001eBN\u0011%\t9A!&\u0002\u0002\u0003\u0007q\u000b\u0003\u0005\u0003 \u0006\u0015\u0005\u0015)\u0003X\u0003Ei\u0017\r_+qI\u0006$XMU3ue&,7\u000f\t\u0005\n\u0005G\u000b)I1A\u0005\nY\u000baB]3uef\u0014\u0015mY6pM\u001al5\u000f\u0003\u0005\u0003(\u0006\u0015\u0005\u0015!\u0003X\u0003=\u0011X\r\u001e:z\u0005\u0006\u001c7n\u001c4g\u001bN\u0004\u0003\"\u0003BV\u0003\u000b\u0013\r\u0011\"\u0003W\u0003Q\u0011X\r\u001e:z\u0005\u0006\u001c7n\u001c4g\u0015&$H/\u001a:Ng\"A!qVACA\u0003%q+A\u000bsKR\u0014\u0018PQ1dW>4gMS5ui\u0016\u0014Xj\u001d\u0011\t\u0011\tM\u0016Q\u0011C!\u0005k\u000b\u0011bY8oM&<WO]3\u0015\t\u0005=(q\u0017\u0005\t\u0005s\u0013\t\f1\u0001\u0003<\u0006Y!.\u0019<b\u0007>tg-[4ta\u0011\u0011iL!4\u0011\u0011\t}&\u0011\u0019Bc\u0005\u0013l!A!\"\n\t\t\r'Q\u0011\u0002\u0004\u001b\u0006\u0004\bcA#\u0003H&\u0011\u0011E\u0014\t\u0005\u0005\u0017\u0014i\r\u0004\u0001\u0005\u0019\t='qWA\u0001\u0002\u0003\u0015\tA!5\u0003\u0007}#\u0013'E\u0002\u0003T~\u00042a\u0004Bk\u0013\r\u00119\u000e\u0005\u0002\b\u001d>$\b.\u001b8h\u0011!\u0011Y.!\"\u0005B\tu\u0017!C1vi\"|'/\u001b>f)!\t\tCa8\u0003z\u000e\r\u0001\u0002\u0003Bq\u00053\u0004\rAa9\u0002\u000fM,7o]5p]B!!Q\u001dBz\u001d\u0011\u00119O!<\u000f\t\t\u001d$\u0011^\u0005\u0004\u0005W4\u0011a\u00028fi^|'o[\u0005\u0005\u0005_\u0014\t0\u0001\bSKF,Xm\u001d;DQ\u0006tg.\u001a7\u000b\u0007\t-h!\u0003\u0003\u0003v\n](aB*fgNLwN\u001c\u0006\u0005\u0005_\u0014\t\u0010\u0003\u0005\u0003|\ne\u0007\u0019\u0001B\u007f\u0003%y\u0007/\u001a:bi&|g\u000eE\u0002\u000b\u0005\u007fL1a!\u0001\u0003\u0005%y\u0005/\u001a:bi&|g\u000e\u0003\u0005\u0004\u0006\te\u0007\u0019\u0001B-\u0003!\u0011Xm]8ve\u000e,\u0007\u0002CB\u0005\u0003\u000b#\taa\u0003\u0002/%\u001cX)\u001c9us\u0006\u001bG.\u00118e\u0003V$\bn\u001c:ju\u0016$G\u0003DA\u0011\u0007\u001b\u0019ya!\u0005\u0004\u0016\re\u0001\u0002\u0003B~\u0007\u000f\u0001\rA!@\t\u0011\r\u00151q\u0001a\u0001\u00053B\u0001ba\u0005\u0004\b\u0001\u0007\u0011qZ\u0001\naJLgnY5qC2D\u0001ba\u0006\u0004\b\u0001\u0007!QY\u0001\u0005Q>\u001cH\u000f\u0003\u0004C\u0007\u000f\u0001\r\u0001\u0012\u0005\t\u0007;\t)\t\"\u0001\u0004 \u0005Y\u0011n]*va\u0016\u0014Xk]3s))\t\tc!\t\u0004$\r\u00152q\u0005\u0005\t\u0005w\u001cY\u00021\u0001\u0003~\"A1QAB\u000e\u0001\u0004\u0011I\u0006\u0003\u0005\u0004\u0014\rm\u0001\u0019AAh\u0011!\u00199ba\u0007A\u0002\t\u0015\u0007\u0002CB\u0016\u0003\u000b#Ia!\f\u0002\u0011\u0005\u001cG.T1uG\"$b\"!\t\u00040\rM2QGB\u001c\u0007s\u0019\u0019\u0005\u0003\u0005\u00042\r%\u0002\u0019\u0001B\u007f\u0003)y\u0007/\u001a:bi&|gn\u001d\u0005\t\u0007\u000b\u0019I\u00031\u0001\u0003Z!A11CB\u0015\u0001\u0004\ty\r\u0003\u0005\u0004\u0018\r%\u0002\u0019\u0001Bc\u0011!\u0019Yd!\u000bA\u0002\ru\u0012A\u00049fe6L7o]5p]RK\b/\u001a\t\u0004\u0015\r}\u0012bAB!\u0005\tq\u0001+\u001a:nSN\u001c\u0018n\u001c8UsB,\u0007B\u0002\"\u0004*\u0001\u0007A\t\u0003\u0005\u0004H\u0005\u0015E\u0011IB%\u0003\u001d\tG\rZ!dYN$b!a<\u0004L\r5\u0003B\u0002\"\u0004F\u0001\u0007A\t\u0003\u0005\u0004\u0006\r\u0015\u0003\u0019\u0001B-\u0011!\u0019\t&!\"\u0005B\rM\u0013A\u0003:f[>4X-Q2mgR1\u0011\u0011EB+\u00073Bqaa\u0016\u0004P\u0001\u0007A)A\bbG2\u001cHk\u001c2f%\u0016lwN^3e\u0011!\u0019)aa\u0014A\u0002\te\u0003\u0002CB)\u0003\u000b#\te!\u0018\u0015\t\u0005\u00052q\f\u0005\t\u0007\u000b\u0019Y\u00061\u0001\u0003Z!A11MAC\t\u0003\u001a)'A\u0004hKR\f5\r\\:\u0015\u0007\u0011\u001b9\u0007\u0003\u0005\u0004\u0006\r\u0005\u0004\u0019\u0001B-\u0011!\u0019\u0019'!\"\u0005B\r-D\u0003BB7\u0007c\u0002b!RB8\u00053\"\u0015b\u0001Bb\u001d\"A11CB5\u0001\u0004\ty\r\u0003\u0005\u0004d\u0005\u0015E\u0011IB;)\t\u0019i\u0007\u0003\u0005\u0004z\u0005\u0015E\u0011AB>\u0003\u0015\u0019Gn\\:f)\t\ty\u000f\u0003\u0005\u0004\u0000\u0005\u0015E\u0011BB>\u0003%aw.\u00193DC\u000eDW\r\u0003\u0005\u0004\u0004\u0006\u0015E\u0011BBC\u0003=awnZ!vI&$X*Z:tC\u001e,G\u0003DAx\u0007\u000f\u001bIi!$\u0004\u0010\u000eE\u0005\u0002CB\n\u0007\u0003\u0003\r!a4\t\u0011\r-5\u0011\u0011a\u0001\u0003C\t!\"Y;uQ>\u0014\u0018N_3e\u0011!\u0011Yp!!A\u0002\tu\b\u0002CB\u0003\u0007\u0003\u0003\rA!\u0017\t\u0011\r]1\u0011\u0011a\u0001\u0005\u000bD\u0001b!&\u0002\u0006\u0012%1qS\u0001\u0013kB$\u0017\r^3SKN|WO]2f\u0003\u000ed7\u000f\u0006\u0003\u0004\u001a\u000e\u0015F\u0003BA\u0011\u00077C\u0001b!(\u0004\u0014\u0002\u00071qT\u0001\u000bO\u0016$h*Z<BG2\u001c\b#B\b\u0004\"\u0012#\u0015bABR!\tIa)\u001e8di&|g.\r\u0005\t\u0007\u000b\u0019\u0019\n1\u0001\u0003Z!A1\u0011VAC\t\u0013\u0019Y+\u0001\thKR\f5\r\\:Ge>l7)Y2iKR!!qLBW\u0011!\u0019)aa*A\u0002\te\u0003\u0002CBY\u0003\u000b#Iaa-\u0002\u001b\u001d,G/Q2mg\u001a\u0013x.\u001c.l)\u0011\u0011yf!.\t\u0011\r\u00151q\u0016a\u0001\u00053B\u0001b!/\u0002\u0006\u0012%11X\u0001\fkB$\u0017\r^3DC\u000eDW\r\u0006\u0004\u0002p\u000eu6q\u0018\u0005\t\u0007\u000b\u00199\f1\u0001\u0003Z!A1\u0011YB\\\u0001\u0004\u0011y&A\u0007wKJ\u001c\u0018n\u001c8fI\u0006\u001bGn\u001d\u0005\t\u0007\u000b\f)\t\"\u0003\u0004H\u0006!R\u000f\u001d3bi\u0016\f5\r\\\"iC:<W\r\u001a$mC\u001e$B!a<\u0004J\"A1QABb\u0001\u0004\u0011I\u0006C\u0004\u0004N\u0006\u0015E\u0011\u0002,\u0002\u0017\t\f7m[8gMRKW.Z\u0004\t\u0007#\f)\t#\u0001\u0004T\u0006i\u0012i\u00197DQ\u0006tw-\u001a3O_RLg-[2bi&|g\u000eS1oI2,'\u000f\u0005\u0003\u0004V\u000e]WBAAC\r!\u0019I.!\"\t\u0002\rm'!H!dY\u000eC\u0017M\\4fI:{G/\u001b4jG\u0006$\u0018n\u001c8IC:$G.\u001a:\u0014\u000b\r]gb!8\u0011\t\tM2q\\\u0005\u0005\u0007C\u0014)DA\nO_RLg-[2bi&|g\u000eS1oI2,'\u000fC\u0004\u0016\u0007/$\ta!:\u0015\u0005\rM\u0007\u0002CBu\u0007/$\tea;\u0002'A\u0014xnY3tg:{G/\u001b4jG\u0006$\u0018n\u001c8\u0015\t\u0005=8Q\u001e\u0005\t\u0007_\u001c9\u000f1\u0001\u0004r\u0006\u0019bn\u001c;jM&\u001c\u0017\r^5p]6+7o]1hKB)qba=\u0004x&\u00191Q\u001f\t\u0003\u000b\u0005\u0013(/Y=\u0011\u0007=\u0019I0C\u0002\u0004|B\u0011AAQ=uK\u0002")
public class SimpleAclAuthorizer
implements Authorizer,
Logging {
    private volatile SimpleAclAuthorizer$AclChangedNotificationHandler$ AclChangedNotificationHandler$module;
    private final Logger authorizerLogger;
    private Set<KafkaPrincipal> superUsers;
    private boolean shouldAllowEveryoneIfNoAclIsFound;
    private KafkaZkClient zkClient;
    private ZkNodeChangeNotificationListener aclChangeListener;
    private final HashMap<Resource, VersionedAcls> aclCache;
    private final ReentrantReadWriteLock kafka$security$auth$SimpleAclAuthorizer$$lock;
    private int maxUpdateRetries;
    private final int retryBackoffMs;
    private final int retryBackoffJitterMs;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static String AllowEveryoneIfNoAclIsFoundProp() {
        return SimpleAclAuthorizer$.MODULE$.AllowEveryoneIfNoAclIsFoundProp();
    }

    public static String SuperUsersProp() {
        return SimpleAclAuthorizer$.MODULE$.SuperUsersProp();
    }

    public static String ZkMaxInFlightRequests() {
        return SimpleAclAuthorizer$.MODULE$.ZkMaxInFlightRequests();
    }

    public static String ZkSessionTimeOutProp() {
        return SimpleAclAuthorizer$.MODULE$.ZkSessionTimeOutProp();
    }

    public static String ZkConnectionTimeOutProp() {
        return SimpleAclAuthorizer$.MODULE$.ZkConnectionTimeOutProp();
    }

    public static String ZkUrlProp() {
        return SimpleAclAuthorizer$.MODULE$.ZkUrlProp();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    public SimpleAclAuthorizer$AclChangedNotificationHandler$ AclChangedNotificationHandler() {
        if (this.AclChangedNotificationHandler$module == null) {
            this.AclChangedNotificationHandler$lzycompute$1();
        }
        return this.AclChangedNotificationHandler$module;
    }

    private Logger logger$lzycompute() {
        SimpleAclAuthorizer simpleAclAuthorizer = this;
        synchronized (simpleAclAuthorizer) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private Logger authorizerLogger() {
        return this.authorizerLogger;
    }

    private Set<KafkaPrincipal> superUsers() {
        return this.superUsers;
    }

    private void superUsers_$eq(Set<KafkaPrincipal> x$1) {
        this.superUsers = x$1;
    }

    private boolean shouldAllowEveryoneIfNoAclIsFound() {
        return this.shouldAllowEveryoneIfNoAclIsFound;
    }

    private void shouldAllowEveryoneIfNoAclIsFound_$eq(boolean x$1) {
        this.shouldAllowEveryoneIfNoAclIsFound = x$1;
    }

    private KafkaZkClient zkClient() {
        return this.zkClient;
    }

    private void zkClient_$eq(KafkaZkClient x$1) {
        this.zkClient = x$1;
    }

    private ZkNodeChangeNotificationListener aclChangeListener() {
        return this.aclChangeListener;
    }

    private void aclChangeListener_$eq(ZkNodeChangeNotificationListener x$1) {
        this.aclChangeListener = x$1;
    }

    private HashMap<Resource, VersionedAcls> aclCache() {
        return this.aclCache;
    }

    public ReentrantReadWriteLock kafka$security$auth$SimpleAclAuthorizer$$lock() {
        return this.kafka$security$auth$SimpleAclAuthorizer$$lock;
    }

    public int maxUpdateRetries() {
        return this.maxUpdateRetries;
    }

    public void maxUpdateRetries_$eq(int x$1) {
        this.maxUpdateRetries = x$1;
    }

    private int retryBackoffMs() {
        return this.retryBackoffMs;
    }

    private int retryBackoffJitterMs() {
        return this.retryBackoffJitterMs;
    }

    @Override
    public void configure(Map<String, ?> javaConfigs) {
        scala.collection.mutable.Map configs = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(javaConfigs).asScala();
        Properties props = new Properties();
        configs.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String key = (String)tuple2._1();
            Object value = tuple2._2();
            Object object = props.put(key, value.toString());
            return object;
        });
        this.superUsers_$eq((Set<KafkaPrincipal>)((Set)configs.get((Object)SimpleAclAuthorizer$.MODULE$.SuperUsersProp()).collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                String string;
                A1 A1 = x1;
                Object object = A1 instanceof String && new StringOps(Predef$.MODULE$.augmentString(string = (String)A1)).nonEmpty() ? new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])string.split(";"))).map((Function1 & Serializable & scala.Serializable)s -> SecurityUtils.parseKafkaPrincipal(s.trim()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(KafkaPrincipal.class))))).toSet() : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                String string;
                Object object = x1;
                boolean bl = object instanceof String && new StringOps(Predef$.MODULE$.augmentString(string = (String)object)).nonEmpty();
                return bl;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(java.lang.String )}, serializedLambda);
            }
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Set().empty())));
        this.shouldAllowEveryoneIfNoAclIsFound_$eq(configs.get((Object)SimpleAclAuthorizer$.MODULE$.AllowEveryoneIfNoAclIsFoundProp()).exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)SimpleAclAuthorizer.$anonfun$configure$3(x$1))));
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props, false);
        String zkUrl = (String)configs.get((Object)SimpleAclAuthorizer$.MODULE$.ZkUrlProp()).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> kafkaConfig.zkConnect());
        int zkConnectionTimeoutMs = BoxesRunTime.unboxToInt((Object)configs.get((Object)SimpleAclAuthorizer$.MODULE$.ZkConnectionTimeOutProp()).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)SimpleAclAuthorizer.$anonfun$configure$6(x$3))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> kafkaConfig.zkConnectionTimeoutMs()));
        int zkSessionTimeOutMs = BoxesRunTime.unboxToInt((Object)configs.get((Object)SimpleAclAuthorizer$.MODULE$.ZkSessionTimeOutProp()).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)SimpleAclAuthorizer.$anonfun$configure$8(x$4))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> kafkaConfig.zkSessionTimeoutMs()));
        int zkMaxInFlightRequests = BoxesRunTime.unboxToInt((Object)configs.get((Object)SimpleAclAuthorizer$.MODULE$.ZkMaxInFlightRequests()).map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)SimpleAclAuthorizer.$anonfun$configure$10(x$5))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> kafkaConfig.zkMaxInFlightRequests()));
        Time time = Time.SYSTEM;
        this.zkClient_$eq(KafkaZkClient$.MODULE$.apply(zkUrl, kafkaConfig.zkEnableSecureAcls(), zkSessionTimeOutMs, zkConnectionTimeoutMs, zkMaxInFlightRequests, time, "io.confluent.kafka.security", "SimpleAclAuthorizer"));
        this.zkClient().createAclPaths();
        this.loadCache();
        this.aclChangeListener_$eq(new ZkNodeChangeNotificationListener(this.zkClient(), AclChangeNotificationZNode$.MODULE$.path(), AclChangeNotificationSequenceZNode$.MODULE$.SequenceNumberPrefix(), this.AclChangedNotificationHandler(), ZkNodeChangeNotificationListener$.MODULE$.$lessinit$greater$default$5(), ZkNodeChangeNotificationListener$.MODULE$.$lessinit$greater$default$6()));
        this.aclChangeListener().init();
    }

    @Override
    public boolean authorize(RequestChannel.Session session, Operation operation2, Resource resource) {
        KafkaPrincipal principal = session.principal();
        String host = session.clientAddress().getHostAddress();
        Set acls = (Set)this.getAcls(resource).$plus$plus(this.getAcls(new Resource(resource.resourceType(), Resource$.MODULE$.WildCardResource())));
        boolean denyMatch = this.aclMatch(operation2, resource, principal, host, Deny$.MODULE$, (Set<Acl>)acls);
        Operation operation3 = operation2;
        Set set = Describe$.MODULE$.equals(operation3) ? (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Describe$.MODULE$, Read$.MODULE$, Write$.MODULE$, Delete$.MODULE$, Alter$.MODULE$})) : (DescribeConfigs$.MODULE$.equals(operation3) ? (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{DescribeConfigs$.MODULE$, AlterConfigs$.MODULE$})) : (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{operation2})));
        Set allowOps = set;
        boolean allowMatch = allowOps.exists((Function1 & Serializable & scala.Serializable)operation -> BoxesRunTime.boxToBoolean((boolean)this.aclMatch(operation, resource, principal, host, Allow$.MODULE$, (Set<Acl>)acls)));
        boolean authorized = this.isSuperUser(operation2, resource, principal, host) || this.isEmptyAclAndAuthorized(operation2, resource, principal, host, (Set<Acl>)acls) || !denyMatch && allowMatch;
        this.logAuditMessage(principal, authorized, operation2, resource, host);
        return authorized;
    }

    public boolean isEmptyAclAndAuthorized(Operation operation, Resource resource, KafkaPrincipal principal, String host, Set<Acl> acls) {
        boolean bl;
        if (acls.isEmpty()) {
            BoxedUnit boxedUnit;
            if (this.authorizerLogger().underlying().isDebugEnabled()) {
                this.authorizerLogger().underlying().debug("No acl found for resource {}, authorized = {}", new Object[]{resource, BoxesRunTime.boxToBoolean((boolean)this.shouldAllowEveryoneIfNoAclIsFound())});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            bl = this.shouldAllowEveryoneIfNoAclIsFound();
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean isSuperUser(Operation operation, Resource resource, KafkaPrincipal principal, String host) {
        boolean bl;
        if (this.superUsers().contains((Object)principal)) {
            BoxedUnit boxedUnit;
            if (this.authorizerLogger().underlying().isDebugEnabled()) {
                this.authorizerLogger().underlying().debug("principal = {} is a super user, allowing operation without checking acls.", new Object[]{principal});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private boolean aclMatch(Operation operations, Resource resource, KafkaPrincipal principal, String host, PermissionType permissionType, Set<Acl> acls) {
        return acls.find((Function1 & Serializable & scala.Serializable)acl -> BoxesRunTime.boxToBoolean((boolean)SimpleAclAuthorizer.$anonfun$aclMatch$1(operations, principal, host, permissionType, acl))).exists((Function1 & Serializable & scala.Serializable)acl -> BoxesRunTime.boxToBoolean((boolean)SimpleAclAuthorizer.$anonfun$aclMatch$2(this, operations, resource, host, permissionType, acl)));
    }

    @Override
    public void addAcls(Set<Acl> acls, Resource resource) {
        block0: {
            if (acls == null || !acls.nonEmpty()) break block0;
            CoreUtils$.MODULE$.inWriteLock(this.kafka$security$auth$SimpleAclAuthorizer$$lock(), (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.updateResourceAcls(resource, (Function1<Set<Acl>, Set<Acl>>)(Function1 & Serializable & scala.Serializable)currentAcls -> (Set)currentAcls.$plus$plus((GenTraversableOnce)acls)));
        }
    }

    @Override
    public boolean removeAcls(Set<Acl> aclsTobeRemoved, Resource resource) {
        return BoxesRunTime.unboxToBoolean(CoreUtils$.MODULE$.inWriteLock(this.kafka$security$auth$SimpleAclAuthorizer$$lock(), (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.updateResourceAcls(resource, (Function1<Set<Acl>, Set<Acl>>)(Function1 & Serializable & scala.Serializable)currentAcls -> (Set)currentAcls.$minus$minus((GenTraversableOnce)aclsTobeRemoved))));
    }

    @Override
    public boolean removeAcls(Resource resource) {
        return BoxesRunTime.unboxToBoolean(CoreUtils$.MODULE$.inWriteLock(this.kafka$security$auth$SimpleAclAuthorizer$$lock(), (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            void var2_2;
            boolean result = this.zkClient().deleteResource(resource);
            this.kafka$security$auth$SimpleAclAuthorizer$$updateCache(resource, new VersionedAcls((Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)), 0));
            this.updateAclChangedFlag(resource);
            return (boolean)var2_2;
        }));
    }

    @Override
    public Set<Acl> getAcls(Resource resource) {
        return (Set)CoreUtils$.MODULE$.inReadLock(this.kafka$security$auth$SimpleAclAuthorizer$$lock(), (Function0 & Serializable & scala.Serializable)() -> (Set)this.aclCache().get((Object)resource).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.acls()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Set().empty()));
    }

    @Override
    public scala.collection.immutable.Map<Resource, Set<Acl>> getAcls(KafkaPrincipal principal) {
        return (scala.collection.immutable.Map)CoreUtils$.MODULE$.inReadLock(this.kafka$security$auth$SimpleAclAuthorizer$$lock(), (Function0 & Serializable & scala.Serializable)() -> ((TraversableOnce)this.aclCache().mapValues((Function1 & Serializable & scala.Serializable)versionedAcls -> (Set)versionedAcls.acls().filter((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)SimpleAclAuthorizer.$anonfun$getAcls$6(principal, x$7)))).filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)SimpleAclAuthorizer.$anonfun$getAcls$7(x0$2)))).toMap(Predef$.MODULE$.$conforms()));
    }

    @Override
    public scala.collection.immutable.Map<Resource, Set<Acl>> getAcls() {
        return (scala.collection.immutable.Map)CoreUtils$.MODULE$.inReadLock(this.kafka$security$auth$SimpleAclAuthorizer$$lock(), (Function0 & Serializable & scala.Serializable)() -> this.aclCache().mapValues((Function1 & Serializable & scala.Serializable)x$8 -> x$8.acls()).toMap(Predef$.MODULE$.$conforms()));
    }

    @Override
    public void close() {
        block1: {
            if (this.aclChangeListener() != null) {
                this.aclChangeListener().close();
            }
            if (this.zkClient() == null) break block1;
            this.zkClient().close();
        }
    }

    private void loadCache() {
        CoreUtils$.MODULE$.inWriteLock(this.kafka$security$auth$SimpleAclAuthorizer$$lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Seq<String> resourceTypes = this.zkClient().getResourceTypes();
            resourceTypes.foreach((Function1 & Serializable & scala.Serializable)rType -> {
                SimpleAclAuthorizer.$anonfun$loadCache$2(this, rType);
                return BoxedUnit.UNIT;
            });
        });
    }

    private void logAuditMessage(KafkaPrincipal principal, boolean authorized, Operation operation, Resource resource, String host) {
        BoxedUnit boxedUnit;
        if (authorized) {
            BoxedUnit boxedUnit2;
            if (this.authorizerLogger().underlying().isDebugEnabled()) {
                this.authorizerLogger().underlying().debug(SimpleAclAuthorizer.logMessage$1(principal, authorized, operation, resource, host));
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
        } else if (this.authorizerLogger().underlying().isInfoEnabled()) {
            this.authorizerLogger().underlying().info(SimpleAclAuthorizer.logMessage$1(principal, authorized, operation, resource, host));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    private boolean updateResourceAcls(Resource resource, Function1<Set<Acl>, Set<Acl>> getNewAcls) {
        boolean bl;
        ObjectRef currentVersionedAcls = ObjectRef.create((Object)(this.aclCache().contains((Object)resource) ? this.getAclsFromCache(resource) : this.kafka$security$auth$SimpleAclAuthorizer$$getAclsFromZk(resource)));
        ObjectRef newVersionedAcls = ObjectRef.create(null);
        boolean writeComplete = false;
        int retries = 0;
        while (!writeComplete && retries <= this.maxUpdateRetries()) {
            Tuple2.mcZI.sp sp2;
            Tuple2.mcZI.sp sp3;
            Set newAcls = (Set)getNewAcls.apply(((VersionedAcls)currentVersionedAcls.elem).acls());
            if (newAcls.nonEmpty()) {
                sp3 = this.zkClient().conditionalSetOrCreateAclsForResource(resource, (Set<Acl>)newAcls, ((VersionedAcls)currentVersionedAcls.elem).zkVersion());
            } else {
                this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deleting path for ", " because it had no ACLs remaining"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resource})));
                sp3 = sp2 = new Tuple2.mcZI.sp(this.zkClient().conditionalDelete(resource, ((VersionedAcls)currentVersionedAcls.elem).zkVersion()), 0);
            }
            if (sp2 == null) {
                throw new MatchError((Object)sp2);
            }
            boolean updateSucceeded = sp2._1$mcZ$sp();
            int updateVersion = sp2._2$mcI$sp();
            Tuple2.mcZI.sp sp4 = new Tuple2.mcZI.sp(updateSucceeded, updateVersion);
            Tuple2.mcZI.sp sp5 = sp4;
            boolean updateSucceeded2 = sp5._1$mcZ$sp();
            int updateVersion2 = sp5._2$mcI$sp();
            if (!updateSucceeded2) {
                this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to update ACLs for ", ". Used version ", ". Reading data and retrying update."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resource, BoxesRunTime.boxToInteger((int)((VersionedAcls)currentVersionedAcls$1.elem).zkVersion())})));
                Thread.sleep(this.backoffTime());
                currentVersionedAcls.elem = this.kafka$security$auth$SimpleAclAuthorizer$$getAclsFromZk(resource);
                ++retries;
                continue;
            }
            newVersionedAcls.elem = new VersionedAcls((Set<Acl>)newAcls, updateVersion2);
            writeComplete = updateSucceeded2;
        }
        if (!writeComplete) {
            throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to update ACLs for ", " after trying a maximum of ", " times"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resource, BoxesRunTime.boxToInteger((int)this.maxUpdateRetries())})));
        }
        Set<Acl> set = ((VersionedAcls)newVersionedAcls.elem).acls();
        Set<Acl> set2 = ((VersionedAcls)currentVersionedAcls.elem).acls();
        if (set == null ? set2 != null : !set.equals(set2)) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Updated ACLs for ", " to ", " with version ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resource, ((VersionedAcls)newVersionedAcls$1.elem).acls(), BoxesRunTime.boxToInteger((int)((VersionedAcls)newVersionedAcls$1.elem).zkVersion())})));
            this.kafka$security$auth$SimpleAclAuthorizer$$updateCache(resource, (VersionedAcls)newVersionedAcls.elem);
            this.updateAclChangedFlag(resource);
            bl = true;
        } else {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Updated ACLs for ", ", no change was made"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resource})));
            this.kafka$security$auth$SimpleAclAuthorizer$$updateCache(resource, (VersionedAcls)newVersionedAcls.elem);
            bl = false;
        }
        return bl;
    }

    private VersionedAcls getAclsFromCache(Resource resource) {
        return (VersionedAcls)this.aclCache().getOrElse((Object)resource, (Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ACLs do not exist in the cache for resource ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resource})));
        });
    }

    public VersionedAcls kafka$security$auth$SimpleAclAuthorizer$$getAclsFromZk(Resource resource) {
        return this.zkClient().getVersionedAclsForResource(resource);
    }

    public void kafka$security$auth$SimpleAclAuthorizer$$updateCache(Resource resource, VersionedAcls versionedAcls) {
        if (versionedAcls.acls().nonEmpty()) {
            this.aclCache().put((Object)resource, (Object)versionedAcls);
        } else {
            this.aclCache().remove((Object)resource);
        }
    }

    private void updateAclChangedFlag(Resource resource) {
        this.zkClient().createAclChangeNotification(resource.toString());
    }

    private int backoffTime() {
        return this.retryBackoffMs() + Random$.MODULE$.nextInt(this.retryBackoffJitterMs());
    }

    private final void AclChangedNotificationHandler$lzycompute$1() {
        SimpleAclAuthorizer simpleAclAuthorizer = this;
        synchronized (simpleAclAuthorizer) {
            if (this.AclChangedNotificationHandler$module == null) {
                this.AclChangedNotificationHandler$module = new SimpleAclAuthorizer$AclChangedNotificationHandler$(this);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$configure$3(Object x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1.toString())).toBoolean();
    }

    public static final /* synthetic */ int $anonfun$configure$6(Object x$3) {
        return new StringOps(Predef$.MODULE$.augmentString(x$3.toString())).toInt();
    }

    public static final /* synthetic */ int $anonfun$configure$8(Object x$4) {
        return new StringOps(Predef$.MODULE$.augmentString(x$4.toString())).toInt();
    }

    public static final /* synthetic */ int $anonfun$configure$10(Object x$5) {
        return new StringOps(Predef$.MODULE$.augmentString(x$5.toString())).toInt();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$aclMatch$1(Operation operations$1, KafkaPrincipal principal$3, String host$2, PermissionType permissionType$1, Acl acl) {
        PermissionType permissionType = acl.permissionType();
        PermissionType permissionType2 = permissionType$1;
        if (permissionType == null) {
            if (permissionType2 != null) {
                return false;
            }
        } else if (!permissionType.equals(permissionType2)) return false;
        KafkaPrincipal kafkaPrincipal = acl.principal();
        KafkaPrincipal kafkaPrincipal2 = principal$3;
        if (kafkaPrincipal == null ? kafkaPrincipal2 != null : !((Object)kafkaPrincipal).equals(kafkaPrincipal2)) {
            KafkaPrincipal kafkaPrincipal3 = acl.principal();
            KafkaPrincipal kafkaPrincipal4 = Acl$.MODULE$.WildCardPrincipal();
            if (kafkaPrincipal3 == null) {
                if (kafkaPrincipal4 != null) {
                    return false;
                }
            } else if (!((Object)kafkaPrincipal3).equals(kafkaPrincipal4)) return false;
        }
        Operation operation = operations$1;
        Operation operation2 = acl.operation();
        if (operation == null ? operation2 != null : !operation.equals(operation2)) {
            Operation operation3 = acl.operation();
            All$ all$ = All$.MODULE$;
            if (operation3 == null) {
                if (all$ != null) {
                    return false;
                }
            } else if (!operation3.equals(all$)) return false;
        }
        String string = acl.host();
        String string2 = host$2;
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = acl.host();
        String string4 = Acl$.MODULE$.WildCardHost();
        if (string3 == null) {
            if (string4 == null) return true;
            return false;
        } else {
            if (!string3.equals(string4)) return false;
            return true;
        }
    }

    public static final /* synthetic */ boolean $anonfun$aclMatch$2(SimpleAclAuthorizer $this, Operation operations$1, Resource resource$3, String host$2, PermissionType permissionType$1, Acl acl) {
        BoxedUnit boxedUnit;
        if ($this.authorizerLogger().underlying().isDebugEnabled()) {
            $this.authorizerLogger().underlying().debug("operation = {} on resource = {} from host = {} is {} based on acl = {}", new Object[]{operations$1, resource$3, host$2, permissionType$1, acl});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$getAcls$6(KafkaPrincipal principal$2, Acl x$7) {
        KafkaPrincipal kafkaPrincipal = x$7.principal();
        KafkaPrincipal kafkaPrincipal2 = principal$2;
        return !(kafkaPrincipal != null ? !((Object)kafkaPrincipal).equals(kafkaPrincipal2) : kafkaPrincipal2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getAcls$7(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Set acls = (Set)tuple2._2();
        boolean bl = acls.nonEmpty();
        return bl;
    }

    public static final /* synthetic */ void $anonfun$loadCache$3(SimpleAclAuthorizer $this, ResourceType resourceType$1, String resourceName) {
        VersionedAcls versionedAcls = $this.kafka$security$auth$SimpleAclAuthorizer$$getAclsFromZk(new Resource(resourceType$1, resourceName));
        $this.kafka$security$auth$SimpleAclAuthorizer$$updateCache(new Resource(resourceType$1, resourceName), versionedAcls);
    }

    public static final /* synthetic */ void $anonfun$loadCache$2(SimpleAclAuthorizer $this, String rType) {
        ResourceType resourceType = ResourceType$.MODULE$.fromString(rType);
        Seq<String> resourceNames = $this.zkClient().getResourceNames(resourceType.name());
        resourceNames.foreach((Function1 & Serializable & scala.Serializable)resourceName -> {
            SimpleAclAuthorizer.$anonfun$loadCache$3($this, resourceType, resourceName);
            return BoxedUnit.UNIT;
        });
    }

    private static final String logMessage$1(KafkaPrincipal principal$4, boolean authorized$1, Operation operation$1, Resource resource$4, String host$3) {
        String authResult = authorized$1 ? "Allowed" : "Denied";
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Principal = ", " is ", " Operation = ", " from host = ", " on resource = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{principal$4, authResult, operation$1, host$3, resource$4}));
    }

    public SimpleAclAuthorizer() {
        Logging.$init$(this);
        this.authorizerLogger = Logger$.MODULE$.apply("io.confluent.kafka.authorizer.logger");
        this.superUsers = Predef$.MODULE$.Set().empty();
        this.shouldAllowEveryoneIfNoAclIsFound = false;
        this.zkClient = null;
        this.aclChangeListener = null;
        this.aclCache = new HashMap();
        this.kafka$security$auth$SimpleAclAuthorizer$$lock = new ReentrantReadWriteLock();
        this.maxUpdateRetries = 10;
        this.retryBackoffMs = 100;
        this.retryBackoffJitterMs = 50;
    }

    public static class VersionedAcls
    implements Product,
    scala.Serializable {
        private final Set<Acl> acls;
        private final int zkVersion;

        public Set<Acl> acls() {
            return this.acls;
        }

        public int zkVersion() {
            return this.zkVersion;
        }

        public VersionedAcls copy(Set<Acl> acls, int zkVersion) {
            return new VersionedAcls(acls, zkVersion);
        }

        public Set<Acl> copy$default$1() {
            return this.acls();
        }

        public int copy$default$2() {
            return this.zkVersion();
        }

        public String productPrefix() {
            return "VersionedAcls";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.acls();
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToInteger((int)this.zkVersion());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof VersionedAcls;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.anyHash(this.acls()));
            n = Statics.mix((int)n, (int)this.zkVersion());
            return Statics.finalizeHash((int)n, (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof VersionedAcls)) return false;
            boolean bl = true;
            if (!bl) return false;
            VersionedAcls versionedAcls = (VersionedAcls)x$1;
            Set<Acl> set = this.acls();
            Set<Acl> set2 = versionedAcls.acls();
            if (set == null) {
                if (set2 != null) {
                    return false;
                }
            } else if (!set.equals(set2)) return false;
            if (this.zkVersion() != versionedAcls.zkVersion()) return false;
            if (!versionedAcls.canEqual(this)) return false;
            return true;
        }

        public VersionedAcls(Set<Acl> acls, int zkVersion) {
            this.acls = acls;
            this.zkVersion = zkVersion;
            Product.$init$((Product)this);
        }
    }
}

