/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.producer.async;

import com.typesafe.scalalogging.Logger;
import io.confluent.kafka.api.ProducerRequest;
import io.confluent.kafka.api.ProducerResponse;
import io.confluent.kafka.api.ProducerResponseStatus;
import io.confluent.kafka.api.TopicMetadata;
import io.confluent.kafka.common.FailedToSendMessageException;
import io.confluent.kafka.common.KafkaException;
import io.confluent.kafka.common.NoBrokersForPartitionException;
import io.confluent.kafka.common.TopicAndPartition;
import io.confluent.kafka.message.ByteBufferMessageSet;
import io.confluent.kafka.message.CompressionCodec;
import io.confluent.kafka.message.Message;
import io.confluent.kafka.message.Message$;
import io.confluent.kafka.message.NoCompressionCodec$;
import io.confluent.kafka.producer.BrokerPartitionInfo;
import io.confluent.kafka.producer.KeyedMessage;
import io.confluent.kafka.producer.PartitionAndLeader;
import io.confluent.kafka.producer.Partitioner;
import io.confluent.kafka.producer.ProducerConfig;
import io.confluent.kafka.producer.ProducerPool;
import io.confluent.kafka.producer.ProducerStats;
import io.confluent.kafka.producer.ProducerStatsRegistry$;
import io.confluent.kafka.producer.ProducerTopicStats;
import io.confluent.kafka.producer.ProducerTopicStatsRegistry$;
import io.confluent.kafka.producer.SyncProducer;
import io.confluent.kafka.producer.async.DefaultEventHandler$;
import io.confluent.kafka.producer.async.EventHandler;
import io.confluent.kafka.serializer.Encoder;
import io.confluent.kafka.utils.CoreUtils$;
import io.confluent.kafka.utils.Logging;
import io.confluent.org.apache.kafka.common.errors.LeaderNotAvailableException;
import io.confluent.org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import io.confluent.org.apache.kafka.common.protocol.Errors;
import io.confluent.org.apache.kafka.common.utils.Time;
import io.confluent.org.apache.kafka.common.utils.Utils;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\tmf\u0001B\u0001\u0003\u0001%\u00111\u0003R3gCVdG/\u0012<f]RD\u0015M\u001c3mKJT!a\u0001\u0003\u0002\u000b\u0005\u001c\u0018P\\2\u000b\u0005\u00151\u0011\u0001\u00039s_\u0012,8-\u001a:\u000b\u0003\u001d\tQa[1gW\u0006\u001c\u0001!F\u0002\u000b/\u0005\u001aB\u0001A\u0006\u0012GA\u0011AbD\u0007\u0002\u001b)\ta\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0011\u001b\t1\u0011I\\=SK\u001a\u0004BAE\n\u0016A5\t!!\u0003\u0002\u0015\u0005\taQI^3oi\"\u000bg\u000e\u001a7feB\u0011ac\u0006\u0007\u0001\t\u0015A\u0002A1\u0001\u001a\u0005\u0005Y\u0015C\u0001\u000e\u001e!\ta1$\u0003\u0002\u001d\u001b\t9aj\u001c;iS:<\u0007C\u0001\u0007\u001f\u0013\tyRBA\u0002B]f\u0004\"AF\u0011\u0005\u000b\t\u0002!\u0019A\r\u0003\u0003Y\u0003\"\u0001J\u0014\u000e\u0003\u0015R!A\n\u0004\u0002\u000bU$\u0018\u000e\\:\n\u0005!*#a\u0002'pO\u001eLgn\u001a\u0005\tU\u0001\u0011\t\u0011)A\u0005W\u000511m\u001c8gS\u001e\u0004\"\u0001L\u0017\u000e\u0003\u0011I!A\f\u0003\u0003\u001dA\u0013x\u000eZ;dKJ\u001cuN\u001c4jO\"A\u0001\u0007\u0001BC\u0002\u0013%\u0011'A\u0006qCJ$\u0018\u000e^5p]\u0016\u0014X#\u0001\u001a\u0011\u00051\u001a\u0014B\u0001\u001b\u0005\u0005-\u0001\u0016M\u001d;ji&|g.\u001a:\t\u0011Y\u0002!\u0011!Q\u0001\nI\nA\u0002]1si&$\u0018n\u001c8fe\u0002B\u0001\u0002\u000f\u0001\u0003\u0006\u0004%I!O\u0001\bK:\u001cw\u000eZ3s+\u0005Q\u0004cA\u001e?A5\tAH\u0003\u0002>\r\u0005Q1/\u001a:jC2L'0\u001a:\n\u0005}b$aB#oG>$WM\u001d\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005u\u0005AQM\\2pI\u0016\u0014\b\u0005\u0003\u0005D\u0001\t\u0015\r\u0011\"\u0003E\u0003)YW-_#oG>$WM]\u000b\u0002\u000bB\u00191HP\u000b\t\u0011\u001d\u0003!\u0011!Q\u0001\n\u0015\u000b1b[3z\u000b:\u001cw\u000eZ3sA!A\u0011\n\u0001BC\u0002\u0013%!*\u0001\u0007qe>$WoY3s!>|G.F\u0001L!\taC*\u0003\u0002N\t\ta\u0001K]8ek\u000e,'\u000fU8pY\"Aq\n\u0001B\u0001B\u0003%1*A\u0007qe>$WoY3s!>|G\u000e\t\u0005\t#\u0002\u0011)\u0019!C\u0005%\u0006\u0019Bo\u001c9jGB\u000b'\u000f^5uS>t\u0017J\u001c4pgV\t1\u000b\u0005\u0003U3n3W\"A+\u000b\u0005Y;\u0016aB7vi\u0006\u0014G.\u001a\u0006\u000316\t!bY8mY\u0016\u001cG/[8o\u0013\tQVKA\u0004ICNDW*\u00199\u0011\u0005q\u001bgBA/b!\tqV\"D\u0001`\u0015\t\u0001\u0007\"\u0001\u0004=e>|GOP\u0005\u0003E6\ta\u0001\u0015:fI\u00164\u0017B\u00013f\u0005\u0019\u0019FO]5oO*\u0011!-\u0004\t\u0003O*l\u0011\u0001\u001b\u0006\u0003S\u001a\t1!\u00199j\u0013\tY\u0007NA\u0007U_BL7-T3uC\u0012\fG/\u0019\u0005\t[\u0002\u0011\t\u0011)A\u0005'\u0006!Bo\u001c9jGB\u000b'\u000f^5uS>t\u0017J\u001c4pg\u0002B\u0001b\u001c\u0001\u0003\u0006\u0004%I\u0001]\u0001\u0005i&lW-F\u0001r!\t\u001180D\u0001t\u0015\t1CO\u0003\u0002vm\u000611m\\7n_:T!aB<\u000b\u0005aL\u0018AB1qC\u000eDWMC\u0001{\u0003\ry'oZ\u0005\u0003yN\u0014A\u0001V5nK\"Aa\u0010\u0001B\u0001B\u0003%\u0011/A\u0003uS6,\u0007\u0005C\u0004\u0002\u0002\u0001!\t!a\u0001\u0002\rqJg.\u001b;?)A\t)!a\u0002\u0002\n\u0005-\u0011QBA\b\u0003#\t\u0019\u0002\u0005\u0003\u0013\u0001U\u0001\u0003\"\u0002\u0016\u0000\u0001\u0004Y\u0003\"\u0002\u0019\u0000\u0001\u0004\u0011\u0004\"\u0002\u001d\u0000\u0001\u0004Q\u0004\"B\"\u0000\u0001\u0004)\u0005\"B%\u0000\u0001\u0004Y\u0005bB)\u0000!\u0003\u0005\ra\u0015\u0005\b_~\u0004\n\u00111\u0001r\u0011%\t9\u0002\u0001b\u0001\n\u0003\tI\"\u0001\u0004jgNKhnY\u000b\u0003\u00037\u00012\u0001DA\u000f\u0013\r\ty\"\u0004\u0002\b\u0005>|G.Z1o\u0011!\t\u0019\u0003\u0001Q\u0001\n\u0005m\u0011aB5t'ft7\r\t\u0005\n\u0003O\u0001!\u0019!C\u0001\u0003S\tQbY8se\u0016d\u0017\r^5p]&#WCAA\u0016!\u0011\ti#a\u0010\u000e\u0005\u0005=\"\u0002BA\u0019\u0003g\ta!\u0019;p[&\u001c'\u0002BA\u001b\u0003o\t!bY8oGV\u0014(/\u001a8u\u0015\u0011\tI$a\u000f\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003{\tAA[1wC&!\u0011\u0011IA\u0018\u00055\tEo\\7jG&sG/Z4fe\"A\u0011Q\t\u0001!\u0002\u0013\tY#\u0001\bd_J\u0014X\r\\1uS>t\u0017\n\u001a\u0011\t\u0013\u0005%\u0003A1A\u0005\u0002\u0005-\u0013a\u00052s_.,'\u000fU1si&$\u0018n\u001c8J]\u001a|WCAA'!\ra\u0013qJ\u0005\u0004\u0003#\"!a\u0005\"s_.,'\u000fU1si&$\u0018n\u001c8J]\u001a|\u0007\u0002CA+\u0001\u0001\u0006I!!\u0014\u0002)\t\u0014xn[3s!\u0006\u0014H/\u001b;j_:LeNZ8!\u0011%\tI\u0006\u0001b\u0001\n\u0013\tY&\u0001\u000fu_BL7-T3uC\u0012\fG/\u0019*fMJ,7\u000f[%oi\u0016\u0014h/\u00197\u0016\u0005\u0005u\u0003c\u0001\u0007\u0002`%\u0019\u0011\u0011M\u0007\u0003\u0007%sG\u000f\u0003\u0005\u0002f\u0001\u0001\u000b\u0011BA/\u0003u!x\u000e]5d\u001b\u0016$\u0018\rZ1uCJ+gM]3tQ&sG/\u001a:wC2\u0004\u0003\"CA5\u0001\u0001\u0007I\u0011BA6\u0003qa\u0017m\u001d;U_BL7-T3uC\u0012\fG/\u0019*fMJ,7\u000f\u001b+j[\u0016,\"!!\u001c\u0011\u00071\ty'C\u0002\u0002r5\u0011A\u0001T8oO\"I\u0011Q\u000f\u0001A\u0002\u0013%\u0011qO\u0001!Y\u0006\u001cH\u000fV8qS\u000elU\r^1eCR\f'+\u001a4sKNDG+[7f?\u0012*\u0017\u000f\u0006\u0003\u0002z\u0005}\u0004c\u0001\u0007\u0002|%\u0019\u0011QP\u0007\u0003\tUs\u0017\u000e\u001e\u0005\u000b\u0003\u0003\u000b\u0019(!AA\u0002\u00055\u0014a\u0001=%c!A\u0011Q\u0011\u0001!B\u0013\ti'A\u000fmCN$Hk\u001c9jG6+G/\u00193bi\u0006\u0014VM\u001a:fg\"$\u0016.\\3!\u0011%\tI\t\u0001b\u0001\n\u0013\tY)\u0001\fu_BL7-T3uC\u0012\fG/\u0019+p%\u00164'/Z:i+\t\ti\t\u0005\u0003U\u0003\u001f[\u0016bAAI+\n\u00191+\u001a;\t\u0011\u0005U\u0005\u0001)A\u0005\u0003\u001b\u000bq\u0003^8qS\u000elU\r^1eCR\fGk\u001c*fMJ,7\u000f\u001b\u0011\t\u0013\u0005e\u0005A1A\u0005\n\u0005m\u0015AG:f]\u0012\u0004\u0016M\u001d;ji&|g\u000eU3s)>\u0004\u0018nY\"bG\",WCAAO!\u0015!\u0016lWA/\u0011!\t\t\u000b\u0001Q\u0001\n\u0005u\u0015aG:f]\u0012\u0004\u0016M\u001d;ji&|g\u000eU3s)>\u0004\u0018nY\"bG\",\u0007\u0005C\u0005\u0002&\u0002\u0011\r\u0011\"\u0003\u0002(\u0006i\u0001O]8ek\u000e,'o\u0015;biN,\"!!+\u0011\u00071\nY+C\u0002\u0002.\u0012\u0011Q\u0002\u0015:pIV\u001cWM]*uCR\u001c\b\u0002CAY\u0001\u0001\u0006I!!+\u0002\u001dA\u0014x\u000eZ;dKJ\u001cF/\u0019;tA!I\u0011Q\u0017\u0001C\u0002\u0013%\u0011qW\u0001\u0013aJ|G-^2feR{\u0007/[2Ti\u0006$8/\u0006\u0002\u0002:B\u0019A&a/\n\u0007\u0005uFA\u0001\nQe>$WoY3s)>\u0004\u0018nY*uCR\u001c\b\u0002CAa\u0001\u0001\u0006I!!/\u0002'A\u0014x\u000eZ;dKJ$v\u000e]5d'R\fGo\u001d\u0011\t\u000f\u0005\u0015\u0007\u0001\"\u0001\u0002H\u00061\u0001.\u00198eY\u0016$B!!\u001f\u0002J\"A\u00111ZAb\u0001\u0004\ti-\u0001\u0004fm\u0016tGo\u001d\t\u0007\u0003\u001f\f\t.!6\u000e\u0003]K1!a5X\u0005\r\u0019V-\u001d\t\u0006Y\u0005]W\u0003I\u0005\u0004\u00033$!\u0001D&fs\u0016$W*Z:tC\u001e,\u0007bBAo\u0001\u0011%\u0011q\\\u0001\u0017I&\u001c\b/\u0019;dQN+'/[1mSj,G\rR1uCR!\u0011\u0011]Ay!\u0019\ty-!5\u0002dB1A&a6\u0016\u0003K\u0004B!a:\u0002n6\u0011\u0011\u0011\u001e\u0006\u0004\u0003W4\u0011aB7fgN\fw-Z\u0005\u0005\u0003_\fIOA\u0004NKN\u001c\u0018mZ3\t\u0011\u0005M\u00181\u001ca\u0001\u0003C\f\u0001\"\\3tg\u0006<Wm\u001d\u0005\b\u0003o\u0004A\u0011AA}\u0003%\u0019XM]5bY&TX\r\u0006\u0003\u0002b\u0006m\b\u0002CAf\u0003k\u0004\r!!4\t\u000f\u0005}\b\u0001\"\u0001\u0003\u0002\u0005\u0019\u0002/\u0019:uSRLwN\\!oI\u000e{G\u000e\\1uKR!!1\u0001B\u000f!\u0015a!Q\u0001B\u0005\u0013\r\u00119!\u0004\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0011\u0005='1BA/\u0005\u001fI1A!\u0004X\u0005\ri\u0015\r\u001d\t\b)\nE!1CAq\u0013\r\u0011i!\u0016\t\u0005\u0005+\u0011I\"\u0004\u0002\u0003\u0018)\u0011QOB\u0005\u0005\u00057\u00119BA\tU_BL7-\u00118e!\u0006\u0014H/\u001b;j_:D\u0001\"a=\u0002~\u0002\u0007\u0011\u0011\u001d\u0005\b\u0005C\u0001A\u0011\u0002B\u0012\u0003a9W\r\u001e)beRLG/[8o\u0019&\u001cHOR8s)>\u0004\u0018n\u0019\u000b\u0005\u0005K\u0011i\u0003\u0005\u0004\u0002P\u0006E'q\u0005\t\u0004Y\t%\u0012b\u0001B\u0016\t\t\u0011\u0002+\u0019:uSRLwN\\!oI2+\u0017\rZ3s\u0011!\u0011yCa\bA\u0002\u0005\r\u0018!A7\t\u000f\tM\u0002\u0001\"\u0003\u00036\u0005aq-\u001a;QCJ$\u0018\u000e^5p]RA\u0011Q\fB\u001c\u0005w\u0011y\u0004C\u0004\u0003:\tE\u0002\u0019A.\u0002\u000bQ|\u0007/[2\t\u000f\tu\"\u0011\u0007a\u0001;\u0005\u00191.Z=\t\u0011\t\u0005#\u0011\u0007a\u0001\u0005K\t!\u0003^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eT5ti\"9!Q\t\u0001\u0005\n\t\u001d\u0013\u0001B:f]\u0012$bA!\u0013\u0003L\t=\u0003CBAh\u0003#\u0014\u0019\u0002\u0003\u0005\u0003N\t\r\u0003\u0019AA/\u0003!\u0011'o\\6fe&#\u0007\u0002\u0003B)\u0005\u0007\u0002\rAa\u0015\u0002!5,7o]1hKN\u0004VM\u001d+pa&\u001c\u0007c\u0002+\u0003\u0012\tM!Q\u000b\t\u0005\u0003O\u00149&\u0003\u0003\u0003Z\u0005%(\u0001\u0006\"zi\u0016\u0014UO\u001a4fe6+7o]1hKN+G\u000fC\u0004\u0003^\u0001!IAa\u0018\u0002%\u001d\u0014x.\u001e9NKN\u001c\u0018mZ3t)>\u001cV\r\u001e\u000b\u0005\u0005C\u0012\u0019\u0007E\u0003\r\u0005\u000b\u0011\u0019\u0006\u0003\u0005\u0003f\tm\u0003\u0019\u0001B\b\u0003qiWm]:bO\u0016\u001c\b+\u001a:U_BL7-\u00118e!\u0006\u0014H/\u001b;j_:DqA!\u001b\u0001\t\u0003\u0011Y'A\u0003dY>\u001cX\r\u0006\u0002\u0002z!:\u0001Aa\u001c\u0003v\te\u0004c\u0001\u0007\u0003r%\u0019!1O\u0007\u0003\u0015\u0011,\u0007O]3dCR,G-\t\u0002\u0003x\u00059E\u000b[5tA\rd\u0017m]:!Q\u0006\u001c\bEY3f]\u0002\"W\r\u001d:fG\u0006$X\r\u001a\u0011b]\u0012\u0004s/\u001b7mA\t,\u0007E]3n_Z,G\rI5oA\u0005\u0004c-\u001e;ve\u0016\u0004#/\u001a7fCN,g&\t\u0002\u0003|\u0005A\u0001GL\u00191]Ar\u0003gB\u0005\u0003\u0000\t\t\t\u0011#\u0001\u0003\u0002\u0006\u0019B)\u001a4bk2$XI^3oi\"\u000bg\u000e\u001a7feB\u0019!Ca!\u0007\u0011\u0005\u0011\u0011\u0011!E\u0001\u0005\u000b\u001b2Aa!\f\u0011!\t\tAa!\u0005\u0002\t%EC\u0001BA\u0011)\u0011iIa!\u0012\u0002\u0013\u0005!qR\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001c\u0016\r\tE%q\u0015BU+\t\u0011\u0019JK\u0002T\u0005+[#Aa&\u0011\t\te%1U\u0007\u0003\u00057SAA!(\u0003 \u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005Ck\u0011AC1o]>$\u0018\r^5p]&!!Q\u0015BN\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0003\u00071\t-%\u0019A\r\u0005\r\t\u0012YI1\u0001\u001a\u0011)\u0011iKa!\u0012\u0002\u0013\u0005!qV\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001c\u0016\r\tE&Q\u0017B\\+\t\u0011\u0019LK\u0002r\u0005+#a\u0001\u0007BV\u0005\u0004IBA\u0002\u0012\u0003,\n\u0007\u0011\u0004\u000b\u0005\u0003\u0004\n=$Q\u000fB=\u0001")
public class DefaultEventHandler<K, V>
implements EventHandler<K, V>,
Logging {
    private final ProducerConfig config;
    private final Partitioner partitioner;
    private final Encoder<V> encoder;
    private final Encoder<K> keyEncoder;
    private final ProducerPool producerPool;
    private final HashMap<String, TopicMetadata> topicPartitionInfos;
    private final Time time;
    private final boolean isSync;
    private final AtomicInteger correlationId;
    private final BrokerPartitionInfo brokerPartitionInfo;
    private final int topicMetadataRefreshInterval;
    private long lastTopicMetadataRefreshTime;
    private final Set<String> topicMetadataToRefresh;
    private final HashMap<String, Object> sendPartitionPerTopicCache;
    private final ProducerStats producerStats;
    private final ProducerTopicStats producerTopicStats;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static <K, V> Time $lessinit$greater$default$7() {
        return DefaultEventHandler$.MODULE$.$lessinit$greater$default$7();
    }

    public static <K, V> HashMap<String, TopicMetadata> $lessinit$greater$default$6() {
        return DefaultEventHandler$.MODULE$.$lessinit$greater$default$6();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        DefaultEventHandler defaultEventHandler = this;
        synchronized (defaultEventHandler) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private Partitioner partitioner() {
        return this.partitioner;
    }

    private Encoder<V> encoder() {
        return this.encoder;
    }

    private Encoder<K> keyEncoder() {
        return this.keyEncoder;
    }

    private ProducerPool producerPool() {
        return this.producerPool;
    }

    private HashMap<String, TopicMetadata> topicPartitionInfos() {
        return this.topicPartitionInfos;
    }

    private Time time() {
        return this.time;
    }

    public boolean isSync() {
        return this.isSync;
    }

    public AtomicInteger correlationId() {
        return this.correlationId;
    }

    public BrokerPartitionInfo brokerPartitionInfo() {
        return this.brokerPartitionInfo;
    }

    private int topicMetadataRefreshInterval() {
        return this.topicMetadataRefreshInterval;
    }

    private long lastTopicMetadataRefreshTime() {
        return this.lastTopicMetadataRefreshTime;
    }

    private void lastTopicMetadataRefreshTime_$eq(long x$1) {
        this.lastTopicMetadataRefreshTime = x$1;
    }

    private Set<String> topicMetadataToRefresh() {
        return this.topicMetadataToRefresh;
    }

    private HashMap<String, Object> sendPartitionPerTopicCache() {
        return this.sendPartitionPerTopicCache;
    }

    private ProducerStats producerStats() {
        return this.producerStats;
    }

    private ProducerTopicStats producerTopicStats() {
        return this.producerTopicStats;
    }

    @Override
    public void handle(Seq<KeyedMessage<K, V>> events) {
        Seq<KeyedMessage<K, Message>> serializedData = this.serialize(events);
        serializedData.foreach((Function1 & Serializable & scala.Serializable)keyed -> {
            DefaultEventHandler.$anonfun$handle$1(this, keyed);
            return BoxedUnit.UNIT;
        });
        ObjectRef outstandingProduceRequests = ObjectRef.create(serializedData);
        IntRef remainingRetries = IntRef.create((int)(this.config.messageSendMaxRetries() + 1));
        int correlationIdStart = this.correlationId().get();
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Handling %d events")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)events.size())})));
        while (remainingRetries.elem > 0 && ((Seq)outstandingProduceRequests.elem).nonEmpty()) {
            this.topicMetadataToRefresh().$plus$plus$eq((TraversableOnce)((Seq)outstandingProduceRequests.elem).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.topic(), Seq$.MODULE$.canBuildFrom()));
            if (this.topicMetadataRefreshInterval() >= 0 && Time.SYSTEM.milliseconds() - this.lastTopicMetadataRefreshTime() > (long)this.topicMetadataRefreshInterval()) {
                CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.brokerPartitionInfo().updateInfo((scala.collection.immutable.Set<String>)this.topicMetadataToRefresh().toSet(), this.correlationId().getAndIncrement()), this, Level.ERROR);
                this.sendPartitionPerTopicCache().clear();
                this.topicMetadataToRefresh().clear();
                this.lastTopicMetadataRefreshTime_$eq(Time.SYSTEM.milliseconds());
            }
            outstandingProduceRequests.elem = this.dispatchSerializedData((Seq)outstandingProduceRequests.elem);
            if (!((Seq)outstandingProduceRequests.elem).nonEmpty()) continue;
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Back off for %d ms before retrying send. Remaining retries = %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)$this.config.retryBackoffMs()), BoxesRunTime.boxToInteger((int)(remainingRetries$1.elem - 1))})));
            Thread.sleep(this.config.retryBackoffMs());
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.brokerPartitionInfo().updateInfo((scala.collection.immutable.Set<String>)((TraversableOnce)((Seq)outstandingProduceRequests$1.elem).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.topic(), Seq$.MODULE$.canBuildFrom())).toSet(), this.correlationId().getAndIncrement()), this, Level.ERROR);
            this.sendPartitionPerTopicCache().clear();
            --remainingRetries.elem;
            this.producerStats().resendRate().mark();
        }
        if (((Seq)outstandingProduceRequests.elem).nonEmpty()) {
            this.producerStats().failedSendRate().mark();
            int correlationIdEnd = this.correlationId().get();
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Failed to send requests for topics %s with correlation ids in [%d,%d]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)((Seq)outstandingProduceRequests$1.elem).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.topic(), Seq$.MODULE$.canBuildFrom())).toSet().mkString(","), BoxesRunTime.boxToInteger((int)correlationIdStart), BoxesRunTime.boxToInteger((int)(correlationIdEnd - 1))})));
            throw new FailedToSendMessageException("Failed to send messages after " + this.config.messageSendMaxRetries() + " tries.", null);
        }
    }

    private Seq<KeyedMessage<K, Message>> dispatchSerializedData(Seq<KeyedMessage<K, Message>> messages) {
        ArrayBuffer arrayBuffer;
        Option<Map<Object, scala.collection.mutable.Map<TopicAndPartition, Seq<KeyedMessage<K, Message>>>>> partitionedDataOpt = this.partitionAndCollate((Seq<KeyedMessage<K, Message>>)messages);
        Option<Map<Object, scala.collection.mutable.Map<TopicAndPartition, Seq<KeyedMessage<K, Message>>>>> option = partitionedDataOpt;
        if (option instanceof Some) {
            Some some = (Some)option;
            Map partitionedData = (Map)some.value();
            ArrayBuffer failedProduceRequests = new ArrayBuffer();
            partitionedData.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)DefaultEventHandler.$anonfun$dispatchSerializedData$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                DefaultEventHandler.$anonfun$dispatchSerializedData$2(this, failedProduceRequests, x$4);
                return BoxedUnit.UNIT;
            });
            arrayBuffer = failedProduceRequests;
        } else if (None$.MODULE$.equals(option)) {
            arrayBuffer = messages;
        } else {
            throw new MatchError(option);
        }
        return arrayBuffer;
    }

    /*
     * WARNING - void declaration
     */
    public Seq<KeyedMessage<K, Message>> serialize(Seq<KeyedMessage<K, V>> events) {
        void var2_2;
        ArrayBuffer serializedMessages = new ArrayBuffer(events.size());
        events.foreach((Function1 & Serializable & scala.Serializable)e -> {
            BoxedUnit boxedUnit;
            block4: {
                try {
                    if (e.hasKey()) {
                        byte[] x$9 = this.keyEncoder().toBytes(e.key());
                        byte[] x$10 = this.encoder().toBytes(e.message());
                        long x$11 = this.time().milliseconds();
                        byte x$12 = Message$.MODULE$.MagicValue_V1();
                        boxedUnit = serializedMessages.$plus$eq(new KeyedMessage(e.topic(), e.key(), e.partKey(), new Message(x$10, x$9, x$11, x$12)));
                        break block4;
                    }
                    boxedUnit = serializedMessages.$plus$eq(new KeyedMessage(e.topic(), e.key(), e.partKey(), new Message(this.encoder().toBytes(e.message()), this.time().milliseconds(), Message$.MODULE$.MagicValue_V1())));
                }
                catch (Throwable t) {
                    this.producerStats().serializationErrorRate().mark();
                    if (this.isSync()) {
                        throw t;
                    }
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Error serializing message for topic %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{e.topic()})), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            return boxedUnit;
        });
        return var2_2;
    }

    public Option<Map<Object, scala.collection.mutable.Map<TopicAndPartition, Seq<KeyedMessage<K, Message>>>>> partitionAndCollate(Seq<KeyedMessage<K, Message>> messages) {
        Some some;
        HashMap ret = new HashMap();
        try {
            messages.foreach((Function1 & Serializable & scala.Serializable)message -> {
                DefaultEventHandler.$anonfun$partitionAndCollate$1(this, ret, message);
                return BoxedUnit.UNIT;
            });
            some = new Some((Object)ret);
        }
        catch (UnknownTopicOrPartitionException ute) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to collate messages by topic,partition due to: " + ute.getMessage());
            some = None$.MODULE$;
        }
        catch (LeaderNotAvailableException lnae) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to collate messages by topic,partition due to: " + lnae.getMessage());
            some = None$.MODULE$;
        }
        catch (Throwable oe) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to collate messages by topic, partition due to: " + oe.getMessage());
            some = None$.MODULE$;
        }
        return some;
    }

    /*
     * WARNING - void declaration
     */
    private Seq<PartitionAndLeader> getPartitionListForTopic(KeyedMessage<K, Message> m) {
        void var2_2;
        Seq<PartitionAndLeader> topicPartitionsList = this.brokerPartitionInfo().getBrokerPartitionInfo(m.topic(), this.correlationId().getAndIncrement());
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Broker partitions registered for topic: %s are %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{m.topic(), ((TraversableOnce)topicPartitionsList.map((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToInteger((int)p.partitionId()), Seq$.MODULE$.canBuildFrom())).mkString(",")})));
        int totalNumPartitions = topicPartitionsList.length();
        if (totalNumPartitions == 0) {
            throw new NoBrokersForPartitionException("Partition key = " + m.key());
        }
        return var2_2;
    }

    private int getPartition(String topic, Object key, Seq<PartitionAndLeader> topicPartitionList) {
        int partition;
        int n;
        int numPartitions = topicPartitionList.size();
        if (numPartitions <= 0) {
            throw new UnknownTopicOrPartitionException("Topic " + topic + " doesn't exist");
        }
        if (key == null) {
            int n2;
            Option id = this.sendPartitionPerTopicCache().get((Object)topic);
            Option option = id;
            if (option instanceof Some) {
                int partitionId;
                Some some = (Some)option;
                n2 = partitionId = BoxesRunTime.unboxToInt((Object)some.value());
            } else if (None$.MODULE$.equals(option)) {
                Seq availablePartitions = (Seq)topicPartitionList.filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)DefaultEventHandler.$anonfun$getPartition$1(x$5)));
                if (availablePartitions.isEmpty()) {
                    throw new LeaderNotAvailableException("No leader for any partition in topic " + topic);
                }
                int index = Utils.abs(Random$.MODULE$.nextInt()) % availablePartitions.size();
                int partitionId = ((PartitionAndLeader)availablePartitions.apply(index)).partitionId();
                this.sendPartitionPerTopicCache().put((Object)topic, (Object)BoxesRunTime.boxToInteger((int)partitionId));
                n2 = partitionId;
            } else {
                throw new MatchError((Object)option);
            }
            n = n2;
        } else {
            n = partition = this.partitioner().partition(key, numPartitions);
        }
        if (partition < 0 || partition >= numPartitions) {
            throw new UnknownTopicOrPartitionException("Invalid partition id: " + partition + " for topic " + topic + "; Valid values are in the inclusive range of [0, " + (numPartitions - 1) + "]");
        }
        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Assigning message of topic %s and key %s to a selected partition %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, key == null ? "[none]" : key.toString(), BoxesRunTime.boxToInteger((int)partition)})));
        return partition;
    }

    private Seq<TopicAndPartition> send(int brokerId, scala.collection.mutable.Map<TopicAndPartition, ByteBufferMessageSet> messagesPerTopic) {
        List list;
        block10: {
            if (brokerId < 0) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Failed to send data since partitions %s don't have a leader")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{messagesPerTopic.keys().mkString(",")})));
                list = messagesPerTopic.keys().toSeq();
            } else if (messagesPerTopic.nonEmpty()) {
                int currentCorrelationId = this.correlationId().getAndIncrement();
                ProducerRequest producerRequest = new ProducerRequest(currentCorrelationId, this.config.clientId(), this.config.requestRequiredAcks(), this.config.requestTimeoutMs(), messagesPerTopic);
                Seq failedTopicPartitions = (Seq)Seq$.MODULE$.empty();
                try {
                    SyncProducer syncProducer = this.producerPool().getProducer(brokerId);
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Producer sending messages with correlation id %d for topics %s to broker %d on %s:%d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)currentCorrelationId), messagesPerTopic.keySet().mkString(","), BoxesRunTime.boxToInteger((int)brokerId), syncProducer.config().host(), BoxesRunTime.boxToInteger((int)syncProducer.config().port())})));
                    ProducerResponse response = syncProducer.send(producerRequest);
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Producer sent messages with correlation id %d for topics %s to broker %d on %s:%d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)currentCorrelationId), messagesPerTopic.keySet().mkString(","), BoxesRunTime.boxToInteger((int)brokerId), syncProducer.config().host(), BoxesRunTime.boxToInteger((int)syncProducer.config().port())})));
                    if (response != null) {
                        Seq failedPartitionsAndStatus;
                        if (response.status().size() != producerRequest.data().size()) {
                            throw new KafkaException(new StringOps(Predef$.MODULE$.augmentString("Incomplete response (%s) for producer request (%s)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{response, producerRequest})));
                        }
                        if (this.isTraceEnabled()) {
                            Map successfullySentData = (Map)response.status().filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)DefaultEventHandler.$anonfun$send$4(x$6)));
                            successfullySentData.foreach((Function1 & Serializable & scala.Serializable)m -> {
                                DefaultEventHandler.$anonfun$send$5(this, messagesPerTopic, m);
                                return BoxedUnit.UNIT;
                            });
                        }
                        if ((failedTopicPartitions = (Seq)(failedPartitionsAndStatus = ((MapLike)response.status().filter((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)DefaultEventHandler.$anonfun$send$8(x$7)))).toSeq()).map((Function1 & Serializable & scala.Serializable)partitionStatus -> (TopicAndPartition)partitionStatus._1(), Seq$.MODULE$.canBuildFrom())).nonEmpty()) {
                            String errorString = ((TraversableOnce)((TraversableLike)failedPartitionsAndStatus.sortWith((Function2 & Serializable & scala.Serializable)(p1, p2) -> BoxesRunTime.boxToBoolean((boolean)DefaultEventHandler.$anonfun$send$10(p1, p2)))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                                Tuple2 tuple2 = x0$2;
                                if (tuple2 == null) {
                                    throw new MatchError((Object)tuple2);
                                }
                                TopicAndPartition topicAndPartition = (TopicAndPartition)tuple2._1();
                                ProducerResponseStatus status = (ProducerResponseStatus)tuple2._2();
                                String string = topicAndPartition.toString() + ": " + status.error().exceptionName();
                                return string;
                            }, Seq$.MODULE$.canBuildFrom())).mkString(",");
                            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Produce request with correlation id %d failed due to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)currentCorrelationId), errorString})));
                        }
                        list = failedTopicPartitions;
                        break block10;
                    }
                    list = (Seq)Seq$.MODULE$.empty();
                }
                catch (Throwable t) {
                    this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Failed to send producer request with correlation id %d to broker %d with data for partitions %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)currentCorrelationId), BoxesRunTime.boxToInteger((int)brokerId), messagesPerTopic.keys().mkString(",")})), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
                    list = messagesPerTopic.keys().toSeq();
                }
            } else {
                list = List$.MODULE$.empty();
            }
        }
        return list;
    }

    private Option<scala.collection.mutable.Map<TopicAndPartition, ByteBufferMessageSet>> groupMessagesToSet(scala.collection.mutable.Map<TopicAndPartition, Seq<KeyedMessage<K, Message>>> messagesPerTopicAndPartition) {
        None$ none$;
        try {
            scala.collection.mutable.Map messagesPerTopicPartition = (scala.collection.mutable.Map)messagesPerTopicAndPartition.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                ByteBufferMessageSet byteBufferMessageSet;
                TopicAndPartition topicAndPartition;
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    topicAndPartition = (TopicAndPartition)tuple2._1();
                    Seq messages = (Seq)tuple2._2();
                    Seq rawMessages = (Seq)messages.map((Function1 & Serializable & scala.Serializable)x$8 -> (Message)x$8.message(), Seq$.MODULE$.canBuildFrom());
                    CompressionCodec compressionCodec = $this.config.compressionCodec();
                    if (NoCompressionCodec$.MODULE$.equals(compressionCodec)) {
                        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Sending %d messages with no compression to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)messages.size()), topicAndPartition})));
                        byteBufferMessageSet = new ByteBufferMessageSet(NoCompressionCodec$.MODULE$, (Seq<Message>)rawMessages);
                    } else {
                        ByteBufferMessageSet byteBufferMessageSet2;
                        int n = $this.config.compressedTopics().size();
                        switch (n) {
                            case 0: {
                                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Sending %d messages with compression codec %d to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)messages.size()), BoxesRunTime.boxToInteger((int)$this.config.compressionCodec().codec()), topicAndPartition})));
                                byteBufferMessageSet2 = new ByteBufferMessageSet($this.config.compressionCodec(), (Seq<Message>)rawMessages);
                                break;
                            }
                            default: {
                                if ($this.config.compressedTopics().contains((Object)topicAndPartition.topic())) {
                                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Sending %d messages with compression codec %d to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)messages.size()), BoxesRunTime.boxToInteger((int)$this.config.compressionCodec().codec()), topicAndPartition})));
                                    byteBufferMessageSet2 = new ByteBufferMessageSet($this.config.compressionCodec(), (Seq<Message>)rawMessages);
                                    break;
                                }
                                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Sending %d messages to %s with no compression as it is not in compressed.topics - %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)messages.size()), topicAndPartition, $this.config.compressedTopics().toString()})));
                                byteBufferMessageSet2 = new ByteBufferMessageSet(NoCompressionCodec$.MODULE$, (Seq<Message>)rawMessages);
                                break;
                            }
                        }
                        byteBufferMessageSet = byteBufferMessageSet2;
                    }
                } else {
                    throw new MatchError((Object)tuple2);
                }
                Tuple2 tuple22 = new Tuple2((Object)topicAndPartition, (Object)byteBufferMessageSet);
                return tuple22;
            }, Map$.MODULE$.canBuildFrom());
            none$ = new Some((Object)messagesPerTopicPartition);
        }
        catch (Throwable t) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to group messages", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
            none$ = None$.MODULE$;
        }
        return none$;
    }

    @Override
    public void close() {
        block0: {
            if (this.producerPool() == null) break block0;
            this.producerPool().close();
        }
    }

    public static final /* synthetic */ void $anonfun$handle$1(DefaultEventHandler $this, KeyedMessage keyed) {
        int dataSize = ((Message)keyed.message()).payloadSize();
        $this.producerTopicStats().getProducerTopicStats(keyed.topic()).byteRate().mark((long)dataSize);
        $this.producerTopicStats().getProducerAllTopicsStats().byteRate().mark((long)dataSize);
    }

    public static final /* synthetic */ boolean $anonfun$dispatchSerializedData$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$dispatchSerializedData$5(ArrayBuffer failedProduceRequests$1, scala.collection.mutable.Map messagesPerBrokerMap$1, TopicAndPartition topicPartition) {
        messagesPerBrokerMap$1.get((Object)topicPartition).foreach((Function1 & Serializable & scala.Serializable)xs -> {
            failedProduceRequests$1.appendAll(xs);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ void $anonfun$dispatchSerializedData$2(DefaultEventHandler $this, ArrayBuffer failedProduceRequests$1, Tuple2 x$4) {
        Option<scala.collection.mutable.Map<TopicAndPartition, ByteBufferMessageSet>> messageSetPerBrokerOpt;
        Option<scala.collection.mutable.Map<TopicAndPartition, ByteBufferMessageSet>> option;
        Tuple2 tuple2 = x$4;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        int brokerid = tuple2._1$mcI$sp();
        scala.collection.mutable.Map messagesPerBrokerMap = (scala.collection.mutable.Map)tuple2._2();
        if ($this.isTraceEnabled()) {
            messagesPerBrokerMap.foreach((Function1 & Serializable & scala.Serializable)partitionAndEvent -> {
                $this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Handling event for Topic: %s, Broker: %d, Partitions: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partitionAndEvent._1(), BoxesRunTime.boxToInteger((int)brokerid$1), partitionAndEvent._2()})));
                return BoxedUnit.UNIT;
            });
        }
        if ((option = (messageSetPerBrokerOpt = $this.groupMessagesToSet(messagesPerBrokerMap))) instanceof Some) {
            Some some = (Some)option;
            scala.collection.mutable.Map messageSetPerBroker = (scala.collection.mutable.Map)some.value();
            Seq<TopicAndPartition> failedTopicPartitions = $this.send(brokerid, (scala.collection.mutable.Map<TopicAndPartition, ByteBufferMessageSet>)messageSetPerBroker);
            failedTopicPartitions.foreach((Function1 & Serializable & scala.Serializable)topicPartition -> {
                DefaultEventHandler.$anonfun$dispatchSerializedData$5(failedProduceRequests$1, messagesPerBrokerMap, topicPartition);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            if (!None$.MODULE$.equals(option)) throw new MatchError(option);
            messagesPerBrokerMap.values().foreach((Function1 & Serializable & scala.Serializable)m -> {
                failedProduceRequests$1.appendAll((TraversableOnce)m);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$partitionAndCollate$1(DefaultEventHandler $this, HashMap ret$1, KeyedMessage message) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        Seq<PartitionAndLeader> topicPartitionsList = $this.getPartitionListForTopic(message);
        int partitionIndex = $this.getPartition(message.topic(), message.partitionKey(), topicPartitionsList);
        PartitionAndLeader brokerPartition = (PartitionAndLeader)topicPartitionsList.apply(partitionIndex);
        int leaderBrokerId = BoxesRunTime.unboxToInt((Object)brokerPartition.leaderBrokerIdOpt().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> -1));
        HashMap dataPerBroker = null;
        Option option = ret$1.get((Object)BoxesRunTime.boxToInteger((int)leaderBrokerId));
        if (option instanceof Some) {
            Some some = (Some)option;
            scala.collection.mutable.Map element = (scala.collection.mutable.Map)some.value();
            dataPerBroker = (HashMap)element;
            boxedUnit2 = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            dataPerBroker = new HashMap();
            boxedUnit2 = ret$1.put((Object)BoxesRunTime.boxToInteger((int)leaderBrokerId), (Object)dataPerBroker);
        } else {
            throw new MatchError((Object)option);
        }
        TopicAndPartition topicAndPartition = new TopicAndPartition(message.topic(), brokerPartition.partitionId());
        ArrayBuffer dataPerTopicPartition = null;
        Option option2 = dataPerBroker.get((Object)topicAndPartition);
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            Seq element = (Seq)some.value();
            dataPerTopicPartition = (ArrayBuffer)element;
            boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option2)) {
            dataPerTopicPartition = new ArrayBuffer();
            boxedUnit = dataPerBroker.put((Object)topicAndPartition, (Object)dataPerTopicPartition);
        } else {
            throw new MatchError((Object)option2);
        }
        dataPerTopicPartition.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{message}));
    }

    public static final /* synthetic */ boolean $anonfun$getPartition$1(PartitionAndLeader x$5) {
        return x$5.leaderBrokerIdOpt().isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$send$4(Tuple2 x$6) {
        Errors errors = ((ProducerResponseStatus)x$6._2()).error();
        Errors errors2 = Errors.NONE;
        return !(errors != null ? !((Object)((Object)errors)).equals((Object)errors2) : errors2 != null);
    }

    public static final /* synthetic */ void $anonfun$send$5(DefaultEventHandler $this, scala.collection.mutable.Map messagesPerTopic$1, Tuple2 m) {
        ((IterableLike)messagesPerTopic$1.apply(m._1())).foreach((Function1 & Serializable & scala.Serializable)message -> {
            $this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Successfully sent message: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{message.message().isNull() ? null : message.message().toString()})));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$send$8(Tuple2 x$7) {
        Errors errors = ((ProducerResponseStatus)x$7._2()).error();
        Errors errors2 = Errors.NONE;
        return errors == null ? errors2 != null : !((Object)((Object)errors)).equals((Object)errors2);
    }

    public static final /* synthetic */ boolean $anonfun$send$10(Tuple2 p1, Tuple2 p2) {
        return ((TopicAndPartition)p1._1()).topic().compareTo(((TopicAndPartition)p2._1()).topic()) < 0 || ((TopicAndPartition)p1._1()).topic().compareTo(((TopicAndPartition)p2._1()).topic()) == 0 && ((TopicAndPartition)p1._1()).partition() < ((TopicAndPartition)p2._1()).partition();
    }

    public DefaultEventHandler(ProducerConfig config, Partitioner partitioner, Encoder<V> encoder, Encoder<K> keyEncoder, ProducerPool producerPool, HashMap<String, TopicMetadata> topicPartitionInfos, Time time) {
        this.config = config;
        this.partitioner = partitioner;
        this.encoder = encoder;
        this.keyEncoder = keyEncoder;
        this.producerPool = producerPool;
        this.topicPartitionInfos = topicPartitionInfos;
        this.time = time;
        Logging.$init$(this);
        this.isSync = "sync".equals(config.producerType());
        this.correlationId = new AtomicInteger(0);
        this.brokerPartitionInfo = new BrokerPartitionInfo(config, producerPool, topicPartitionInfos);
        this.topicMetadataRefreshInterval = config.topicMetadataRefreshIntervalMs();
        this.lastTopicMetadataRefreshTime = 0L;
        this.topicMetadataToRefresh = Set$.MODULE$.empty();
        this.sendPartitionPerTopicCache = HashMap$.MODULE$.empty();
        this.producerStats = ProducerStatsRegistry$.MODULE$.getProducerStats(config.clientId());
        this.producerTopicStats = ProducerTopicStatsRegistry$.MODULE$.getProducerTopicStats(config.clientId());
    }
}

