/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.producer;

import com.typesafe.scalalogging.Logger;
import io.confluent.kafka.common.Config;
import io.confluent.kafka.common.InvalidConfigException;
import io.confluent.kafka.producer.ProducerConfig;
import io.confluent.kafka.utils.Logging;
import scala.Function0;
import scala.runtime.BoxedUnit;

public final class ProducerConfig$
implements Config {
    public static ProducerConfig$ MODULE$;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new ProducerConfig$();
    }

    @Override
    public void validateChars(String prop, String value) {
        Config.validateChars$(this, prop, value);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        ProducerConfig$ producerConfig$ = this;
        synchronized (producerConfig$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public void validate(ProducerConfig config) {
        this.validateClientId(config.clientId());
        this.validateBatchSize(config.batchNumMessages(), config.queueBufferingMaxMessages());
        this.validateProducerType(config.producerType());
    }

    public void validateClientId(String clientId) {
        this.validateChars("client.id", clientId);
    }

    public void validateBatchSize(int batchSize, int queueSize) {
        if (batchSize > queueSize) {
            throw new InvalidConfigException("Batch size = " + batchSize + " can't be larger than queue size = " + queueSize);
        }
    }

    public void validateProducerType(String producerType) {
        String string = producerType;
        if ("sync".equals(string)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("async".equals(string)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new InvalidConfigException("Invalid value " + producerType + " for producer.type, valid values are sync/async");
        }
    }

    private ProducerConfig$() {
        MODULE$ = this;
        Logging.$init$(this);
        Config.$init$(this);
    }
}

