/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.producer;

import com.typesafe.scalalogging.Logger;
import io.confluent.kafka.common.AppInfo$;
import io.confluent.kafka.common.QueueFullException;
import io.confluent.kafka.metrics.KafkaMetricsGroup$;
import io.confluent.kafka.metrics.KafkaMetricsReporter$;
import io.confluent.kafka.producer.KeyedMessage;
import io.confluent.kafka.producer.Partitioner;
import io.confluent.kafka.producer.ProducerClosedException;
import io.confluent.kafka.producer.ProducerConfig;
import io.confluent.kafka.producer.ProducerPool;
import io.confluent.kafka.producer.ProducerTopicStats;
import io.confluent.kafka.producer.ProducerTopicStatsRegistry$;
import io.confluent.kafka.producer.async.DefaultEventHandler;
import io.confluent.kafka.producer.async.DefaultEventHandler$;
import io.confluent.kafka.producer.async.EventHandler;
import io.confluent.kafka.producer.async.ProducerSendThread;
import io.confluent.kafka.serializer.Encoder;
import io.confluent.kafka.utils.CoreUtils$;
import io.confluent.kafka.utils.Logging;
import java.io.Serializable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dd\u0001B\u0001\u0003\u0001\u001d\u0011\u0001\u0002\u0015:pIV\u001cWM\u001d\u0006\u0003\u0007\u0011\t\u0001\u0002\u001d:pIV\u001cWM\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u0001Qc\u0001\u0005*gM\u0019\u0001!C\b\u0011\u0005)iQ\"A\u0006\u000b\u00031\tQa]2bY\u0006L!AD\u0006\u0003\r\u0005s\u0017PU3g!\t\u00012#D\u0001\u0012\u0015\t\u0011B!A\u0003vi&d7/\u0003\u0002\u0015#\t9Aj\\4hS:<\u0007\u0002\u0003\f\u0001\u0005\u000b\u0007I\u0011A\f\u0002\r\r|gNZ5h+\u0005A\u0002CA\r\u001b\u001b\u0005\u0011\u0011BA\u000e\u0003\u00059\u0001&o\u001c3vG\u0016\u00148i\u001c8gS\u001eD\u0001\"\b\u0001\u0003\u0002\u0003\u0006I\u0001G\u0001\bG>tg-[4!\u0011!y\u0002A!b\u0001\n\u0013\u0001\u0013\u0001D3wK:$\b*\u00198eY\u0016\u0014X#A\u0011\u0011\t\t*sEM\u0007\u0002G)\u0011AEA\u0001\u0006CNLhnY\u0005\u0003M\r\u0012A\"\u0012<f]RD\u0015M\u001c3mKJ\u0004\"\u0001K\u0015\r\u0001\u0011)!\u0006\u0001b\u0001W\t\t1*\u0005\u0002-_A\u0011!\"L\u0005\u0003]-\u0011qAT8uQ&tw\r\u0005\u0002\u000ba%\u0011\u0011g\u0003\u0002\u0004\u0003:L\bC\u0001\u00154\t\u0015!\u0004A1\u0001,\u0005\u00051\u0006\u0002\u0003\u001c\u0001\u0005\u0003\u0005\u000b\u0011B\u0011\u0002\u001b\u00154XM\u001c;IC:$G.\u001a:!\u0011\u0015A\u0004\u0001\"\u0001:\u0003\u0019a\u0014N\\5u}Q\u0019!h\u000f\u001f\u0011\te\u0001qE\r\u0005\u0006-]\u0002\r\u0001\u0007\u0005\u0006?]\u0002\r!\t\u0005\b}\u0001\u0011\r\u0011\"\u0003@\u0003-A\u0017m]*ikR$wn\u001e8\u0016\u0003\u0001\u0003\"!\u0011&\u000e\u0003\tS!a\u0011#\u0002\r\u0005$x.\\5d\u0015\t)e)\u0001\u0006d_:\u001cWO\u001d:f]RT!a\u0012%\u0002\tU$\u0018\u000e\u001c\u0006\u0002\u0013\u0006!!.\u0019<b\u0013\tY%IA\u0007Bi>l\u0017n\u0019\"p_2,\u0017M\u001c\u0005\u0007\u001b\u0002\u0001\u000b\u0011\u0002!\u0002\u0019!\f7o\u00155vi\u0012|wO\u001c\u0011\t\u000f=\u0003!\u0019!C\u0005!\u0006)\u0011/^3vKV\t\u0011\u000bE\u0002S'Vk\u0011\u0001R\u0005\u0003)\u0012\u00131\u0003T5oW\u0016$'\t\\8dW&tw-U;fk\u0016\u0004B!\u0007,(e%\u0011qK\u0001\u0002\r\u0017\u0016LX\rZ'fgN\fw-\u001a\u0005\u00073\u0002\u0001\u000b\u0011B)\u0002\rE,X-^3!\u0011\u001dY\u0006\u00011A\u0005\nq\u000bAa]=oGV\tQ\f\u0005\u0002\u000b=&\u0011ql\u0003\u0002\b\u0005>|G.Z1o\u0011\u001d\t\u0007\u00011A\u0005\n\t\f\u0001b]=oG~#S-\u001d\u000b\u0003G\u001a\u0004\"A\u00033\n\u0005\u0015\\!\u0001B+oSRDqa\u001a1\u0002\u0002\u0003\u0007Q,A\u0002yIEBa!\u001b\u0001!B\u0013i\u0016!B:z]\u000e\u0004\u0003bB6\u0001\u0001\u0004%I\u0001\\\u0001\u0013aJ|G-^2feN+g\u000e\u001a+ie\u0016\fG-F\u0001n!\u0011\u0011cn\n\u001a\n\u0005=\u001c#A\u0005)s_\u0012,8-\u001a:TK:$G\u000b\u001b:fC\u0012Dq!\u001d\u0001A\u0002\u0013%!/\u0001\fqe>$WoY3s'\u0016tG\r\u00165sK\u0006$w\fJ3r)\t\u00197\u000fC\u0004ha\u0006\u0005\t\u0019A7\t\rU\u0004\u0001\u0015)\u0003n\u0003M\u0001(o\u001c3vG\u0016\u00148+\u001a8e)\"\u0014X-\u00193!\u0011\u001d9\bA1A\u0005\na\fA\u0001\\8dWV\t\u0011\u0010\u0005\u0002{{6\t1P\u0003\u0002}\u0011\u0006!A.\u00198h\u0013\tq8P\u0001\u0004PE*,7\r\u001e\u0005\b\u0003\u0003\u0001\u0001\u0015!\u0003z\u0003\u0015awnY6!\u0011%\t)\u0001\u0001b\u0001\n\u0013\t9!\u0001\nqe>$WoY3s)>\u0004\u0018nY*uCR\u001cXCAA\u0005!\rI\u00121B\u0005\u0004\u0003\u001b\u0011!A\u0005)s_\u0012,8-\u001a:U_BL7m\u0015;biND\u0001\"!\u0005\u0001A\u0003%\u0011\u0011B\u0001\u0014aJ|G-^2feR{\u0007/[2Ti\u0006$8\u000f\t\u0005\u0007q\u0001!\t!!\u0006\u0015\u0007i\n9\u0002\u0003\u0004\u0017\u0003'\u0001\r\u0001\u0007\u0005\b\u00037\u0001A\u0011AA\u000f\u0003\u0011\u0019XM\u001c3\u0015\u0007\r\fy\u0002\u0003\u0005\u0002\"\u0005e\u0001\u0019AA\u0012\u0003!iWm]:bO\u0016\u001c\b\u0003\u0002\u0006\u0002&UK1!a\n\f\u0005)a$/\u001a9fCR,GM\u0010\u0005\b\u0003W\u0001A\u0011BA\u0017\u0003-\u0011XmY8sIN#\u0018\r^:\u0015\u0007\r\fy\u0003\u0003\u0005\u0002\"\u0005%\u0002\u0019AA\u0019!\u0015\t\u0019$a\u0011V\u001d\u0011\t)$a\u0010\u000f\t\u0005]\u0012QH\u0007\u0003\u0003sQ1!a\u000f\u0007\u0003\u0019a$o\\8u}%\tA\"C\u0002\u0002B-\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002F\u0005\u001d#aA*fc*\u0019\u0011\u0011I\u0006\t\u000f\u0005-\u0003\u0001\"\u0003\u0002N\u0005I\u0011m]=oGN+g\u000e\u001a\u000b\u0004G\u0006=\u0003\u0002CA\u0011\u0003\u0013\u0002\r!!\r\t\u000f\u0005M\u0003\u0001\"\u0001\u0002V\u0005)1\r\\8tKR\t1\rK\u0004\u0001\u00033\ny&a\u0019\u0011\u0007)\tY&C\u0002\u0002^-\u0011!\u0002Z3qe\u0016\u001c\u0017\r^3eC\t\t\t'AA\f)\"L7\u000fI2mCN\u001c\b\u0005[1tA\t,WM\u001c\u0011eKB\u0014XmY1uK\u0012\u0004\u0013M\u001c3!o&dG\u000e\t2fAI,Wn\u001c<fI\u0002Jg\u000eI1!MV$XO]3!e\u0016dW-Y:f]\u0001\u0002F.Z1tK\u0002*8/\u001a\u0011pe\u001et\u0013\r]1dQ\u0016t3.\u00194lC:\u001aG.[3oiNt\u0003O]8ek\u000e,'OL&bM.\f\u0007K]8ek\u000e,'\u000fI5ogR,\u0017\r\u001a\u0018\"\u0005\u0005\u0015\u0014\u0001\u0003\u0019/cAr\u0003G\f\u0019")
public class Producer<K, V>
implements Logging {
    private final ProducerConfig config;
    private final EventHandler<K, V> eventHandler;
    private final AtomicBoolean hasShutdown;
    private final LinkedBlockingQueue<KeyedMessage<K, V>> queue;
    private boolean sync;
    private ProducerSendThread<K, V> producerSendThread;
    private final Object lock;
    private final ProducerTopicStats producerTopicStats;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        Producer producer = this;
        synchronized (producer) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public ProducerConfig config() {
        return this.config;
    }

    private EventHandler<K, V> eventHandler() {
        return this.eventHandler;
    }

    private AtomicBoolean hasShutdown() {
        return this.hasShutdown;
    }

    private LinkedBlockingQueue<KeyedMessage<K, V>> queue() {
        return this.queue;
    }

    private boolean sync() {
        return this.sync;
    }

    private void sync_$eq(boolean x$1) {
        this.sync = x$1;
    }

    private ProducerSendThread<K, V> producerSendThread() {
        return this.producerSendThread;
    }

    private void producerSendThread_$eq(ProducerSendThread<K, V> x$1) {
        this.producerSendThread = x$1;
    }

    private Object lock() {
        return this.lock;
    }

    private ProducerTopicStats producerTopicStats() {
        return this.producerTopicStats;
    }

    public void send(Seq<KeyedMessage<K, V>> messages) {
        Object object = this.lock();
        synchronized (object) {
            if (this.hasShutdown().get()) {
                throw new ProducerClosedException();
            }
            this.recordStats(messages);
            if (this.sync()) {
                this.eventHandler().handle(messages);
            } else {
                this.asyncSend(messages);
            }
        }
    }

    private void recordStats(Seq<KeyedMessage<K, V>> messages) {
        messages.foreach((Function1 & Serializable & scala.Serializable)message -> {
            Producer.$anonfun$recordStats$1(this, message);
            return BoxedUnit.UNIT;
        });
    }

    private void asyncSend(Seq<KeyedMessage<K, V>> messages) {
        messages.foreach((Function1 & Serializable & scala.Serializable)message -> {
            Producer.$anonfun$asyncSend$1(this, message);
            return BoxedUnit.UNIT;
        });
    }

    public void close() {
        Object object = this.lock();
        synchronized (object) {
            boolean canShutdown = this.hasShutdown().compareAndSet(false, true);
            if (canShutdown) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutting down producer");
                long startTime = System.nanoTime();
                KafkaMetricsGroup$.MODULE$.removeAllProducerMetrics(this.config().clientId());
                if (this.producerSendThread() != null) {
                    this.producerSendThread().shutdown();
                }
                this.eventHandler().close();
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Producer shutdown completed in " + (System.nanoTime() - startTime) / 1000000L + " ms");
            }
        }
    }

    public static final /* synthetic */ void $anonfun$recordStats$1(Producer $this, KeyedMessage message) {
        $this.producerTopicStats().getProducerTopicStats(message.topic()).messageRate().mark();
        $this.producerTopicStats().getProducerAllTopicsStats().messageRate().mark();
    }

    public static final /* synthetic */ void $anonfun$asyncSend$1(Producer $this, KeyedMessage message) {
        boolean bl;
        int n = $this.config().queueEnqueueTimeoutMs();
        switch (n) {
            case 0: {
                bl = $this.queue().offer(message);
                break;
            }
            default: {
                try {
                    if ($this.config().queueEnqueueTimeoutMs() < 0) {
                        $this.queue().put(message);
                        bl = true;
                        break;
                    }
                    bl = $this.queue().offer(message, $this.config().queueEnqueueTimeoutMs(), TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException interruptedException) {
                    bl = false;
                }
                break;
            }
        }
        boolean added = bl;
        if (!added) {
            $this.producerTopicStats().getProducerTopicStats(message.topic()).droppedMessageRate().mark();
            $this.producerTopicStats().getProducerAllTopicsStats().droppedMessageRate().mark();
            throw new QueueFullException("Event queue is full of unsent messages, could not send event: " + message.toString());
        }
        $this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Added to send queue an event: " + message.toString());
        $this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Remaining queue size: " + $this.queue().remainingCapacity());
    }

    public Producer(ProducerConfig config, EventHandler<K, V> eventHandler) {
        this.config = config;
        this.eventHandler = eventHandler;
        Logging.$init$(this);
        this.hasShutdown = new AtomicBoolean(false);
        this.queue = new LinkedBlockingQueue(config.queueBufferingMaxMessages());
        this.sync = true;
        this.producerSendThread = null;
        this.lock = new Object();
        String string = config.producerType();
        if ("sync".equals(string)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("async".equals(string)) {
            this.sync_$eq(false);
            this.producerSendThread_$eq(new ProducerSendThread<K, V>("ProducerSendThread-" + config.clientId(), this.queue(), eventHandler, config.queueBufferingMaxMs(), config.batchNumMessages(), config.clientId()));
            this.producerSendThread().start();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)string);
        }
        this.producerTopicStats = ProducerTopicStatsRegistry$.MODULE$.getProducerTopicStats(config.clientId());
        KafkaMetricsReporter$.MODULE$.startReporters(config.props());
        AppInfo$.MODULE$.registerInfo();
    }

    public Producer(ProducerConfig config) {
        this(config, new DefaultEventHandler(config, (Partitioner)CoreUtils$.MODULE$.createObject(config.partitionerClass(), (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{config.props()})), (Encoder)CoreUtils$.MODULE$.createObject(config.serializerClass(), (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{config.props()})), (Encoder)CoreUtils$.MODULE$.createObject(config.keySerializerClass(), (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{config.props()})), new ProducerPool(config), DefaultEventHandler$.MODULE$.$lessinit$greater$default$6(), DefaultEventHandler$.MODULE$.$lessinit$greater$default$7()));
    }
}

