/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.log;

import com.typesafe.scalalogging.Logger;
import io.confluent.kafka.log.AbortedTxn;
import io.confluent.kafka.log.CompletedTxn;
import io.confluent.kafka.log.LogConfig;
import io.confluent.kafka.log.LogFlushStats$;
import io.confluent.kafka.log.LogSegment$;
import io.confluent.kafka.log.OffsetIndex;
import io.confluent.kafka.log.OffsetPosition;
import io.confluent.kafka.log.ProducerAppendInfo;
import io.confluent.kafka.log.ProducerStateManager;
import io.confluent.kafka.log.TimeIndex;
import io.confluent.kafka.log.TimestampOffset;
import io.confluent.kafka.log.TransactionIndex;
import io.confluent.kafka.log.TxnIndexSearchResult;
import io.confluent.kafka.server.FetchDataInfo;
import io.confluent.kafka.server.FetchDataInfo$;
import io.confluent.kafka.server.LogOffsetMetadata;
import io.confluent.kafka.server.epoch.LeaderEpochCache;
import io.confluent.kafka.utils.CoreUtils$;
import io.confluent.kafka.utils.Logging;
import io.confluent.org.apache.kafka.common.errors.CorruptRecordException;
import io.confluent.org.apache.kafka.common.record.FileLogInputStream;
import io.confluent.org.apache.kafka.common.record.FileRecords;
import io.confluent.org.apache.kafka.common.record.MemoryRecords;
import io.confluent.org.apache.kafka.common.record.RecordBatch;
import io.confluent.org.apache.kafka.common.utils.Time;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.Iterator;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\r\u0005g\u0001B\u0001\u0003\u0001\u001d\u0011!\u0002T8h'\u0016<W.\u001a8u\u0015\t\u0019A!A\u0002m_\u001eT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001\u0001B\u0004\t\u0003\u00131i\u0011A\u0003\u0006\u0002\u0017\u0005)1oY1mC&\u0011QB\u0003\u0002\u0007\u0003:L(+\u001a4\u0011\u0005=\u0011R\"\u0001\t\u000b\u0005E!\u0011!B;uS2\u001c\u0018BA\n\u0011\u0005\u001daunZ4j]\u001eD\u0001b\u0001\u0001\u0003\u0006\u0004%\t!F\u000b\u0002-A\u0011q#I\u0007\u00021)\u0011\u0011DG\u0001\u0007e\u0016\u001cwN\u001d3\u000b\u0005ma\u0012AB2p[6|gN\u0003\u0002\u0006;)\u0011adH\u0001\u0007CB\f7\r[3\u000b\u0003\u0001\n1a\u001c:h\u0013\t\u0011\u0003DA\u0006GS2,'+Z2pe\u0012\u001c\b\u0002\u0003\u0013\u0001\u0005\u0003\u0005\u000b\u0011\u0002\f\u0002\t1|w\r\t\u0005\tM\u0001\u0011)\u0019!C\u0001O\u0005YqN\u001a4tKRLe\u000eZ3y+\u0005A\u0003CA\u0015+\u001b\u0005\u0011\u0011BA\u0016\u0003\u0005-yeMZ:fi&sG-\u001a=\t\u00115\u0002!\u0011!Q\u0001\n!\nAb\u001c4gg\u0016$\u0018J\u001c3fq\u0002B\u0001b\f\u0001\u0003\u0006\u0004%\t\u0001M\u0001\ni&lW-\u00138eKb,\u0012!\r\t\u0003SIJ!a\r\u0002\u0003\u0013QKW.Z%oI\u0016D\b\u0002C\u001b\u0001\u0005\u0003\u0005\u000b\u0011B\u0019\u0002\u0015QLW.Z%oI\u0016D\b\u0005\u0003\u00058\u0001\t\u0015\r\u0011\"\u00019\u0003!!\bP\\%oI\u0016DX#A\u001d\u0011\u0005%R\u0014BA\u001e\u0003\u0005A!&/\u00198tC\u000e$\u0018n\u001c8J]\u0012,\u0007\u0010\u0003\u0005>\u0001\t\u0005\t\u0015!\u0003:\u0003%!\bP\\%oI\u0016D\b\u0005\u0003\u0005@\u0001\t\u0015\r\u0011\"\u0001A\u0003)\u0011\u0017m]3PM\u001a\u001cX\r^\u000b\u0002\u0003B\u0011\u0011BQ\u0005\u0003\u0007*\u0011A\u0001T8oO\"AQ\t\u0001B\u0001B\u0003%\u0011)A\u0006cCN,wJ\u001a4tKR\u0004\u0003\u0002C$\u0001\u0005\u000b\u0007I\u0011\u0001%\u0002%%tG-\u001a=J]R,'O^1m\u0005f$Xm]\u000b\u0002\u0013B\u0011\u0011BS\u0005\u0003\u0017*\u00111!\u00138u\u0011!i\u0005A!A!\u0002\u0013I\u0015aE5oI\u0016D\u0018J\u001c;feZ\fGNQ=uKN\u0004\u0003\u0002C(\u0001\u0005\u000b\u0007I\u0011\u0001!\u0002\u0019I|G\u000e\u001c&jiR,'/T:\t\u0011E\u0003!\u0011!Q\u0001\n\u0005\u000bQB]8mY*KG\u000f^3s\u001bN\u0004\u0003\u0002C*\u0001\u0005\u000b\u0007I\u0011\u0001!\u0002\u00195\f\u0007pU3h[\u0016tG/T:\t\u0011U\u0003!\u0011!Q\u0001\n\u0005\u000bQ\"\\1y'\u0016<W.\u001a8u\u001bN\u0004\u0003\u0002C,\u0001\u0005\u000b\u0007I\u0011\u0001%\u0002\u001f5\f\u0007pU3h[\u0016tGOQ=uKND\u0001\"\u0017\u0001\u0003\u0002\u0003\u0006I!S\u0001\u0011[\u0006D8+Z4nK:$()\u001f;fg\u0002B\u0001b\u0017\u0001\u0003\u0006\u0004%\t\u0001X\u0001\u0005i&lW-F\u0001^!\tq\u0006-D\u0001`\u0015\t\t\"$\u0003\u0002b?\n!A+[7f\u0011!\u0019\u0007A!A!\u0002\u0013i\u0016!\u0002;j[\u0016\u0004\u0003BB3\u0001\t\u0003\u0011a-\u0001\u0004=S:LGO\u0010\u000b\fO\"L'n\u001b7n]>\u0004\u0018\u000f\u0005\u0002*\u0001!)1\u0001\u001aa\u0001-!)a\u0005\u001aa\u0001Q!)q\u0006\u001aa\u0001c!)q\u0007\u001aa\u0001s!)q\b\u001aa\u0001\u0003\")q\t\u001aa\u0001\u0013\")q\n\u001aa\u0001\u0003\")1\u000b\u001aa\u0001\u0003\")q\u000b\u001aa\u0001\u0013\")1\f\u001aa\u0001;\")1\u000f\u0001C\u0001i\u0006Q1\u000f[8vY\u0012\u0014v\u000e\u001c7\u0015\u000bUD(\u0010 @\u0011\u0005%1\u0018BA<\u000b\u0005\u001d\u0011un\u001c7fC:DQ!\u001f:A\u0002%\u000bA\"\\3tg\u0006<Wm]*ju\u0016DQa\u001f:A\u0002\u0005\u000ba#\\1y)&lWm\u001d;b[BLe.T3tg\u0006<Wm\u001d\u0005\u0006{J\u0004\r!Q\u0001\u0014[\u0006DxJ\u001a4tKRLe.T3tg\u0006<Wm\u001d\u0005\u0006\u007fJ\u0004\r!Q\u0001\u0004]><\bbBA\u0002\u0001\u0011\u0005\u0011QA\u0001\u000ee\u0016\u001c\u0018N_3J]\u0012,\u00070Z:\u0015\t\u0005\u001d\u0011Q\u0002\t\u0004\u0013\u0005%\u0011bAA\u0006\u0015\t!QK\\5u\u0011\u001d\ty!!\u0001A\u0002%\u000bAa]5{K\"9\u00111\u0003\u0001\u0005\u0002\u0005U\u0011aC:b]&$\u0018p\u00115fG.$B!a\u0002\u0002\u0018!9\u0011\u0011DA\t\u0001\u0004)\u0018!\u0007;j[\u0016Le\u000eZ3y\r&dWMT3xYf\u001c%/Z1uK\u0012D\u0001\"!\b\u0001\u0001\u0004%I\u0001Q\u0001\bGJ,\u0017\r^3e\u0011%\t\t\u0003\u0001a\u0001\n\u0013\t\u0019#A\u0006de\u0016\fG/\u001a3`I\u0015\fH\u0003BA\u0004\u0003KA\u0011\"a\n\u0002 \u0005\u0005\t\u0019A!\u0002\u0007a$\u0013\u0007C\u0004\u0002,\u0001\u0001\u000b\u0015B!\u0002\u0011\r\u0014X-\u0019;fI\u0002B\u0001\"a\f\u0001\u0001\u0004%I\u0001S\u0001\u0019Ef$Xm]*j]\u000e,G*Y:u\u0013:$W\r_#oiJL\b\"CA\u001a\u0001\u0001\u0007I\u0011BA\u001b\u0003q\u0011\u0017\u0010^3t'&t7-\u001a'bgRLe\u000eZ3y\u000b:$(/_0%KF$B!a\u0002\u00028!I\u0011qEA\u0019\u0003\u0003\u0005\r!\u0013\u0005\b\u0003w\u0001\u0001\u0015)\u0003J\u0003e\u0011\u0017\u0010^3t'&t7-\u001a'bgRLe\u000eZ3y\u000b:$(/\u001f\u0011\t\u0013\u0005}\u0002\u00011A\u0005\n\u0005\u0005\u0013!\u0006:pY2Lgn\u001a\"bg\u0016$G+[7fgR\fW\u000e]\u000b\u0003\u0003\u0007\u0002B!CA#\u0003&\u0019\u0011q\t\u0006\u0003\r=\u0003H/[8o\u0011%\tY\u0005\u0001a\u0001\n\u0013\ti%A\rs_2d\u0017N\\4CCN,G\rV5nKN$\u0018-\u001c9`I\u0015\fH\u0003BA\u0004\u0003\u001fB!\"a\n\u0002J\u0005\u0005\t\u0019AA\"\u0011!\t\u0019\u0006\u0001Q!\n\u0005\r\u0013A\u0006:pY2Lgn\u001a\"bg\u0016$G+[7fgR\fW\u000e\u001d\u0011\t\u0011\u0005]\u0003\u00011A\u0005\n\u0001\u000b\u0011#\\1y)&lWm\u001d;b[B\u001cvNR1s\u0011%\tY\u0006\u0001a\u0001\n\u0013\ti&A\u000bnCb$\u0016.\\3ti\u0006l\u0007oU8GCJ|F%Z9\u0015\t\u0005\u001d\u0011q\f\u0005\n\u0003O\tI&!AA\u0002\u0005Cq!a\u0019\u0001A\u0003&\u0011)\u0001\nnCb$\u0016.\\3ti\u0006l\u0007oU8GCJ\u0004\u0003\u0006BA1\u0003O\u00022!CA5\u0013\r\tYG\u0003\u0002\tm>d\u0017\r^5mK\"A\u0011q\u000e\u0001A\u0002\u0013%\u0001)\u0001\u000bpM\u001a\u001cX\r^(g\u001b\u0006DH+[7fgR\fW\u000e\u001d\u0005\n\u0003g\u0002\u0001\u0019!C\u0005\u0003k\n\u0001d\u001c4gg\u0016$xJZ'bqRKW.Z:uC6\u0004x\fJ3r)\u0011\t9!a\u001e\t\u0013\u0005\u001d\u0012\u0011OA\u0001\u0002\u0004\t\u0005bBA>\u0001\u0001\u0006K!Q\u0001\u0016_\u001a47/\u001a;PM6\u000b\u0007\u0010V5nKN$\u0018-\u001c9!Q\u0011\tI(a\u001a\t\r\u0005=\u0001\u0001\"\u0001I\u0011\u001d\t\u0019\t\u0001C\u0001\u0003\u000b\u000b!dY1o\u0007>tg/\u001a:u)>\u0014V\r\\1uSZ,wJ\u001a4tKR$2!^AD\u0011\u001d\tI)!!A\u0002\u0005\u000baa\u001c4gg\u0016$\bbBAG\u0001\u0011\u0005\u0011qR\u0001\u0007CB\u0004XM\u001c3\u0015\u0019\u0005\u001d\u0011\u0011SAK\u00033\u000bi*!)\t\u000f\u0005M\u00151\u0012a\u0001\u0003\u0006Ya-\u001b:ti>3gm]3u\u0011\u001d\t9*a#A\u0002\u0005\u000bQ\u0002\\1sO\u0016\u001cHo\u00144gg\u0016$\bbBAN\u0003\u0017\u0003\r!Q\u0001\u0011Y\u0006\u0014x-Z:u)&lWm\u001d;b[BDq!a(\u0002\f\u0002\u0007\u0011)A\u000etQ\u0006dGn\\<PM\u001a\u001cX\r^(g\u001b\u0006DH+[7fgR\fW\u000e\u001d\u0005\t\u0003G\u000bY\t1\u0001\u0002&\u00069!/Z2pe\u0012\u001c\bcA\f\u0002(&\u0019\u0011\u0011\u0016\r\u0003\u001b5+Wn\u001c:z%\u0016\u001cwN\u001d3tQ\u0011\tY)!,\u0011\u0007=\ty+C\u0002\u00022B\u0011QB\\8oi\"\u0014X-\u00193tC\u001a,\u0007bBA[\u0001\u0011\u0005\u0011qW\u0001\u000fkB$\u0017\r^3Uq:Le\u000eZ3y)\u0019\t9!!/\u0002D\"A\u00111XAZ\u0001\u0004\ti,\u0001\u0007d_6\u0004H.\u001a;fIRCh\u000eE\u0002*\u0003\u007fK1!!1\u0003\u00051\u0019u.\u001c9mKR,G\r\u0016=o\u0011\u001d\t)-a-A\u0002\u0005\u000b\u0001\u0003\\1tiN#\u0018M\u00197f\u001f\u001a47/\u001a;)\t\u0005M\u0016Q\u0016\u0005\b\u0003\u0017\u0004A\u0011BAg\u0003M)\b\u000fZ1uKB\u0013x\u000eZ;dKJ\u001cF/\u0019;f)\u0019\t9!a4\u0002Z\"A\u0011\u0011[Ae\u0001\u0004\t\u0019.\u0001\u000bqe>$WoY3s'R\fG/Z'b]\u0006<WM\u001d\t\u0004S\u0005U\u0017bAAl\u0005\t!\u0002K]8ek\u000e,'o\u0015;bi\u0016l\u0015M\\1hKJD\u0001\"a7\u0002J\u0002\u0007\u0011Q\\\u0001\u0006E\u0006$8\r\u001b\t\u0004/\u0005}\u0017bAAq1\tY!+Z2pe\u0012\u0014\u0015\r^2i\u0011!\t)\u000f\u0001C\u0001\u0005\u0005\u001d\u0018a\u0004;sC:\u001cH.\u0019;f\u001f\u001a47/\u001a;\u0015\r\u0005%(\u0011\u0003B\n!\u0011\tYOa\u0003\u000f\t\u00055(q\u0001\b\u0005\u0003_\u0014)A\u0004\u0003\u0002r\n\ra\u0002BAz\u0005\u0003qA!!>\u0002\u0000:!\u0011q_A\u007f\u001b\t\tIPC\u0002\u0002|\u001a\ta\u0001\u0010:p_Rt\u0014\"\u0001\u0011\n\u0005yy\u0012BA\u0003\u001e\u0013\tYB$\u0003\u0002\u001a5%\u0019!\u0011\u0002\r\u0002\u0017\u0019KG.\u001a*fG>\u0014Hm]\u0005\u0005\u0005\u001b\u0011yAA\tM_\u001e|eMZ:fiB{7/\u001b;j_:T1A!\u0003\u0019\u0011\u001d\tI)a9A\u0002\u0005C\u0011B!\u0006\u0002dB\u0005\t\u0019A%\u0002)M$\u0018M\u001d;j]\u001e4\u0015\u000e\\3Q_NLG/[8oQ\u0011\t\u0019O!\u0007\u0011\u0007=\u0011Y\"C\u0002\u0003\u001eA\u0011!\u0002\u001e5sK\u0006$7/\u00194f\u0011\u001d\u0011\t\u0003\u0001C\u0001\u0005G\tAA]3bIRa!Q\u0005B\u0019\u0005k\u0011ID!\u0010\u0003BA!!q\u0005B\u0017\u001b\t\u0011ICC\u0002\u0003,\u0011\taa]3sm\u0016\u0014\u0018\u0002\u0002B\u0018\u0005S\u0011QBR3uG\"$\u0015\r^1J]\u001a|\u0007b\u0002B\u001a\u0005?\u0001\r!Q\u0001\fgR\f'\u000f^(gMN,G\u000f\u0003\u0005\u00038\t}\u0001\u0019AA\"\u0003%i\u0017\r_(gMN,G\u000fC\u0004\u0003<\t}\u0001\u0019A%\u0002\u000f5\f\u0007pU5{K\"I!q\bB\u0010!\u0003\u0005\r!Q\u0001\f[\u0006D\bk\\:ji&|g\u000eC\u0005\u0003D\t}\u0001\u0013!a\u0001k\u0006iQ.\u001b8P]\u0016lUm]:bO\u0016DCAa\b\u0003\u001a!9!\u0011\n\u0001\u0005\u0002\t-\u0013!\u00064fi\u000eDW\u000b\u001d9fe\n{WO\u001c3PM\u001a\u001cX\r\u001e\u000b\u0007\u0003\u0007\u0012iEa\u0016\t\u0011\t=#q\ta\u0001\u0005#\n1c\u001d;beR|eMZ:fiB{7/\u001b;j_:\u00042!\u000bB*\u0013\r\u0011)F\u0001\u0002\u000f\u001f\u001a47/\u001a;Q_NLG/[8o\u0011\u001d\u0011IFa\u0012A\u0002%\u000b\u0011BZ3uG\"\u001c\u0016N_3\t\u000f\tu\u0003\u0001\"\u0001\u0003`\u00059!/Z2pm\u0016\u0014H#B%\u0003b\t\r\u0004\u0002CAi\u00057\u0002\r!a5\t\u0015\t\u0015$1\fI\u0001\u0002\u0004\u00119'\u0001\tmK\u0006$WM]#q_\u000eD7)Y2iKB)\u0011\"!\u0012\u0003jA!!1\u000eB9\u001b\t\u0011iG\u0003\u0003\u0003p\t%\u0012!B3q_\u000eD\u0017\u0002\u0002B:\u0005[\u0012\u0001\u0003T3bI\u0016\u0014X\t]8dQ\u000e\u000b7\r[3)\t\tm\u0013Q\u0016\u0005\b\u0005s\u0002A\u0011\u0002B>\u0003Qaw.\u00193MCJ<Wm\u001d;US6,7\u000f^1naR\u0011\u0011q\u0001\u0005\b\u0005\u007f\u0002A\u0011\u0001BA\u0003I\u0019w\u000e\u001c7fGR\f%m\u001c:uK\u0012$\u0006P\\:\u0015\r\t\r%\u0011\u0012BG!\rI#QQ\u0005\u0004\u0005\u000f\u0013!\u0001\u0006+y]&sG-\u001a=TK\u0006\u00148\r\u001b*fgVdG\u000fC\u0004\u0003\f\nu\u0004\u0019A!\u0002\u0017\u0019,Go\u00195PM\u001a\u001cX\r\u001e\u0005\b\u0005\u001f\u0013i\b1\u0001B\u0003A)\b\u000f]3s\u0005>,h\u000eZ(gMN,G\u000fC\u0004\u0003\u0014\u0002!\tE!&\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"Aa&\u0011\t\te%1U\u0007\u0003\u00057SAA!(\u0003 \u0006!A.\u00198h\u0015\t\u0011\t+\u0001\u0003kCZ\f\u0017\u0002\u0002BS\u00057\u0013aa\u0015;sS:<\u0007b\u0002BU\u0001\u0011\u0005!1V\u0001\u000biJ,hnY1uKR{GcA%\u0003.\"9\u0011\u0011\u0012BT\u0001\u0004\t\u0005\u0006\u0002BT\u0003[CaAa-\u0001\t\u0003\u0001\u0015A\u0004:fC\u0012tU\r\u001f;PM\u001a\u001cX\r\u001e\u0015\u0005\u0005c\u0013I\u0002C\u0004\u0003:\u0002!\tAa\u001f\u0002\u000b\u0019dWo\u001d5)\t\t]&\u0011\u0004\u0005\b\u0005\u007f\u0003A\u0011\u0001Ba\u0003%)\b\u000fZ1uK\u0012K'\u000f\u0006\u0003\u0002\b\t\r\u0007\u0002\u0003Bc\u0005{\u0003\rAa2\u0002\u0007\u0011L'\u000f\u0005\u0003\u0003J\n=WB\u0001Bf\u0015\u0011\u0011iMa(\u0002\u0005%|\u0017\u0002\u0002Bi\u0005\u0017\u0014AAR5mK\"9!Q\u001b\u0001\u0005\u0002\t]\u0017AE2iC:<WMR5mKN+hMZ5yKN$b!a\u0002\u0003Z\n-\b\u0002\u0003Bn\u0005'\u0004\rA!8\u0002\u0013=dGmU;gM&D\b\u0003\u0002Bp\u0005OtAA!9\u0003dB\u0019\u0011q\u001f\u0006\n\u0007\t\u0015(\"\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0005K\u0013IOC\u0002\u0003f*A\u0001B!<\u0003T\u0002\u0007!Q\\\u0001\n]\u0016<8+\u001e4gSbDqA!=\u0001\t\u0003\u0011Y(A\fp]\n+7m\\7f\u0013:\f7\r^5wKN+w-\\3oi\"9!Q\u001f\u0001\u0005\u0002\t]\u0018!\u0005;j[\u0016<\u0016-\u001b;fI\u001a{'OU8mYR)\u0011I!?\u0003|\"1qPa=A\u0002\u0005CqA!@\u0003t\u0002\u0007\u0011)\u0001\tnKN\u001c\u0018mZ3US6,7\u000f^1na\"91\u0011\u0001\u0001\u0005\u0002\r\r\u0011!\u00064j]\u0012|eMZ:fi\nKH+[7fgR\fW\u000e\u001d\u000b\u0007\u0007\u000b\u0019ia!\u0005\u0011\u000b%\t)ea\u0002\u0011\u0007%\u001aI!C\u0002\u0004\f\t\u0011q\u0002V5nKN$\u0018-\u001c9PM\u001a\u001cX\r\u001e\u0005\b\u0007\u001f\u0011y\u00101\u0001B\u0003%!\u0018.\\3ti\u0006l\u0007\u000fC\u0005\u0004\u0014\t}\b\u0013!a\u0001\u0003\u0006q1\u000f^1si&twm\u00144gg\u0016$\bbBB\f\u0001\u0011\u0005!1P\u0001\u0006G2|7/\u001a\u0005\b\u00077\u0001A\u0011\u0001B>\u00035\u0019Gn\\:f\u0011\u0006tG\r\\3sg\"91q\u0004\u0001\u0005\u0002\tm\u0014A\u00043fY\u0016$X-\u00134Fq&\u001cHo\u001d\u0005\u0007\u0007G\u0001A\u0011\u0001!\u0002\u00191\f7\u000f^'pI&4\u0017.\u001a3\t\r\u0005m\u0005\u0001\"\u0001A\u0011\u001d\u0019I\u0003\u0001C\u0001\u0007W\t\u0001\u0003\\1ti6{G-\u001b4jK\u0012|F%Z9\u0015\t\r52Q\b\t\u0005\u0007_\u0019I$\u0004\u0002\u00042)!11GB\u001b\u0003\u00111\u0017\u000e\\3\u000b\t\r]\"qT\u0001\u0004]&|\u0017\u0002BB\u001e\u0007c\u0011A\u0001U1uQ\"91qHB\u0014\u0001\u0004\t\u0015AA7t\u0011%\u0019\u0019\u0005AI\u0001\n\u0003\u0019)%\u0001\bsK\u0006$G\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\r\u001d#fA!\u0004J-\u001211\n\t\u0005\u0007\u001b\u001a9&\u0004\u0002\u0004P)!1\u0011KB*\u0003%)hn\u00195fG.,GMC\u0002\u0004V)\t!\"\u00198o_R\fG/[8o\u0013\u0011\u0019Ifa\u0014\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0005\u0004^\u0001\t\n\u0011\"\u0001\u0004`\u0005q!/Z1eI\u0011,g-Y;mi\u0012*TCAB1U\r)8\u0011\n\u0005\n\u0007K\u0002\u0011\u0013!C\u0001\u0007O\n\u0011C]3d_Z,'\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\u0019IG\u000b\u0003\u0003h\r%\u0003BCB7\u0001E\u0005I\u0011\u0001\u0002\u0004p\u0005IBO]1og2\fG/Z(gMN,G\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\u0019\tHK\u0002J\u0007\u0013B\u0011b!\u001e\u0001#\u0003%\ta!\u0012\u0002?\u0019Lg\u000eZ(gMN,GOQ=US6,7\u000f^1na\u0012\"WMZ1vYR$#\u0007K\u0002\u0001\u0003[;qaa\u001f\u0003\u0011\u0003\u0019i(\u0001\u0006M_\u001e\u001cVmZ7f]R\u00042!KB@\r\u0019\t!\u0001#\u0001\u0004\u0002N\u00191q\u0010\u0005\t\u000f\u0015\u001cy\b\"\u0001\u0004\u0006R\u00111Q\u0010\u0005\t\u0007\u0013\u001by\b\"\u0001\u0004\f\u0006!q\u000e]3o)E97QRBH\u0007#\u001bYj!(\u0004\"\u000e\u00156\u0011\u0016\u0005\t\u0005\u000b\u001c9\t1\u0001\u0003H\"1qha\"A\u0002\u0005C\u0001ba%\u0004\b\u0002\u00071QS\u0001\u0007G>tg-[4\u0011\u0007%\u001a9*C\u0002\u0004\u001a\n\u0011\u0011\u0002T8h\u0007>tg-[4\t\rm\u001b9\t1\u0001^\u0011%\u0019yja\"\u0011\u0002\u0003\u0007Q/A\tgS2,\u0017\t\u001c:fC\u0012LX\t_5tiND\u0011ba)\u0004\bB\u0005\t\u0019A%\u0002\u0019%t\u0017\u000e\u001e$jY\u0016\u001c\u0016N_3\t\u0013\r\u001d6q\u0011I\u0001\u0002\u0004)\u0018a\u00039sK\u0006dGn\\2bi\u0016D!ba+\u0004\bB\u0005\t\u0019\u0001Bo\u0003)1\u0017\u000e\\3Tk\u001a4\u0017\u000e\u001f\u0005\u000b\u0007_\u001by(%A\u0005\u0002\r}\u0013AD8qK:$C-\u001a4bk2$H%\u000e\u0005\u000b\u0007g\u001by(%A\u0005\u0002\r=\u0014AD8qK:$C-\u001a4bk2$HE\u000e\u0005\u000b\u0007o\u001by(%A\u0005\u0002\r}\u0013AD8qK:$C-\u001a4bk2$He\u000e\u0005\u000b\u0007w\u001by(%A\u0005\u0002\ru\u0016AD8qK:$C-\u001a4bk2$H\u0005O\u000b\u0003\u0007\u007fSCA!8\u0004J\u0001")
public class LogSegment
implements Logging {
    private final FileRecords log;
    private final OffsetIndex offsetIndex;
    private final TimeIndex timeIndex;
    private final TransactionIndex txnIndex;
    private final long baseOffset;
    private final int indexIntervalBytes;
    private final long rollJitterMs;
    private final long maxSegmentMs;
    private final int maxSegmentBytes;
    private final Time time;
    private long created;
    private int bytesSinceLastIndexEntry;
    private Option<Object> rollingBasedTimestamp;
    private volatile long maxTimestampSoFar;
    private volatile long offsetOfMaxTimestamp;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static String open$default$8() {
        return LogSegment$.MODULE$.open$default$8();
    }

    public static boolean open$default$7() {
        return LogSegment$.MODULE$.open$default$7();
    }

    public static int open$default$6() {
        return LogSegment$.MODULE$.open$default$6();
    }

    public static boolean open$default$5() {
        return LogSegment$.MODULE$.open$default$5();
    }

    public static LogSegment open(File file, long l, LogConfig logConfig, Time time, boolean bl, int n, boolean bl2, String string) {
        return LogSegment$.MODULE$.open(file, l, logConfig, time, bl, n, bl2, string);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        LogSegment logSegment = this;
        synchronized (logSegment) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public FileRecords log() {
        return this.log;
    }

    public OffsetIndex offsetIndex() {
        return this.offsetIndex;
    }

    public TimeIndex timeIndex() {
        return this.timeIndex;
    }

    public TransactionIndex txnIndex() {
        return this.txnIndex;
    }

    public long baseOffset() {
        return this.baseOffset;
    }

    public int indexIntervalBytes() {
        return this.indexIntervalBytes;
    }

    public long rollJitterMs() {
        return this.rollJitterMs;
    }

    public long maxSegmentMs() {
        return this.maxSegmentMs;
    }

    public int maxSegmentBytes() {
        return this.maxSegmentBytes;
    }

    public Time time() {
        return this.time;
    }

    public boolean shouldRoll(int messagesSize, long maxTimestampInMessages, long maxOffsetInMessages, long now) {
        boolean reachedRollMs = this.timeWaitedForRoll(now, maxTimestampInMessages) > this.maxSegmentMs() - this.rollJitterMs();
        return this.size() > this.maxSegmentBytes() - messagesSize || this.size() > 0 && reachedRollMs || this.offsetIndex().isFull() || this.timeIndex().isFull() || !this.canConvertToRelativeOffset(maxOffsetInMessages);
    }

    public void resizeIndexes(int size) {
        this.offsetIndex().resize(size);
        this.timeIndex().resize(size);
    }

    public void sanityCheck(boolean timeIndexFileNewlyCreated) {
        if (!this.offsetIndex().file().exists()) {
            throw new NoSuchFileException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Offset index file ", " does not exist"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.offsetIndex().file().getAbsolutePath()})));
        }
        this.offsetIndex().sanityCheck();
        Object object = timeIndexFileNewlyCreated ? BoxesRunTime.boxToBoolean((boolean)this.timeIndex().resize(0)) : BoxedUnit.UNIT;
        this.timeIndex().sanityCheck();
        this.txnIndex().sanityCheck();
    }

    private long created() {
        return this.created;
    }

    private void created_$eq(long x$1) {
        this.created = x$1;
    }

    private int bytesSinceLastIndexEntry() {
        return this.bytesSinceLastIndexEntry;
    }

    private void bytesSinceLastIndexEntry_$eq(int x$1) {
        this.bytesSinceLastIndexEntry = x$1;
    }

    private Option<Object> rollingBasedTimestamp() {
        return this.rollingBasedTimestamp;
    }

    private void rollingBasedTimestamp_$eq(Option<Object> x$1) {
        this.rollingBasedTimestamp = x$1;
    }

    private long maxTimestampSoFar() {
        return this.maxTimestampSoFar;
    }

    private void maxTimestampSoFar_$eq(long x$1) {
        this.maxTimestampSoFar = x$1;
    }

    private long offsetOfMaxTimestamp() {
        return this.offsetOfMaxTimestamp;
    }

    private void offsetOfMaxTimestamp_$eq(long x$1) {
        this.offsetOfMaxTimestamp = x$1;
    }

    public int size() {
        return this.log().sizeInBytes();
    }

    public boolean canConvertToRelativeOffset(long offset) {
        return offset - this.baseOffset() <= Integer.MAX_VALUE;
    }

    public void append(long firstOffset, long largestOffset, long largestTimestamp, long shallowOffsetOfMaxTimestamp, MemoryRecords records) {
        block3: {
            if (records.sizeInBytes() <= 0) break block3;
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Inserting %d bytes at offset %d at position %d with largest timestamp %d at shallow offset %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)records.sizeInBytes()), BoxesRunTime.boxToLong((long)firstOffset), BoxesRunTime.boxToInteger((int)this.log().sizeInBytes()), BoxesRunTime.boxToLong((long)largestTimestamp), BoxesRunTime.boxToLong((long)shallowOffsetOfMaxTimestamp)})));
            int physicalPosition = this.log().sizeInBytes();
            if (physicalPosition == 0) {
                this.rollingBasedTimestamp_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)largestTimestamp)));
            }
            Predef$.MODULE$.require(this.canConvertToRelativeOffset(largestOffset), (Function0 & Serializable & scala.Serializable)() -> "largest offset in message set can not be safely converted to relative offset.");
            int appendedBytes = this.log().append(records);
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Appended ", " to ", " at offset ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)appendedBytes), this.log().file(), BoxesRunTime.boxToLong((long)firstOffset)})));
            if (largestTimestamp > this.maxTimestampSoFar()) {
                this.maxTimestampSoFar_$eq(largestTimestamp);
                this.offsetOfMaxTimestamp_$eq(shallowOffsetOfMaxTimestamp);
            }
            if (this.bytesSinceLastIndexEntry() > this.indexIntervalBytes()) {
                this.offsetIndex().append(firstOffset, physicalPosition);
                this.timeIndex().maybeAppend(this.maxTimestampSoFar(), this.offsetOfMaxTimestamp(), this.timeIndex().maybeAppend$default$3());
                this.bytesSinceLastIndexEntry_$eq(0);
            }
            this.bytesSinceLastIndexEntry_$eq(this.bytesSinceLastIndexEntry() + records.sizeInBytes());
        }
    }

    public void updateTxnIndex(CompletedTxn completedTxn, long lastStableOffset) {
        block0: {
            if (!completedTxn.isAborted()) break block0;
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Writing aborted transaction ", " to transaction index, last stable offset is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{completedTxn, BoxesRunTime.boxToLong((long)lastStableOffset)})));
            this.txnIndex().append(new AbortedTxn(completedTxn, lastStableOffset));
        }
    }

    private void updateProducerState(ProducerStateManager producerStateManager, RecordBatch batch) {
        if (batch.hasProducerId()) {
            long producerId = batch.producerId();
            ProducerAppendInfo appendInfo = producerStateManager.prepareUpdate(producerId, false);
            Option<CompletedTxn> maybeCompletedTxn = appendInfo.append(batch);
            producerStateManager.update(appendInfo);
            maybeCompletedTxn.foreach((Function1 & Serializable & scala.Serializable)completedTxn -> {
                LogSegment.$anonfun$updateProducerState$1(this, producerStateManager, completedTxn);
                return BoxedUnit.UNIT;
            });
        }
        producerStateManager.updateMapEndOffset(batch.lastOffset() + 1L);
    }

    public FileRecords.LogOffsetPosition translateOffset(long offset, int startingFilePosition) {
        OffsetPosition mapping = this.offsetIndex().lookup(offset);
        return this.log().searchForOffsetWithSize(offset, package$.MODULE$.max(mapping.position(), startingFilePosition));
    }

    public int translateOffset$default$2() {
        return 0;
    }

    public FetchDataInfo read(long startOffset, Option<Object> maxOffset, int maxSize, long maxPosition, boolean minOneMessage) {
        int n;
        int adjustedMaxSize;
        if (maxSize < 0) {
            throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Invalid max size for log read (%d)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)maxSize)})));
        }
        int logSize = this.log().sizeInBytes();
        FileRecords.LogOffsetPosition startOffsetAndSize = this.translateOffset(startOffset, this.translateOffset$default$2());
        if (startOffsetAndSize == null) {
            return null;
        }
        int startPosition = startOffsetAndSize.position;
        LogOffsetMetadata offsetMetadata = new LogOffsetMetadata(startOffset, this.baseOffset(), startPosition);
        int n2 = adjustedMaxSize = minOneMessage ? package$.MODULE$.max(maxSize, startOffsetAndSize.size) : maxSize;
        if (adjustedMaxSize == 0) {
            return new FetchDataInfo(offsetMetadata, MemoryRecords.EMPTY, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4());
        }
        Option<Object> option = maxOffset;
        if (None$.MODULE$.equals(option)) {
            n = package$.MODULE$.min((int)(maxPosition - (long)startPosition), adjustedMaxSize);
        } else if (option instanceof Some) {
            Some some = (Some)option;
            long offset = BoxesRunTime.unboxToLong((Object)some.value());
            if (offset < startOffset) {
                return new FetchDataInfo(offsetMetadata, MemoryRecords.EMPTY, false, FetchDataInfo$.MODULE$.apply$default$4());
            }
            FileRecords.LogOffsetPosition mapping = this.translateOffset(offset, startPosition);
            int endPosition = mapping == null ? logSize : mapping.position;
            n = (int)package$.MODULE$.min(package$.MODULE$.min(maxPosition, (long)endPosition) - (long)startPosition, (long)adjustedMaxSize);
        } else {
            throw new MatchError(option);
        }
        int fetchSize = n;
        return new FetchDataInfo(offsetMetadata, this.log().read(startPosition, fetchSize), adjustedMaxSize < startOffsetAndSize.size, FetchDataInfo$.MODULE$.apply$default$4());
    }

    public long read$default$4() {
        return this.size();
    }

    public boolean read$default$5() {
        return false;
    }

    public Option<Object> fetchUpperBoundOffset(OffsetPosition startOffsetPosition, int fetchSize) {
        return this.offsetIndex().fetchUpperBoundOffset(startOffsetPosition, fetchSize).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.offset()));
    }

    public int recover(ProducerStateManager producerStateManager, Option<LeaderEpochCache> leaderEpochCache) {
        this.offsetIndex().reset();
        this.timeIndex().reset();
        this.txnIndex().reset();
        IntRef validBytes = IntRef.create((int)0);
        IntRef lastIndexEntry = IntRef.create((int)0);
        this.maxTimestampSoFar_$eq(-1L);
        try {
            ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(this.log().batches()).asScala()).foreach((Function1 & Serializable & scala.Serializable)batch -> {
                LogSegment.$anonfun$recover$1(this, producerStateManager, leaderEpochCache, validBytes, lastIndexEntry, batch);
                return BoxedUnit.UNIT;
            });
        }
        catch (CorruptRecordException e) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Found invalid messages in log segment %s at byte offset %d: %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.log().file().getAbsolutePath(), BoxesRunTime.boxToInteger((int)validBytes$1.elem), e.getMessage()})));
        }
        int truncated = this.log().sizeInBytes() - validBytes.elem;
        if (truncated > 0) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Truncated ", " invalid bytes at the end of segment ", " during recovery"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)truncated), this.log().file().getAbsoluteFile()})));
        }
        this.log().truncateTo(validBytes.elem);
        this.offsetIndex().trimToValidSize();
        this.timeIndex().maybeAppend(this.maxTimestampSoFar(), this.offsetOfMaxTimestamp(), true);
        this.timeIndex().trimToValidSize();
        return truncated;
    }

    public Option<LeaderEpochCache> recover$default$2() {
        return None$.MODULE$;
    }

    private void loadLargestTimestamp() {
        block0: {
            TimestampOffset lastTimeIndexEntry = this.timeIndex().lastEntry();
            this.maxTimestampSoFar_$eq(lastTimeIndexEntry.timestamp());
            this.offsetOfMaxTimestamp_$eq(lastTimeIndexEntry.offset());
            OffsetPosition offsetPosition = this.offsetIndex().lookup(lastTimeIndexEntry.offset());
            FileRecords.TimestampAndOffset maxTimestampOffsetAfterLastEntry = this.log().largestTimestampAfter(offsetPosition.position());
            if (maxTimestampOffsetAfterLastEntry.timestamp <= lastTimeIndexEntry.timestamp()) break block0;
            this.maxTimestampSoFar_$eq(maxTimestampOffsetAfterLastEntry.timestamp);
            this.offsetOfMaxTimestamp_$eq(maxTimestampOffsetAfterLastEntry.offset);
        }
    }

    public TxnIndexSearchResult collectAbortedTxns(long fetchOffset, long upperBoundOffset) {
        return this.txnIndex().collectAbortedTxns(fetchOffset, upperBoundOffset);
    }

    public String toString() {
        return "LogSegment(baseOffset=" + this.baseOffset() + ", size=" + this.size() + ")";
    }

    public int truncateTo(long offset) {
        int bytesTruncated;
        block1: {
            FileRecords.LogOffsetPosition mapping = this.translateOffset(offset, this.translateOffset$default$2());
            this.offsetIndex().truncateTo(offset);
            this.timeIndex().truncateTo(offset);
            this.txnIndex().truncateTo(offset);
            this.offsetIndex().resize(this.offsetIndex().maxIndexSize());
            this.timeIndex().resize(this.timeIndex().maxIndexSize());
            int n = bytesTruncated = mapping == null ? 0 : this.log().truncateTo(mapping.position);
            if (this.log().sizeInBytes() == 0) {
                this.created_$eq(this.time().milliseconds());
                this.rollingBasedTimestamp_$eq((Option<Object>)None$.MODULE$);
            }
            this.bytesSinceLastIndexEntry_$eq(0);
            if (this.maxTimestampSoFar() < 0L) break block1;
            this.loadLargestTimestamp();
        }
        return bytesTruncated;
    }

    public long readNextOffset() {
        FetchDataInfo ms = this.read(this.offsetIndex().lastOffset(), (Option<Object>)None$.MODULE$, this.log().sizeInBytes(), this.read$default$4(), this.read$default$5());
        return ms == null ? this.baseOffset() : BoxesRunTime.unboxToLong((Object)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(ms.records().batches()).asScala()).lastOption().map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.nextOffset())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> this.baseOffset()));
    }

    public void flush() {
        LogFlushStats$.MODULE$.logFlushTimer().time((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.log().flush();
            this.offsetIndex().flush();
            this.timeIndex().flush();
            this.txnIndex().flush();
        });
    }

    public void updateDir(File dir) {
        this.log().setFile(new File(dir, this.log().file().getName()));
        this.offsetIndex().file_$eq(new File(dir, this.offsetIndex().file().getName()));
        this.timeIndex().file_$eq(new File(dir, this.timeIndex().file().getName()));
        this.txnIndex().file_$eq(new File(dir, this.txnIndex().file().getName()));
    }

    public void changeFileSuffixes(String oldSuffix, String newSuffix) {
        this.log().renameTo(new File(CoreUtils$.MODULE$.replaceSuffix(this.log().file().getPath(), oldSuffix, newSuffix)));
        this.offsetIndex().renameTo(new File(CoreUtils$.MODULE$.replaceSuffix(this.offsetIndex().file().getPath(), oldSuffix, newSuffix)));
        this.timeIndex().renameTo(new File(CoreUtils$.MODULE$.replaceSuffix(this.timeIndex().file().getPath(), oldSuffix, newSuffix)));
        this.txnIndex().renameTo(new File(CoreUtils$.MODULE$.replaceSuffix(this.txnIndex().file().getPath(), oldSuffix, newSuffix)));
    }

    public void onBecomeInactiveSegment() {
        this.timeIndex().maybeAppend(this.maxTimestampSoFar(), this.offsetOfMaxTimestamp(), true);
        this.offsetIndex().trimToValidSize();
        this.timeIndex().trimToValidSize();
        this.log().trim();
    }

    public long timeWaitedForRoll(long now, long messageTimestamp) {
        Some some;
        long t;
        Option<Object> option;
        Iterator<FileLogInputStream.FileChannelRecordBatch> iter;
        if (this.rollingBasedTimestamp().isEmpty() && (iter = this.log().batches().iterator()).hasNext()) {
            this.rollingBasedTimestamp_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)iter.next().maxTimestamp())));
        }
        long l = (option = this.rollingBasedTimestamp()) instanceof Some && (t = BoxesRunTime.unboxToLong((Object)(some = (Some)option).value())) >= 0L ? messageTimestamp - t : now - this.created();
        return l;
    }

    public Option<TimestampOffset> findOffsetByTimestamp(long timestamp, long startingOffset) {
        TimestampOffset timestampOffset = this.timeIndex().lookup(timestamp);
        int position = this.offsetIndex().lookup(package$.MODULE$.max(timestampOffset.offset(), startingOffset)).position();
        return Option$.MODULE$.apply((Object)this.log().searchForTimestamp(timestamp, position, startingOffset)).map((Function1 & Serializable & scala.Serializable)timestampAndOffset -> new TimestampOffset(timestampAndOffset.timestamp, timestampAndOffset.offset));
    }

    public long findOffsetByTimestamp$default$2() {
        return this.baseOffset();
    }

    public void close() {
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.timeIndex().maybeAppend(this.maxTimestampSoFar(), this.offsetOfMaxTimestamp(), true), this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.offsetIndex().close(), this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.timeIndex().close(), this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.log().close(), this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.txnIndex().close(), this, CoreUtils$.MODULE$.swallow$default$3());
    }

    public void closeHandlers() {
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.offsetIndex().closeHandler(), this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.timeIndex().closeHandler(), this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.log().closeHandlers(), this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.txnIndex().close(), this, CoreUtils$.MODULE$.swallow$default$3());
    }

    public void deleteIfExists() {
        CoreUtils$.MODULE$.tryAll((Seq<Function0<BoxedUnit>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function0[]{(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.delete$1((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.log().deleteIfExists(), "log", this.log().file(), true), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.delete$1((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.offsetIndex().deleteIfExists(), "offset index", this.offsetIndex().file(), true), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.delete$1((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.timeIndex().deleteIfExists(), "time index", this.timeIndex().file(), true), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.delete$1((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.txnIndex().deleteIfExists(), "transaction index", this.txnIndex().file(), false)}))));
    }

    public long lastModified() {
        return this.log().file().lastModified();
    }

    public long largestTimestamp() {
        return this.maxTimestampSoFar() >= 0L ? this.maxTimestampSoFar() : this.lastModified();
    }

    public Path lastModified_$eq(long ms) {
        FileTime fileTime = FileTime.fromMillis(ms);
        Files.setLastModifiedTime(this.log().file().toPath(), fileTime);
        Files.setLastModifiedTime(this.offsetIndex().file().toPath(), fileTime);
        return Files.setLastModifiedTime(this.timeIndex().file().toPath(), fileTime);
    }

    public static final /* synthetic */ void $anonfun$updateProducerState$1(LogSegment $this, ProducerStateManager producerStateManager$2, CompletedTxn completedTxn) {
        long lastStableOffset = producerStateManager$2.completeTxn(completedTxn);
        $this.updateTxnIndex(completedTxn, lastStableOffset);
    }

    public static final /* synthetic */ void $anonfun$recover$2(FileLogInputStream.FileChannelRecordBatch batch$1, LeaderEpochCache cache) {
        block0: {
            if (batch$1.partitionLeaderEpoch() <= cache.latestEpoch()) break block0;
            cache.assign(batch$1.partitionLeaderEpoch(), batch$1.baseOffset());
        }
    }

    public static final /* synthetic */ void $anonfun$recover$1(LogSegment $this, ProducerStateManager producerStateManager$1, Option leaderEpochCache$1, IntRef validBytes$1, IntRef lastIndexEntry$1, FileLogInputStream.FileChannelRecordBatch batch) {
        block2: {
            batch.ensureValid();
            if (batch.maxTimestamp() > $this.maxTimestampSoFar()) {
                $this.maxTimestampSoFar_$eq(batch.maxTimestamp());
                $this.offsetOfMaxTimestamp_$eq(batch.lastOffset());
            }
            if (validBytes$1.elem - lastIndexEntry$1.elem > $this.indexIntervalBytes()) {
                long startOffset = batch.baseOffset();
                $this.offsetIndex().append(startOffset, validBytes$1.elem);
                $this.timeIndex().maybeAppend($this.maxTimestampSoFar(), $this.offsetOfMaxTimestamp(), $this.timeIndex().maybeAppend$default$3());
                lastIndexEntry$1.elem = validBytes$1.elem;
            }
            validBytes$1.elem += batch.sizeInBytes();
            if (batch.magic() < 2) break block2;
            leaderEpochCache$1.foreach((Function1 & Serializable & scala.Serializable)cache -> {
                LogSegment.$anonfun$recover$2(batch, cache);
                return BoxedUnit.UNIT;
            });
            $this.updateProducerState(producerStateManager$1, batch);
        }
    }

    private final void delete$1(Function0 delete, String fileType, File file, boolean logIfMissing) {
        try {
            if (delete.apply$mcZ$sp()) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deleted ", " ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fileType, file.getAbsolutePath()})));
            } else if (logIfMissing) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to delete ", " ", " because it does not exist."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fileType, file.getAbsolutePath()})));
            }
        }
        catch (IOException e) {
            throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Delete of ", " ", " failed."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fileType, file.getAbsolutePath()})), e);
        }
    }

    public LogSegment(FileRecords log, OffsetIndex offsetIndex, TimeIndex timeIndex, TransactionIndex txnIndex, long baseOffset, int indexIntervalBytes, long rollJitterMs, long maxSegmentMs, int maxSegmentBytes, Time time) {
        this.log = log;
        this.offsetIndex = offsetIndex;
        this.timeIndex = timeIndex;
        this.txnIndex = txnIndex;
        this.baseOffset = baseOffset;
        this.indexIntervalBytes = indexIntervalBytes;
        this.rollJitterMs = rollJitterMs;
        this.maxSegmentMs = maxSegmentMs;
        this.maxSegmentBytes = maxSegmentBytes;
        this.time = time;
        Logging.$init$(this);
        this.created = time.milliseconds();
        this.bytesSinceLastIndexEntry = 0;
        this.rollingBasedTimestamp = None$.MODULE$;
        this.maxTimestampSoFar = timeIndex.lastEntry().timestamp();
        this.offsetOfMaxTimestamp = timeIndex.lastEntry().offset();
    }
}

