/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.log;

import com.typesafe.scalalogging.Logger;
import io.confluent.kafka.log.AbstractIndex$;
import io.confluent.kafka.log.IndexEntry;
import io.confluent.kafka.log.IndexSearchType$;
import io.confluent.kafka.utils.CoreUtils$;
import io.confluent.kafka.utils.Logging;
import io.confluent.org.apache.kafka.common.utils.MappedByteBuffers;
import io.confluent.org.apache.kafka.common.utils.OperatingSystem;
import io.confluent.org.apache.kafka.common.utils.Utils;
import java.io.File;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import scala.Enumeration;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t]c!B\u0001\u0003\u0003\u00039!!D!cgR\u0014\u0018m\u0019;J]\u0012,\u0007P\u0003\u0002\u0004\t\u0005\u0019An\\4\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001!F\u0002\t\u001b^\u001b2\u0001A\u0005\u0010!\tQQ\"D\u0001\f\u0015\u0005a\u0011!B:dC2\f\u0017B\u0001\b\f\u0005\u0019\te.\u001f*fMB\u0011\u0001cE\u0007\u0002#)\u0011!\u0003B\u0001\u0006kRLGn]\u0005\u0003)E\u0011q\u0001T8hO&tw\r\u0003\u0005\u0017\u0001\t\u0005\r\u0011\"\u0001\u0018\u0003\u00111\u0017\u000e\\3\u0016\u0003a\u0001\"!\u0007\u0010\u000e\u0003iQ!a\u0007\u000f\u0002\u0005%|'\"A\u000f\u0002\t)\fg/Y\u0005\u0003?i\u0011AAR5mK\"A\u0011\u0005\u0001BA\u0002\u0013\u0005!%\u0001\u0005gS2,w\fJ3r)\t\u0019c\u0005\u0005\u0002\u000bI%\u0011Qe\u0003\u0002\u0005+:LG\u000fC\u0004(A\u0005\u0005\t\u0019\u0001\r\u0002\u0007a$\u0013\u0007\u0003\u0005*\u0001\t\u0005\t\u0015)\u0003\u0019\u0003\u00151\u0017\u000e\\3!Q\tA3\u0006\u0005\u0002\u000bY%\u0011Qf\u0003\u0002\tm>d\u0017\r^5mK\"Aq\u0006\u0001BC\u0002\u0013\u0005\u0001'\u0001\u0006cCN,wJ\u001a4tKR,\u0012!\r\t\u0003\u0015IJ!aM\u0006\u0003\t1{gn\u001a\u0005\tk\u0001\u0011\t\u0011)A\u0005c\u0005Y!-Y:f\u001f\u001a47/\u001a;!\u0011!9\u0004A!b\u0001\n\u0003A\u0014\u0001D7bq&sG-\u001a=TSj,W#A\u001d\u0011\u0005)Q\u0014BA\u001e\f\u0005\rIe\u000e\u001e\u0005\t{\u0001\u0011\t\u0011)A\u0005s\u0005iQ.\u0019=J]\u0012,\u0007pU5{K\u0002B\u0001b\u0010\u0001\u0003\u0006\u0004%\t\u0001Q\u0001\toJLG/\u00192mKV\t\u0011\t\u0005\u0002\u000b\u0005&\u00111i\u0003\u0002\b\u0005>|G.Z1o\u0011!)\u0005A!A!\u0002\u0013\t\u0015!C<sSR\f'\r\\3!\u0011\u00159\u0005\u0001\"\u0001I\u0003\u0019a\u0014N\\5u}Q)\u0011*\u0017.\\9B!!\nA&W\u001b\u0005\u0011\u0001C\u0001'N\u0019\u0001!QA\u0014\u0001C\u0002=\u0013\u0011aS\t\u0003!N\u0003\"AC)\n\u0005I[!a\u0002(pi\"Lgn\u001a\t\u0003\u0015QK!!V\u0006\u0003\u0007\u0005s\u0017\u0010\u0005\u0002M/\u0012)\u0001\f\u0001b\u0001\u001f\n\ta\u000bC\u0003\u0017\r\u0002\u0007\u0001\u0004C\u00030\r\u0002\u0007\u0011\u0007C\u00048\rB\u0005\t\u0019A\u001d\t\u000b}2\u0005\u0019A!\t\u0013y\u0003\u0001\u0019!a\u0001\n\u0013\u0001\u0014aB0mK:<G\u000f\u001b\u0005\nA\u0002\u0001\r\u00111A\u0005\n\u0005\f1b\u00187f]\u001e$\bn\u0018\u0013fcR\u00111E\u0019\u0005\bO}\u000b\t\u00111\u00012\u0011%!\u0007\u00011A\u0001B\u0003&\u0011'\u0001\u0005`Y\u0016tw\r\u001e5!Q\t\u00197\u0006C\u0003h\u0001\u0019E\u0001(A\u0005f]R\u0014\u0018pU5{K\"9\u0011\u000e\u0001b\u0001\n#Q\u0017\u0001\u00027pG.,\u0012a\u001b\t\u0003YNl\u0011!\u001c\u0006\u0003]>\fQ\u0001\\8dWNT!\u0001]9\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002s9\u0005!Q\u000f^5m\u0013\t!XNA\u0007SK\u0016tGO]1oi2{7m\u001b\u0005\u0007m\u0002\u0001\u000b\u0011B6\u0002\u000b1|7m\u001b\u0011\t\u000fa\u0004\u0001\u0019!C\ts\u0006!Q.\\1q+\u0005Q\bCA>\u007f\u001b\u0005a(BA?\u001d\u0003\rq\u0017n\\\u0005\u0003\u007fr\u0014\u0001#T1qa\u0016$')\u001f;f\u0005V4g-\u001a:\t\u0013\u0005\r\u0001\u00011A\u0005\u0012\u0005\u0015\u0011\u0001C7nCB|F%Z9\u0015\u0007\r\n9\u0001\u0003\u0005(\u0003\u0003\t\t\u00111\u0001{\u0011\u001d\tY\u0001\u0001Q!\ni\fQ!\\7ba\u0002B3!!\u0003,\u0011\u001d\t\t\u0002\u0001Q!\ne\n1bX7bq\u0016sGO]5fg\"\u001a\u0011qB\u0016\t\u0011\u0005]\u0001\u00011A\u0005\u0012a\n\u0001bX3oiJLWm\u001d\u0005\n\u00037\u0001\u0001\u0019!C\t\u0003;\tAbX3oiJLWm]0%KF$2aIA\u0010\u0011!9\u0013\u0011DA\u0001\u0002\u0004I\u0004bBA\u0012\u0001\u0001\u0006K!O\u0001\n?\u0016tGO]5fg\u0002B3!!\t,\u0011\u0019\tI\u0003\u0001C\u0001\u0001\u00061\u0011n\u001d$vY2Da!!\f\u0001\t\u0003A\u0014AC7bq\u0016sGO]5fg\"1\u0011\u0011\u0007\u0001\u0005\u0002a\nq!\u001a8ue&,7\u000f\u0003\u0004\u00026\u0001!\t\u0001M\u0001\u0007Y\u0016tw\r\u001e5\t\u000f\u0005e\u0002\u0001\"\u0001\u0002<\u00051!/Z:ju\u0016$2!QA\u001f\u0011\u001d\ty$a\u000eA\u0002e\nqA\\3x'&TX\rC\u0004\u0002D\u0001!\t!!\u0012\u0002\u0011I,g.Y7f)>$2aIA$\u0011\u001d\tI%!\u0011A\u0002a\t\u0011A\u001a\u0005\b\u0003\u001b\u0002A\u0011AA(\u0003\u00151G.^:i)\u0005\u0019\u0003bBA*\u0001\u0011\u0005\u0011QK\u0001\u000fI\u0016dW\r^3JM\u0016C\u0018n\u001d;t)\u0005\t\u0005bBA-\u0001\u0011\u0005\u0011qJ\u0001\u0010iJLW\u000eV8WC2LGmU5{K\"1\u0011Q\f\u0001\u0005\u0002a\n1b]5{K&s')\u001f;fg\"9\u0011\u0011\r\u0001\u0005\u0002\u0005=\u0013!B2m_N,\u0007bBA3\u0001\u0011\u0005\u0011qJ\u0001\rG2|7/\u001a%b]\u0012dWM\u001d\u0005\b\u0003S\u0002a\u0011AA(\u0003-\u0019\u0018M\\5us\u000eCWmY6\t\u000f\u00055\u0004A\"\u0005\u0002P\u0005AAO];oG\u0006$X\rC\u0004\u0002r\u00011\t!a\u001d\u0002\u0015Q\u0014XO\\2bi\u0016$v\u000eF\u0002$\u0003kBq!a\u001e\u0002p\u0001\u0007\u0011'\u0001\u0004pM\u001a\u001cX\r\u001e\u0005\b\u0003w\u0002A\u0011AA(\u0003\u0015\u0011Xm]3u\u0011\u001d\ty\b\u0001C\t\u0003\u001f\nab]1gK\u001a{'oY3V]6\f\u0007\u000f\u0003\u0005\u0002\u0004\u0002!\tBAA(\u0003)1wN]2f+:l\u0017\r\u001d\u0005\b\u0003\u000f\u0003A\u0011CAE\u0003%i\u0017-\u001f2f\u0019>\u001c7.\u0006\u0003\u0002\f\u0006EE\u0003BAG\u0003?#B!a$\u0002\u0016B\u0019A*!%\u0005\u000f\u0005M\u0015Q\u0011b\u0001\u001f\n\tA\u000bC\u0005\u0002\u0018\u0006\u0015E\u00111\u0001\u0002\u001a\u0006\u0019a-\u001e8\u0011\u000b)\tY*a$\n\u0007\u0005u5B\u0001\u0005=Eft\u0017-\\3?\u0011\u001dI\u0017Q\u0011a\u0001\u0003C\u00032\u0001\\AR\u0013\r\t)+\u001c\u0002\u0005\u0019>\u001c7\u000eC\u0004\u0002*\u00021\t\"a+\u0002\u0015A\f'o]3F]R\u0014\u0018\u0010\u0006\u0004\u0002.\u0006M\u0016Q\u0018\t\u0004\u0015\u0006=\u0016bAAY\u0005\tQ\u0011J\u001c3fq\u0016sGO]=\t\u0011\u0005U\u0016q\u0015a\u0001\u0003o\u000baAY;gM\u0016\u0014\bcA>\u0002:&\u0019\u00111\u0018?\u0003\u0015\tKH/\u001a\"vM\u001a,'\u000fC\u0004\u0002@\u0006\u001d\u0006\u0019A\u001d\u0002\u00039Dq!a1\u0001\t#\t)-\u0001\rmCJ<Wm\u001d;M_^,'OQ8v]\u0012\u001cFn\u001c;G_J$r!OAd\u0003\u0017\fy\r\u0003\u0005\u0002J\u0006\u0005\u0007\u0019AA\\\u0003\rIG\r\u001f\u0005\b\u0003\u001b\f\t\r1\u00012\u0003\u0019!\u0018M]4fi\"A\u0011\u0011[Aa\u0001\u0004\t\u0019.\u0001\u0007tK\u0006\u00148\r[#oi&$\u0018\u0010\u0005\u0003\u0002V\u0006%h\u0002BAl\u0003KtA!!7\u0002d:!\u00111\\Aq\u001b\t\tiNC\u0002\u0002`\u001a\ta\u0001\u0010:p_Rt\u0014\"A\u0003\n\u0005\r!\u0011bAAt\u0005\u0005y\u0011J\u001c3fqN+\u0017M]2i)f\u0004X-\u0003\u0003\u0002l\u00065(!E%oI\u0016D8+Z1sG\",e\u000e^5us*\u0019\u0011q\u001d\u0002\t\u000f\u0005E\b\u0001\"\u0005\u0002t\u0006I2/\\1mY\u0016\u001cH/\u00169qKJ\u0014u.\u001e8e'2|GOR8s)\u001dI\u0014Q_A|\u0003sD\u0001\"!3\u0002p\u0002\u0007\u0011q\u0017\u0005\b\u0003\u001b\fy\u000f1\u00012\u0011!\t\t.a<A\u0002\u0005M\u0007bBA\u007f\u0001\u0011%\u0011q`\u0001\u0012S:$W\r_*m_R\u0014\u0016M\\4f\r>\u0014H\u0003\u0003B\u0001\u0005\u000f\u0011IAa\u0003\u0011\u000b)\u0011\u0019!O\u001d\n\u0007\t\u00151B\u0001\u0004UkBdWM\r\u0005\t\u0003\u0013\fY\u00101\u0001\u00028\"9\u0011QZA~\u0001\u0004\t\u0004\u0002CAi\u0003w\u0004\r!a5\t\u000f\t=\u0001\u0001\"\u0003\u0003\u0012\u0005\t2m\\7qCJ,\u0017J\u001c3fq\u0016sGO]=\u0015\u000fe\u0012\u0019Ba\u0006\u0003\u001a!A!Q\u0003B\u0007\u0001\u0004\ti+\u0001\u0006j]\u0012,\u00070\u00128uefDq!!4\u0003\u000e\u0001\u0007\u0011\u0007\u0003\u0005\u0002R\n5\u0001\u0019AAj\u0011\u001d\u0011i\u0002\u0001C\u0005\u0005?\t\u0001D]8v]\u0012$un\u001e8U_\u0016C\u0018m\u0019;Nk2$\u0018\u000e\u001d7f)\u0015I$\u0011\u0005B\u0013\u0011\u001d\u0011\u0019Ca\u0007A\u0002e\naA\\;nE\u0016\u0014\bb\u0002B\u0014\u00057\u0001\r!O\u0001\u0007M\u0006\u001cGo\u001c:\b\u0013\t-\"!!A\t\u0002\t5\u0012!D!cgR\u0014\u0018m\u0019;J]\u0012,\u0007\u0010E\u0002K\u0005_1\u0001\"\u0001\u0002\u0002\u0002#\u0005!\u0011G\n\u0004\u0005_I\u0001bB$\u00030\u0011\u0005!Q\u0007\u000b\u0003\u0005[A!B!\u000f\u00030E\u0005I\u0011\u0001B\u001e\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%gU1!Q\bB*\u0005+*\"Aa\u0010+\u0007e\u0012\te\u000b\u0002\u0003DA!!Q\tB(\u001b\t\u00119E\u0003\u0003\u0003J\t-\u0013!C;oG\",7m[3e\u0015\r\u0011ieC\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B)\u0005\u000f\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\t\u0019q%q\u0007b\u0001\u001f\u00121\u0001La\u000eC\u0002=\u0003")
public abstract class AbstractIndex<K, V>
implements Logging {
    private volatile File file;
    private final long baseOffset;
    private final int maxIndexSize;
    private final boolean writable;
    private volatile long _length;
    private final ReentrantLock lock;
    private volatile MappedByteBuffer mmap;
    private volatile int _maxEntries;
    private volatile int _entries;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static <K, V> int $lessinit$greater$default$3() {
        return AbstractIndex$.MODULE$.$lessinit$greater$default$3();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        AbstractIndex abstractIndex = this;
        synchronized (abstractIndex) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public File file() {
        return this.file;
    }

    public void file_$eq(File x$1) {
        this.file = x$1;
    }

    public long baseOffset() {
        return this.baseOffset;
    }

    public int maxIndexSize() {
        return this.maxIndexSize;
    }

    public boolean writable() {
        return this.writable;
    }

    private long _length() {
        return this._length;
    }

    private void _length_$eq(long x$1) {
        this._length = x$1;
    }

    public abstract int entrySize();

    public ReentrantLock lock() {
        return this.lock;
    }

    public MappedByteBuffer mmap() {
        return this.mmap;
    }

    public void mmap_$eq(MappedByteBuffer x$1) {
        this.mmap = x$1;
    }

    public int _entries() {
        return this._entries;
    }

    public void _entries_$eq(int x$1) {
        this._entries = x$1;
    }

    public boolean isFull() {
        return this._entries() >= this._maxEntries;
    }

    public int maxEntries() {
        return this._maxEntries;
    }

    public int entries() {
        return this._entries();
    }

    public long length() {
        return this._length();
    }

    public boolean resize(int newSize) {
        return BoxesRunTime.unboxToBoolean(CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            boolean bl;
            int roundedNewSize = this.roundDownToExactMultiple(newSize, this.entrySize());
            if (this._length() == (long)roundedNewSize) {
                bl = false;
            } else {
                RandomAccessFile raf = new RandomAccessFile(this.file(), "rw");
                try {
                    int position = this.mmap().position();
                    if (OperatingSystem.IS_WINDOWS) {
                        this.safeForceUnmap();
                    }
                    raf.setLength(roundedNewSize);
                    this._length_$eq(roundedNewSize);
                    this.mmap_$eq(raf.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, roundedNewSize));
                    $this._maxEntries = this.mmap().limit() / this.entrySize();
                    this.mmap().position(position);
                    bl = true;
                }
                finally {
                    CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> raf.close(), this, CoreUtils$.MODULE$.swallow$default$3());
                }
            }
            return bl;
        }));
    }

    public void renameTo(File f) {
        try {
            Utils.atomicMoveWithFallback(this.file().toPath(), f.toPath());
        }
        finally {
            this.file_$eq(f);
        }
    }

    public void flush() {
        CoreUtils$.MODULE$.inLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> this.mmap().force());
    }

    public boolean deleteIfExists() {
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.safeForceUnmap());
        return Files.deleteIfExists(this.file().toPath());
    }

    public void trimToValidSize() {
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.resize(this.entrySize() * this._entries()));
    }

    public int sizeInBytes() {
        return this.entrySize() * this._entries();
    }

    public void close() {
        this.trimToValidSize();
    }

    public void closeHandler() {
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.safeForceUnmap());
    }

    public abstract void sanityCheck();

    public abstract void truncate();

    public abstract void truncateTo(long var1);

    public void reset() {
        this.truncate();
        this.resize(this.maxIndexSize());
    }

    public void safeForceUnmap() {
        try {
            this.forceUnmap();
        }
        catch (Throwable t) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error unmapping index ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file()})), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
        }
    }

    public void forceUnmap() {
        try {
            MappedByteBuffers.unmap(this.file().getAbsolutePath(), this.mmap());
        }
        finally {
            this.mmap_$eq(null);
        }
    }

    public <T> T maybeLock(Lock lock, Function0<T> fun) {
        Object object;
        if (OperatingSystem.IS_WINDOWS) {
            lock.lock();
        }
        try {
            object = fun.apply();
        }
        finally {
            if (OperatingSystem.IS_WINDOWS) {
                lock.unlock();
            }
        }
        return (T)object;
    }

    public abstract IndexEntry parseEntry(ByteBuffer var1, int var2);

    public int largestLowerBoundSlotFor(ByteBuffer idx, long target, Enumeration.Value searchEntity) {
        return this.indexSlotRangeFor(idx, target, searchEntity)._1$mcI$sp();
    }

    public int smallestUpperBoundSlotFor(ByteBuffer idx, long target, Enumeration.Value searchEntity) {
        return this.indexSlotRangeFor(idx, target, searchEntity)._2$mcI$sp();
    }

    private Tuple2<Object, Object> indexSlotRangeFor(ByteBuffer idx, long target, Enumeration.Value searchEntity) {
        if (this._entries() == 0) {
            return new Tuple2.mcII.sp(-1, -1);
        }
        if (this.compareIndexEntry(this.parseEntry(idx, 0), target, searchEntity) > 0) {
            return new Tuple2.mcII.sp(-1, 0);
        }
        int lo = 0;
        int hi = this._entries() - 1;
        while (lo < hi) {
            int mid = (int)package$.MODULE$.ceil((double)hi / 2.0 + (double)lo / 2.0);
            IndexEntry found = this.parseEntry(idx, mid);
            int compareResult = this.compareIndexEntry(found, target, searchEntity);
            if (compareResult > 0) {
                hi = mid - 1;
                continue;
            }
            if (compareResult < 0) {
                lo = mid;
                continue;
            }
            return new Tuple2.mcII.sp(mid, mid);
        }
        return new Tuple2.mcII.sp(lo, lo == this._entries() - 1 ? -1 : lo + 1);
    }

    private int compareIndexEntry(IndexEntry indexEntry, long target, Enumeration.Value searchEntity) {
        int n;
        Enumeration.Value value = searchEntity;
        Enumeration.Value value2 = IndexSearchType$.MODULE$.KEY();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            n = Predef$.MODULE$.long2Long(indexEntry.indexKey()).compareTo(Predef$.MODULE$.long2Long(target));
        } else {
            Enumeration.Value value4 = IndexSearchType$.MODULE$.VALUE();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                n = Predef$.MODULE$.long2Long(indexEntry.indexValue()).compareTo(Predef$.MODULE$.long2Long(target));
            } else {
                throw new MatchError((Object)value);
            }
        }
        return n;
    }

    private int roundDownToExactMultiple(int number, int factor) {
        return factor * (number / factor);
    }

    public AbstractIndex(File file, long baseOffset, int maxIndexSize, boolean writable) {
        MappedByteBuffer mappedByteBuffer;
        this.file = file;
        this.baseOffset = baseOffset;
        this.maxIndexSize = maxIndexSize;
        this.writable = writable;
        Logging.$init$(this);
        this.lock = new ReentrantLock();
        boolean newlyCreated = this.file().createNewFile();
        RandomAccessFile raf = writable ? new RandomAccessFile(this.file(), "rw") : new RandomAccessFile(this.file(), "r");
        try {
            if (newlyCreated) {
                if (maxIndexSize < this.entrySize()) {
                    throw new IllegalArgumentException("Invalid max index size: " + maxIndexSize);
                }
                raf.setLength(this.roundDownToExactMultiple(maxIndexSize, this.entrySize()));
            }
            this._length_$eq(raf.length());
            MappedByteBuffer idx = writable ? raf.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, this._length()) : raf.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, this._length());
            Buffer buffer = newlyCreated ? idx.position(0) : idx.position(this.roundDownToExactMultiple(idx.limit(), this.entrySize()));
            mappedByteBuffer = idx;
        }
        finally {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> raf.close(), this, CoreUtils$.MODULE$.swallow$default$3());
        }
        this.mmap = mappedByteBuffer;
        this._maxEntries = this.mmap().limit() / this.entrySize();
        this._entries = this.mmap().position() / this.entrySize();
    }
}

