/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.controller;

import io.confluent.kafka.common.KafkaException;
import io.confluent.kafka.controller.ControllerContext;
import io.confluent.kafka.controller.QueueItem;
import io.confluent.kafka.controller.StateChangeLogger;
import io.confluent.kafka.server.KafkaConfig;
import io.confluent.kafka.utils.ShutdownableThread;
import io.confluent.kafka.utils.ShutdownableThread$;
import io.confluent.org.apache.kafka.clients.ClientRequest;
import io.confluent.org.apache.kafka.clients.ClientResponse;
import io.confluent.org.apache.kafka.clients.NetworkClient;
import io.confluent.org.apache.kafka.clients.NetworkClientUtils;
import io.confluent.org.apache.kafka.common.Node;
import io.confluent.org.apache.kafka.common.protocol.ApiKeys;
import io.confluent.org.apache.kafka.common.requests.AbstractRequest;
import io.confluent.org.apache.kafka.common.requests.AbstractResponse;
import io.confluent.org.apache.kafka.common.requests.RequestHeader;
import io.confluent.org.apache.kafka.common.utils.Time;
import java.io.Serializable;
import java.net.SocketTimeoutException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005=b\u0001B\u0001\u0003\u0001\u001d\u0011\u0011CU3rk\u0016\u001cHoU3oIRC'/Z1e\u0015\t\u0019A!\u0001\u0006d_:$(o\u001c7mKJT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\u0002\u0005\u0002\n\u00195\t!B\u0003\u0002\f\t\u0005)Q\u000f^5mg&\u0011QB\u0003\u0002\u0013'\",H\u000fZ8x]\u0006\u0014G.\u001a+ie\u0016\fG\r\u0003\u0005\u0010\u0001\t\u0015\r\u0011\"\u0001\u0011\u00031\u0019wN\u001c;s_2dWM]%e+\u0005\t\u0002C\u0001\n\u0016\u001b\u0005\u0019\"\"\u0001\u000b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u0019\"aA%oi\"A\u0001\u0004\u0001B\u0001B\u0003%\u0011#A\u0007d_:$(o\u001c7mKJLE\r\t\u0005\t5\u0001\u0011)\u0019!C\u00017\u0005\t2m\u001c8ue>dG.\u001a:D_:$X\r\u001f;\u0016\u0003q\u0001\"!\b\u0010\u000e\u0003\tI!a\b\u0002\u0003#\r{g\u000e\u001e:pY2,'oQ8oi\u0016DH\u000f\u0003\u0005\"\u0001\t\u0005\t\u0015!\u0003\u001d\u0003I\u0019wN\u001c;s_2dWM]\"p]R,\u0007\u0010\u001e\u0011\t\u0011\r\u0002!Q1A\u0005\u0002\u0011\nQ!];fk\u0016,\u0012!\n\t\u0004M5zS\"A\u0014\u000b\u0005!J\u0013AC2p]\u000e,(O]3oi*\u0011!fK\u0001\u0005kRLGNC\u0001-\u0003\u0011Q\u0017M^1\n\u00059:#!\u0004\"m_\u000e\\\u0017N\\4Rk\u0016,X\r\u0005\u0002\u001ea%\u0011\u0011G\u0001\u0002\n#V,W/Z%uK6D\u0001b\r\u0001\u0003\u0002\u0003\u0006I!J\u0001\u0007cV,W/\u001a\u0011\t\u0011U\u0002!Q1A\u0005\u0002Y\nQB\\3uo>\u00148n\u00117jK:$X#A\u001c\u0011\u0005a\u0002U\"A\u001d\u000b\u0005iZ\u0014aB2mS\u0016tGo\u001d\u0006\u0003\u000bqR!!\u0010 \u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0014aA8sO&\u0011\u0011)\u000f\u0002\u000e\u001d\u0016$xo\u001c:l\u00072LWM\u001c;\t\u0011\r\u0003!\u0011!Q\u0001\n]\naB\\3uo>\u00148n\u00117jK:$\b\u0005\u0003\u0005F\u0001\t\u0015\r\u0011\"\u0001G\u0003)\u0011'o\\6fe:{G-Z\u000b\u0002\u000fB\u0011\u0001jS\u0007\u0002\u0013*\u0011!jO\u0001\u0007G>lWn\u001c8\n\u00051K%\u0001\u0002(pI\u0016D\u0001B\u0014\u0001\u0003\u0002\u0003\u0006IaR\u0001\fEJ|7.\u001a:O_\u0012,\u0007\u0005\u0003\u0005Q\u0001\t\u0015\r\u0011\"\u0001R\u0003\u0019\u0019wN\u001c4jOV\t!\u000b\u0005\u0002T-6\tAK\u0003\u0002V\t\u000511/\u001a:wKJL!a\u0016+\u0003\u0017-\u000bgm[1D_:4\u0017n\u001a\u0005\t3\u0002\u0011\t\u0011)A\u0005%\u000691m\u001c8gS\u001e\u0004\u0003\u0002C.\u0001\u0005\u000b\u0007I\u0011\u0001/\u0002\tQLW.Z\u000b\u0002;B\u0011a\fY\u0007\u0002?*\u00111\"S\u0005\u0003C~\u0013A\u0001V5nK\"A1\r\u0001B\u0001B\u0003%Q,A\u0003uS6,\u0007\u0005\u0003\u0005f\u0001\t\u0015\r\u0011\"\u0001g\u0003E\u0019H/\u0019;f\u0007\"\fgnZ3M_\u001e<WM]\u000b\u0002OB\u0011Q\u0004[\u0005\u0003S\n\u0011\u0011c\u0015;bi\u0016\u001c\u0005.\u00198hK2{wmZ3s\u0011!Y\u0007A!A!\u0002\u00139\u0017AE:uCR,7\t[1oO\u0016dunZ4fe\u0002B\u0011\"\u001c\u0001\u0003\u0002\u0003\u0006IA\\=\u0002\t9\fW.\u001a\t\u0003_Zt!\u0001\u001d;\u0011\u0005E\u001cR\"\u0001:\u000b\u0005M4\u0011A\u0002\u001fs_>$h(\u0003\u0002v'\u00051\u0001K]3eK\u001aL!a\u001e=\u0003\rM#(/\u001b8h\u0015\t)8#\u0003\u0002n\u0019!)1\u0010\u0001C\u0001y\u00061A(\u001b8jiz\"\u0012# @\u0000\u0003\u0003\t\u0019!!\u0002\u0002\b\u0005%\u00111BA\u0007!\ti\u0002\u0001C\u0003\u0010u\u0002\u0007\u0011\u0003C\u0003\u001bu\u0002\u0007A\u0004C\u0003$u\u0002\u0007Q\u0005C\u00036u\u0002\u0007q\u0007C\u0003Fu\u0002\u0007q\tC\u0003Qu\u0002\u0007!\u000bC\u0003\\u\u0002\u0007Q\fC\u0003fu\u0002\u0007q\rC\u0003nu\u0002\u0007a\u000e\u0003\u0005\u0002\u0012\u0001\u0011\r\u0011\"\u0003\u0011\u0003=\u0019xnY6fiRKW.Z8vi6\u001b\bbBA\u000b\u0001\u0001\u0006I!E\u0001\u0011g>\u001c7.\u001a;US6,w.\u001e;Ng\u0002Bq!!\u0007\u0001\t\u0003\nY\"\u0001\u0004e_^{'o\u001b\u000b\u0003\u0003;\u00012AEA\u0010\u0013\r\t\tc\u0005\u0002\u0005+:LG\u000fC\u0004\u0002&\u0001!I!a\n\u0002\u0017\t\u0014xn[3s%\u0016\fG-\u001f\u000b\u0003\u0003S\u00012AEA\u0016\u0013\r\tic\u0005\u0002\b\u0005>|G.Z1o\u0001")
public class RequestSendThread
extends ShutdownableThread {
    private final int controllerId;
    private final ControllerContext controllerContext;
    private final BlockingQueue<QueueItem> queue;
    private final NetworkClient networkClient;
    private final Node brokerNode;
    private final KafkaConfig config;
    private final Time time;
    private final StateChangeLogger stateChangeLogger;
    private final int socketTimeoutMs;

    public int controllerId() {
        return this.controllerId;
    }

    public ControllerContext controllerContext() {
        return this.controllerContext;
    }

    public BlockingQueue<QueueItem> queue() {
        return this.queue;
    }

    public NetworkClient networkClient() {
        return this.networkClient;
    }

    public Node brokerNode() {
        return this.brokerNode;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public Time time() {
        return this.time;
    }

    public StateChangeLogger stateChangeLogger() {
        return this.stateChangeLogger;
    }

    private int socketTimeoutMs() {
        return this.socketTimeoutMs;
    }

    @Override
    public void doWork() {
        block11: {
            QueueItem queueItem = this.queue().take();
            if (queueItem == null) {
                throw new MatchError((Object)queueItem);
            }
            ApiKeys apiKey = queueItem.apiKey();
            AbstractRequest.Builder<? extends AbstractRequest> requestBuilder = queueItem.request();
            Function1<AbstractResponse, BoxedUnit> callback = queueItem.callback();
            Tuple3 tuple3 = new Tuple3((Object)apiKey, requestBuilder, callback);
            Tuple3 tuple32 = tuple3;
            ApiKeys apiKey2 = (ApiKeys)((Object)tuple32._1());
            AbstractRequest.Builder requestBuilder2 = (AbstractRequest.Builder)tuple32._2();
            Function1 callback2 = (Function1)tuple32._3();
            ClientResponse clientResponse = null;
            try {
                ApiKeys api;
                boolean isSendSuccessful = false;
                while (this.isRunning() && !isSendSuccessful) {
                    try {
                        if (!this.brokerReady()) {
                            isSendSuccessful = false;
                            this.backoff$1();
                            continue;
                        }
                        ClientRequest clientRequest = this.networkClient().newClientRequest(this.brokerNode().idString(), requestBuilder2, this.time().milliseconds(), true);
                        clientResponse = NetworkClientUtils.sendAndReceive(this.networkClient(), clientRequest, this.time());
                        isSendSuccessful = true;
                    }
                    catch (Throwable e) {
                        this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Controller ", " epoch ", " fails to send request ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.controllerContext().epoch()), requestBuilder2})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"to broker ", ". Reconnecting to broker."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.brokerNode()})), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                        this.networkClient().close(this.brokerNode().idString());
                        isSendSuccessful = false;
                        this.backoff$1();
                    }
                }
                if (clientResponse == null) break block11;
                RequestHeader requestHeader = clientResponse.requestHeader();
                ApiKeys apiKeys = api = requestHeader.apiKey();
                ApiKeys apiKeys2 = ApiKeys.LEADER_AND_ISR;
                if (apiKeys == null ? apiKeys2 != null : !((Object)((Object)apiKeys)).equals((Object)apiKeys2)) {
                    ApiKeys apiKeys3 = api;
                    ApiKeys apiKeys4 = ApiKeys.STOP_REPLICA;
                    if (apiKeys3 == null ? apiKeys4 != null : !((Object)((Object)apiKeys3)).equals((Object)apiKeys4)) {
                        ApiKeys apiKeys5 = api;
                        ApiKeys apiKeys6 = ApiKeys.UPDATE_METADATA;
                        if (apiKeys5 == null ? apiKeys6 != null : !((Object)((Object)apiKeys5)).equals((Object)apiKeys6)) {
                            throw new KafkaException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected apiKey received: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{apiKey2})));
                        }
                    }
                }
                AbstractResponse response = clientResponse.responseBody();
                this.stateChangeLogger().withControllerEpoch(this.controllerContext().epoch()).trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Received response "})).s((Seq)Nil$.MODULE$) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " for request ", " with correlation id "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{response.toString(requestHeader.apiVersion()), api})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " sent to broker ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)requestHeader.correlationId()), this.brokerNode()})));
                if (callback2 != null) {
                    callback2.apply((Object)response);
                }
            }
            catch (Throwable e) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Controller ", " fails to send a request to broker ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), this.brokerNode()})), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                this.networkClient().close(this.brokerNode().idString());
            }
        }
    }

    private boolean brokerReady() {
        boolean bl;
        try {
            if (!NetworkClientUtils.isReady(this.networkClient(), this.brokerNode(), this.time().milliseconds())) {
                if (!NetworkClientUtils.awaitReady(this.networkClient(), this.brokerNode(), this.time(), this.socketTimeoutMs())) {
                    throw new SocketTimeoutException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to connect within ", " ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.socketTimeoutMs())})));
                }
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Controller ", " connected to ", " for sending state change requests"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), this.brokerNode()})));
            }
            bl = true;
        }
        catch (Throwable e) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Controller ", "'s connection to broker ", " was unsuccessful"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), this.brokerNode()})), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            this.networkClient().close(this.brokerNode().idString());
            bl = false;
        }
        return bl;
    }

    private final void backoff$1() {
        this.pause(100L, TimeUnit.MILLISECONDS);
    }

    public RequestSendThread(int controllerId, ControllerContext controllerContext, BlockingQueue<QueueItem> queue, NetworkClient networkClient, Node brokerNode, KafkaConfig config, Time time, StateChangeLogger stateChangeLogger, String name) {
        this.controllerId = controllerId;
        this.controllerContext = controllerContext;
        this.queue = queue;
        this.networkClient = networkClient;
        this.brokerNode = brokerNode;
        this.config = config;
        this.time = time;
        this.stateChangeLogger = stateChangeLogger;
        super(name, ShutdownableThread$.MODULE$.$lessinit$greater$default$2());
        this.logIdent_$eq(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[RequestSendThread controllerId=", "] "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)controllerId)})));
        this.socketTimeoutMs = config.controllerSocketTimeoutMs();
    }
}

