/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.consumer;

import com.typesafe.scalalogging.Logger;
import io.confluent.kafka.common.KafkaException;
import io.confluent.kafka.consumer.Blacklist;
import io.confluent.kafka.consumer.ConsumerThreadId;
import io.confluent.kafka.consumer.StaticTopicCount;
import io.confluent.kafka.consumer.TopicCount;
import io.confluent.kafka.consumer.TopicFilter;
import io.confluent.kafka.consumer.Whitelist;
import io.confluent.kafka.consumer.WildcardTopicCount;
import io.confluent.kafka.utils.Json$;
import io.confluent.kafka.utils.Logging;
import io.confluent.kafka.utils.ZKGroupDirs;
import io.confluent.kafka.utils.ZkUtils;
import io.confluent.kafka.utils.json.DecodeJson$;
import io.confluent.kafka.utils.json.DecodeJson$DecodeInt$;
import io.confluent.kafka.utils.json.DecodeJson$DecodeString$;
import io.confluent.kafka.utils.json.JsonObject;
import io.confluent.kafka.utils.json.JsonValue;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Set;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class TopicCount$
implements Logging {
    public static TopicCount$ MODULE$;
    private final String whiteListPattern;
    private final String blackListPattern;
    private final String staticPattern;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new TopicCount$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        TopicCount$ topicCount$ = this;
        synchronized (topicCount$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String whiteListPattern() {
        return this.whiteListPattern;
    }

    public String blackListPattern() {
        return this.blackListPattern;
    }

    public String staticPattern() {
        return this.staticPattern;
    }

    public String makeThreadId(String consumerIdString, int threadId) {
        return consumerIdString + "-" + threadId;
    }

    /*
     * WARNING - void declaration
     */
    public HashMap<String, Set<ConsumerThreadId>> makeConsumerThreadIdsPerTopic(String consumerIdString, Map<String, Object> topicCountMap) {
        void var3_3;
        HashMap consumerThreadIdsPerTopicMap = new HashMap();
        topicCountMap.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)TopicCount$.$anonfun$makeConsumerThreadIdsPerTopic$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String topic = (String)tuple2._1();
            int nConsumers = tuple2._2$mcI$sp();
            HashSet consumerSet = new HashSet();
            Predef$.MODULE$.assert(nConsumers >= 1);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), nConsumers).foreach((Function1 & Serializable & scala.Serializable)i -> consumerSet.$plus$eq((Object)new ConsumerThreadId(consumerIdString, BoxesRunTime.unboxToInt((Object)i))));
            Option option = consumerThreadIdsPerTopicMap.put((Object)topic, (Object)consumerSet);
            return option;
        });
        return var3_3;
    }

    public TopicCount constructTopicCount(String group, String consumerId, ZkUtils zkUtils, boolean excludeInternalTopics) {
        TopicCount topicCount;
        ZKGroupDirs dirs = new ZKGroupDirs(group);
        String topicCountString = (String)zkUtils.readData(dirs.consumerRegistryDir() + "/" + consumerId)._1();
        String subscriptionPattern = null;
        Map topMap = null;
        try {
            Option<JsonValue> option = Json$.MODULE$.parseFull(topicCountString);
            if (option instanceof Some) {
                Some some = (Some)option;
                JsonValue js = (JsonValue)some.value();
                JsonObject consumerRegistrationMap = js.asJsonObject();
                Option<JsonValue> option2 = consumerRegistrationMap.get("pattern");
                if (!(option2 instanceof Some)) {
                    if (None$.MODULE$.equals(option2)) {
                        throw new KafkaException("error constructing TopicCount : " + topicCountString);
                    }
                    throw new MatchError(option2);
                }
                Some some2 = (Some)option2;
                JsonValue pattern = (JsonValue)some2.value();
                subscriptionPattern = pattern.to(DecodeJson$DecodeString$.MODULE$);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                Option<JsonValue> option3 = consumerRegistrationMap.get("subscription");
                if (!(option3 instanceof Some)) {
                    if (None$.MODULE$.equals(option3)) {
                        throw new KafkaException("error constructing TopicCount : " + topicCountString);
                    }
                    throw new MatchError(option3);
                }
                Some some3 = (Some)option3;
                JsonValue sub = (JsonValue)some3.value();
                topMap = (Map)sub.to(DecodeJson$.MODULE$.decodeMap(DecodeJson$DecodeInt$.MODULE$, Map$.MODULE$.canBuildFrom()));
                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
            } else {
                if (None$.MODULE$.equals(option)) {
                    throw new KafkaException("error constructing TopicCount : " + topicCountString);
                }
                throw new MatchError(option);
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        catch (Throwable e) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "error parsing consumer json string " + topicCountString, (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            throw e;
        }
        boolean hasWhiteList = this.whiteListPattern().equals(subscriptionPattern);
        boolean hasBlackList = this.blackListPattern().equals(subscriptionPattern);
        if (topMap.isEmpty() || !hasWhiteList && !hasBlackList) {
            topicCount = new StaticTopicCount(consumerId, (Map<String, Object>)topMap);
        } else {
            String regex = (String)((Tuple2)topMap.head())._1();
            int numStreams = ((Tuple2)topMap.head())._2$mcI$sp();
            TopicFilter filter = hasWhiteList ? new Whitelist(regex) : new Blacklist(regex);
            topicCount = new WildcardTopicCount(zkUtils, consumerId, filter, numStreams, excludeInternalTopics);
        }
        return topicCount;
    }

    public StaticTopicCount constructTopicCount(String consumerIdString, Map<String, Object> topicCount) {
        return new StaticTopicCount(consumerIdString, topicCount);
    }

    public WildcardTopicCount constructTopicCount(String consumerIdString, TopicFilter filter, int numStreams, ZkUtils zkUtils, boolean excludeInternalTopics) {
        return new WildcardTopicCount(zkUtils, consumerIdString, filter, numStreams, excludeInternalTopics);
    }

    public static final /* synthetic */ boolean $anonfun$makeConsumerThreadIdsPerTopic$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    private TopicCount$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.whiteListPattern = "white_list";
        this.blackListPattern = "black_list";
        this.staticPattern = "static";
    }
}

