/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.consumer;

import com.typesafe.scalalogging.Logger;
import io.confluent.kafka.api.FetchRequest;
import io.confluent.kafka.api.FetchResponse;
import io.confluent.kafka.api.FetchResponse$;
import io.confluent.kafka.api.GroupCoordinatorRequest;
import io.confluent.kafka.api.GroupCoordinatorResponse;
import io.confluent.kafka.api.GroupCoordinatorResponse$;
import io.confluent.kafka.api.OffsetCommitRequest;
import io.confluent.kafka.api.OffsetCommitResponse;
import io.confluent.kafka.api.OffsetCommitResponse$;
import io.confluent.kafka.api.OffsetFetchRequest;
import io.confluent.kafka.api.OffsetFetchResponse;
import io.confluent.kafka.api.OffsetFetchResponse$;
import io.confluent.kafka.api.OffsetRequest;
import io.confluent.kafka.api.OffsetRequest$;
import io.confluent.kafka.api.OffsetResponse;
import io.confluent.kafka.api.OffsetResponse$;
import io.confluent.kafka.api.PartitionOffsetRequestInfo;
import io.confluent.kafka.api.PartitionOffsetsResponse;
import io.confluent.kafka.api.RequestOrResponse;
import io.confluent.kafka.api.TopicMetadataRequest;
import io.confluent.kafka.api.TopicMetadataResponse;
import io.confluent.kafka.api.TopicMetadataResponse$;
import io.confluent.kafka.common.ErrorMapping$;
import io.confluent.kafka.common.TopicAndPartition;
import io.confluent.kafka.consumer.ConsumerConfig$;
import io.confluent.kafka.consumer.FetchRequestAndResponseStats;
import io.confluent.kafka.consumer.FetchRequestAndResponseStatsRegistry$;
import io.confluent.kafka.metrics.KafkaTimer;
import io.confluent.kafka.network.BlockingChannel;
import io.confluent.kafka.network.BlockingChannel$;
import io.confluent.kafka.utils.Logging;
import io.confluent.org.apache.kafka.common.network.NetworkReceive;
import io.confluent.org.apache.kafka.common.protocol.Errors;
import io.confluent.org.apache.kafka.common.utils.Utils;
import java.io.Serializable;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ClosedByInterruptException;
import java.util.concurrent.TimeUnit;
import scala.Function0;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005}g\u0001B\u0001\u0003\u0001\u001d\u0011abU5na2,7i\u001c8tk6,'O\u0003\u0002\u0004\t\u0005A1m\u001c8tk6,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001\u0001\u0005\u000f!\tIA\"D\u0001\u000b\u0015\u0005Y\u0011!B:dC2\f\u0017BA\u0007\u000b\u0005\u0019\te.\u001f*fMB\u0011qBE\u0007\u0002!)\u0011\u0011\u0003B\u0001\u0006kRLGn]\u0005\u0003'A\u0011q\u0001T8hO&tw\r\u0003\u0005\u0016\u0001\t\u0015\r\u0011\"\u0001\u0017\u0003\u0011Awn\u001d;\u0016\u0003]\u0001\"\u0001G\u0010\u000f\u0005ei\u0002C\u0001\u000e\u000b\u001b\u0005Y\"B\u0001\u000f\u0007\u0003\u0019a$o\\8u}%\u0011aDC\u0001\u0007!J,G-\u001a4\n\u0005\u0001\n#AB*ue&twM\u0003\u0002\u001f\u0015!A1\u0005\u0001B\u0001B\u0003%q#A\u0003i_N$\b\u0005\u0003\u0005&\u0001\t\u0015\r\u0011\"\u0001'\u0003\u0011\u0001xN\u001d;\u0016\u0003\u001d\u0002\"!\u0003\u0015\n\u0005%R!aA%oi\"A1\u0006\u0001B\u0001B\u0003%q%A\u0003q_J$\b\u0005\u0003\u0005.\u0001\t\u0015\r\u0011\"\u0001'\u0003%\u0019x\u000eV5nK>,H\u000f\u0003\u00050\u0001\t\u0005\t\u0015!\u0003(\u0003)\u0019x\u000eV5nK>,H\u000f\t\u0005\tc\u0001\u0011)\u0019!C\u0001M\u0005Q!-\u001e4gKJ\u001c\u0016N_3\t\u0011M\u0002!\u0011!Q\u0001\n\u001d\n1BY;gM\u0016\u00148+\u001b>fA!AQ\u0007\u0001BC\u0002\u0013\u0005a#\u0001\u0005dY&,g\u000e^%e\u0011!9\u0004A!A!\u0002\u00139\u0012!C2mS\u0016tG/\u00133!\u0011\u0015I\u0004\u0001\"\u0001;\u0003\u0019a\u0014N\\5u}Q11(\u0010 @\u0001\u0006\u0003\"\u0001\u0010\u0001\u000e\u0003\tAQ!\u0006\u001dA\u0002]AQ!\n\u001dA\u0002\u001dBQ!\f\u001dA\u0002\u001dBQ!\r\u001dA\u0002\u001dBQ!\u000e\u001dA\u0002]Aqa\u0011\u0001C\u0002\u0013%A)\u0001\u0003m_\u000e\\W#A#\u0011\u0005\u0019[U\"A$\u000b\u0005!K\u0015\u0001\u00027b]\u001eT\u0011AS\u0001\u0005U\u00064\u0018-\u0003\u0002M\u000f\n1qJ\u00196fGRDaA\u0014\u0001!\u0002\u0013)\u0015!\u00027pG.\u0004\u0003b\u0002)\u0001\u0005\u0004%I!U\u0001\u0010E2|7m[5oO\u000eC\u0017M\u001c8fYV\t!\u000b\u0005\u0002T-6\tAK\u0003\u0002V\t\u00059a.\u001a;x_J\\\u0017BA,U\u0005=\u0011En\\2lS:<7\t[1o]\u0016d\u0007BB-\u0001A\u0003%!+\u0001\tcY>\u001c7.\u001b8h\u0007\"\fgN\\3mA!91\f\u0001b\u0001\n\u0013a\u0016\u0001\b4fi\u000eD'+Z9vKN$\u0018I\u001c3SKN\u0004xN\\:f'R\fGo]\u000b\u0002;B\u0011AHX\u0005\u0003?\n\u0011ADR3uG\"\u0014V-];fgR\fe\u000e\u001a*fgB|gn]3Ti\u0006$8\u000f\u0003\u0004b\u0001\u0001\u0006I!X\u0001\u001eM\u0016$8\r\u001b*fcV,7\u000f^!oIJ+7\u000f]8og\u0016\u001cF/\u0019;tA!91\r\u0001a\u0001\n\u0013!\u0017\u0001C5t\u00072|7/\u001a3\u0016\u0003\u0015\u0004\"!\u00034\n\u0005\u001dT!a\u0002\"p_2,\u0017M\u001c\u0005\bS\u0002\u0001\r\u0011\"\u0003k\u00031I7o\u00117pg\u0016$w\fJ3r)\tYg\u000e\u0005\u0002\nY&\u0011QN\u0003\u0002\u0005+:LG\u000fC\u0004pQ\u0006\u0005\t\u0019A3\u0002\u0007a$\u0013\u0007\u0003\u0004r\u0001\u0001\u0006K!Z\u0001\nSN\u001cEn\\:fI\u0002BQa\u001d\u0001\u0005\nQ\fqaY8o]\u0016\u001cG\u000fF\u0001S\u0011\u00151\b\u0001\"\u0003x\u0003)!\u0017n]2p]:,7\r\u001e\u000b\u0002W\")\u0011\u0010\u0001C\u0005o\u0006I!/Z2p]:,7\r\u001e\u0005\u0006w\u0002!\ta^\u0001\u001cI&\u001c8m\u001c8oK\u000e$Hk\u001c%b]\u0012dWMS1wC&{%)^4\t\u000bu\u0004A\u0011A<\u0002\u000b\rdwn]3\t\r}\u0004A\u0011BA\u0001\u0003-\u0019XM\u001c3SKF,Xm\u001d;\u0015\t\u0005\r\u00111\u0004\t\u0005\u0003\u000b\t9\"\u0004\u0002\u0002\b)\u0019Q+!\u0003\u000b\t\u0005-\u0011QB\u0001\u0007G>lWn\u001c8\u000b\u0007\u0015\tyA\u0003\u0003\u0002\u0012\u0005M\u0011AB1qC\u000eDWM\u0003\u0002\u0002\u0016\u0005\u0019qN]4\n\t\u0005e\u0011q\u0001\u0002\u000f\u001d\u0016$xo\u001c:l%\u0016\u001cW-\u001b<f\u0011\u001d\tiB a\u0001\u0003?\tqA]3rk\u0016\u001cH\u000f\u0005\u0003\u0002\"\u0005\u001dRBAA\u0012\u0015\r\t)\u0003B\u0001\u0004CBL\u0017\u0002BA\u0015\u0003G\u0011\u0011CU3rk\u0016\u001cHo\u0014:SKN\u0004xN\\:f\u0011\u001d\ti\u0003\u0001C\u0001\u0003_\tAa]3oIR!\u0011\u0011GA\u001c!\u0011\t\t#a\r\n\t\u0005U\u00121\u0005\u0002\u0016)>\u0004\u0018nY'fi\u0006$\u0017\r^1SKN\u0004xN\\:f\u0011!\ti\"a\u000bA\u0002\u0005e\u0002\u0003BA\u0011\u0003wIA!!\u0010\u0002$\t!Bk\u001c9jG6+G/\u00193bi\u0006\u0014V-];fgRDq!!\f\u0001\t\u0003\t\t\u0005\u0006\u0003\u0002D\u0005%\u0003\u0003BA\u0011\u0003\u000bJA!a\u0012\u0002$\tArI]8va\u000e{wN\u001d3j]\u0006$xN\u001d*fgB|gn]3\t\u0011\u0005u\u0011q\ba\u0001\u0003\u0017\u0002B!!\t\u0002N%!\u0011qJA\u0012\u0005]9%o\\;q\u0007>|'\u000fZ5oCR|'OU3rk\u0016\u001cH\u000fC\u0004\u0002T\u0001!\t!!\u0016\u0002\u000b\u0019,Go\u00195\u0015\t\u0005]\u0013Q\f\t\u0005\u0003C\tI&\u0003\u0003\u0002\\\u0005\r\"!\u0004$fi\u000eD'+Z:q_:\u001cX\r\u0003\u0005\u0002\u001e\u0005E\u0003\u0019AA0!\u0011\t\t#!\u0019\n\t\u0005\r\u00141\u0005\u0002\r\r\u0016$8\r\u001b*fcV,7\u000f\u001e\u0005\b\u0003O\u0002A\u0011AA5\u0003A9W\r^(gMN,Go\u001d\"fM>\u0014X\r\u0006\u0003\u0002l\u0005E\u0004\u0003BA\u0011\u0003[JA!a\u001c\u0002$\tqqJ\u001a4tKR\u0014Vm\u001d9p]N,\u0007\u0002CA\u000f\u0003K\u0002\r!a\u001d\u0011\t\u0005\u0005\u0012QO\u0005\u0005\u0003o\n\u0019CA\u0007PM\u001a\u001cX\r\u001e*fcV,7\u000f\u001e\u0005\b\u0003w\u0002A\u0011AA?\u00035\u0019w.\\7ji>3gm]3ugR!\u0011qPAC!\u0011\t\t#!!\n\t\u0005\r\u00151\u0005\u0002\u0015\u001f\u001a47/\u001a;D_6l\u0017\u000e\u001e*fgB|gn]3\t\u0011\u0005u\u0011\u0011\u0010a\u0001\u0003\u000f\u0003B!!\t\u0002\n&!\u00111RA\u0012\u0005MyeMZ:fi\u000e{W.\\5u%\u0016\fX/Z:u\u0011\u001d\ty\t\u0001C\u0001\u0003#\u000bABZ3uG\"|eMZ:fiN$B!a%\u0002\u001aB!\u0011\u0011EAK\u0013\u0011\t9*a\t\u0003'=3gm]3u\r\u0016$8\r\u001b*fgB|gn]3\t\u0011\u0005u\u0011Q\u0012a\u0001\u00037\u0003B!!\t\u0002\u001e&!\u0011qTA\u0012\u0005IyeMZ:fi\u001a+Go\u00195SKF,Xm\u001d;\t\r\u0005\r\u0006\u0001\"\u0003x\u0003M9W\r^(s\u001b\u0006\\WmQ8o]\u0016\u001cG/[8o\u0011\u001d\t9\u000b\u0001C\u0001\u0003S\u000ba#Z1sY&,7\u000f^(s\u0019\u0006$Xm\u001d;PM\u001a\u001cX\r\u001e\u000b\t\u0003W\u000b\t,a0\u0002DB\u0019\u0011\"!,\n\u0007\u0005=&B\u0001\u0003M_:<\u0007\u0002CAZ\u0003K\u0003\r!!.\u0002#Q|\u0007/[2B]\u0012\u0004\u0016M\u001d;ji&|g\u000e\u0005\u0003\u00028\u0006mVBAA]\u0015\r\tY\u0001B\u0005\u0005\u0003{\u000bILA\tU_BL7-\u00118e!\u0006\u0014H/\u001b;j_:D\u0001\"!1\u0002&\u0002\u0007\u00111V\u0001\u0011K\u0006\u0014H.[3ti>\u0013H*\u0019;fgRDq!!2\u0002&\u0002\u0007q%\u0001\u0006d_:\u001cX/\\3s\u0013\u0012D3\u0001AAe!\ry\u00111Z\u0005\u0004\u0003\u001b\u0004\"A\u0003;ie\u0016\fGm]1gK\":\u0001!!5\u0002X\u0006m\u0007cA\u0005\u0002T&\u0019\u0011Q\u001b\u0006\u0003\u0015\u0011,\u0007O]3dCR,G-\t\u0002\u0002Z\u0006\t9\u0002\u00165jg\u0002\u001aG.Y:tA!\f7\u000f\t2fK:\u0004C-\u001a9sK\u000e\fG/\u001a3!C:$\u0007e^5mY\u0002\u0012W\r\t:f[>4X\r\u001a\u0011j]\u0002\n\u0007EZ;ukJ,\u0007E]3mK\u0006\u001cXM\f\u0011QY\u0016\f7/\u001a\u0011vg\u0016\u0004sN]4/CB\f7\r[3/W\u000647.\u0019\u0018dY&,g\u000e^:/G>t7/^7fe:Z\u0015MZ6b\u0007>t7/^7fe\u0002Jgn\u001d;fC\u0012t\u0013EAAo\u0003!\u0001d&M\u0019/a9\u0002\u0004")
public class SimpleConsumer
implements Logging {
    private final String host;
    private final int port;
    private final int soTimeout;
    private final int bufferSize;
    private final String clientId;
    private final Object lock;
    private final BlockingChannel blockingChannel;
    private final FetchRequestAndResponseStats fetchRequestAndResponseStats;
    private boolean isClosed;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        SimpleConsumer simpleConsumer = this;
        synchronized (simpleConsumer) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public int soTimeout() {
        return this.soTimeout;
    }

    public int bufferSize() {
        return this.bufferSize;
    }

    public String clientId() {
        return this.clientId;
    }

    private Object lock() {
        return this.lock;
    }

    private BlockingChannel blockingChannel() {
        return this.blockingChannel;
    }

    private FetchRequestAndResponseStats fetchRequestAndResponseStats() {
        return this.fetchRequestAndResponseStats;
    }

    private boolean isClosed() {
        return this.isClosed;
    }

    private void isClosed_$eq(boolean x$1) {
        this.isClosed = x$1;
    }

    private BlockingChannel connect() {
        this.close();
        this.blockingChannel().connect();
        return this.blockingChannel();
    }

    private void disconnect() {
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Disconnecting from " + Utils.formatAddress(this.host(), Predef$.MODULE$.int2Integer(this.port())));
        this.blockingChannel().disconnect();
    }

    private void reconnect() {
        this.disconnect();
        this.connect();
    }

    public void disconnectToHandleJavaIOBug() {
        this.disconnect();
    }

    public void close() {
        Object object = this.lock();
        synchronized (object) {
            this.disconnect();
            this.isClosed_$eq(true);
        }
    }

    private NetworkReceive sendRequest(RequestOrResponse request) {
        NetworkReceive networkReceive;
        Object object = this.lock();
        synchronized (object) {
            ObjectRef response = ObjectRef.create(null);
            this.liftedTree1$1(request, response);
            networkReceive = (NetworkReceive)response.elem;
        }
        return networkReceive;
    }

    public TopicMetadataResponse send(TopicMetadataRequest request) {
        NetworkReceive response = this.sendRequest(request);
        return TopicMetadataResponse$.MODULE$.readFrom(response.payload());
    }

    public GroupCoordinatorResponse send(GroupCoordinatorRequest request) {
        NetworkReceive response = this.sendRequest(request);
        return GroupCoordinatorResponse$.MODULE$.readFrom(response.payload());
    }

    public FetchResponse fetch(FetchRequest request) {
        ObjectRef response = ObjectRef.create(null);
        KafkaTimer specificTimer = this.fetchRequestAndResponseStats().getFetchRequestAndResponseStats(this.host(), this.port()).requestTimer();
        KafkaTimer aggregateTimer = this.fetchRequestAndResponseStats().getFetchRequestAndResponseAllBrokersStats().requestTimer();
        aggregateTimer.time((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> specificTimer.time((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            response$2.elem = this.sendRequest(request);
        }));
        FetchResponse fetchResponse = FetchResponse$.MODULE$.readFrom(((NetworkReceive)response.elem).payload(), request.versionId());
        int fetchedSize = fetchResponse.sizeInBytes();
        this.fetchRequestAndResponseStats().getFetchRequestAndResponseStats(this.host(), this.port()).requestSizeHist().update(fetchedSize);
        this.fetchRequestAndResponseStats().getFetchRequestAndResponseAllBrokersStats().requestSizeHist().update(fetchedSize);
        this.fetchRequestAndResponseStats().getFetchRequestAndResponseStats(this.host(), this.port()).throttleTimeStats().update((long)fetchResponse.throttleTimeMs(), TimeUnit.MILLISECONDS);
        this.fetchRequestAndResponseStats().getFetchRequestAndResponseAllBrokersStats().throttleTimeStats().update((long)fetchResponse.throttleTimeMs(), TimeUnit.MILLISECONDS);
        return fetchResponse;
    }

    public OffsetResponse getOffsetsBefore(OffsetRequest request) {
        return OffsetResponse$.MODULE$.readFrom(this.sendRequest(request).payload());
    }

    public OffsetCommitResponse commitOffsets(OffsetCommitRequest request) {
        return OffsetCommitResponse$.MODULE$.readFrom(this.sendRequest(request).payload());
    }

    public OffsetFetchResponse fetchOffsets(OffsetFetchRequest request) {
        return OffsetFetchResponse$.MODULE$.readFrom(this.sendRequest(request).payload(), request.versionId());
    }

    private void getOrMakeConnection() {
        block0: {
            if (this.isClosed() || this.blockingChannel().isConnected()) break block0;
            this.connect();
        }
    }

    public long earliestOrLatestOffset(TopicAndPartition topicAndPartition, long earliestOrLatest, int consumerId) {
        int x$5;
        Map x$1 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicAndPartition), (Object)new PartitionOffsetRequestInfo(earliestOrLatest, 1))}));
        String x$2 = this.clientId();
        int x$3 = consumerId;
        short x$4 = OffsetRequest$.MODULE$.apply$default$2();
        OffsetRequest request = new OffsetRequest((Map<TopicAndPartition, PartitionOffsetRequestInfo>)x$1, x$4, x$5 = OffsetRequest$.MODULE$.apply$default$3(), x$2, x$3);
        PartitionOffsetsResponse partitionErrorAndOffset = (PartitionOffsetsResponse)this.getOffsetsBefore(request).partitionErrorAndOffsets().apply((Object)topicAndPartition);
        Errors errors = partitionErrorAndOffset.error();
        if (!((Object)((Object)Errors.NONE)).equals((Object)errors)) {
            throw ErrorMapping$.MODULE$.exceptionFor(partitionErrorAndOffset.error().code());
        }
        long l = BoxesRunTime.unboxToLong((Object)partitionErrorAndOffset.offsets().head());
        long offset = l;
        return offset;
    }

    private final void liftedTree1$1(RequestOrResponse request$1, ObjectRef response$1) {
        try {
            this.getOrMakeConnection();
            this.blockingChannel().send(request$1);
            response$1.elem = this.blockingChannel().receive();
        }
        catch (ClosedByInterruptException e) {
            throw e;
        }
        catch (AsynchronousCloseException e) {
            throw e;
        }
        catch (Throwable e) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Reconnect due to error:", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            try {
                this.reconnect();
                this.blockingChannel().send(request$1);
                response$1.elem = this.blockingChannel().receive();
            }
            catch (Throwable e2) {
                this.disconnect();
                throw e2;
            }
        }
    }

    public SimpleConsumer(String host, int port, int soTimeout, int bufferSize, String clientId) {
        this.host = host;
        this.port = port;
        this.soTimeout = soTimeout;
        this.bufferSize = bufferSize;
        this.clientId = clientId;
        Logging.$init$(this);
        ConsumerConfig$.MODULE$.validateClientId(clientId);
        this.lock = new Object();
        this.blockingChannel = new BlockingChannel(host, port, bufferSize, BlockingChannel$.MODULE$.UseDefaultBufferSize(), soTimeout);
        this.fetchRequestAndResponseStats = FetchRequestAndResponseStatsRegistry$.MODULE$.getFetchRequestAndResponseStats(clientId);
        this.isClosed = false;
    }
}

