/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.common;

import io.confluent.kafka.common.InterBrokerSendThread$;
import io.confluent.kafka.common.RequestAndCompletionHandler;
import io.confluent.kafka.utils.ShutdownableThread;
import io.confluent.org.apache.kafka.clients.ClientRequest;
import io.confluent.org.apache.kafka.clients.ClientResponse;
import io.confluent.org.apache.kafka.clients.NetworkClient;
import io.confluent.org.apache.kafka.clients.RequestCompletionHandler;
import io.confluent.org.apache.kafka.common.internals.FatalExitError;
import io.confluent.org.apache.kafka.common.requests.RequestHeader;
import io.confluent.org.apache.kafka.common.utils.Time;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;

@ScalaSignature(bytes="\u0006\u0001M4Q!\u0001\u0002\u0002\u0002\u001d\u0011Q#\u00138uKJ\u0014%o\\6feN+g\u000e\u001a+ie\u0016\fGM\u0003\u0002\u0004\t\u000511m\\7n_:T\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\u0002\u0005\u0002\n\u00195\t!B\u0003\u0002\f\t\u0005)Q\u000f^5mg&\u0011QB\u0003\u0002\u0013'\",H\u000fZ8x]\u0006\u0014G.\u001a+ie\u0016\fG\rC\u0005\u0010\u0001\t\u0005\t\u0015!\u0003\u0011;\u0005!a.Y7f!\t\t\"D\u0004\u0002\u00131A\u00111CF\u0007\u0002))\u0011QCB\u0001\u0007yI|w\u000e\u001e \u000b\u0003]\tQa]2bY\u0006L!!\u0007\f\u0002\rA\u0013X\rZ3g\u0013\tYBD\u0001\u0004TiJLgn\u001a\u0006\u00033YI!a\u0004\u0007\t\u0011}\u0001!\u0011!Q\u0001\n\u0001\nQB\\3uo>\u00148n\u00117jK:$\bCA\u0011*\u001b\u0005\u0011#BA\u0012%\u0003\u001d\u0019G.[3oiNT!!B\u0013\u000b\u0005\u0019:\u0013AB1qC\u000eDWMC\u0001)\u0003\ry'oZ\u0005\u0003U\t\u0012QBT3uo>\u00148n\u00117jK:$\b\u0002\u0003\u0017\u0001\u0005\u0003\u0005\u000b\u0011B\u0017\u0002\tQLW.\u001a\t\u0003]Ej\u0011a\f\u0006\u0003\u0017AR!a\u0001\u0013\n\u0005Iz#\u0001\u0002+j[\u0016D\u0011\u0002\u000e\u0001\u0003\u0002\u0003\u0006I!N\u001d\u0002\u001f%\u001c\u0018J\u001c;feJ,\b\u000f^5cY\u0016\u0004\"AN\u001c\u000e\u0003YI!\u0001\u000f\f\u0003\u000f\t{w\u000e\\3b]&\u0011A\u0007\u0004\u0005\u0006w\u0001!\t\u0001P\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000buz\u0004)\u0011\"\u0011\u0005y\u0002Q\"\u0001\u0002\t\u000b=Q\u0004\u0019\u0001\t\t\u000b}Q\u0004\u0019\u0001\u0011\t\u000b1R\u0004\u0019A\u0017\t\u000fQR\u0004\u0013!a\u0001k!)A\t\u0001D\u0001\u000b\u0006\u0001r-\u001a8fe\u0006$XMU3rk\u0016\u001cHo\u001d\u000b\u0002\rB\u0019q\tT(\u000f\u0005!SeBA\nJ\u0013\u00059\u0012BA&\u0017\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u0014(\u0003\u0011%#XM]1cY\u0016T!a\u0013\f\u0011\u0005y\u0002\u0016BA)\u0003\u0005m\u0011V-];fgR\fe\u000eZ\"p[BdW\r^5p]\"\u000bg\u000e\u001a7fe\")1\u000b\u0001C!)\u0006A1\u000f[;uI><h\u000eF\u0001V!\t1d+\u0003\u0002X-\t!QK\\5u\u0011\u0015I\u0006\u0001\"\u0011U\u0003\u0019!wnV8sW\")1\f\u0001C\u0001)\u00061q/Y6fkB<q!\u0018\u0002\u0002\u0002#\u0005a,A\u000bJ]R,'O\u0011:pW\u0016\u00148+\u001a8e)\"\u0014X-\u00193\u0011\u0005yzfaB\u0001\u0003\u0003\u0003E\t\u0001Y\n\u0003?\u0006\u0004\"A\u000e2\n\u0005\r4\"AB!osJ+g\rC\u0003<?\u0012\u0005Q\rF\u0001_\u0011\u001d9w,%A\u0005\u0002!\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\"T#A5+\u0005UR7&A6\u0011\u00051\fX\"A7\u000b\u00059|\u0017!C;oG\",7m[3e\u0015\t\u0001h#\u0001\u0006b]:|G/\u0019;j_:L!A]7\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
public abstract class InterBrokerSendThread
extends ShutdownableThread {
    private final NetworkClient networkClient;
    private final Time time;

    public static boolean $lessinit$greater$default$4() {
        return InterBrokerSendThread$.MODULE$.$lessinit$greater$default$4();
    }

    public abstract Iterable<RequestAndCompletionHandler> generateRequests();

    @Override
    public void shutdown() {
        this.initiateShutdown();
        this.networkClient.wakeup();
        this.awaitShutdown();
    }

    @Override
    public void doWork() {
        long now = this.time.milliseconds();
        LongRef pollTimeout = LongRef.create((long)Long.MAX_VALUE);
        try {
            this.generateRequests().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)InterBrokerSendThread.$anonfun$doWork$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)request -> {
                InterBrokerSendThread.$anonfun$doWork$2(this, now, pollTimeout, request);
                return BoxedUnit.UNIT;
            });
            this.networkClient.poll(pollTimeout.elem, now);
        }
        catch (FatalExitError e) {
            throw e;
        }
        catch (Throwable t) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"unhandled exception caught in InterBrokerSendThread"})).s((Seq)Nil$.MODULE$), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
            throw new FatalExitError();
        }
    }

    public void wakeup() {
        this.networkClient.wakeup();
    }

    public static final /* synthetic */ boolean $anonfun$doWork$1(RequestAndCompletionHandler check$ifrefutable$1) {
        RequestAndCompletionHandler requestAndCompletionHandler = check$ifrefutable$1;
        boolean bl = requestAndCompletionHandler != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$doWork$2(InterBrokerSendThread $this, long now$1, LongRef pollTimeout$1, RequestAndCompletionHandler request) {
        String destination = Integer.toString(request.destination().id());
        RequestCompletionHandler completionHandler = request.handler();
        ClientRequest clientRequest = $this.networkClient.newClientRequest(destination, request.request(), now$1, true, completionHandler);
        if ($this.networkClient.ready(request.destination(), now$1)) {
            $this.networkClient.send(clientRequest, now$1);
        } else {
            RequestHeader header = clientRequest.makeHeader(request.request().latestAllowedVersion());
            ClientResponse disconnectResponse = new ClientResponse(header, completionHandler, destination, now$1, now$1, true, null, null);
            pollTimeout$1.elem = Math.min(pollTimeout$1.elem, $this.networkClient.connectionDelay(request.destination(), now$1));
            completionHandler.onComplete(disconnectResponse);
        }
    }

    public InterBrokerSendThread(String name, NetworkClient networkClient, Time time, boolean isInterruptible) {
        this.networkClient = networkClient;
        this.time = time;
        super(name, isInterruptible);
    }
}

