/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.cluster;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import io.confluent.kafka.api.LeaderAndIsr;
import io.confluent.kafka.api.LeaderAndIsr$;
import io.confluent.kafka.api.Request$;
import io.confluent.kafka.cluster.Partition$;
import io.confluent.kafka.cluster.Replica;
import io.confluent.kafka.cluster.Replica$;
import io.confluent.kafka.controller.KafkaController$;
import io.confluent.kafka.log.Log;
import io.confluent.kafka.log.LogAppendInfo;
import io.confluent.kafka.log.LogConfig;
import io.confluent.kafka.log.LogConfig$;
import io.confluent.kafka.log.LogManager;
import io.confluent.kafka.metrics.KafkaMetricsGroup;
import io.confluent.kafka.server.ConfigType$;
import io.confluent.kafka.server.LogOffsetMetadata;
import io.confluent.kafka.server.LogReadResult;
import io.confluent.kafka.server.LogReadResult$;
import io.confluent.kafka.server.ReplicaManager;
import io.confluent.kafka.server.TopicPartitionOperationKey;
import io.confluent.kafka.server.checkpoints.OffsetCheckpointFile;
import io.confluent.kafka.server.epoch.LeaderEpochCache;
import io.confluent.kafka.utils.CoreUtils$;
import io.confluent.kafka.utils.Logging;
import io.confluent.kafka.utils.Pool;
import io.confluent.kafka.utils.Pool$;
import io.confluent.kafka.utils.ReplicationUtils$;
import io.confluent.kafka.zk.AdminZkClient;
import io.confluent.kafka.zk.KafkaZkClient;
import io.confluent.org.apache.kafka.common.TopicPartition;
import io.confluent.org.apache.kafka.common.errors.NotEnoughReplicasException;
import io.confluent.org.apache.kafka.common.errors.NotLeaderForPartitionException;
import io.confluent.org.apache.kafka.common.errors.PolicyViolationException;
import io.confluent.org.apache.kafka.common.protocol.Errors;
import io.confluent.org.apache.kafka.common.record.MemoryRecords;
import io.confluent.org.apache.kafka.common.requests.EpochEndOffset;
import io.confluent.org.apache.kafka.common.requests.LeaderAndIsrRequest;
import io.confluent.org.apache.kafka.common.utils.Time;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.Subtractable;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\r\u0015f\u0001B\u0001\u0003\u0001\u001d\u0011\u0011\u0002U1si&$\u0018n\u001c8\u000b\u0005\r!\u0011aB2mkN$XM\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011\u0003\u0002\u0001\t\u001dQ\u0001\"!\u0003\u0007\u000e\u0003)Q\u0011aC\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001b)\u0011a!\u00118z%\u00164\u0007CA\b\u0013\u001b\u0005\u0001\"BA\t\u0005\u0003\u0015)H/\u001b7t\u0013\t\u0019\u0002CA\u0004M_\u001e<\u0017N\\4\u0011\u0005UAR\"\u0001\f\u000b\u0005]!\u0011aB7fiJL7m]\u0005\u00033Y\u0011\u0011cS1gW\u0006lU\r\u001e:jGN<%o\\;q\u0011!Y\u0002A!b\u0001\n\u0003a\u0012!\u0002;pa&\u001cW#A\u000f\u0011\u0005y)cBA\u0010$!\t\u0001#\"D\u0001\"\u0015\t\u0011c!\u0001\u0004=e>|GOP\u0005\u0003I)\ta\u0001\u0015:fI\u00164\u0017B\u0001\u0014(\u0005\u0019\u0019FO]5oO*\u0011AE\u0003\u0005\tS\u0001\u0011\t\u0011)A\u0005;\u00051Ao\u001c9jG\u0002B\u0001b\u000b\u0001\u0003\u0006\u0004%\t\u0001L\u0001\fa\u0006\u0014H/\u001b;j_:LE-F\u0001.!\tIa&\u0003\u00020\u0015\t\u0019\u0011J\u001c;\t\u0011E\u0002!\u0011!Q\u0001\n5\nA\u0002]1si&$\u0018n\u001c8JI\u0002B\u0001b\r\u0001\u0003\u0002\u0003\u0006I\u0001N\u0001\u0005i&lW\r\u0005\u00026}5\taG\u0003\u0002\u0012o)\u0011\u0001(O\u0001\u0007G>lWn\u001c8\u000b\u0005\u0015Q$BA\u001e=\u0003\u0019\t\u0007/Y2iK*\tQ(A\u0002pe\u001eL!a\u0010\u001c\u0003\tQKW.\u001a\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005\u0005\u0006q!/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\bCA\"G\u001b\u0005!%BA#\u0005\u0003\u0019\u0019XM\u001d<fe&\u0011q\t\u0012\u0002\u000f%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u0011!I\u0005A!b\u0001\n\u0003Q\u0015!C5t\u001f\u001a4G.\u001b8f+\u0005Y\u0005CA\u0005M\u0013\ti%BA\u0004C_>dW-\u00198\t\u0011=\u0003!\u0011!Q\u0001\n-\u000b!\"[:PM\u001ad\u0017N\\3!\u0011\u0015\t\u0006\u0001\"\u0001S\u0003\u0019a\u0014N\\5u}Q11+\u0016,X1f\u0003\"\u0001\u0016\u0001\u000e\u0003\tAQa\u0007)A\u0002uAQa\u000b)A\u00025BQa\r)A\u0002QBQ!\u0011)A\u0002\tCq!\u0013)\u0011\u0002\u0003\u00071\nC\u0004\\\u0001\t\u0007I\u0011\u0001/\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]V\tQ\f\u0005\u0002_?6\tq'\u0003\u0002ao\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007B\u00022\u0001A\u0003%Q,A\bu_BL7\rU1si&$\u0018n\u001c8!\u0011\u001d!\u0007A1A\u0005\n1\nQ\u0002\\8dC2\u0014%o\\6fe&#\u0007B\u00024\u0001A\u0003%Q&\u0001\bm_\u000e\fGN\u0011:pW\u0016\u0014\u0018\n\u001a\u0011\t\u000f!\u0004!\u0019!C\u0005S\u0006QAn\\4NC:\fw-\u001a:\u0016\u0003)\u0004\"a\u001b8\u000e\u00031T!!\u001c\u0003\u0002\u00071|w-\u0003\u0002pY\nQAj\\4NC:\fw-\u001a:\t\rE\u0004\u0001\u0015!\u0003k\u0003-awnZ'b]\u0006<WM\u001d\u0011\t\u000fM\u0004!\u0019!C\u0005i\u0006A!p[\"mS\u0016tG/F\u0001v!\t1\u00180D\u0001x\u0015\tAH!\u0001\u0002{W&\u0011!p\u001e\u0002\u000e\u0017\u000647.\u0019.l\u00072LWM\u001c;\t\rq\u0004\u0001\u0015!\u0003v\u0003%Q8n\u00117jK:$\b\u0005C\u0004\u007f\u0001\t\u0007I\u0011B@\u0002\u001d\u0005dGNU3qY&\u001c\u0017m]'baV\u0011\u0011\u0011\u0001\t\u0007\u001f\u0005\rQ&a\u0002\n\u0007\u0005\u0015\u0001C\u0001\u0003Q_>d\u0007c\u0001+\u0002\n%\u0019\u00111\u0002\u0002\u0003\u000fI+\u0007\u000f\\5dC\"A\u0011q\u0002\u0001!\u0002\u0013\t\t!A\bbY2\u0014V\r\u001d7jG\u0006\u001cX*\u00199!\u0011%\t\u0019\u0002\u0001b\u0001\n\u0013\t)\"A\nmK\u0006$WM]%teV\u0003H-\u0019;f\u0019>\u001c7.\u0006\u0002\u0002\u0018A!\u0011\u0011DA\u0016\u001b\t\tYB\u0003\u0003\u0002\u001e\u0005}\u0011!\u00027pG.\u001c(\u0002BA\u0011\u0003G\t!bY8oGV\u0014(/\u001a8u\u0015\u0011\t)#a\n\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003S\tAA[1wC&!\u0011QFA\u000e\u0005Y\u0011V-\u001a8ue\u0006tGOU3bI^\u0013\u0018\u000e^3M_\u000e\\\u0007\u0002CA\u0019\u0001\u0001\u0006I!a\u0006\u0002)1,\u0017\rZ3s\u0013N\u0014X\u000b\u001d3bi\u0016dunY6!\u0011!\t)\u0004\u0001a\u0001\n\u0013a\u0013!\u0003>l-\u0016\u00148/[8o\u0011%\tI\u0004\u0001a\u0001\n\u0013\tY$A\u0007{WZ+'o]5p]~#S-\u001d\u000b\u0005\u0003{\t\u0019\u0005E\u0002\n\u0003\u007fI1!!\u0011\u000b\u0005\u0011)f.\u001b;\t\u0013\u0005\u0015\u0013qGA\u0001\u0002\u0004i\u0013a\u0001=%c!9\u0011\u0011\n\u0001!B\u0013i\u0013A\u0003>l-\u0016\u00148/[8oA!A\u0011Q\n\u0001A\u0002\u0013%A&A\u0006mK\u0006$WM]#q_\u000eD\u0007\"CA)\u0001\u0001\u0007I\u0011BA*\u0003=aW-\u00193fe\u0016\u0003xn\u00195`I\u0015\fH\u0003BA\u001f\u0003+B\u0011\"!\u0012\u0002P\u0005\u0005\t\u0019A\u0017\t\u000f\u0005e\u0003\u0001)Q\u0005[\u0005aA.Z1eKJ,\u0005o\\2iA!\"\u0011qKA/!\rI\u0011qL\u0005\u0004\u0003CR!\u0001\u0003<pY\u0006$\u0018\u000e\\3\t\u0013\u0005\u0015\u0004\u00011A\u0005\u0002\u0005\u001d\u0014A\u00057fC\u0012,'OU3qY&\u001c\u0017-\u00133PaR,\"!!\u001b\u0011\t%\tY'L\u0005\u0004\u0003[R!AB(qi&|g\u000eC\u0005\u0002r\u0001\u0001\r\u0011\"\u0001\u0002t\u00051B.Z1eKJ\u0014V\r\u001d7jG\u0006LEm\u00149u?\u0012*\u0017\u000f\u0006\u0003\u0002>\u0005U\u0004BCA#\u0003_\n\t\u00111\u0001\u0002j!A\u0011\u0011\u0010\u0001!B\u0013\tI'A\nmK\u0006$WM\u001d*fa2L7-Y%e\u001fB$\b\u0005\u000b\u0003\u0002x\u0005u\u0003\"CA@\u0001\u0001\u0007I\u0011AAA\u00039IgnU=oGJ+\u0007\u000f\\5dCN,\"!a!\u0011\u000by\t))a\u0002\n\u0007\u0005\u001duEA\u0002TKRD\u0011\"a#\u0001\u0001\u0004%\t!!$\u0002%%t7+\u001f8d%\u0016\u0004H.[2bg~#S-\u001d\u000b\u0005\u0003{\ty\t\u0003\u0006\u0002F\u0005%\u0015\u0011!a\u0001\u0003\u0007C\u0001\"a%\u0001A\u0003&\u00111Q\u0001\u0010S:\u001c\u0016P\\2SKBd\u0017nY1tA!\"\u0011\u0011SA/\u0011!\tI\n\u0001a\u0001\n\u0013a\u0013aD2p]R\u0014x\u000e\u001c7fe\u0016\u0003xn\u00195\t\u0013\u0005u\u0005\u00011A\u0005\n\u0005}\u0015aE2p]R\u0014x\u000e\u001c7fe\u0016\u0003xn\u00195`I\u0015\fH\u0003BA\u001f\u0003CC\u0011\"!\u0012\u0002\u001c\u0006\u0005\t\u0019A\u0017\t\u000f\u0005\u0015\u0006\u0001)Q\u0005[\u0005\u00012m\u001c8ue>dG.\u001a:Fa>\u001c\u0007\u000e\t\u0005\b\u0003S\u0003A\u0011BAV\u00039I7OU3qY&\u001c\u0017\rT8dC2$2aSAW\u0011\u001d\ty+a*A\u00025\n\u0011B]3qY&\u001c\u0017-\u00133\t\u0013\u0005M\u0006A1A\u0005\n\u0005U\u0016\u0001\u0002;bON,\"!a.\u0011\u0011\u0005e\u0016qXAb\u0003\u0007l!!a/\u000b\u0007\u0005u&\"\u0001\u0006d_2dWm\u0019;j_:LA!!1\u0002<\n\u0019Q*\u00199\u0011\t\u0005\u0015\u00171Z\u0007\u0003\u0003\u000fTA!!3\u0002(\u0005!A.\u00198h\u0013\r1\u0013q\u0019\u0005\t\u0003\u001f\u0004\u0001\u0015!\u0003\u00028\u0006)A/Y4tA!1\u00111\u001b\u0001\u0005\n)\u000bA#[:MK\u0006$WM\u001d*fa2L7-\u0019'pG\u0006d\u0007BBAl\u0001\u0011\u0005!*A\tjgVsG-\u001a:SKBd\u0017nY1uK\u0012Da!a7\u0001\t\u0003Q\u0015!D5t+:$WM]'j]&\u001b(\u000fC\u0004\u0002`\u0002!\t!!9\u000215\f\u0017PY3De\u0016\fG/\u001a$viV\u0014XMU3qY&\u001c\u0017\rF\u0002L\u0003GDq!!:\u0002^\u0002\u0007Q$\u0001\u0004m_\u001e$\u0015N\u001d\u0005\b\u0003S\u0004A\u0011AAv\u0003I9W\r^(s\u0007J,\u0017\r^3SKBd\u0017nY1\u0015\r\u0005\u001d\u0011Q^Ax\u0011%\ty+a:\u0011\u0002\u0003\u0007Q\u0006C\u0005\u0002r\u0006\u001d\b\u0013!a\u0001\u0017\u0006)\u0011n\u001d(fo\"9\u0011Q\u001f\u0001\u0005\u0002\u0005]\u0018AC4fiJ+\u0007\u000f\\5dCR!\u0011\u0011`A~!\u0015I\u00111NA\u0004\u0011%\ty+a=\u0011\u0002\u0003\u0007Q\u0006C\u0004\u0002\u0000\u0002!\tA!\u0001\u0002)1,\u0017\rZ3s%\u0016\u0004H.[2b\u0013\u001adunY1m+\t\tI\u0010C\u0004\u0003\u0006\u0001!\tAa\u0002\u0002+\u0005$GMU3qY&\u001c\u0017-\u00134O_R,\u00050[:ugR!\u0011q\u0001B\u0005\u0011!\u0011YAa\u0001A\u0002\u0005\u001d\u0011a\u0002:fa2L7-\u0019\u0005\b\u0005\u001f\u0001A\u0011AAA\u0003A\t7o]5h]\u0016$'+\u001a9mS\u000e\f7\u000fC\u0004\u0003\u0014\u0001!\t!!!\u0002\u0017\u0005dGNU3qY&\u001c\u0017m\u001d\u0005\b\u0005/\u0001A\u0011\u0002B\r\u00035\u0011X-\\8wKJ+\u0007\u000f\\5dCR!\u0011Q\bB\u000e\u0011\u001d\tyK!\u0006A\u00025BqAa\b\u0001\t\u0003\u0011\t#\u0001\rsK6|g/\u001a$viV\u0014X\rT8dC2\u0014V\r\u001d7jG\u0006$\"!!\u0010\t\u000f\t\u0015\u0002\u0001\"\u0001\u0003(\u0005!S.Y=cKJ+\u0007\u000f\\1dK\u000e+(O]3oi^KG\u000f\u001b$viV\u0014XMU3qY&\u001c\u0017\rF\u0001L\u0011\u001d\u0011Y\u0003\u0001C\u0001\u0005C\ta\u0001Z3mKR,\u0007B\u0002B\u0018\u0001\u0011\u0005A&\u0001\bhKRdU-\u00193fe\u0016\u0003xn\u00195\t\u000f\tM\u0002\u0001\"\u0001\u00036\u0005QQ.Y6f\u0019\u0016\fG-\u001a:\u0015\u000f-\u00139Da\u000f\u0003T!9!\u0011\bB\u0019\u0001\u0004i\u0013\u0001D2p]R\u0014x\u000e\u001c7fe&#\u0007\u0002\u0003B\u001f\u0005c\u0001\rAa\u0010\u0002%A\f'\u000f^5uS>t7\u000b^1uK&sgm\u001c\t\u0005\u0005\u0003\u0012iE\u0004\u0003\u0003D\t%SB\u0001B#\u0015\r\u00119eN\u0001\te\u0016\fX/Z:ug&!!1\nB#\u0003MaU-\u00193fe\u0006sG-S:s%\u0016\fX/Z:u\u0013\u0011\u0011yE!\u0015\u0003\u001dA\u000b'\u000f^5uS>t7\u000b^1uK*!!1\nB#\u0011\u001d\u0011)F!\rA\u00025\nQbY8se\u0016d\u0017\r^5p]&#\u0007b\u0002B-\u0001\u0011\u0005!1L\u0001\r[\u0006\\WMR8mY><XM\u001d\u000b\b\u0017\nu#q\fB1\u0011\u001d\u0011IDa\u0016A\u00025B\u0001B!\u0010\u0003X\u0001\u0007!q\b\u0005\b\u0005+\u00129\u00061\u0001.\u0011\u001d\u0011)\u0007\u0001C\u0001\u0005O\n!$\u001e9eCR,'+\u001a9mS\u000e\fGj\\4SK\u0006$'+Z:vYR$Ra\u0013B5\u0005WB\u0001Ba\u0003\u0003d\u0001\u0007\u0011q\u0001\u0005\t\u0005[\u0012\u0019\u00071\u0001\u0003p\u0005iAn\\4SK\u0006$'+Z:vYR\u00042a\u0011B9\u0013\r\u0011\u0019\b\u0012\u0002\u000e\u0019><'+Z1e%\u0016\u001cX\u000f\u001c;\t\u000f\t]\u0004\u0001\"\u0001\u0003z\u0005qQ.Y=cK\u0016C\b/\u00198e\u0013N\u0014H#B&\u0003|\tu\u0004bBAX\u0005k\u0002\r!\f\u0005\t\u0005[\u0012)\b1\u0001\u0003p!9!\u0011\u0011\u0001\u0005\u0002\t\r\u0015AH2iK\u000e\\WI\\8vO\"\u0014V\r\u001d7jG\u0006\u001c(+Z1dQ>3gm]3u)\u0011\u0011)Ia&\u0011\r%\u00119i\u0013BF\u0013\r\u0011II\u0003\u0002\u0007)V\u0004H.\u001a\u001a\u0011\t\t5%1S\u0007\u0003\u0005\u001fS1A!%8\u0003!\u0001(o\u001c;pG>d\u0017\u0002\u0002BK\u0005\u001f\u0013a!\u0012:s_J\u001c\b\u0002\u0003BM\u0005\u007f\u0002\rAa'\u0002\u001dI,\u0017/^5sK\u0012|eMZ:fiB\u0019\u0011B!(\n\u0007\t}%B\u0001\u0003M_:<\u0007b\u0002BR\u0001\u0011%!QU\u0001\u0017[\u0006L(-Z%oGJ,W.\u001a8u\u0019\u0016\fG-\u001a:I/R)1Ja*\u0003,\"A!\u0011\u0016BQ\u0001\u0004\t9!A\u0007mK\u0006$WM\u001d*fa2L7-\u0019\u0005\u000b\u0005[\u0013\t\u000b%AA\u0002\tm\u0015aB2veRKW.\u001a\u0005\b\u0005c\u0003A\u0011\u0001BZ\u0003Qawn^,bi\u0016\u0014X.\u0019:l\u0013\u001adU-\u00193feV\u0011!1\u0014\u0005\b\u0005o\u0003A\u0011\u0002B\u0011\u0003i!(/_\"p[BdW\r^3EK2\f\u00170\u001a3SKF,Xm\u001d;t\u0011\u001d\u0011Y\f\u0001C\u0001\u0005{\u000ba\"\\1zE\u0016\u001c\u0006N]5oW&\u001b(\u000f\u0006\u0003\u0002>\t}\u0006\u0002\u0003Ba\u0005s\u0003\rAa'\u0002'I,\u0007\u000f\\5dC6\u000b\u0007\u0010T1h)&lW-T:\t\u000f\t\u0015\u0007\u0001\"\u0001\u0003H\u0006!r-\u001a;PkR|emU=oGJ+\u0007\u000f\\5dCN$b!a!\u0003J\n-\u0007\u0002\u0003BU\u0005\u0007\u0004\r!a\u0002\t\u0011\t5'1\u0019a\u0001\u00057\u000b\u0001\"\\1y\u0019\u0006<Wj\u001d\u0005\b\u0005#\u0004A\u0011\u0001Bj\u0003q\t\u0007\u000f]3oIJ+7m\u001c:egR{g)\u001e;ve\u0016\u0014V\r\u001d7jG\u0006$B!!\u0010\u0003V\"A!q\u001bBh\u0001\u0004\u0011I.A\u0004sK\u000e|'\u000fZ:\u0011\t\tm'\u0011]\u0007\u0003\u0005;T1Aa88\u0003\u0019\u0011XmY8sI&!!1\u001dBo\u00055iU-\\8ssJ+7m\u001c:eg\"9!q\u001d\u0001\u0005\u0002\t%\u0018aF1qa\u0016tGMU3d_J$7\u000fV8G_2dwn^3s)\u0011\tiDa;\t\u0011\t]'Q\u001da\u0001\u00053DqAa<\u0001\t\u0003\u0011\t0A\u000bbaB,g\u000e\u001a*fG>\u0014Hm\u001d+p\u0019\u0016\fG-\u001a:\u0015\u0011\tM(\u0011 B~\u0005\u007f\u00042a\u001bB{\u0013\r\u00119\u0010\u001c\u0002\u000e\u0019><\u0017\t\u001d9f]\u0012LeNZ8\t\u0011\t]'Q\u001ea\u0001\u00053DqA!@\u0003n\u0002\u00071*\u0001\u0007jg\u001a\u0013x.\\\"mS\u0016tG\u000fC\u0005\u0004\u0002\t5\b\u0013!a\u0001[\u0005a!/Z9vSJ,G-Q2lg\"91Q\u0001\u0001\u0005\u0002\tM\u0016A\u00047pON#\u0018M\u001d;PM\u001a\u001cX\r\u001e\u0005\b\u0007\u0013\u0001A\u0011AB\u0006\u0003U!W\r\\3uKJ+7m\u001c:eg>sG*Z1eKJ$BAa'\u0004\u000e!A1qBB\u0004\u0001\u0004\u0011Y*\u0001\u0004pM\u001a\u001cX\r\u001e\u0005\b\u0007'\u0001A\u0011AB\u000b\u0003)!(/\u001e8dCR,Gk\u001c\u000b\u0007\u0003{\u00199b!\u0007\t\u0011\r=1\u0011\u0003a\u0001\u00057Cqaa\u0007\u0004\u0012\u0001\u00071*\u0001\u0005jg\u001a+H/\u001e:f\u0011\u001d\u0019y\u0002\u0001C\u0001\u0007C\tq\u0003\u001e:v]\u000e\fG/\u001a$vY2L\u0018I\u001c3Ti\u0006\u0014H/\u0011;\u0015\r\u0005u21EB\u0014\u0011!\u0019)c!\bA\u0002\tm\u0015!\u00038fo>3gm]3u\u0011\u001d\u0019Yb!\bA\u0002-Cqaa\u000b\u0001\t\u0003\u0019i#\u0001\rmCN$xJ\u001a4tKR4uN\u001d'fC\u0012,'/\u00129pG\"$Baa\f\u00046A!!1IB\u0019\u0013\u0011\u0019\u0019D!\u0012\u0003\u001d\u0015\u0003xn\u00195F]\u0012|eMZ:fi\"9\u0011QJB\u0015\u0001\u0004i\u0003bBB\u001d\u0001\u0011%11H\u0001\nkB$\u0017\r^3JgJ$B!!\u0010\u0004>!A1qHB\u001c\u0001\u0004\t\u0019)\u0001\u0004oK^L5O\u001d\u0005\b\u0007\u0007\u0002A\u0011\u0001B\u0011\u0003Y\u0011X-\\8wKB\u000b'\u000f^5uS>tW*\u001a;sS\u000e\u001c\bbBB$\u0001\u0011\u00053\u0011J\u0001\u0007KF,\u0018\r\\:\u0015\u0007-\u001bY\u0005\u0003\u0005\u0004N\r\u0015\u0003\u0019AB(\u0003\u0011!\b.\u0019;\u0011\u0007%\u0019\t&C\u0002\u0004T)\u00111!\u00118z\u0011\u001d\u00199\u0006\u0001C!\u00073\n\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0002[!91Q\f\u0001\u0005B\r}\u0013\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003uA\u0011ba\u0019\u0001#\u0003%\ta!\u001a\u0002)\u001d,GOU3qY&\u001c\u0017\r\n3fM\u0006,H\u000e\u001e\u00132+\t\u00199GK\u0002.\u0007SZ#aa\u001b\u0011\t\r54qO\u0007\u0003\u0007_RAa!\u001d\u0004t\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0007kR\u0011AC1o]>$\u0018\r^5p]&!1\u0011PB8\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\n\u0007{\u0002\u0011\u0013!C\u0001\u0007K\nAdZ3u\u001fJ\u001c%/Z1uKJ+\u0007\u000f\\5dC\u0012\"WMZ1vYR$\u0013\u0007C\u0005\u0004\u0002\u0002\t\n\u0011\"\u0001\u0004\u0004\u0006ar-\u001a;Pe\u000e\u0013X-\u0019;f%\u0016\u0004H.[2bI\u0011,g-Y;mi\u0012\u0012TCABCU\rY5\u0011\u000e\u0005\n\u0007\u0013\u0003\u0011\u0013!C\u0005\u0007\u0017\u000b\u0001%\\1zE\u0016Len\u0019:f[\u0016tG\u000fT3bI\u0016\u0014\bj\u0016\u0013eK\u001a\fW\u000f\u001c;%eU\u00111Q\u0012\u0016\u0005\u00057\u001bI\u0007C\u0005\u0004\u0012\u0002\t\n\u0011\"\u0001\u0004f\u0005y\u0012\r\u001d9f]\u0012\u0014VmY8sIN$v\u000eT3bI\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\b\u0013\rU%!!A\t\u0002\r]\u0015!\u0003)beRLG/[8o!\r!6\u0011\u0014\u0004\t\u0003\t\t\t\u0011#\u0001\u0004\u001cN\u00191\u0011\u0014\u0005\t\u000fE\u001bI\n\"\u0001\u0004 R\u00111q\u0013\u0005\u000b\u0007G\u001bI*%A\u0005\u0002\r\r\u0015a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$S\u0007")
public class Partition
implements KafkaMetricsGroup {
    private final String topic;
    private final int partitionId;
    private final Time time;
    public final ReplicaManager kafka$cluster$Partition$$replicaManager;
    private final boolean isOffline;
    private final TopicPartition topicPartition;
    private final int localBrokerId;
    private final LogManager logManager;
    private final KafkaZkClient zkClient;
    private final Pool<Object, Replica> allReplicasMap;
    private final ReentrantReadWriteLock leaderIsrUpdateLock;
    private int zkVersion;
    private volatile int leaderEpoch;
    private volatile Option<Object> leaderReplicaIdOpt;
    private volatile Set<Replica> inSyncReplicas;
    private int controllerEpoch;
    private final Map<String, String> tags;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static boolean $lessinit$greater$default$5() {
        return Partition$.MODULE$.$lessinit$greater$default$5();
    }

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        Partition partition = this;
        synchronized (partition) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String topic() {
        return this.topic;
    }

    public int partitionId() {
        return this.partitionId;
    }

    public boolean isOffline() {
        return this.isOffline;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    private int localBrokerId() {
        return this.localBrokerId;
    }

    private LogManager logManager() {
        return this.logManager;
    }

    private KafkaZkClient zkClient() {
        return this.zkClient;
    }

    private Pool<Object, Replica> allReplicasMap() {
        return this.allReplicasMap;
    }

    private ReentrantReadWriteLock leaderIsrUpdateLock() {
        return this.leaderIsrUpdateLock;
    }

    private int zkVersion() {
        return this.zkVersion;
    }

    private void zkVersion_$eq(int x$1) {
        this.zkVersion = x$1;
    }

    private int leaderEpoch() {
        return this.leaderEpoch;
    }

    private void leaderEpoch_$eq(int x$1) {
        this.leaderEpoch = x$1;
    }

    public Option<Object> leaderReplicaIdOpt() {
        return this.leaderReplicaIdOpt;
    }

    public void leaderReplicaIdOpt_$eq(Option<Object> x$1) {
        this.leaderReplicaIdOpt = x$1;
    }

    public Set<Replica> inSyncReplicas() {
        return this.inSyncReplicas;
    }

    public void inSyncReplicas_$eq(Set<Replica> x$1) {
        this.inSyncReplicas = x$1;
    }

    private int controllerEpoch() {
        return this.controllerEpoch;
    }

    private void controllerEpoch_$eq(int x$1) {
        this.controllerEpoch = x$1;
    }

    private boolean isReplicaLocal(int replicaId) {
        return replicaId == this.localBrokerId() || replicaId == Request$.MODULE$.FutureLocalReplicaId();
    }

    private Map<String, String> tags() {
        return this.tags;
    }

    public boolean kafka$cluster$Partition$$isLeaderReplicaLocal() {
        return this.leaderReplicaIfLocal().isDefined();
    }

    public boolean isUnderReplicated() {
        return this.kafka$cluster$Partition$$isLeaderReplicaLocal() && this.inSyncReplicas().size() < this.assignedReplicas().size();
    }

    public boolean isUnderMinIsr() {
        boolean bl;
        Option<Replica> option = this.leaderReplicaIfLocal();
        if (option instanceof Some) {
            Some some = (Some)option;
            Replica leaderReplica = (Replica)some.value();
            bl = this.inSyncReplicas().size() < Predef$.MODULE$.Integer2int(((Log)leaderReplica.log().get()).config().minInSyncReplicas());
        } else if (None$.MODULE$.equals(option)) {
            bl = false;
        } else {
            throw new MatchError(option);
        }
        return bl;
    }

    public boolean maybeCreateFutureReplica(String logDir) {
        return BoxesRunTime.unboxToBoolean(CoreUtils$.MODULE$.inReadLock(this.leaderIsrUpdateLock(), (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            boolean bl;
            Replica currentReplica = (Replica)this.getReplica(this.getReplica$default$1()).get();
            String string = ((Log)currentReplica.log().get()).dir().getParent();
            String string2 = logDir;
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                bl = false;
            } else if (this.getReplica(Request$.MODULE$.FutureLocalReplicaId()).isDefined()) {
                String futureReplicaLogDir;
                String string3 = futureReplicaLogDir = ((Log)((Replica)this.getReplica(Request$.MODULE$.FutureLocalReplicaId()).get()).log().get()).dir().getParent();
                String string4 = logDir;
                if (string3 == null ? string4 != null : !string3.equals(string4)) {
                    throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The future log dir ", " of ", " is different from the requested log dir ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{futureReplicaLogDir, this.topicPartition(), logDir})));
                }
                bl = false;
            } else {
                this.getOrCreateReplica(Request$.MODULE$.FutureLocalReplicaId(), this.getOrCreateReplica$default$2());
                bl = true;
            }
            return bl;
        }));
    }

    public Replica getOrCreateReplica(int replicaId, boolean isNew) {
        return this.allReplicasMap().getAndMaybePut(BoxesRunTime.boxToInteger((int)replicaId), (Function0<Replica>)(Function0 & Serializable & scala.Serializable)() -> {
            Replica replica;
            if (this.isReplicaLocal(replicaId)) {
                AdminZkClient adminZkClient = new AdminZkClient(this.zkClient());
                Properties props = adminZkClient.fetchEntityConfig(ConfigType$.MODULE$.Topic(), this.topic());
                LogConfig config = LogConfig$.MODULE$.fromProps(this.logManager().currentDefaultConfig().originals(), props);
                Log log = this.logManager().getOrCreateLog(this.topicPartition(), config, isNew, replicaId == Request$.MODULE$.FutureLocalReplicaId());
                OffsetCheckpointFile checkpoint = (OffsetCheckpointFile)$this.kafka$cluster$Partition$$replicaManager.highWatermarkCheckpoints().apply((Object)log.dir().getParent());
                Map<TopicPartition, Object> offsetMap = checkpoint.read();
                if (!offsetMap.contains((Object)this.topicPartition())) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No checkpointed highwatermark is found for partition ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition()})));
                }
                long offset = package$.MODULE$.min(BoxesRunTime.unboxToLong((Object)offsetMap.getOrElse((Object)this.topicPartition(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)), log.logEndOffset());
                replica = new Replica(replicaId, this.topicPartition(), $this.time, offset, (Option<Log>)new Some((Object)log));
            } else {
                replica = new Replica(replicaId, this.topicPartition(), $this.time, Replica$.MODULE$.$lessinit$greater$default$4(), Replica$.MODULE$.$lessinit$greater$default$5());
            }
            return replica;
        });
    }

    public int getOrCreateReplica$default$1() {
        return this.localBrokerId();
    }

    public boolean getOrCreateReplica$default$2() {
        return false;
    }

    public Option<Replica> getReplica(int replicaId) {
        return Option$.MODULE$.apply((Object)this.allReplicasMap().get(BoxesRunTime.boxToInteger((int)replicaId)));
    }

    public int getReplica$default$1() {
        return this.localBrokerId();
    }

    public Option<Replica> leaderReplicaIfLocal() {
        return this.leaderReplicaIdOpt().filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$1 -> x$1 == this.localBrokerId()).flatMap((Function1 & Serializable & scala.Serializable)replicaId -> this.getReplica(BoxesRunTime.unboxToInt((Object)replicaId)));
    }

    public Replica addReplicaIfNotExists(Replica replica) {
        return this.allReplicasMap().putIfNotExists(BoxesRunTime.boxToInteger((int)replica.brokerId()), replica);
    }

    public Set<Replica> assignedReplicas() {
        return ((TraversableOnce)this.allReplicasMap().values().filter((Function1 & Serializable & scala.Serializable)replica -> BoxesRunTime.boxToBoolean((boolean)Request$.MODULE$.isValidBrokerId(replica.brokerId())))).toSet();
    }

    public Set<Replica> allReplicas() {
        return this.allReplicasMap().values().toSet();
    }

    private void removeReplica(int replicaId) {
        this.allReplicasMap().remove(BoxesRunTime.boxToInteger((int)replicaId));
    }

    public void removeFutureLocalReplica() {
        CoreUtils$.MODULE$.inWriteLock(this.leaderIsrUpdateLock(), (Function0 & Serializable & scala.Serializable)() -> this.allReplicasMap().remove(BoxesRunTime.boxToInteger((int)Request$.MODULE$.FutureLocalReplicaId())));
    }

    public boolean maybeReplaceCurrentWithFutureReplica() {
        Replica replica = (Replica)this.getReplica(this.getReplica$default$1()).get();
        Replica futureReplica = (Replica)this.getReplica(Request$.MODULE$.FutureLocalReplicaId()).get();
        LogOffsetMetadata logOffsetMetadata = replica.logEndOffset();
        LogOffsetMetadata logOffsetMetadata2 = futureReplica.logEndOffset();
        return !(logOffsetMetadata != null ? !((Object)logOffsetMetadata).equals(logOffsetMetadata2) : logOffsetMetadata2 != null) ? BoxesRunTime.unboxToBoolean(CoreUtils$.MODULE$.inWriteLock(this.leaderIsrUpdateLock(), (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            boolean bl;
            LogOffsetMetadata logOffsetMetadata = replica.logEndOffset();
            LogOffsetMetadata logOffsetMetadata2 = futureReplica.logEndOffset();
            if (!(logOffsetMetadata != null ? !((Object)logOffsetMetadata).equals(logOffsetMetadata2) : logOffsetMetadata2 != null)) {
                this.logManager().replaceCurrentWithFutureLog(this.topicPartition());
                replica.log_$eq(futureReplica.log());
                futureReplica.log_$eq((Option<Log>)None$.MODULE$);
                this.allReplicasMap().remove(BoxesRunTime.boxToInteger((int)Request$.MODULE$.FutureLocalReplicaId()));
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        })) : false;
    }

    public void delete() {
        CoreUtils$.MODULE$.inWriteLock(this.leaderIsrUpdateLock(), (Function0 & Serializable & scala.Serializable)() -> {
            this.allReplicasMap().clear();
            this.inSyncReplicas_$eq((Set<Replica>)Predef$.MODULE$.Set().empty());
            this.leaderReplicaIdOpt_$eq((Option<Object>)None$.MODULE$);
            this.removePartitionMetrics();
            this.logManager().asyncDelete(this.topicPartition(), this.logManager().asyncDelete$default$2());
            return this.logManager().asyncDelete(this.topicPartition(), true);
        });
    }

    public int getLeaderEpoch() {
        return this.leaderEpoch();
    }

    public boolean makeLeader(int controllerId, LeaderAndIsrRequest.PartitionState partitionStateInfo, int correlationId) {
        boolean isNewLeader;
        block1: {
            Tuple2 tuple2 = (Tuple2)CoreUtils$.MODULE$.inWriteLock(this.leaderIsrUpdateLock(), (Function0 & Serializable & scala.Serializable)() -> {
                Buffer newAssignedReplicas = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionStateInfo$1.basePartitionState.replicas).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$2)), Buffer$.MODULE$.canBuildFrom());
                this.controllerEpoch_$eq(partitionStateInfo$1.basePartitionState.controllerEpoch);
                Set newInSyncReplicas = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionStateInfo$1.basePartitionState.isr).asScala()).map((Function1 & Serializable & scala.Serializable)r -> this.getOrCreateReplica(Predef$.MODULE$.Integer2int(r), partitionStateInfo$1.isNew), Buffer$.MODULE$.canBuildFrom())).toSet();
                ((IterableLike)((Subtractable)this.assignedReplicas().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.brokerId()), Set$.MODULE$.canBuildFrom())).$minus$minus((GenTraversableOnce)newAssignedReplicas)).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)replicaId -> this.removeReplica(replicaId));
                this.inSyncReplicas_$eq((Set<Replica>)newInSyncReplicas);
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " starts at Leader Epoch ", " from offset ", ". Previous Leader Epoch was: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition(), BoxesRunTime.boxToInteger((int)partitionStateInfo$1.basePartitionState.leaderEpoch), BoxesRunTime.boxToLong((long)((Replica)this.getReplica(this.getReplica$default$1()).get()).logEndOffset().messageOffset()), BoxesRunTime.boxToInteger((int)this.leaderEpoch())})));
                this.leaderEpoch_$eq(partitionStateInfo$1.basePartitionState.leaderEpoch);
                newAssignedReplicas.foreach((Function1 & Serializable & scala.Serializable)id -> this.getOrCreateReplica(BoxesRunTime.unboxToInt((Object)id), partitionStateInfo.isNew));
                this.zkVersion_$eq(partitionStateInfo$1.basePartitionState.zkVersion);
                boolean isNewLeader = BoxesRunTime.unboxToBoolean((Object)this.leaderReplicaIdOpt().map((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$4 -> x$4 != this.localBrokerId()).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> true));
                Replica leaderReplica = (Replica)this.getReplica(this.getReplica$default$1()).get();
                long curLeaderLogEndOffset = leaderReplica.logEndOffset().messageOffset();
                long curTimeMs = $this.time.milliseconds();
                this.assignedReplicas().$minus((Object)leaderReplica).foreach((Function1 & Serializable & scala.Serializable)replica -> {
                    Partition.$anonfun$makeLeader$10(this, curLeaderLogEndOffset, curTimeMs, replica);
                    return BoxedUnit.UNIT;
                });
                if (isNewLeader) {
                    leaderReplica.convertHWToLocalOffsetMetadata();
                    this.leaderReplicaIdOpt_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)this.localBrokerId())));
                    ((IterableLike)this.assignedReplicas().filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)Partition.$anonfun$makeLeader$11(this, x$5)))).foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
                        x$6.updateLogReadResult(LogReadResult$.MODULE$.UnknownLogReadResult());
                        return BoxedUnit.UNIT;
                    });
                }
                return new Tuple2.mcZZ.sp(this.maybeIncrementLeaderHW(leaderReplica, this.maybeIncrementLeaderHW$default$2()), isNewLeader);
            });
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            boolean leaderHWIncremented = tuple2._1$mcZ$sp();
            boolean isNewLeader2 = tuple2._2$mcZ$sp();
            Tuple2.mcZZ.sp sp2 = new Tuple2.mcZZ.sp(leaderHWIncremented, isNewLeader2);
            Tuple2.mcZZ.sp sp3 = sp2;
            boolean leaderHWIncremented2 = sp3._1$mcZ$sp();
            isNewLeader = sp3._2$mcZ$sp();
            if (!leaderHWIncremented2) break block1;
            this.tryCompleteDelayedRequests();
        }
        return isNewLeader;
    }

    public boolean makeFollower(int controllerId, LeaderAndIsrRequest.PartitionState partitionStateInfo, int correlationId) {
        return BoxesRunTime.unboxToBoolean(CoreUtils$.MODULE$.inWriteLock(this.leaderIsrUpdateLock(), (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            boolean bl;
            Buffer newAssignedReplicas = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionStateInfo$2.basePartitionState.replicas).asScala()).map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$8)), Buffer$.MODULE$.canBuildFrom());
            int newLeaderBrokerId = partitionStateInfo$2.basePartitionState.leader;
            this.controllerEpoch_$eq(partitionStateInfo$2.basePartitionState.controllerEpoch);
            newAssignedReplicas.foreach((Function1 & Serializable & scala.Serializable)r -> this.getOrCreateReplica(BoxesRunTime.unboxToInt((Object)r), partitionStateInfo.isNew));
            ((IterableLike)((Subtractable)this.assignedReplicas().map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToInteger((int)x$9.brokerId()), Set$.MODULE$.canBuildFrom())).$minus$minus((GenTraversableOnce)newAssignedReplicas)).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)replicaId -> this.removeReplica(replicaId));
            this.inSyncReplicas_$eq((Set<Replica>)Predef$.MODULE$.Set().empty());
            this.leaderEpoch_$eq(partitionStateInfo$2.basePartitionState.leaderEpoch);
            this.zkVersion_$eq(partitionStateInfo$2.basePartitionState.zkVersion);
            if (this.leaderReplicaIdOpt().isDefined() && BoxesRunTime.unboxToInt((Object)this.leaderReplicaIdOpt().get()) == newLeaderBrokerId) {
                bl = false;
            } else {
                this.leaderReplicaIdOpt_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)newLeaderBrokerId)));
                bl = true;
            }
            return bl;
        }));
    }

    public boolean updateReplicaLogReadResult(Replica replica, LogReadResult logReadResult) {
        boolean result;
        int replicaId = replica.brokerId();
        long oldLeaderLW = this.kafka$cluster$Partition$$replicaManager.delayedDeleteRecordsPurgatory().delayed() > 0 ? this.lowWatermarkIfLeader() : -1L;
        replica.updateLogReadResult(logReadResult);
        long newLeaderLW = this.kafka$cluster$Partition$$replicaManager.delayedDeleteRecordsPurgatory().delayed() > 0 ? this.lowWatermarkIfLeader() : -1L;
        boolean leaderLWIncremented = newLeaderLW > oldLeaderLW;
        boolean leaderHWIncremented = this.maybeExpandIsr(replicaId, logReadResult);
        boolean bl = result = leaderLWIncremented || leaderHWIncremented;
        if (result) {
            this.tryCompleteDelayedRequests();
        }
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Recorded replica ", " log end offset (LEO) position ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)replicaId), BoxesRunTime.boxToLong((long)logReadResult.info().fetchOffsetMetadata().messageOffset())})));
        return result;
    }

    public boolean maybeExpandIsr(int replicaId, LogReadResult logReadResult) {
        return BoxesRunTime.unboxToBoolean(CoreUtils$.MODULE$.inWriteLock(this.leaderIsrUpdateLock(), (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            boolean bl;
            Option<Replica> option = this.leaderReplicaIfLocal();
            if (option instanceof Some) {
                Some some = (Some)option;
                Replica leaderReplica = (Replica)some.value();
                Replica replica = (Replica)this.getReplica(replicaId).get();
                LogOffsetMetadata leaderHW = leaderReplica.highWatermark();
                if (!this.inSyncReplicas().contains((Object)replica) && ((SetLike)this.assignedReplicas().map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToInteger((int)x$10.brokerId()), Set$.MODULE$.canBuildFrom())).contains((Object)BoxesRunTime.boxToInteger((int)replicaId)) && replica.logEndOffset().offsetDiff(leaderHW) >= 0L) {
                    Set newInSyncReplicas = (Set)this.inSyncReplicas().$plus((Object)replica);
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expanding ISR from ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)this.inSyncReplicas().map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToInteger((int)x$11.brokerId()), Set$.MODULE$.canBuildFrom())).mkString(",")})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)newInSyncReplicas.map((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToInteger((int)x$12.brokerId()), Set$.MODULE$.canBuildFrom())).mkString(",")})));
                    this.updateIsr((Set<Replica>)newInSyncReplicas);
                    $this.kafka$cluster$Partition$$replicaManager.isrExpandRate().mark();
                }
                bl = this.maybeIncrementLeaderHW(leaderReplica, logReadResult.fetchTimeMs());
            } else if (None$.MODULE$.equals(option)) {
                bl = false;
            } else {
                throw new MatchError(option);
            }
            return bl;
        }));
    }

    public Tuple2<Object, Errors> checkEnoughReplicasReachOffset(long requiredOffset) {
        Tuple2 tuple2;
        Option<Replica> option = this.leaderReplicaIfLocal();
        if (option instanceof Some) {
            Some some = (Some)option;
            Replica leaderReplica = (Replica)some.value();
            Set<Replica> curInSyncReplicas = this.inSyncReplicas();
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " acks satisfied with acks = -1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.numAcks$1(requiredOffset, curInSyncReplicas))})));
            Integer minIsr = ((Log)leaderReplica.log().get()).config().minInSyncReplicas();
            tuple2 = leaderReplica.highWatermark().messageOffset() >= requiredOffset ? (Predef$.MODULE$.Integer2int(minIsr) <= curInSyncReplicas.size() ? new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)Errors.NONE) : new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)Errors.NOT_ENOUGH_REPLICAS_AFTER_APPEND)) : new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)Errors.NONE);
        } else if (None$.MODULE$.equals(option)) {
            tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)Errors.NOT_LEADER_FOR_PARTITION);
        } else {
            throw new MatchError(option);
        }
        return tuple2;
    }

    private boolean maybeIncrementLeaderHW(Replica leaderReplica, long curTime) {
        boolean bl;
        Set allLogEndOffsets = (Set)((SetLike)this.assignedReplicas().filter((Function1 & Serializable & scala.Serializable)replica -> BoxesRunTime.boxToBoolean((boolean)Partition.$anonfun$maybeIncrementLeaderHW$1(this, curTime, replica)))).map((Function1 & Serializable & scala.Serializable)x$13 -> x$13.logEndOffset(), Set$.MODULE$.canBuildFrom());
        LogOffsetMetadata newHighWatermark = (LogOffsetMetadata)allLogEndOffsets.min((Ordering)new LogOffsetMetadata.OffsetOrdering());
        LogOffsetMetadata oldHighWatermark = leaderReplica.highWatermark();
        if (oldHighWatermark.messageOffset() < newHighWatermark.messageOffset() || oldHighWatermark.messageOffset() == newHighWatermark.messageOffset() && oldHighWatermark.onOlderSegment(newHighWatermark)) {
            leaderReplica.highWatermark_$eq(newHighWatermark);
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"High watermark updated to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{newHighWatermark})));
            bl = true;
        } else {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Skipping update high watermark since new hw ", " is not larger than old hw ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{newHighWatermark, oldHighWatermark})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"All LEOs are ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{allLogEndOffsets.mkString(",")})));
            bl = false;
        }
        return bl;
    }

    private long maybeIncrementLeaderHW$default$2() {
        return this.time.milliseconds();
    }

    public long lowWatermarkIfLeader() {
        if (!this.kafka$cluster$Partition$$isLeaderReplicaLocal()) {
            throw new NotLeaderForPartitionException(new StringOps(Predef$.MODULE$.augmentString("Leader not local for partition %s on broker %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition(), BoxesRunTime.boxToInteger((int)this.localBrokerId())})));
        }
        Set logStartOffsets = (Set)this.allReplicas().collect((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Partition $outer;

            public final <A1 extends Replica, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Object object = this.$outer.kafka$cluster$Partition$$replicaManager.metadataCache().isBrokerAlive(A1.brokerId()) || A1.brokerId() == Request$.MODULE$.FutureLocalReplicaId() ? BoxesRunTime.boxToLong((long)A1.logStartOffset()) : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Replica x1) {
                Replica replica = x1;
                boolean bl = this.$outer.kafka$cluster$Partition$$replicaManager.metadataCache().isBrokerAlive(replica.brokerId()) || replica.brokerId() == Request$.MODULE$.FutureLocalReplicaId();
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Set$.MODULE$.canBuildFrom());
        return BoxesRunTime.unboxToLong((Object)CoreUtils$.MODULE$.min(logStartOffsets, BoxesRunTime.boxToLong((long)0L), Ordering.Long$.MODULE$));
    }

    private void tryCompleteDelayedRequests() {
        TopicPartitionOperationKey requestKey = new TopicPartitionOperationKey(this.topicPartition());
        this.kafka$cluster$Partition$$replicaManager.tryCompleteDelayedFetch(requestKey);
        this.kafka$cluster$Partition$$replicaManager.tryCompleteDelayedProduce(requestKey);
        this.kafka$cluster$Partition$$replicaManager.tryCompleteDelayedDeleteRecords(requestKey);
    }

    public void maybeShrinkIsr(long replicaMaxLagTimeMs) {
        block0: {
            boolean leaderHWIncremented = BoxesRunTime.unboxToBoolean(CoreUtils$.MODULE$.inWriteLock(this.leaderIsrUpdateLock(), (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                boolean bl;
                Option<Replica> option = this.leaderReplicaIfLocal();
                if (option instanceof Some) {
                    boolean bl2;
                    Some some = (Some)option;
                    Replica leaderReplica = (Replica)some.value();
                    Set<Replica> outOfSyncReplicas = this.getOutOfSyncReplicas(leaderReplica, replicaMaxLagTimeMs);
                    if (outOfSyncReplicas.nonEmpty()) {
                        Set newInSyncReplicas = (Set)this.inSyncReplicas().$minus$minus(outOfSyncReplicas);
                        Predef$.MODULE$.assert(newInSyncReplicas.nonEmpty());
                        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Shrinking ISR from %s to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)this.inSyncReplicas().map((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToInteger((int)x$14.brokerId()), Set$.MODULE$.canBuildFrom())).mkString(","), ((TraversableOnce)newInSyncReplicas.map((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToInteger((int)x$15.brokerId()), Set$.MODULE$.canBuildFrom())).mkString(",")})));
                        this.updateIsr((Set<Replica>)newInSyncReplicas);
                        $this.kafka$cluster$Partition$$replicaManager.isrShrinkRate().mark();
                        bl2 = this.maybeIncrementLeaderHW(leaderReplica, this.maybeIncrementLeaderHW$default$2());
                    } else {
                        bl2 = false;
                    }
                    bl = bl2;
                } else if (None$.MODULE$.equals(option)) {
                    bl = false;
                } else {
                    throw new MatchError(option);
                }
                return bl;
            }));
            if (!leaderHWIncremented) break block0;
            this.tryCompleteDelayedRequests();
        }
    }

    public Set<Replica> getOutOfSyncReplicas(Replica leaderReplica, long maxLagMs) {
        Set laggingReplicas;
        block0: {
            Set candidateReplicas = (Set)this.inSyncReplicas().$minus((Object)leaderReplica);
            laggingReplicas = (Set)candidateReplicas.filter((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)Partition.$anonfun$getOutOfSyncReplicas$1(this, maxLagMs, r)));
            if (!laggingReplicas.nonEmpty()) break block0;
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Lagging replicas are %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)laggingReplicas.map((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToInteger((int)x$16.brokerId()), Set$.MODULE$.canBuildFrom())).mkString(",")})));
        }
        return laggingReplicas;
    }

    public void appendRecordsToFutureReplica(MemoryRecords records) {
        ((Log)((Replica)this.getReplica(Request$.MODULE$.FutureLocalReplicaId()).get()).log().get()).appendAsFollower(records);
    }

    public void appendRecordsToFollower(MemoryRecords records) {
        CoreUtils$.MODULE$.inReadLock(this.leaderIsrUpdateLock(), (Function0 & Serializable & scala.Serializable)() -> ((Log)((Replica)this.getReplica(this.getReplica$default$1()).get()).log().get()).appendAsFollower(records));
    }

    public LogAppendInfo appendRecordsToLeader(MemoryRecords records, boolean isFromClient, int requiredAcks) {
        LogAppendInfo info;
        block1: {
            Tuple2 tuple2 = (Tuple2)CoreUtils$.MODULE$.inReadLock(this.leaderIsrUpdateLock(), (Function0 & Serializable & scala.Serializable)() -> {
                Log log;
                Replica leaderReplica;
                Option<Replica> option = this.leaderReplicaIfLocal();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    leaderReplica = (Replica)some.value();
                    log = (Log)leaderReplica.log().get();
                    Integer minIsr = log.config().minInSyncReplicas();
                    int inSyncSize = this.inSyncReplicas().size();
                    if (inSyncSize < Predef$.MODULE$.Integer2int(minIsr) && requiredAcks == -1) {
                        throw new NotEnoughReplicasException(new StringOps(Predef$.MODULE$.augmentString("Number of insync replicas for partition %s is [%d], below required minimum [%d]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition(), BoxesRunTime.boxToInteger((int)inSyncSize), minIsr})));
                    }
                } else {
                    if (None$.MODULE$.equals(option)) {
                        throw new NotLeaderForPartitionException(new StringOps(Predef$.MODULE$.augmentString("Leader not local for partition %s on broker %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition(), BoxesRunTime.boxToInteger((int)this.localBrokerId())})));
                    }
                    throw new MatchError(option);
                }
                LogAppendInfo info = log.appendAsLeader(records, this.leaderEpoch(), isFromClient);
                $this.kafka$cluster$Partition$$replicaManager.tryCompleteDelayedFetch(new TopicPartitionOperationKey(this.topic(), this.partitionId()));
                Tuple2 tuple2 = new Tuple2((Object)info, (Object)BoxesRunTime.boxToBoolean((boolean)this.maybeIncrementLeaderHW(leaderReplica, this.maybeIncrementLeaderHW$default$2())));
                return tuple2;
            });
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            LogAppendInfo info2 = (LogAppendInfo)tuple2._1();
            boolean leaderHWIncremented = tuple2._2$mcZ$sp();
            Tuple2 tuple22 = new Tuple2((Object)info2, (Object)BoxesRunTime.boxToBoolean((boolean)leaderHWIncremented));
            Tuple2 tuple23 = tuple22;
            info = (LogAppendInfo)tuple23._1();
            boolean leaderHWIncremented2 = tuple23._2$mcZ$sp();
            if (!leaderHWIncremented2) break block1;
            this.tryCompleteDelayedRequests();
        }
        return info;
    }

    public int appendRecordsToLeader$default$3() {
        return 0;
    }

    public long logStartOffset() {
        return BoxesRunTime.unboxToLong(CoreUtils$.MODULE$.inReadLock(this.leaderIsrUpdateLock(), (JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToLong((Object)this.leaderReplicaIfLocal().map((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToLong((long)Partition.$anonfun$logStartOffset$2(x$18))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L))));
    }

    public long deleteRecordsOnLeader(long offset) {
        return BoxesRunTime.unboxToLong(CoreUtils$.MODULE$.inReadLock(this.leaderIsrUpdateLock(), (JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> {
            Replica leaderReplica;
            Option<Replica> option = this.leaderReplicaIfLocal();
            if (option instanceof Some) {
                Some some = (Some)option;
                leaderReplica = (Replica)some.value();
                if (!((Log)leaderReplica.log().get()).config().delete()) {
                    throw new PolicyViolationException(new StringOps(Predef$.MODULE$.augmentString("Records of partition %s can not be deleted due to the configured policy")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition()})));
                }
            } else {
                if (None$.MODULE$.equals(option)) {
                    throw new NotLeaderForPartitionException(new StringOps(Predef$.MODULE$.augmentString("Leader not local for partition %s on broker %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition(), BoxesRunTime.boxToInteger((int)this.localBrokerId())})));
                }
                throw new MatchError(option);
            }
            leaderReplica.maybeIncrementLogStartOffset(offset);
            long l = this.lowWatermarkIfLeader();
            return l;
        }));
    }

    public void truncateTo(long offset, boolean isFuture) {
        CoreUtils$.MODULE$.inReadLock(this.leaderIsrUpdateLock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.logManager().truncateTo((Map<TopicPartition, Object>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)BoxesRunTime.boxToLong((long)offset))}))), isFuture));
    }

    public void truncateFullyAndStartAt(long newOffset, boolean isFuture) {
        CoreUtils$.MODULE$.inReadLock(this.leaderIsrUpdateLock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.logManager().truncateFullyAndStartAt(this.topicPartition(), newOffset, isFuture));
    }

    public EpochEndOffset lastOffsetForLeaderEpoch(int leaderEpoch) {
        return (EpochEndOffset)CoreUtils$.MODULE$.inReadLock(this.leaderIsrUpdateLock(), (Function0 & Serializable & scala.Serializable)() -> {
            EpochEndOffset epochEndOffset;
            Option<Replica> option = this.leaderReplicaIfLocal();
            if (option instanceof Some) {
                Some some = (Some)option;
                Replica leaderReplica = (Replica)some.value();
                epochEndOffset = new EpochEndOffset(Errors.NONE, ((LeaderEpochCache)leaderReplica.epochs().get()).endOffsetFor(leaderEpoch));
            } else if (None$.MODULE$.equals(option)) {
                epochEndOffset = new EpochEndOffset(Errors.NOT_LEADER_FOR_PARTITION, -1L);
            } else {
                throw new MatchError(option);
            }
            return epochEndOffset;
        });
    }

    private void updateIsr(Set<Replica> newIsr) {
        LeaderAndIsr newLeaderAndIsr = new LeaderAndIsr(this.localBrokerId(), this.leaderEpoch(), (List<Object>)((TraversableOnce)newIsr.map((Function1 & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToInteger((int)x$19.brokerId()), Set$.MODULE$.canBuildFrom())).toList(), this.zkVersion());
        Tuple2<Object, Object> tuple2 = ReplicationUtils$.MODULE$.updateLeaderAndIsr(this.zkClient(), this.topicPartition(), newLeaderAndIsr, this.controllerEpoch());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        boolean updateSucceeded = tuple2._1$mcZ$sp();
        int newVersion = tuple2._2$mcI$sp();
        Tuple2.mcZI.sp sp2 = new Tuple2.mcZI.sp(updateSucceeded, newVersion);
        Tuple2.mcZI.sp sp3 = sp2;
        boolean updateSucceeded2 = sp3._1$mcZ$sp();
        int newVersion2 = sp3._2$mcI$sp();
        if (updateSucceeded2) {
            this.kafka$cluster$Partition$$replicaManager.recordIsrChange(this.topicPartition());
            this.inSyncReplicas_$eq(newIsr);
            this.zkVersion_$eq(newVersion2);
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("ISR updated to [%s] and zkVersion updated to [%d]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{newIsr.mkString(","), BoxesRunTime.boxToInteger((int)this.zkVersion())})));
        } else {
            this.kafka$cluster$Partition$$replicaManager.failedIsrUpdatesRate().mark();
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Cached zkVersion [%d] not equal to that in zookeeper, skip updating ISR")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.zkVersion())})));
        }
    }

    public void removePartitionMetrics() {
        this.removeMetric("UnderReplicated", this.tags());
        this.removeMetric("UnderMinIsr", this.tags());
        this.removeMetric("InSyncReplicasCount", this.tags());
        this.removeMetric("ReplicasCount", this.tags());
        this.removeMetric("LastStableOffsetLag", this.tags());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object that) {
        Object object = that;
        if (!(object instanceof Partition)) return false;
        Partition partition = (Partition)object;
        if (this.partitionId() != partition.partitionId()) return false;
        String string = this.topic();
        String string2 = partition.topic();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (this.isOffline() != partition.isOffline()) return false;
        return true;
    }

    public int hashCode() {
        return 31 + this.topic().hashCode() + 17 * this.partitionId() + (this.isOffline() ? 1 : 0);
    }

    public String toString() {
        StringBuilder partitionString = new StringBuilder();
        partitionString.append("Topic: " + this.topic());
        partitionString.append("; Partition: " + this.partitionId());
        partitionString.append("; Leader: " + this.leaderReplicaIdOpt());
        partitionString.append("; AllReplicas: " + this.allReplicasMap().keys().mkString(","));
        partitionString.append("; InSyncReplicas: " + ((TraversableOnce)this.inSyncReplicas().map((Function1 & Serializable & scala.Serializable)x$21 -> BoxesRunTime.boxToInteger((int)x$21.brokerId()), Set$.MODULE$.canBuildFrom())).mkString(","));
        return partitionString.toString();
    }

    public static final /* synthetic */ void $anonfun$makeLeader$10(Partition $this, long curLeaderLogEndOffset$1, long curTimeMs$1, Replica replica) {
        long lastCaughtUpTimeMs = $this.inSyncReplicas().contains((Object)replica) ? curTimeMs$1 : 0L;
        replica.resetLastCaughtUpTime(curLeaderLogEndOffset$1, curTimeMs$1, lastCaughtUpTimeMs);
    }

    public static final /* synthetic */ boolean $anonfun$makeLeader$11(Partition $this, Replica x$5) {
        return x$5.brokerId() != $this.localBrokerId();
    }

    public static final /* synthetic */ boolean $anonfun$checkEnoughReplicasReachOffset$1(Partition $this, long requiredOffset$1, Replica r) {
        boolean bl;
        if (!r.isLocal()) {
            if (r.logEndOffset().messageOffset() >= requiredOffset$1) {
                $this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Replica ", " received offset ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)r.brokerId()), BoxesRunTime.boxToLong((long)requiredOffset$1)})));
                bl = true;
            } else {
                bl = false;
            }
        } else {
            bl = true;
        }
        return bl;
    }

    private final int numAcks$1(long requiredOffset$1, Set curInSyncReplicas$1) {
        return curInSyncReplicas$1.count((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)Partition.$anonfun$checkEnoughReplicasReachOffset$1(this, requiredOffset$1, r)));
    }

    public static final /* synthetic */ boolean $anonfun$maybeIncrementLeaderHW$1(Partition $this, long curTime$1, Replica replica) {
        return curTime$1 - replica.lastCaughtUpTimeMs() <= Predef$.MODULE$.Long2long($this.kafka$cluster$Partition$$replicaManager.config().replicaLagTimeMaxMs()) || $this.inSyncReplicas().contains((Object)replica);
    }

    public static final /* synthetic */ boolean $anonfun$getOutOfSyncReplicas$1(Partition $this, long maxLagMs$1, Replica r) {
        return $this.time.milliseconds() - r.lastCaughtUpTimeMs() > maxLagMs$1;
    }

    public static final /* synthetic */ long $anonfun$logStartOffset$2(Replica x$18) {
        return ((Log)x$18.log().get()).logStartOffset();
    }

    public Partition(String topic, int partitionId, Time time, ReplicaManager replicaManager, boolean isOffline) {
        Gauge<Object> gauge;
        this.topic = topic;
        this.partitionId = partitionId;
        this.time = time;
        this.kafka$cluster$Partition$$replicaManager = replicaManager;
        this.isOffline = isOffline;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.topicPartition = new TopicPartition(topic, partitionId);
        this.localBrokerId = !isOffline ? replicaManager.config().brokerId() : -1;
        this.logManager = !isOffline ? replicaManager.logManager() : null;
        this.zkClient = !isOffline ? replicaManager.zkClient() : null;
        this.allReplicasMap = new Pool(Pool$.MODULE$.$lessinit$greater$default$1());
        this.leaderIsrUpdateLock = new ReentrantReadWriteLock();
        this.zkVersion = LeaderAndIsr$.MODULE$.initialZKVersion();
        this.leaderEpoch = LeaderAndIsr$.MODULE$.initialLeaderEpoch() - 1;
        this.leaderReplicaIdOpt = None$.MODULE$;
        this.inSyncReplicas = Predef$.MODULE$.Set().empty();
        this.controllerEpoch = KafkaController$.MODULE$.InitialControllerEpoch() - 1;
        this.logIdent_$eq(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[Partition ", " broker=", "] "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition(), BoxesRunTime.boxToInteger((int)this.localBrokerId())})));
        this.tags = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic"), (Object)topic), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partition"), (Object)((Object)BoxesRunTime.boxToInteger((int)partitionId)).toString())}));
        if (!isOffline) {
            this.newGauge("UnderReplicated", new Gauge<Object>(this){
                private final /* synthetic */ Partition $outer;

                public int value() {
                    return this.$outer.isUnderReplicated() ? 1 : 0;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, this.tags());
            this.newGauge("InSyncReplicasCount", new Gauge<Object>(this){
                private final /* synthetic */ Partition $outer;

                public int value() {
                    return this.$outer.kafka$cluster$Partition$$isLeaderReplicaLocal() ? this.$outer.inSyncReplicas().size() : 0;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, this.tags());
            this.newGauge("UnderMinIsr", new Gauge<Object>(this){
                private final /* synthetic */ Partition $outer;

                public int value() {
                    return this.$outer.isUnderMinIsr() ? 1 : 0;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, this.tags());
            this.newGauge("ReplicasCount", new Gauge<Object>(this){
                private final /* synthetic */ Partition $outer;

                public int value() {
                    return this.$outer.kafka$cluster$Partition$$isLeaderReplicaLocal() ? this.$outer.assignedReplicas().size() : 0;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, this.tags());
            gauge = this.newGauge("LastStableOffsetLag", new Gauge<Object>(this){
                private final /* synthetic */ Partition $outer;

                public long value() {
                    return BoxesRunTime.unboxToLong((Object)this.$outer.leaderReplicaIfLocal().map((Function1 & Serializable & scala.Serializable)replica -> BoxesRunTime.boxToLong((long)$anon$5.$anonfun$value$1(replica))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
                }

                public static final /* synthetic */ long $anonfun$value$1(Replica replica) {
                    return replica.highWatermark().messageOffset() - replica.lastStableOffset().messageOffset();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$value$1$adapted(io.confluent.kafka.cluster.Replica ), $anonfun$value$2()}, serializedLambda);
                }
            }, this.tags());
        } else {
            gauge = BoxedUnit.UNIT;
        }
    }
}

