/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.admin;

import com.typesafe.scalalogging.Logger;
import io.confluent.kafka.admin.AdminClient;
import io.confluent.kafka.admin.AdminClient$;
import io.confluent.kafka.admin.AdminOperationException;
import io.confluent.kafka.admin.DelegationTokenCommand;
import io.confluent.kafka.utils.CommandLineUtils$;
import io.confluent.kafka.utils.Exit$;
import io.confluent.kafka.utils.Logging;
import io.confluent.org.apache.kafka.common.protocol.Errors;
import io.confluent.org.apache.kafka.common.security.auth.KafkaPrincipal;
import io.confluent.org.apache.kafka.common.security.token.delegation.DelegationToken;
import io.confluent.org.apache.kafka.common.security.token.delegation.TokenInformation;
import io.confluent.org.apache.kafka.common.utils.Base64;
import io.confluent.org.apache.kafka.common.utils.SecurityUtils;
import io.confluent.org.apache.kafka.common.utils.Utils;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Properties;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class DelegationTokenCommand$
implements Logging {
    public static DelegationTokenCommand$ MODULE$;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new DelegationTokenCommand$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        DelegationTokenCommand$ delegationTokenCommand$ = this;
        synchronized (delegationTokenCommand$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void main(String[] args) {
        DelegationTokenCommand.DelegationTokenCommandOptions opts = new DelegationTokenCommand.DelegationTokenCommandOptions(args);
        if (args.length == 0) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "Tool to create, renew, expire, or describe delegation tokens.");
        }
        int actions = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpecBuilder[]{opts.createOpt(), opts.renewOpt(), opts.expiryOpt(), opts.describeOpt()}))).count((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DelegationTokenCommand$.$anonfun$main$1(opts, x$1)));
        if (actions != 1) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "Command must include exactly one action: --create, --renew, --expire or --describe");
        }
        opts.checkArgs();
        AdminClient adminClient = this.createAdminClient(opts);
        int exitCode = 0;
        try {
            try {
                if (opts.options().has((OptionSpec)opts.createOpt())) {
                    this.createToken(adminClient, opts);
                }
                if (opts.options().has((OptionSpec)opts.renewOpt())) {
                    this.renewToken(adminClient, opts);
                }
                if (opts.options().has((OptionSpec)opts.expiryOpt())) {
                    this.expireToken(adminClient, opts);
                }
                if (opts.options().has((OptionSpec)opts.describeOpt())) {
                    this.describeToken(adminClient, opts);
                }
            }
            catch (Throwable e) {
                Predef$.MODULE$.println((Object)("Error while executing delegation token command : " + e.getMessage()));
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> Utils.stackTrace(e));
                exitCode = 1;
            }
        }
        finally {
            adminClient.close();
            throw Exit$.MODULE$.exit(exitCode, Exit$.MODULE$.exit$default$2());
        }
    }

    public void createToken(AdminClient adminClient, DelegationTokenCommand.DelegationTokenCommandOptions opts) {
        DelegationToken token;
        block5: {
            Tuple2<Errors, DelegationToken> tuple2;
            block4: {
                Tuple2<Errors, DelegationToken> response;
                List<KafkaPrincipal> renewerPrincipals = this.getPrincipals(opts, opts.renewPrincipalsOpt());
                long maxLifeTimeMs = Predef$.MODULE$.long2Long(BoxesRunTime.unboxToLong((Object)opts.options().valueOf(opts.maxLifeTimeOpt())));
                Predef$.MODULE$.println((Object)("Calling create token operation with renewers :" + renewerPrincipals + " , max-life-time-period :" + maxLifeTimeMs));
                tuple2 = response = adminClient.createToken(renewerPrincipals, maxLifeTimeMs);
                if (tuple2 == null) break block4;
                Errors errors = (Errors)((Object)tuple2._1());
                token = (DelegationToken)tuple2._2();
                if (((Object)((Object)Errors.NONE)).equals((Object)errors)) break block5;
            }
            if (tuple2 != null) {
                Errors e = (Errors)((Object)tuple2._1());
                throw new AdminOperationException(e.message());
            }
            throw new MatchError(tuple2);
        }
        Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Created delegation token with tokenId : %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{token.tokenInfo().tokenId()})));
        this.printToken((List<DelegationToken>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DelegationToken[]{token})));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public void printToken(List<DelegationToken> tokens) {
        Predef$.MODULE$.print((Object)new StringOps(Predef$.MODULE$.augmentString("\n%-15s %-30s %-15s %-25s %-15s %-15s %-15s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"TOKENID", "HMAC", "OWNER", "RENEWERS", "ISSUEDATE", "EXPIRYDATE", "MAXDATE"})));
        tokens.foreach((Function1 & Serializable & scala.Serializable)token -> {
            DelegationTokenCommand$.$anonfun$printToken$1(token);
            return BoxedUnit.UNIT;
        });
    }

    private List<KafkaPrincipal> getPrincipals(DelegationTokenCommand.DelegationTokenCommandOptions opts, ArgumentAcceptingOptionSpec<String> principalOptionSpec) {
        return opts.options().has(principalOptionSpec) ? ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(opts.options().valuesOf(principalOptionSpec)).asScala()).map((Function1 & Serializable & scala.Serializable)s -> SecurityUtils.parseKafkaPrincipal(s.trim()), Buffer$.MODULE$.canBuildFrom())).toList() : List$.MODULE$.empty();
    }

    public void renewToken(AdminClient adminClient, DelegationTokenCommand.DelegationTokenCommandOptions opts) {
        long expiryTimeStamp;
        block5: {
            Tuple2<Errors, Object> tuple2;
            block4: {
                Tuple2<Errors, Object> response;
                String hmac = (String)opts.options().valueOf(opts.hmacOpt());
                long renewTimePeriodMs = Predef$.MODULE$.long2Long(BoxesRunTime.unboxToLong((Object)opts.options().valueOf(opts.renewTimePeriodOpt())));
                Predef$.MODULE$.println((Object)("Calling renew token operation with hmac :" + hmac + " , renew-time-period :" + renewTimePeriodMs));
                tuple2 = response = adminClient.renewToken(ByteBuffer.wrap(Base64.decoder().decode(hmac)), renewTimePeriodMs);
                if (tuple2 == null) break block4;
                Errors errors = (Errors)((Object)tuple2._1());
                expiryTimeStamp = tuple2._2$mcJ$sp();
                if (((Object)((Object)Errors.NONE)).equals((Object)errors)) break block5;
            }
            if (tuple2 != null) {
                Errors e = (Errors)((Object)tuple2._1());
                throw new AdminOperationException(e.message());
            }
            throw new MatchError(tuple2);
        }
        Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Completed renew operation. New expiry timestamp : %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)expiryTimeStamp)})));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public void expireToken(AdminClient adminClient, DelegationTokenCommand.DelegationTokenCommandOptions opts) {
        long expiryTimeStamp;
        block5: {
            Tuple2<Errors, Object> tuple2;
            block4: {
                Tuple2<Errors, Object> response;
                String hmac = (String)opts.options().valueOf(opts.hmacOpt());
                long expiryTimePeriodMs = Predef$.MODULE$.long2Long(BoxesRunTime.unboxToLong((Object)opts.options().valueOf(opts.expiryTimePeriodOpt())));
                Predef$.MODULE$.println((Object)("Calling expire token operation with hmac :" + hmac + " , expire-time-period : " + expiryTimePeriodMs));
                tuple2 = response = adminClient.expireToken(ByteBuffer.wrap(Base64.decoder().decode(hmac)), expiryTimePeriodMs);
                if (tuple2 == null) break block4;
                Errors errors = (Errors)((Object)tuple2._1());
                expiryTimeStamp = tuple2._2$mcJ$sp();
                if (((Object)((Object)Errors.NONE)).equals((Object)errors)) break block5;
            }
            if (tuple2 != null) {
                Errors e = (Errors)((Object)tuple2._1());
                throw new AdminOperationException(e.message());
            }
            throw new MatchError(tuple2);
        }
        Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Completed expire operation. New expiry timestamp : %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)expiryTimeStamp)})));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public void describeToken(AdminClient adminClient, DelegationTokenCommand.DelegationTokenCommandOptions opts) {
        List tokens;
        block5: {
            Tuple2<Errors, List<DelegationToken>> tuple2;
            block4: {
                Tuple2<Errors, List<DelegationToken>> response;
                List<KafkaPrincipal> ownerPrincipals = this.getPrincipals(opts, opts.ownerPrincipalsOpt());
                Predef$.MODULE$.println((Object)("Calling describe token operation for owners :" + ownerPrincipals));
                tuple2 = response = adminClient.describeToken(ownerPrincipals);
                if (tuple2 == null) break block4;
                Errors errors = (Errors)((Object)tuple2._1());
                tokens = (List)tuple2._2();
                if (((Object)((Object)Errors.NONE)).equals((Object)errors)) break block5;
            }
            if (tuple2 != null) {
                Errors e = (Errors)((Object)tuple2._1());
                throw new AdminOperationException(e.message());
            }
            throw new MatchError(tuple2);
        }
        Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Total Number of tokens : %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)tokens.size())})));
        this.printToken((List<DelegationToken>)tokens);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private AdminClient createAdminClient(DelegationTokenCommand.DelegationTokenCommandOptions opts) {
        Properties props = Utils.loadProps((String)opts.options().valueOf(opts.commandConfigOpt()));
        props.put("bootstrap.servers", opts.options().valueOf(opts.bootstrapServerOpt()));
        return AdminClient$.MODULE$.create(props);
    }

    public static final /* synthetic */ boolean $anonfun$main$1(DelegationTokenCommand.DelegationTokenCommandOptions opts$1, OptionSpec x$1) {
        return opts$1.options().has(x$1);
    }

    public static final /* synthetic */ void $anonfun$printToken$1(DelegationToken token) {
        TokenInformation tokenInfo = token.tokenInfo();
        Predef$.MODULE$.print((Object)new StringOps(Predef$.MODULE$.augmentString("\n%-15s %-30s %-15s %-25s %-15s %-15s %-15s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tokenInfo.tokenId(), token.hmacAsBase64String(), tokenInfo.owner(), tokenInfo.renewersAsString(), BoxesRunTime.boxToLong((long)tokenInfo.issueTimestamp()), BoxesRunTime.boxToLong((long)tokenInfo.expiryTimestamp()), BoxesRunTime.boxToLong((long)tokenInfo.maxTimestamp())})));
        Predef$.MODULE$.println();
    }

    private DelegationTokenCommand$() {
        MODULE$ = this;
        Logging.$init$(this);
    }
}

