/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.admin;

import com.typesafe.scalalogging.Logger;
import io.confluent.kafka.admin.ConfigCommand$;
import io.confluent.kafka.log.LogConfig$;
import io.confluent.kafka.server.ConfigEntityName$;
import io.confluent.kafka.server.ConfigType$;
import io.confluent.kafka.server.DynamicConfig$Broker$;
import io.confluent.kafka.server.DynamicConfig$Client$;
import io.confluent.kafka.server.DynamicConfig$User$;
import io.confluent.kafka.utils.CommandLineUtils$;
import io.confluent.kafka.zk.KafkaZkClient;
import io.confluent.org.apache.kafka.common.utils.Sanitizer;
import java.io.Serializable;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Buffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\r\rw!B\u0001\u0003\u0011\u00039\u0011!D\"p]\u001aLwmQ8n[\u0006tGM\u0003\u0002\u0004\t\u0005)\u0011\rZ7j]*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0011\u0005!IQ\"\u0001\u0002\u0007\u000b)\u0011\u0001\u0012A\u0006\u0003\u001b\r{gNZ5h\u0007>lW.\u00198e'\rIAB\u0005\t\u0003\u001bAi\u0011A\u0004\u0006\u0002\u001f\u0005)1oY1mC&\u0011\u0011C\u0004\u0002\u0007\u0003:L(+\u001a4\u0011\u0005M1R\"\u0001\u000b\u000b\u0005U!\u0011AB2p[6|g.\u0003\u0002\u0018)\t11i\u001c8gS\u001eDQ!G\u0005\u0005\u0002i\ta\u0001P5oSRtD#A\u0004\t\u000fqI!\u0019!C\u0001;\u00051B)\u001a4bk2$8k\u0019:b[&#XM]1uS>t7/F\u0001\u001f!\tiq$\u0003\u0002!\u001d\t\u0019\u0011J\u001c;\t\r\tJ\u0001\u0015!\u0003\u001f\u0003]!UMZ1vYR\u001c6M]1n\u0013R,'/\u0019;j_:\u001c\b\u0005C\u0004%\u0013\t\u0007I\u0011A\u0013\u0002I\t\u0013xn[3s\u0007>tg-[4t+B$\u0017\r^1cY\u0016,6/\u001b8h5>|7*Z3qKJ,\u0012A\n\t\u0004O)bS\"\u0001\u0015\u000b\u0005%r\u0011AC2pY2,7\r^5p]&\u00111\u0006\u000b\u0002\u0004'\u0016$\bCA\u00173\u001b\u0005q#BA\u00181\u0003\u0011a\u0017M\\4\u000b\u0003E\nAA[1wC&\u00111G\f\u0002\u0007'R\u0014\u0018N\\4\t\rUJ\u0001\u0015!\u0003'\u0003\u0015\u0012%o\\6fe\u000e{gNZ5hgV\u0003H-\u0019;bE2,Wk]5oOj{wnS3fa\u0016\u0014\b\u0005C\u00038\u0013\u0011\u0005\u0001(\u0001\u0003nC&tGCA\u001d=!\ti!(\u0003\u0002<\u001d\t!QK\\5u\u0011\u0015id\u00071\u0001?\u0003\u0011\t'oZ:\u0011\u00075y\u0014)\u0003\u0002A\u001d\t)\u0011I\u001d:bsB\u0011!)\u0013\b\u0003\u0007\u001e\u0003\"\u0001\u0012\b\u000e\u0003\u0015S!A\u0012\u0004\u0002\rq\u0012xn\u001c;?\u0013\tAe\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003g)S!\u0001\u0013\b\t\u000b1KA\u0011B'\u0002)A\u0014xnY3tg\u000e{W.\\1oI^KG\u000f\u001b.l)\rId\n\u0015\u0005\u0006\u001f.\u0003\r!Q\u0001\u0010u.\u001cuN\u001c8fGR\u001cFO]5oO\")\u0011k\u0013a\u0001%\u0006!q\u000e\u001d;t!\t\u0019F+D\u0001\n\r\u0011)\u0016\u0002\u0001,\u0003)\r{gNZ5h\u0007>lW.\u00198e\u001fB$\u0018n\u001c8t'\t!F\u0002\u0003\u0005>)\n\u0005\t\u0015!\u0003?\u0011\u0015IB\u000b\"\u0001Z)\t\u0011&\fC\u0003>1\u0002\u0007a\bC\u0004])\n\u0007I\u0011A/\u0002\rA\f'o]3s+\u0005q\u0006CA0c\u001b\u0005\u0001'\"A1\u0002\u0015)|\u0007\u000f^:j[BdW-\u0003\u0002dA\naq\n\u001d;j_:\u0004\u0016M]:fe\"1Q\r\u0016Q\u0001\ny\u000bq\u0001]1sg\u0016\u0014\b\u0005C\u0004h)\n\u0007I\u0011\u00015\u0002\u0019i\\7i\u001c8oK\u000e$x\n\u001d;\u0016\u0003%\u00042a\u00186B\u0013\tY\u0007MA\u000eBe\u001e,X.\u001a8u\u0003\u000e\u001cW\r\u001d;j]\u001e|\u0005\u000f^5p]N\u0003Xm\u0019\u0005\u0007[R\u0003\u000b\u0011B5\u0002\u001bi\\7i\u001c8oK\u000e$x\n\u001d;!\u0011\u001dyGK1A\u0005\u0002!\f!CY8piN$(/\u00199TKJ4XM](qi\"1\u0011\u000f\u0016Q\u0001\n%\f1CY8piN$(/\u00199TKJ4XM](qi\u0002Bqa\u001d+C\u0002\u0013\u0005\u0001.\u0001\td_6l\u0017M\u001c3D_:4\u0017nZ(qi\"1Q\u000f\u0016Q\u0001\n%\f\u0011cY8n[\u0006tGmQ8oM&<w\n\u001d;!\u0011\u001d9HK1A\u0005\u0002a\f\u0001\"\u00197uKJ|\u0005\u000f^\u000b\u0002sB\u0011qL_\u0005\u0003w\u0002\u0014\u0011c\u00149uS>t7\u000b]3d\u0005VLG\u000eZ3s\u0011\u0019iH\u000b)A\u0005s\u0006I\u0011\r\u001c;fe>\u0003H\u000f\t\u0005\b\u007fR\u0013\r\u0011\"\u0001y\u0003-!Wm]2sS\n,w\n\u001d;\t\u000f\u0005\rA\u000b)A\u0005s\u0006aA-Z:de&\u0014Wm\u00149uA!A\u0011q\u0001+C\u0002\u0013\u0005\u0001.\u0001\u0006f]RLG/\u001f+za\u0016Dq!a\u0003UA\u0003%\u0011.A\u0006f]RLG/\u001f+za\u0016\u0004\u0003\u0002CA\b)\n\u0007I\u0011\u00015\u0002\u0015\u0015tG/\u001b;z\u001d\u0006lW\rC\u0004\u0002\u0014Q\u0003\u000b\u0011B5\u0002\u0017\u0015tG/\u001b;z\u001d\u0006lW\r\t\u0005\t\u0003/!&\u0019!C\u0001q\u0006iQM\u001c;jif$UMZ1vYRDq!a\u0007UA\u0003%\u00110\u0001\bf]RLG/\u001f#fM\u0006,H\u000e\u001e\u0011\t\u0013\u0005}AK1A\u0005\u0002\u0005\u0005\u0012A\u00018m+\u0005a\u0003bBA\u0013)\u0002\u0006I\u0001L\u0001\u0004]2\u0004\u0003\u0002CA\u0015)\n\u0007I\u0011\u00015\u0002\u0013\u0005$GmQ8oM&<\u0007bBA\u0017)\u0002\u0006I![\u0001\u000bC\u0012$7i\u001c8gS\u001e\u0004\u0003\u0002CA\u0019)\n\u0007I\u0011\u00015\u0002\u0019\u0011,G.\u001a;f\u0007>tg-[4\t\u000f\u0005UB\u000b)A\u0005S\u0006iA-\u001a7fi\u0016\u001cuN\u001c4jO\u0002B\u0001\"!\u000fU\u0005\u0004%\t\u0001_\u0001\bQ\u0016d\u0007o\u00149u\u0011\u001d\ti\u0004\u0016Q\u0001\ne\f\u0001\u0002[3ma>\u0003H\u000f\t\u0005\t\u0003\u0003\"&\u0019!C\u0001q\u0006Aam\u001c:dK>\u0003H\u000fC\u0004\u0002FQ\u0003\u000b\u0011B=\u0002\u0013\u0019|'oY3PaR\u0004\u0003\"CA%)\n\u0007I\u0011AA&\u0003\u001dy\u0007\u000f^5p]N,\"!!\u0014\u0011\u0007}\u000by%C\u0002\u0002R\u0001\u0014\u0011b\u00149uS>t7+\u001a;\t\u0011\u0005UC\u000b)A\u0005\u0003\u001b\n\u0001b\u001c9uS>t7\u000f\t\u0005\n\u00033\"&\u0019!C\u0001\u00037\nq!\u00197m\u001fB$8/\u0006\u0002\u0002^A!qEKA0a\u0011\t\t'a\u001b\u0011\u000b}\u000b\u0019'a\u001a\n\u0007\u0005\u0015\u0004M\u0001\u0006PaRLwN\\*qK\u000e\u0004B!!\u001b\u0002l1\u0001A\u0001DA7\u0003_\n\t\u0011!A\u0003\u0002\u0005M$aA0%c!A\u0011\u0011\u000f+!\u0002\u0013\ti&\u0001\u0005bY2|\u0005\u000f^:!#\u0011\t)(a\u001f\u0011\u00075\t9(C\u0002\u0002z9\u0011qAT8uQ&tw\rE\u0002\u000e\u0003{J1!a \u000f\u0005\r\te.\u001f\u0005\b\u0003\u0007#F\u0011AAC\u0003%\u0019\u0007.Z2l\u0003J<7\u000fF\u0001:\u0011!\tI)\u0003C\u0001\u0005\u0005-\u0015aC1mi\u0016\u00148i\u001c8gS\u001e$r!OAG\u0003;\u000by\n\u0003\u0005\u0002\u0010\u0006\u001d\u0005\u0019AAI\u0003!Q8n\u00117jK:$\b\u0003BAJ\u00033k!!!&\u000b\u0007\u0005]E!\u0001\u0002{W&!\u00111TAK\u00055Y\u0015MZ6b5.\u001cE.[3oi\"1\u0011+a\"A\u0002IC\u0001\"!)\u0002\b\u0002\u0007\u00111U\u0001\u000eC\u0012l\u0017N\u001c.l\u00072LWM\u001c;\u0011\t\u0005M\u0015QU\u0005\u0005\u0003O\u000b)JA\u0007BI6LgNW6DY&,g\u000e\u001e\u0005\b\u0003WKA\u0011BAW\u0003i\u0001(/\u001a)s_\u000e,7o]*de\u0006l7I]3eK:$\u0018.\u00197t)\rI\u0014q\u0016\u0005\t\u0003c\u000bI\u000b1\u0001\u00024\u0006\u00012m\u001c8gS\u001e\u001cHk\u001c\"f\u0003\u0012$W\r\u001a\t\u0005\u0003k\u000bY,\u0004\u0002\u00028*\u0019\u0011\u0011\u0018\u0019\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003{\u000b9L\u0001\u0006Qe>\u0004XM\u001d;jKNDq!!1\n\t\u0013\t\u0019-\u0001\beKN\u001c'/\u001b2f\u0007>tg-[4\u0015\u000fe\n)-a2\u0002J\"A\u0011qRA`\u0001\u0004\t\t\n\u0003\u0004R\u0003\u007f\u0003\rA\u0015\u0005\t\u0003C\u000by\f1\u0001\u0002$\"A\u0011QZ\u0005\u0005\u0002\t\ty-A\u000bqCJ\u001cXmQ8oM&<7\u000fV8CK\u0006#G-\u001a3\u0015\t\u0005M\u0016\u0011\u001b\u0005\u0007#\u0006-\u0007\u0019\u0001*\t\u0011\u0005U\u0017\u0002\"\u0001\u0003\u0003/\fq\u0003]1sg\u0016\u001cuN\u001c4jON$vNQ3EK2,G/\u001a3\u0015\t\u0005e\u0017q\u001c\t\u0005O\u0005m\u0017)C\u0002\u0002^\"\u00121aU3r\u0011\u0019\t\u00161\u001ba\u0001%\"9\u00111]\u0005\u0005\n\u0005\u0015\u0018a\u00059s_\u000e,7o\u001d\"s_.,'oQ8oM&<GcA\u001d\u0002h\"1\u0011+!9A\u0002IC\u0001\"a;\n\t\u0003\u0011\u0011Q^\u0001\u0012C2$XM\u001d\"s_.,'oQ8oM&<GcB\u001d\u0002p\n-!Q\u0002\u0005\t\u0003c\fI\u000f1\u0001\u0002t\u0006Y\u0011\rZ7j]\u000ec\u0017.\u001a8u!\u0011\t)Pa\u0002\u000e\u0005\u0005](bA\u0002\u0002z*!\u00111`A\u007f\u0003\u001d\u0019G.[3oiNT1!BA\u0000\u0015\u0011\u0011\tAa\u0001\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\u0011)!A\u0002pe\u001eLAA!\u0003\u0002x\nY\u0011\tZ7j]\u000ec\u0017.\u001a8u\u0011\u0019\t\u0016\u0011\u001ea\u0001%\"9\u0011qBAu\u0001\u0004\t\u0005b\u0002B\t\u0013\u0011%!1C\u0001\u0015I\u0016\u001c8M]5cK\n\u0013xn[3s\u0007>tg-[4\u0015\u000fe\u0012)Ba\u0006\u0003\u001a!A\u0011\u0011\u001fB\b\u0001\u0004\t\u0019\u0010\u0003\u0004R\u0005\u001f\u0001\rA\u0015\u0005\b\u0003\u001f\u0011y\u00011\u0001B\u0011\u001d\u0011i\"\u0003C\u0005\u0005?\tAB\u0019:pW\u0016\u00148i\u001c8gS\u001e$\u0002B!\t\u0003*\t-\"Q\u0006\t\u0006O\u0005m'1\u0005\t\u0005\u0003k\u0014)#\u0003\u0003\u0003(\u0005](aC\"p]\u001aLw-\u00128uefD\u0001\"!=\u0003\u001c\u0001\u0007\u00111\u001f\u0005\b\u0003\u001f\u0011Y\u00021\u0001B\u0011!\u0011yCa\u0007A\u0002\tE\u0012aD5oG2,H-Z*z]>t\u00170\\:\u0011\u00075\u0011\u0019$C\u0002\u000369\u0011qAQ8pY\u0016\fgN\u0002\u0004\u0003:%\u0001%1\b\u0002\u0007\u000b:$\u0018\u000e^=\u0014\u000f\t]BB!\u0010\u0003DA\u0019QBa\u0010\n\u0007\t\u0005cBA\u0004Qe>$Wo\u0019;\u0011\u00075\u0011)%C\u0002\u0003H9\u0011AbU3sS\u0006d\u0017N_1cY\u0016D1\"a\u0002\u00038\tU\r\u0011\"\u0001\u0003LU\t\u0011\t\u0003\u0006\u0002\f\t]\"\u0011#Q\u0001\n\u0005C1B!\u0015\u00038\tU\r\u0011\"\u0001\u0003T\u0005i1/\u00198ji&TX\r\u001a(b[\u0016,\"A!\u0016\u0011\t5\u00119&Q\u0005\u0004\u00053r!AB(qi&|g\u000eC\u0006\u0003^\t]\"\u0011#Q\u0001\n\tU\u0013AD:b]&$\u0018N_3e\u001d\u0006lW\r\t\u0005\b3\t]B\u0011\u0001B1)\u0019\u0011\u0019G!\u001a\u0003hA\u00191Ka\u000e\t\u000f\u0005\u001d!q\fa\u0001\u0003\"A!\u0011\u000bB0\u0001\u0004\u0011)\u0006\u0003\u0006\u0003l\t]\"\u0019!C\u0001\u0003C\t!\"\u001a8uSRL\b+\u0019;i\u0011!\u0011yGa\u000e!\u0002\u0013a\u0013aC3oi&$\u0018\u0010U1uQ\u0002B\u0001Ba\u001d\u00038\u0011\u0005#QO\u0001\ti>\u001cFO]5oOR\t\u0011\t\u0003\u0006\u0003z\t]\u0012\u0011!C\u0001\u0005w\nAaY8qsR1!1\rB?\u0005\u007fB\u0011\"a\u0002\u0003xA\u0005\t\u0019A!\t\u0015\tE#q\u000fI\u0001\u0002\u0004\u0011)\u0006\u0003\u0006\u0003\u0004\n]\u0012\u0013!C\u0001\u0005\u000b\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003\b*\u001a\u0011I!#,\u0005\t-\u0005\u0003\u0002BG\u0005/k!Aa$\u000b\t\tE%1S\u0001\nk:\u001c\u0007.Z2lK\u0012T1A!&\u000f\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u00053\u0013yIA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D!B!(\u00038E\u0005I\u0011\u0001BP\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"A!)+\t\tU#\u0011\u0012\u0005\u000b\u0005K\u00139$!A\u0005B\u0005\u0005\u0012!\u00049s_\u0012,8\r\u001e)sK\u001aL\u0007\u0010C\u0005\u0003*\n]\u0012\u0011!C\u0001;\u0005a\u0001O]8ek\u000e$\u0018I]5us\"Q!Q\u0016B\u001c\u0003\u0003%\tAa,\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u00111\u0010BY\u0011%\u0011\u0019La+\u0002\u0002\u0003\u0007a$A\u0002yIEB!Ba.\u00038\u0005\u0005I\u0011\tB]\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XC\u0001B^!\u00159#QXA>\u0013\r\u0011y\f\u000b\u0002\t\u0013R,'/\u0019;pe\"Q!1\u0019B\u001c\u0003\u0003%\tA!2\u0002\u0011\r\fg.R9vC2$BA!\r\u0003H\"Q!1\u0017Ba\u0003\u0003\u0005\r!a\u001f\t\u0015\t-'qGA\u0001\n\u0003\u0012i-\u0001\u0005iCND7i\u001c3f)\u0005q\u0002B\u0003Bi\u0005o\t\t\u0011\"\u0011\u0003T\u00061Q-];bYN$BA!\r\u0003V\"Q!1\u0017Bh\u0003\u0003\u0005\r!a\u001f\b\u0013\te\u0017\"!A\t\u0002\tm\u0017AB#oi&$\u0018\u0010E\u0002T\u0005;4\u0011B!\u000f\n\u0003\u0003E\tAa8\u0014\r\tu'\u0011\u001dB\"!%\u0011\u0019O!;B\u0005+\u0012\u0019'\u0004\u0002\u0003f*\u0019!q\u001d\b\u0002\u000fI,h\u000e^5nK&!!1\u001eBs\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\u0005\b3\tuG\u0011\u0001Bx)\t\u0011Y\u000e\u0003\u0006\u0003t\tu\u0017\u0011!C#\u0005g$\u0012\u0001\f\u0005\u000b\u0005o\u0014i.!A\u0005\u0002\ne\u0018!B1qa2LHC\u0002B2\u0005w\u0014i\u0010C\u0004\u0002\b\tU\b\u0019A!\t\u0011\tE#Q\u001fa\u0001\u0005+B!b!\u0001\u0003^\u0006\u0005I\u0011QB\u0002\u0003\u001d)h.\u00199qYf$Ba!\u0002\u0004\u000eA)QBa\u0016\u0004\bA1Qb!\u0003B\u0005+J1aa\u0003\u000f\u0005\u0019!V\u000f\u001d7fe!Q1q\u0002B\u0000\u0003\u0003\u0005\rAa\u0019\u0002\u0007a$\u0003\u0007\u0003\u0006\u0004\u0014\tu\u0017\u0011!C\u0005\u0007+\t1B]3bIJ+7o\u001c7wKR\u00111q\u0003\t\u0004[\re\u0011bAB\u000e]\t1qJ\u00196fGR4aaa\b\n\u0001\u000e\u0005\"\u0001D\"p]\u001aLw-\u00128uSRL8cBB\u000f\u0019\tu\"1\t\u0005\f\u0007K\u0019iB!f\u0001\n\u0003\u00199#\u0001\u0003s_>$XC\u0001B2\u0011-\u0019Yc!\b\u0003\u0012\u0003\u0006IAa\u0019\u0002\u000bI|w\u000e\u001e\u0011\t\u0017\r=2Q\u0004BK\u0002\u0013\u00051\u0011G\u0001\u0006G\"LG\u000eZ\u000b\u0003\u0007g\u0001R!\u0004B,\u0005GB1ba\u000e\u0004\u001e\tE\t\u0015!\u0003\u00044\u000511\r[5mI\u0002Bq!GB\u000f\t\u0003\u0019Y\u0004\u0006\u0004\u0004>\r}2\u0011\t\t\u0004'\u000eu\u0001\u0002CB\u0013\u0007s\u0001\rAa\u0019\t\u0011\r=2\u0011\ba\u0001\u0007gA!b!\u0012\u0004\u001e\t\u0007I\u0011AA\u0011\u0003E1W\u000f\u001c7TC:LG/\u001b>fI:\u000bW.\u001a\u0005\t\u0007\u0013\u001ai\u0002)A\u0005Y\u0005\u0011b-\u001e7m'\u0006t\u0017\u000e^5{K\u0012t\u0015-\\3!\u0011!\u0019ie!\b\u0005\u0002\r=\u0013AD4fi\u0006cG.\u00128uSRLWm\u001d\u000b\u0005\u0007#\u001a\u0019\u0006E\u0003(\u00037\u001ci\u0004\u0003\u0005\u0002\u0010\u000e-\u0003\u0019AAI\u0011!\u0011\u0019h!\b\u0005B\tU\u0004B\u0003B=\u0007;\t\t\u0011\"\u0001\u0004ZQ11QHB.\u0007;B!b!\n\u0004XA\u0005\t\u0019\u0001B2\u0011)\u0019yca\u0016\u0011\u0002\u0003\u000711\u0007\u0005\u000b\u0005\u0007\u001bi\"%A\u0005\u0002\r\u0005TCAB2U\u0011\u0011\u0019G!#\t\u0015\tu5QDI\u0001\n\u0003\u00199'\u0006\u0002\u0004j)\"11\u0007BE\u0011)\u0011)k!\b\u0002\u0002\u0013\u0005\u0013\u0011\u0005\u0005\n\u0005S\u001bi\"!A\u0005\u0002uA!B!,\u0004\u001e\u0005\u0005I\u0011AB9)\u0011\tYha\u001d\t\u0013\tM6qNA\u0001\u0002\u0004q\u0002B\u0003B\\\u0007;\t\t\u0011\"\u0011\u0003:\"Q!1YB\u000f\u0003\u0003%\ta!\u001f\u0015\t\tE21\u0010\u0005\u000b\u0005g\u001b9(!AA\u0002\u0005m\u0004B\u0003Bf\u0007;\t\t\u0011\"\u0011\u0003N\"Q!\u0011[B\u000f\u0003\u0003%\te!!\u0015\t\tE21\u0011\u0005\u000b\u0005g\u001by(!AA\u0002\u0005mt!CBD\u0013\u0005\u0005\t\u0012ABE\u00031\u0019uN\u001c4jO\u0016sG/\u001b;z!\r\u001961\u0012\u0004\n\u0007?I\u0011\u0011!E\u0001\u0007\u001b\u001bbaa#\u0004\u0010\n\r\u0003C\u0003Br\u0005S\u0014\u0019ga\r\u0004>!9\u0011da#\u0005\u0002\rMECABE\u0011)\u0011\u0019ha#\u0002\u0002\u0013\u0015#1\u001f\u0005\u000b\u0005o\u001cY)!A\u0005\u0002\u000eeECBB\u001f\u00077\u001bi\n\u0003\u0005\u0004&\r]\u0005\u0019\u0001B2\u0011!\u0019yca&A\u0002\rM\u0002BCB\u0001\u0007\u0017\u000b\t\u0011\"!\u0004\"R!11UBT!\u0015i!qKBS!\u001di1\u0011\u0002B2\u0007gA!ba\u0004\u0004 \u0006\u0005\t\u0019AB\u001f\u0011)\u0019\u0019ba#\u0002\u0002\u0013%1Q\u0003\u0005\t\u0007[KA\u0011\u0001\u0002\u00040\u0006Y\u0001/\u0019:tK\u0016sG/\u001b;z)\u0011\u0019id!-\t\rE\u001bY\u000b1\u0001S\u0011\u001d\u0019),\u0003C\u0005\u0007o\u000b1\"\u001a8uSRLh*Y7fgR!\u0011\u0011\\B]\u0011\u0019\t61\u0017a\u0001%\"91QX\u0005\u0005\n\r}\u0016\u0001\u00059beN,\u0017+^8uC\u0016sG/\u001b;z)\u0011\u0019id!1\t\rE\u001bY\f1\u0001S\u0001")
public final class ConfigCommand {
    public static void fatal(Function0<String> function0, Function0<Throwable> function02) {
        ConfigCommand$.MODULE$.fatal(function0, function02);
    }

    public static void fatal(Function0<String> function0) {
        ConfigCommand$.MODULE$.fatal(function0);
    }

    public static void error(Function0<String> function0, Function0<Throwable> function02) {
        ConfigCommand$.MODULE$.error(function0, function02);
    }

    public static void error(Function0<String> function0) {
        ConfigCommand$.MODULE$.error(function0);
    }

    public static void warn(Function0<String> function0, Function0<Throwable> function02) {
        ConfigCommand$.MODULE$.warn(function0, function02);
    }

    public static void warn(Function0<String> function0) {
        ConfigCommand$.MODULE$.warn(function0);
    }

    public static void info(Function0<String> function0, Function0<Throwable> function02) {
        ConfigCommand$.MODULE$.info(function0, function02);
    }

    public static void info(Function0<String> function0) {
        ConfigCommand$.MODULE$.info(function0);
    }

    public static void debug(Function0<String> function0, Function0<Throwable> function02) {
        ConfigCommand$.MODULE$.debug(function0, function02);
    }

    public static void debug(Function0<String> function0) {
        ConfigCommand$.MODULE$.debug(function0);
    }

    public static boolean isTraceEnabled() {
        return ConfigCommand$.MODULE$.isTraceEnabled();
    }

    public static boolean isDebugEnabled() {
        return ConfigCommand$.MODULE$.isDebugEnabled();
    }

    public static void trace(Function0<String> function0, Function0<Throwable> function02) {
        ConfigCommand$.MODULE$.trace(function0, function02);
    }

    public static void trace(Function0<String> function0) {
        ConfigCommand$.MODULE$.trace(function0);
    }

    public static String msgWithLogIdent(String string) {
        return ConfigCommand$.MODULE$.msgWithLogIdent(string);
    }

    public static String loggerName() {
        return ConfigCommand$.MODULE$.loggerName();
    }

    public static void validateChars(String string, String string2) {
        ConfigCommand$.MODULE$.validateChars(string, string2);
    }

    public static void main(String[] stringArray) {
        ConfigCommand$.MODULE$.main(stringArray);
    }

    public static Set<String> BrokerConfigsUpdatableUsingZooKeeper() {
        return ConfigCommand$.MODULE$.BrokerConfigsUpdatableUsingZooKeeper();
    }

    public static int DefaultScramIterations() {
        return ConfigCommand$.MODULE$.DefaultScramIterations();
    }

    public static String logIdent() {
        return ConfigCommand$.MODULE$.logIdent();
    }

    public static Logger logger() {
        return ConfigCommand$.MODULE$.logger();
    }

    public static class ConfigCommandOptions {
        private final OptionParser parser = new OptionParser(false);
        private final ArgumentAcceptingOptionSpec<String> zkConnectOpt = this.parser().accepts("zookeeper", "REQUIRED: The connection string for the zookeeper connection in the form host:port. Multiple URLS can be given to allow fail-over.").withRequiredArg().describedAs("urls").ofType(String.class);
        private final ArgumentAcceptingOptionSpec<String> bootstrapServerOpt = this.parser().accepts("bootstrap-server", "The Kafka server to connect to. This is required for describing and altering broker configs.").withRequiredArg().describedAs("server to connect to").ofType(String.class);
        private final ArgumentAcceptingOptionSpec<String> commandConfigOpt = this.parser().accepts("command-config", "Property file containing configs to be passed to Admin Client. This is used only with --bootstrap-server option for describing and altering broker configs.").withRequiredArg().describedAs("command config property file").ofType(String.class);
        private final OptionSpecBuilder alterOpt = this.parser().accepts("alter", "Alter the configuration for the entity.");
        private final OptionSpecBuilder describeOpt = this.parser().accepts("describe", "List configs for the given entity.");
        private final ArgumentAcceptingOptionSpec<String> entityType = this.parser().accepts("entity-type", "Type of entity (topics/clients/users/brokers)").withRequiredArg().ofType(String.class);
        private final ArgumentAcceptingOptionSpec<String> entityName = this.parser().accepts("entity-name", "Name of entity (topic name/client id/user principal name/broker id)").withRequiredArg().ofType(String.class);
        private final OptionSpecBuilder entityDefault = this.parser().accepts("entity-default", "Default entity name for clients/users/brokers (applies to corresponding entity type in command line)");
        private final String nl = System.getProperty("line.separator");
        private final ArgumentAcceptingOptionSpec<String> addConfig = this.parser().accepts("add-config", "Key Value pairs of configs to add. Square brackets can be used to group values which contain commas: 'k1=v1,k2=[v1,v2,v2],k3=v3'. The following is a list of valid configurations: For entity_type '" + ConfigType$.MODULE$.Topic() + "': " + ((TraversableOnce)LogConfig$.MODULE$.configNames().map((Function1 & Serializable & scala.Serializable)x$8 -> "\t" + x$8, Seq$.MODULE$.canBuildFrom())).mkString(this.nl(), this.nl(), this.nl()) + "For entity_type '" + ConfigType$.MODULE$.Broker() + "': " + ((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(DynamicConfig$Broker$.MODULE$.names()).asScala()).map((Function1 & Serializable & scala.Serializable)x$9 -> "\t" + x$9, scala.collection.mutable.Set$.MODULE$.canBuildFrom())).mkString(this.nl(), this.nl(), this.nl()) + "For entity_type '" + ConfigType$.MODULE$.User() + "': " + ((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(DynamicConfig$User$.MODULE$.names()).asScala()).map((Function1 & Serializable & scala.Serializable)x$10 -> "\t" + x$10, scala.collection.mutable.Set$.MODULE$.canBuildFrom())).mkString(this.nl(), this.nl(), this.nl()) + "For entity_type '" + ConfigType$.MODULE$.Client() + "': " + ((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(DynamicConfig$Client$.MODULE$.names()).asScala()).map((Function1 & Serializable & scala.Serializable)x$11 -> "\t" + x$11, scala.collection.mutable.Set$.MODULE$.canBuildFrom())).mkString(this.nl(), this.nl(), this.nl()) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Entity types '", "' and '", "' may be specified together to update config for clients of a specific user."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ConfigType$.MODULE$.User(), ConfigType$.MODULE$.Client()}))).withRequiredArg().ofType(String.class);
        private final ArgumentAcceptingOptionSpec<String> deleteConfig = this.parser().accepts("delete-config", "config keys to remove 'k1,k2'").withRequiredArg().ofType(String.class).withValuesSeparatedBy(',');
        private final OptionSpecBuilder helpOpt = this.parser().accepts("help", "Print usage information.");
        private final OptionSpecBuilder forceOpt = this.parser().accepts("force", "Suppress console prompts");
        private final OptionSet options;
        private final Set<OptionSpec<?>> allOpts;

        public OptionParser parser() {
            return this.parser;
        }

        public ArgumentAcceptingOptionSpec<String> zkConnectOpt() {
            return this.zkConnectOpt;
        }

        public ArgumentAcceptingOptionSpec<String> bootstrapServerOpt() {
            return this.bootstrapServerOpt;
        }

        public ArgumentAcceptingOptionSpec<String> commandConfigOpt() {
            return this.commandConfigOpt;
        }

        public OptionSpecBuilder alterOpt() {
            return this.alterOpt;
        }

        public OptionSpecBuilder describeOpt() {
            return this.describeOpt;
        }

        public ArgumentAcceptingOptionSpec<String> entityType() {
            return this.entityType;
        }

        public ArgumentAcceptingOptionSpec<String> entityName() {
            return this.entityName;
        }

        public OptionSpecBuilder entityDefault() {
            return this.entityDefault;
        }

        public String nl() {
            return this.nl;
        }

        public ArgumentAcceptingOptionSpec<String> addConfig() {
            return this.addConfig;
        }

        public ArgumentAcceptingOptionSpec<String> deleteConfig() {
            return this.deleteConfig;
        }

        public OptionSpecBuilder helpOpt() {
            return this.helpOpt;
        }

        public OptionSpecBuilder forceOpt() {
            return this.forceOpt;
        }

        public OptionSet options() {
            return this.options;
        }

        public Set<OptionSpec<?>> allOpts() {
            return this.allOpts;
        }

        public void checkArgs() {
            int actions = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpecBuilder[]{this.alterOpt(), this.describeOpt()}))).count((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ConfigCommandOptions.$anonfun$checkArgs$1(this, x$1)));
            if (actions != 1) {
                throw CommandLineUtils$.MODULE$.printUsageAndDie(this.parser(), "Command must include exactly one action: --describe, --alter");
            }
            CommandLineUtils$.MODULE$.checkInvalidArgs(this.parser(), this.options(), (OptionSpec<?>)this.alterOpt(), (Set<OptionSpec<?>>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{this.describeOpt()}))));
            CommandLineUtils$.MODULE$.checkInvalidArgs(this.parser(), this.options(), (OptionSpec<?>)this.describeOpt(), (Set<OptionSpec<?>>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{this.alterOpt(), this.addConfig(), this.deleteConfig()}))));
            Buffer entityTypeVals = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(this.options().valuesOf(this.entityType())).asScala();
            if (this.options().has(this.bootstrapServerOpt()) == this.options().has(this.zkConnectOpt())) {
                throw new IllegalArgumentException("Only one of --bootstrap-server or --zookeeper must be specified");
            }
            if (entityTypeVals.contains((Object)ConfigType$.MODULE$.Client()) || entityTypeVals.contains((Object)ConfigType$.MODULE$.Topic()) || entityTypeVals.contains((Object)ConfigType$.MODULE$.User())) {
                CommandLineUtils$.MODULE$.checkRequiredArgs(this.parser(), this.options(), (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{this.zkConnectOpt(), this.entityType()}));
            }
            if (this.options().has((OptionSpec)this.alterOpt())) {
                if (entityTypeVals.contains((Object)ConfigType$.MODULE$.User()) || entityTypeVals.contains((Object)ConfigType$.MODULE$.Client()) || entityTypeVals.contains((Object)ConfigType$.MODULE$.Broker())) {
                    if (!this.options().has(this.entityName()) && !this.options().has((OptionSpec)this.entityDefault())) {
                        throw new IllegalArgumentException("--entity-name or --entity-default must be specified with --alter of users, clients or brokers");
                    }
                } else if (!this.options().has(this.entityName())) {
                    throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-name must be specified with --alter of ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{entityTypeVals})));
                }
                boolean isAddConfigPresent = this.options().has(this.addConfig());
                boolean isDeleteConfigPresent = this.options().has(this.deleteConfig());
                if (!isAddConfigPresent && !isDeleteConfigPresent) {
                    throw new IllegalArgumentException("At least one of --add-config or --delete-config must be specified with --alter");
                }
            }
            entityTypeVals.foreach((Function1 & Serializable & scala.Serializable)entityTypeVal -> {
                ConfigCommandOptions.$anonfun$checkArgs$2(entityTypeVal);
                return BoxedUnit.UNIT;
            });
            if (entityTypeVals.isEmpty()) {
                throw new IllegalArgumentException("At least one --entity-type must be specified");
            }
            if (entityTypeVals.size() > 1 && !entityTypeVals.toSet().equals((Object)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{ConfigType$.MODULE$.User(), ConfigType$.MODULE$.Client()})))) {
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Only '", "' and '", "' entity types may be specified together"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ConfigType$.MODULE$.User(), ConfigType$.MODULE$.Client()})));
            }
        }

        public static final /* synthetic */ boolean $anonfun$checkArgs$1(ConfigCommandOptions $this, OptionSpec x$1) {
            return $this.options().has(x$1);
        }

        public static final /* synthetic */ void $anonfun$checkArgs$2(String entityTypeVal) {
            if (!ConfigType$.MODULE$.all().contains((Object)entityTypeVal)) {
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid entity-type ", ", --entity-type must be one of ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{entityTypeVal, ConfigType$.MODULE$.all()})));
            }
        }

        public ConfigCommandOptions(String[] args) {
            this.options = this.parser().parse(args);
            this.allOpts = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{this.alterOpt(), this.describeOpt(), this.entityType(), this.entityName(), this.addConfig(), this.deleteConfig(), this.helpOpt()}));
        }
    }

    public static class ConfigEntity
    implements Product,
    scala.Serializable {
        private final Entity root;
        private final Option<Entity> child;
        private final String fullSanitizedName;

        public Entity root() {
            return this.root;
        }

        public Option<Entity> child() {
            return this.child;
        }

        public String fullSanitizedName() {
            return this.fullSanitizedName;
        }

        public Seq<ConfigEntity> getAllEntities(KafkaZkClient zkClient) {
            Option option;
            Option option2;
            Seq seq;
            Option option3;
            Tuple2 tuple2 = new Tuple2(this.root().sanitizedName(), this.child());
            if (tuple2 != null && None$.MODULE$.equals(option3 = (Option)tuple2._1())) {
                Seq seq2;
                Seq rootEntities = (Seq)zkClient.getAllEntitiesWithConfig(this.root().entityType()).map((Function1 & Serializable & scala.Serializable)name -> new ConfigEntity(new Entity(this.root().entityType(), (Option<String>)new Some(name)), this.child()), Seq$.MODULE$.canBuildFrom());
                Option<Entity> option4 = this.child();
                if (option4 instanceof Some) {
                    Some some = (Some)option4;
                    Entity s = (Entity)some.value();
                    seq2 = (Seq)rootEntities.flatMap((Function1 & Serializable & scala.Serializable)rootEntity -> new ConfigEntity(rootEntity.root(), (Option<Entity>)new Some((Object)new Entity(s.entityType(), (Option<String>)None$.MODULE$))).getAllEntities(zkClient), Seq$.MODULE$.canBuildFrom());
                } else if (None$.MODULE$.equals(option4)) {
                    seq2 = rootEntities;
                } else {
                    throw new MatchError(option4);
                }
                seq = seq2;
            } else if (tuple2 != null && (option2 = (Option)tuple2._2()) instanceof Some) {
                Seq seq3;
                Some some = (Some)option2;
                Entity childEntity = (Entity)some.value();
                Option<String> option5 = childEntity.sanitizedName();
                if (option5 instanceof Some) {
                    seq3 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigEntity[]{this}));
                } else if (None$.MODULE$.equals(option5)) {
                    seq3 = (Seq)zkClient.getAllEntitiesWithConfig(this.root().entityPath() + "/" + childEntity.entityType()).map((Function1 & Serializable & scala.Serializable)name -> new ConfigEntity(this.root(), (Option<Entity>)new Some((Object)new Entity(childEntity.entityType(), (Option<String>)new Some(name)))), Seq$.MODULE$.canBuildFrom());
                } else {
                    throw new MatchError(option5);
                }
                seq = seq3;
            } else if (tuple2 != null && None$.MODULE$.equals(option = (Option)tuple2._2())) {
                seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigEntity[]{this}));
            } else {
                throw new MatchError((Object)tuple2);
            }
            return seq;
        }

        public String toString() {
            return this.root().toString() + this.child().map((Function1 & Serializable & scala.Serializable)s -> ", " + s.toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        }

        public ConfigEntity copy(Entity root, Option<Entity> child) {
            return new ConfigEntity(root, child);
        }

        public Entity copy$default$1() {
            return this.root();
        }

        public Option<Entity> copy$default$2() {
            return this.child();
        }

        public String productPrefix() {
            return "ConfigEntity";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Option<Entity> option;
            int n = x$1;
            switch (n) {
                case 0: {
                    option = this.root();
                    break;
                }
                case 1: {
                    option = this.child();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return option;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ConfigEntity;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ConfigEntity)) return false;
            boolean bl = true;
            if (!bl) return false;
            ConfigEntity configEntity = (ConfigEntity)x$1;
            Entity entity = this.root();
            Entity entity2 = configEntity.root();
            if (entity == null) {
                if (entity2 != null) {
                    return false;
                }
            } else if (!((Object)entity).equals(entity2)) return false;
            Option<Entity> option = this.child();
            Option<Entity> option2 = configEntity.child();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (!configEntity.canEqual(this)) return false;
            return true;
        }

        public ConfigEntity(Entity root, Option<Entity> child) {
            this.root = root;
            this.child = child;
            Product.$init$((Product)this);
            this.fullSanitizedName = (String)root.sanitizedName().getOrElse((Function0 & Serializable & scala.Serializable)() -> "") + child.map((Function1 & Serializable & scala.Serializable)s -> "/" + s.entityPath()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        }
    }

    public static class Entity
    implements Product,
    scala.Serializable {
        private final String entityType;
        private final Option<String> sanitizedName;
        private final String entityPath;

        public String entityType() {
            return this.entityType;
        }

        public Option<String> sanitizedName() {
            return this.sanitizedName;
        }

        public String entityPath() {
            return this.entityPath;
        }

        /*
         * Unable to fully structure code
         */
        public String toString() {
            block9: {
                block10: {
                    block8: {
                        var4_1 = this.entityType();
                        v0 = ConfigType$.MODULE$.User();
                        var5_2 = var4_1;
                        if (!(v0 != null ? v0.equals(var5_2) == false : var5_2 != null)) {
                            var2_3 = "user-principal";
                        } else {
                            v1 = ConfigType$.MODULE$.Client();
                            var6_4 = var4_1;
                            if (!(v1 != null ? v1.equals(var6_4) == false : var6_4 != null)) {
                                var2_3 = "client-id";
                            } else {
                                v2 = ConfigType$.MODULE$.Topic();
                                var7_5 = var4_1;
                                var2_3 = !(v2 != null ? v2.equals(var7_5) == false : var7_5 != null) ? "topic" : var4_1;
                            }
                        }
                        typeName = var2_3;
                        var8_7 = false;
                        var9_8 = null;
                        var10_9 = this.sanitizedName();
                        if (!(var10_9 instanceof Some)) break block8;
                        var8_7 = true;
                        var9_8 = (Some)var10_9;
                        var11_10 = (String)var9_8.value();
                        v3 = ConfigEntityName$.MODULE$.Default();
                        var12_11 = var11_10;
                        if (v3 != null ? v3.equals(var12_11) == false : var12_11 != null) break block8;
                        var1_12 = "default " + typeName;
                        break block9;
                    }
                    if (!var8_7) break block10;
                    n = (String)var9_8.value();
                    v4 = this.entityType();
                    var15_14 = ConfigType$.MODULE$.User();
                    if (!(v4 == null ? var15_14 != null : v4.equals(var15_14) == false)) ** GOTO lbl-1000
                    v5 = this.entityType();
                    var16_15 = ConfigType$.MODULE$.Client();
                    if (!(v5 != null ? v5.equals(var16_15) == false : var16_15 != null)) lbl-1000:
                    // 2 sources

                    {
                        v6 = Sanitizer.desanitize(n);
                    } else {
                        v6 = n;
                    }
                    desanitized = v6;
                    var1_12 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{typeName, desanitized}));
                    break block9;
                }
                if (None$.MODULE$.equals(var10_9)) {
                    var1_12 = this.entityType();
                } else {
                    throw new MatchError(var10_9);
                }
            }
            return var1_12;
        }

        public Entity copy(String entityType, Option<String> sanitizedName) {
            return new Entity(entityType, sanitizedName);
        }

        public String copy$default$1() {
            return this.entityType();
        }

        public Option<String> copy$default$2() {
            return this.sanitizedName();
        }

        public String productPrefix() {
            return "Entity";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Option<String> option;
            int n = x$1;
            switch (n) {
                case 0: {
                    option = this.entityType();
                    break;
                }
                case 1: {
                    option = this.sanitizedName();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return option;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Entity;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Entity)) return false;
            boolean bl = true;
            if (!bl) return false;
            Entity entity = (Entity)x$1;
            String string = this.entityType();
            String string2 = entity.entityType();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Option<String> option = this.sanitizedName();
            Option<String> option2 = entity.sanitizedName();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (!entity.canEqual(this)) return false;
            return true;
        }

        public Entity(String entityType, Option<String> sanitizedName) {
            String string;
            this.entityType = entityType;
            this.sanitizedName = sanitizedName;
            Product.$init$((Product)this);
            Option<String> option = sanitizedName;
            if (option instanceof Some) {
                Some some = (Some)option;
                String n = (String)some.value();
                string = entityType + "/" + n;
            } else if (None$.MODULE$.equals(option)) {
                string = entityType;
            } else {
                throw new MatchError(option);
            }
            this.entityPath = string;
        }
    }
}

