/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.admin;

import com.typesafe.scalalogging.Logger;
import io.confluent.kafka.admin.ConfigCommand;
import io.confluent.kafka.common.Config;
import io.confluent.kafka.common.InvalidConfigException;
import io.confluent.kafka.log.LogConfig$;
import io.confluent.kafka.server.ConfigEntityName$;
import io.confluent.kafka.server.ConfigType$;
import io.confluent.kafka.server.DynamicConfig$Broker$;
import io.confluent.kafka.utils.CommandLineUtils$;
import io.confluent.kafka.utils.Exit$;
import io.confluent.kafka.utils.Implicits$;
import io.confluent.kafka.utils.Logging;
import io.confluent.kafka.zk.AdminZkClient;
import io.confluent.kafka.zk.KafkaZkClient;
import io.confluent.kafka.zk.KafkaZkClient$;
import io.confluent.org.apache.kafka.clients.admin.AdminClient;
import io.confluent.org.apache.kafka.clients.admin.AlterConfigsOptions;
import io.confluent.org.apache.kafka.clients.admin.ConfigEntry;
import io.confluent.org.apache.kafka.clients.admin.DescribeConfigsOptions;
import io.confluent.org.apache.kafka.common.config.ConfigResource;
import io.confluent.org.apache.kafka.common.security.JaasUtils;
import io.confluent.org.apache.kafka.common.security.scram.ScramCredential;
import io.confluent.org.apache.kafka.common.security.scram.ScramCredentialUtils;
import io.confluent.org.apache.kafka.common.security.scram.ScramFormatter;
import io.confluent.org.apache.kafka.common.security.scram.ScramMechanism;
import io.confluent.org.apache.kafka.common.utils.Sanitizer;
import io.confluent.org.apache.kafka.common.utils.Time;
import io.confluent.org.apache.kafka.common.utils.Utils;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import joptsimple.OptionException;
import joptsimple.OptionSpec;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.matching.Regex;

public final class ConfigCommand$
implements Config {
    public static ConfigCommand$ MODULE$;
    private final int DefaultScramIterations;
    private final Set<String> BrokerConfigsUpdatableUsingZooKeeper;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new ConfigCommand$();
    }

    @Override
    public void validateChars(String prop, String value) {
        Config.validateChars$(this, prop, value);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        ConfigCommand$ configCommand$ = this;
        synchronized (configCommand$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int DefaultScramIterations() {
        return this.DefaultScramIterations;
    }

    public Set<String> BrokerConfigsUpdatableUsingZooKeeper() {
        return this.BrokerConfigsUpdatableUsingZooKeeper;
    }

    public void main(String[] args) {
        try {
            ConfigCommand.ConfigCommandOptions opts = new ConfigCommand.ConfigCommandOptions(args);
            if (args.length == 0) {
                throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "Add/Remove entity config for a topic, client, user or broker");
            }
            opts.checkArgs();
            if (opts.options().has(opts.zkConnectOpt())) {
                this.processCommandWithZk((String)opts.options().valueOf(opts.zkConnectOpt()), opts);
            } else {
                this.processBrokerConfig(opts);
            }
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            boolean bl = throwable2 instanceof IllegalArgumentException ? true : (throwable2 instanceof InvalidConfigException ? true : throwable2 instanceof OptionException);
            if (bl) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed config command with args '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).mkString(" ")})), throwable2);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                System.err.println(throwable2.getMessage());
                throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
            }
            if (throwable2 != null) {
                Throwable throwable3 = throwable2;
                System.err.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error while executing config command with args '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).mkString(" ")})));
                throwable3.printStackTrace(System.err);
                throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
            }
            throw throwable;
        }
    }

    private void processCommandWithZk(String zkConnectString, ConfigCommand.ConfigCommandOptions opts) {
        KafkaZkClient zkClient = KafkaZkClient$.MODULE$.apply(zkConnectString, JaasUtils.isZkSecurityEnabled(), 30000, 30000, Integer.MAX_VALUE, Time.SYSTEM, KafkaZkClient$.MODULE$.apply$default$7(), KafkaZkClient$.MODULE$.apply$default$8());
        AdminZkClient adminZkClient = new AdminZkClient(zkClient);
        try {
            if (opts.options().has((OptionSpec)opts.alterOpt())) {
                this.alterConfig(zkClient, opts, adminZkClient);
            } else if (opts.options().has((OptionSpec)opts.describeOpt())) {
                this.describeConfig(zkClient, opts, adminZkClient);
            }
        }
        finally {
            zkClient.close();
        }
    }

    public void alterConfig(KafkaZkClient zkClient, ConfigCommand.ConfigCommandOptions opts, AdminZkClient adminZkClient) {
        Properties configs;
        Seq invalidConfigs;
        Properties configsToBeAdded = this.parseConfigsToBeAdded(opts);
        Seq<String> configsToBeDeleted = this.parseConfigsToBeDeleted(opts);
        ConfigCommand.ConfigEntity entity = this.parseEntity(opts);
        String entityType = entity.root().entityType();
        String entityName = entity.fullSanitizedName();
        String string = entityType;
        String string2 = ConfigType$.MODULE$.User();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            this.preProcessScramCredentials(configsToBeAdded);
        }
        String string3 = entityType;
        String string4 = ConfigType$.MODULE$.Broker();
        if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
            Predef$.MODULE$.require(((MapLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(configsToBeAdded).asScala()).keySet().forall((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)ConfigCommand$.$anonfun$alterConfig$2(elem))), (Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--bootstrap-server option must be specified to update broker configs ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{configsToBeAdded})));
        }
        if ((invalidConfigs = (Seq)configsToBeDeleted.filterNot(arg_0 -> ConfigCommand$.$anonfun$alterConfig$3$adapted(configs = adminZkClient.fetchEntityConfig(entityType, entityName), arg_0))).nonEmpty()) {
            throw new InvalidConfigException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid config(s): ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{invalidConfigs.mkString(",")})));
        }
        Implicits$.MODULE$.PropertiesOps(configs).$plus$plus$eq(configsToBeAdded);
        configsToBeDeleted.foreach((Function1 & Serializable & scala.Serializable)x$2 -> configs.remove(x$2));
        adminZkClient.changeConfigs(entityType, entityName, configs);
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Completed Updating config for entity: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{entity})));
    }

    private void preProcessScramCredentials(Properties configsToBeAdded) {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ScramMechanism.values())).foreach((Function1 & Serializable & scala.Serializable)mechanism -> {
            String string = configsToBeAdded.getProperty(mechanism.mechanismName());
            Object object = string == null ? BoxedUnit.UNIT : configsToBeAdded.setProperty(mechanism.mechanismName(), this.scramCredential$1((ScramMechanism)((Object)mechanism), string));
            return object;
        });
    }

    /*
     * Unable to fully structure code
     */
    private void describeConfig(KafkaZkClient zkClient, ConfigCommand.ConfigCommandOptions opts, AdminZkClient adminZkClient) {
        configEntity = this.parseEntity(opts);
        v0 = configEntity.root().entityType();
        var6_5 = ConfigType$.MODULE$.User();
        if (v0 != null ? v0.equals(var6_5) == false : var6_5 != null) ** GOTO lbl-1000
        if (!configEntity.root().sanitizedName().isDefined() && !configEntity.child().isDefined()) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        describeAllUsers = v1;
        entities = configEntity.getAllEntities(zkClient);
        entities.foreach((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$describeConfig$1$adapted(io.confluent.kafka.zk.AdminZkClient boolean io.confluent.kafka.admin.ConfigCommand$ConfigEntity ), (Lio/confluent/kafka/admin/ConfigCommand$ConfigEntity;)Ljava/lang/Object;)((AdminZkClient)adminZkClient, (boolean)describeAllUsers));
    }

    /*
     * WARNING - void declaration
     */
    public Properties parseConfigsToBeAdded(ConfigCommand.ConfigCommandOptions opts) {
        void var2_2;
        block1: {
            Properties props = new Properties();
            if (!opts.options().has(opts.addConfig())) break block1;
            String pattern = "(?=[^\\]]*(?:\\[|$))";
            String[][] configsToBeAdded = (String[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((String)opts.options().valueOf(opts.addConfig())).split("," + pattern))).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.split("\\s*=\\s*" + pattern), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))));
            Predef$.MODULE$.require(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])configsToBeAdded)).forall((Function1 & Serializable & scala.Serializable)config -> BoxesRunTime.boxToBoolean((boolean)ConfigCommand$.$anonfun$parseConfigsToBeAdded$3(config))), (Function0 & Serializable & scala.Serializable)() -> "Invalid entity config: all configs to be added must be in the format \"key=val\".");
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])configsToBeAdded)).foreach((Function1 & Serializable & scala.Serializable)pair -> props.setProperty(pair[0].trim(), pair[1].replaceAll("\\[?\\]?", "").trim()));
            if (props.containsKey(LogConfig$.MODULE$.MessageFormatVersionProp())) {
                Predef$.MODULE$.println((Object)(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"WARNING: The configuration ", "=", " is specified. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{LogConfig$.MODULE$.MessageFormatVersionProp(), props.getProperty(LogConfig$.MODULE$.MessageFormatVersionProp())})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"This configuration will be ignored if the version is newer than the inter.broker.protocol.version specified in the broker."})).s((Seq)Nil$.MODULE$)));
            }
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public Seq<String> parseConfigsToBeDeleted(ConfigCommand.ConfigCommandOptions opts) {
        Seq seq;
        if (opts.options().has(opts.deleteConfig())) {
            void var2_2;
            Buffer configsToBeDeleted = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(opts.options().valuesOf(opts.deleteConfig())).asScala()).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.trim(), Buffer$.MODULE$.canBuildFrom());
            Properties propsToBeDeleted = new Properties();
            configsToBeDeleted.foreach((Function1 & Serializable & scala.Serializable)x$6 -> propsToBeDeleted.setProperty((String)x$6, ""));
            seq = var2_2;
        } else {
            seq = (Seq)Seq$.MODULE$.empty();
        }
        return seq;
    }

    private void processBrokerConfig(ConfigCommand.ConfigCommandOptions opts) {
        String string;
        Properties props = opts.options().has(opts.commandConfigOpt()) ? Utils.loadProps((String)opts.options().valueOf(opts.commandConfigOpt())) : new Properties();
        props.put("bootstrap.servers", opts.options().valueOf(opts.bootstrapServerOpt()));
        AdminClient adminClient = AdminClient.create(props);
        if (opts.options().has(opts.entityName())) {
            string = (String)opts.options().valueOf(opts.entityName());
        } else if (opts.options().has((OptionSpec)opts.entityDefault())) {
            string = "";
        } else {
            throw new IllegalArgumentException("At least one of --entity-name or --entity-default must be specified with --bootstrap-server");
        }
        String entityName = string;
        Buffer entityTypes = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(opts.options().valuesOf(opts.entityType())).asScala();
        if (entityTypes.size() != 1) {
            throw new IllegalArgumentException("Exactly one --entity-type must be specified with --bootstrap-server");
        }
        Object object = entityTypes.head();
        String string2 = ConfigType$.MODULE$.Broker();
        if (object == null ? string2 != null : !object.equals(string2)) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--zookeeper option must be specified for entity-type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{entityTypes})));
        }
        try {
            if (opts.options().has((OptionSpec)opts.alterOpt())) {
                this.alterBrokerConfig(adminClient, opts, entityName);
            } else if (opts.options().has((OptionSpec)opts.describeOpt())) {
                this.describeBrokerConfig(adminClient, opts, entityName);
            }
        }
        finally {
            adminClient.close();
        }
    }

    public void alterBrokerConfig(AdminClient adminClient, ConfigCommand.ConfigCommandOptions opts, String entityName) {
        scala.collection.mutable.Map configsToBeAdded = (scala.collection.mutable.Map)((TraversableLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(this.parseConfigsToBeAdded(opts)).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)k, (Object)new ConfigEntry(k, v));
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
        Seq<String> configsToBeDeleted = this.parseConfigsToBeDeleted(opts);
        ConfigResource configResource = new ConfigResource(ConfigResource.Type.BROKER, entityName);
        scala.collection.immutable.Map oldConfig = ((TraversableOnce)this.brokerConfig(adminClient, entityName, false).map((Function1 & Serializable & scala.Serializable)entry -> new Tuple2((Object)entry.name(), entry), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Seq invalidConfigs = (Seq)configsToBeDeleted.filterNot((Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)oldConfig.contains((Object)key)));
        if (invalidConfigs.nonEmpty()) {
            throw new InvalidConfigException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid config(s): ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{invalidConfigs.mkString(",")})));
        }
        scala.collection.immutable.Map newEntries = (scala.collection.immutable.Map)oldConfig.$plus$plus((GenTraversableOnce)configsToBeAdded).$minus$minus(configsToBeDeleted);
        scala.collection.immutable.Map sensitiveEntries = (scala.collection.immutable.Map)newEntries.filter((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)ConfigCommand$.$anonfun$alterBrokerConfig$4(x$7)));
        if (sensitiveEntries.nonEmpty()) {
            throw new InvalidConfigException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"All sensitive broker config entries must be specified for --alter, missing entries: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sensitiveEntries.keySet()})));
        }
        io.confluent.org.apache.kafka.clients.admin.Config newConfig = new io.confluent.org.apache.kafka.clients.admin.Config(((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)newEntries).asJava()).values());
        AlterConfigsOptions alterOptions = new AlterConfigsOptions().timeoutMs(Predef$.MODULE$.int2Integer(30000)).validateOnly(false);
        adminClient.alterConfigs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)configResource), (Object)newConfig)}))).asJava(), alterOptions).all().get(60L, TimeUnit.SECONDS);
        if (new StringOps(Predef$.MODULE$.augmentString(entityName)).nonEmpty()) {
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Completed updating config for broker: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{entityName})));
        } else {
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Completed updating default config for brokers in the cluster,"})).s((Seq)Nil$.MODULE$));
        }
    }

    private void describeBrokerConfig(AdminClient adminClient, ConfigCommand.ConfigCommandOptions opts, String entityName) {
        Seq<ConfigEntry> configs = this.brokerConfig(adminClient, entityName, true);
        if (new StringOps(Predef$.MODULE$.augmentString(entityName)).nonEmpty()) {
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Configs for broker ", " are:"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{entityName})));
        } else {
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Default config for brokers in the cluster are:"})).s((Seq)Nil$.MODULE$));
        }
        configs.foreach((Function1 & Serializable & scala.Serializable)config -> {
            ConfigCommand$.$anonfun$describeBrokerConfig$1(config);
            return BoxedUnit.UNIT;
        });
    }

    private Seq<ConfigEntry> brokerConfig(AdminClient adminClient, String entityName, boolean includeSynonyms) {
        ConfigResource configResource = new ConfigResource(ConfigResource.Type.BROKER, entityName);
        ConfigEntry.ConfigSource configSource = !entityName.isEmpty() ? ConfigEntry.ConfigSource.DYNAMIC_BROKER_CONFIG : ConfigEntry.ConfigSource.DYNAMIC_DEFAULT_BROKER_CONFIG;
        DescribeConfigsOptions describeOpts = new DescribeConfigsOptions().includeSynonyms(includeSynonyms);
        java.util.Map<ConfigResource, io.confluent.org.apache.kafka.clients.admin.Config> configs = adminClient.describeConfigs(Collections.singleton(configResource), describeOpts).all().get(30L, TimeUnit.SECONDS);
        return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(configs.get(configResource).entries()).asScala()).filter((Function1 & Serializable & scala.Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)ConfigCommand$.$anonfun$brokerConfig$1(configSource, entry)))).toSeq();
    }

    /*
     * Enabled aggressive block sorting
     */
    public ConfigCommand.ConfigEntity parseEntity(ConfigCommand.ConfigCommandOptions opts) {
        ConfigCommand.ConfigEntity configEntity;
        Buffer entityTypes;
        block3: {
            block2: {
                entityTypes = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(opts.options().valuesOf(opts.entityType())).asScala();
                Object object = entityTypes.head();
                String string = ConfigType$.MODULE$.User();
                if (!(object == null ? string != null : !object.equals(string))) break block2;
                Object object2 = entityTypes.head();
                String string2 = ConfigType$.MODULE$.Client();
                if (object2 != null ? !object2.equals(string2) : string2 != null) break block3;
            }
            configEntity = this.parseQuotaEntity(opts);
            return configEntity;
        }
        None$ name = opts.options().has(opts.entityName()) ? new Some(opts.options().valueOf(opts.entityName())) : None$.MODULE$;
        configEntity = new ConfigCommand.ConfigEntity(new ConfigCommand.Entity((String)entityTypes.head(), (Option<String>)name), (Option<ConfigCommand.Entity>)None$.MODULE$);
        return configEntity;
    }

    private Seq<String> entityNames(ConfigCommand.ConfigCommandOptions opts) {
        java.util.Iterator namesIterator = opts.options().valuesOf(opts.entityName()).iterator();
        return (Seq)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(opts.options().specs()).asScala()).filter((Function1 & Serializable & scala.Serializable)spec -> BoxesRunTime.boxToBoolean((boolean)ConfigCommand$.$anonfun$entityNames$1(spec)))).map((Function1 & Serializable & scala.Serializable)spec -> spec.options().contains("entity-name") ? (String)namesIterator.next() : "", Buffer$.MODULE$.canBuildFrom());
    }

    /*
     * Unable to fully structure code
     */
    private ConfigCommand.ConfigEntity parseQuotaEntity(ConfigCommand.ConfigCommandOptions opts) {
        types = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(opts.options().valuesOf(opts.entityType())).asScala();
        names = this.entityNames(opts);
        if (opts.options().has((OptionSpec)opts.alterOpt()) && names.size() != types.size()) {
            throw new IllegalArgumentException("--entity-name or --entity-default must be specified with each --entity-type for --alter");
        }
        if (types.size() != 2) ** GOTO lbl-1000
        v0 = types.apply(0);
        var5_4 = ConfigType$.MODULE$.Client();
        if (!(v0 != null ? v0.equals(var5_4) == false : var5_4 != null)) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        reverse = v1;
        entityTypes = reverse != false ? (Buffer)types.reverse() : types;
        sortedNames = ((IterableLike)(reverse != false && names.length() == 2 ? names.reverse() : names)).iterator();
        entities = (Buffer)entityTypes.map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$parseQuotaEntity$1(scala.collection.Iterator java.lang.String ), (Ljava/lang/String;)Lio/confluent/kafka/admin/ConfigCommand$Entity;)((Iterator)sortedNames), Buffer$.MODULE$.canBuildFrom());
        return new ConfigCommand.ConfigEntity((ConfigCommand.Entity)entities.head(), (Option<ConfigCommand.Entity>)(entities.size() > 1 ? new Some(entities.apply(1)) : None$.MODULE$));
    }

    public static final /* synthetic */ boolean $anonfun$alterConfig$2(String elem) {
        return MODULE$.BrokerConfigsUpdatableUsingZooKeeper().contains((Object)elem);
    }

    private final String scramCredential$1(ScramMechanism mechanism, String credentialStr) {
        String string;
        Regex pattern = new StringOps(Predef$.MODULE$.augmentString("(?:iterations=([0-9]*),)?password=(.*)")).r();
        Option option = pattern.unapplySeq((CharSequence)(string = credentialStr));
        if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(2) != 0) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid credential property ", "=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{mechanism, credentialStr})));
        }
        String iterations = (String)((LinearSeqOptimized)option.get()).apply(0);
        String password = (String)((LinearSeqOptimized)option.get()).apply(1);
        Tuple2 tuple2 = new Tuple2((Object)(iterations != null ? BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(iterations)).toInt()) : BoxesRunTime.boxToInteger((int)this.DefaultScramIterations())), (Object)password);
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        int iterations2 = tuple22._1$mcI$sp();
        String password2 = (String)tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)iterations2), (Object)password2);
        Tuple2 tuple24 = tuple23;
        int iterations3 = tuple24._1$mcI$sp();
        String password3 = (String)tuple24._2();
        if (iterations3 < mechanism.minIterations()) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Iterations ", " is less than the minimum ", " required for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)iterations3), BoxesRunTime.boxToInteger((int)mechanism.minIterations()), mechanism})));
        }
        ScramCredential credential = new ScramFormatter(mechanism).generateCredential(password3, iterations3);
        return ScramCredentialUtils.credentialToString(credential);
    }

    public static final /* synthetic */ void $anonfun$describeConfig$1(AdminZkClient adminZkClient$1, boolean describeAllUsers$1, ConfigCommand.ConfigEntity entity) {
        block0: {
            Properties configs = adminZkClient$1.fetchEntityConfig(entity.root().entityType(), entity.fullSanitizedName());
            if (configs.isEmpty() && describeAllUsers$1) break block0;
            Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Configs for %s are %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{entity, ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(configs).asScala()).map((Function1 & Serializable & scala.Serializable)kv -> (String)kv._1() + "=" + kv._2(), Iterable$.MODULE$.canBuildFrom())).mkString(",")})));
        }
    }

    public static final /* synthetic */ boolean $anonfun$parseConfigsToBeAdded$3(String[] config) {
        return config.length == 2;
    }

    public static final /* synthetic */ boolean $anonfun$alterBrokerConfig$4(Tuple2 x$7) {
        return ((ConfigEntry)x$7._2()).value() == null;
    }

    public static final /* synthetic */ void $anonfun$describeBrokerConfig$1(ConfigEntry config) {
        String synonyms = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(config.synonyms()).asScala()).map((Function1 & Serializable & scala.Serializable)synonym -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", "=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{synonym.source(), synonym.name(), synonym.value()})), Buffer$.MODULE$.canBuildFrom())).mkString(", ");
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"  ", "=", " sensitive=", " synonyms={", "}"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{config.name(), config.value(), BoxesRunTime.boxToBoolean((boolean)config.isSensitive()), synonyms})));
    }

    public static final /* synthetic */ boolean $anonfun$brokerConfig$1(ConfigEntry.ConfigSource configSource$1, ConfigEntry entry) {
        ConfigEntry.ConfigSource configSource = entry.source();
        ConfigEntry.ConfigSource configSource2 = configSource$1;
        return !(configSource != null ? !((Object)((Object)configSource)).equals((Object)configSource2) : configSource2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$entityNames$1(OptionSpec spec) {
        return spec.options().contains("entity-name") || spec.options().contains("entity-default");
    }

    private static final String sanitizeName$1(String entityType, String name) {
        String string;
        if (name.isEmpty()) {
            string = ConfigEntityName$.MODULE$.Default();
        } else {
            boolean bl;
            String string2 = entityType;
            String string3 = ConfigType$.MODULE$.User();
            String string4 = string2;
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                bl = true;
            } else {
                String string5 = ConfigType$.MODULE$.Client();
                String string6 = string2;
                bl = !(string5 != null ? !string5.equals(string6) : string6 != null);
            }
            if (!bl) {
                throw new IllegalArgumentException("Invalid entity type " + entityType);
            }
            String string7 = Sanitizer.sanitize(name);
            string = string7;
        }
        return string;
    }

    public static final /* synthetic */ ConfigCommand.Entity $anonfun$parseQuotaEntity$1(Iterator sortedNames$1, String t) {
        return new ConfigCommand.Entity(t, (Option<String>)(sortedNames$1.hasNext() ? new Some((Object)ConfigCommand$.sanitizeName$1(t, (String)sortedNames$1.next())) : None$.MODULE$));
    }

    private ConfigCommand$() {
        MODULE$ = this;
        Logging.$init$(this);
        Config.$init$(this);
        this.DefaultScramIterations = 4096;
        this.BrokerConfigsUpdatableUsingZooKeeper = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{DynamicConfig$Broker$.MODULE$.LeaderReplicationThrottledRateProp(), DynamicConfig$Broker$.MODULE$.FollowerReplicationThrottledRateProp(), DynamicConfig$Broker$.MODULE$.ReplicaAlterLogDirsIoMaxBytesPerSecondProp()}));
    }

    public static final /* synthetic */ Object $anonfun$alterConfig$3$adapted(Properties configs$1, String x$1) {
        return BoxesRunTime.boxToBoolean((boolean)configs$1.containsKey(x$1));
    }

    public static final /* synthetic */ Object $anonfun$describeConfig$1$adapted(AdminZkClient adminZkClient$1, boolean describeAllUsers$1, ConfigCommand.ConfigEntity entity) {
        ConfigCommand$.$anonfun$describeConfig$1(adminZkClient$1, describeAllUsers$1, entity);
        return BoxedUnit.UNIT;
    }
}

