/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.kafkarest.Errors;
import io.confluent.kafkarest.KafkaRestConfig;
import io.confluent.kafkarest.entities.EmbeddedFormat;
import io.confluent.rest.exceptions.RestConstraintViolationException;
import java.util.Properties;
import javax.validation.constraints.NotNull;
import org.apache.kafka.common.config.ConfigException;

public class ConsumerInstanceConfig {
    private static final EmbeddedFormat DEFAULT_FORMAT = EmbeddedFormat.BINARY;
    private String id;
    private String name;
    @NotNull
    private EmbeddedFormat format;
    private String autoOffsetReset;
    private String autoCommitEnable;
    private Integer responseMinBytes;
    private Integer requestWaitMs;

    public ConsumerInstanceConfig() {
        this(DEFAULT_FORMAT);
    }

    public ConsumerInstanceConfig(EmbeddedFormat format) {
        this(null, null, format.name(), null, null, null, null);
    }

    public ConsumerInstanceConfig(@JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="format") String format, @JsonProperty(value="auto.offset.reset") String autoOffsetReset, @JsonProperty(value="auto.commit.enable") String autoCommitEnable, @JsonProperty(value="fetch.min.bytes") Integer responseMinBytes, @JsonProperty(value="consumer.request.timeout.ms") Integer requestWaitMs) {
        this.id = id;
        this.name = name;
        if (format == null) {
            this.format = DEFAULT_FORMAT;
        } else {
            String formatCanonical = format.toUpperCase();
            for (EmbeddedFormat f : EmbeddedFormat.values()) {
                if (!f.name().equals(formatCanonical)) continue;
                this.format = f;
                break;
            }
            if (this.format == null) {
                throw new RestConstraintViolationException("Invalid format type.", 422);
            }
        }
        this.setResponseMinBytes(responseMinBytes);
        this.requestWaitMs = requestWaitMs;
        this.autoOffsetReset = autoOffsetReset;
        this.autoCommitEnable = autoCommitEnable;
    }

    public static Properties attachProxySpecificProperties(Properties props, ConsumerInstanceConfig config) {
        if (config.getResponseMinBytes() != null) {
            props.setProperty("fetch.min.bytes", config.getResponseMinBytes().toString());
        }
        if (config.getRequestWaitMs() != null) {
            props.setProperty("consumer.request.timeout.ms", config.getRequestWaitMs().toString());
        }
        return props;
    }

    @JsonProperty
    public String getId() {
        return this.id;
    }

    @JsonProperty
    public void setId(String id) {
        this.id = id;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public Integer getResponseMinBytes() {
        return this.responseMinBytes;
    }

    @JsonProperty
    public void setResponseMinBytes(Integer responseMinBytes) throws RestConstraintViolationException {
        if (responseMinBytes == null) {
            this.responseMinBytes = null;
            return;
        }
        try {
            KafkaRestConfig.PROXY_FETCH_MIN_BYTES_VALIDATOR.ensureValid("fetch.min.bytes", (Object)responseMinBytes);
            this.responseMinBytes = responseMinBytes;
        }
        catch (ConfigException e) {
            throw Errors.invalidConsumerConfigConstraintException(e);
        }
    }

    @JsonProperty
    public Integer getRequestWaitMs() {
        return this.requestWaitMs;
    }

    @JsonProperty
    public void setName(String name) {
        this.name = name;
    }

    @JsonIgnore
    public EmbeddedFormat getFormat() {
        return this.format;
    }

    @JsonProperty(value="format")
    public String getFormatJson() {
        return this.format.name().toLowerCase();
    }

    @JsonProperty
    public void setFormat(EmbeddedFormat format) {
        this.format = format;
    }

    @JsonProperty(value="auto.offset.reset")
    public String getAutoOffsetReset() {
        return this.autoOffsetReset;
    }

    @JsonProperty(value="auto.offset.reset")
    public void setAutoOffsetReset(String autoOffsetReset) {
        this.autoOffsetReset = autoOffsetReset;
    }

    @JsonProperty(value="auto.commit.enable")
    public String getAutoCommitEnable() {
        return this.autoCommitEnable;
    }

    @JsonProperty(value="auto.commit.enable")
    public void setAutoCommitEnable(String autoCommitEnable) {
        this.autoCommitEnable = autoCommitEnable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConsumerInstanceConfig that = (ConsumerInstanceConfig)o;
        if (this.autoCommitEnable != null ? !this.autoCommitEnable.equals(that.autoCommitEnable) : that.autoCommitEnable != null) {
            return false;
        }
        if (this.autoOffsetReset != null ? !this.autoOffsetReset.equals(that.autoOffsetReset) : that.autoOffsetReset != null) {
            return false;
        }
        if (this.format != that.format) {
            return false;
        }
        return !(this.id != null ? !this.id.equals(that.id) : that.id != null);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.format != null ? this.format.hashCode() : 0);
        result = 31 * result + (this.autoOffsetReset != null ? this.autoOffsetReset.hashCode() : 0);
        result = 31 * result + (this.autoCommitEnable != null ? this.autoCommitEnable.hashCode() : 0);
        return result;
    }
}

