/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.serializers.protobuf;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.Message;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.serializers.protobuf.AbstractKafkaProtobufDeserializer;
import io.confluent.kafka.serializers.protobuf.KafkaProtobufDeserializerConfig;
import java.util.Map;
import org.apache.kafka.common.serialization.Deserializer;

public class KafkaProtobufDeserializer<T extends Message>
extends AbstractKafkaProtobufDeserializer<T>
implements Deserializer<T> {
    public KafkaProtobufDeserializer() {
    }

    public KafkaProtobufDeserializer(SchemaRegistryClient client) {
        this.schemaRegistry = client;
    }

    public KafkaProtobufDeserializer(SchemaRegistryClient client, Map<String, ?> props) {
        this(client, props, null);
    }

    @VisibleForTesting
    public KafkaProtobufDeserializer(SchemaRegistryClient client, Map<String, ?> props, Class<T> type) {
        this.schemaRegistry = client;
        this.configure(this.deserializerConfig(props), type);
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        this.configure(new KafkaProtobufDeserializerConfig(configs), isKey);
    }

    protected void configure(KafkaProtobufDeserializerConfig config, boolean isKey) {
        this.isKey = isKey;
        if (isKey) {
            this.configure(config, config.getClass("specific.protobuf.key.type"));
        } else {
            this.configure(config, config.getClass("specific.protobuf.value.type"));
        }
    }

    public T deserialize(String topic, byte[] bytes) {
        return (T)((Message)this.deserialize(false, topic, this.isKey, bytes));
    }

    public void close() {
    }
}

