/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.formatter.protobuf;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import io.confluent.kafka.formatter.SchemaMessageDeserializer;
import io.confluent.kafka.formatter.SchemaMessageFormatter;
import io.confluent.kafka.schemaregistry.SchemaProvider;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchemaProvider;
import io.confluent.kafka.serializers.protobuf.AbstractKafkaProtobufDeserializer;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.Deserializer;

public class ProtobufMessageFormatter
extends SchemaMessageFormatter<Message> {
    public ProtobufMessageFormatter() {
    }

    ProtobufMessageFormatter(SchemaRegistryClient schemaRegistryClient, Deserializer keyDeserializer) {
        super(schemaRegistryClient, keyDeserializer);
    }

    protected SchemaMessageDeserializer<Message> createDeserializer(SchemaRegistryClient schemaRegistryClient, Deserializer keyDeserializer) {
        return new ProtobufMessageDeserializer(schemaRegistryClient, keyDeserializer);
    }

    protected void writeTo(byte[] data, PrintStream output) throws IOException {
        Message object = (Message)this.deserializer.deserialize(data);
        try {
            output.print(object == null ? null : JsonFormat.printer().includingDefaultValueFields().omittingInsignificantWhitespace().print((MessageOrBuilder)object));
        }
        catch (InvalidProtocolBufferException e) {
            throw new SerializationException("Error serializing Protobuf data to json", (Throwable)e);
        }
    }

    protected SchemaProvider getProvider() {
        return new ProtobufSchemaProvider();
    }

    static class ProtobufMessageDeserializer
    extends AbstractKafkaProtobufDeserializer
    implements SchemaMessageDeserializer<Message> {
        protected final Deserializer keyDeserializer;

        ProtobufMessageDeserializer(SchemaRegistryClient schemaRegistryClient, Deserializer keyDeserializer) {
            this.schemaRegistry = schemaRegistryClient;
            this.keyDeserializer = keyDeserializer;
        }

        public Deserializer getKeyDeserializer() {
            return this.keyDeserializer;
        }

        public Object deserializeKey(String topic, byte[] payload) {
            return this.keyDeserializer.deserialize(topic, payload);
        }

        public Message deserialize(byte[] payload) throws SerializationException {
            return super.deserialize(payload);
        }
    }
}

