/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.protobuf.dynamic;

import com.google.protobuf.DescriptorProtos;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchema;
import io.confluent.kafka.schemaregistry.protobuf.dynamic.DynamicSchema;
import io.confluent.kafka.schemaregistry.protobuf.dynamic.EnumDefinition;
import io.confluent.protobuf.MetaProto;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MessageDefinition {
    private DescriptorProtos.DescriptorProto mMsgType;
    private static Map<String, DescriptorProtos.FieldDescriptorProto.Type> sTypeMap = new HashMap<String, DescriptorProtos.FieldDescriptorProto.Type>();
    private static Map<String, DescriptorProtos.FieldDescriptorProto.Label> sLabelMap;

    public static Builder newBuilder(String msgTypeName) {
        return new Builder(msgTypeName);
    }

    public String toString() {
        return this.mMsgType.toString();
    }

    DescriptorProtos.DescriptorProto getMessageType() {
        return this.mMsgType;
    }

    private MessageDefinition(DescriptorProtos.DescriptorProto msgType) {
        this.mMsgType = msgType;
    }

    public static DescriptorProtos.FieldDescriptorProto.Builder getFieldBuilder(String label, boolean isProto3Optional, String type, String name, int num, String defaultVal, String jsonName, ProtobufSchema.ProtobufMeta meta, DescriptorProtos.FieldOptions.CType ctype, Boolean isPacked, DescriptorProtos.FieldOptions.JSType jstype, Boolean isDeprecated, OneofBuilder oneofBuilder) {
        DescriptorProtos.FieldOptions.Builder optionsBuilder;
        DescriptorProtos.FieldDescriptorProto.Type primType;
        DescriptorProtos.FieldDescriptorProto.Label protoLabel = sLabelMap.get(label);
        DescriptorProtos.FieldDescriptorProto.Builder fieldBuilder = DescriptorProtos.FieldDescriptorProto.newBuilder();
        if (label != null) {
            fieldBuilder.setLabel(protoLabel);
        }
        if (isProto3Optional) {
            fieldBuilder.setProto3Optional(isProto3Optional);
        }
        if ((primType = sTypeMap.get(type)) != null) {
            fieldBuilder.setType(primType);
        } else {
            fieldBuilder.setTypeName(type);
        }
        fieldBuilder.setName(name).setNumber(num);
        if (defaultVal != null) {
            fieldBuilder.setDefaultValue(defaultVal);
        }
        if (oneofBuilder != null) {
            fieldBuilder.setOneofIndex(oneofBuilder.getIdx());
        }
        if (jsonName != null) {
            fieldBuilder.setJsonName(jsonName);
        }
        if (ctype != null) {
            optionsBuilder = DescriptorProtos.FieldOptions.newBuilder();
            optionsBuilder.setCtype(ctype);
            fieldBuilder.mergeOptions(optionsBuilder.build());
        }
        if (isPacked != null) {
            optionsBuilder = DescriptorProtos.FieldOptions.newBuilder();
            optionsBuilder.setPacked(isPacked.booleanValue());
            fieldBuilder.mergeOptions(optionsBuilder.build());
        }
        if (jstype != null) {
            optionsBuilder = DescriptorProtos.FieldOptions.newBuilder();
            optionsBuilder.setJstype(jstype);
            fieldBuilder.mergeOptions(optionsBuilder.build());
        }
        if (isDeprecated != null) {
            optionsBuilder = DescriptorProtos.FieldOptions.newBuilder();
            optionsBuilder.setDeprecated(isDeprecated.booleanValue());
            fieldBuilder.mergeOptions(optionsBuilder.build());
        }
        MessageDefinition.setFieldMeta(fieldBuilder, meta);
        return fieldBuilder;
    }

    private static void setFieldMeta(DescriptorProtos.FieldDescriptorProto.Builder fieldBuilder, ProtobufSchema.ProtobufMeta meta) {
        MetaProto.Meta m = DynamicSchema.toMeta(meta);
        if (m != null) {
            DescriptorProtos.FieldOptions.Builder optionsBuilder = DescriptorProtos.FieldOptions.newBuilder();
            optionsBuilder.setExtension(MetaProto.fieldMeta, (Object)m);
            fieldBuilder.mergeOptions(optionsBuilder.build());
        }
    }

    static {
        sTypeMap.put("double", DescriptorProtos.FieldDescriptorProto.Type.TYPE_DOUBLE);
        sTypeMap.put("float", DescriptorProtos.FieldDescriptorProto.Type.TYPE_FLOAT);
        sTypeMap.put("int32", DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT32);
        sTypeMap.put("int64", DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64);
        sTypeMap.put("uint32", DescriptorProtos.FieldDescriptorProto.Type.TYPE_UINT32);
        sTypeMap.put("uint64", DescriptorProtos.FieldDescriptorProto.Type.TYPE_UINT64);
        sTypeMap.put("sint32", DescriptorProtos.FieldDescriptorProto.Type.TYPE_SINT32);
        sTypeMap.put("sint64", DescriptorProtos.FieldDescriptorProto.Type.TYPE_SINT64);
        sTypeMap.put("fixed32", DescriptorProtos.FieldDescriptorProto.Type.TYPE_FIXED32);
        sTypeMap.put("fixed64", DescriptorProtos.FieldDescriptorProto.Type.TYPE_FIXED64);
        sTypeMap.put("sfixed32", DescriptorProtos.FieldDescriptorProto.Type.TYPE_SFIXED32);
        sTypeMap.put("sfixed64", DescriptorProtos.FieldDescriptorProto.Type.TYPE_SFIXED64);
        sTypeMap.put("bool", DescriptorProtos.FieldDescriptorProto.Type.TYPE_BOOL);
        sTypeMap.put("string", DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING);
        sTypeMap.put("bytes", DescriptorProtos.FieldDescriptorProto.Type.TYPE_BYTES);
        sLabelMap = new HashMap<String, DescriptorProtos.FieldDescriptorProto.Label>();
        sLabelMap.put("optional", DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL);
        sLabelMap.put("required", DescriptorProtos.FieldDescriptorProto.Label.LABEL_REQUIRED);
        sLabelMap.put("repeated", DescriptorProtos.FieldDescriptorProto.Label.LABEL_REPEATED);
    }

    public static class OneofBuilder {
        private Builder mMsgBuilder;
        private int mIdx;

        public OneofBuilder addField(String type, String name, int num, String defaultVal, ProtobufSchema.ProtobufMeta meta) {
            return this.addField(false, type, name, num, defaultVal, null, meta, null, null, false);
        }

        public OneofBuilder addField(boolean isProto3Optional, String type, String name, int num, String defaultVal, ProtobufSchema.ProtobufMeta meta) {
            return this.addField(isProto3Optional, type, name, num, defaultVal, null, meta, null, null, false);
        }

        public OneofBuilder addField(boolean isProto3Optional, String type, String name, int num, String defaultVal, String jsonName, ProtobufSchema.ProtobufMeta meta, DescriptorProtos.FieldOptions.CType ctype, DescriptorProtos.FieldOptions.JSType jstype, Boolean deprecated) {
            this.mMsgBuilder.doAddField("optional", isProto3Optional, type, name, num, defaultVal, jsonName, meta, ctype, null, jstype, deprecated, this);
            return this;
        }

        public Builder msgDefBuilder() {
            return this.mMsgBuilder;
        }

        public int getIdx() {
            return this.mIdx;
        }

        private OneofBuilder(Builder msgBuilder, int oneofIdx) {
            this.mMsgBuilder = msgBuilder;
            this.mIdx = oneofIdx;
        }
    }

    public static class Builder {
        private DescriptorProtos.DescriptorProto.Builder mMsgTypeBuilder = DescriptorProtos.DescriptorProto.newBuilder();
        private int mOneofIndex = 0;

        public String getName() {
            return this.mMsgTypeBuilder.getName();
        }

        public Builder addField(String label, String type, String name, int num, String defaultVal, ProtobufSchema.ProtobufMeta meta) {
            return this.addField(label, type, name, num, defaultVal, null, meta, null, null, null, null);
        }

        public Builder addField(String label, String type, String name, int num, String defaultVal, String jsonName, ProtobufSchema.ProtobufMeta meta, DescriptorProtos.FieldOptions.CType ctype, Boolean isPacked, DescriptorProtos.FieldOptions.JSType jstype, Boolean isDeprecated) {
            this.doAddField(label, false, type, name, num, defaultVal, jsonName, meta, ctype, isPacked, jstype, isDeprecated, null);
            return this;
        }

        public OneofBuilder addOneof(String oneofName) {
            this.mMsgTypeBuilder.addOneofDecl(DescriptorProtos.OneofDescriptorProto.newBuilder().setName(oneofName).build());
            return new OneofBuilder(this, this.mOneofIndex++);
        }

        public boolean containsMessage(String name) {
            List messages = this.mMsgTypeBuilder.getNestedTypeList();
            for (DescriptorProtos.DescriptorProto message : messages) {
                if (!message.getName().equals(name)) continue;
                return true;
            }
            return false;
        }

        public Builder addMessageDefinition(MessageDefinition msgDef) {
            this.mMsgTypeBuilder.addNestedType(msgDef.getMessageType());
            return this;
        }

        public boolean containsEnum(String name) {
            List enums = this.mMsgTypeBuilder.getEnumTypeList();
            for (DescriptorProtos.EnumDescriptorProto enumer : enums) {
                if (!enumer.getName().equals(name)) continue;
                return true;
            }
            return false;
        }

        public Builder addEnumDefinition(EnumDefinition enumDef) {
            this.mMsgTypeBuilder.addEnumType(enumDef.getEnumType());
            return this;
        }

        public Builder addReservedName(String reservedName) {
            this.mMsgTypeBuilder.addReservedName(reservedName);
            return this;
        }

        public Builder addReservedRange(int start, int end) {
            DescriptorProtos.DescriptorProto.ReservedRange.Builder rangeBuilder = DescriptorProtos.DescriptorProto.ReservedRange.newBuilder();
            rangeBuilder.setStart(start).setEnd(end);
            this.mMsgTypeBuilder.addReservedRange(rangeBuilder.build());
            return this;
        }

        public Builder addExtensionRange(int start, int end) {
            DescriptorProtos.DescriptorProto.ExtensionRange.Builder rangeBuilder = DescriptorProtos.DescriptorProto.ExtensionRange.newBuilder();
            rangeBuilder.setStart(start).setEnd(end);
            this.mMsgTypeBuilder.addExtensionRange(rangeBuilder.build());
            return this;
        }

        public Builder addExtendDefinition(String extendee, String label, String type, String name, int num, String defaultVal, String jsonName, ProtobufSchema.ProtobufMeta meta, DescriptorProtos.FieldOptions.CType ctype, Boolean isPacked, DescriptorProtos.FieldOptions.JSType jstype, Boolean isDeprecated) {
            DescriptorProtos.FieldDescriptorProto.Builder fieldBuilder = MessageDefinition.getFieldBuilder(label, false, type, name, num, defaultVal, jsonName, meta, ctype, isPacked, jstype, isDeprecated, null);
            fieldBuilder.setExtendee(extendee);
            this.mMsgTypeBuilder.addExtension(fieldBuilder.build());
            return this;
        }

        public Builder setNoStandardDescriptorAccessor(boolean noStandardDescriptorAccessor) {
            DescriptorProtos.MessageOptions.Builder optionsBuilder = DescriptorProtos.MessageOptions.newBuilder();
            optionsBuilder.setNoStandardDescriptorAccessor(noStandardDescriptorAccessor);
            this.mMsgTypeBuilder.mergeOptions(optionsBuilder.build());
            return this;
        }

        public Builder setDeprecated(boolean isDeprecated) {
            DescriptorProtos.MessageOptions.Builder optionsBuilder = DescriptorProtos.MessageOptions.newBuilder();
            optionsBuilder.setDeprecated(isDeprecated);
            this.mMsgTypeBuilder.mergeOptions(optionsBuilder.build());
            return this;
        }

        public Builder setMapEntry(boolean mapEntry) {
            DescriptorProtos.MessageOptions.Builder optionsBuilder = DescriptorProtos.MessageOptions.newBuilder();
            optionsBuilder.setMapEntry(mapEntry);
            this.mMsgTypeBuilder.mergeOptions(optionsBuilder.build());
            return this;
        }

        public Builder setMeta(ProtobufSchema.ProtobufMeta meta) {
            MetaProto.Meta m = DynamicSchema.toMeta(meta);
            if (m != null) {
                DescriptorProtos.MessageOptions.Builder optionsBuilder = DescriptorProtos.MessageOptions.newBuilder();
                optionsBuilder.setExtension(MetaProto.messageMeta, (Object)m);
                this.mMsgTypeBuilder.mergeOptions(optionsBuilder.build());
            }
            return this;
        }

        public MessageDefinition build() {
            return new MessageDefinition(this.mMsgTypeBuilder.build());
        }

        private Builder(String msgTypeName) {
            this.mMsgTypeBuilder.setName(msgTypeName);
        }

        private void doAddField(String label, boolean isProto3Optional, String type, String name, int num, String defaultVal, String jsonName, ProtobufSchema.ProtobufMeta meta, DescriptorProtos.FieldOptions.CType ctype, Boolean isPacked, DescriptorProtos.FieldOptions.JSType jstype, Boolean isDeprecated, OneofBuilder oneofBuilder) {
            DescriptorProtos.FieldDescriptorProto.Builder fieldBuilder = MessageDefinition.getFieldBuilder(label, isProto3Optional, type, name, num, defaultVal, jsonName, meta, ctype, isPacked, jstype, isDeprecated, oneofBuilder);
            this.mMsgTypeBuilder.addField(fieldBuilder.build());
        }
    }
}

