/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.protobuf;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import com.squareup.wire.Syntax;
import com.squareup.wire.schema.Field;
import com.squareup.wire.schema.ProtoType;
import com.squareup.wire.schema.internal.parser.EnumConstantElement;
import com.squareup.wire.schema.internal.parser.EnumElement;
import com.squareup.wire.schema.internal.parser.ExtendElement;
import com.squareup.wire.schema.internal.parser.ExtensionsElement;
import com.squareup.wire.schema.internal.parser.FieldElement;
import com.squareup.wire.schema.internal.parser.GroupElement;
import com.squareup.wire.schema.internal.parser.MessageElement;
import com.squareup.wire.schema.internal.parser.OneOfElement;
import com.squareup.wire.schema.internal.parser.OptionElement;
import com.squareup.wire.schema.internal.parser.ProtoFileElement;
import com.squareup.wire.schema.internal.parser.ReservedElement;
import com.squareup.wire.schema.internal.parser.RpcElement;
import com.squareup.wire.schema.internal.parser.ServiceElement;
import com.squareup.wire.schema.internal.parser.TypeElement;
import io.confluent.kafka.schemaregistry.protobuf.ProtoFileElementDeserializer;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchema;
import io.confluent.kafka.schemaregistry.protobuf.diff.Context;
import io.confluent.kafka.schemaregistry.utils.JacksonMapper;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.Pair;
import kotlin.ranges.IntRange;
import org.apache.commons.lang3.math.NumberUtils;

public class ProtobufSchemaUtils {
    private static final ObjectMapper jsonMapper = JacksonMapper.INSTANCE;
    private static final ObjectMapper mapperWithProtoFileDeserializer = new ObjectMapper();
    private static final SimpleModule module = new SimpleModule();

    public static ProtobufSchema copyOf(ProtobufSchema schema) {
        return schema.copy();
    }

    public static ProtobufSchema getSchema(Message message) {
        return message != null ? new ProtobufSchema(message.getDescriptorForType()) : null;
    }

    public static Object toObject(JsonNode value, ProtobufSchema schema) throws IOException {
        StringWriter out = new StringWriter();
        jsonMapper.writeValue((Writer)out, (Object)value);
        return ProtobufSchemaUtils.toObject(out.toString(), schema);
    }

    public static Object toObject(String value, ProtobufSchema schema) throws InvalidProtocolBufferException {
        DynamicMessage.Builder message = schema.newMessageBuilder();
        JsonFormat.parser().merge(value, (Message.Builder)message);
        return message.build();
    }

    public static byte[] toJson(Message message) throws IOException {
        if (message == null) {
            return null;
        }
        String jsonString = JsonFormat.printer().includingDefaultValueFields().omittingInsignificantWhitespace().print((MessageOrBuilder)message);
        return jsonString.getBytes(StandardCharsets.UTF_8);
    }

    public static ProtoFileElement jsonToFile(JsonNode node) throws JsonProcessingException {
        return (ProtoFileElement)mapperWithProtoFileDeserializer.convertValue((Object)node, ProtoFileElement.class);
    }

    public static JsonNode findMatchingNodeHelper(JsonNode node, String arrayField, String targetFieldName, String targetFieldValue) {
        Iterator iter = node.get(arrayField).elements();
        while (iter.hasNext()) {
            JsonNode currNode = (JsonNode)iter.next();
            if (!targetFieldValue.equals(currNode.get(targetFieldName).asText())) continue;
            return currNode;
        }
        return null;
    }

    public static JsonNode findMatchingNode(JsonNode node, String[] identifiers, int lastIndex) {
        int idx;
        JsonNode nodePtr = node;
        for (idx = 1; idx < lastIndex; ++idx) {
            String targetName = identifiers[idx];
            JsonNode found = idx == 1 ? ProtobufSchemaUtils.findMatchingNodeHelper(nodePtr, "types", "name", targetName) : ProtobufSchemaUtils.findMatchingNodeHelper(nodePtr, "nestedTypes", "name", targetName);
            if (found == null) {
                if (idx != 1 && idx == lastIndex - 1) break;
                throw new IllegalArgumentException(String.format("No matching field 'name' with value '%s' found in the schema", targetName));
            }
            nodePtr = found;
        }
        if (idx == lastIndex - 1) {
            nodePtr = ProtobufSchemaUtils.findMatchingNodeHelper(nodePtr, "oneOfs", "name", identifiers[idx]);
        }
        if (lastIndex < identifiers.length) {
            nodePtr = ProtobufSchemaUtils.findMatchingNodeHelper(nodePtr, "fields", "name", identifiers[identifiers.length - 1]);
        }
        return nodePtr;
    }

    public static MessageElement findMatchingMessage(List<TypeElement> typeElementList, String name) {
        for (TypeElement typeElement : typeElementList) {
            if (!(typeElement instanceof MessageElement) || !name.equals(typeElement.getName())) continue;
            return (MessageElement)typeElement;
        }
        return null;
    }

    public static FieldElement findMatchingFieldElement(MessageElement messageElement, String[] identifiers) {
        String fieldName = identifiers[identifiers.length - 1];
        for (FieldElement fieldElement : messageElement.getFields()) {
            if (!fieldName.equals(fieldElement.getName())) continue;
            return fieldElement;
        }
        if (identifiers.length > 3) {
            String oneOfFieldName = identifiers[identifiers.length - 2];
            OneOfElement foundOneOfElement = null;
            for (OneOfElement oneOfElement : messageElement.getOneOfs()) {
                if (!oneOfFieldName.equals(oneOfElement.getName())) continue;
                foundOneOfElement = oneOfElement;
            }
            if (foundOneOfElement != null) {
                for (FieldElement fieldElement : foundOneOfElement.getFields()) {
                    if (!fieldName.equals(fieldElement.getName())) continue;
                    return fieldElement;
                }
            }
        }
        throw new IllegalArgumentException(String.format("No matching Field with name '%s' found in the schema", fieldName));
    }

    public static MessageElement findMatchingMessageElement(ProtoFileElement original, String[] identifiers, int lastIndex) {
        MessageElement messageElement = null;
        for (int i = 1; i < lastIndex; ++i) {
            String targetName = identifiers[i];
            MessageElement found = i == 1 ? ProtobufSchemaUtils.findMatchingMessage(original.getTypes(), targetName) : ProtobufSchemaUtils.findMatchingMessage(messageElement.getNestedTypes(), targetName);
            if (found != null) {
                messageElement = found;
                continue;
            }
            if (i != 1 && i == lastIndex - 1) continue;
            throw new IllegalArgumentException(String.format("No matching Message with name '%s' found in the schema", targetName));
        }
        return messageElement;
    }

    protected static String toNormalizedString(ProtobufSchema schema) {
        FormatContext ctx = new FormatContext(false, true);
        return ProtobufSchemaUtils.toFormattedString(ctx, schema);
    }

    protected static String toFormattedString(FormatContext ctx, ProtobufSchema schema) {
        if (ctx.normalize()) {
            ctx.collectTypeInfo(schema, true);
        }
        return ProtobufSchemaUtils.toString(ctx, schema.rawSchema());
    }

    protected static String toString(ProtoFileElement protoFile) {
        FormatContext ctx = new FormatContext(false, false);
        return ProtobufSchemaUtils.toString(ctx, protoFile);
    }

    /*
     * WARNING - void declaration
     */
    private static String toString(FormatContext ctx, ProtoFileElement protoFile) {
        List<TypeElement> types;
        List<OptionElement> options;
        StringBuilder sb = new StringBuilder();
        if (!(protoFile.getSyntax() == null || ctx.normalize() && protoFile.getSyntax() != Syntax.PROTO_3)) {
            sb.append("syntax = \"");
            sb.append(protoFile.getSyntax());
            sb.append("\";\n");
        }
        if (protoFile.getPackageName() != null) {
            sb.append("package ");
            sb.append(protoFile.getPackageName());
            sb.append(";\n");
        }
        if (!protoFile.getImports().isEmpty() || !protoFile.getPublicImports().isEmpty()) {
            sb.append('\n');
            List imports = protoFile.getImports();
            if (ctx.normalize()) {
                imports = imports.stream().sorted().distinct().collect(Collectors.toList());
            }
            for (String string : imports) {
                sb.append("import \"");
                sb.append(string);
                sb.append("\";\n");
            }
            List publicImports = protoFile.getPublicImports();
            if (ctx.normalize()) {
                publicImports = publicImports.stream().sorted().distinct().collect(Collectors.toList());
            }
            for (String string : publicImports) {
                sb.append("import public \"");
                sb.append(string);
                sb.append("\";\n");
            }
        }
        if (!(options = ctx.filterOptions(protoFile.getOptions())).isEmpty()) {
            sb.append('\n');
            for (OptionElement optionElement : options) {
                sb.append(ProtobufSchemaUtils.toOptionString(ctx, optionElement));
            }
        }
        if (!(types = ProtobufSchemaUtils.filterTypes(ctx, protoFile.getTypes())).isEmpty()) {
            Throwable throwable;
            Context.NamedScope nameScope;
            sb.append('\n');
            for (TypeElement typeElement : types) {
                if (!(typeElement instanceof MessageElement)) continue;
                nameScope = ctx.enterName(typeElement.getName());
                throwable = null;
                try {
                    sb.append(ProtobufSchemaUtils.toString(ctx, (MessageElement)typeElement));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (nameScope == null) continue;
                    if (throwable != null) {
                        try {
                            nameScope.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    nameScope.close();
                }
            }
            for (TypeElement typeElement : types) {
                if (!(typeElement instanceof EnumElement)) continue;
                nameScope = ctx.enterName(typeElement.getName());
                throwable = null;
                try {
                    sb.append(ProtobufSchemaUtils.toString(ctx, (EnumElement)typeElement));
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (nameScope == null) continue;
                    if (throwable != null) {
                        try {
                            nameScope.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                        continue;
                    }
                    nameScope.close();
                }
            }
        }
        if (!ctx.ignoreExtensions() && !protoFile.getExtendDeclarations().isEmpty()) {
            void var5_14;
            sb.append('\n');
            List list = protoFile.getExtendDeclarations();
            if (ctx.normalize()) {
                List list2 = list.stream().flatMap(e -> e.getFields().stream().map(f -> new Pair((Object)ProtobufSchemaUtils.resolve(ctx, e.getName()), f))).collect(Collectors.groupingBy(Pair::getFirst, LinkedHashMap::new, Collectors.mapping(Pair::getSecond, Collectors.toList()))).entrySet().stream().map(e -> new ExtendElement(ProtobufSchema.DEFAULT_LOCATION, (String)e.getKey(), "", (List)e.getValue())).collect(Collectors.toList());
            }
            for (ExtendElement extendElem : var5_14) {
                sb.append(ProtobufSchemaUtils.toString(ctx, extendElem));
            }
        }
        if (!protoFile.getServices().isEmpty()) {
            sb.append('\n');
            for (ServiceElement serviceElement : protoFile.getServices()) {
                sb.append(ProtobufSchemaUtils.toString(ctx, serviceElement));
            }
        }
        return sb.toString();
    }

    private static String toString(FormatContext ctx, ServiceElement service) {
        StringBuilder sb = new StringBuilder();
        sb.append("service ");
        sb.append(service.getName());
        sb.append(" {");
        List<OptionElement> options = ctx.filterOptions(service.getOptions());
        if (!options.isEmpty()) {
            sb.append('\n');
            for (OptionElement option : options) {
                ProtobufSchemaUtils.appendIndented(sb, ProtobufSchemaUtils.toOptionString(ctx, option));
            }
        }
        if (!service.getRpcs().isEmpty()) {
            sb.append('\n');
            for (RpcElement rpc : service.getRpcs()) {
                ProtobufSchemaUtils.appendIndented(sb, ProtobufSchemaUtils.toString(ctx, rpc));
            }
        }
        sb.append("}\n");
        return sb.toString();
    }

    private static String toString(FormatContext ctx, RpcElement rpc) {
        StringBuilder sb = new StringBuilder();
        sb.append("rpc ");
        sb.append(rpc.getName());
        sb.append(" (");
        if (rpc.getRequestStreaming()) {
            sb.append("stream ");
        }
        String requestType = rpc.getRequestType();
        if (ctx.normalize()) {
            requestType = ProtobufSchemaUtils.resolve(ctx, requestType);
        }
        sb.append(requestType);
        sb.append(") returns (");
        if (rpc.getResponseStreaming()) {
            sb.append("stream ");
        }
        String responseType = rpc.getResponseType();
        if (ctx.normalize()) {
            responseType = ProtobufSchemaUtils.resolve(ctx, responseType);
        }
        sb.append(responseType);
        sb.append(")");
        List<OptionElement> options = ctx.filterOptions(rpc.getOptions());
        if (!options.isEmpty()) {
            sb.append(" {\n");
            for (OptionElement option : options) {
                ProtobufSchemaUtils.appendIndented(sb, ProtobufSchemaUtils.toOptionString(ctx, option));
            }
            sb.append('}');
        }
        sb.append(";\n");
        return sb.toString();
    }

    private static String toString(FormatContext ctx, EnumElement type) {
        List<OptionElement> options;
        StringBuilder sb = new StringBuilder();
        sb.append("enum ");
        sb.append(type.getName());
        sb.append(" {");
        if (!type.getReserveds().isEmpty()) {
            sb.append('\n');
            List reserveds = type.getReserveds();
            if (ctx.normalize()) {
                reserveds = reserveds.stream().flatMap(r -> r.getValues().stream().map(o -> new ReservedElement(r.getLocation(), r.getDocumentation(), Collections.singletonList(o)))).collect(Collectors.toList());
                Comparator<Object> cmp = Comparator.comparing(r -> {
                    Object o = ((ReservedElement)r).getValues().get(0);
                    if (o instanceof IntRange) {
                        return ((IntRange)o).getStart();
                    }
                    if (o instanceof Integer) {
                        return (Integer)o;
                    }
                    return Integer.MAX_VALUE;
                }).thenComparing(r -> ((ReservedElement)r).getValues().get(0).toString());
                reserveds.sort(cmp);
            }
            for (ReservedElement reserved : reserveds) {
                ProtobufSchemaUtils.appendIndented(sb, ProtobufSchemaUtils.toString(ctx, reserved));
            }
        }
        if (!(!type.getReserveds().isEmpty() || type.getOptions().isEmpty() && type.getConstants().isEmpty())) {
            sb.append('\n');
        }
        if (!(options = ctx.filterOptions(type.getOptions())).isEmpty()) {
            for (OptionElement option : options) {
                ProtobufSchemaUtils.appendIndented(sb, ProtobufSchemaUtils.toOptionString(ctx, option));
            }
        }
        if (!type.getConstants().isEmpty()) {
            ArrayList<EnumConstantElement> constants = type.getConstants();
            if (ctx.normalize()) {
                constants = new ArrayList<EnumConstantElement>(constants);
                constants.sort(Comparator.comparing(EnumConstantElement::getTag).thenComparing(EnumConstantElement::getName));
            }
            for (EnumConstantElement constant : constants) {
                ProtobufSchemaUtils.appendIndented(sb, ProtobufSchemaUtils.toString(ctx, constant));
            }
        }
        sb.append("}\n");
        return sb.toString();
    }

    private static String toString(FormatContext ctx, EnumConstantElement type) {
        StringBuilder sb = new StringBuilder();
        sb.append(type.getName());
        sb.append(" = ");
        sb.append(type.getTag());
        List<OptionElement> options = ctx.filterOptions(type.getOptions());
        if (!options.isEmpty()) {
            sb.append(" ");
            ProtobufSchemaUtils.appendOptions(ctx, sb, options);
        }
        sb.append(";\n");
        return sb.toString();
    }

    private static String toString(FormatContext ctx, MessageElement type) {
        List<TypeElement> types;
        List<OptionElement> options;
        StringBuilder sb = new StringBuilder();
        sb.append("message ");
        sb.append(type.getName());
        sb.append(" {");
        if (!type.getReserveds().isEmpty()) {
            sb.append('\n');
            List reserveds = type.getReserveds();
            if (ctx.normalize()) {
                reserveds = reserveds.stream().flatMap(r -> r.getValues().stream().map(o -> new ReservedElement(r.getLocation(), r.getDocumentation(), Collections.singletonList(o)))).collect(Collectors.toList());
                Comparator<Object> cmp = Comparator.comparing(r -> {
                    Object o = ((ReservedElement)r).getValues().get(0);
                    if (o instanceof IntRange) {
                        return ((IntRange)o).getStart();
                    }
                    if (o instanceof Integer) {
                        return (Integer)o;
                    }
                    return Integer.MAX_VALUE;
                }).thenComparing(r -> ((ReservedElement)r).getValues().get(0).toString());
                reserveds.sort(cmp);
            }
            for (ReservedElement reservedElement : reserveds) {
                ProtobufSchemaUtils.appendIndented(sb, ProtobufSchemaUtils.toString(ctx, reservedElement));
            }
        }
        if (!(options = ctx.filterOptions(type.getOptions())).isEmpty()) {
            sb.append('\n');
            for (OptionElement optionElement : options) {
                ProtobufSchemaUtils.appendIndented(sb, ProtobufSchemaUtils.toOptionString(ctx, optionElement));
            }
        }
        if (!type.getFields().isEmpty()) {
            sb.append('\n');
            ArrayList<FieldElement> fields = type.getFields();
            if (ctx.normalize()) {
                fields = new ArrayList<FieldElement>(fields);
                fields.sort(Comparator.comparing(FieldElement::getTag));
            }
            for (FieldElement field : fields) {
                ProtobufSchemaUtils.appendIndented(sb, ProtobufSchemaUtils.toString(ctx, field));
            }
        }
        if (!type.getOneOfs().isEmpty()) {
            sb.append('\n');
            List oneOfs = type.getOneOfs();
            if (ctx.normalize()) {
                oneOfs = oneOfs.stream().filter(o -> !o.getFields().isEmpty()).map(o -> {
                    ArrayList<FieldElement> fields = new ArrayList<FieldElement>(o.getFields());
                    fields.sort(Comparator.comparing(FieldElement::getTag));
                    return new OneOfElement(o.getName(), o.getDocumentation(), fields, o.getGroups(), o.getOptions());
                }).collect(Collectors.toList());
                oneOfs.sort(Comparator.comparing(o -> ((FieldElement)o.getFields().get(0)).getTag()));
            }
            for (OneOfElement oneOf : oneOfs) {
                ProtobufSchemaUtils.appendIndented(sb, ProtobufSchemaUtils.toString(ctx, oneOf));
            }
        }
        if (!type.getGroups().isEmpty()) {
            sb.append('\n');
            ArrayList<GroupElement> groups = type.getGroups();
            if (ctx.normalize()) {
                groups = new ArrayList<GroupElement>(groups);
                groups.sort(Comparator.comparing(GroupElement::getTag));
            }
            for (GroupElement group : groups) {
                ProtobufSchemaUtils.appendIndented(sb, ProtobufSchemaUtils.toString(ctx, group));
            }
        }
        if (!ctx.ignoreExtensions() && !type.getExtensions().isEmpty()) {
            sb.append('\n');
            List extensions = type.getExtensions();
            if (ctx.normalize()) {
                extensions = extensions.stream().flatMap(r -> r.getValues().stream().map(o -> new ExtensionsElement(r.getLocation(), r.getDocumentation(), Collections.singletonList(o)))).collect(Collectors.toList());
                Comparator<Object> comparator = Comparator.comparing(r -> {
                    Object o = ((ExtensionsElement)r).getValues().get(0);
                    if (o instanceof IntRange) {
                        return ((IntRange)o).getStart();
                    }
                    if (o instanceof Integer) {
                        return (Integer)o;
                    }
                    return Integer.MAX_VALUE;
                });
                extensions.sort(comparator);
            }
            for (ExtensionsElement extension : extensions) {
                ProtobufSchemaUtils.appendIndented(sb, ProtobufSchemaUtils.toString(ctx, extension));
            }
        }
        if (!ctx.ignoreExtensions() && !type.getExtendDeclarations().isEmpty()) {
            sb.append('\n');
            List extendElems = type.getExtendDeclarations();
            if (ctx.normalize()) {
                extendElems = extendElems.stream().flatMap(e -> e.getFields().stream().map(f -> new Pair((Object)ProtobufSchemaUtils.resolve(ctx, e.getName()), f))).collect(Collectors.groupingBy(Pair::getFirst, LinkedHashMap::new, Collectors.mapping(Pair::getSecond, Collectors.toList()))).entrySet().stream().map(e -> new ExtendElement(ProtobufSchema.DEFAULT_LOCATION, (String)e.getKey(), "", (List)e.getValue())).collect(Collectors.toList());
            }
            for (ExtendElement extendElem : extendElems) {
                ProtobufSchemaUtils.appendIndented(sb, ProtobufSchemaUtils.toString(ctx, extendElem));
            }
        }
        if (!(types = ProtobufSchemaUtils.filterTypes(ctx, type.getNestedTypes())).isEmpty()) {
            Throwable throwable;
            Context.NamedScope nameScope;
            sb.append('\n');
            for (TypeElement typeElement : types) {
                if (!(typeElement instanceof MessageElement)) continue;
                nameScope = ctx.enterName(typeElement.getName());
                throwable = null;
                try {
                    ProtobufSchemaUtils.appendIndented(sb, ProtobufSchemaUtils.toString(ctx, (MessageElement)typeElement));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (nameScope == null) continue;
                    if (throwable != null) {
                        try {
                            nameScope.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    nameScope.close();
                }
            }
            for (TypeElement typeElement : types) {
                if (!(typeElement instanceof EnumElement)) continue;
                nameScope = ctx.enterName(typeElement.getName());
                throwable = null;
                try {
                    ProtobufSchemaUtils.appendIndented(sb, ProtobufSchemaUtils.toString(ctx, (EnumElement)typeElement));
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (nameScope == null) continue;
                    if (throwable != null) {
                        try {
                            nameScope.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                        continue;
                    }
                    nameScope.close();
                }
            }
        }
        sb.append("}\n");
        return sb.toString();
    }

    private static String toString(FormatContext ctx, ReservedElement type) {
        StringBuilder sb = new StringBuilder();
        sb.append("reserved ");
        boolean first = true;
        for (Object value : type.getValues()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            if (value instanceof String) {
                sb.append("\"");
                sb.append(value);
                sb.append("\"");
                continue;
            }
            if (value instanceof Integer) {
                sb.append(value);
                continue;
            }
            if (value instanceof IntRange) {
                IntRange range = (IntRange)value;
                if (ctx.normalize() && range.getStart().equals(range.getEndInclusive())) {
                    sb.append(range.getStart());
                    continue;
                }
                sb.append(range.getStart());
                sb.append(" to ");
                int last = range.getEndInclusive();
                if (last < 0x1FFFFFFF) {
                    sb.append(last);
                    continue;
                }
                sb.append("max");
                continue;
            }
            throw new IllegalArgumentException();
        }
        sb.append(";\n");
        return sb.toString();
    }

    private static String toString(FormatContext ctx, ExtensionsElement type) {
        StringBuilder sb = new StringBuilder();
        sb.append("extensions ");
        boolean first = true;
        for (Object value : type.getValues()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            if (value instanceof Integer) {
                sb.append(value);
                continue;
            }
            if (value instanceof IntRange) {
                IntRange range = (IntRange)value;
                if (ctx.normalize() && range.getStart().equals(range.getEndInclusive())) {
                    sb.append(range.getStart());
                    continue;
                }
                sb.append(range.getStart());
                sb.append(" to ");
                int last = range.getEndInclusive();
                if (last < 0x1FFFFFFF) {
                    sb.append(last);
                    continue;
                }
                sb.append("max");
                continue;
            }
            throw new IllegalArgumentException();
        }
        sb.append(";\n");
        return sb.toString();
    }

    private static String toString(FormatContext ctx, OneOfElement type) {
        StringBuilder sb = new StringBuilder();
        sb.append("oneof ");
        sb.append(type.getName());
        sb.append(" {");
        List<OptionElement> options = ctx.filterOptions(type.getOptions());
        if (!options.isEmpty()) {
            sb.append('\n');
            for (OptionElement option : options) {
                ProtobufSchemaUtils.appendIndented(sb, ProtobufSchemaUtils.toOptionString(ctx, option));
            }
        }
        if (!type.getFields().isEmpty()) {
            sb.append('\n');
            List fields = type.getFields();
            for (FieldElement field : fields) {
                ProtobufSchemaUtils.appendIndented(sb, ProtobufSchemaUtils.toString(ctx, field));
            }
        }
        if (!type.getGroups().isEmpty()) {
            sb.append('\n');
            ArrayList<GroupElement> groups = type.getGroups();
            if (ctx.normalize()) {
                groups = new ArrayList<GroupElement>(groups);
                groups.sort(Comparator.comparing(GroupElement::getTag));
            }
            for (GroupElement group : groups) {
                ProtobufSchemaUtils.appendIndented(sb, ProtobufSchemaUtils.toString(ctx, group));
            }
        }
        sb.append("}\n");
        return sb.toString();
    }

    private static String toString(FormatContext ctx, GroupElement group) {
        StringBuilder sb = new StringBuilder();
        Field.Label label = group.getLabel();
        if (label != null) {
            sb.append(label.name().toLowerCase(Locale.US));
            sb.append(" ");
        }
        sb.append("group ");
        sb.append(group.getName());
        sb.append(" = ");
        sb.append(group.getTag());
        sb.append(" {");
        if (!group.getFields().isEmpty()) {
            sb.append('\n');
            ArrayList<FieldElement> fields = group.getFields();
            if (ctx.normalize()) {
                fields = new ArrayList<FieldElement>(fields);
                fields.sort(Comparator.comparing(FieldElement::getTag));
            }
            for (FieldElement field : fields) {
                ProtobufSchemaUtils.appendIndented(sb, ProtobufSchemaUtils.toString(ctx, field));
            }
        }
        sb.append("}\n");
        return sb.toString();
    }

    private static String toString(FormatContext ctx, ExtendElement extendElem) {
        StringBuilder sb = new StringBuilder();
        sb.append("extend ");
        String extendName = extendElem.getName();
        sb.append(extendName);
        sb.append(" {");
        if (!extendElem.getFields().isEmpty()) {
            sb.append('\n');
            ArrayList<FieldElement> fields = extendElem.getFields();
            if (ctx.normalize()) {
                fields = new ArrayList<FieldElement>(fields);
                fields.sort(Comparator.comparing(FieldElement::getTag));
            }
            for (FieldElement field : fields) {
                ProtobufSchemaUtils.appendIndented(sb, ProtobufSchemaUtils.toString(ctx, field));
            }
        }
        sb.append("}\n");
        return sb.toString();
    }

    private static String toString(FormatContext ctx, FieldElement field) {
        String jsonName;
        StringBuilder sb = new StringBuilder();
        Field.Label label = field.getLabel();
        String fieldType = field.getType();
        ProtoType fieldProtoType = ProtoType.get((String)fieldType);
        if (ctx.normalize()) {
            if (!fieldProtoType.isScalar() && !fieldProtoType.isMap()) {
                Context.TypeElementInfo typeInfo = ctx.getTypeForFullName(fieldType = ProtobufSchemaUtils.resolve(ctx, fieldType), true);
                fieldProtoType = typeInfo != null && typeInfo.isMap() ? typeInfo.getMapType() : ProtoType.get((String)fieldType);
            }
            ProtoType mapValueType = fieldProtoType.getValueType();
            if (fieldProtoType.isMap() && mapValueType != null) {
                String valueType = ctx.resolve(mapValueType.toString(), true);
                if (valueType != null) {
                    fieldProtoType = ProtoType.get((String)("map<" + fieldProtoType.getKeyType() + ", ." + valueType + ">"));
                }
                label = null;
            }
            fieldType = fieldProtoType.toString();
        }
        if (label != null) {
            sb.append(label.name().toLowerCase(Locale.US));
            sb.append(" ");
        }
        sb.append(fieldType);
        sb.append(" ");
        sb.append(field.getName());
        sb.append(" = ");
        sb.append(field.getTag());
        List<OptionElement> optionsWithSpecialValues = new ArrayList<OptionElement>(field.getOptions());
        String defaultValue = field.getDefaultValue();
        if (defaultValue != null) {
            optionsWithSpecialValues.add(OptionElement.Companion.create("default", ProtobufSchemaUtils.toKind(fieldProtoType), (Object)defaultValue));
        }
        if ((jsonName = field.getJsonName()) != null) {
            optionsWithSpecialValues.add(OptionElement.Companion.create("json_name", OptionElement.Kind.STRING, (Object)jsonName));
        }
        if (!(optionsWithSpecialValues = ctx.filterOptions(optionsWithSpecialValues)).isEmpty()) {
            sb.append(" ");
            ProtobufSchemaUtils.appendOptions(ctx, sb, optionsWithSpecialValues);
        }
        sb.append(";\n");
        return sb.toString();
    }

    private static String toString(FormatContext ctx, OptionElement option) {
        StringBuilder sb = new StringBuilder();
        String name = option.getName();
        if (option.isParenthesized()) {
            sb.append("(").append(name).append(")");
        } else {
            sb.append(name);
        }
        Object value = option.getValue();
        switch (option.getKind()) {
            case STRING: {
                sb.append(" = \"");
                sb.append(ProtobufSchemaUtils.escapeChars(value.toString()));
                sb.append("\"");
                break;
            }
            case BOOLEAN: 
            case ENUM: {
                sb.append(" = ");
                sb.append(value);
                break;
            }
            case NUMBER: {
                sb.append(" = ");
                sb.append(ProtobufSchemaUtils.formatNumber(ctx, value));
                break;
            }
            case OPTION: {
                sb.append(".");
                sb.append(ProtobufSchemaUtils.toString(ctx, (OptionElement)value));
                break;
            }
            case MAP: {
                sb.append(" = {\n");
                ProtobufSchemaUtils.formatOptionMap(ctx, sb, (Map)value);
                sb.append('}');
                break;
            }
            case LIST: {
                sb.append(" = ");
                ProtobufSchemaUtils.appendOptions(ctx, sb, (List)value);
                break;
            }
        }
        return sb.toString();
    }

    private static List<TypeElement> filterTypes(FormatContext ctx, List<TypeElement> types) {
        if (ctx.normalize()) {
            return types.stream().filter(type -> {
                if (type instanceof MessageElement) {
                    Context.TypeElementInfo typeInfo = ctx.getType(type.getName(), true);
                    return typeInfo == null || !typeInfo.isMap();
                }
                return true;
            }).collect(Collectors.toList());
        }
        return types;
    }

    private static void formatOptionMap(FormatContext ctx, StringBuilder sb, Map<String, Object> valueMap) {
        if (ctx.normalize()) {
            valueMap = valueMap.entrySet().stream().filter(e -> {
                Object value = e.getValue();
                return !(value instanceof List) || !((List)value).isEmpty();
            }).map(e -> {
                String key = (String)e.getKey();
                Object value = e.getValue();
                if (key.startsWith("[") && key.endsWith("]")) {
                    String fieldName = key.substring(1, key.length() - 1);
                    String resolved = ctx.resolve(ctx::getExtendFieldForFullName, fieldName, true);
                    if (resolved != null) {
                        return new Pair((Object)("[" + resolved + "]"), value);
                    }
                }
                return new Pair((Object)key, value);
            }).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond, (e1, e2) -> e1, TreeMap::new));
        }
        int lastIndex = valueMap.size() - 1;
        int index = 0;
        for (Map.Entry<String, Object> entry : valueMap.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            String endl = index != lastIndex ? "," : "";
            String kv = key + ": " + ProtobufSchemaUtils.formatOptionMapOrListValue(ctx, value) + endl;
            ProtobufSchemaUtils.appendIndented(sb, kv);
            ++index;
        }
    }

    private static String formatOptionMapOrListValue(FormatContext ctx, Object value) {
        StringBuilder sb = new StringBuilder();
        if (value instanceof String) {
            sb.append("\"");
            sb.append(ProtobufSchemaUtils.escapeChars(value.toString()));
            sb.append("\"");
        } else if (value instanceof Map) {
            sb.append("{\n");
            ProtobufSchemaUtils.formatOptionMap(ctx, sb, (Map)value);
            sb.append('}');
        } else if (value instanceof List) {
            List list = (List)value;
            if (ctx.normalize() && list.size() == 1) {
                sb.append(ProtobufSchemaUtils.formatOptionMapOrListValue(ctx, list.get(0)));
            } else {
                sb.append("[\n");
                int lastIndex = list.size() - 1;
                for (int i = 0; i < list.size(); ++i) {
                    String endl = i != lastIndex ? "," : "";
                    String v = ProtobufSchemaUtils.formatOptionMapOrListValue(ctx, list.get(i)) + endl;
                    ProtobufSchemaUtils.appendIndented(sb, v);
                }
                sb.append("]");
            }
        } else if (value instanceof OptionElement.OptionPrimitive) {
            OptionElement.OptionPrimitive primitive = (OptionElement.OptionPrimitive)value;
            switch (primitive.getKind()) {
                case BOOLEAN: 
                case ENUM: {
                    sb.append(primitive.getValue());
                    break;
                }
                case NUMBER: {
                    sb.append(ProtobufSchemaUtils.formatNumber(ctx, primitive.getValue()));
                    break;
                }
                default: {
                    sb.append(ProtobufSchemaUtils.formatOptionMapOrListValue(ctx, primitive.getValue()));
                    break;
                }
            }
        } else if (value instanceof OptionElement) {
            sb.append(ProtobufSchemaUtils.toString(ctx, (OptionElement)value));
        } else {
            sb.append(value);
        }
        return sb.toString();
    }

    private static String toOptionString(FormatContext ctx, OptionElement option) {
        StringBuilder sb = new StringBuilder();
        sb.append("option ").append(ProtobufSchemaUtils.toString(ctx, option)).append(";\n");
        return sb.toString();
    }

    private static void appendOptions(FormatContext ctx, StringBuilder sb, List<?> options) {
        int count = options.size();
        if (count == 1) {
            sb.append('[').append(ProtobufSchemaUtils.formatOptionMapOrListValue(ctx, options.get(0))).append(']');
            return;
        }
        sb.append("[\n");
        for (int i = 0; i < count; ++i) {
            String endl = i < count - 1 ? "," : "";
            ProtobufSchemaUtils.appendIndented(sb, ProtobufSchemaUtils.formatOptionMapOrListValue(ctx, options.get(i)) + endl);
        }
        sb.append(']');
    }

    private static OptionElement.Kind toKind(ProtoType protoType) {
        switch (protoType.getSimpleName()) {
            case "bool": {
                return OptionElement.Kind.BOOLEAN;
            }
            case "string": {
                return OptionElement.Kind.STRING;
            }
            case "bytes": 
            case "double": 
            case "float": 
            case "fixed32": 
            case "fixed64": 
            case "int32": 
            case "int64": 
            case "sfixed32": 
            case "sfixed64": 
            case "sint32": 
            case "sint64": 
            case "uint32": 
            case "uint64": {
                return OptionElement.Kind.NUMBER;
            }
        }
        return OptionElement.Kind.ENUM;
    }

    private static void appendIndented(StringBuilder sb, String value) {
        List<String> lines = Arrays.asList(value.split("\n"));
        if (lines.size() > 1 && lines.get(lines.size() - 1).isEmpty()) {
            lines.remove(lines.size() - 1);
        }
        for (String line : lines) {
            sb.append("  ").append(line).append('\n');
        }
    }

    public static String escapeChars(String input) {
        StringBuilder buffer = new StringBuilder(input.length());
        block12: for (int i = 0; i < input.length(); ++i) {
            char curr = input.charAt(i);
            switch (curr) {
                case '\u0007': {
                    buffer.append("\\a");
                    continue block12;
                }
                case '\b': {
                    buffer.append("\\b");
                    continue block12;
                }
                case '\f': {
                    buffer.append("\\f");
                    continue block12;
                }
                case '\n': {
                    buffer.append("\\n");
                    continue block12;
                }
                case '\r': {
                    buffer.append("\\r");
                    continue block12;
                }
                case '\t': {
                    buffer.append("\\t");
                    continue block12;
                }
                case '\u000b': {
                    buffer.append("\\v");
                    continue block12;
                }
                case '\\': {
                    buffer.append("\\\\");
                    continue block12;
                }
                case '\'': {
                    buffer.append("\\'");
                    continue block12;
                }
                case '\"': {
                    buffer.append("\\\"");
                    continue block12;
                }
                default: {
                    buffer.append(curr);
                }
            }
        }
        return buffer.toString();
    }

    private static String formatNumber(FormatContext formatContext, Object value) {
        if (formatContext.normalize()) {
            try {
                Number num = value instanceof Number ? (Number)((Number)value) : (Number)formatContext.parseNumber(value.toString());
                value = formatContext.formatNumber(num);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return value.toString();
    }

    private static String resolve(Context ctx, String type) {
        String resolved = ctx.resolve(type, true);
        if (resolved == null) {
            throw new IllegalArgumentException("Could not resolve type: " + type);
        }
        return "." + resolved;
    }

    static {
        module.addDeserializer(ProtoFileElement.class, (JsonDeserializer)new ProtoFileElementDeserializer());
        mapperWithProtoFileDeserializer.registerModule((Module)module);
    }

    public static class FormatContext
    extends Context {
        private boolean ignoreExtensions;
        private boolean normalize;
        private NumberFormat numberFormat;

        public FormatContext(boolean ignoreExtensions, boolean normalize) {
            this.ignoreExtensions = ignoreExtensions;
            this.normalize = normalize;
        }

        public boolean ignoreExtensions() {
            return this.ignoreExtensions;
        }

        public boolean normalize() {
            return this.normalize;
        }

        public String formatNumber(Number number) {
            return this.numberFormat().format(number);
        }

        public Number parseNumber(String str) {
            return NumberUtils.createNumber((String)str);
        }

        private NumberFormat numberFormat() {
            if (this.numberFormat == null) {
                this.numberFormat = new DecimalFormat();
                this.numberFormat.setGroupingUsed(false);
            }
            return this.numberFormat;
        }

        public List<OptionElement> filterOptions(List<OptionElement> options) {
            if (options.isEmpty()) {
                return options;
            }
            if (this.ignoreExtensions) {
                options = options.stream().filter(o -> !o.isParenthesized() || o.getName().startsWith("confluent.")).collect(Collectors.toList());
            }
            if (this.normalize) {
                options = options.stream().map(o -> {
                    String resolved;
                    if (o.isParenthesized() && (resolved = this.resolve(this::getExtendFieldForFullName, o.getName(), true)) != null) {
                        return ProtobufSchema.transform(new OptionElement(resolved, o.getKind(), o.getValue(), o.isParenthesized()));
                    }
                    return o;
                }).sorted(Comparator.comparing(OptionElement::getName)).collect(Collectors.groupingBy(OptionElement::getName, LinkedHashMap::new, Collectors.toList())).entrySet().stream().flatMap(entry -> {
                    String name = (String)entry.getKey();
                    List list = (List)entry.getValue();
                    Context.ExtendFieldElementInfo fieldInfo = this.getExtendFieldForFullName(name, true);
                    if (fieldInfo != null && !fieldInfo.isRepeated() && list.size() > 0) {
                        return Stream.of(list.stream().reduce(ProtobufSchema::merge).get());
                    }
                    return list.stream();
                }).collect(Collectors.toList());
            }
            return options;
        }
    }
}

